--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: Common; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "Common";


ALTER SCHEMA "Common" OWNER TO openconcerto;

--
-- Name: SCHEMA "Common"; Type: COMMENT; Schema: -; Owner: openconcerto
--

COMMENT ON SCHEMA "Common" IS 'Standard public schema';


--
-- Name: Default; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "Default";


ALTER SCHEMA "Default" OWNER TO openconcerto;

--
-- Name: SCHEMA "Default"; Type: COMMENT; Schema: -; Owner: openconcerto
--

COMMENT ON SCHEMA "Default" IS 'Standard public schema';


--
-- Name: OpenConcerto42; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "OpenConcerto42";


ALTER SCHEMA "OpenConcerto42" OWNER TO openconcerto;

--
-- Name: OpenConcerto48; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "OpenConcerto48";


ALTER SCHEMA "OpenConcerto48" OWNER TO openconcerto;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: openconcerto
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO openconcerto;

SET search_path = "Common", pg_catalog;

--
-- Name: plpgsql_call_handler(); Type: FUNCTION; Schema: Common; Owner: openconcerto
--

CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
    LANGUAGE c
    AS '$libdir/plpgsql', 'plpgsql_call_handler';


ALTER FUNCTION "Common".plpgsql_call_handler() OWNER TO openconcerto;

--
-- Name: plpgsql_validator(oid); Type: FUNCTION; Schema: Common; Owner: openconcerto
--

CREATE FUNCTION plpgsql_validator(oid) RETURNS void
    LANGUAGE c
    AS '$libdir/plpgsql', 'plpgsql_validator';


ALTER FUNCTION "Common".plpgsql_validator(oid) OWNER TO openconcerto;

SET search_path = "Default", pg_catalog;

--
-- Name: next_ordret(); Type: FUNCTION; Schema: Default; Owner: openconcerto
--

CREATE FUNCTION next_ordret() RETURNS numeric
    LANGUAGE sql
    AS $$ UPDATE ordreT_generator set tmpVal = currentVal, currentVal = currentVal + inc ;SELECT tmpVal from ordreT_generator; $$;


ALTER FUNCTION "Default".next_ordret() OWNER TO openconcerto;

--
-- Name: reset_ordret(); Type: FUNCTION; Schema: Default; Owner: openconcerto
--

CREATE FUNCTION reset_ordret() RETURNS numeric
    LANGUAGE sql
    AS $$ update ordreT_generator set currentVal = minVal ;select currentVal from ordreT_generator; $$;


ALTER FUNCTION "Default".reset_ordret() OWNER TO openconcerto;

SET search_path = "Common", pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: ACCES_SOCIETE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ACCES_SOCIETE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON" integer DEFAULT 1,
    "ID_SOCIETE_COMMON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."ACCES_SOCIETE" OWNER TO openconcerto;

--
-- Name: ACCES_SOCIETE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "ACCES_SOCIETE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."ACCES_SOCIETE_ID_seq" OWNER TO openconcerto;

--
-- Name: ACCES_SOCIETE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "ACCES_SOCIETE_ID_seq" OWNED BY "ACCES_SOCIETE"."ID";


--
-- Name: ACCES_SOCIETE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"ACCES_SOCIETE_ID_seq"', 1, true);


--
-- Name: ADRESSE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ADRESSE_COMMON" (
    "ID" integer NOT NULL,
    "RUE" character varying(2048) DEFAULT ''::text NOT NULL,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PAYS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VILLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CEDEX" integer,
    "HAS_CEDEX" boolean DEFAULT false
);


ALTER TABLE "Common"."ADRESSE_COMMON" OWNER TO openconcerto;

--
-- Name: ADRESSE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "ADRESSE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."ADRESSE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- Name: ADRESSE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "ADRESSE_COMMON_ID_seq" OWNED BY "ADRESSE_COMMON"."ID";


--
-- Name: ADRESSE_COMMON_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"ADRESSE_COMMON_ID_seq"', 61, true);


--
-- Name: BANQUE_POLE_PRODUIT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BANQUE_POLE_PRODUIT" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "NUMERO_RUE" character varying(2048) DEFAULT ''::text,
    "VOIE" character varying(2048) DEFAULT ''::text,
    "RUE" character varying(2048) DEFAULT ''::text,
    "CODE_POSTAL" character varying(2048) DEFAULT ''::text,
    "VILLE" character varying(2048) DEFAULT ''::text,
    "CODE_ETS" character varying(2048) DEFAULT ''::text,
    "CODE_GUICHET" character varying(2048) DEFAULT ''::text,
    "NUMERO_COMPTE" character varying(2048) DEFAULT ''::text,
    "CLE_RICE" character varying(2048) DEFAULT ''::text,
    "DOMICILIATION" character varying(2048) DEFAULT ''::text,
    "BIC" character varying(2048) DEFAULT ''::text,
    "IBAN" character varying(2048) DEFAULT ''::text,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_POLE_PRODUIT" integer DEFAULT 1
);


ALTER TABLE "Common"."BANQUE_POLE_PRODUIT" OWNER TO openconcerto;

--
-- Name: BANQUE_POLE_PRODUIT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "BANQUE_POLE_PRODUIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."BANQUE_POLE_PRODUIT_ID_seq" OWNER TO openconcerto;

--
-- Name: BANQUE_POLE_PRODUIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "BANQUE_POLE_PRODUIT_ID_seq" OWNED BY "BANQUE_POLE_PRODUIT"."ID";


--
-- Name: BANQUE_POLE_PRODUIT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"BANQUE_POLE_PRODUIT_ID_seq"', 1, true);


--
-- Name: CAISSE_COTISATION; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CAISSE_COTISATION" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE_COMMON" integer DEFAULT 1 NOT NULL,
    "TEL" character varying(32) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PORTABLE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."CAISSE_COTISATION" OWNER TO openconcerto;

--
-- Name: CAISSE_COTISATION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "CAISSE_COTISATION_ID_seq"
    START WITH 9
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."CAISSE_COTISATION_ID_seq" OWNER TO openconcerto;

--
-- Name: CAISSE_COTISATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "CAISSE_COTISATION_ID_seq" OWNED BY "CAISSE_COTISATION"."ID";


--
-- Name: CAISSE_COTISATION_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"CAISSE_COTISATION_ID_seq"', 9, false);


--
-- Name: COMPLETION; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPLETION" (
    "CHAMP" character varying(256) DEFAULT ''::character varying NOT NULL,
    "LABEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."COMPLETION" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_DEFAULT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPTE_PCE_DEFAULT" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUMERO_DEFAULT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."COMPTE_PCE_DEFAULT" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_DEFAULT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "COMPTE_PCE_DEFAULT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."COMPTE_PCE_DEFAULT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_DEFAULT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "COMPTE_PCE_DEFAULT_ID_seq" OWNED BY "COMPTE_PCE_DEFAULT"."ID";


--
-- Name: COMPTE_PCE_DEFAULT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMPTE_PCE_DEFAULT_ID_seq"', 28, true);


--
-- Name: CONNEXION; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONNEXION" (
    "LOGIN" character varying(45),
    "MDP" character varying(2048),
    "DATE" timestamp with time zone,
    "IP" character varying(2048),
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "FAILED" boolean DEFAULT false
);


ALTER TABLE "Common"."CONNEXION" OWNER TO openconcerto;

--
-- Name: CONNEXION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "CONNEXION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."CONNEXION_ID_seq" OWNER TO openconcerto;

--
-- Name: CONNEXION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "CONNEXION_ID_seq" OWNED BY "CONNEXION"."ID";


--
-- Name: CONNEXION_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONNEXION_ID_seq"', 3442, true);


--
-- Name: DEVISE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEVISE" (
    "ID" integer NOT NULL,
    "CODE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "LIBELLE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "LIBELLE_CENT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TAUX" numeric(16,8) DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."DEVISE" OWNER TO openconcerto;

--
-- Name: DEVISE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "DEVISE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."DEVISE_ID_seq" OWNER TO openconcerto;

--
-- Name: DEVISE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "DEVISE_ID_seq" OWNED BY "DEVISE"."ID";


--
-- Name: DEVISE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEVISE_ID_seq"', 1, true);


--
-- Name: DOMAINE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DOMAINE" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CONDITION" character varying(2048) DEFAULT ''::text,
    "Q18" boolean DEFAULT false,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "Common"."DOMAINE" OWNER TO openconcerto;

--
-- Name: DOMAINE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "DOMAINE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."DOMAINE_ID_seq" OWNER TO openconcerto;

--
-- Name: DOMAINE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "DOMAINE_ID_seq" OWNED BY "DOMAINE"."ID";


--
-- Name: DOMAINE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"DOMAINE_ID_seq"', 1, true);


--
-- Name: ECHANTILLON; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHANTILLON" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PV_HT" bigint DEFAULT 0,
    "PV_TTC" bigint DEFAULT 0
);


ALTER TABLE "Common"."ECHANTILLON" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "ECHANTILLON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."ECHANTILLON_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "ECHANTILLON_ID_seq" OWNED BY "ECHANTILLON"."ID";


--
-- Name: ECHANTILLON_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHANTILLON_ID_seq"', 1, true);


--
-- Name: EXERCICE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "EXERCICE_COMMON" (
    "ID" integer NOT NULL,
    "DATE_DEB" date,
    "DATE_FIN" date,
    "NUMERO" integer DEFAULT 1 NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE_CLOTURE" date,
    "ID_SOCIETE_COMMON" integer DEFAULT 1
);


ALTER TABLE "Common"."EXERCICE_COMMON" OWNER TO openconcerto;

--
-- Name: EXERCICE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "EXERCICE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."EXERCICE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- Name: EXERCICE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "EXERCICE_COMMON_ID_seq" OWNED BY "EXERCICE_COMMON"."ID";


--
-- Name: EXERCICE_COMMON_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"EXERCICE_COMMON_ID_seq"', 60, true);


--
-- Name: FWK_RIV_METADATA; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_RIV_METADATA" (
    "ID" integer NOT NULL,
    "ELEMENT_CODE" character varying(80),
    "COMPONENT_CODE" character varying(80),
    "ITEM" character varying(80) NOT NULL,
    "LABEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "COLUMN_TITLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DOCUMENTATION" character varying(8192) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."FWK_RIV_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_RIV_METADATA_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "FWK_RIV_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."FWK_RIV_METADATA_ID_seq" OWNER TO openconcerto;

--
-- Name: FWK_RIV_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "FWK_RIV_METADATA_ID_seq" OWNED BY "FWK_RIV_METADATA"."ID";


--
-- Name: FWK_RIV_METADATA_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"FWK_RIV_METADATA_ID_seq"', 1, false);


--
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_UNDEFINED_IDS" (
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL,
    "UNDEFINED_ID" integer
);


ALTER TABLE "Common"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- Name: IMPRESSION_RUBRIQUE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "IMPRESSION_RUBRIQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."IMPRESSION_RUBRIQUE" OWNER TO openconcerto;

--
-- Name: IMPRESSION_RUBRIQUE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "IMPRESSION_RUBRIQUE_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."IMPRESSION_RUBRIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: IMPRESSION_RUBRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "IMPRESSION_RUBRIQUE_ID_seq" OWNED BY "IMPRESSION_RUBRIQUE"."ID";


--
-- Name: IMPRESSION_RUBRIQUE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"IMPRESSION_RUBRIQUE_ID_seq"', 5, false);


--
-- Name: INDICE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "INDICE" (
    "ANNEE" integer,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "JANVIER" bigint DEFAULT 0,
    "FEVRIER" bigint DEFAULT 0,
    "MARS" bigint DEFAULT 0,
    "AVRIL" bigint DEFAULT 0,
    "MAI" bigint DEFAULT 0,
    "JUIN" bigint DEFAULT 0,
    "JUILLET" bigint DEFAULT 0,
    "AOUT" bigint DEFAULT 0,
    "SEPTEMBRE" bigint DEFAULT 0,
    "OCTOBRE" bigint DEFAULT 0,
    "NOVEMBRE" bigint DEFAULT 0,
    "DECEMBRE" bigint DEFAULT 0
);


ALTER TABLE "Common"."INDICE" OWNER TO openconcerto;

--
-- Name: INDICE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "INDICE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."INDICE_ID_seq" OWNER TO openconcerto;

--
-- Name: INDICE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "INDICE_ID_seq" OWNED BY "INDICE"."ID";


--
-- Name: INDICE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"INDICE_ID_seq"', 6, true);


--
-- Name: OBJET; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "OBJET" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_DOMAINE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."OBJET" OWNER TO openconcerto;

--
-- Name: OBJET_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "OBJET_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."OBJET_ID_seq" OWNER TO openconcerto;

--
-- Name: OBJET_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "OBJET_ID_seq" OWNED BY "OBJET"."ID";


--
-- Name: OBJET_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"OBJET_ID_seq"', 1, true);


--
-- Name: PERIODE_VALIDITE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PERIODE_VALIDITE" (
    "ID" integer NOT NULL,
    "JANVIER" boolean DEFAULT true NOT NULL,
    "FEVRIER" boolean DEFAULT true NOT NULL,
    "MARS" boolean DEFAULT true NOT NULL,
    "AVRIL" boolean DEFAULT true NOT NULL,
    "MAI" boolean DEFAULT true NOT NULL,
    "JUIN" boolean DEFAULT true NOT NULL,
    "JUILLET" boolean DEFAULT true NOT NULL,
    "AOUT" boolean DEFAULT true NOT NULL,
    "SEPTEMBRE" boolean DEFAULT true NOT NULL,
    "OCTOBRE" boolean DEFAULT true NOT NULL,
    "NOVEMBRE" boolean DEFAULT true NOT NULL,
    "DECEMBRE" boolean DEFAULT true NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."PERIODE_VALIDITE" OWNER TO openconcerto;

--
-- Name: PERIODE_VALIDITE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "PERIODE_VALIDITE_ID_seq"
    START WITH 95
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."PERIODE_VALIDITE_ID_seq" OWNER TO openconcerto;

--
-- Name: PERIODE_VALIDITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "PERIODE_VALIDITE_ID_seq" OWNED BY "PERIODE_VALIDITE"."ID";


--
-- Name: PERIODE_VALIDITE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"PERIODE_VALIDITE_ID_seq"', 95, false);


--
-- Name: POLE_PRODUIT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "POLE_PRODUIT" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM_DIRECTEUR" character varying(2048) DEFAULT ''::text,
    "NOM_SECRETAIRE" character varying(2048) DEFAULT ''::text,
    "TEL" character varying(22) DEFAULT ''::character varying,
    "FAX" character varying(22) DEFAULT ''::character varying,
    "MAIL" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE_COMMON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL
);


ALTER TABLE "Common"."POLE_PRODUIT" OWNER TO openconcerto;

--
-- Name: POLE_PRODUIT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "POLE_PRODUIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."POLE_PRODUIT_ID_seq" OWNER TO openconcerto;

--
-- Name: POLE_PRODUIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "POLE_PRODUIT_ID_seq" OWNED BY "POLE_PRODUIT"."ID";


--
-- Name: POLE_PRODUIT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"POLE_PRODUIT_ID_seq"', 1, true);


--
-- Name: PREF_NODE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREF_NODE" (
    "ID" integer NOT NULL,
    "ID_PARENT" integer,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."PREF_NODE" OWNER TO openconcerto;

--
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "PREF_NODE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."PREF_NODE_ID_seq" OWNER TO openconcerto;

--
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "PREF_NODE_ID_seq" OWNED BY "PREF_NODE"."ID";


--
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREF_NODE_ID_seq"', 1, false);


--
-- Name: PREF_VALUE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREF_VALUE" (
    "ID_NODE" integer NOT NULL,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(8192) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."PREF_VALUE" OWNER TO openconcerto;

--
-- Name: PROFIL_PAYE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PROFIL_PAYE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."PROFIL_PAYE" OWNER TO openconcerto;

--
-- Name: PROFIL_PAYE_ELEMENT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PROFIL_PAYE_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_PROFIL_PAYE" integer DEFAULT 1 NOT NULL,
    "SOURCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1 NOT NULL,
    "POSITION" integer DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."PROFIL_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- Name: PROFIL_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "PROFIL_PAYE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."PROFIL_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: PROFIL_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "PROFIL_PAYE_ELEMENT_ID_seq" OWNED BY "PROFIL_PAYE_ELEMENT"."ID";


--
-- Name: PROFIL_PAYE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"PROFIL_PAYE_ELEMENT_ID_seq"', 168, true);


--
-- Name: PROFIL_PAYE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "PROFIL_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."PROFIL_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: PROFIL_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "PROFIL_PAYE_ID_seq" OWNED BY "PROFIL_PAYE"."ID";


--
-- Name: PROFIL_PAYE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"PROFIL_PAYE_ID_seq"', 9, true);


--
-- Name: RIGHT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RIGHT" (
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CODE" character varying(128) DEFAULT ''::character varying,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "DESCRIPTION" character varying(500) DEFAULT ''::character varying
);


ALTER TABLE "Common"."RIGHT" OWNER TO openconcerto;

--
-- Name: RIGHT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "RIGHT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."RIGHT_ID_seq" OWNER TO openconcerto;

--
-- Name: RIGHT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "RIGHT_ID_seq" OWNED BY "RIGHT"."ID";


--
-- Name: RIGHT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"RIGHT_ID_seq"', 16, true);


--
-- Name: RUBRIQUE_BRUT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RUBRIQUE_BRUT" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT" character varying(2048) DEFAULT ''::text NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_TYPE_RUBRIQUE_BRUT" integer DEFAULT 1 NOT NULL,
    "IMPOSABLE" boolean DEFAULT false NOT NULL,
    "PART_BRUT" boolean DEFAULT false NOT NULL,
    "PART_CP" boolean DEFAULT false NOT NULL,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Common"."RUBRIQUE_BRUT" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "RUBRIQUE_BRUT_ID_seq"
    START WITH 42
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_BRUT_ID_seq" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "RUBRIQUE_BRUT_ID_seq" OWNED BY "RUBRIQUE_BRUT"."ID";


--
-- Name: RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"RUBRIQUE_BRUT_ID_seq"', 42, false);


--
-- Name: RUBRIQUE_COMM; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RUBRIQUE_COMM" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NB_BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX_SAL" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX_PAT" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT_SAL_AJ" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT_SAL_DED" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT_PAT" character varying(2048) DEFAULT ''::text NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL,
    "NOM_VISIBLE" boolean DEFAULT true NOT NULL,
    "MONTANT" real DEFAULT 0 NOT NULL
);


ALTER TABLE "Common"."RUBRIQUE_COMM" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_COMM_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "RUBRIQUE_COMM_ID_seq"
    START WITH 10
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_COMM_ID_seq" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_COMM_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "RUBRIQUE_COMM_ID_seq" OWNED BY "RUBRIQUE_COMM"."ID";


--
-- Name: RUBRIQUE_COMM_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"RUBRIQUE_COMM_ID_seq"', 10, false);


--
-- Name: RUBRIQUE_COTISATION; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RUBRIQUE_COTISATION" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CAISSE_COTISATION" integer DEFAULT 1 NOT NULL,
    "BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TX_SAL" character varying(2048) DEFAULT ''::text NOT NULL,
    "TX_PAT" character varying(2048) DEFAULT ''::text NOT NULL,
    "IMPOSABLE" boolean DEFAULT false NOT NULL,
    "PART_CSG" boolean DEFAULT false NOT NULL,
    "BRUT" boolean DEFAULT false NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Common"."RUBRIQUE_COTISATION" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_COTISATION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "RUBRIQUE_COTISATION_ID_seq"
    START WITH 43
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_COTISATION_ID_seq" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_COTISATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "RUBRIQUE_COTISATION_ID_seq" OWNED BY "RUBRIQUE_COTISATION"."ID";


--
-- Name: RUBRIQUE_COTISATION_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"RUBRIQUE_COTISATION_ID_seq"', 43, false);


--
-- Name: RUBRIQUE_NET; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RUBRIQUE_NET" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT" character varying(2048) DEFAULT ''::text NOT NULL,
    "IMPOSABLE" boolean DEFAULT false NOT NULL,
    "FRAIS_PERS" boolean DEFAULT false NOT NULL,
    "BRUT" boolean DEFAULT false NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ID_TYPE_RUBRIQUE_NET" integer DEFAULT 1 NOT NULL,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "Common"."RUBRIQUE_NET" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_NET_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "RUBRIQUE_NET_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_NET_ID_seq" OWNER TO openconcerto;

--
-- Name: RUBRIQUE_NET_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "RUBRIQUE_NET_ID_seq" OWNED BY "RUBRIQUE_NET"."ID";


--
-- Name: RUBRIQUE_NET_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"RUBRIQUE_NET_ID_seq"', 6, false);


--
-- Name: SERVICE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SERVICE" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."SERVICE" OWNER TO openconcerto;

--
-- Name: SERVICE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "SERVICE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."SERVICE_ID_seq" OWNER TO openconcerto;

--
-- Name: SERVICE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "SERVICE_ID_seq" OWNED BY "SERVICE"."ID";


--
-- Name: SERVICE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"SERVICE_ID_seq"', 1, true);


--
-- Name: SOCIETE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SOCIETE_COMMON" (
    "ID" integer NOT NULL,
    "DATABASE_NAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUM_SIRET" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUM_NII" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUM_APE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_EXERCICE_COMMON" integer DEFAULT 1 NOT NULL,
    "NUM_TEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUM_FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE_COMMON" integer DEFAULT 1 NOT NULL,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "NUMERO_URSSAF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "RCS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CAPITAL" bigint DEFAULT 0
);


ALTER TABLE "Common"."SOCIETE_COMMON" OWNER TO openconcerto;

--
-- Name: SOCIETE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "SOCIETE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."SOCIETE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- Name: SOCIETE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "SOCIETE_COMMON_ID_seq" OWNED BY "SOCIETE_COMMON"."ID";


--
-- Name: SOCIETE_COMMON_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"SOCIETE_COMMON_ID_seq"', 48, true);


--
-- Name: STOCK; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "STOCK" (
    "ID" integer NOT NULL,
    "QTE_REEL" real DEFAULT 0 NOT NULL,
    "QTE_TH" real DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."STOCK" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "STOCK_ID_seq" OWNED BY "STOCK"."ID";


--
-- Name: STOCK_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"STOCK_ID_seq"', 1, true);


--
-- Name: TACHE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TACHE_COMMON" (
    "ID" integer NOT NULL,
    "PRIORITE" integer DEFAULT 0 NOT NULL,
    "FAIT" boolean DEFAULT false NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text NOT NULL,
    "DATE_ENTREE" timestamp without time zone,
    "DATE_FAIT" timestamp without time zone,
    "DATE_EXP" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1 NOT NULL,
    "ID_USER_COMMON_TO" integer DEFAULT 1 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "COMMENT" character varying(2048),
    "ID_USER_COMMON_ASSIGN_BY" integer DEFAULT 1,
    "ID_SOCIETE_COMMON" integer DEFAULT 1,
    "TYPE" character varying(128) DEFAULT ''::character varying,
    "COOKIE" character varying(128) DEFAULT ''::character varying
);


ALTER TABLE "Common"."TACHE_COMMON" OWNER TO openconcerto;

--
-- Name: TACHE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "TACHE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."TACHE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- Name: TACHE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "TACHE_COMMON_ID_seq" OWNED BY "TACHE_COMMON"."ID";


--
-- Name: TACHE_COMMON_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"TACHE_COMMON_ID_seq"', 704, true);


--
-- Name: TACHE_LISTENER_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TACHE_LISTENER_COMMON" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON" integer DEFAULT 1 NOT NULL,
    "ID_USER_COMMON_LISTENTO" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."TACHE_LISTENER_COMMON" OWNER TO openconcerto;

--
-- Name: TACHE_LISTENER_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "TACHE_LISTENER_COMMON_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."TACHE_LISTENER_COMMON_ID_seq" OWNER TO openconcerto;

--
-- Name: TACHE_LISTENER_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "TACHE_LISTENER_COMMON_ID_seq" OWNED BY "TACHE_LISTENER_COMMON"."ID";


--
-- Name: TACHE_LISTENER_COMMON_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"TACHE_LISTENER_COMMON_ID_seq"', 4, false);


--
-- Name: TACHE_RIGHTS; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TACHE_RIGHTS" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON" integer DEFAULT 1 NOT NULL,
    "ID_USER_COMMON_TO" integer DEFAULT 1 NOT NULL,
    "READ" boolean DEFAULT false NOT NULL,
    "MODIFY" boolean DEFAULT false NOT NULL,
    "ADD" boolean DEFAULT false NOT NULL,
    "VALIDATE" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "Common"."TACHE_RIGHTS" OWNER TO openconcerto;

--
-- Name: TACHE_RIGHTS_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "TACHE_RIGHTS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."TACHE_RIGHTS_ID_seq" OWNER TO openconcerto;

--
-- Name: TACHE_RIGHTS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "TACHE_RIGHTS_ID_seq" OWNED BY "TACHE_RIGHTS"."ID";


--
-- Name: TACHE_RIGHTS_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"TACHE_RIGHTS_ID_seq"', 34, true);


--
-- Name: TYPE_MODELE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DEFAULT_MODELE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."TYPE_MODELE" OWNER TO openconcerto;

--
-- Name: TYPE_MODELE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_MODELE_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_MODELE_ID_seq" OWNED BY "TYPE_MODELE"."ID";


--
-- Name: TYPE_MODELE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_MODELE_ID_seq"', 6, true);


--
-- Name: TYPE_RUBRIQUE_BRUT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_RUBRIQUE_BRUT" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Common"."TYPE_RUBRIQUE_BRUT" OWNER TO openconcerto;

--
-- Name: TYPE_RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_RUBRIQUE_BRUT_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_RUBRIQUE_BRUT_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_RUBRIQUE_BRUT_ID_seq" OWNED BY "TYPE_RUBRIQUE_BRUT"."ID";


--
-- Name: TYPE_RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_RUBRIQUE_BRUT_ID_seq"', 6, false);


--
-- Name: TYPE_RUBRIQUE_NET; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_RUBRIQUE_NET" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."TYPE_RUBRIQUE_NET" OWNER TO openconcerto;

--
-- Name: TYPE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_RUBRIQUE_NET_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_RUBRIQUE_NET_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_RUBRIQUE_NET_ID_seq" OWNED BY "TYPE_RUBRIQUE_NET"."ID";


--
-- Name: TYPE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_RUBRIQUE_NET_ID_seq"', 5, false);


--
-- Name: USER_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "USER_COMMON" (
    "ID" integer NOT NULL,
    "LOGIN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PASSWORD" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SURNOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "SUPERUSER" boolean DEFAULT false,
    "ADMIN" boolean DEFAULT false,
    "MAIL" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "Common"."USER_COMMON" OWNER TO openconcerto;

--
-- Name: USER_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "USER_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."USER_COMMON_ID_seq" OWNER TO openconcerto;

--
-- Name: USER_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "USER_COMMON_ID_seq" OWNED BY "USER_COMMON"."ID";


--
-- Name: USER_COMMON_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"USER_COMMON_ID_seq"', 15, true);


--
-- Name: USER_RIGHT; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "USER_RIGHT" (
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON" integer DEFAULT 1,
    "HAVE_RIGHT" boolean,
    "CODE" character varying(128) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "DESCRIPTION" character varying(500) DEFAULT ''::character varying,
    "ID_RIGHT" integer DEFAULT 1,
    "OBJECT" character varying(256)
);


ALTER TABLE "Common"."USER_RIGHT" OWNER TO openconcerto;

--
-- Name: USER_RIGHT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "USER_RIGHT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."USER_RIGHT_ID_seq" OWNER TO openconcerto;

--
-- Name: USER_RIGHT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "USER_RIGHT_ID_seq" OWNED BY "USER_RIGHT"."ID";


--
-- Name: USER_RIGHT_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"USER_RIGHT_ID_seq"', 19, true);


--
-- Name: VARIABLE_PAYE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "VARIABLE_PAYE" (
    "ID" integer NOT NULL,
    "VALEUR" real DEFAULT 0 NOT NULL,
    "FORMULE" character varying(2048) DEFAULT ''::text NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CATEGORIE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::text NOT NULL
);


ALTER TABLE "Common"."VARIABLE_PAYE" OWNER TO openconcerto;

--
-- Name: VARIABLE_PAYE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "VARIABLE_PAYE_ID_seq"
    START WITH 51
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."VARIABLE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: VARIABLE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "VARIABLE_PAYE_ID_seq" OWNED BY "VARIABLE_PAYE"."ID";


--
-- Name: VARIABLE_PAYE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"VARIABLE_PAYE_ID_seq"', 51, false);


--
-- Name: VILLE; Type: TABLE; Schema: Common; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "VILLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048),
    "CODE_POSTAL" character varying(2048),
    "X_LAMBERT" bigint DEFAULT 0,
    "Y_LAMBERT" bigint DEFAULT 0,
    "POPULATION" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."VILLE" OWNER TO openconcerto;

--
-- Name: VILLE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "VILLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Common"."VILLE_ID_seq" OWNER TO openconcerto;

--
-- Name: VILLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "VILLE_ID_seq" OWNED BY "VILLE"."ID";


--
-- Name: VILLE_ID_seq; Type: SEQUENCE SET; Schema: Common; Owner: openconcerto
--

SELECT pg_catalog.setval('"VILLE_ID_seq"', 117, true);


SET search_path = "Default", pg_catalog;

--
-- Name: ACOMPTE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ACOMPTE" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "MONTANT" real DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ACOMPTE" OWNER TO openconcerto;

--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ACOMPTE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ACOMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ACOMPTE_ID_seq" OWNED BY "ACOMPTE"."ID";


--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ACOMPTE_ID_seq"', 2, false);


--
-- Name: ADRESSE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ADRESSE" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_ADRESSE" integer NOT NULL,
    "RUE" character varying(2048) DEFAULT ''::text,
    "CODE_POSTAL" integer DEFAULT 0,
    "PAYS" character varying(100) DEFAULT ''::character varying,
    "VILLE" character varying(2048) DEFAULT ''::text,
    "HAS_CEDEX" boolean DEFAULT false,
    "CEDEX" integer,
    "DEST" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1
);


ALTER TABLE "Default"."ADRESSE" OWNER TO openconcerto;

--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ADRESSE_ID_ADRESSE_seq"
    START WITH 9
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ADRESSE_ID_ADRESSE_seq" OWNER TO openconcerto;

--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ADRESSE_ID_ADRESSE_seq" OWNED BY "ADRESSE"."ID_ADRESSE";


--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ADRESSE_ID_ADRESSE_seq"', 9, false);


--
-- Name: ARTICLE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PA_HT" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CREATION_AUTO" boolean DEFAULT false,
    "PV_TTC" bigint DEFAULT 0,
    "ID_STOCK" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "GESTION_STOCK" boolean DEFAULT true,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE_MIN" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_PAYS" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2
);


ALTER TABLE "Default"."ARTICLE" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE_DESIGNATION" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."ARTICLE_DESIGNATION" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_DESIGNATION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_DESIGNATION_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_DESIGNATION_ID_seq" OWNED BY "ARTICLE_DESIGNATION"."ID";


--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_DESIGNATION_ID_seq"', 1, true);


--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_ID_seq" OWNED BY "ARTICLE"."ID";


--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_ID_seq"', 2, false);


--
-- Name: ARTICLE_TARIF; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE_TARIF" (
    "ID" integer NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_TARIF" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."ARTICLE_TARIF" OWNER TO openconcerto;

--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_TARIF_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_TARIF_ID_seq" OWNED BY "ARTICLE_TARIF"."ID";


--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_TARIF_ID_seq"', 1, true);


--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ASSOCIATION_COMPTE_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ASSOCIATION_COMPTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNED BY "ASSOCIATION_COMPTE_ANALYTIQUE"."ID";


--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: AVOIR_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "DATE" date,
    "MONTANT_TTC" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "SOLDE" boolean DEFAULT false,
    "A_DEDUIRE" boolean DEFAULT false,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "DATE_ENVOI_AFFACTURAGE" date,
    "AFFACTURAGE" boolean DEFAULT false,
    "MONTANT_SOLDE" bigint DEFAULT 0,
    "MONTANT_RESTANT" bigint DEFAULT 0,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "ID_CONTACT" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "MOTIF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "AFFACTURE" boolean DEFAULT false,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "Default"."AVOIR_CLIENT" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_CLIENT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PA_HT" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "QTE" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "TARIF_Q18_HT" bigint DEFAULT 0,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "Q18" boolean DEFAULT false,
    "ID_CONTACT" integer DEFAULT 1,
    "INDICE_0" bigint DEFAULT 0,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "INDICE_N" bigint DEFAULT 0,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "MONTANT_INITIAL" bigint DEFAULT 0,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "DATE_FIN" timestamp without time zone,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "DATE" timestamp without time zone,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0 NOT NULL,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."AVOIR_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_CLIENT_ELEMENT_ID_seq" OWNED BY "AVOIR_CLIENT_ELEMENT"."ID";


--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_CLIENT_ELEMENT_ID_seq"', 1, true);


--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_CLIENT_ID_seq" OWNED BY "AVOIR_CLIENT"."ID";


--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_CLIENT_ID_seq"', 2, false);


--
-- Name: AVOIR_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE" date,
    "SOLDE" boolean DEFAULT false,
    "A_DEDUIRE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "MONTANT_TTC" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "IMMO" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."AVOIR_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."AVOIR_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_FOURNISSEUR_ID_seq" OWNED BY "AVOIR_FOURNISSEUR"."ID";


--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_FOURNISSEUR_ID_seq"', 1, true);


--
-- Name: AXE_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AXE_ANALYTIQUE" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."AXE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "AXE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."AXE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "AXE_ANALYTIQUE_ID_seq" OWNED BY "AXE_ANALYTIQUE"."ID";


--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"AXE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: BON_DE_LIVRAISON; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_DE_LIVRAISON" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "DATE" date,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TOTAL_HT" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_POIDS" real DEFAULT 0,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "SOURCE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_LIVRAISON" date
);


ALTER TABLE "Default"."BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_DE_LIVRAISON_ELEMENT" (
    "ID_SAISIE_VENTE_FACTURE_ELEMENT" integer DEFAULT 1,
    "QTE_A_LIVRER" integer DEFAULT 0,
    "QTE_LIVREE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PV_HT" bigint DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "ID_STYLE" integer DEFAULT 1,
    "T_POIDS_LIVREE" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."BON_DE_LIVRAISON_ELEMENT" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "BON_DE_LIVRAISON_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNED BY "BON_DE_LIVRAISON_ELEMENT"."ID";


--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_DE_LIVRAISON_ELEMENT_ID_seq"', 2, false);


--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "BON_DE_LIVRAISON_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "BON_DE_LIVRAISON_ID_seq" OWNED BY "BON_DE_LIVRAISON"."ID";


--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_DE_LIVRAISON_ID_seq"', 2, false);


--
-- Name: BON_RECEPTION; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_RECEPTION" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TOTAL_HT" bigint DEFAULT 0,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "TOTAL_POIDS" real DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_COMMANDE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0
);


ALTER TABLE "Default"."BON_RECEPTION" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_RECEPTION_ELEMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "QTE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "ID_STYLE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "T_PA_TTC" bigint DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."BON_RECEPTION_ELEMENT" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "BON_RECEPTION_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_RECEPTION_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "BON_RECEPTION_ELEMENT_ID_seq" OWNED BY "BON_RECEPTION_ELEMENT"."ID";


--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_RECEPTION_ELEMENT_ID_seq"', 1, true);


--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "BON_RECEPTION_ID_seq" OWNED BY "BON_RECEPTION"."ID";


--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_RECEPTION_ID_seq"', 1, true);


--
-- Name: CAISSE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CAISSE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL
);


ALTER TABLE "Default"."CAISSE" OWNER TO openconcerto;

--
-- Name: CAISSE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CAISSE_ID_seq" OWNER TO openconcerto;

--
-- Name: CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CAISSE_ID_seq" OWNED BY "CAISSE"."ID";


--
-- Name: CAISSE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CAISSE_ID_seq"', 2, false);


--
-- Name: CHEQUE_AVOIR_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_AVOIR_CLIENT" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DECAISSE" boolean DEFAULT false NOT NULL,
    "ID_MOUVEMENT" integer DEFAULT 1 NOT NULL,
    "DATE_AVOIR" date,
    "DATE_MIN_DECAISSE" date,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE_DECAISSE" date,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "Default"."CHEQUE_AVOIR_CLIENT" OWNER TO openconcerto;

--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_AVOIR_CLIENT_ID_seq" OWNED BY "CHEQUE_AVOIR_CLIENT"."ID";


--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_AVOIR_CLIENT_ID_seq"', 1, true);


--
-- Name: CHEQUE_A_ENCAISSER; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_A_ENCAISSER" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ENCAISSE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "DATE_MIN_DEPOT" date,
    "DATE_VENTE" date,
    "DATE_DEPOT" date,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "Default"."CHEQUE_A_ENCAISSER" OWNER TO openconcerto;

--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_A_ENCAISSER_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CHEQUE_A_ENCAISSER_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_A_ENCAISSER_ID_seq" OWNED BY "CHEQUE_A_ENCAISSER"."ID";


--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_A_ENCAISSER_ID_seq"', 2, false);


--
-- Name: CHEQUE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_FOURNISSEUR" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "DECAISSE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE_ACHAT" date,
    "DATE_MIN_DECAISSE" date,
    "DATE_DECAISSE" date,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "Default"."CHEQUE_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CHEQUE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_FOURNISSEUR_ID_seq" OWNED BY "CHEQUE_FOURNISSEUR"."ID";


--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_FOURNISSEUR_ID_seq"', 2, false);


--
-- Name: CLASSEMENT_CONVENTIONNEL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLASSEMENT_CONVENTIONNEL" (
    "ID" integer NOT NULL,
    "NIVEAU" character varying(45) DEFAULT ''::character varying,
    "COEFF" character varying(45) DEFAULT ''::character varying,
    "INDICE" character varying(45) DEFAULT ''::character varying,
    "POSITION" character varying(45) DEFAULT ''::character varying,
    "ECHELON" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CLASSEMENT_CONVENTIONNEL" OWNER TO openconcerto;

--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CLASSEMENT_CONVENTIONNEL_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNER TO openconcerto;

--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CLASSEMENT_CONVENTIONNEL_ID_seq" OWNED BY "CLASSEMENT_CONVENTIONNEL"."ID";


--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLASSEMENT_CONVENTIONNEL_ID_seq"', 2, false);


--
-- Name: CLASSE_COMPTE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLASSE_COMPTE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TYPE_NUMERO_COMPTE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CLASSE_COMPTE" OWNER TO openconcerto;

--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CLASSE_COMPTE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CLASSE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CLASSE_COMPTE_ID_seq" OWNED BY "CLASSE_COMPTE"."ID";


--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLASSE_COMPTE_ID_seq"', 12, false);


--
-- Name: CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLIENT" (
    "ID" integer NOT NULL,
    "FORME_JURIDIQUE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "TEL" character varying(100) DEFAULT ''::character varying,
    "MAIL" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "NUMERO_TVA" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "RESPONSABLE" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE_L" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TEL_P" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_P_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_TECH" character varying(100) DEFAULT ''::character varying,
    "MAIL_TECH" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_P_COM" character varying(100) DEFAULT ''::character varying,
    "MAIL_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_COM" character varying(100) DEFAULT ''::character varying,
    "ID_MODE_REGLEMENT" integer DEFAULT 1 NOT NULL,
    "ID_ADRESSE_F" integer DEFAULT 1,
    "FAX_TECH" character varying(100) DEFAULT ''::character varying,
    "FAX_COM" character varying(100) DEFAULT ''::character varying,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "SIRET" character varying(2048) DEFAULT ''::text,
    "RIB" character varying(2048) DEFAULT ''::text,
    "MARCHE_PUBLIC" boolean DEFAULT false,
    "MARCHE_PRIVE" boolean DEFAULT false,
    "AFFACTURAGE" boolean DEFAULT false,
    "MAX_FACTURE" bigint DEFAULT 0,
    "COMPTANT" boolean DEFAULT false,
    "COMPTE_CLIENT_AUTO" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_TARIF" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1
);


ALTER TABLE "Default"."CLIENT" OWNER TO openconcerto;

--
-- Name: CLIENT_ID_CLIENT_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CLIENT_ID_CLIENT_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CLIENT_ID_CLIENT_seq" OWNER TO openconcerto;

--
-- Name: CLIENT_ID_CLIENT_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CLIENT_ID_CLIENT_seq" OWNED BY "CLIENT"."ID";


--
-- Name: CLIENT_ID_CLIENT_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLIENT_ID_CLIENT_seq"', 2, false);


--
-- Name: CODE_CARACT_ACTIVITE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_CARACT_ACTIVITE" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_CARACT_ACTIVITE" OWNER TO openconcerto;

--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_CARACT_ACTIVITE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_CARACT_ACTIVITE_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_CARACT_ACTIVITE_ID_seq" OWNED BY "CODE_CARACT_ACTIVITE"."ID";


--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_CARACT_ACTIVITE_ID_seq"', 12, false);


--
-- Name: CODE_CONTRAT_TRAVAIL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_CONTRAT_TRAVAIL" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(128) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_CONTRAT_TRAVAIL" OWNER TO openconcerto;

--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_CONTRAT_TRAVAIL_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_CONTRAT_TRAVAIL_ID_seq" OWNED BY "CODE_CONTRAT_TRAVAIL"."ID";


--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_CONTRAT_TRAVAIL_ID_seq"', 14, false);


--
-- Name: CODE_DROIT_CONTRAT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_DROIT_CONTRAT" (
    "ID" integer NOT NULL,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_DROIT_CONTRAT" OWNER TO openconcerto;

--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_DROIT_CONTRAT_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_DROIT_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_DROIT_CONTRAT_ID_seq" OWNED BY "CODE_DROIT_CONTRAT"."ID";


--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_DROIT_CONTRAT_ID_seq"', 4, false);


--
-- Name: CODE_EMPLOI; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_EMPLOI" (
    "ID" integer NOT NULL,
    "CODE" character varying(11) DEFAULT ''::character varying,
    "NOM" character varying(195) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_EMPLOI" OWNER TO openconcerto;

--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_EMPLOI_ID_seq"
    START WITH 1036
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_EMPLOI_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_EMPLOI_ID_seq" OWNED BY "CODE_EMPLOI"."ID";


--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_EMPLOI_ID_seq"', 1036, false);


--
-- Name: CODE_REGIME; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_REGIME" (
    "ID" integer NOT NULL,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_REGIME" OWNER TO openconcerto;

--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_REGIME_ID_seq"
    START WITH 23
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_REGIME_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_REGIME_ID_seq" OWNED BY "CODE_REGIME"."ID";


--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_REGIME_ID_seq"', 23, false);


--
-- Name: CODE_STATUT_CATEGORIEL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_CATEGORIEL" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_STATUT_CATEGORIEL" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_CATEGORIEL_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_STATUT_CATEGORIEL_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_CATEGORIEL_ID_seq" OWNED BY "CODE_STATUT_CATEGORIEL"."ID";


--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_CATEGORIEL_ID_seq"', 6, false);


--
-- Name: CODE_STATUT_CAT_CONV; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_CAT_CONV" (
    "ID" integer NOT NULL,
    "CODE" character varying(6) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CODE_STATUT_CAT_CONV" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_CAT_CONV_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_STATUT_CAT_CONV_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_CAT_CONV_ID_seq" OWNED BY "CODE_STATUT_CAT_CONV"."ID";


--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_CAT_CONV_ID_seq"', 8, true);


--
-- Name: CODE_STATUT_PROF; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_PROF" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_STATUT_PROF" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_PROF_ID_seq"
    START WITH 51
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_STATUT_PROF_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_PROF_ID_seq" OWNED BY "CODE_STATUT_PROF"."ID";


--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_PROF_ID_seq"', 51, false);


--
-- Name: COMMANDE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "DATE_ECHEANCE" date,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "EN_COURS" boolean DEFAULT true,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1
);


ALTER TABLE "Default"."COMMANDE" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_CLIENT" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "ID_DEVIS" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "Default"."COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_CLIENT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "POIDS" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."COMMANDE_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_CLIENT_ELEMENT_ID_seq" OWNED BY "COMMANDE_CLIENT_ELEMENT"."ID";


--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_CLIENT_ELEMENT_ID_seq"', 1, true);


--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_CLIENT_ID_seq" OWNED BY "COMMANDE_CLIENT"."ID";


--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_CLIENT_ID_seq"', 2, false);


--
-- Name: COMMANDE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "POIDS" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_COMMANDE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "T_PA_TTC" bigint DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."COMMANDE_ELEMENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_ELEMENT_ID_seq" OWNED BY "COMMANDE_ELEMENT"."ID";


--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_ELEMENT_ID_seq"', 1, true);


--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_ID_seq" OWNED BY "COMMANDE"."ID";


--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_ID_seq"', 2, false);


--
-- Name: COMMERCIAL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMERCIAL" (
    "ID_COMMERCIAL" integer NOT NULL,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "FONCTION" character varying(100) DEFAULT ''::character varying,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_USER_COMMON" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."COMMERCIAL" OWNER TO openconcerto;

--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COMMERCIAL_ID_COMMERCIAL_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMERCIAL_ID_COMMERCIAL_seq" OWNER TO openconcerto;

--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COMMERCIAL_ID_COMMERCIAL_seq" OWNED BY "COMMERCIAL"."ID_COMMERCIAL";


--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMERCIAL_ID_COMMERCIAL_seq"', 2, true);


--
-- Name: COMPLETION; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPLETION" (
    "CHAMP" character varying(100) DEFAULT ''::character varying,
    "LABEL" character varying(200) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."COMPLETION" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPTE_PCE" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "TOTAL_DEBIT" bigint DEFAULT 0,
    "TOTAL_CREDIT" bigint DEFAULT 0,
    "RACINE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."COMPTE_PCE" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COMPTE_PCE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COMPTE_PCE_ID_seq" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COMPTE_PCE_ID_seq" OWNED BY "COMPTE_PCE"."ID";


--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMPTE_PCE_ID_seq"', 2, false);


--
-- Name: COMPTE_PCG; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPTE_PCG" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "ID_TYPE_COMPTE_PCG_BASE" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_AB" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_DEV" integer DEFAULT 1,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."COMPTE_PCG" OWNER TO openconcerto;

--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COMPTE_PCG_ID_seq"
    START WITH 978
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COMPTE_PCG_ID_seq" OWNED BY "COMPTE_PCG"."ID";


--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMPTE_PCG_ID_seq"', 978, false);


--
-- Name: CONTACT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT" (
    "ID" integer NOT NULL,
    "NOM" character varying(100) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(100) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(100) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(100) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 2 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "FONCTION" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."CONTACT" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT_ADMINISTRATIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "N4DS" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTACT_ADMINISTRATIF" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_ADMINISTRATIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTACT_ADMINISTRATIF_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_ADMINISTRATIF_ID_seq" OWNED BY "CONTACT_ADMINISTRATIF"."ID";


--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_ADMINISTRATIF_ID_seq"', 1, true);


--
-- Name: CONTACT_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTACT_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTACT_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_FOURNISSEUR_ID_seq" OWNED BY "CONTACT_FOURNISSEUR"."ID";


--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_FOURNISSEUR_ID_seq"', 1, true);


--
-- Name: CONTACT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTACT_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_ID_seq" OWNED BY "CONTACT"."ID";


--
-- Name: CONTACT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_ID_seq"', 1, true);


--
-- Name: CONTRAT_SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "NATURE" character varying(2048) DEFAULT ''::text,
    "ID_CODE_EMPLOI" integer DEFAULT 1,
    "ID_CODE_CONTRAT_TRAVAIL" integer DEFAULT 1,
    "ID_CODE_DROIT_CONTRAT" integer DEFAULT 1,
    "ID_CODE_CARACT_ACTIVITE" integer DEFAULT 1,
    "ID_CODE_STATUT_PROF" integer DEFAULT 1,
    "ID_CODE_STATUT_CATEGORIEL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "CODE_IRC_UGRR" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRR" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_UGRC" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRC" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_RETRAITE" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_RETRAITE" character varying(64) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_STATUT_CAT_CONV" integer DEFAULT 1
);


ALTER TABLE "Default"."CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CONTRAT_SALARIE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CONTRAT_SALARIE_ID_seq" OWNED BY "CONTRAT_SALARIE"."ID";


--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTRAT_SALARIE_ID_seq"', 2, false);


--
-- Name: COURRIER_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COURRIER_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ID_MODELE_COURRIER_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."COURRIER_CLIENT" OWNER TO openconcerto;

--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "COURRIER_CLIENT_ID_seq" OWNED BY "COURRIER_CLIENT"."ID";


--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"COURRIER_CLIENT_ID_seq"', 1, true);


--
-- Name: CUMULS_CONGES; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CUMULS_CONGES" (
    "ID" integer NOT NULL,
    "RESTANT" real DEFAULT 0,
    "ACQUIS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CUMULS_CONGES" OWNER TO openconcerto;

--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CUMULS_CONGES_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CUMULS_CONGES_ID_seq" OWNER TO openconcerto;

--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CUMULS_CONGES_ID_seq" OWNED BY "CUMULS_CONGES"."ID";


--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CUMULS_CONGES_ID_seq"', 2, false);


--
-- Name: CUMULS_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CUMULS_PAYE" (
    "ID" integer NOT NULL,
    "SAL_BRUT_C" real DEFAULT 0,
    "COT_PAT_C" real DEFAULT 0,
    "COT_SAL_C" real DEFAULT 0,
    "NET_IMP_C" real DEFAULT 0,
    "NET_A_PAYER_C" real DEFAULT 0,
    "CSG_C" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CUMULS_PAYE" OWNER TO openconcerto;

--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "CUMULS_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."CUMULS_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "CUMULS_PAYE_ID_seq" OWNED BY "CUMULS_PAYE"."ID";


--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"CUMULS_PAYE_ID_seq"', 2, false);


--
-- Name: DEPARTEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEPARTEMENT" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(10) DEFAULT ''::character varying,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "CHEF_LIEU" character varying(100) DEFAULT ''::character varying,
    "REGION_ADMIN" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."DEPARTEMENT" OWNER TO openconcerto;

--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "DEPARTEMENT_ID_seq"
    START WITH 102
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "DEPARTEMENT_ID_seq" OWNED BY "DEPARTEMENT"."ID";


--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEPARTEMENT_ID_seq"', 102, false);


--
-- Name: DEVIS; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEVIS" (
    "ID_DEVIS" integer NOT NULL,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "OBJET" character varying(100) DEFAULT ''::character varying,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_ETAT_DEVIS" integer DEFAULT 1,
    "DATE_ENVOI" timestamp without time zone,
    "T_POIDS" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_ADRESSE" integer DEFAULT 1,
    "DATE_VALIDITE" date,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "Default"."DEVIS" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEVIS_ELEMENT" (
    "ID_DEVIS_ELEMENT" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PA_HT" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "QTE" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."DEVIS_ELEMENT" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNED BY "DEVIS_ELEMENT"."ID_DEVIS_ELEMENT";


--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"', 2, false);


--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "DEVIS_ID_DEVIS_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."DEVIS_ID_DEVIS_seq" OWNER TO openconcerto;

--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "DEVIS_ID_DEVIS_seq" OWNED BY "DEVIS"."ID_DEVIS";


--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEVIS_ID_DEVIS_seq"', 2, false);


--
-- Name: ECHANTILLON_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHANTILLON_ELEMENT" (
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "QTE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ECHANTILLON_ELEMENT" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ECHANTILLON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ECHANTILLON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ECHANTILLON_ELEMENT_ID_seq" OWNED BY "ECHANTILLON_ELEMENT"."ID";


--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHANTILLON_ELEMENT_ID_seq"', 1, true);


--
-- Name: ECHEANCE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHEANCE_CLIENT" (
    "ID" integer NOT NULL,
    "MONTANT" bigint DEFAULT 0,
    "DATE" date,
    "NOMBRE_RELANCE" integer DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_CLIENT" integer DEFAULT 1,
    "REGLE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "REG_COMPTA" boolean DEFAULT false,
    "DATE_LAST_RELANCE" date
);


ALTER TABLE "Default"."ECHEANCE_CLIENT" OWNER TO openconcerto;

--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ECHEANCE_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ECHEANCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ECHEANCE_CLIENT_ID_seq" OWNED BY "ECHEANCE_CLIENT"."ID";


--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHEANCE_CLIENT_ID_seq"', 2, false);


--
-- Name: ECHEANCE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHEANCE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "MONTANT" bigint DEFAULT 0,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "REGLE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ECHEANCE_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ECHEANCE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ECHEANCE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ECHEANCE_FOURNISSEUR_ID_seq" OWNED BY "ECHEANCE_FOURNISSEUR"."ID";


--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHEANCE_FOURNISSEUR_ID_seq"', 2, false);


--
-- Name: ECRITURE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECRITURE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "DATE" date,
    "DEBIT" bigint DEFAULT 0,
    "CREDIT" bigint DEFAULT 0,
    "ID_JOURNAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "VALIDE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "POINTEE" character varying(45) DEFAULT ''::character varying,
    "DATE_POINTEE" date,
    "DATE_VALIDE" date,
    "IDUSER_CREATE" integer DEFAULT 1,
    "IDUSER_VALIDE" integer DEFAULT 1,
    "IDUSER_DELETE" integer DEFAULT 1,
    "LETTRAGE" character varying(256) DEFAULT ''::character varying,
    "DATE_LETTRAGE" date,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "JOURNAL_NOM" character varying(2048) DEFAULT ''::text,
    "JOURNAL_CODE" character varying(2048) DEFAULT ''::text,
    "COMPTE_NOM" character varying(2048) DEFAULT ''::text,
    "COMPTE_NUMERO" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "Default"."ECRITURE" OWNER TO openconcerto;

--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ECRITURE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ECRITURE_ID_seq" OWNER TO openconcerto;

--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ECRITURE_ID_seq" OWNED BY "ECRITURE"."ID";


--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECRITURE_ID_seq"', 2, false);


--
-- Name: EMPLOYEUR_MULTIPLE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "EMPLOYEUR_MULTIPLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."EMPLOYEUR_MULTIPLE" OWNER TO openconcerto;

--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "EMPLOYEUR_MULTIPLE_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."EMPLOYEUR_MULTIPLE_ID_seq" OWNER TO openconcerto;

--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "EMPLOYEUR_MULTIPLE_ID_seq" OWNED BY "EMPLOYEUR_MULTIPLE"."ID";


--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"EMPLOYEUR_MULTIPLE_ID_seq"', 5, false);


--
-- Name: ENCAISSER_MONTANT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ENCAISSER_MONTANT" (
    "ID" integer NOT NULL,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(200),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1
);


ALTER TABLE "Default"."ENCAISSER_MONTANT" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ENCAISSER_MONTANT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "ID_ENCAISSER_MONTANT" integer DEFAULT 1,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE" timestamp without time zone
);


ALTER TABLE "Default"."ENCAISSER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ENCAISSER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNED BY "ENCAISSER_MONTANT_ELEMENT"."ID";


--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ENCAISSER_MONTANT_ELEMENT_ID_seq"', 1, true);


--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ENCAISSER_MONTANT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ENCAISSER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ENCAISSER_MONTANT_ID_seq" OWNED BY "ENCAISSER_MONTANT"."ID";


--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ENCAISSER_MONTANT_ID_seq"', 2, false);


--
-- Name: ETAT_CIVIL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_CIVIL" (
    "ID" integer NOT NULL,
    "ID_ADRESSE" integer DEFAULT 1,
    "DATE_NAISSANCE" date,
    "NUMERO_SS" character varying(45) DEFAULT ''::character varying,
    "NB_ENFANTS" integer DEFAULT 0,
    "COMMUNE_NAISSANCE" character varying(45) DEFAULT ''::character varying,
    "ID_DEPARTEMENT_NAISSANCE" integer DEFAULT 1,
    "ID_PAYS_NAISSANCE" integer DEFAULT 1,
    "TELEPHONE" character varying(45) DEFAULT ''::character varying,
    "MAIL" character varying(45) DEFAULT ''::character varying,
    "PORTABLE" character varying(45) DEFAULT ''::character varying,
    "NB_PERS_A_CHARGE" integer DEFAULT 0,
    "ID_SITUATION_FAMILIALE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ETAT_CIVIL" OWNER TO openconcerto;

--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_CIVIL_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_CIVIL_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_CIVIL_ID_seq" OWNED BY "ETAT_CIVIL"."ID";


--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_CIVIL_ID_seq"', 2, false);


--
-- Name: ETAT_DEVIS; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_DEVIS" (
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ETAT_DEVIS" OWNER TO openconcerto;

--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_DEVIS_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_DEVIS_ID_seq" OWNED BY "ETAT_DEVIS"."ID";


--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_DEVIS_ID_seq"', 5, true);


--
-- Name: ETAT_RAPPORT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_RAPPORT" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048),
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ETAT_RAPPORT" OWNER TO openconcerto;

--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_RAPPORT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_RAPPORT_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_RAPPORT_ID_seq" OWNED BY "ETAT_RAPPORT"."ID";


--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_RAPPORT_ID_seq"', 2, true);


--
-- Name: FAMILLE_ARTICLE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FAMILLE_ARTICLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_FAMILLE_ARTICLE_PERE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."FAMILLE_ARTICLE" OWNER TO openconcerto;

--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "FAMILLE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."FAMILLE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "FAMILLE_ARTICLE_ID_seq" OWNED BY "FAMILLE_ARTICLE"."ID";


--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"FAMILLE_ARTICLE_ID_seq"', 1, true);


--
-- Name: FICHE_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FICHE_PAYE" (
    "ID" integer NOT NULL,
    "ANNEE" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_SALARIE" integer DEFAULT 1,
    "ID_PROFIL_PAYE" integer DEFAULT 1,
    "SAL_BRUT" real DEFAULT 0,
    "COT_PAT" real DEFAULT 0,
    "COT_SAL" real DEFAULT 0,
    "NET_IMP" real DEFAULT 0,
    "NET_A_PAYER" real DEFAULT 0,
    "ACOMPTE" real DEFAULT 0,
    "ID_MOIS" integer DEFAULT 1,
    "VALIDE" boolean DEFAULT false,
    "CSG" real DEFAULT 0,
    "DU" date,
    "AU" date,
    "CONGES_ACQUIS" real DEFAULT 0,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "NATURE_EMPLOI" character varying(150) DEFAULT ''::character varying,
    "ID_IDCC" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."FICHE_PAYE" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FICHE_PAYE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "NB_BASE" real,
    "TAUX_SAL" real,
    "TAUX_PAT" real,
    "MONTANT_SAL_AJ" real,
    "MONTANT_PAT" real,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "POSITION" integer DEFAULT 0,
    "MONTANT_SAL_DED" real,
    "VALIDE" boolean DEFAULT false,
    "IMPRESSION" boolean DEFAULT true,
    "IN_PERIODE" boolean DEFAULT true,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."FICHE_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "FICHE_PAYE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."FICHE_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "FICHE_PAYE_ELEMENT_ID_seq" OWNED BY "FICHE_PAYE_ELEMENT"."ID";


--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"FICHE_PAYE_ELEMENT_ID_seq"', 2, false);


--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "FICHE_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."FICHE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "FICHE_PAYE_ID_seq" OWNED BY "FICHE_PAYE"."ID";


--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"FICHE_PAYE_ID_seq"', 2, false);


--
-- Name: FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FOURNISSEUR" (
    "ID_FOURNISSEUR" integer NOT NULL,
    "TYPE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_E" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "UE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1 NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1 NOT NULL,
    "TEL" character varying(2048) DEFAULT ''::text,
    "FAX" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "RESPONSABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_P" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_CHARGE" integer DEFAULT 1
);


ALTER TABLE "Default"."FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "FOURNISSEUR_ID_FOURNISSEUR_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNER TO openconcerto;

--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "FOURNISSEUR_ID_FOURNISSEUR_seq" OWNED BY "FOURNISSEUR"."ID_FOURNISSEUR";


--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"FOURNISSEUR_ID_FOURNISSEUR_seq"', 2, false);


--
-- Name: FWK_MODULE_METADATA; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_MODULE_METADATA" (
    "ID" integer NOT NULL,
    "MODULE_NAME" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128),
    "FIELD" character varying(128),
    "KEY" boolean,
    "MODULE_VERSION" bigint NOT NULL
);


ALTER TABLE "Default"."FWK_MODULE_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "FWK_MODULE_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."FWK_MODULE_METADATA_ID_seq" OWNER TO openconcerto;

--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "FWK_MODULE_METADATA_ID_seq" OWNED BY "FWK_MODULE_METADATA"."ID";


--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"FWK_MODULE_METADATA_ID_seq"', 1, false);


--
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_UNDEFINED_IDS" (
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL,
    "UNDEFINED_ID" integer DEFAULT 0
);


ALTER TABLE "Default"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- Name: IDCC; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "IDCC" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."IDCC" OWNER TO openconcerto;

--
-- Name: IDCC_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "IDCC_ID_seq"
    START WITH 996
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."IDCC_ID_seq" OWNER TO openconcerto;

--
-- Name: IDCC_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "IDCC_ID_seq" OWNED BY "IDCC"."ID";


--
-- Name: IDCC_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"IDCC_ID_seq"', 996, false);


--
-- Name: INFOS_SALARIE_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "INFOS_SALARIE_PAYE" (
    "ID" integer NOT NULL,
    "ID_IDCC" integer DEFAULT 1,
    "ID_CONTRAT_SALARIE" integer DEFAULT 1,
    "ID_CLASSEMENT_CONVENTIONNEL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "DUREE_HEBDO" real DEFAULT 0,
    "DUREE_MOIS" real DEFAULT 0,
    "DATE_ARRIVE" date,
    "CONGES_PAYES" real DEFAULT 0,
    "TAUX_AT" real DEFAULT 0,
    "SALAIRE_MOIS" real DEFAULT 0,
    "DATE_SORTIE" date,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "CODE_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "CODE_SECTION_AT" character varying(18) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."INFOS_SALARIE_PAYE" OWNER TO openconcerto;

--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "INFOS_SALARIE_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."INFOS_SALARIE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "INFOS_SALARIE_PAYE_ID_seq" OWNED BY "INFOS_SALARIE_PAYE"."ID";


--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"INFOS_SALARIE_PAYE_ID_seq"', 2, false);


--
-- Name: JOURNAL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "JOURNAL" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "PAR_DEFAUT" boolean DEFAULT false,
    "TYPE_BANQUE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."JOURNAL" OWNER TO openconcerto;

--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "JOURNAL_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "JOURNAL_ID_seq" OWNED BY "JOURNAL"."ID";


--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"JOURNAL_ID_seq"', 7, false);


--
-- Name: LANGUE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "LANGUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CHEMIN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."LANGUE" OWNER TO openconcerto;

--
-- Name: LANGUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "LANGUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."LANGUE_ID_seq" OWNER TO openconcerto;

--
-- Name: LANGUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "LANGUE_ID_seq" OWNED BY "LANGUE"."ID";


--
-- Name: LANGUE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"LANGUE_ID_seq"', 7, true);


--
-- Name: METRIQUE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "METRIQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "UNITE" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."METRIQUE" OWNER TO openconcerto;

--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "METRIQUE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."METRIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "METRIQUE_ID_seq" OWNED BY "METRIQUE"."ID";


--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"METRIQUE_ID_seq"', 4, false);


--
-- Name: MODELE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TYPE_MODELE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."MODELE" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODELE_COURRIER_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CODE" character varying(10) DEFAULT ''::character varying,
    "LOCATION" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CONTENU" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MODELE_COURRIER_CLIENT" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MODELE_COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MODELE_COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MODELE_COURRIER_CLIENT_ID_seq" OWNED BY "MODELE_COURRIER_CLIENT"."ID";


--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODELE_COURRIER_CLIENT_ID_seq"', 9, true);


--
-- Name: MODELE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MODELE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MODELE_ID_seq" OWNED BY "MODELE"."ID";


--
-- Name: MODELE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODELE_ID_seq"', 1, true);


--
-- Name: MODE_REGLEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_REGLEMENT" (
    "ID_MODE_REGLEMENT" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "AJOURS" integer DEFAULT 0,
    "LENJOUR" integer DEFAULT 0,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "FIN_MOIS" boolean DEFAULT false,
    "COMPTANT" boolean DEFAULT false,
    "DATE_DEPOT" date,
    "DATE_FACTURE" boolean DEFAULT false,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "DATE_VIREMENT" date
);


ALTER TABLE "Default"."MODE_REGLEMENT" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNED BY "MODE_REGLEMENT"."ID_MODE_REGLEMENT";


--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"', 3, true);


--
-- Name: MODE_REGLEMENT_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_REGLEMENT_PAYE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "Default"."MODE_REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MODE_REGLEMENT_PAYE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MODE_REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MODE_REGLEMENT_PAYE_ID_seq" OWNED BY "MODE_REGLEMENT_PAYE"."ID";


--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_REGLEMENT_PAYE_ID_seq"', 4, false);


--
-- Name: MODE_VENTE_ARTICLE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_VENTE_ARTICLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0.00000000,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MODE_VENTE_ARTICLE" OWNER TO openconcerto;

--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MODE_VENTE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MODE_VENTE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MODE_VENTE_ARTICLE_ID_seq" OWNED BY "MODE_VENTE_ARTICLE"."ID";


--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_VENTE_ARTICLE_ID_seq"', 6, true);


--
-- Name: MOIS; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOIS" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MOIS" OWNER TO openconcerto;

--
-- Name: MOIS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MOIS_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MOIS_ID_seq" OWNER TO openconcerto;

--
-- Name: MOIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MOIS_ID_seq" OWNED BY "MOIS"."ID";


--
-- Name: MOIS_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOIS_ID_seq"', 14, false);


--
-- Name: MOUVEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOUVEMENT" (
    "ID" integer NOT NULL,
    "NUMERO" integer DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_MOUVEMENT_PERE" integer DEFAULT 1,
    "ID_PIECE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MOUVEMENT" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MOUVEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MOUVEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MOUVEMENT_ID_seq" OWNED BY "MOUVEMENT"."ID";


--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOUVEMENT_ID_seq"', 2, false);


--
-- Name: MOUVEMENT_STOCK; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOUVEMENT_STOCK" (
    "ID" integer NOT NULL,
    "QTE" real DEFAULT 0,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(150) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "DATE" date,
    "ID_ARTICLE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MOUVEMENT_STOCK" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "MOUVEMENT_STOCK_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."MOUVEMENT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "MOUVEMENT_STOCK_ID_seq" OWNED BY "MOUVEMENT_STOCK"."ID";


--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOUVEMENT_STOCK_ID_seq"', 2, false);


--
-- Name: NATURE_COMPTE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "NATURE_COMPTE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."NATURE_COMPTE" OWNER TO openconcerto;

--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "NATURE_COMPTE_ID_seq"
    START WITH 13
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."NATURE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "NATURE_COMPTE_ID_seq" OWNED BY "NATURE_COMPTE"."ID";


--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"NATURE_COMPTE_ID_seq"', 13, false);


--
-- Name: NUMEROTATION_AUTO; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "NUMEROTATION_AUTO" (
    "ID" integer NOT NULL,
    "DEVIS_FORMAT" character varying(45) DEFAULT ''::character varying,
    "DEVIS_START" integer DEFAULT 1,
    "BON_L_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_L_START" integer DEFAULT 1,
    "FACT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "FACT_START" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SALARIE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "SALARIE_START" integer DEFAULT 1,
    "PROPOSITION_FORMAT" character varying(45) DEFAULT ''::character varying,
    "PROPOSITION_START" integer DEFAULT 0,
    "RELANCE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "RELANCE_START" integer DEFAULT 0,
    "COMMANDE_CLIENT_START" integer DEFAULT 0,
    "COMMANDE_CLIENT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_START" integer DEFAULT 0,
    "COMMANDE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_R_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_R_START" integer DEFAULT 0,
    "AFFAIRE_START" integer DEFAULT 0,
    "AFFAIRE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_START" integer DEFAULT 0,
    "AVOIR_FORMAT" character varying(45) DEFAULT ''::character varying,
    "CODE_LETTRAGE" character varying(128) DEFAULT 'AAA'::character varying,
    "COURRIER_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_START" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "AVOIR_F_START" integer DEFAULT 0,
    "AVOIR_F_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."NUMEROTATION_AUTO" OWNER TO openconcerto;

--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "NUMEROTATION_AUTO_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."NUMEROTATION_AUTO_ID_seq" OWNER TO openconcerto;

--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "NUMEROTATION_AUTO_ID_seq" OWNED BY "NUMEROTATION_AUTO"."ID";


--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"NUMEROTATION_AUTO_ID_seq"', 3, false);


--
-- Name: OBJECTIF_COMMERCIAL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "OBJECTIF_COMMERCIAL" (
    "ID" integer NOT NULL,
    "MOIS" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ANNEE" integer,
    "MARGE_HT" bigint DEFAULT 0,
    "POURCENT_MARGE" numeric(16,8),
    "CHIFFRE_AFFAIRE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."OBJECTIF_COMMERCIAL" OWNER TO openconcerto;

--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "OBJECTIF_COMMERCIAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."OBJECTIF_COMMERCIAL_ID_seq" OWNER TO openconcerto;

--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "OBJECTIF_COMMERCIAL_ID_seq" OWNED BY "OBJECTIF_COMMERCIAL"."ID";


--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"OBJECTIF_COMMERCIAL_ID_seq"', 1, true);


--
-- Name: PAYS; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PAYS" (
    "ID" integer NOT NULL,
    "CODE" character varying(15) DEFAULT ''::character varying,
    "NOM" character varying(50) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_TARIF" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1
);


ALTER TABLE "Default"."PAYS" OWNER TO openconcerto;

--
-- Name: PAYS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "PAYS_ID_seq"
    START WITH 194
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."PAYS_ID_seq" OWNER TO openconcerto;

--
-- Name: PAYS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "PAYS_ID_seq" OWNED BY "PAYS"."ID";


--
-- Name: PAYS_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"PAYS_ID_seq"', 194, false);


--
-- Name: PIECE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PIECE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."PIECE" OWNER TO openconcerto;

--
-- Name: PIECE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "PIECE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."PIECE_ID_seq" OWNER TO openconcerto;

--
-- Name: PIECE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "PIECE_ID_seq" OWNED BY "PIECE"."ID";


--
-- Name: PIECE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"PIECE_ID_seq"', 2, false);


--
-- Name: POSTE_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "POSTE_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."POSTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "POSTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."POSTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "POSTE_ANALYTIQUE_ID_seq" OWNED BY "POSTE_ANALYTIQUE"."ID";


--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"POSTE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: PREFERENCES; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREFERENCES" (
    "NAME" character varying(2048) NOT NULL,
    "VALUE" character varying(2048),
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."PREFERENCES" OWNER TO openconcerto;

--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "PREFERENCES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."PREFERENCES_ID_seq" OWNER TO openconcerto;

--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "PREFERENCES_ID_seq" OWNED BY "PREFERENCES"."ID";


--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREFERENCES_ID_seq"', 4, true);


--
-- Name: PREFS_COMPTE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREFS_COMPTE" (
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE_REGL" integer DEFAULT 1,
    "ID_COMPTE_PCE_PAYE" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_INTRA" integer DEFAULT 1 NOT NULL,
    "ID_COMPTE_PCE_TVA_IMMO" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_O" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_F" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT_INTRA" integer DEFAULT 1,
    "ID_JOURNAL_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT_PERTE" integer DEFAULT 1
);


ALTER TABLE "Default"."PREFS_COMPTE" OWNER TO openconcerto;

--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "PREFS_COMPTE_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."PREFS_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "PREFS_COMPTE_ID_seq" OWNED BY "PREFS_COMPTE"."ID";


--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREFS_COMPTE_ID_seq"', 3, false);


--
-- Name: REFERENCE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REFERENCE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REFERENCE_CLIENT" OWNER TO openconcerto;

--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "REFERENCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."REFERENCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "REFERENCE_CLIENT_ID_seq" OWNED BY "REFERENCE_CLIENT"."ID";


--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"REFERENCE_CLIENT_ID_seq"', 2, true);


--
-- Name: REGIME_BASE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGIME_BASE" (
    "ID" integer NOT NULL,
    "ID_CODE_REGIME_BASE" integer DEFAULT 1,
    "ID_CODE_REGIME_MALADIE" integer DEFAULT 1,
    "ID_CODE_REGIME_AT" integer DEFAULT 1,
    "ID_CODE_REGIME_VIEL_P" integer DEFAULT 1,
    "ID_CODE_REGIME_VIEL_S" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REGIME_BASE" OWNER TO openconcerto;

--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "REGIME_BASE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."REGIME_BASE_ID_seq" OWNER TO openconcerto;

--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "REGIME_BASE_ID_seq" OWNED BY "REGIME_BASE"."ID";


--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGIME_BASE_ID_seq"', 2, false);


--
-- Name: REGLEMENT_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGLEMENT_PAYE" (
    "ID" integer NOT NULL,
    "NOM_BANQUE" character varying(45) DEFAULT ''::character varying,
    "RIB" character varying(45) DEFAULT ''::character varying,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "LE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "REGLEMENT_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "REGLEMENT_PAYE_ID_seq" OWNED BY "REGLEMENT_PAYE"."ID";


--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGLEMENT_PAYE_ID_seq"', 2, false);


--
-- Name: REGLER_MONTANT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGLER_MONTANT" (
    "ID" integer NOT NULL,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REGLER_MONTANT" OWNER TO openconcerto;

--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "REGLER_MONTANT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."REGLER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "REGLER_MONTANT_ID_seq" OWNED BY "REGLER_MONTANT"."ID";


--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGLER_MONTANT_ID_seq"', 2, false);


--
-- Name: RELANCE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RELANCE" (
    "ID" integer NOT NULL,
    "DATE" date,
    "ID_TYPE_LETTRE_RELANCE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."RELANCE" OWNER TO openconcerto;

--
-- Name: RELANCE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "RELANCE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."RELANCE_ID_seq" OWNER TO openconcerto;

--
-- Name: RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "RELANCE_ID_seq" OWNED BY "RELANCE"."ID";


--
-- Name: RELANCE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"RELANCE_ID_seq"', 2, false);


--
-- Name: REPARTITION_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REPARTITION_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REPARTITION_ANALYTIQUE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "TAUX" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE_ELEMENT" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNED BY "REPARTITION_ANALYTIQUE_ELEMENT"."ID";


--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"', 2, false);


--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "REPARTITION_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "REPARTITION_ANALYTIQUE_ID_seq" OWNED BY "REPARTITION_ANALYTIQUE"."ID";


--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"REPARTITION_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: SAISIE_ACHAT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_ACHAT" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MONTANT_TTC" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NUMERO_COMMANDE" character varying(2048) DEFAULT ''::text,
    "NUMERO_FACTURE" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "MONTANT_HT" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ID_COMPTE_PCE" integer DEFAULT 1 NOT NULL,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "IMMO" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SAISIE_ACHAT" OWNER TO openconcerto;

--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_ACHAT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_ACHAT_ID_seq" OWNED BY "SAISIE_ACHAT"."ID";


--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_ACHAT_ID_seq"', 2, false);


--
-- Name: SAISIE_KM; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_KM" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_JOURNAL" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SAISIE_KM" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_KM_ELEMENT" (
    "ID_SAISIE_KM" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "NUMERO" character varying(100) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "NOM_ECRITURE" character varying(2048) DEFAULT ''::text,
    "DEBIT" bigint DEFAULT 0,
    "CREDIT" bigint DEFAULT 0,
    "ID_ECRITURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SAISIE_KM_ELEMENT" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_KM_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_KM_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_KM_ELEMENT_ID_seq" OWNED BY "SAISIE_KM_ELEMENT"."ID";


--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_KM_ELEMENT_ID_seq"', 2, false);


--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_KM_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_KM_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_KM_ID_seq" OWNED BY "SAISIE_KM"."ID";


--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_KM_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_COMPTOIR; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_COMPTOIR" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_ARTICLE" integer DEFAULT 1,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 0,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ECHEANCE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SAISIE_VENTE_COMPTOIR" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_COMPTOIR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_COMPTOIR_ID_seq" OWNED BY "SAISIE_VENTE_COMPTOIR"."ID";


--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_COMPTOIR_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_FACTURE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_FACTURE" (
    "ID_DEVIS" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "NOM" character varying(250) DEFAULT ''::character varying,
    "DATE" date,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "T_SERVICE" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_POIDS" real DEFAULT 0,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "PREVISIONNELLE" boolean DEFAULT false NOT NULL,
    "COMPLEMENT" boolean DEFAULT false NOT NULL,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "DATE_ENVOI" timestamp without time zone,
    "DATE_REGLEMENT" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "POURCENT_ACOMPTE" real DEFAULT 0,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "DATE_ENVOI_AFFACTURAGE" date,
    "AFFACTURAGE" boolean DEFAULT false,
    "ID_CONTACT" integer DEFAULT 1,
    "TYPE_INTERVENTION" character varying(2048) DEFAULT ''::text,
    "ID_REFERENCE_CLIENT" integer DEFAULT 1,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "T_AVOIR_TTC" bigint DEFAULT 0,
    "REF_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "T_HA" bigint DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_MOIS_CCIP" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "CONTROLE_TECHNIQUE" boolean DEFAULT false,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_TAXE_PORT" integer DEFAULT 1
);


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_FACTURE_ELEMENT" (
    "LIVREE" boolean DEFAULT false,
    "QTE_LIVREE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PV_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "INDICE_0" bigint DEFAULT 0,
    "INDICE_N" bigint DEFAULT 0,
    "MONTANT_INITIAL" bigint DEFAULT 0,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "Q18" boolean DEFAULT false,
    "TARIF_Q18_HT" bigint DEFAULT 0,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "POURCENT_CCIP" character varying(256) DEFAULT ''::character varying NOT NULL,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "ACOMPTE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0 NOT NULL,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "REPARTITION_POURCENT" numeric(6,2) DEFAULT 0 NOT NULL,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE_ELEMENT" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNED BY "SAISIE_VENTE_FACTURE_ELEMENT"."ID";


--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "SAISIE_VENTE_FACTURE"."ID";


--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_FACTURE_ID_seq"', 2, false);


--
-- Name: SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SALARIE" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "PRENOM" character varying(45) DEFAULT ''::character varying,
    "NOM_JEUNE_FILLE" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_ETAT_CIVIL" integer DEFAULT 1,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "DERNIER_MOIS" integer DEFAULT 0,
    "DERNIERE_ANNEE" integer DEFAULT 0,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SALARIE" OWNER TO openconcerto;

--
-- Name: SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SALARIE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SALARIE_ID_seq" OWNED BY "SALARIE"."ID";


--
-- Name: SALARIE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SALARIE_ID_seq"', 2, false);


--
-- Name: SITUATION_FAMILIALE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SITUATION_FAMILIALE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SITUATION_FAMILIALE" OWNER TO openconcerto;

--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "SITUATION_FAMILIALE_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."SITUATION_FAMILIALE_ID_seq" OWNER TO openconcerto;

--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "SITUATION_FAMILIALE_ID_seq" OWNED BY "SITUATION_FAMILIALE"."ID";


--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"SITUATION_FAMILIALE_ID_seq"', 7, false);


--
-- Name: STOCK; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "STOCK" (
    "ID" integer NOT NULL,
    "QTE_REEL" real DEFAULT 0,
    "QTE_TH" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."STOCK" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "STOCK_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "STOCK_ID_seq" OWNED BY "STOCK"."ID";


--
-- Name: STOCK_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"STOCK_ID_seq"', 2, false);


--
-- Name: STYLE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "STYLE" (
    "ID_STYLE" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "Default"."STYLE" OWNER TO openconcerto;

--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "STYLE_ID_STYLE_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."STYLE_ID_STYLE_seq" OWNER TO openconcerto;

--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "STYLE_ID_STYLE_seq" OWNED BY "STYLE"."ID_STYLE";


--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"STYLE_ID_STYLE_seq"', 5, false);


--
-- Name: TARIF; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TARIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."TARIF" OWNER TO openconcerto;

--
-- Name: TARIF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."TARIF_ID_seq" OWNER TO openconcerto;

--
-- Name: TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "TARIF_ID_seq" OWNED BY "TARIF"."ID";


--
-- Name: TARIF_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"TARIF_ID_seq"', 1, true);


--
-- Name: TAXE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TAXE" (
    "ID_TAXE" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TAUX" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_COMPTE_PCE_DED" integer DEFAULT 1,
    "ID_COMPTE_PCE_COLLECTE" integer DEFAULT 1
);


ALTER TABLE "Default"."TAXE" OWNER TO openconcerto;

--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "TAXE_ID_TAXE_seq"
    START WITH 6
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."TAXE_ID_TAXE_seq" OWNER TO openconcerto;

--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "TAXE_ID_TAXE_seq" OWNED BY "TAXE"."ID_TAXE";


--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"TAXE_ID_TAXE_seq"', 6, true);


--
-- Name: TICKET_CAISSE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TICKET_CAISSE" (
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "DATE" timestamp without time zone,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "TOTAL_HT" bigint DEFAULT 0,
    "ID_CAISSE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1
);


ALTER TABLE "Default"."TICKET_CAISSE" OWNER TO openconcerto;

--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "TICKET_CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."TICKET_CAISSE_ID_seq" OWNER TO openconcerto;

--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "TICKET_CAISSE_ID_seq" OWNED BY "TICKET_CAISSE"."ID";


--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"TICKET_CAISSE_ID_seq"', 1, true);


--
-- Name: TITRE_PERSONNEL; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TITRE_PERSONNEL" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SEXE_M" boolean DEFAULT true,
    "CODE" character varying(8) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."TITRE_PERSONNEL" OWNER TO openconcerto;

--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "TITRE_PERSONNEL_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."TITRE_PERSONNEL_ID_seq" OWNER TO openconcerto;

--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "TITRE_PERSONNEL_ID_seq" OWNED BY "TITRE_PERSONNEL"."ID";


--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"TITRE_PERSONNEL_ID_seq"', 5, false);


--
-- Name: TYPE_COMPTE_PCG; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_COMPTE_PCG" (
    "ID" integer NOT NULL,
    "RACINE" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "Default"."TYPE_COMPTE_PCG" OWNER TO openconcerto;

--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_COMPTE_PCG_ID_seq"
    START WITH 8
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."TYPE_COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_COMPTE_PCG_ID_seq" OWNED BY "TYPE_COMPTE_PCG"."ID";


--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_COMPTE_PCG_ID_seq"', 8, false);


--
-- Name: TYPE_LETTRE_RELANCE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_LETTRE_RELANCE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODELE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."TYPE_LETTRE_RELANCE" OWNER TO openconcerto;

--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_LETTRE_RELANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."TYPE_LETTRE_RELANCE_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_LETTRE_RELANCE_ID_seq" OWNED BY "TYPE_LETTRE_RELANCE"."ID";


--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_LETTRE_RELANCE_ID_seq"', 2, true);


--
-- Name: TYPE_REGLEMENT; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_REGLEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "COMPTANT" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURN" integer DEFAULT 1,
    "ECHEANCE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."TYPE_REGLEMENT" OWNER TO openconcerto;

--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_REGLEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."TYPE_REGLEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_REGLEMENT_ID_seq" OWNED BY "TYPE_REGLEMENT"."ID";


--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_REGLEMENT_ID_seq"', 9, true);


--
-- Name: UNITE_VENTE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "UNITE_VENTE" (
    "ID" integer NOT NULL,
    "CODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "A_LA_PIECE" boolean DEFAULT false,
    "INFOS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."UNITE_VENTE" OWNER TO openconcerto;

--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "UNITE_VENTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."UNITE_VENTE_ID_seq" OWNER TO openconcerto;

--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "UNITE_VENTE_ID_seq" OWNED BY "UNITE_VENTE"."ID";


--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"UNITE_VENTE_ID_seq"', 10, true);


--
-- Name: VARIABLE_SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "VARIABLE_SALARIE" (
    "ID" integer NOT NULL,
    "HEURE_ABS" real DEFAULT 0,
    "HEURE_110" real DEFAULT 0,
    "HEURE_125" real DEFAULT 0,
    "HEURE_150" real DEFAULT 0,
    "HEURE_200" real DEFAULT 0,
    "CONGES_PRIS" real DEFAULT 0,
    "HEURE_TRAV" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."VARIABLE_SALARIE" OWNER TO openconcerto;

--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "VARIABLE_SALARIE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "Default"."VARIABLE_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "VARIABLE_SALARIE_ID_seq" OWNED BY "VARIABLE_SALARIE"."ID";


--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE SET; Schema: Default; Owner: openconcerto
--

SELECT pg_catalog.setval('"VARIABLE_SALARIE_ID_seq"', 2, false);


SET search_path = "OpenConcerto42", pg_catalog;

--
-- Name: ACOMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ACOMPTE" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MONTANT" real DEFAULT 0,
    "ID_SALARIE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."ACOMPTE" OWNER TO openconcerto;

--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ACOMPTE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ACOMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ACOMPTE_ID_seq" OWNED BY "ACOMPTE"."ID";


--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ACOMPTE_ID_seq"', 2, false);


--
-- Name: ADRESSE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ADRESSE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "CODE_POSTAL" integer DEFAULT 0,
    "ID_ADRESSE" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "DEST" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CEDEX" integer,
    "RUE" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 1,
    "HAS_CEDEX" boolean DEFAULT false,
    "VILLE" character varying(2048) DEFAULT ''::text,
    "PAYS" character varying(100) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."ADRESSE" OWNER TO openconcerto;

--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ADRESSE_ID_ADRESSE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ADRESSE_ID_ADRESSE_seq" OWNER TO openconcerto;

--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ADRESSE_ID_ADRESSE_seq" OWNED BY "ADRESSE"."ID_ADRESSE";


--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ADRESSE_ID_ADRESSE_seq"', 32, true);


--
-- Name: ARTICLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE" (
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "PV_TTC" bigint DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "PA_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "CREATION_AUTO" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "ID_STOCK" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "OBSOLETE" boolean DEFAULT false,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "GESTION_STOCK" boolean DEFAULT true,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE_MIN" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_PAYS" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2
);


ALTER TABLE "OpenConcerto42"."ARTICLE" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE_DESIGNATION" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."ARTICLE_DESIGNATION" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_DESIGNATION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_DESIGNATION_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_DESIGNATION_ID_seq" OWNED BY "ARTICLE_DESIGNATION"."ID";


--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_DESIGNATION_ID_seq"', 1, true);


--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_ID_seq" OWNED BY "ARTICLE"."ID";


--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_ID_seq"', 27, true);


--
-- Name: ARTICLE_TARIF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE_TARIF" (
    "ID" integer NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_TARIF" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."ARTICLE_TARIF" OWNER TO openconcerto;

--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_TARIF_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_TARIF_ID_seq" OWNED BY "ARTICLE_TARIF"."ID";


--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_TARIF_ID_seq"', 1, true);


--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ASSOCIATION_COMPTE_ANALYTIQUE" (
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNED BY "ASSOCIATION_COMPTE_ANALYTIQUE"."ID";


--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_CLIENT" (
    "MONTANT_SOLDE" bigint DEFAULT 0,
    "SOLDE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MOTIF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_HT" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_ENVOI_AFFACTURAGE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE" date,
    "AFFACTURE" boolean DEFAULT false,
    "MONTANT_TVA" bigint DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "AFFACTURAGE" boolean DEFAULT false,
    "A_DEDUIRE" boolean DEFAULT false,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_RESTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_CLIENT_ELEMENT" (
    "INDICE_N" bigint DEFAULT 0,
    "ID_CONTACT" integer DEFAULT 1,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "TARIF_Q18_HT" bigint DEFAULT 0,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE_FIN" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "PA_HT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "Q18" boolean DEFAULT false,
    "T_POIDS" real DEFAULT 0,
    "MONTANT_INITIAL" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0 NOT NULL,
    "T_PA_HT" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "T_PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "QTE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "INDICE_0" bigint DEFAULT 0,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_CLIENT_ELEMENT_ID_seq" OWNED BY "AVOIR_CLIENT_ELEMENT"."ID";


--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_CLIENT_ELEMENT_ID_seq"', 2, true);


--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_CLIENT_ID_seq" OWNED BY "AVOIR_CLIENT"."ID";


--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_CLIENT_ID_seq"', 2, true);


--
-- Name: AVOIR_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_FOURNISSEUR" (
    "SOLDE" boolean DEFAULT false,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "MONTANT_TVA" bigint DEFAULT 0,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "A_DEDUIRE" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "IMMO" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."AVOIR_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AVOIR_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_FOURNISSEUR_ID_seq" OWNED BY "AVOIR_FOURNISSEUR"."ID";


--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_FOURNISSEUR_ID_seq"', 2, true);


--
-- Name: AXE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AXE_ANALYTIQUE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."AXE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "AXE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AXE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "AXE_ANALYTIQUE_ID_seq" OWNED BY "AXE_ANALYTIQUE"."ID";


--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"AXE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: BON_DE_LIVRAISON; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_DE_LIVRAISON" (
    "ID_USER_COMMON_CREATE" integer,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "TOTAL_TTC" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "TOTAL_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "TOTAL_HT" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "TOTAL_POIDS" real DEFAULT 0,
    "SOURCE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_LIVRAISON" date
);


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_DE_LIVRAISON_ELEMENT" (
    "T_POIDS" real DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "T_PV_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "QTE_A_LIVRER" integer DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_STYLE" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "POIDS" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "T_POIDS_LIVREE" real DEFAULT 0,
    "ID" integer NOT NULL,
    "PA_HT" bigint DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE_ELEMENT" integer DEFAULT 1,
    "QTE_LIVREE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_TAXE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "BON_DE_LIVRAISON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNED BY "BON_DE_LIVRAISON_ELEMENT"."ID";


--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_DE_LIVRAISON_ELEMENT_ID_seq"', 5, true);


--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "BON_DE_LIVRAISON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "BON_DE_LIVRAISON_ID_seq" OWNED BY "BON_DE_LIVRAISON"."ID";


--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_DE_LIVRAISON_ID_seq"', 5, true);


--
-- Name: BON_RECEPTION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_RECEPTION" (
    "ID_USER_COMMON_CREATE" integer,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "TOTAL_TVA" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "TOTAL_HT" bigint DEFAULT 0,
    "DATE" date,
    "TOTAL_TTC" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "TOTAL_POIDS" real DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."BON_RECEPTION" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_RECEPTION_ELEMENT" (
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "T_PA_TTC" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "T_PV_TTC" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "PA_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "T_PA_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."BON_RECEPTION_ELEMENT" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "BON_RECEPTION_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_RECEPTION_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "BON_RECEPTION_ELEMENT_ID_seq" OWNED BY "BON_RECEPTION_ELEMENT"."ID";


--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_RECEPTION_ELEMENT_ID_seq"', 10, true);


--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "BON_RECEPTION_ID_seq" OWNED BY "BON_RECEPTION"."ID";


--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_RECEPTION_ID_seq"', 10, true);


--
-- Name: CAISSE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CAISSE" (
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."CAISSE" OWNER TO openconcerto;

--
-- Name: CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CAISSE_ID_seq" OWNER TO openconcerto;

--
-- Name: CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CAISSE_ID_seq" OWNED BY "CAISSE"."ID";


--
-- Name: CAISSE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CAISSE_ID_seq"', 3, false);


--
-- Name: CHEQUE_AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_AVOIR_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_MIN_DECAISSE" date,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DECAISSE" boolean DEFAULT false,
    "DATE_AVOIR" date,
    "ID_USER_COMMON_CREATE" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "DATE_DECAISSE" date,
    "ARCHIVE" integer DEFAULT 0,
    "REG_COMPTA" boolean DEFAULT false,
    "ETS" character varying(2048) DEFAULT ''::text,
    "MONTANT" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."CHEQUE_AVOIR_CLIENT" OWNER TO openconcerto;

--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_AVOIR_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_AVOIR_CLIENT_ID_seq" OWNED BY "CHEQUE_AVOIR_CLIENT"."ID";


--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_AVOIR_CLIENT_ID_seq"', 2, false);


--
-- Name: CHEQUE_A_ENCAISSER; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_A_ENCAISSER" (
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE_MIN_DEPOT" date,
    "DATE_VENTE" date,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ENCAISSE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE" date,
    "ETS" character varying(2048) DEFAULT ''::text,
    "MONTANT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "REG_COMPTA" boolean DEFAULT false,
    "DATE_DEPOT" date
);


ALTER TABLE "OpenConcerto42"."CHEQUE_A_ENCAISSER" OWNER TO openconcerto;

--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_A_ENCAISSER_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CHEQUE_A_ENCAISSER_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_A_ENCAISSER_ID_seq" OWNED BY "CHEQUE_A_ENCAISSER"."ID";


--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_A_ENCAISSER_ID_seq"', 10, true);


--
-- Name: CHEQUE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_FOURNISSEUR" (
    "ORDRE" numeric(16,8),
    "ETS" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_MIN_DECAISSE" date,
    "DATE_ACHAT" date,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE_DECAISSE" date,
    "DATE" date,
    "ID_USER_COMMON_CREATE" integer,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "DECAISSE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto42"."CHEQUE_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CHEQUE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_FOURNISSEUR_ID_seq" OWNED BY "CHEQUE_FOURNISSEUR"."ID";


--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_FOURNISSEUR_ID_seq"', 3, true);


--
-- Name: CLASSEMENT_CONVENTIONNEL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLASSEMENT_CONVENTIONNEL" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "COEFF" character varying(45) DEFAULT ''::character varying,
    "ECHELON" character varying(45) DEFAULT ''::character varying,
    "NIVEAU" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "POSITION" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "INDICE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL" OWNER TO openconcerto;

--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CLASSEMENT_CONVENTIONNEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNER TO openconcerto;

--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CLASSEMENT_CONVENTIONNEL_ID_seq" OWNED BY "CLASSEMENT_CONVENTIONNEL"."ID";


--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLASSEMENT_CONVENTIONNEL_ID_seq"', 5, true);


--
-- Name: CLASSE_COMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLASSE_COMPTE" (
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "TYPE_NUMERO_COMPTE" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CLASSE_COMPTE" OWNER TO openconcerto;

--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CLASSE_COMPTE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CLASSE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CLASSE_COMPTE_ID_seq" OWNED BY "CLASSE_COMPTE"."ID";


--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLASSE_COMPTE_ID_seq"', 12, false);


--
-- Name: CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLIENT" (
    "ID_USER_COMMON_MODIFY" integer,
    "TEL_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_P_COM" character varying(100) DEFAULT ''::character varying,
    "MAIL_TECH" character varying(100) DEFAULT ''::character varying,
    "NUMERO_TVA" character varying(100) DEFAULT ''::character varying,
    "TEL_COM" character varying(100) DEFAULT ''::character varying,
    "FAX_TECH" character varying(100) DEFAULT ''::character varying,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "MAX_FACTURE" bigint DEFAULT 0,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "AFFACTURAGE" boolean DEFAULT false,
    "RIB" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ADRESSE_F" integer DEFAULT 1,
    "COMPTE_CLIENT_AUTO" boolean DEFAULT false,
    "MAIL_COM" character varying(100) DEFAULT ''::character varying,
    "FAX_COM" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_P" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_TECH" character varying(100) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "TEL" character varying(100) DEFAULT ''::character varying,
    "TEL_P_TECH" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE" character varying(100) DEFAULT ''::character varying,
    "COMPTANT" boolean DEFAULT false,
    "ID_ADRESSE_L" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "MAIL" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "MARCHE_PUBLIC" boolean DEFAULT false,
    "MARCHE_PRIVE" boolean DEFAULT false,
    "FORME_JURIDIQUE" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "SIRET" character varying(2048) DEFAULT ''::text,
    "ID_TARIF" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CLIENT" OWNER TO openconcerto;

--
-- Name: CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CLIENT_ID_seq" OWNED BY "CLIENT"."ID";


--
-- Name: CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLIENT_ID_seq"', 14, true);


--
-- Name: CODE_CARACT_ACTIVITE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_CARACT_ACTIVITE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."CODE_CARACT_ACTIVITE" OWNER TO openconcerto;

--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_CARACT_ACTIVITE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_CARACT_ACTIVITE_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_CARACT_ACTIVITE_ID_seq" OWNED BY "CODE_CARACT_ACTIVITE"."ID";


--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_CARACT_ACTIVITE_ID_seq"', 12, false);


--
-- Name: CODE_CONTRAT_TRAVAIL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_CONTRAT_TRAVAIL" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(128) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."CODE_CONTRAT_TRAVAIL" OWNER TO openconcerto;

--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_CONTRAT_TRAVAIL_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_CONTRAT_TRAVAIL_ID_seq" OWNED BY "CODE_CONTRAT_TRAVAIL"."ID";


--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_CONTRAT_TRAVAIL_ID_seq"', 14, false);


--
-- Name: CODE_DROIT_CONTRAT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_DROIT_CONTRAT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CODE_DROIT_CONTRAT" OWNER TO openconcerto;

--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_DROIT_CONTRAT_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_DROIT_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_DROIT_CONTRAT_ID_seq" OWNED BY "CODE_DROIT_CONTRAT"."ID";


--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_DROIT_CONTRAT_ID_seq"', 4, false);


--
-- Name: CODE_EMPLOI; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_EMPLOI" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CODE" character varying(11) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NOM" character varying(195) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."CODE_EMPLOI" OWNER TO openconcerto;

--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_EMPLOI_ID_seq"
    START WITH 1036
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_EMPLOI_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_EMPLOI_ID_seq" OWNED BY "CODE_EMPLOI"."ID";


--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_EMPLOI_ID_seq"', 1036, false);


--
-- Name: CODE_REGIME; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_REGIME" (
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CODE_REGIME" OWNER TO openconcerto;

--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_REGIME_ID_seq"
    START WITH 23
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_REGIME_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_REGIME_ID_seq" OWNED BY "CODE_REGIME"."ID";


--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_REGIME_ID_seq"', 23, false);


--
-- Name: CODE_STATUT_CATEGORIEL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_CATEGORIEL" (
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CATEGORIEL" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_CATEGORIEL_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CATEGORIEL_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_CATEGORIEL_ID_seq" OWNED BY "CODE_STATUT_CATEGORIEL"."ID";


--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_CATEGORIEL_ID_seq"', 6, false);


--
-- Name: CODE_STATUT_CAT_CONV; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_CAT_CONV" (
    "ID" integer NOT NULL,
    "CODE" character varying(6) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CAT_CONV" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_CAT_CONV_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CAT_CONV_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_CAT_CONV_ID_seq" OWNED BY "CODE_STATUT_CAT_CONV"."ID";


--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_CAT_CONV_ID_seq"', 8, true);


--
-- Name: CODE_STATUT_PROF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_PROF" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."CODE_STATUT_PROF" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_PROF_ID_seq"
    START WITH 51
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_STATUT_PROF_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_PROF_ID_seq" OWNED BY "CODE_STATUT_PROF"."ID";


--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_PROF_ID_seq"', 51, false);


--
-- Name: COMMANDE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE" (
    "ID_USER_COMMON_CREATE" integer,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "T_HT" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ORDRE" numeric(16,8),
    "DATE" date,
    "T_SERVICE" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "T_TTC" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "IDSOURCE" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "EN_COURS" boolean DEFAULT true,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMMANDE" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "T_POIDS" real DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "T_TTC" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "T_HT" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" date,
    "CREATION_DATE" timestamp without time zone,
    "IDSOURCE" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_CLIENT_ELEMENT" (
    "ORDRE" numeric(16,8),
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "T_PA_HT" bigint DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "T_PV_TTC" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "POIDS" real DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "PA_HT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_CLIENT_ELEMENT_ID_seq" OWNED BY "COMMANDE_CLIENT_ELEMENT"."ID";


--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_CLIENT_ELEMENT_ID_seq"', 13, true);


--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_CLIENT_ID_seq" OWNED BY "COMMANDE_CLIENT"."ID";


--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_CLIENT_ID_seq"', 11, true);


--
-- Name: COMMANDE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_ELEMENT" (
    "T_PA_HT" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "T_POIDS" real DEFAULT 0,
    "T_PA_TTC" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "QTE" integer DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMMANDE_ELEMENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_ELEMENT_ID_seq" OWNED BY "COMMANDE_ELEMENT"."ID";


--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_ELEMENT_ID_seq"', 3, true);


--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_ID_seq" OWNED BY "COMMANDE"."ID";


--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_ID_seq"', 3, true);


--
-- Name: COMMERCIAL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMERCIAL" (
    "FONCTION" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "FAX" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "ID_COMMERCIAL" integer NOT NULL,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON" integer DEFAULT 1,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."COMMERCIAL" OWNER TO openconcerto;

--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COMMERCIAL_ID_COMMERCIAL_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMERCIAL_ID_COMMERCIAL_seq" OWNER TO openconcerto;

--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COMMERCIAL_ID_COMMERCIAL_seq" OWNED BY "COMMERCIAL"."ID_COMMERCIAL";


--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMERCIAL_ID_COMMERCIAL_seq"', 3, true);


--
-- Name: COMPLETION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPLETION" (
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "CHAMP" character varying(100) DEFAULT ''::character varying,
    "LABEL" character varying(200) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."COMPLETION" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPTE_PCE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "TOTAL_CREDIT" bigint DEFAULT 0,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TOTAL_DEBIT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "RACINE" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."COMPTE_PCE" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COMPTE_PCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMPTE_PCE_ID_seq" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COMPTE_PCE_ID_seq" OWNED BY "COMPTE_PCE"."ID";


--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMPTE_PCE_ID_seq"', 420, true);


--
-- Name: COMPTE_PCG; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPTE_PCG" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_TYPE_COMPTE_PCG_BASE" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_TYPE_COMPTE_PCG_DEV" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_AB" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMPTE_PCG" OWNER TO openconcerto;

--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COMPTE_PCG_ID_seq"
    START WITH 978
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COMPTE_PCG_ID_seq" OWNED BY "COMPTE_PCG"."ID";


--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMPTE_PCG_ID_seq"', 978, false);


--
-- Name: CONTACT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 2,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "FONCTION" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."CONTACT" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT_ADMINISTRATIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "N4DS" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTACT_ADMINISTRATIF" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_ADMINISTRATIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTACT_ADMINISTRATIF_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_ADMINISTRATIF_ID_seq" OWNED BY "CONTACT_ADMINISTRATIF"."ID";


--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_ADMINISTRATIF_ID_seq"', 1, true);


--
-- Name: CONTACT_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTACT_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTACT_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_FOURNISSEUR_ID_seq" OWNED BY "CONTACT_FOURNISSEUR"."ID";


--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_FOURNISSEUR_ID_seq"', 1, true);


--
-- Name: CONTACT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTACT_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_ID_seq" OWNED BY "CONTACT"."ID";


--
-- Name: CONTACT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_ID_seq"', 7, true);


--
-- Name: CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTRAT_SALARIE" (
    "ID_CODE_STATUT_CATEGORIEL" integer DEFAULT 1,
    "ID_CODE_DROIT_CONTRAT" integer DEFAULT 1,
    "ID_CODE_STATUT_PROF" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CODE_CARACT_ACTIVITE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_CODE_CONTRAT_TRAVAIL" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NATURE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_CODE_EMPLOI" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE_IRC_UGRR" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRR" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_UGRC" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRC" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_RETRAITE" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_RETRAITE" character varying(64) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_STATUT_CAT_CONV" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CONTRAT_SALARIE_ID_seq" OWNED BY "CONTRAT_SALARIE"."ID";


--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTRAT_SALARIE_ID_seq"', 5, true);


--
-- Name: COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COURRIER_CLIENT" (
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE" date,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_MODELE_COURRIER_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer
);


ALTER TABLE "OpenConcerto42"."COURRIER_CLIENT" OWNER TO openconcerto;

--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "COURRIER_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "COURRIER_CLIENT_ID_seq" OWNED BY "COURRIER_CLIENT"."ID";


--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"COURRIER_CLIENT_ID_seq"', 2, false);


--
-- Name: CUMULS_CONGES; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CUMULS_CONGES" (
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "RESTANT" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ACQUIS" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."CUMULS_CONGES" OWNER TO openconcerto;

--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CUMULS_CONGES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CUMULS_CONGES_ID_seq" OWNER TO openconcerto;

--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CUMULS_CONGES_ID_seq" OWNED BY "CUMULS_CONGES"."ID";


--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CUMULS_CONGES_ID_seq"', 35, true);


--
-- Name: CUMULS_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CUMULS_PAYE" (
    "NET_IMP_C" real DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "COT_PAT_C" real DEFAULT 0,
    "COT_SAL_C" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "SAL_BRUT_C" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NET_A_PAYER_C" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "CSG_C" real DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."CUMULS_PAYE" OWNER TO openconcerto;

--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "CUMULS_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CUMULS_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "CUMULS_PAYE_ID_seq" OWNED BY "CUMULS_PAYE"."ID";


--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"CUMULS_PAYE_ID_seq"', 64, true);


--
-- Name: DEPARTEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEPARTEMENT" (
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "NUMERO" character varying(10) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "CHEF_LIEU" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "REGION_ADMIN" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."DEPARTEMENT" OWNER TO openconcerto;

--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "DEPARTEMENT_ID_seq"
    START WITH 102
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "DEPARTEMENT_ID_seq" OWNED BY "DEPARTEMENT"."ID";


--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEPARTEMENT_ID_seq"', 102, false);


--
-- Name: DEVIS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEVIS" (
    "REMISE_HT" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_DEVIS" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "T_TTC" bigint DEFAULT 0,
    "T_HT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" date,
    "DATE_ENVOI" timestamp without time zone,
    "ID_ETAT_DEVIS" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_SERVICE" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "T_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "OBJET" character varying(100) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1 NOT NULL,
    "DATE_VALIDITE" date,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."DEVIS" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEVIS_ELEMENT" (
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "T_PA_HT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(45) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_DEVIS" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_DEVIS_ELEMENT" integer NOT NULL,
    "T_PV_HT" bigint DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SERVICE" boolean DEFAULT false,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "QTE" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."DEVIS_ELEMENT" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNED BY "DEVIS_ELEMENT"."ID_DEVIS_ELEMENT";


--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"', 43, true);


--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "DEVIS_ID_DEVIS_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEVIS_ID_DEVIS_seq" OWNER TO openconcerto;

--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "DEVIS_ID_DEVIS_seq" OWNED BY "DEVIS"."ID_DEVIS";


--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEVIS_ID_DEVIS_seq"', 33, true);


--
-- Name: ECHANTILLON_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHANTILLON_ELEMENT" (
    "ID_TAXE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "T_PV_TTC" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "QTE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PV_HT" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."ECHANTILLON_ELEMENT" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ECHANTILLON_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECHANTILLON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ECHANTILLON_ELEMENT_ID_seq" OWNED BY "ECHANTILLON_ELEMENT"."ID";


--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHANTILLON_ELEMENT_ID_seq"', 2, false);


--
-- Name: ECHEANCE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHEANCE_CLIENT" (
    "REGLE" boolean DEFAULT false,
    "DATE" date,
    "NOMBRE_RELANCE" integer DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "MONTANT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_LAST_RELANCE" date,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."ECHEANCE_CLIENT" OWNER TO openconcerto;

--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ECHEANCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECHEANCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ECHEANCE_CLIENT_ID_seq" OWNED BY "ECHEANCE_CLIENT"."ID";


--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHEANCE_CLIENT_ID_seq"', 19, true);


--
-- Name: ECHEANCE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHEANCE_FOURNISSEUR" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "REGLE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."ECHEANCE_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ECHEANCE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECHEANCE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ECHEANCE_FOURNISSEUR_ID_seq" OWNED BY "ECHEANCE_FOURNISSEUR"."ID";


--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHEANCE_FOURNISSEUR_ID_seq"', 2, false);


--
-- Name: ECRITURE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECRITURE" (
    "DATE_POINTEE" date,
    "ID" integer NOT NULL,
    "DATE" date,
    "DEBIT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREDIT" bigint DEFAULT 0,
    "DATE_VALIDE" date,
    "JOURNAL_CODE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_JOURNAL" integer DEFAULT 1,
    "IDUSER_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "DATE_LETTRAGE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "LETTRAGE" character varying(256) DEFAULT ''::character varying,
    "COMPTE_NOM" character varying(2048) DEFAULT ''::text,
    "JOURNAL_NOM" character varying(2048) DEFAULT ''::text,
    "IDUSER_VALIDE" integer DEFAULT 1,
    "VALIDE" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "POINTEE" character varying(45) DEFAULT ''::character varying,
    "COMPTE_NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "IDUSER_DELETE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."ECRITURE" OWNER TO openconcerto;

--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ECRITURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECRITURE_ID_seq" OWNER TO openconcerto;

--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ECRITURE_ID_seq" OWNED BY "ECRITURE"."ID";


--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECRITURE_ID_seq"', 252, true);


--
-- Name: EMPLOYEUR_MULTIPLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "EMPLOYEUR_MULTIPLE" (
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."EMPLOYEUR_MULTIPLE" OWNER TO openconcerto;

--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "EMPLOYEUR_MULTIPLE_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."EMPLOYEUR_MULTIPLE_ID_seq" OWNER TO openconcerto;

--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "EMPLOYEUR_MULTIPLE_ID_seq" OWNED BY "EMPLOYEUR_MULTIPLE"."ID";


--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"EMPLOYEUR_MULTIPLE_ID_seq"', 5, false);


--
-- Name: ENCAISSER_MONTANT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ENCAISSER_MONTANT" (
    "ID_MOUVEMENT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "NOM" character varying(200),
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" date,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ENCAISSER_MONTANT_ELEMENT" (
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_ENCAISSER_MONTANT" integer DEFAULT 1,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ENCAISSER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNED BY "ENCAISSER_MONTANT_ELEMENT"."ID";


--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ENCAISSER_MONTANT_ELEMENT_ID_seq"', 9, true);


--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ENCAISSER_MONTANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ENCAISSER_MONTANT_ID_seq" OWNED BY "ENCAISSER_MONTANT"."ID";


--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ENCAISSER_MONTANT_ID_seq"', 28, true);


--
-- Name: ETAT_CIVIL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_CIVIL" (
    "ARCHIVE" integer DEFAULT 0,
    "NB_PERS_A_CHARGE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "NB_ENFANTS" integer DEFAULT 0,
    "TELEPHONE" character varying(45) DEFAULT ''::character varying,
    "DATE_NAISSANCE" date,
    "ID_ADRESSE" integer DEFAULT 1,
    "COMMUNE_NAISSANCE" character varying(45) DEFAULT ''::character varying,
    "ID_SITUATION_FAMILIALE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_PAYS_NAISSANCE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "PORTABLE" character varying(45) DEFAULT ''::character varying,
    "MAIL" character varying(45) DEFAULT ''::character varying,
    "ID_DEPARTEMENT_NAISSANCE" integer DEFAULT 1,
    "NUMERO_SS" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."ETAT_CIVIL" OWNER TO openconcerto;

--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_CIVIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_CIVIL_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_CIVIL_ID_seq" OWNED BY "ETAT_CIVIL"."ID";


--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_CIVIL_ID_seq"', 5, true);


--
-- Name: ETAT_DEVIS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_DEVIS" (
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."ETAT_DEVIS" OWNER TO openconcerto;

--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_DEVIS_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_DEVIS_ID_seq" OWNED BY "ETAT_DEVIS"."ID";


--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_DEVIS_ID_seq"', 5, true);


--
-- Name: ETAT_RAPPORT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_RAPPORT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048),
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."ETAT_RAPPORT" OWNER TO openconcerto;

--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_RAPPORT_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_RAPPORT_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_RAPPORT_ID_seq" OWNED BY "ETAT_RAPPORT"."ID";


--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_RAPPORT_ID_seq"', 3, false);


--
-- Name: FAMILLE_ARTICLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FAMILLE_ARTICLE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FAMILLE_ARTICLE_PERE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."FAMILLE_ARTICLE" OWNER TO openconcerto;

--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "FAMILLE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FAMILLE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "FAMILLE_ARTICLE_ID_seq" OWNED BY "FAMILLE_ARTICLE"."ID";


--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"FAMILLE_ARTICLE_ID_seq"', 10, true);


--
-- Name: FICHE_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FICHE_PAYE" (
    "ACOMPTE" real DEFAULT 0,
    "NET_IMP" real DEFAULT 0,
    "CONGES_ACQUIS" real DEFAULT 0,
    "NATURE_EMPLOI" character varying(150) DEFAULT ''::character varying,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "ID_IDCC" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "DU" date,
    "ORDRE" numeric(16,8),
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "COT_PAT" real DEFAULT 0,
    "ANNEE" integer DEFAULT 0,
    "AU" date,
    "CREATION_DATE" timestamp without time zone,
    "NET_A_PAYER" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "SAL_BRUT" real DEFAULT 0,
    "VALIDE" boolean DEFAULT false,
    "CSG" real DEFAULT 0,
    "COT_SAL" real DEFAULT 0,
    "ID_MOIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_SALARIE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_PROFIL_PAYE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."FICHE_PAYE" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FICHE_PAYE_ELEMENT" (
    "IN_PERIODE" boolean DEFAULT true,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "VALIDE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "TAUX_PAT" real,
    "IMPRESSION" boolean DEFAULT true,
    "MONTANT_SAL_AJ" real,
    "CREATION_DATE" timestamp without time zone,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "TAUX_SAL" real,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MONTANT_SAL_DED" real,
    "ORDRE" numeric(16,8),
    "NB_BASE" real,
    "IDSOURCE" integer DEFAULT 1,
    "POSITION" integer DEFAULT 0,
    "MONTANT_PAT" real
);


ALTER TABLE "OpenConcerto42"."FICHE_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "FICHE_PAYE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FICHE_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "FICHE_PAYE_ELEMENT_ID_seq" OWNED BY "FICHE_PAYE_ELEMENT"."ID";


--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"FICHE_PAYE_ELEMENT_ID_seq"', 895, true);


--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "FICHE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FICHE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "FICHE_PAYE_ID_seq" OWNED BY "FICHE_PAYE"."ID";


--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"FICHE_PAYE_ID_seq"', 35, true);


--
-- Name: FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FOURNISSEUR" (
    "CREATION_DATE" timestamp without time zone,
    "CODE" character varying(2048) DEFAULT ''::text,
    "UE" boolean DEFAULT false,
    "TYPE" character varying(2048) DEFAULT ''::text,
    "TEL" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_E" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "FAX" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "RESPONSABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_P" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_CHARGE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "FOURNISSEUR_ID_FOURNISSEUR_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNER TO openconcerto;

--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "FOURNISSEUR_ID_FOURNISSEUR_seq" OWNED BY "FOURNISSEUR"."ID_FOURNISSEUR";


--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"FOURNISSEUR_ID_FOURNISSEUR_seq"', 2, true);


--
-- Name: FWK_MODULE_METADATA; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_MODULE_METADATA" (
    "ID" integer NOT NULL,
    "MODULE_NAME" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128),
    "FIELD" character varying(128),
    "KEY" boolean,
    "MODULE_VERSION" bigint NOT NULL
);


ALTER TABLE "OpenConcerto42"."FWK_MODULE_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "FWK_MODULE_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FWK_MODULE_METADATA_ID_seq" OWNER TO openconcerto;

--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "FWK_MODULE_METADATA_ID_seq" OWNED BY "FWK_MODULE_METADATA"."ID";


--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"FWK_MODULE_METADATA_ID_seq"', 25, true);


--
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_SCHEMA_METADATA" (
    "VALUE" character varying(250) DEFAULT ''::character varying,
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_UNDEFINED_IDS" (
    "UNDEFINED_ID" integer DEFAULT 0,
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- Name: IDCC; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "IDCC" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."IDCC" OWNER TO openconcerto;

--
-- Name: IDCC_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "IDCC_ID_seq"
    START WITH 996
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."IDCC_ID_seq" OWNER TO openconcerto;

--
-- Name: IDCC_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "IDCC_ID_seq" OWNED BY "IDCC"."ID";


--
-- Name: IDCC_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"IDCC_ID_seq"', 996, false);


--
-- Name: INFOS_SALARIE_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "INFOS_SALARIE_PAYE" (
    "DUREE_MOIS" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_CLASSEMENT_CONVENTIONNEL" integer DEFAULT 1,
    "DATE_SORTIE" date,
    "SALAIRE_MOIS" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CONTRAT_SALARIE" integer DEFAULT 1,
    "TAUX_AT" real DEFAULT 0,
    "DATE_ARRIVE" date,
    "DUREE_HEBDO" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CONGES_PAYES" real DEFAULT 0,
    "ID_IDCC" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CODE_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "CODE_SECTION_AT" character varying(18) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."INFOS_SALARIE_PAYE" OWNER TO openconcerto;

--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "INFOS_SALARIE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."INFOS_SALARIE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "INFOS_SALARIE_PAYE_ID_seq" OWNED BY "INFOS_SALARIE_PAYE"."ID";


--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"INFOS_SALARIE_PAYE_ID_seq"', 5, true);


--
-- Name: JOURNAL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "JOURNAL" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "TYPE_BANQUE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "PAR_DEFAUT" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer
);


ALTER TABLE "OpenConcerto42"."JOURNAL" OWNER TO openconcerto;

--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "JOURNAL_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "JOURNAL_ID_seq" OWNED BY "JOURNAL"."ID";


--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"JOURNAL_ID_seq"', 7, false);


--
-- Name: LANGUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "LANGUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CHEMIN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."LANGUE" OWNER TO openconcerto;

--
-- Name: LANGUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "LANGUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."LANGUE_ID_seq" OWNER TO openconcerto;

--
-- Name: LANGUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "LANGUE_ID_seq" OWNED BY "LANGUE"."ID";


--
-- Name: LANGUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"LANGUE_ID_seq"', 7, true);


--
-- Name: LEAD; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "LEAD" (
    "ID" integer NOT NULL,
    "NUMBER" character varying(20) DEFAULT ''::character varying NOT NULL,
    "DATE" timestamp without time zone,
    "FIRSTNAME" character varying(64) DEFAULT ''::character varying NOT NULL,
    "NAME" character varying(64) DEFAULT ''::character varying NOT NULL,
    "COMPANY" character varying(64) DEFAULT ''::character varying NOT NULL,
    "PHONE" character varying(16) DEFAULT ''::character varying NOT NULL,
    "MOBILE" character varying(16) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(16) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(32) DEFAULT ''::character varying NOT NULL,
    "WEBSITE" character varying(64) DEFAULT ''::character varying NOT NULL,
    "SOURCE" character varying(200) DEFAULT ''::character varying NOT NULL,
    "STATUS" character varying(50) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "INFORMATION" character varying(512) DEFAULT ''::character varying NOT NULL,
    "INDUSTRY" character varying(200) DEFAULT ''::character varying NOT NULL,
    "RATING" character varying(200) DEFAULT ''::character varying NOT NULL,
    "REVENUE" integer DEFAULT 0 NOT NULL,
    "EMPLOYEES" integer DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."LEAD" OWNER TO openconcerto;

--
-- Name: LEAD_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "LEAD_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."LEAD_ID_seq" OWNER TO openconcerto;

--
-- Name: LEAD_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "LEAD_ID_seq" OWNED BY "LEAD"."ID";


--
-- Name: LEAD_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"LEAD_ID_seq"', 1, false);


--
-- Name: METRIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "METRIQUE" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "UNITE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."METRIQUE" OWNER TO openconcerto;

--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "METRIQUE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."METRIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "METRIQUE_ID_seq" OWNED BY "METRIQUE"."ID";


--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"METRIQUE_ID_seq"', 4, false);


--
-- Name: MODELE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TYPE_MODELE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."MODELE" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODELE_COURRIER_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CODE" character varying(10) DEFAULT ''::character varying,
    "LOCATION" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CONTENU" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."MODELE_COURRIER_CLIENT" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MODELE_COURRIER_CLIENT_ID_seq"
    START WITH 10
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODELE_COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MODELE_COURRIER_CLIENT_ID_seq" OWNED BY "MODELE_COURRIER_CLIENT"."ID";


--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODELE_COURRIER_CLIENT_ID_seq"', 10, false);


--
-- Name: MODELE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODELE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MODELE_ID_seq" OWNED BY "MODELE"."ID";


--
-- Name: MODELE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODELE_ID_seq"', 1, true);


--
-- Name: MODE_REGLEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_REGLEMENT" (
    "DATE_FACTURE" boolean DEFAULT false,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "DATE" date,
    "COMPTANT" boolean DEFAULT false,
    "ID_MODE_REGLEMENT" integer NOT NULL,
    "LENJOUR" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(2048) DEFAULT ''::text,
    "AJOURS" integer DEFAULT 0,
    "DATE_VIREMENT" date,
    "ORDRE" numeric(16,8),
    "DATE_DEPOT" date,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "FIN_MOIS" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNED BY "MODE_REGLEMENT"."ID_MODE_REGLEMENT";


--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"', 79, true);


--
-- Name: MODE_REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_REGLEMENT_PAYE" (
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MODE_REGLEMENT_PAYE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MODE_REGLEMENT_PAYE_ID_seq" OWNED BY "MODE_REGLEMENT_PAYE"."ID";


--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_REGLEMENT_PAYE_ID_seq"', 4, false);


--
-- Name: MODE_VENTE_ARTICLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_VENTE_ARTICLE" (
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0.00000000,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."MODE_VENTE_ARTICLE" OWNER TO openconcerto;

--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MODE_VENTE_ARTICLE_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODE_VENTE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MODE_VENTE_ARTICLE_ID_seq" OWNED BY "MODE_VENTE_ARTICLE"."ID";


--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_VENTE_ARTICLE_ID_seq"', 7, false);


--
-- Name: MOIS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOIS" (
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."MOIS" OWNER TO openconcerto;

--
-- Name: MOIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MOIS_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MOIS_ID_seq" OWNER TO openconcerto;

--
-- Name: MOIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MOIS_ID_seq" OWNED BY "MOIS"."ID";


--
-- Name: MOIS_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOIS_ID_seq"', 14, false);


--
-- Name: MOUVEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOUVEMENT" (
    "ID_MOUVEMENT_PERE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_PIECE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "NUMERO" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "SOURCE" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."MOUVEMENT" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MOUVEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MOUVEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MOUVEMENT_ID_seq" OWNED BY "MOUVEMENT"."ID";


--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOUVEMENT_ID_seq"', 100, true);


--
-- Name: MOUVEMENT_STOCK; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOUVEMENT_STOCK" (
    "QTE" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "NUMERO" character varying(150) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "DATE" date
);


ALTER TABLE "OpenConcerto42"."MOUVEMENT_STOCK" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "MOUVEMENT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MOUVEMENT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "MOUVEMENT_STOCK_ID_seq" OWNED BY "MOUVEMENT_STOCK"."ID";


--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOUVEMENT_STOCK_ID_seq"', 72, true);


--
-- Name: NATURE_COMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "NATURE_COMPTE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."NATURE_COMPTE" OWNER TO openconcerto;

--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "NATURE_COMPTE_ID_seq"
    START WITH 13
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."NATURE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "NATURE_COMPTE_ID_seq" OWNED BY "NATURE_COMPTE"."ID";


--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"NATURE_COMPTE_ID_seq"', 13, false);


--
-- Name: NUMEROTATION_AUTO; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "NUMEROTATION_AUTO" (
    "FACT_START" integer DEFAULT 1,
    "AFFAIRE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "RELANCE_START" integer DEFAULT 0,
    "SALARIE_START" integer DEFAULT 1,
    "FACT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "DEVIS_FORMAT" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "AFFAIRE_START" integer DEFAULT 0,
    "CODE_LETTRAGE" character varying(128) DEFAULT 'AAA'::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SALARIE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_L_START" integer DEFAULT 1,
    "AVOIR_START" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "RELANCE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "PROPOSITION_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_CLIENT_START" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "AVOIR_FORMAT" character varying(45) DEFAULT ''::character varying,
    "PROPOSITION_START" integer DEFAULT 0,
    "BON_R_START" integer DEFAULT 0,
    "BON_R_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_CLIENT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_START" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "BON_L_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_START" integer DEFAULT 1,
    "COURRIER_FORMAT" character varying(45) DEFAULT ''::character varying,
    "DEVIS_START" integer DEFAULT 1,
    "AVOIR_F_START" integer DEFAULT 0,
    "AVOIR_F_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."NUMEROTATION_AUTO" OWNER TO openconcerto;

--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "NUMEROTATION_AUTO_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."NUMEROTATION_AUTO_ID_seq" OWNER TO openconcerto;

--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "NUMEROTATION_AUTO_ID_seq" OWNED BY "NUMEROTATION_AUTO"."ID";


--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"NUMEROTATION_AUTO_ID_seq"', 3, false);


--
-- Name: OBJECTIF_COMMERCIAL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "OBJECTIF_COMMERCIAL" (
    "ID" integer NOT NULL,
    "MOIS" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ANNEE" integer,
    "MARGE_HT" bigint DEFAULT 0,
    "POURCENT_MARGE" numeric(16,8),
    "CHIFFRE_AFFAIRE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."OBJECTIF_COMMERCIAL" OWNER TO openconcerto;

--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OBJECTIF_COMMERCIAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."OBJECTIF_COMMERCIAL_ID_seq" OWNER TO openconcerto;

--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OBJECTIF_COMMERCIAL_ID_seq" OWNED BY "OBJECTIF_COMMERCIAL"."ID";


--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"OBJECTIF_COMMERCIAL_ID_seq"', 1, true);


--
-- Name: PAYS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PAYS" (
    "CODE" character varying(15) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(50) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ID_TARIF" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."PAYS" OWNER TO openconcerto;

--
-- Name: PAYS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "PAYS_ID_seq"
    START WITH 194
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PAYS_ID_seq" OWNER TO openconcerto;

--
-- Name: PAYS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "PAYS_ID_seq" OWNED BY "PAYS"."ID";


--
-- Name: PAYS_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"PAYS_ID_seq"', 194, false);


--
-- Name: PIECE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PIECE" (
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."PIECE" OWNER TO openconcerto;

--
-- Name: PIECE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "PIECE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PIECE_ID_seq" OWNER TO openconcerto;

--
-- Name: PIECE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "PIECE_ID_seq" OWNED BY "PIECE"."ID";


--
-- Name: PIECE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"PIECE_ID_seq"', 44, true);


--
-- Name: POSTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "POSTE_ANALYTIQUE" (
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."POSTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "POSTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."POSTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "POSTE_ANALYTIQUE_ID_seq" OWNED BY "POSTE_ANALYTIQUE"."ID";


--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"POSTE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: PREFERENCES; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREFERENCES" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "VALUE" character varying(2048),
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NAME" character varying(2048)
);


ALTER TABLE "OpenConcerto42"."PREFERENCES" OWNER TO openconcerto;

--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "PREFERENCES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PREFERENCES_ID_seq" OWNER TO openconcerto;

--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "PREFERENCES_ID_seq" OWNED BY "PREFERENCES"."ID";


--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREFERENCES_ID_seq"', 4, true);


--
-- Name: PREFS_COMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREFS_COMPTE" (
    "ID_COMPTE_PCE_TVA_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_IMMO" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT_PERTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_F" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_O" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_ACHAT_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE_REGL" integer DEFAULT 1,
    "ID_JOURNAL_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE_PAYE" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_VENTE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."PREFS_COMPTE" OWNER TO openconcerto;

--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "PREFS_COMPTE_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PREFS_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "PREFS_COMPTE_ID_seq" OWNED BY "PREFS_COMPTE"."ID";


--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREFS_COMPTE_ID_seq"', 3, false);


--
-- Name: PREF_NODE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREF_NODE" (
    "ID" integer NOT NULL,
    "ID_PARENT" integer,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."PREF_NODE" OWNER TO openconcerto;

--
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "PREF_NODE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PREF_NODE_ID_seq" OWNER TO openconcerto;

--
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "PREF_NODE_ID_seq" OWNED BY "PREF_NODE"."ID";


--
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREF_NODE_ID_seq"', 1, false);


--
-- Name: PREF_VALUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREF_VALUE" (
    "ID_NODE" integer NOT NULL,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(8192) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."PREF_VALUE" OWNER TO openconcerto;

--
-- Name: REFERENCE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REFERENCE_CLIENT" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."REFERENCE_CLIENT" OWNER TO openconcerto;

--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "REFERENCE_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REFERENCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "REFERENCE_CLIENT_ID_seq" OWNED BY "REFERENCE_CLIENT"."ID";


--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"REFERENCE_CLIENT_ID_seq"', 2, false);


--
-- Name: REGIME_BASE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGIME_BASE" (
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_CODE_REGIME_MALADIE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CODE_REGIME_VIEL_P" integer DEFAULT 1,
    "ID_CODE_REGIME_AT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_REGIME_VIEL_S" integer DEFAULT 1,
    "ID_CODE_REGIME_BASE" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."REGIME_BASE" OWNER TO openconcerto;

--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "REGIME_BASE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REGIME_BASE_ID_seq" OWNER TO openconcerto;

--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "REGIME_BASE_ID_seq" OWNED BY "REGIME_BASE"."ID";


--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGIME_BASE_ID_seq"', 2, false);


--
-- Name: REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGLEMENT_PAYE" (
    "ID" integer NOT NULL,
    "LE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "NOM_BANQUE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_MODE_REGLEMENT_PAYE" integer DEFAULT 1,
    "RIB" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "REGLEMENT_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "REGLEMENT_PAYE_ID_seq" OWNED BY "REGLEMENT_PAYE"."ID";


--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGLEMENT_PAYE_ID_seq"', 35, true);


--
-- Name: REGLER_MONTANT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGLER_MONTANT" (
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."REGLER_MONTANT" OWNER TO openconcerto;

--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "REGLER_MONTANT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REGLER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "REGLER_MONTANT_ID_seq" OWNED BY "REGLER_MONTANT"."ID";


--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGLER_MONTANT_ID_seq"', 2, false);


--
-- Name: RELANCE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RELANCE" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TYPE_LETTRE_RELANCE" integer DEFAULT 1,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."RELANCE" OWNER TO openconcerto;

--
-- Name: RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "RELANCE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."RELANCE_ID_seq" OWNER TO openconcerto;

--
-- Name: RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "RELANCE_ID_seq" OWNED BY "RELANCE"."ID";


--
-- Name: RELANCE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"RELANCE_ID_seq"', 2, true);


--
-- Name: REPARTITION_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REPARTITION_ANALYTIQUE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REPARTITION_ANALYTIQUE_ELEMENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "TAUX" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNED BY "REPARTITION_ANALYTIQUE_ELEMENT"."ID";


--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"', 2, false);


--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "REPARTITION_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "REPARTITION_ANALYTIQUE_ID_seq" OWNED BY "REPARTITION_ANALYTIQUE"."ID";


--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"REPARTITION_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: SAISIE_ACHAT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_ACHAT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "IMMO" boolean DEFAULT false,
    "MONTANT_HT" bigint DEFAULT 0,
    "NUMERO_COMMANDE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "DATE" date,
    "MONTANT_TVA" bigint DEFAULT 0,
    "NUMERO_FACTURE" character varying(2048) DEFAULT ''::text,
    "IDSOURCE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."SAISIE_ACHAT" OWNER TO openconcerto;

--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_ACHAT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_ACHAT_ID_seq" OWNED BY "SAISIE_ACHAT"."ID";


--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_ACHAT_ID_seq"', 3, true);


--
-- Name: SAISIE_KM; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_KM" (
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE" date,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ID_JOURNAL" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."SAISIE_KM" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_KM_ELEMENT" (
    "ID" integer NOT NULL,
    "CREDIT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM_ECRITURE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NUMERO" character varying(100) DEFAULT ''::character varying,
    "ID_ECRITURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_SAISIE_KM" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "DEBIT" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."SAISIE_KM_ELEMENT" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_KM_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_KM_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_KM_ELEMENT_ID_seq" OWNED BY "SAISIE_KM_ELEMENT"."ID";


--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_KM_ELEMENT_ID_seq"', 2, false);


--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_KM_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_KM_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_KM_ID_seq" OWNED BY "SAISIE_KM"."ID";


--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_KM_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_COMPTOIR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_COMPTOIR" (
    "CREATION_DATE" timestamp without time zone,
    "ECHEANCE" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_COMPTOIR" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_COMPTOIR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_COMPTOIR_ID_seq" OWNED BY "SAISIE_VENTE_COMPTOIR"."ID";


--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_COMPTOIR_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_FACTURE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_FACTURE" (
    "PREVISIONNELLE" boolean DEFAULT false,
    "IDSOURCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "POURCENT_ACOMPTE" real DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "DATE_REGLEMENT" timestamp without time zone,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ID_ADRESSE" integer DEFAULT 1,
    "T_AVOIR_TTC" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "COMPLEMENT" boolean DEFAULT false,
    "T_TTC" bigint DEFAULT 0,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "T_TVA" bigint DEFAULT 0,
    "DATE_ENVOI_AFFACTURAGE" date,
    "T_POIDS" real DEFAULT 0,
    "DATE_ENVOI" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "TYPE_INTERVENTION" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_MOIS_CCIP" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "AFFACTURAGE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "NOM" character varying(250) DEFAULT ''::character varying,
    "T_HA" bigint DEFAULT 0,
    "REF_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "ID_REFERENCE_CLIENT" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "CONTROLE_TECHNIQUE" boolean DEFAULT false,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_TAXE_PORT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_FACTURE_ELEMENT" (
    "T_PA_HT" bigint DEFAULT 0,
    "Q18" boolean DEFAULT false,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "INDICE_0" bigint DEFAULT 0,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "TARIF_Q18_HT" bigint DEFAULT 0,
    "POURCENT_CCIP" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_CONTACT" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "QTE_LIVREE" integer DEFAULT 0,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "POIDS" real DEFAULT 0,
    "LIVREE" boolean DEFAULT false,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "T_PV_HT" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "T_PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "MONTANT_INITIAL" bigint DEFAULT 0,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "INDICE_N" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_STYLE" integer DEFAULT 1,
    "REPARTITION_POURCENT" numeric(6,2) DEFAULT 0 NOT NULL,
    "DATE_FIN" timestamp without time zone,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "DATE" date,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "ACOMPTE" boolean DEFAULT false,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNED BY "SAISIE_VENTE_FACTURE_ELEMENT"."ID";


--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"', 41, true);


--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "SAISIE_VENTE_FACTURE"."ID";


--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_FACTURE_ID_seq"', 34, true);


--
-- Name: SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SALARIE" (
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "PRENOM" character varying(45) DEFAULT ''::character varying,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "DERNIER_MOIS" integer DEFAULT 0,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "DERNIERE_ANNEE" integer DEFAULT 0,
    "NOM_JEUNE_FILLE" character varying(45) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_ETAT_CIVIL" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer
);


ALTER TABLE "OpenConcerto42"."SALARIE" OWNER TO openconcerto;

--
-- Name: SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SALARIE_ID_seq" OWNED BY "SALARIE"."ID";


--
-- Name: SALARIE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SALARIE_ID_seq"', 5, true);


--
-- Name: SITUATION_FAMILIALE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SITUATION_FAMILIALE" (
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."SITUATION_FAMILIALE" OWNER TO openconcerto;

--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "SITUATION_FAMILIALE_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SITUATION_FAMILIALE_ID_seq" OWNER TO openconcerto;

--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "SITUATION_FAMILIALE_ID_seq" OWNED BY "SITUATION_FAMILIALE"."ID";


--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"SITUATION_FAMILIALE_ID_seq"', 7, false);


--
-- Name: STOCK; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "STOCK" (
    "QTE_REEL" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "QTE_TH" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."STOCK" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "STOCK_ID_seq" OWNED BY "STOCK"."ID";


--
-- Name: STOCK_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"STOCK_ID_seq"', 22, true);


--
-- Name: STYLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "STYLE" (
    "ID_STYLE" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."STYLE" OWNER TO openconcerto;

--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "STYLE_ID_STYLE_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."STYLE_ID_STYLE_seq" OWNER TO openconcerto;

--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "STYLE_ID_STYLE_seq" OWNED BY "STYLE"."ID_STYLE";


--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"STYLE_ID_STYLE_seq"', 5, false);


--
-- Name: TARIF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TARIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."TARIF" OWNER TO openconcerto;

--
-- Name: TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TARIF_ID_seq" OWNER TO openconcerto;

--
-- Name: TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "TARIF_ID_seq" OWNED BY "TARIF"."ID";


--
-- Name: TARIF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"TARIF_ID_seq"', 1, true);


--
-- Name: TAXE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TAXE" (
    "CODE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TAXE" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "TAUX" real DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_COMPTE_PCE_COLLECTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_DED" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TAXE" OWNER TO openconcerto;

--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "TAXE_ID_TAXE_seq"
    START WITH 6
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TAXE_ID_TAXE_seq" OWNER TO openconcerto;

--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "TAXE_ID_TAXE_seq" OWNED BY "TAXE"."ID_TAXE";


--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"TAXE_ID_TAXE_seq"', 6, true);


--
-- Name: TICKET_CAISSE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TICKET_CAISSE" (
    "DATE" timestamp without time zone,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "TOTAL_TVA" bigint DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "TOTAL_HT" bigint DEFAULT 0,
    "TOTAL_TTC" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_CAISSE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_MOUVEMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TICKET_CAISSE" OWNER TO openconcerto;

--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "TICKET_CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TICKET_CAISSE_ID_seq" OWNER TO openconcerto;

--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "TICKET_CAISSE_ID_seq" OWNED BY "TICKET_CAISSE"."ID";


--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"TICKET_CAISSE_ID_seq"', 1, true);


--
-- Name: TITRE_PERSONNEL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TITRE_PERSONNEL" (
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "SEXE_M" boolean DEFAULT true,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(8) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."TITRE_PERSONNEL" OWNER TO openconcerto;

--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "TITRE_PERSONNEL_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TITRE_PERSONNEL_ID_seq" OWNER TO openconcerto;

--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "TITRE_PERSONNEL_ID_seq" OWNED BY "TITRE_PERSONNEL"."ID";


--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"TITRE_PERSONNEL_ID_seq"', 5, false);


--
-- Name: TYPE_COMPTE_PCG; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_COMPTE_PCG" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "RACINE" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto42"."TYPE_COMPTE_PCG" OWNER TO openconcerto;

--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_COMPTE_PCG_ID_seq"
    START WITH 8
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TYPE_COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_COMPTE_PCG_ID_seq" OWNED BY "TYPE_COMPTE_PCG"."ID";


--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_COMPTE_PCG_ID_seq"', 8, false);


--
-- Name: TYPE_LETTRE_RELANCE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_LETTRE_RELANCE" (
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "MODELE" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."TYPE_LETTRE_RELANCE" OWNER TO openconcerto;

--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_LETTRE_RELANCE_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TYPE_LETTRE_RELANCE_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_LETTRE_RELANCE_ID_seq" OWNED BY "TYPE_LETTRE_RELANCE"."ID";


--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_LETTRE_RELANCE_ID_seq"', 3, false);


--
-- Name: TYPE_REGLEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_REGLEMENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURN" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ECHEANCE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "COMPTANT" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto42"."TYPE_REGLEMENT" OWNER TO openconcerto;

--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_REGLEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TYPE_REGLEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_REGLEMENT_ID_seq" OWNED BY "TYPE_REGLEMENT"."ID";


--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_REGLEMENT_ID_seq"', 9, true);


--
-- Name: UNITE_VENTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "UNITE_VENTE" (
    "ID" integer NOT NULL,
    "CODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "A_LA_PIECE" boolean DEFAULT false,
    "INFOS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."UNITE_VENTE" OWNER TO openconcerto;

--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "UNITE_VENTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."UNITE_VENTE_ID_seq" OWNER TO openconcerto;

--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "UNITE_VENTE_ID_seq" OWNED BY "UNITE_VENTE"."ID";


--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"UNITE_VENTE_ID_seq"', 10, true);


--
-- Name: VARIABLE_SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "VARIABLE_SALARIE" (
    "HEURE_TRAV" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CONGES_PRIS" real DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "HEURE_150" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "HEURE_200" real DEFAULT 0,
    "HEURE_110" real DEFAULT 0,
    "HEURE_ABS" real DEFAULT 0,
    "HEURE_125" real DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."VARIABLE_SALARIE" OWNER TO openconcerto;

--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "VARIABLE_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."VARIABLE_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "VARIABLE_SALARIE_ID_seq" OWNED BY "VARIABLE_SALARIE"."ID";


--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto42; Owner: openconcerto
--

SELECT pg_catalog.setval('"VARIABLE_SALARIE_ID_seq"', 35, true);


SET search_path = "OpenConcerto48", pg_catalog;

--
-- Name: ACOMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ACOMPTE" (
    "ID_SALARIE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "MONTANT" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ACOMPTE" OWNER TO openconcerto;

--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ACOMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ACOMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ACOMPTE_ID_seq" OWNED BY "ACOMPTE"."ID";


--
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ACOMPTE_ID_seq"', 2, false);


--
-- Name: ADRESSE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ADRESSE" (
    "RUE" character varying(2048) DEFAULT ''::text,
    "CODE_POSTAL" integer DEFAULT 0,
    "CEDEX" integer,
    "DEST" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PAYS" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "HAS_CEDEX" boolean DEFAULT false,
    "VILLE" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."ADRESSE" OWNER TO openconcerto;

--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ADRESSE_ID_ADRESSE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ADRESSE_ID_ADRESSE_seq" OWNER TO openconcerto;

--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ADRESSE_ID_ADRESSE_seq" OWNED BY "ADRESSE"."ID_ADRESSE";


--
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ADRESSE_ID_ADRESSE_seq"', 9, false);


--
-- Name: ARTICLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE" (
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "CREATION_AUTO" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "PV_TTC" bigint DEFAULT 0,
    "ID_STOCK" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "PV_HT" bigint DEFAULT 0,
    "PA_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "OBSOLETE" boolean DEFAULT false,
    "POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "GESTION_STOCK" boolean DEFAULT true,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE_MIN" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_PAYS" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2
);


ALTER TABLE "OpenConcerto48"."ARTICLE" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE_DESIGNATION" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."ARTICLE_DESIGNATION" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_DESIGNATION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_DESIGNATION_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_DESIGNATION_ID_seq" OWNED BY "ARTICLE_DESIGNATION"."ID";


--
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_DESIGNATION_ID_seq"', 1, true);


--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_ID_seq" OWNED BY "ARTICLE"."ID";


--
-- Name: ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_ID_seq"', 2, false);


--
-- Name: ARTICLE_TARIF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ARTICLE_TARIF" (
    "ID" integer NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_TARIF" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."ARTICLE_TARIF" OWNER TO openconcerto;

--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ARTICLE_TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_TARIF_ID_seq" OWNER TO openconcerto;

--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ARTICLE_TARIF_ID_seq" OWNED BY "ARTICLE_TARIF"."ID";


--
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ARTICLE_TARIF_ID_seq"', 1, true);


--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ASSOCIATION_COMPTE_ANALYTIQUE" (
    "ORDRE" numeric(16,8),
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNED BY "ASSOCIATION_COMPTE_ANALYTIQUE"."ID";


--
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_CLIENT" (
    "MONTANT_TTC" bigint DEFAULT 0,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "MONTANT_RESTANT" bigint DEFAULT 0,
    "AFFACTURAGE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "MONTANT_TVA" bigint DEFAULT 0,
    "MONTANT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "SOLDE" boolean DEFAULT false,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_ENVOI_AFFACTURAGE" date,
    "MONTANT_SOLDE" bigint DEFAULT 0,
    "MOTIF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "A_DEDUIRE" boolean DEFAULT false,
    "PORT_HT" bigint DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "AFFACTURE" boolean DEFAULT false,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_CLIENT_ELEMENT" (
    "CODE" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "Q18" boolean DEFAULT false,
    "ID_STYLE" integer DEFAULT 1,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "MONTANT_INITIAL" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "INDICE_0" bigint DEFAULT 0,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "QTE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "T_PA_HT" bigint DEFAULT 0,
    "TARIF_Q18_HT" bigint DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "INDICE_N" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "ACOMPTE" boolean DEFAULT false,
    "PA_HT" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_CLIENT_ELEMENT_ID_seq" OWNED BY "AVOIR_CLIENT_ELEMENT"."ID";


--
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_CLIENT_ELEMENT_ID_seq"', 2, false);


--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_CLIENT_ID_seq" OWNED BY "AVOIR_CLIENT"."ID";


--
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_CLIENT_ID_seq"', 2, false);


--
-- Name: AVOIR_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AVOIR_FOURNISSEUR" (
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "IMMO" boolean DEFAULT false,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "A_DEDUIRE" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "SOLDE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer,
    "DATE" date,
    "MONTANT_HT" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."AVOIR_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "AVOIR_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AVOIR_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "AVOIR_FOURNISSEUR_ID_seq" OWNED BY "AVOIR_FOURNISSEUR"."ID";


--
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"AVOIR_FOURNISSEUR_ID_seq"', 2, false);


--
-- Name: AXE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "AXE_ANALYTIQUE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."AXE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "AXE_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AXE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "AXE_ANALYTIQUE_ID_seq" OWNED BY "AXE_ANALYTIQUE"."ID";


--
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"AXE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: BON_DE_LIVRAISON; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_DE_LIVRAISON" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "TOTAL_POIDS" real DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "TOTAL_HT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "DATE" date,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "SOURCE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_LIVRAISON" date
);


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_DE_LIVRAISON_ELEMENT" (
    "T_POIDS_LIVREE" real DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "PV_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "T_PV_TTC" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "QTE_LIVREE" integer DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "SERVICE" boolean DEFAULT false,
    "PA_HT" bigint DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE_ELEMENT" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "QTE_A_LIVRER" integer DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "BON_DE_LIVRAISON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNED BY "BON_DE_LIVRAISON_ELEMENT"."ID";


--
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_DE_LIVRAISON_ELEMENT_ID_seq"', 2, false);


--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "BON_DE_LIVRAISON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "BON_DE_LIVRAISON_ID_seq" OWNED BY "BON_DE_LIVRAISON"."ID";


--
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_DE_LIVRAISON_ID_seq"', 2, false);


--
-- Name: BON_RECEPTION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_RECEPTION" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "TOTAL_TTC" bigint DEFAULT 0,
    "DATE" date,
    "TOTAL_POIDS" real DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TOTAL_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMMANDE" integer DEFAULT 1,
    "TOTAL_TVA" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."BON_RECEPTION" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "BON_RECEPTION_ELEMENT" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_TAXE" integer DEFAULT 1,
    "T_PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PA_TTC" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "T_PV_HT" bigint DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "PA_HT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."BON_RECEPTION_ELEMENT" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "BON_RECEPTION_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_RECEPTION_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "BON_RECEPTION_ELEMENT_ID_seq" OWNED BY "BON_RECEPTION_ELEMENT"."ID";


--
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_RECEPTION_ELEMENT_ID_seq"', 2, false);


--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "BON_RECEPTION_ID_seq" OWNED BY "BON_RECEPTION"."ID";


--
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"BON_RECEPTION_ID_seq"', 2, false);


--
-- Name: CAISSE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CAISSE" (
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."CAISSE" OWNER TO openconcerto;

--
-- Name: CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CAISSE_ID_seq" OWNER TO openconcerto;

--
-- Name: CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CAISSE_ID_seq" OWNED BY "CAISSE"."ID";


--
-- Name: CAISSE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CAISSE_ID_seq"', 2, false);


--
-- Name: CHEQUE_AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_AVOIR_CLIENT" (
    "CREATION_DATE" timestamp without time zone,
    "DATE_AVOIR" date,
    "DECAISSE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "DATE_DECAISSE" date,
    "MONTANT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_MIN_DECAISSE" date
);


ALTER TABLE "OpenConcerto48"."CHEQUE_AVOIR_CLIENT" OWNER TO openconcerto;

--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_AVOIR_CLIENT_ID_seq" OWNED BY "CHEQUE_AVOIR_CLIENT"."ID";


--
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_AVOIR_CLIENT_ID_seq"', 2, false);


--
-- Name: CHEQUE_A_ENCAISSER; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_A_ENCAISSER" (
    "DATE_MIN_DEPOT" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "MONTANT" bigint DEFAULT 0,
    "ETS" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_VENTE" date,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_DEPOT" date,
    "ENCAISSE" boolean DEFAULT false,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto48"."CHEQUE_A_ENCAISSER" OWNER TO openconcerto;

--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_A_ENCAISSER_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CHEQUE_A_ENCAISSER_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_A_ENCAISSER_ID_seq" OWNED BY "CHEQUE_A_ENCAISSER"."ID";


--
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_A_ENCAISSER_ID_seq"', 2, false);


--
-- Name: CHEQUE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CHEQUE_FOURNISSEUR" (
    "DATE_DECAISSE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE_MIN_DECAISSE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_ACHAT" date,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "DECAISSE" boolean DEFAULT false,
    "ETS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."CHEQUE_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CHEQUE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CHEQUE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CHEQUE_FOURNISSEUR_ID_seq" OWNED BY "CHEQUE_FOURNISSEUR"."ID";


--
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CHEQUE_FOURNISSEUR_ID_seq"', 2, false);


--
-- Name: CLASSEMENT_CONVENTIONNEL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLASSEMENT_CONVENTIONNEL" (
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ECHELON" character varying(45) DEFAULT ''::character varying,
    "INDICE" character varying(45) DEFAULT ''::character varying,
    "POSITION" character varying(45) DEFAULT ''::character varying,
    "NIVEAU" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "COEFF" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL" OWNER TO openconcerto;

--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CLASSEMENT_CONVENTIONNEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNER TO openconcerto;

--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CLASSEMENT_CONVENTIONNEL_ID_seq" OWNED BY "CLASSEMENT_CONVENTIONNEL"."ID";


--
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLASSEMENT_CONVENTIONNEL_ID_seq"', 2, false);


--
-- Name: CLASSE_COMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLASSE_COMPTE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "TYPE_NUMERO_COMPTE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CLASSE_COMPTE" OWNER TO openconcerto;

--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CLASSE_COMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CLASSE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CLASSE_COMPTE_ID_seq" OWNED BY "CLASSE_COMPTE"."ID";


--
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLASSE_COMPTE_ID_seq"', 12, false);


--
-- Name: CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CLIENT" (
    "ID_ADRESSE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "TEL_COM" character varying(100) DEFAULT ''::character varying,
    "MAX_FACTURE" bigint DEFAULT 0,
    "TEL_P" character varying(100) DEFAULT ''::character varying,
    "TEL" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE_F" integer DEFAULT 1,
    "MAIL_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_P_TECH" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "FAX_COM" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_COM" character varying(100) DEFAULT ''::character varying,
    "COMPTE_CLIENT_AUTO" boolean DEFAULT false,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "NUMERO_TVA" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE_L" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "SIRET" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "FORME_JURIDIQUE" character varying(2048) DEFAULT ''::text,
    "RESPONSABLE_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_P_COM" character varying(100) DEFAULT ''::character varying,
    "MARCHE_PRIVE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "COMPTANT" boolean DEFAULT false,
    "RESPONSABLE" character varying(100) DEFAULT ''::character varying,
    "RIB" character varying(2048) DEFAULT ''::text,
    "MARCHE_PUBLIC" boolean DEFAULT false,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "TEL_TECH" character varying(100) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "AFFACTURAGE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "MAIL" character varying(100) DEFAULT ''::character varying,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MAIL_TECH" character varying(100) DEFAULT ''::character varying,
    "FAX_TECH" character varying(100) DEFAULT ''::character varying,
    "ID_TARIF" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CLIENT" OWNER TO openconcerto;

--
-- Name: CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CLIENT_ID_seq" OWNED BY "CLIENT"."ID";


--
-- Name: CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CLIENT_ID_seq"', 2, false);


--
-- Name: CODE_CARACT_ACTIVITE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_CARACT_ACTIVITE" (
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."CODE_CARACT_ACTIVITE" OWNER TO openconcerto;

--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_CARACT_ACTIVITE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_CARACT_ACTIVITE_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_CARACT_ACTIVITE_ID_seq" OWNED BY "CODE_CARACT_ACTIVITE"."ID";


--
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_CARACT_ACTIVITE_ID_seq"', 12, false);


--
-- Name: CODE_CONTRAT_TRAVAIL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_CONTRAT_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(128) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."CODE_CONTRAT_TRAVAIL" OWNER TO openconcerto;

--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_CONTRAT_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_CONTRAT_TRAVAIL_ID_seq" OWNED BY "CODE_CONTRAT_TRAVAIL"."ID";


--
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_CONTRAT_TRAVAIL_ID_seq"', 14, false);


--
-- Name: CODE_DROIT_CONTRAT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_DROIT_CONTRAT" (
    "ORDRE" numeric(16,8),
    "CODE" character varying(4) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CODE_DROIT_CONTRAT" OWNER TO openconcerto;

--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_DROIT_CONTRAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_DROIT_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_DROIT_CONTRAT_ID_seq" OWNED BY "CODE_DROIT_CONTRAT"."ID";


--
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_DROIT_CONTRAT_ID_seq"', 4, false);


--
-- Name: CODE_EMPLOI; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_EMPLOI" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CODE" character varying(11) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(195) DEFAULT ''::character varying,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."CODE_EMPLOI" OWNER TO openconcerto;

--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_EMPLOI_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_EMPLOI_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_EMPLOI_ID_seq" OWNED BY "CODE_EMPLOI"."ID";


--
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_EMPLOI_ID_seq"', 1036, false);


--
-- Name: CODE_REGIME; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_REGIME" (
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CODE_REGIME" OWNER TO openconcerto;

--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_REGIME_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_REGIME_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_REGIME_ID_seq" OWNED BY "CODE_REGIME"."ID";


--
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_REGIME_ID_seq"', 23, false);


--
-- Name: CODE_STATUT_CATEGORIEL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_CATEGORIEL" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CATEGORIEL" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_CATEGORIEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CATEGORIEL_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_CATEGORIEL_ID_seq" OWNED BY "CODE_STATUT_CATEGORIEL"."ID";


--
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_CATEGORIEL_ID_seq"', 6, false);


--
-- Name: CODE_STATUT_CAT_CONV; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_CAT_CONV" (
    "ID" integer NOT NULL,
    "CODE" character varying(6) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CAT_CONV" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_CAT_CONV_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CAT_CONV_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_CAT_CONV_ID_seq" OWNED BY "CODE_STATUT_CAT_CONV"."ID";


--
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_CAT_CONV_ID_seq"', 8, true);


--
-- Name: CODE_STATUT_PROF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CODE_STATUT_PROF" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."CODE_STATUT_PROF" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CODE_STATUT_PROF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_STATUT_PROF_ID_seq" OWNER TO openconcerto;

--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CODE_STATUT_PROF_ID_seq" OWNED BY "CODE_STATUT_PROF"."ID";


--
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CODE_STATUT_PROF_ID_seq"', 51, false);


--
-- Name: COMMANDE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE" (
    "T_POIDS" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE" date,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "T_SERVICE" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_TTC" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "IDSOURCE" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "T_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "T_TVA" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "EN_COURS" boolean DEFAULT true,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."COMMANDE" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_CLIENT" (
    "DATE" date,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "T_TTC" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "DATE_ECHEANCE" date,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "T_TVA" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_HT" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "T_POIDS" real DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_CLIENT_ELEMENT" (
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "PA_HT" bigint DEFAULT 0,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "QTE" integer DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "T_POIDS" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "ID_METRIQUE_3" integer DEFAULT 1,
    "T_PV_HT" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "T_PA_HT" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_CLIENT_ELEMENT_ID_seq" OWNED BY "COMMANDE_CLIENT_ELEMENT"."ID";


--
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_CLIENT_ELEMENT_ID_seq"', 2, false);


--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_CLIENT_ID_seq" OWNED BY "COMMANDE_CLIENT"."ID";


--
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_CLIENT_ID_seq"', 2, false);


--
-- Name: COMMANDE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMANDE_ELEMENT" (
    "ID_COMMANDE" integer DEFAULT 1,
    "T_PV_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_STYLE" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "T_PA_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "T_PA_TTC" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "QTE" integer DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PA_HT" bigint DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."COMMANDE_ELEMENT" OWNER TO openconcerto;

--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_ELEMENT_ID_seq" OWNED BY "COMMANDE_ELEMENT"."ID";


--
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_ELEMENT_ID_seq"', 2, false);


--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COMMANDE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COMMANDE_ID_seq" OWNED BY "COMMANDE"."ID";


--
-- Name: COMMANDE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMANDE_ID_seq"', 2, false);


--
-- Name: COMMERCIAL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMMERCIAL" (
    "ID_COMMERCIAL" integer NOT NULL,
    "FONCTION" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON" integer DEFAULT 1,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer,
    "EMAIL" character varying(100) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."COMMERCIAL" OWNER TO openconcerto;

--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COMMERCIAL_ID_COMMERCIAL_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMERCIAL_ID_COMMERCIAL_seq" OWNER TO openconcerto;

--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COMMERCIAL_ID_COMMERCIAL_seq" OWNED BY "COMMERCIAL"."ID_COMMERCIAL";


--
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMMERCIAL_ID_COMMERCIAL_seq"', 3, false);


--
-- Name: COMPLETION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPLETION" (
    "ORDRE" numeric(16,8),
    "CHAMP" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "LABEL" character varying(200) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."COMPLETION" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPTE_PCE" (
    "TOTAL_DEBIT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "TOTAL_CREDIT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "RACINE" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."COMPTE_PCE" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COMPTE_PCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMPTE_PCE_ID_seq" OWNER TO openconcerto;

--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COMPTE_PCE_ID_seq" OWNED BY "COMPTE_PCE"."ID";


--
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMPTE_PCE_ID_seq"', 414, true);


--
-- Name: COMPTE_PCG; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COMPTE_PCG" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_TYPE_COMPTE_PCG_AB" integer DEFAULT 1,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_TYPE_COMPTE_PCG_BASE" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_DEV" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."COMPTE_PCG" OWNER TO openconcerto;

--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COMPTE_PCG_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COMPTE_PCG_ID_seq" OWNED BY "COMPTE_PCG"."ID";


--
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COMPTE_PCG_ID_seq"', 978, false);


--
-- Name: CONTACT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT" (
    "ID_CLIENT" integer DEFAULT 1,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "FONCTION" character varying(2048) DEFAULT ''::text,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_TITRE_PERSONNEL" integer DEFAULT 2,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."CONTACT" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT_ADMINISTRATIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "N4DS" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTACT_ADMINISTRATIF" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_ADMINISTRATIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTACT_ADMINISTRATIF_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_ADMINISTRATIF_ID_seq" OWNED BY "CONTACT_ADMINISTRATIF"."ID";


--
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_ADMINISTRATIF_ID_seq"', 1, true);


--
-- Name: CONTACT_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTACT_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTACT_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTACT_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_FOURNISSEUR_ID_seq" OWNED BY "CONTACT_FOURNISSEUR"."ID";


--
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_FOURNISSEUR_ID_seq"', 1, true);


--
-- Name: CONTACT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CONTACT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTACT_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTACT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CONTACT_ID_seq" OWNED BY "CONTACT"."ID";


--
-- Name: CONTACT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTACT_ID_seq"', 2, false);


--
-- Name: CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CONTRAT_SALARIE" (
    "NATURE" character varying(2048) DEFAULT ''::text,
    "ID_CODE_STATUT_PROF" integer DEFAULT 1,
    "ID_CODE_CARACT_ACTIVITE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_CODE_DROIT_CONTRAT" integer DEFAULT 1,
    "ID_CODE_EMPLOI" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_CODE_STATUT_CATEGORIEL" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CODE_CONTRAT_TRAVAIL" integer DEFAULT 1,
    "CODE_IRC_UGRR" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRR" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_UGRC" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRC" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_RETRAITE" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_RETRAITE" character varying(64) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_STATUT_CAT_CONV" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CONTRAT_SALARIE_ID_seq" OWNED BY "CONTRAT_SALARIE"."ID";


--
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CONTRAT_SALARIE_ID_seq"', 2, false);


--
-- Name: COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "COURRIER_CLIENT" (
    "ID_USER_COMMON_CREATE" integer,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_MODELE_COURRIER_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."COURRIER_CLIENT" OWNER TO openconcerto;

--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "COURRIER_CLIENT_ID_seq" OWNED BY "COURRIER_CLIENT"."ID";


--
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"COURRIER_CLIENT_ID_seq"', 2, false);


--
-- Name: CUMULS_CONGES; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CUMULS_CONGES" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ACQUIS" real DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "RESTANT" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."CUMULS_CONGES" OWNER TO openconcerto;

--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CUMULS_CONGES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CUMULS_CONGES_ID_seq" OWNER TO openconcerto;

--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CUMULS_CONGES_ID_seq" OWNED BY "CUMULS_CONGES"."ID";


--
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CUMULS_CONGES_ID_seq"', 2, false);


--
-- Name: CUMULS_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "CUMULS_PAYE" (
    "ORDRE" numeric(16,8),
    "NET_A_PAYER_C" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "COT_PAT_C" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "COT_SAL_C" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "SAL_BRUT_C" real DEFAULT 0,
    "CSG_C" real DEFAULT 0,
    "ID" integer NOT NULL,
    "NET_IMP_C" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CUMULS_PAYE" OWNER TO openconcerto;

--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "CUMULS_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CUMULS_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "CUMULS_PAYE_ID_seq" OWNED BY "CUMULS_PAYE"."ID";


--
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"CUMULS_PAYE_ID_seq"', 2, false);


--
-- Name: DEPARTEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEPARTEMENT" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "REGION_ADMIN" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CHEF_LIEU" character varying(100) DEFAULT ''::character varying,
    "NUMERO" character varying(10) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."DEPARTEMENT" OWNER TO openconcerto;

--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "DEPARTEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "DEPARTEMENT_ID_seq" OWNED BY "DEPARTEMENT"."ID";


--
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEPARTEMENT_ID_seq"', 102, false);


--
-- Name: DEVIS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEVIS" (
    "T_POIDS" real DEFAULT 0,
    "DATE_ENVOI" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_DEVIS" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ETAT_DEVIS" integer DEFAULT 1,
    "T_TTC" bigint DEFAULT 0,
    "OBJET" character varying(100) DEFAULT ''::character varying,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "PORT_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "REMISE_HT" bigint DEFAULT 0,
    "T_HT" bigint DEFAULT 0,
    "DATE" date,
    "T_TVA" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "DATE_VALIDITE" date,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."DEVIS" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "DEVIS_ELEMENT" (
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "QTE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PA_HT" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_TAXE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PV_TTC" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "ID_DEVIS" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "T_PA_HT" bigint DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_DEVIS_ELEMENT" integer NOT NULL,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."DEVIS_ELEMENT" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNER TO openconcerto;

--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNED BY "DEVIS_ELEMENT"."ID_DEVIS_ELEMENT";


--
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"', 2, false);


--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "DEVIS_ID_DEVIS_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEVIS_ID_DEVIS_seq" OWNER TO openconcerto;

--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "DEVIS_ID_DEVIS_seq" OWNED BY "DEVIS"."ID_DEVIS";


--
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"DEVIS_ID_DEVIS_seq"', 2, false);


--
-- Name: ECHANTILLON_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHANTILLON_ELEMENT" (
    "ID_TAXE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PV_HT" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "QTE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PV_TTC" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."ECHANTILLON_ELEMENT" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ECHANTILLON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECHANTILLON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ECHANTILLON_ELEMENT_ID_seq" OWNED BY "ECHANTILLON_ELEMENT"."ID";


--
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHANTILLON_ELEMENT_ID_seq"', 2, false);


--
-- Name: ECHEANCE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHEANCE_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_LAST_RELANCE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "MONTANT" bigint DEFAULT 0,
    "REGLE" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "NOMBRE_RELANCE" integer DEFAULT 0,
    "DATE" date,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."ECHEANCE_CLIENT" OWNER TO openconcerto;

--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ECHEANCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECHEANCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ECHEANCE_CLIENT_ID_seq" OWNED BY "ECHEANCE_CLIENT"."ID";


--
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHEANCE_CLIENT_ID_seq"', 2, false);


--
-- Name: ECHEANCE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECHEANCE_FOURNISSEUR" (
    "ID_MOUVEMENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "REGLE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE" date
);


ALTER TABLE "OpenConcerto48"."ECHEANCE_FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ECHEANCE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECHEANCE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ECHEANCE_FOURNISSEUR_ID_seq" OWNED BY "ECHEANCE_FOURNISSEUR"."ID";


--
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECHEANCE_FOURNISSEUR_ID_seq"', 2, false);


--
-- Name: ECRITURE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ECRITURE" (
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "DATE_POINTEE" date,
    "DATE_LETTRAGE" date,
    "JOURNAL_NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "POINTEE" character varying(45) DEFAULT ''::character varying,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DEBIT" bigint DEFAULT 0,
    "CREDIT" bigint DEFAULT 0,
    "ID_JOURNAL" integer DEFAULT 1,
    "IDUSER_VALIDE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "IDUSER_CREATE" integer DEFAULT 1,
    "COMPTE_NUMERO" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "COMPTE_NOM" character varying(2048) DEFAULT ''::text,
    "LETTRAGE" character varying(256) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "JOURNAL_CODE" character varying(2048) DEFAULT ''::text,
    "VALIDE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "ORDRE" numeric(16,8),
    "IDUSER_DELETE" integer DEFAULT 1,
    "DATE_VALIDE" date
);


ALTER TABLE "OpenConcerto48"."ECRITURE" OWNER TO openconcerto;

--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ECRITURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECRITURE_ID_seq" OWNER TO openconcerto;

--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ECRITURE_ID_seq" OWNED BY "ECRITURE"."ID";


--
-- Name: ECRITURE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ECRITURE_ID_seq"', 2, false);


--
-- Name: EMPLOYEUR_MULTIPLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "EMPLOYEUR_MULTIPLE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."EMPLOYEUR_MULTIPLE" OWNER TO openconcerto;

--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "EMPLOYEUR_MULTIPLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."EMPLOYEUR_MULTIPLE_ID_seq" OWNER TO openconcerto;

--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "EMPLOYEUR_MULTIPLE_ID_seq" OWNED BY "EMPLOYEUR_MULTIPLE"."ID";


--
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"EMPLOYEUR_MULTIPLE_ID_seq"', 5, false);


--
-- Name: ENCAISSER_MONTANT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ENCAISSER_MONTANT" (
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NOM" character varying(200),
    "MODIFICATION_DATE" timestamp without time zone,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ENCAISSER_MONTANT_ELEMENT" (
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_ENCAISSER_MONTANT" integer DEFAULT 1,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ENCAISSER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNED BY "ENCAISSER_MONTANT_ELEMENT"."ID";


--
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ENCAISSER_MONTANT_ELEMENT_ID_seq"', 2, false);


--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ENCAISSER_MONTANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ENCAISSER_MONTANT_ID_seq" OWNED BY "ENCAISSER_MONTANT"."ID";


--
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ENCAISSER_MONTANT_ID_seq"', 2, false);


--
-- Name: ETAT_CIVIL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_CIVIL" (
    "ID_DEPARTEMENT_NAISSANCE" integer DEFAULT 1,
    "PORTABLE" character varying(45) DEFAULT ''::character varying,
    "ID_SITUATION_FAMILIALE" integer DEFAULT 1,
    "MAIL" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_NAISSANCE" date,
    "NB_PERS_A_CHARGE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "COMMUNE_NAISSANCE" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NB_ENFANTS" integer DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_PAYS_NAISSANCE" integer DEFAULT 1,
    "NUMERO_SS" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "TELEPHONE" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."ETAT_CIVIL" OWNER TO openconcerto;

--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_CIVIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_CIVIL_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_CIVIL_ID_seq" OWNED BY "ETAT_CIVIL"."ID";


--
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_CIVIL_ID_seq"', 2, false);


--
-- Name: ETAT_DEVIS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_DEVIS" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."ETAT_DEVIS" OWNER TO openconcerto;

--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_DEVIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_DEVIS_ID_seq" OWNED BY "ETAT_DEVIS"."ID";


--
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_DEVIS_ID_seq"', 5, true);


--
-- Name: ETAT_RAPPORT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "ETAT_RAPPORT" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."ETAT_RAPPORT" OWNER TO openconcerto;

--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "ETAT_RAPPORT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_RAPPORT_ID_seq" OWNER TO openconcerto;

--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "ETAT_RAPPORT_ID_seq" OWNED BY "ETAT_RAPPORT"."ID";


--
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"ETAT_RAPPORT_ID_seq"', 3, false);


--
-- Name: FAMILLE_ARTICLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FAMILLE_ARTICLE" (
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FAMILLE_ARTICLE_PERE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."FAMILLE_ARTICLE" OWNER TO openconcerto;

--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "FAMILLE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FAMILLE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "FAMILLE_ARTICLE_ID_seq" OWNED BY "FAMILLE_ARTICLE"."ID";


--
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"FAMILLE_ARTICLE_ID_seq"', 2, false);


--
-- Name: FICHE_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FICHE_PAYE" (
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "VALIDE" boolean DEFAULT false,
    "DU" date,
    "NET_A_PAYER" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NET_IMP" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ID_IDCC" integer DEFAULT 1,
    "COT_PAT" real DEFAULT 0,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NATURE_EMPLOI" character varying(150) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "SAL_BRUT" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "AU" date,
    "ACOMPTE" real DEFAULT 0,
    "ID_MOIS" integer DEFAULT 1,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "COT_SAL" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "CONGES_ACQUIS" real DEFAULT 0,
    "CSG" real DEFAULT 0,
    "ANNEE" integer DEFAULT 0,
    "ID_SALARIE" integer DEFAULT 1,
    "ID_PROFIL_PAYE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."FICHE_PAYE" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FICHE_PAYE_ELEMENT" (
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "POSITION" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "TAUX_SAL" real,
    "NB_BASE" real,
    "IDSOURCE" integer DEFAULT 1,
    "TAUX_PAT" real,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "MONTANT_PAT" real,
    "ID" integer NOT NULL,
    "VALIDE" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT_SAL_AJ" real,
    "MONTANT_SAL_DED" real,
    "IN_PERIODE" boolean DEFAULT true,
    "IMPRESSION" boolean DEFAULT true,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."FICHE_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "FICHE_PAYE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FICHE_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "FICHE_PAYE_ELEMENT_ID_seq" OWNED BY "FICHE_PAYE_ELEMENT"."ID";


--
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"FICHE_PAYE_ELEMENT_ID_seq"', 2, false);


--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "FICHE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FICHE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "FICHE_PAYE_ID_seq" OWNED BY "FICHE_PAYE"."ID";


--
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"FICHE_PAYE_ID_seq"', 2, false);


--
-- Name: FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FOURNISSEUR" (
    "TYPE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer NOT NULL,
    "UE" boolean DEFAULT false,
    "ID_ADRESSE_E" integer DEFAULT 1,
    "FAX" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TEL" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "RESPONSABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_P" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_CHARGE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."FOURNISSEUR" OWNER TO openconcerto;

--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "FOURNISSEUR_ID_FOURNISSEUR_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNER TO openconcerto;

--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "FOURNISSEUR_ID_FOURNISSEUR_seq" OWNED BY "FOURNISSEUR"."ID_FOURNISSEUR";


--
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"FOURNISSEUR_ID_FOURNISSEUR_seq"', 2, false);


--
-- Name: FWK_MODULE_METADATA; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_MODULE_METADATA" (
    "ID" integer NOT NULL,
    "MODULE_NAME" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128),
    "FIELD" character varying(128),
    "KEY" boolean,
    "MODULE_VERSION" bigint NOT NULL
);


ALTER TABLE "OpenConcerto48"."FWK_MODULE_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "FWK_MODULE_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FWK_MODULE_METADATA_ID_seq" OWNER TO openconcerto;

--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "FWK_MODULE_METADATA_ID_seq" OWNED BY "FWK_MODULE_METADATA"."ID";


--
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"FWK_MODULE_METADATA_ID_seq"', 1, false);


--
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_UNDEFINED_IDS" (
    "UNDEFINED_ID" integer DEFAULT 0,
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- Name: IDCC; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "IDCC" (
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."IDCC" OWNER TO openconcerto;

--
-- Name: IDCC_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "IDCC_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."IDCC_ID_seq" OWNER TO openconcerto;

--
-- Name: IDCC_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "IDCC_ID_seq" OWNED BY "IDCC"."ID";


--
-- Name: IDCC_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"IDCC_ID_seq"', 996, false);


--
-- Name: INFOS_SALARIE_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "INFOS_SALARIE_PAYE" (
    "DUREE_HEBDO" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "TAUX_AT" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SALAIRE_MOIS" real DEFAULT 0,
    "ID_CONTRAT_SALARIE" integer DEFAULT 1,
    "CONGES_PAYES" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_SORTIE" date,
    "ID_IDCC" integer DEFAULT 1,
    "DATE_ARRIVE" date,
    "DUREE_MOIS" real DEFAULT 0,
    "ID_CLASSEMENT_CONVENTIONNEL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CODE_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "CODE_SECTION_AT" character varying(18) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."INFOS_SALARIE_PAYE" OWNER TO openconcerto;

--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "INFOS_SALARIE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."INFOS_SALARIE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "INFOS_SALARIE_PAYE_ID_seq" OWNED BY "INFOS_SALARIE_PAYE"."ID";


--
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"INFOS_SALARIE_PAYE_ID_seq"', 2, false);


--
-- Name: JOURNAL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "JOURNAL" (
    "PAR_DEFAUT" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "TYPE_BANQUE" boolean DEFAULT false,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."JOURNAL" OWNER TO openconcerto;

--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "JOURNAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "JOURNAL_ID_seq" OWNED BY "JOURNAL"."ID";


--
-- Name: JOURNAL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"JOURNAL_ID_seq"', 7, false);


--
-- Name: LANGUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "LANGUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CHEMIN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."LANGUE" OWNER TO openconcerto;

--
-- Name: LANGUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "LANGUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."LANGUE_ID_seq" OWNER TO openconcerto;

--
-- Name: LANGUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "LANGUE_ID_seq" OWNED BY "LANGUE"."ID";


--
-- Name: LANGUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"LANGUE_ID_seq"', 7, true);


--
-- Name: METRIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "METRIQUE" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "UNITE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."METRIQUE" OWNER TO openconcerto;

--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "METRIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."METRIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "METRIQUE_ID_seq" OWNED BY "METRIQUE"."ID";


--
-- Name: METRIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"METRIQUE_ID_seq"', 4, false);


--
-- Name: MODELE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TYPE_MODELE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."MODELE" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODELE_COURRIER_CLIENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(10) DEFAULT ''::character varying,
    "LOCATION" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "CONTENU" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."MODELE_COURRIER_CLIENT" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MODELE_COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODELE_COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MODELE_COURRIER_CLIENT_ID_seq" OWNED BY "MODELE_COURRIER_CLIENT"."ID";


--
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODELE_COURRIER_CLIENT_ID_seq"', 10, false);


--
-- Name: MODELE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODELE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MODELE_ID_seq" OWNED BY "MODELE"."ID";


--
-- Name: MODELE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODELE_ID_seq"', 1, true);


--
-- Name: MODE_REGLEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_REGLEMENT" (
    "FIN_MOIS" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE_VIREMENT" date,
    "DATE_FACTURE" boolean DEFAULT false,
    "LENJOUR" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "ETS" character varying(2048) DEFAULT ''::text,
    "COMPTANT" boolean DEFAULT false,
    "DATE_DEPOT" date,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "AJOURS" integer DEFAULT 0,
    "DATE" date,
    "ID_MODE_REGLEMENT" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNED BY "MODE_REGLEMENT"."ID_MODE_REGLEMENT";


--
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"', 4, false);


--
-- Name: MODE_REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_REGLEMENT_PAYE" (
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MODE_REGLEMENT_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MODE_REGLEMENT_PAYE_ID_seq" OWNED BY "MODE_REGLEMENT_PAYE"."ID";


--
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_REGLEMENT_PAYE_ID_seq"', 4, false);


--
-- Name: MODE_VENTE_ARTICLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MODE_VENTE_ARTICLE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8) DEFAULT 0.00000000,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."MODE_VENTE_ARTICLE" OWNER TO openconcerto;

--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MODE_VENTE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODE_VENTE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MODE_VENTE_ARTICLE_ID_seq" OWNED BY "MODE_VENTE_ARTICLE"."ID";


--
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MODE_VENTE_ARTICLE_ID_seq"', 7, false);


--
-- Name: MOIS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOIS" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."MOIS" OWNER TO openconcerto;

--
-- Name: MOIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MOIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MOIS_ID_seq" OWNER TO openconcerto;

--
-- Name: MOIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MOIS_ID_seq" OWNED BY "MOIS"."ID";


--
-- Name: MOIS_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOIS_ID_seq"', 14, false);


--
-- Name: MOUVEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOUVEMENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SOURCE" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_MOUVEMENT_PERE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_PIECE" integer DEFAULT 1,
    "IDSOURCE" integer DEFAULT 1,
    "NUMERO" integer DEFAULT 0,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."MOUVEMENT" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MOUVEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MOUVEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MOUVEMENT_ID_seq" OWNED BY "MOUVEMENT"."ID";


--
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOUVEMENT_ID_seq"', 2, false);


--
-- Name: MOUVEMENT_STOCK; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "MOUVEMENT_STOCK" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NUMERO" character varying(150) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."MOUVEMENT_STOCK" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "MOUVEMENT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MOUVEMENT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "MOUVEMENT_STOCK_ID_seq" OWNED BY "MOUVEMENT_STOCK"."ID";


--
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"MOUVEMENT_STOCK_ID_seq"', 2, false);


--
-- Name: NATURE_COMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "NATURE_COMPTE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."NATURE_COMPTE" OWNER TO openconcerto;

--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "NATURE_COMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."NATURE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "NATURE_COMPTE_ID_seq" OWNED BY "NATURE_COMPTE"."ID";


--
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"NATURE_COMPTE_ID_seq"', 13, false);


--
-- Name: NUMEROTATION_AUTO; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "NUMEROTATION_AUTO" (
    "BON_L_FORMAT" character varying(45) DEFAULT ''::character varying,
    "RELANCE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_START" integer DEFAULT 1,
    "AFFAIRE_START" integer DEFAULT 0,
    "DEVIS_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_START" integer DEFAULT 0,
    "SALARIE_START" integer DEFAULT 1,
    "PROPOSITION_START" integer DEFAULT 0,
    "BON_R_START" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "FACT_START" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "FACT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "SALARIE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "COMMANDE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_CLIENT_START" integer DEFAULT 0,
    "COMMANDE_START" integer DEFAULT 0,
    "BON_R_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_L_START" integer DEFAULT 1,
    "DEVIS_START" integer DEFAULT 1,
    "RELANCE_START" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "PROPOSITION_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AFFAIRE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_FORMAT" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CODE_LETTRAGE" character varying(128) DEFAULT 'AAA'::character varying,
    "COMMANDE_CLIENT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_F_START" integer DEFAULT 0,
    "AVOIR_F_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."NUMEROTATION_AUTO" OWNER TO openconcerto;

--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "NUMEROTATION_AUTO_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."NUMEROTATION_AUTO_ID_seq" OWNER TO openconcerto;

--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "NUMEROTATION_AUTO_ID_seq" OWNED BY "NUMEROTATION_AUTO"."ID";


--
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"NUMEROTATION_AUTO_ID_seq"', 3, false);


--
-- Name: OBJECTIF_COMMERCIAL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "OBJECTIF_COMMERCIAL" (
    "ID" integer NOT NULL,
    "MOIS" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ANNEE" integer,
    "MARGE_HT" bigint DEFAULT 0,
    "POURCENT_MARGE" numeric(16,8),
    "CHIFFRE_AFFAIRE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."OBJECTIF_COMMERCIAL" OWNER TO openconcerto;

--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OBJECTIF_COMMERCIAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."OBJECTIF_COMMERCIAL_ID_seq" OWNER TO openconcerto;

--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OBJECTIF_COMMERCIAL_ID_seq" OWNED BY "OBJECTIF_COMMERCIAL"."ID";


--
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"OBJECTIF_COMMERCIAL_ID_seq"', 1, true);


--
-- Name: PAYS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PAYS" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(50) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CODE" character varying(15) DEFAULT ''::character varying,
    "ID_TARIF" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."PAYS" OWNER TO openconcerto;

--
-- Name: PAYS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "PAYS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PAYS_ID_seq" OWNER TO openconcerto;

--
-- Name: PAYS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "PAYS_ID_seq" OWNED BY "PAYS"."ID";


--
-- Name: PAYS_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"PAYS_ID_seq"', 194, false);


--
-- Name: PIECE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PIECE" (
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."PIECE" OWNER TO openconcerto;

--
-- Name: PIECE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "PIECE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PIECE_ID_seq" OWNER TO openconcerto;

--
-- Name: PIECE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "PIECE_ID_seq" OWNED BY "PIECE"."ID";


--
-- Name: PIECE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"PIECE_ID_seq"', 2, false);


--
-- Name: POSTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "POSTE_ANALYTIQUE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."POSTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "POSTE_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."POSTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "POSTE_ANALYTIQUE_ID_seq" OWNED BY "POSTE_ANALYTIQUE"."ID";


--
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"POSTE_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: PREFERENCES; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREFERENCES" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NAME" character varying(2048),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "VALUE" character varying(2048),
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."PREFERENCES" OWNER TO openconcerto;

--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "PREFERENCES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PREFERENCES_ID_seq" OWNER TO openconcerto;

--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "PREFERENCES_ID_seq" OWNED BY "PREFERENCES"."ID";


--
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREFERENCES_ID_seq"', 5, false);


--
-- Name: PREFS_COMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "PREFS_COMPTE" (
    "ID_COMPTE_PCE_TVA_IMMO" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_O" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_F" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT_PERTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE_REGL" integer DEFAULT 1,
    "ID_COMPTE_PCE_FACTOR" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_TVA_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_PAYE" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT" integer DEFAULT 1,
    "ID_JOURNAL_FACTOR" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."PREFS_COMPTE" OWNER TO openconcerto;

--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "PREFS_COMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PREFS_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "PREFS_COMPTE_ID_seq" OWNED BY "PREFS_COMPTE"."ID";


--
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"PREFS_COMPTE_ID_seq"', 3, false);


--
-- Name: REFERENCE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REFERENCE_CLIENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."REFERENCE_CLIENT" OWNER TO openconcerto;

--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "REFERENCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REFERENCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "REFERENCE_CLIENT_ID_seq" OWNED BY "REFERENCE_CLIENT"."ID";


--
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"REFERENCE_CLIENT_ID_seq"', 2, false);


--
-- Name: REGIME_BASE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGIME_BASE" (
    "ID_CODE_REGIME_MALADIE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_CODE_REGIME_VIEL_S" integer DEFAULT 1,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ID_CODE_REGIME_BASE" integer DEFAULT 1,
    "ID_CODE_REGIME_AT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_CODE_REGIME_VIEL_P" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."REGIME_BASE" OWNER TO openconcerto;

--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "REGIME_BASE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REGIME_BASE_ID_seq" OWNER TO openconcerto;

--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "REGIME_BASE_ID_seq" OWNED BY "REGIME_BASE"."ID";


--
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGIME_BASE_ID_seq"', 2, false);


--
-- Name: REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGLEMENT_PAYE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "RIB" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NOM_BANQUE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "LE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_MODE_REGLEMENT_PAYE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "REGLEMENT_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "REGLEMENT_PAYE_ID_seq" OWNED BY "REGLEMENT_PAYE"."ID";


--
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGLEMENT_PAYE_ID_seq"', 2, false);


--
-- Name: REGLER_MONTANT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REGLER_MONTANT" (
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MONTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL,
    "DATE" date,
    "ARCHIVE" integer DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."REGLER_MONTANT" OWNER TO openconcerto;

--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "REGLER_MONTANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REGLER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "REGLER_MONTANT_ID_seq" OWNED BY "REGLER_MONTANT"."ID";


--
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"REGLER_MONTANT_ID_seq"', 2, false);


--
-- Name: RELANCE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "RELANCE" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_TYPE_LETTRE_RELANCE" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "DATE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "MONTANT" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."RELANCE" OWNER TO openconcerto;

--
-- Name: RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "RELANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."RELANCE_ID_seq" OWNER TO openconcerto;

--
-- Name: RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "RELANCE_ID_seq" OWNED BY "RELANCE"."ID";


--
-- Name: RELANCE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"RELANCE_ID_seq"', 2, false);


--
-- Name: REPARTITION_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REPARTITION_ANALYTIQUE" (
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "REPARTITION_ANALYTIQUE_ELEMENT" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "TAUX" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNED BY "REPARTITION_ANALYTIQUE_ELEMENT"."ID";


--
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"', 2, false);


--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "REPARTITION_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "REPARTITION_ANALYTIQUE_ID_seq" OWNED BY "REPARTITION_ANALYTIQUE"."ID";


--
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"REPARTITION_ANALYTIQUE_ID_seq"', 2, false);


--
-- Name: SAISIE_ACHAT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_ACHAT" (
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "NUMERO_COMMANDE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MONTANT_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "IMMO" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "MONTANT_TTC" bigint DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE" date,
    "MODIFICATION_DATE" timestamp without time zone,
    "IDSOURCE" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "NUMERO_FACTURE" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."SAISIE_ACHAT" OWNER TO openconcerto;

--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_ACHAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_ACHAT_ID_seq" OWNED BY "SAISIE_ACHAT"."ID";


--
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_ACHAT_ID_seq"', 2, false);


--
-- Name: SAISIE_KM; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_KM" (
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_JOURNAL" integer DEFAULT 1,
    "DATE" date,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."SAISIE_KM" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_KM_ELEMENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NUMERO" character varying(100) DEFAULT ''::character varying,
    "NOM_ECRITURE" character varying(2048) DEFAULT ''::text,
    "ID_SAISIE_KM" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "DEBIT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CREDIT" bigint DEFAULT 0,
    "ID_ECRITURE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."SAISIE_KM_ELEMENT" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_KM_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_KM_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_KM_ELEMENT_ID_seq" OWNED BY "SAISIE_KM_ELEMENT"."ID";


--
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_KM_ELEMENT_ID_seq"', 2, false);


--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_KM_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_KM_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_KM_ID_seq" OWNED BY "SAISIE_KM"."ID";


--
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_KM_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_COMPTOIR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_COMPTOIR" (
    "ID_USER_COMMON_CREATE" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ARTICLE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ECHEANCE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 0,
    "DATE" date,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_COMPTOIR" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_COMPTOIR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_COMPTOIR_ID_seq" OWNED BY "SAISIE_VENTE_COMPTOIR"."ID";


--
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_COMPTOIR_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_FACTURE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_FACTURE" (
    "NOM" character varying(250) DEFAULT ''::character varying,
    "T_TTC" bigint DEFAULT 0,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "DATE_ENVOI" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "COMPLEMENT" boolean DEFAULT false,
    "ACOMPTE" boolean DEFAULT false,
    "IDSOURCE" integer DEFAULT 1,
    "T_AVOIR_TTC" bigint DEFAULT 0,
    "T_HT" bigint DEFAULT 0,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "REMISE_HT" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_CLIENT" integer DEFAULT 1,
    "PREVISIONNELLE" boolean DEFAULT false,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "AFFACTURAGE" boolean DEFAULT false,
    "POURCENT_ACOMPTE" real DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_REFERENCE_CLIENT" integer DEFAULT 1,
    "CONTROLE_TECHNIQUE" boolean DEFAULT false,
    "ID_MOIS_CCIP" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "DATE_ENVOI_AFFACTURAGE" date,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "REF_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_REGLEMENT" timestamp without time zone,
    "ID_DEVIS" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "T_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ID_CONTACT" integer DEFAULT 1,
    "TYPE_INTERVENTION" character varying(2048) DEFAULT ''::text,
    "T_HA" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_TAXE_PORT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SAISIE_VENTE_FACTURE_ELEMENT" (
    "T_PV_TTC" bigint DEFAULT 0,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "T_PV_HT" bigint DEFAULT 0,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "TARIF_Q18_HT" bigint DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "Q18" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "LIVREE" boolean DEFAULT false,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "DATE" date,
    "SERVICE" boolean DEFAULT false,
    "ID_TAXE" integer DEFAULT 1,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "T_PA_HT" bigint DEFAULT 0,
    "POURCENT_REMISE" numeric(6,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "MONTANT_INITIAL" bigint DEFAULT 0,
    "QTE_LIVREE" integer DEFAULT 0,
    "ACOMPTE" boolean DEFAULT false,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "REPARTITION_POURCENT" numeric(6,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "POURCENT_CCIP" character varying(256) DEFAULT ''::character varying NOT NULL,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "INDICE_0" bigint DEFAULT 0,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "PA_HT" bigint DEFAULT 0,
    "INDICE_N" bigint DEFAULT 0,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" bigint DEFAULT 0,
    "PV_T_DEVISE" bigint DEFAULT 0,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" bigint DEFAULT 0,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNED BY "SAISIE_VENTE_FACTURE_ELEMENT"."ID";


--
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"', 2, false);


--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "SAISIE_VENTE_FACTURE"."ID";


--
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SAISIE_VENTE_FACTURE_ID_seq"', 2, false);


--
-- Name: SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SALARIE" (
    "CREATION_DATE" timestamp without time zone,
    "DERNIER_MOIS" integer DEFAULT 0,
    "PRENOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "DERNIERE_ANNEE" integer DEFAULT 0,
    "ID_ETAT_CIVIL" integer DEFAULT 1,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM_JEUNE_FILLE" character varying(45) DEFAULT ''::character varying,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."SALARIE" OWNER TO openconcerto;

--
-- Name: SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SALARIE_ID_seq" OWNED BY "SALARIE"."ID";


--
-- Name: SALARIE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SALARIE_ID_seq"', 2, false);


--
-- Name: SITUATION_FAMILIALE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "SITUATION_FAMILIALE" (
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."SITUATION_FAMILIALE" OWNER TO openconcerto;

--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "SITUATION_FAMILIALE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SITUATION_FAMILIALE_ID_seq" OWNER TO openconcerto;

--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "SITUATION_FAMILIALE_ID_seq" OWNED BY "SITUATION_FAMILIALE"."ID";


--
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"SITUATION_FAMILIALE_ID_seq"', 7, false);


--
-- Name: STOCK; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "STOCK" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "QTE_REEL" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "QTE_TH" real DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."STOCK" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "STOCK_ID_seq" OWNED BY "STOCK"."ID";


--
-- Name: STOCK_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"STOCK_ID_seq"', 2, false);


--
-- Name: STYLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "STYLE" (
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_STYLE" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."STYLE" OWNER TO openconcerto;

--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "STYLE_ID_STYLE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."STYLE_ID_STYLE_seq" OWNER TO openconcerto;

--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "STYLE_ID_STYLE_seq" OWNED BY "STYLE"."ID_STYLE";


--
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"STYLE_ID_STYLE_seq"', 5, false);


--
-- Name: TARIF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TARIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."TARIF" OWNER TO openconcerto;

--
-- Name: TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TARIF_ID_seq" OWNER TO openconcerto;

--
-- Name: TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "TARIF_ID_seq" OWNED BY "TARIF"."ID";


--
-- Name: TARIF_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"TARIF_ID_seq"', 1, true);


--
-- Name: TAXE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TAXE" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "TAUX" real DEFAULT 0,
    "ID_COMPTE_PCE_COLLECTE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE_DED" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TAXE" integer NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TAXE" OWNER TO openconcerto;

--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "TAXE_ID_TAXE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TAXE_ID_TAXE_seq" OWNER TO openconcerto;

--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "TAXE_ID_TAXE_seq" OWNED BY "TAXE"."ID_TAXE";


--
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"TAXE_ID_TAXE_seq"', 6, true);


--
-- Name: TICKET_CAISSE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TICKET_CAISSE" (
    "ID_CAISSE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "TOTAL_HT" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "TOTAL_TVA" bigint DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "TOTAL_TTC" bigint DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TICKET_CAISSE" OWNER TO openconcerto;

--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "TICKET_CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TICKET_CAISSE_ID_seq" OWNER TO openconcerto;

--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "TICKET_CAISSE_ID_seq" OWNED BY "TICKET_CAISSE"."ID";


--
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"TICKET_CAISSE_ID_seq"', 1, true);


--
-- Name: TITRE_PERSONNEL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TITRE_PERSONNEL" (
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "SEXE_M" boolean DEFAULT true,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(8) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."TITRE_PERSONNEL" OWNER TO openconcerto;

--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "TITRE_PERSONNEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TITRE_PERSONNEL_ID_seq" OWNER TO openconcerto;

--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "TITRE_PERSONNEL_ID_seq" OWNED BY "TITRE_PERSONNEL"."ID";


--
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"TITRE_PERSONNEL_ID_seq"', 5, false);


--
-- Name: TYPE_COMPTE_PCG; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_COMPTE_PCG" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "RACINE" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto48"."TYPE_COMPTE_PCG" OWNER TO openconcerto;

--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_COMPTE_PCG_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TYPE_COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_COMPTE_PCG_ID_seq" OWNED BY "TYPE_COMPTE_PCG"."ID";


--
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_COMPTE_PCG_ID_seq"', 8, false);


--
-- Name: TYPE_LETTRE_RELANCE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_LETTRE_RELANCE" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODELE" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."TYPE_LETTRE_RELANCE" OWNER TO openconcerto;

--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_LETTRE_RELANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TYPE_LETTRE_RELANCE_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_LETTRE_RELANCE_ID_seq" OWNED BY "TYPE_LETTRE_RELANCE"."ID";


--
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_LETTRE_RELANCE_ID_seq"', 3, false);


--
-- Name: TYPE_REGLEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "TYPE_REGLEMENT" (
    "COMPTANT" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ECHEANCE" boolean DEFAULT false,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE_FOURN" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TYPE_REGLEMENT" OWNER TO openconcerto;

--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "TYPE_REGLEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TYPE_REGLEMENT_ID_seq" OWNER TO openconcerto;

--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "TYPE_REGLEMENT_ID_seq" OWNED BY "TYPE_REGLEMENT"."ID";


--
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"TYPE_REGLEMENT_ID_seq"', 9, true);


--
-- Name: UNITE_VENTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "UNITE_VENTE" (
    "ID" integer NOT NULL,
    "CODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "A_LA_PIECE" boolean DEFAULT false,
    "INFOS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."UNITE_VENTE" OWNER TO openconcerto;

--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "UNITE_VENTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."UNITE_VENTE_ID_seq" OWNER TO openconcerto;

--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "UNITE_VENTE_ID_seq" OWNED BY "UNITE_VENTE"."ID";


--
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"UNITE_VENTE_ID_seq"', 10, true);


--
-- Name: VARIABLE_SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "VARIABLE_SALARIE" (
    "HEURE_200" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "HEURE_125" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ORDRE" numeric(16,8),
    "CONGES_PRIS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "HEURE_TRAV" real DEFAULT 0,
    "HEURE_ABS" real DEFAULT 0,
    "HEURE_150" real DEFAULT 0,
    "HEURE_110" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."VARIABLE_SALARIE" OWNER TO openconcerto;

--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "VARIABLE_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."VARIABLE_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "VARIABLE_SALARIE_ID_seq" OWNED BY "VARIABLE_SALARIE"."ID";


--
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE SET; Schema: OpenConcerto48; Owner: openconcerto
--

SELECT pg_catalog.setval('"VARIABLE_SALARIE_ID_seq"', 2, false);


SET search_path = public, pg_catalog;

--
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: public; Owner: openconcerto; Tablespace: 
--

CREATE TABLE "FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

SET search_path = "Common", pg_catalog;

--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "ACCES_SOCIETE" ALTER COLUMN "ID" SET DEFAULT nextval('"ACCES_SOCIETE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "ADRESSE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"ADRESSE_COMMON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "BANQUE_POLE_PRODUIT" ALTER COLUMN "ID" SET DEFAULT nextval('"BANQUE_POLE_PRODUIT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "CAISSE_COTISATION" ALTER COLUMN "ID" SET DEFAULT nextval('"CAISSE_COTISATION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "COMPTE_PCE_DEFAULT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMPTE_PCE_DEFAULT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "CONNEXION" ALTER COLUMN "ID" SET DEFAULT nextval('"CONNEXION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "DEVISE" ALTER COLUMN "ID" SET DEFAULT nextval('"DEVISE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "DOMAINE" ALTER COLUMN "ID" SET DEFAULT nextval('"DOMAINE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "ECHANTILLON" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHANTILLON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "EXERCICE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"EXERCICE_COMMON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "FWK_RIV_METADATA" ALTER COLUMN "ID" SET DEFAULT nextval('"FWK_RIV_METADATA_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "IMPRESSION_RUBRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"IMPRESSION_RUBRIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "INDICE" ALTER COLUMN "ID" SET DEFAULT nextval('"INDICE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "OBJET" ALTER COLUMN "ID" SET DEFAULT nextval('"OBJET_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "PERIODE_VALIDITE" ALTER COLUMN "ID" SET DEFAULT nextval('"PERIODE_VALIDITE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "POLE_PRODUIT" ALTER COLUMN "ID" SET DEFAULT nextval('"POLE_PRODUIT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "PREF_NODE" ALTER COLUMN "ID" SET DEFAULT nextval('"PREF_NODE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "PROFIL_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"PROFIL_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "PROFIL_PAYE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"PROFIL_PAYE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "RIGHT" ALTER COLUMN "ID" SET DEFAULT nextval('"RIGHT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "RUBRIQUE_BRUT" ALTER COLUMN "ID" SET DEFAULT nextval('"RUBRIQUE_BRUT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "RUBRIQUE_COMM" ALTER COLUMN "ID" SET DEFAULT nextval('"RUBRIQUE_COMM_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "RUBRIQUE_COTISATION" ALTER COLUMN "ID" SET DEFAULT nextval('"RUBRIQUE_COTISATION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "RUBRIQUE_NET" ALTER COLUMN "ID" SET DEFAULT nextval('"RUBRIQUE_NET_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "SERVICE" ALTER COLUMN "ID" SET DEFAULT nextval('"SERVICE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "SOCIETE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"SOCIETE_COMMON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"STOCK_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "TACHE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"TACHE_COMMON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "TACHE_LISTENER_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"TACHE_LISTENER_COMMON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "TACHE_RIGHTS" ALTER COLUMN "ID" SET DEFAULT nextval('"TACHE_RIGHTS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "TYPE_MODELE" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_MODELE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "TYPE_RUBRIQUE_BRUT" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_RUBRIQUE_BRUT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "TYPE_RUBRIQUE_NET" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_RUBRIQUE_NET_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "USER_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"USER_COMMON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "USER_RIGHT" ALTER COLUMN "ID" SET DEFAULT nextval('"USER_RIGHT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "VARIABLE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"VARIABLE_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE "VILLE" ALTER COLUMN "ID" SET DEFAULT nextval('"VILLE_ID_seq"'::regclass);


SET search_path = "Default", pg_catalog;

--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ACOMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"ACOMPTE_ID_seq"'::regclass);


--
-- Name: ID_ADRESSE; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ADRESSE" ALTER COLUMN "ID_ADRESSE" SET DEFAULT nextval('"ADRESSE_ID_ADRESSE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ARTICLE_DESIGNATION" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_DESIGNATION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ARTICLE_TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_TARIF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ASSOCIATION_COMPTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "AVOIR_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "AVOIR_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "AXE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"AXE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "BON_DE_LIVRAISON" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_DE_LIVRAISON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "BON_DE_LIVRAISON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_DE_LIVRAISON_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "BON_RECEPTION" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_RECEPTION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "BON_RECEPTION_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_RECEPTION_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"CAISSE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CHEQUE_AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_AVOIR_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CHEQUE_A_ENCAISSER" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_A_ENCAISSER_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CHEQUE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CLASSEMENT_CONVENTIONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"CLASSEMENT_CONVENTIONNEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CLASSE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"CLASSE_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"CLIENT_ID_CLIENT_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_CARACT_ACTIVITE" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_CARACT_ACTIVITE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_CONTRAT_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_CONTRAT_TRAVAIL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_DROIT_CONTRAT" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_DROIT_CONTRAT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_EMPLOI" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_EMPLOI_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_REGIME" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_REGIME_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_CATEGORIEL" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_CATEGORIEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_CAT_CONV" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_CAT_CONV_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_PROF" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_PROF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COMMANDE" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COMMANDE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COMMANDE_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COMMANDE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID_COMMERCIAL; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COMMERCIAL" ALTER COLUMN "ID_COMMERCIAL" SET DEFAULT nextval('"COMMERCIAL_ID_COMMERCIAL_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COMPTE_PCE" ALTER COLUMN "ID" SET DEFAULT nextval('"COMPTE_PCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"COMPTE_PCG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CONTACT" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CONTACT_ADMINISTRATIF" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_ADMINISTRATIF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CONTACT_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CONTRAT_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTRAT_SALARIE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COURRIER_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CUMULS_CONGES" ALTER COLUMN "ID" SET DEFAULT nextval('"CUMULS_CONGES_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "CUMULS_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"CUMULS_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "DEPARTEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"DEPARTEMENT_ID_seq"'::regclass);


--
-- Name: ID_DEVIS; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "DEVIS" ALTER COLUMN "ID_DEVIS" SET DEFAULT nextval('"DEVIS_ID_DEVIS_seq"'::regclass);


--
-- Name: ID_DEVIS_ELEMENT; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "DEVIS_ELEMENT" ALTER COLUMN "ID_DEVIS_ELEMENT" SET DEFAULT nextval('"DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ECHANTILLON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHANTILLON_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ECHEANCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHEANCE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ECHEANCE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHEANCE_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ECRITURE" ALTER COLUMN "ID" SET DEFAULT nextval('"ECRITURE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "EMPLOYEUR_MULTIPLE" ALTER COLUMN "ID" SET DEFAULT nextval('"EMPLOYEUR_MULTIPLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ENCAISSER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"ENCAISSER_MONTANT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ENCAISSER_MONTANT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ENCAISSER_MONTANT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ETAT_CIVIL" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_CIVIL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ETAT_DEVIS" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_DEVIS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "ETAT_RAPPORT" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_RAPPORT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "FAMILLE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"FAMILLE_ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "FICHE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"FICHE_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "FICHE_PAYE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"FICHE_PAYE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID_FOURNISSEUR; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "FOURNISSEUR" ALTER COLUMN "ID_FOURNISSEUR" SET DEFAULT nextval('"FOURNISSEUR_ID_FOURNISSEUR_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "FWK_MODULE_METADATA" ALTER COLUMN "ID" SET DEFAULT nextval('"FWK_MODULE_METADATA_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "IDCC" ALTER COLUMN "ID" SET DEFAULT nextval('"IDCC_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "INFOS_SALARIE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"INFOS_SALARIE_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "JOURNAL" ALTER COLUMN "ID" SET DEFAULT nextval('"JOURNAL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "LANGUE" ALTER COLUMN "ID" SET DEFAULT nextval('"LANGUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "METRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"METRIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MODELE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODELE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MODELE_COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"MODELE_COURRIER_CLIENT_ID_seq"'::regclass);


--
-- Name: ID_MODE_REGLEMENT; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MODE_REGLEMENT" ALTER COLUMN "ID_MODE_REGLEMENT" SET DEFAULT nextval('"MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MODE_REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODE_REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MODE_VENTE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODE_VENTE_ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MOIS" ALTER COLUMN "ID" SET DEFAULT nextval('"MOIS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MOUVEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"MOUVEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "MOUVEMENT_STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"MOUVEMENT_STOCK_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "NATURE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"NATURE_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "NUMEROTATION_AUTO" ALTER COLUMN "ID" SET DEFAULT nextval('"NUMEROTATION_AUTO_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "OBJECTIF_COMMERCIAL" ALTER COLUMN "ID" SET DEFAULT nextval('"OBJECTIF_COMMERCIAL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "PAYS" ALTER COLUMN "ID" SET DEFAULT nextval('"PAYS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "PIECE" ALTER COLUMN "ID" SET DEFAULT nextval('"PIECE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "POSTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"POSTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "PREFERENCES" ALTER COLUMN "ID" SET DEFAULT nextval('"PREFERENCES_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "PREFS_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"PREFS_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "REFERENCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"REFERENCE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "REGIME_BASE" ALTER COLUMN "ID" SET DEFAULT nextval('"REGIME_BASE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "REGLER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"REGLER_MONTANT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"RELANCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "REPARTITION_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"REPARTITION_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "REPARTITION_ANALYTIQUE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SAISIE_ACHAT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_ACHAT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SAISIE_KM" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_KM_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SAISIE_KM_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_KM_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_COMPTOIR" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_COMPTOIR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_FACTURE" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_FACTURE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_FACTURE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"SALARIE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "SITUATION_FAMILIALE" ALTER COLUMN "ID" SET DEFAULT nextval('"SITUATION_FAMILIALE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"STOCK_ID_seq"'::regclass);


--
-- Name: ID_STYLE; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "STYLE" ALTER COLUMN "ID_STYLE" SET DEFAULT nextval('"STYLE_ID_STYLE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"TARIF_ID_seq"'::regclass);


--
-- Name: ID_TAXE; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "TAXE" ALTER COLUMN "ID_TAXE" SET DEFAULT nextval('"TAXE_ID_TAXE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "TICKET_CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"TICKET_CAISSE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "TITRE_PERSONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"TITRE_PERSONNEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "TYPE_COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_COMPTE_PCG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "TYPE_LETTRE_RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_LETTRE_RELANCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "TYPE_REGLEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_REGLEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "UNITE_VENTE" ALTER COLUMN "ID" SET DEFAULT nextval('"UNITE_VENTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE "VARIABLE_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"VARIABLE_SALARIE_ID_seq"'::regclass);


SET search_path = "OpenConcerto42", pg_catalog;

--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ACOMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"ACOMPTE_ID_seq"'::regclass);


--
-- Name: ID_ADRESSE; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ADRESSE" ALTER COLUMN "ID_ADRESSE" SET DEFAULT nextval('"ADRESSE_ID_ADRESSE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ARTICLE_DESIGNATION" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_DESIGNATION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ARTICLE_TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_TARIF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ASSOCIATION_COMPTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "AVOIR_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "AVOIR_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "AXE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"AXE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "BON_DE_LIVRAISON" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_DE_LIVRAISON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "BON_DE_LIVRAISON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_DE_LIVRAISON_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "BON_RECEPTION" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_RECEPTION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "BON_RECEPTION_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_RECEPTION_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"CAISSE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CHEQUE_AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_AVOIR_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CHEQUE_A_ENCAISSER" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_A_ENCAISSER_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CHEQUE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CLASSEMENT_CONVENTIONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"CLASSEMENT_CONVENTIONNEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CLASSE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"CLASSE_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_CARACT_ACTIVITE" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_CARACT_ACTIVITE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_CONTRAT_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_CONTRAT_TRAVAIL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_DROIT_CONTRAT" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_DROIT_CONTRAT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_EMPLOI" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_EMPLOI_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_REGIME" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_REGIME_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_CATEGORIEL" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_CATEGORIEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_CAT_CONV" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_CAT_CONV_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_PROF" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_PROF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COMMANDE" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COMMANDE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COMMANDE_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COMMANDE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID_COMMERCIAL; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COMMERCIAL" ALTER COLUMN "ID_COMMERCIAL" SET DEFAULT nextval('"COMMERCIAL_ID_COMMERCIAL_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COMPTE_PCE" ALTER COLUMN "ID" SET DEFAULT nextval('"COMPTE_PCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"COMPTE_PCG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CONTACT" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CONTACT_ADMINISTRATIF" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_ADMINISTRATIF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CONTACT_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CONTRAT_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTRAT_SALARIE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COURRIER_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CUMULS_CONGES" ALTER COLUMN "ID" SET DEFAULT nextval('"CUMULS_CONGES_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "CUMULS_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"CUMULS_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "DEPARTEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"DEPARTEMENT_ID_seq"'::regclass);


--
-- Name: ID_DEVIS; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "DEVIS" ALTER COLUMN "ID_DEVIS" SET DEFAULT nextval('"DEVIS_ID_DEVIS_seq"'::regclass);


--
-- Name: ID_DEVIS_ELEMENT; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "DEVIS_ELEMENT" ALTER COLUMN "ID_DEVIS_ELEMENT" SET DEFAULT nextval('"DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ECHANTILLON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHANTILLON_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ECHEANCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHEANCE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ECHEANCE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHEANCE_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ECRITURE" ALTER COLUMN "ID" SET DEFAULT nextval('"ECRITURE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "EMPLOYEUR_MULTIPLE" ALTER COLUMN "ID" SET DEFAULT nextval('"EMPLOYEUR_MULTIPLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ENCAISSER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"ENCAISSER_MONTANT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ENCAISSER_MONTANT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ENCAISSER_MONTANT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ETAT_CIVIL" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_CIVIL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ETAT_DEVIS" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_DEVIS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "ETAT_RAPPORT" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_RAPPORT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "FAMILLE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"FAMILLE_ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "FICHE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"FICHE_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "FICHE_PAYE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"FICHE_PAYE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID_FOURNISSEUR; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "FOURNISSEUR" ALTER COLUMN "ID_FOURNISSEUR" SET DEFAULT nextval('"FOURNISSEUR_ID_FOURNISSEUR_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "FWK_MODULE_METADATA" ALTER COLUMN "ID" SET DEFAULT nextval('"FWK_MODULE_METADATA_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "IDCC" ALTER COLUMN "ID" SET DEFAULT nextval('"IDCC_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "INFOS_SALARIE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"INFOS_SALARIE_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "JOURNAL" ALTER COLUMN "ID" SET DEFAULT nextval('"JOURNAL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "LANGUE" ALTER COLUMN "ID" SET DEFAULT nextval('"LANGUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "LEAD" ALTER COLUMN "ID" SET DEFAULT nextval('"LEAD_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "METRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"METRIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MODELE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODELE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MODELE_COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"MODELE_COURRIER_CLIENT_ID_seq"'::regclass);


--
-- Name: ID_MODE_REGLEMENT; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MODE_REGLEMENT" ALTER COLUMN "ID_MODE_REGLEMENT" SET DEFAULT nextval('"MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MODE_REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODE_REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MODE_VENTE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODE_VENTE_ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MOIS" ALTER COLUMN "ID" SET DEFAULT nextval('"MOIS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MOUVEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"MOUVEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "MOUVEMENT_STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"MOUVEMENT_STOCK_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "NATURE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"NATURE_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "NUMEROTATION_AUTO" ALTER COLUMN "ID" SET DEFAULT nextval('"NUMEROTATION_AUTO_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "OBJECTIF_COMMERCIAL" ALTER COLUMN "ID" SET DEFAULT nextval('"OBJECTIF_COMMERCIAL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "PAYS" ALTER COLUMN "ID" SET DEFAULT nextval('"PAYS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "PIECE" ALTER COLUMN "ID" SET DEFAULT nextval('"PIECE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "POSTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"POSTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "PREFERENCES" ALTER COLUMN "ID" SET DEFAULT nextval('"PREFERENCES_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "PREFS_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"PREFS_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "PREF_NODE" ALTER COLUMN "ID" SET DEFAULT nextval('"PREF_NODE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "REFERENCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"REFERENCE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "REGIME_BASE" ALTER COLUMN "ID" SET DEFAULT nextval('"REGIME_BASE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "REGLER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"REGLER_MONTANT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"RELANCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "REPARTITION_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"REPARTITION_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "REPARTITION_ANALYTIQUE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SAISIE_ACHAT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_ACHAT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SAISIE_KM" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_KM_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SAISIE_KM_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_KM_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_COMPTOIR" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_COMPTOIR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_FACTURE" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_FACTURE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_FACTURE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"SALARIE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "SITUATION_FAMILIALE" ALTER COLUMN "ID" SET DEFAULT nextval('"SITUATION_FAMILIALE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"STOCK_ID_seq"'::regclass);


--
-- Name: ID_STYLE; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "STYLE" ALTER COLUMN "ID_STYLE" SET DEFAULT nextval('"STYLE_ID_STYLE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"TARIF_ID_seq"'::regclass);


--
-- Name: ID_TAXE; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "TAXE" ALTER COLUMN "ID_TAXE" SET DEFAULT nextval('"TAXE_ID_TAXE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "TICKET_CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"TICKET_CAISSE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "TITRE_PERSONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"TITRE_PERSONNEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "TYPE_COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_COMPTE_PCG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "TYPE_LETTRE_RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_LETTRE_RELANCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "TYPE_REGLEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_REGLEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "UNITE_VENTE" ALTER COLUMN "ID" SET DEFAULT nextval('"UNITE_VENTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE "VARIABLE_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"VARIABLE_SALARIE_ID_seq"'::regclass);


SET search_path = "OpenConcerto48", pg_catalog;

--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ACOMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"ACOMPTE_ID_seq"'::regclass);


--
-- Name: ID_ADRESSE; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ADRESSE" ALTER COLUMN "ID_ADRESSE" SET DEFAULT nextval('"ADRESSE_ID_ADRESSE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ARTICLE_DESIGNATION" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_DESIGNATION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ARTICLE_TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"ARTICLE_TARIF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ASSOCIATION_COMPTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "AVOIR_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "AVOIR_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"AVOIR_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "AXE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"AXE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "BON_DE_LIVRAISON" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_DE_LIVRAISON_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "BON_DE_LIVRAISON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_DE_LIVRAISON_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "BON_RECEPTION" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_RECEPTION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "BON_RECEPTION_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"BON_RECEPTION_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"CAISSE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CHEQUE_AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_AVOIR_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CHEQUE_A_ENCAISSER" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_A_ENCAISSER_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CHEQUE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"CHEQUE_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CLASSEMENT_CONVENTIONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"CLASSEMENT_CONVENTIONNEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CLASSE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"CLASSE_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_CARACT_ACTIVITE" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_CARACT_ACTIVITE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_CONTRAT_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_CONTRAT_TRAVAIL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_DROIT_CONTRAT" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_DROIT_CONTRAT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_EMPLOI" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_EMPLOI_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_REGIME" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_REGIME_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_CATEGORIEL" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_CATEGORIEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_CAT_CONV" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_CAT_CONV_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CODE_STATUT_PROF" ALTER COLUMN "ID" SET DEFAULT nextval('"CODE_STATUT_PROF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COMMANDE" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COMMANDE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COMMANDE_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COMMANDE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COMMANDE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID_COMMERCIAL; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COMMERCIAL" ALTER COLUMN "ID_COMMERCIAL" SET DEFAULT nextval('"COMMERCIAL_ID_COMMERCIAL_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COMPTE_PCE" ALTER COLUMN "ID" SET DEFAULT nextval('"COMPTE_PCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"COMPTE_PCG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CONTACT" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CONTACT_ADMINISTRATIF" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_ADMINISTRATIF_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CONTACT_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTACT_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CONTRAT_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"CONTRAT_SALARIE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"COURRIER_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CUMULS_CONGES" ALTER COLUMN "ID" SET DEFAULT nextval('"CUMULS_CONGES_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "CUMULS_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"CUMULS_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "DEPARTEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"DEPARTEMENT_ID_seq"'::regclass);


--
-- Name: ID_DEVIS; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "DEVIS" ALTER COLUMN "ID_DEVIS" SET DEFAULT nextval('"DEVIS_ID_DEVIS_seq"'::regclass);


--
-- Name: ID_DEVIS_ELEMENT; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "DEVIS_ELEMENT" ALTER COLUMN "ID_DEVIS_ELEMENT" SET DEFAULT nextval('"DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ECHANTILLON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHANTILLON_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ECHEANCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHEANCE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ECHEANCE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"ECHEANCE_FOURNISSEUR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ECRITURE" ALTER COLUMN "ID" SET DEFAULT nextval('"ECRITURE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "EMPLOYEUR_MULTIPLE" ALTER COLUMN "ID" SET DEFAULT nextval('"EMPLOYEUR_MULTIPLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ENCAISSER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"ENCAISSER_MONTANT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ENCAISSER_MONTANT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"ENCAISSER_MONTANT_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ETAT_CIVIL" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_CIVIL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ETAT_DEVIS" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_DEVIS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "ETAT_RAPPORT" ALTER COLUMN "ID" SET DEFAULT nextval('"ETAT_RAPPORT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "FAMILLE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"FAMILLE_ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "FICHE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"FICHE_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "FICHE_PAYE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"FICHE_PAYE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID_FOURNISSEUR; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "FOURNISSEUR" ALTER COLUMN "ID_FOURNISSEUR" SET DEFAULT nextval('"FOURNISSEUR_ID_FOURNISSEUR_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "FWK_MODULE_METADATA" ALTER COLUMN "ID" SET DEFAULT nextval('"FWK_MODULE_METADATA_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "IDCC" ALTER COLUMN "ID" SET DEFAULT nextval('"IDCC_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "INFOS_SALARIE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"INFOS_SALARIE_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "JOURNAL" ALTER COLUMN "ID" SET DEFAULT nextval('"JOURNAL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "LANGUE" ALTER COLUMN "ID" SET DEFAULT nextval('"LANGUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "METRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"METRIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MODELE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODELE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MODELE_COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"MODELE_COURRIER_CLIENT_ID_seq"'::regclass);


--
-- Name: ID_MODE_REGLEMENT; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MODE_REGLEMENT" ALTER COLUMN "ID_MODE_REGLEMENT" SET DEFAULT nextval('"MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MODE_REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODE_REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MODE_VENTE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"MODE_VENTE_ARTICLE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MOIS" ALTER COLUMN "ID" SET DEFAULT nextval('"MOIS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MOUVEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"MOUVEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "MOUVEMENT_STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"MOUVEMENT_STOCK_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "NATURE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"NATURE_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "NUMEROTATION_AUTO" ALTER COLUMN "ID" SET DEFAULT nextval('"NUMEROTATION_AUTO_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "OBJECTIF_COMMERCIAL" ALTER COLUMN "ID" SET DEFAULT nextval('"OBJECTIF_COMMERCIAL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "PAYS" ALTER COLUMN "ID" SET DEFAULT nextval('"PAYS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "PIECE" ALTER COLUMN "ID" SET DEFAULT nextval('"PIECE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "POSTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"POSTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "PREFERENCES" ALTER COLUMN "ID" SET DEFAULT nextval('"PREFERENCES_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "PREFS_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"PREFS_COMPTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "REFERENCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"REFERENCE_CLIENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "REGIME_BASE" ALTER COLUMN "ID" SET DEFAULT nextval('"REGIME_BASE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "REGLER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"REGLER_MONTANT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"RELANCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "REPARTITION_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"REPARTITION_ANALYTIQUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "REPARTITION_ANALYTIQUE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SAISIE_ACHAT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_ACHAT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SAISIE_KM" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_KM_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SAISIE_KM_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_KM_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_COMPTOIR" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_COMPTOIR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_FACTURE" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_FACTURE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SAISIE_VENTE_FACTURE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"SALARIE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "SITUATION_FAMILIALE" ALTER COLUMN "ID" SET DEFAULT nextval('"SITUATION_FAMILIALE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"STOCK_ID_seq"'::regclass);


--
-- Name: ID_STYLE; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "STYLE" ALTER COLUMN "ID_STYLE" SET DEFAULT nextval('"STYLE_ID_STYLE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"TARIF_ID_seq"'::regclass);


--
-- Name: ID_TAXE; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "TAXE" ALTER COLUMN "ID_TAXE" SET DEFAULT nextval('"TAXE_ID_TAXE_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "TICKET_CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"TICKET_CAISSE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "TITRE_PERSONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"TITRE_PERSONNEL_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "TYPE_COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_COMPTE_PCG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "TYPE_LETTRE_RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_LETTRE_RELANCE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "TYPE_REGLEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"TYPE_REGLEMENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "UNITE_VENTE" ALTER COLUMN "ID" SET DEFAULT nextval('"UNITE_VENTE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER TABLE "VARIABLE_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"VARIABLE_SALARIE_ID_seq"'::regclass);


SET search_path = "Common", pg_catalog;

--
-- Data for Name: ACCES_SOCIETE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "ACCES_SOCIETE" ("ID", "ID_USER_COMMON", "ID_SOCIETE_COMMON", "ARCHIVE", "ORDRE") FROM stdin;
1	1	1	0	0.00000000
\.


--
-- Data for Name: ADRESSE_COMMON; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "ADRESSE_COMMON" ("ID", "RUE", "CODE_POSTAL", "PAYS", "VILLE", "ARCHIVE", "ORDRE", "CEDEX", "HAS_CEDEX") FROM stdin;
1	 	 	France	 	0	0.00000000	\N	f
2	2	1	France	1	0	1.00000000	\N	f
3	d	2	France	d	0	2.00000000	\N	f
7	125\t	80542	France	HUI	0	6.00000000	\N	f
8	22, place du test	65987	France	JJJ	0	7.00000000	\N	f
10	 	 	 	 	0	0.00000000	\N	f
11	 	 	 	 	0	0.00000000	\N	f
12	 	 	 	 	0	0.00000000	\N	f
13	 	 	 	 	0	0.00000000	\N	f
14	 	 	 	 	0	0.00000000	\N	f
15	 	 	 	 	0	0.00000000	\N	f
16	 	 	 	 	0	0.00000000	\N	f
17	22	32	France	ghu	0	15.00000000	\N	f
42	22	3	France	23	0	40.00000000	\N	f
43	22, place de la libération	80100	France	Abbeville	0	41.00000000	\N	f
47	1	2	France	2	0	45.00000000	\N	f
48	t	t	France	t	0	46.00000000	\N	f
49	f	f	France	f	0	47.00000000	\N	f
52	Route du Crotoy	80132	France	Grand-laviers (80132)	0	50.00000000	\N	f
53	1 place de l'amiral Courbet		France	Abbeville (80100)	0	51.00000000	\N	f
54	1 place de l'Amiral Courbet		France	Abbeville (80100)	0	52.00000000	\N	f
55	22 place de la liberation		France	Abbeville (80100)	0	53.00000000	\N	f
58			France	Aast (64460)	1	55.00000000	\N	f
59			France	Aast (64460)	1	56.00000000	\N	f
57	dddd		France	Abainville (55130)	1	54.00000000	\N	f
60	19 rue poincare		France	VERDUN (55100)	0	57.00000000	\N	f
61			France	Abbeville (80100)	0	58.00000000	\N	f
\.


--
-- Data for Name: BANQUE_POLE_PRODUIT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "BANQUE_POLE_PRODUIT" ("ID", "NOM", "NUMERO_RUE", "VOIE", "RUE", "CODE_POSTAL", "VILLE", "CODE_ETS", "CODE_GUICHET", "NUMERO_COMPTE", "CLE_RICE", "DOMICILIATION", "BIC", "IBAN", "INFOS", "CODE", "ORDRE", "ARCHIVE", "ID_POLE_PRODUIT") FROM stdin;
1																0.00000000	0	1
\.


--
-- Data for Name: CAISSE_COTISATION; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "CAISSE_COTISATION" ("ID", "NOM", "ID_ADRESSE_COMMON", "TEL", "MAIL", "TEL_PORTABLE", "ARCHIVE", "ORDRE") FROM stdin;
1	Indéfini	1	 	 	 	1	1.00000000
2	AGIRC	10	 	 	 	0	1.00000000
3	ARRCO	11	 	 	 	0	2.00000000
4	FISC	12	 	 	 	0	3.00000000
5	MUTUELLE	13	 	 	 	0	4.00000000
6	ASSEDIC	14	 	 	 	0	5.00000000
7	CAISSEPREV	15	 	 	 	0	6.00000000
8	URSSAF	16	 	 	 	0	7.00000000
\.


--
-- Data for Name: COMPLETION; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "COMPLETION" ("CHAMP", "LABEL", "ARCHIVE", "ORDRE") FROM stdin;
\.


--
-- Data for Name: COMPTE_PCE_DEFAULT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "COMPTE_PCE_DEFAULT" ("ID", "NOM", "NUMERO_DEFAULT", "ARCHIVE", "ORDRE") FROM stdin;
1	 	 	0	0.00000000
2	Fournisseurs	40	0	0.00000000
3	Achats	60	0	0.00000000
4	Clients	41	0	0.00000000
5	VentesProduits	701	0	0.00000000
6	VentesServices	706	0	0.00000000
7	TVACollectee	4457	0	0.00000000
8	TVADeductible	4456	0	0.00000000
9	PayeAcompte	425	0	0.00000000
10	PayeReglementAcompte	511	0	0.00000000
11	PayeRemunerationPersonnel	641	0	0.00000000
12	PayeReglement	421	0	0.00000000
21	TVAIntraComm	4452	0	0.00000000
22	TVAImmo	445620	0	0.00000000
23	BilanOuverture	890	0	0.00000000
24	BilanFermeture	891	0	0.00000000
26	AchatsIntra	607120	0	0.00000000
27	ResultatPerte	129	0	0.00000000
25	Resultat	120	0	0.00000000
28	Factor	467000	0	0.00000000
13	AchatCheque	512	0	0.00000000
14	AchatCB	512	0	0.00000000
17	VenteCheque	512	0	0.00000000
15	AchatTraite	512	0	0.00000000
16	AchatEspece	53	0	0.00000000
20	VenteEspece	53	0	0.00000000
18	VenteCB	512	0	0.00000000
19	VenteTraite	512	0	0.00000000
\.


--
-- Data for Name: CONNEXION; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "CONNEXION" ("LOGIN", "MDP", "DATE", "IP", "ARCHIVE", "ORDRE", "ID", "FAILED") FROM stdin;
\.


--
-- Data for Name: DEVISE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "DEVISE" ("ID", "CODE", "NOM", "LIBELLE", "LIBELLE_CENT", "TAUX", "ARCHIVE", "ORDRE") FROM stdin;
1					1.00000000	0	0.00000000
\.


--
-- Data for Name: DOMAINE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "DOMAINE" ("ID", "CODE", "NOM", "CONDITION", "Q18", "ORDRE", "ARCHIVE") FROM stdin;
1				f	0.00000000	0
\.


--
-- Data for Name: ECHANTILLON; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "ECHANTILLON" ("ARCHIVE", "ORDRE", "ID", "NOM", "PV_HT", "PV_TTC") FROM stdin;
0	0.00000000	1		0	0
\.


--
-- Data for Name: EXERCICE_COMMON; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "EXERCICE_COMMON" ("ID", "DATE_DEB", "DATE_FIN", "NUMERO", "CLOTURE", "ARCHIVE", "ORDRE", "DATE_CLOTURE", "ID_SOCIETE_COMMON") FROM stdin;
1	2006-01-01	2006-12-31	1	f	0	0.00000000	\N	1
50	2010-01-01	2010-12-31	1	t	0	49.00000000	2010-12-31	42
51	2010-01-01	2010-12-31	1	f	1	50.00000000	\N	1
52	2010-01-01	2010-12-31	1	t	0	51.00000000	2010-12-31	42
60	2011-01-01	2011-12-31	1	f	0	59.00000000	\N	48
59	2012-01-01	2012-12-31	1	f	1	58.00000000	\N	42
58	2011-01-01	2011-12-31	1	f	0	57.00000000	\N	42
\.


--
-- Data for Name: FWK_RIV_METADATA; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "FWK_RIV_METADATA" ("ID", "ELEMENT_CODE", "COMPONENT_CODE", "ITEM", "LABEL", "COLUMN_TITLE", "DOCUMENTATION") FROM stdin;
\.


--
-- Data for Name: FWK_SCHEMA_METADATA; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "FWK_SCHEMA_METADATA" ("NAME", "VALUE") FROM stdin;
undefined ID policy	min
VERSION	20120723-195145.233+0200
\.


--
-- Data for Name: FWK_UNDEFINED_IDS; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "FWK_UNDEFINED_IDS" ("TABLENAME", "UNDEFINED_ID") FROM stdin;
ADRESSE_COMMON	1
CAISSE_COTISATION	1
EXERCICE_COMMON	1
IMPRESSION_RUBRIQUE	1
PERIODE_VALIDITE	1
PROFIL_PAYE	1
PROFIL_PAYE_ELEMENT	1
RUBRIQUE_BRUT	1
RUBRIQUE_COMM	1
RUBRIQUE_COTISATION	1
RUBRIQUE_NET	1
SOCIETE_COMMON	1
TACHE_COMMON	1
TACHE_LISTENER_COMMON	1
TYPE_RUBRIQUE_NET	1
USER_COMMON	1
USER_RIGHT_COMMON	1
VARIABLE_PAYE	1
CONNEXION	1
VILLE	1
POLE_PRODUIT	1
OBJET	1
DOMAINE	1
BANQUE_POLE_PRODUIT	1
SERVICE	1
ECHANTILLON	1
RIGHT	1
RIGHTS	1
USER_RIGHT	1
COMPTE_PCE_DEFAULT	1
INDICE	1
STOCK	1
TACHE_RIGHTS	1
ACCES_SOCIETE	1
TYPE_RUBRIQUE_BRUT	1
PREF_NODE	\N
PREF_VALUE	\N
FWK_RIV_METADATA	\N
\.


--
-- Data for Name: IMPRESSION_RUBRIQUE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "IMPRESSION_RUBRIQUE" ("ID", "NOM", "ARCHIVE", "ORDRE") FROM stdin;
1	Indéfini	0	1.00000000
2	Si non nul	0	1.00000000
3	Toujours	0	1.00000000
4	Jamais	0	1.00000000
\.


--
-- Data for Name: INDICE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "INDICE" ("ANNEE", "ID", "ORDRE", "ARCHIVE", "JANVIER", "FEVRIER", "MARS", "AVRIL", "MAI", "JUIN", "JUILLET", "AOUT", "SEPTEMBRE", "OCTOBRE", "NOVEMBRE", "DECEMBRE") FROM stdin;
2009	3	2.00000000	1	0	0	0	0	0	0	0	0	0	0	0	0
2010	4	3.00000000	1	0	0	0	0	0	0	0	0	0	0	0	0
2011	5	4.00000000	1	0	0	0	0	0	0	0	0	0	0	0	0
2008	2	1.00000000	0	76470	76650	76940	77540	77900	0	0	0	0	0	0	0
2007	1	0.00000000	0	74380	74750	74830	74990	75110	75120	75340	75320	75450	75750	76020	76230
2009	6	5.00000000	0	0	0	0	0	0	0	0	0	0	0	0	0
\.


--
-- Data for Name: OBJET; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "OBJET" ("ID", "CODE", "NOM", "ID_DOMAINE", "ARCHIVE", "ORDRE") FROM stdin;
1			1	0	0.00000000
\.


--
-- Data for Name: PERIODE_VALIDITE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "PERIODE_VALIDITE" ("ID", "JANVIER", "FEVRIER", "MARS", "AVRIL", "MAI", "JUIN", "JUILLET", "AOUT", "SEPTEMBRE", "OCTOBRE", "NOVEMBRE", "DECEMBRE", "ARCHIVE", "ORDRE") FROM stdin;
1	t	t	t	t	t	t	t	t	t	t	t	t	0	1.00000000
2	t	t	t	t	t	t	t	t	t	t	t	t	1	1.00000000
3	t	t	t	t	t	t	t	t	t	t	t	t	1	1.00000000
4	t	t	t	t	t	t	t	t	t	t	t	t	1	1.00000000
5	t	t	t	t	t	t	t	t	t	t	t	t	0	1.00000000
6	t	t	t	t	t	t	t	t	t	t	t	t	1	1.00000000
7	t	t	t	t	t	t	t	t	t	t	t	t	1	1.00000000
8	t	t	t	t	t	t	t	t	t	t	t	t	0	1.00000000
9	t	t	t	t	t	t	t	t	t	t	t	t	0	1.00000000
10	t	t	t	t	t	t	t	t	t	t	t	t	0	1.00000000
11	t	t	t	t	t	t	t	t	t	t	t	t	0	1.00000000
12	t	t	t	t	t	t	t	t	t	t	t	t	1	1.00000000
13	t	t	t	t	t	t	t	t	t	t	t	t	1	1.00000000
14	t	t	t	t	t	t	t	t	t	t	t	t	0	13.00000000
15	t	t	t	t	t	t	t	t	t	t	t	t	0	14.00000000
16	t	t	t	t	t	t	t	t	t	t	t	t	0	15.00000000
18	t	t	t	t	t	t	t	t	t	t	t	t	0	17.00000000
19	t	t	t	t	t	t	t	t	t	t	t	t	0	18.00000000
20	t	t	t	t	t	t	t	t	t	t	t	t	0	19.00000000
21	t	t	t	t	t	t	t	t	t	t	t	t	0	20.00000000
22	t	t	t	t	t	t	t	t	t	t	t	t	0	21.00000000
23	t	t	t	t	t	t	t	t	t	t	t	t	0	22.00000000
24	t	t	t	t	t	t	t	t	t	t	t	t	0	23.00000000
25	t	t	t	t	t	t	t	t	t	t	t	t	0	24.00000000
26	t	t	t	t	t	t	t	t	t	t	t	t	0	25.00000000
27	t	t	t	t	t	t	t	t	t	t	t	t	0	26.00000000
28	t	t	t	t	t	t	t	t	t	t	t	t	0	27.00000000
29	t	t	t	t	t	t	t	t	t	t	t	t	0	28.00000000
30	t	t	t	t	t	t	t	t	t	t	t	t	0	29.00000000
31	t	t	t	t	t	t	t	t	t	t	t	t	0	30.00000000
32	t	t	t	t	t	t	t	t	t	t	t	t	0	31.00000000
33	t	t	t	t	t	t	t	t	t	t	t	t	0	32.00000000
34	t	t	t	t	t	t	t	t	t	t	t	t	0	33.00000000
35	t	t	t	t	t	t	t	t	t	t	t	t	0	34.00000000
36	t	t	t	t	t	t	t	t	t	t	t	t	1	35.00000000
37	t	t	t	t	t	t	t	t	t	t	t	t	0	36.00000000
39	t	t	t	t	t	t	t	t	t	t	t	t	0	38.00000000
40	t	t	t	t	t	t	t	t	t	t	t	t	0	39.00000000
41	t	t	t	t	t	t	t	t	t	t	t	t	0	40.00000000
42	t	t	t	t	t	t	t	t	t	t	t	t	0	41.00000000
43	t	t	t	t	t	t	t	t	t	t	t	t	0	42.00000000
44	t	t	t	t	t	t	t	t	t	t	t	t	0	43.00000000
45	f	f	t	f	f	f	f	f	f	f	f	f	0	44.00000000
47	t	t	t	t	t	t	t	t	t	t	t	t	0	46.00000000
48	t	t	t	t	t	t	t	t	t	t	t	t	1	47.00000000
49	t	t	t	t	t	t	t	t	t	t	t	t	1	48.00000000
50	t	t	t	t	t	t	t	t	t	t	t	t	1	49.00000000
51	t	t	t	t	t	t	t	t	t	t	t	t	1	50.00000000
52	t	t	t	t	t	t	t	t	t	t	t	t	1	51.00000000
54	t	t	t	t	t	t	t	t	t	t	t	t	0	53.00000000
55	t	t	t	t	t	t	t	t	t	t	t	t	0	54.00000000
56	t	t	t	t	t	t	t	t	t	t	t	t	1	55.00000000
57	t	t	t	t	t	t	t	t	t	t	t	t	1	56.00000000
58	t	t	t	t	t	t	t	t	t	t	t	t	1	57.00000000
59	t	t	t	t	t	t	t	t	t	t	t	t	1	58.00000000
60	t	t	t	t	t	t	t	t	t	t	t	t	1	59.00000000
61	t	t	t	t	t	t	t	t	t	t	t	t	1	60.00000000
62	t	t	t	t	t	t	t	t	t	t	t	t	1	61.00000000
63	t	t	t	t	t	t	t	t	t	t	t	t	1	62.00000000
64	t	t	t	t	t	t	t	t	t	t	t	t	1	63.00000000
65	t	t	t	t	t	t	t	t	t	t	t	t	1	64.00000000
66	t	t	t	t	t	t	t	t	t	t	t	t	1	65.00000000
67	t	t	t	t	t	t	t	t	t	t	t	t	1	66.00000000
68	t	t	t	t	t	t	t	t	t	t	t	t	1	67.00000000
69	t	t	t	t	t	t	t	t	t	t	t	t	1	68.00000000
70	t	t	t	t	t	t	t	t	t	t	t	t	1	69.00000000
71	t	t	t	t	t	t	t	t	t	t	t	t	1	70.00000000
72	t	t	t	t	t	t	t	t	t	t	t	t	1	71.00000000
73	t	t	t	t	t	t	t	t	t	t	t	t	0	72.00000000
74	t	t	t	t	t	t	t	t	t	t	t	t	1	73.00000000
75	t	t	t	t	t	t	t	t	t	t	t	t	1	74.00000000
76	t	t	t	t	t	t	t	t	t	t	t	t	1	75.00000000
77	t	t	t	t	t	t	t	t	t	t	t	t	1	76.00000000
78	t	t	t	t	t	t	t	t	t	t	t	t	1	77.00000000
79	t	t	t	t	t	t	t	t	t	t	t	t	1	78.00000000
80	t	t	t	t	t	t	t	t	t	t	t	t	1	79.00000000
81	t	t	t	t	t	t	t	t	t	t	t	t	1	80.00000000
82	t	t	t	t	t	t	t	t	t	t	t	t	1	81.00000000
83	t	t	t	t	t	t	t	t	t	t	t	t	1	82.00000000
84	t	t	t	t	t	t	t	t	t	t	t	t	1	83.00000000
85	t	t	t	t	t	t	t	t	t	t	t	t	1	84.00000000
86	t	t	t	t	t	t	t	t	t	t	t	t	1	85.00000000
87	t	t	t	t	t	t	t	t	t	t	t	t	1	86.00000000
88	t	t	t	t	t	t	t	t	t	t	t	t	1	87.00000000
89	t	t	t	t	t	t	t	t	t	t	t	t	1	88.00000000
90	t	t	t	t	t	t	t	t	t	t	t	t	1	89.00000000
91	t	t	t	t	t	t	t	t	t	t	t	t	1	90.00000000
92	t	t	t	t	t	t	t	t	t	t	t	t	1	91.00000000
93	t	t	t	t	t	t	t	t	t	t	t	t	1	92.00000000
94	t	t	t	t	t	t	t	t	t	t	t	t	0	93.00000000
17	f	f	f	f	f	f	f	f	f	f	f	t	0	16.00000000
46	t	t	t	t	t	t	t	t	t	t	t	t	0	45.00000000
38	t	t	t	t	t	t	t	t	t	t	t	t	0	37.00000000
53	t	t	t	t	t	t	t	t	t	t	t	t	1	52.00000000
\.


--
-- Data for Name: POLE_PRODUIT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "POLE_PRODUIT" ("NOM", "CODE", "NOM_DIRECTEUR", "NOM_SECRETAIRE", "TEL", "FAX", "MAIL", "ID_ADRESSE_COMMON", "ARCHIVE", "ORDRE", "ID") FROM stdin;
							1	0	0.00000000	1
\.


--
-- Data for Name: PREF_NODE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "PREF_NODE" ("ID", "ID_PARENT", "NAME") FROM stdin;
\.


--
-- Data for Name: PREF_VALUE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "PREF_VALUE" ("ID_NODE", "NAME", "VALUE") FROM stdin;
\.


--
-- Data for Name: PROFIL_PAYE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "PROFIL_PAYE" ("ID", "NOM", "ARCHIVE", "ORDRE") FROM stdin;
1	Indéfini	0	1.00000000
6	Profil Salarié cadre	0	1.00000000
7	Profil Salarié	0	1.50000000
8	Test profil de paye	1	2.00000000
9	fghfgfgh	1	1.75000000
\.


--
-- Data for Name: PROFIL_PAYE_ELEMENT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "PROFIL_PAYE_ELEMENT" ("ID", "NOM", "ID_PROFIL_PAYE", "SOURCE", "IDSOURCE", "POSITION", "ARCHIVE", "ORDRE") FROM stdin;
1	Indéfini	1	 	1	0	0	1.00000000
54	Salaire Brut mensuel	6	RUBRIQUE_BRUT	2	0	1	24.00000000
55	Maladie URSSAF	6	RUBRIQUE_COTISATION	6	4	1	25.00000000
56	URSSAFF Vieillesse TA	6	RUBRIQUE_COTISATION	10	5	1	26.00000000
57	Allocation Familiale URSSAF	6	RUBRIQUE_COTISATION	7	6	1	27.00000000
58	URSSAFF Accident du travail	6	RUBRIQUE_COTISATION	13	7	1	28.00000000
59	ASSEDIC ChÃ´mage	6	RUBRIQUE_COTISATION	15	8	1	29.00000000
60	ASSEDIC FNGS	6	RUBRIQUE_COTISATION	22	9	1	30.00000000
61	URSSAF CSG non déductible + RDS	6	RUBRIQUE_COTISATION	19	15	1	31.00000000
62	URSSAF CSG déductible + RDS	6	RUBRIQUE_COTISATION	20	16	1	32.00000000
64	Salaire Brut	6	RUBRIQUE_COMM	3	2	1	34.00000000
66	ARRCO AGFF cadre TA	6	RUBRIQUE_COTISATION	23	10	1	36.00000000
67	ARRCO AGFF cadre TB	6	RUBRIQUE_COTISATION	24	11	1	37.00000000
68	ARRCO Retraite complementaire cadre TA	6	RUBRIQUE_COTISATION	25	12	1	38.00000000
69	ARRCO Retraite complementaire cadre AGIRC TB	6	RUBRIQUE_COTISATION	26	13	1	39.00000000
70	ARRCO Retraite complementaire cadre AGIRC TC	6	RUBRIQUE_COTISATION	27	14	1	40.00000000
95	URSSAF CSG non déductible + CRDS	6	RUBRIQUE_COTISATION	19	22	1	65.00000000
127	Garantie minimale de points	6	RUBRIQUE_COTISATION	32	16	1	97.00000000
138	Salaire net à payer	6	RUBRIQUE_NET	3	27	1	108.00000000
112	Salaire de base	6	RUBRIQUE_BRUT	5	0	0	82.00000000
113	Absences congés	6	RUBRIQUE_BRUT	7	1	0	83.00000000
114	Indemnité de congés payés	6	RUBRIQUE_BRUT	6	2	0	84.00000000
65	Ligne vide	6	RUBRIQUE_COMM	7	3	0	35.00000000
115	Réduction Loi Fillon suite à  Aubry II	6	RUBRIQUE_COTISATION	21	4	0	85.00000000
116	URSSAF assurance maladie - solidarité	6	RUBRIQUE_COTISATION	6	5	0	86.00000000
117	URSSAF Vieillesse sur brut non plaf.	6	RUBRIQUE_COTISATION	9	6	0	87.00000000
118	URSSAF Vieillesse sur brut plaf.	6	RUBRIQUE_COTISATION	10	7	0	88.00000000
119	URSSAF FNAL sur brut plaf.	6	RUBRIQUE_COTISATION	11	8	0	89.00000000
120	URSSAF Allocation Familiale	6	RUBRIQUE_COTISATION	7	9	0	90.00000000
121	URSSAF Accident du travail	6	RUBRIQUE_COTISATION	13	10	0	91.00000000
122	ASSEDIC Chômage	6	RUBRIQUE_COTISATION	15	11	0	92.00000000
123	ASSEDIC FNGS	6	RUBRIQUE_COTISATION	22	12	0	93.00000000
124	ARRCO AGFF cadre TA	6	RUBRIQUE_COTISATION	23	13	0	94.00000000
125	ARRCO AGFF cadre TB	6	RUBRIQUE_COTISATION	24	14	0	95.00000000
126	ARRCO Retraite complementaire cadre TA	6	RUBRIQUE_COTISATION	25	15	0	96.00000000
141	Contribution Solidarité Autonomie	6	RUBRIQUE_COTISATION	5	16	0	111.00000000
142	Garantie Minimum de Points	6	RUBRIQUE_COTISATION	42	17	0	112.00000000
128	Prévoyance cadre TA	6	RUBRIQUE_COTISATION	31	18	0	98.00000000
129	AGIRC CET	6	RUBRIQUE_COTISATION	30	19	0	99.00000000
130	URSSAF CSG non déductible	6	RUBRIQUE_COTISATION	19	20	0	100.00000000
131	URSSAF CRDS	6	RUBRIQUE_COTISATION	37	21	0	101.00000000
132	URSSAF CSG déductible	6	RUBRIQUE_COTISATION	20	22	0	102.00000000
133	Ligne vide	6	RUBRIQUE_COMM	7	23	0	103.00000000
134	Cotisations Patronales	6	RUBRIQUE_COMM	5	24	0	104.00000000
135	Cotisation Salariale	6	RUBRIQUE_COMM	4	25	0	105.00000000
136	Ligne vide	6	RUBRIQUE_COMM	7	26	0	106.00000000
137	Acompte percu	6	RUBRIQUE_NET	4	27	0	107.00000000
140	Ligne vide	6	RUBRIQUE_COMM	7	28	0	110.00000000
139	Salaire Net	6	RUBRIQUE_COMM	2	29	0	109.00000000
143	Salaire de base	7	RUBRIQUE_BRUT	5	0	0	113.00000000
144	Absences congés	7	RUBRIQUE_BRUT	7	1	0	114.00000000
145	Indemnité de congés payés	7	RUBRIQUE_BRUT	6	2	0	115.00000000
146	Ligne vide	7	RUBRIQUE_COMM	7	3	0	116.00000000
147	Réduction Loi Fillon suite à  Aubry II	7	RUBRIQUE_COTISATION	21	4	0	117.00000000
148	URSSAF assurance maladie - solidarité	7	RUBRIQUE_COTISATION	6	5	0	118.00000000
149	URSSAF Vieillesse sur brut non plaf.	7	RUBRIQUE_COTISATION	9	6	0	119.00000000
150	URSSAF Vieillesse sur brut plaf.	7	RUBRIQUE_COTISATION	10	7	0	120.00000000
151	URSSAF FNAL sur brut plaf.	7	RUBRIQUE_COTISATION	11	8	0	121.00000000
152	URSSAF Allocation Familiale	7	RUBRIQUE_COTISATION	7	9	0	122.00000000
153	ASSEDIC Chômage	7	RUBRIQUE_COTISATION	15	10	0	123.00000000
154	ASSEDIC FNGS	7	RUBRIQUE_COTISATION	22	11	0	124.00000000
155	ARRCO Retraite non cadre T1	7	RUBRIQUE_COTISATION	18	12	0	125.00000000
156	ARRCO AGFF non cadre T1	7	RUBRIQUE_COTISATION	17	13	0	126.00000000
157	AGIRC CET	7	RUBRIQUE_COTISATION	30	14	0	127.00000000
158	Contribution Solidarité Autonomie	7	RUBRIQUE_COTISATION	5	15	0	128.00000000
159	URSSAF CRDS	7	RUBRIQUE_COTISATION	37	16	0	129.00000000
160	URSSAF CSG déductible	7	RUBRIQUE_COTISATION	20	17	0	130.00000000
161	URSSAF CSG non déductible	7	RUBRIQUE_COTISATION	19	18	0	131.00000000
162	Ligne vide	7	RUBRIQUE_COMM	7	19	0	132.00000000
163	Acompte percu	7	RUBRIQUE_NET	4	20	0	133.00000000
164	Ligne vide	7	RUBRIQUE_COMM	7	21	0	134.00000000
165	Salaire Net	7	RUBRIQUE_COMM	2	22	0	135.00000000
168	Noel	8	RUBRIQUE_COMM	8	2	1	138.00000000
166	Cotisations Patronales	1	RUBRIQUE_COMM	5	0	0	136.00000000
167	Ligne vide	1	RUBRIQUE_COMM	7	1	0	137.00000000
\.


--
-- Data for Name: RIGHT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "RIGHT" ("ID", "ARCHIVE", "ORDRE", "CODE", "NOM", "DESCRIPTION") FROM stdin;
1	0	0.00000000			
2	0	1.00000000	COMPTABILITE_TOTAL		
3	0	2.00000000	TABLE_ALL_RIGHTS	Accès en création, modification, suppression sur l'ensemble des tables	
14	0	13.00000000	LOCK_MENU_PAYE	Accès au menu paye	
13	0	12.00000000	ACCES_HISTORIQUE	Accès aux historiques	
12	0	11.00000000	ACCES_GENERATION_POINTAGE	Accès à la gestion des echeances	
11	0	10.00000000	ACCES_LISTE_POINTAGE	Accès au liste des echeances	
10	0	9.00000000	ACCES_MENU_STRUCTURE	Accès au menu structure	
9	0	8.00000000	COMPTABILITE_MENU	Accès complet aux menus comptabilités	
8	0	7.00000000	COMPTABILITE_TOTAL	Accès complet à la comptabilité	
7	0	6.00000000	LOCK_MENU_ADMIN	Accès au menu d'administration	
6	0	5.00000000	ACCES_MENU_STAT	Accès au menu statistique	
5	0	4.00000000	LOCK_MENU_ACHAT	Accès au menu achat	
15	0	\N	GESTION_ENCAISSEMENT	Accès à la gestion des encaissements	
16	0	\N	COMPTABILITE_TOUT_COMPTES	Accés à tous les comptes	
\.


--
-- Data for Name: RUBRIQUE_BRUT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "RUBRIQUE_BRUT" ("ID", "CODE", "NOM", "BASE", "TAUX", "MONTANT", "ID_PERIODE_VALIDITE", "ARCHIVE", "ORDRE", "ID_TYPE_RUBRIQUE_BRUT", "IMPOSABLE", "PART_BRUT", "PART_CP", "ID_IMPRESSION_RUBRIQUE") FROM stdin;
1	Indéfini	Indéfini	 	 	 	1	0	1.00000000	1	f	f	f	1
2	RBBrut	Salaire Brut mensuel	DUREE_MOIS;	Math.round(TAUXHOR*100.0)/100.0;	 	3	1	1.00000000	2	f	f	f	3
3	SALBRUT	Salaire brut	DUREE_MOIS;	TAUXHOR;	 	4	1	2.00000000	2	f	f	f	2
4	SALBRUTAB	Salaire brut Abattu	 	 	SAL_BRUT;	5	1	3.00000000	2	f	f	f	2
5	SAL_BASE_BRUT	Salaire de base	DUREE_MOIS;	Math.round(SALAIRE_MOIS/DUREE_MOIS*100)/100.0;	SALAIRE_MOIS;	37	0	4.00000000	2	f	f	f	2
7	RB_ABS_CONGES	Absences congés	CONGES_PRIS/ JOUR_OUVR * DUREE_HEBDO;	Math.round(TAUXHOR*100.0)/100.0;	 	54	0	6.00000000	3	f	f	t	2
8	RB_TEST_Dyn	test dynamique	15;	15;	15;	56	1	7.00000000	2	f	f	f	2
9	RB_test_dyn	Test dyn bis	5;	5;	5;	57	1	8.00000000	2	f	f	f	2
10	SAL_BASE_BRUT_2	Salaire de base dynamique	DUREE_MOIS;	Math.round(SALAIRE_MOIS/DUREE_MOIS*100)/100.0;	SALAIRE_MOIS;	58	1	9.00000000	2	f	f	f	2
11	Dyn	dynamique	1;	2;	3;	59	1	10.00000000	2	f	f	f	2
12	Dyn2	2dyn2	1;	2;	3;	60	1	11.00000000	2	f	f	f	2
13	test	test2	1;	2;	3;	61	1	12.00000000	2	f	f	f	2
14	Dyn3	3dyn3	1;	2;	3;	62	1	13.00000000	2	f	f	f	2
15	testDyn	Dyn5	 	 	 	63	1	14.00000000	2	f	f	f	2
16	TEST_3	test3	 	 	 	64	1	15.00000000	2	f	f	f	2
17	TEST_3	test 3	 	 	 	65	1	16.00000000	2	f	f	f	2
18	Dyn	Dyn	 	 	 	66	1	17.00000000	2	f	f	f	2
19	Dyn2	Dyn2	 	 	 	67	1	18.00000000	2	f	f	f	2
20	Dyn3	Dyn 3	 	 	 	68	1	19.00000000	3	f	f	f	2
21	Dyn5	Dyn 5	 	 	 	69	1	20.00000000	2	f	f	f	2
22	Dyn7	Dyn 9	 	 	 	70	1	21.00000000	2	f	f	f	2
23	Dyn 8	Dyn 8	 	 	 	71	1	22.00000000	2	f	f	f	2
24	Dyn10	Dyn 10	 	 	 	72	1	23.00000000	2	f	f	f	2
25	Dyn 11	Dyn 11	 	 	 	74	1	24.00000000	2	f	f	f	2
26	Dyn 12	Dyn 12	 	 	 	75	1	25.00000000	2	f	f	f	2
27	Dyn 13	dyn 13	 	 	 	76	1	26.00000000	2	f	f	f	2
28	d	Dyn 14	 	 	 	77	1	27.00000000	2	f	f	f	2
29	dd	Dyn 15	 	 	 	78	1	28.00000000	2	f	f	f	2
30	dd2	Dyn 16	 	 	 	79	1	29.00000000	2	f	f	f	2
31	dyn 80	dyn 80	 	 	 	80	1	30.00000000	2	f	f	f	2
32	ff	dyn 80	 	 	 	81	1	31.00000000	2	f	f	f	2
33	fdgfd	dyn 80	 	 	 	82	1	32.00000000	2	f	f	f	2
34	jmkklm*n	dyn 80	 	 	 	83	1	33.00000000	2	f	f	f	2
35	fghgfhgfd	dyn 80	 	 	 	84	1	34.00000000	2	f	f	f	2
36	fdgfdgfdgsfd	dyn 80	 	 	 	85	1	35.00000000	2	f	f	f	2
37	111	dyn 80	12.2;\n	 	 	86	1	36.00000000	2	f	f	f	2
38	32132	dyn 80	12.2;\n	 	 	87	1	37.00000000	2	f	f	f	2
39	gggg	dyn 80	 	 	 	88	1	38.00000000	2	f	f	f	2
40	sdfsdfs	dyn 80	 	 	 	89	1	39.00000000	2	f	f	f	2
41	fdwdfgsfd	sdfsdfqs	 	 	 	90	1	40.00000000	2	f	f	f	2
6	RB_CONGES_IND	Indemnité de congés payés	CONGES_PRIS/ JOUR_OUVR * DUREE_HEBDO;	Math.round(TAUXHOR*100.0)/100.0;	 	53	1	5.00000000	2	f	f	t	2
\.


--
-- Data for Name: RUBRIQUE_COMM; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "RUBRIQUE_COMM" ("ID", "NOM", "CODE", "NB_BASE", "TAUX_SAL", "TAUX_PAT", "MONTANT_SAL_AJ", "MONTANT_SAL_DED", "MONTANT_PAT", "ORDRE", "ARCHIVE", "ID_PERIODE_VALIDITE", "ID_IMPRESSION_RUBRIQUE", "NOM_VISIBLE", "MONTANT") FROM stdin;
1	Indéfini	 	 	 	 	 	 	 	1.00000000	0	1	1	t	0
2	Salaire Net	RSALNET	 	 	 	NET_A_PAYER;	 	 	1.00000000	0	8	2	t	0
3	Total Brut	RSALBRUT	 	 	 	SAL_BRUT;	 	 	2.00000000	0	9	2	t	0
4	Cotisation Salariale	RCOTISATIONSAL	 	 	 	 	COT_SAL;	 	3.00000000	0	10	2	t	0
5	Cotisations Patronales	RCOTISATIONPAT	 	 	 	 	 	COT_PAT;	4.00000000	0	11	2	t	0
6	Salaire net imposable	RSALNETIMP	 	 	 	NET_IMP;	 	 	5.00000000	0	14	2	t	0
7	Ligne vide	LIGNE_VIDE	 	 	 	 	 	 	6.00000000	0	15	3	f	0
9	A conserver	Conserv	 	 	 	"Ce document est à conserver sans limitation de durée.";	 	 	8.00000000	0	18	3	t	0
8	Noel	Noel	"Bonnes fêtes de fin d'année";	 	 	 	 	 	7.00000000	0	17	2	f	0
\.


--
-- Data for Name: RUBRIQUE_COTISATION; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "RUBRIQUE_COTISATION" ("ID", "CODE", "NOM", "ID_CAISSE_COTISATION", "BASE", "TX_SAL", "TX_PAT", "IMPOSABLE", "PART_CSG", "BRUT", "ID_PERIODE_VALIDITE", "ARCHIVE", "ORDRE", "ID_IMPRESSION_RUBRIQUE") FROM stdin;
1	Indefini	Indéfini	1	 	 	 	f	f	f	1	0	1.00000000	1
2	CodeCotis	qsdqsd	3	 	 	 	f	f	f	2	1	1.00000000	1
3	RCotis	cotisation Imp	2	SAL_BRUT;	6;	3;	t	f	f	12	1	2.00000000	2
4	RCotisNonImp	cotisation non Imp	2	SAL_BRUT;	16;	7;	f	f	f	13	1	3.00000000	2
5	COTCSA	Contribution Solidarité Autonomie	8	SAL_BRUT;	0;\n	0.3;	f	f	f	19	0	4.00000000	2
6	COTMALADIE	URSSAF assurance maladie - solidarité	8	SAL_BRUT;	0.75; 	13.1;	f	f	f	20	0	5.00000000	2
7	COTAF	URSSAF Allocation Familiale	8	SAL_BRUT;	0; 	5.4;	f	f	f	21	0	6.00000000	2
8	COTVEUV	Veuvage	8	SAL_BRUT;	0.1; 	0;	f	f	f	22	0	7.00000000	2
9	COTVIEIL	URSSAF Vieillesse sur brut non plaf.	8	SAL_BRUT;	0.1;	1.6;	f	f	f	23	0	8.00000000	2
10	COTVIEILPLAF	URSSAF Vieillesse sur brut plaf.	8	TRANCHE_A;	6.65;	8.3;	f	f	f	24	0	9.00000000	2
11	COTFNALPLAF	URSSAF FNAL sur brut plaf.	8	TRANCHE_A;	0.0;	0.1;	f	f	f	25	0	10.00000000	2
12	COTFNAL	URSSAF FNAL sur brut non plaf.	8	SAL_BRUT;	0.0;	0.4;	f	f	f	26	0	11.00000000	2
13	COTAT	URSSAF Accident du travail	8	SAL_BRUT;	0.0;	TAUX_AT;	f	f	f	27	0	12.00000000	2
14	COTVTRAN	URSSAF Transport(+ de 9 salariés)	8	SAL_BRUT;	0.0;	2.5;	f	f	f	28	0	13.00000000	2
15	COTCH	ASSEDIC Chômage	6	TRANCHE_A + TRANCHE_B;	2.4;	4.0;	f	f	f	29	0	14.00000000	2
16	COTCHAGS	ASSEDIC AGS septembre 2003	6	SAL_BRUT;	0.0;	0.45;	f	f	f	30	0	15.00000000	2
17	COTAGFF	ARRCO AGFF non cadre T1	3	SAL_BRUT;	0.8;	1.2;	f	f	f	31	0	16.00000000	2
18	COTRNonCadre	ARRCO Retraite non cadre T1	3	SAL_BRUT;	3;	4.5;	f	f	f	32	0	17.00000000	2
19	COTCSGIMP	URSSAF CSG non déductible	8	CSG;	2.4;	0.0;	t	f	f	33	0	18.00000000	2
20	COTCSGDED	URSSAF CSG déductible	8	CSG;	5.1;	0.0;	f	f	f	34	0	19.00000000	2
21	COTFILLON	Réduction Loi Fillon suite à  Aubry II	8	SAL_BRUT * COEFF1;	 	-100;	f	f	f	35	0	20.00000000	2
23	COTCADRET1	ARRCO AGFF cadre TA	3	TRANCHE_A;	0.8;	1.2;	f	f	f	39	0	22.00000000	2
24	COTCADRET2	ARRCO AGFF cadre TB	3	TRANCHE_B;	0.9;	1.3;	f	f	f	40	0	23.00000000	2
25	COT_CADRE_RET_C_A	ARRCO Retraite complementaire cadre TA	3	TRANCHE_A;	3;	4.5;	f	f	f	41	0	24.00000000	2
26	COT_CADRE_RET_C_B	ARRCO Retraite complementaire cadre AGIRC TB	2	TRANCHE_B;	7.7;	12.6;	f	f	f	42	0	25.00000000	2
27	COT_CADRE_RET_C_C	ARRCO Retraite complementaire cadre AGIRC TC	2	TRANCHE_C;	7.7;	12.6;	f	f	f	43	0	26.00000000	2
28	COTAPEC	APEC Association pour l'emploi des cadres	2	TRANCHE_B;	0.024; 	0.036;	f	f	f	44	0	27.00000000	2
29	COTAPECFORF	APEC Forfaitaire	2	APEC;	40;	60;	f	f	f	45	0	28.00000000	2
31	COTPREVCADRETA	Prévoyance cadre TA	2	TRANCHE_A;	0.8;	0.8;	f	t	f	47	0	30.00000000	2
32	COTGMP	Garantie minimale de points	2	GMP;	7.5;	12.5;	f	f	f	48	1	31.00000000	2
33	REG1	Régularisation 01/01 --> 31/07 sur GMP	2	 7 * 3.33;	7.5;	12.5;	f	f	f	49	1	33.00000000	2
34	REG2	Régularisation juillet réduction Fillon	8	SAL_BRUT * COEFF1;	 	-100;	f	f	f	50	1	34.00000000	2
35	REG3	Régularisation 01/01 --> 31/07 Maladie vieillesse	8	SAL_BRUT * 7;	 	0.3;	f	f	f	51	1	35.00000000	2
36	REG4	Régularisation juillet FNGS	6	SAL_BRUT;	 	-0.1;	f	f	f	52	1	36.00000000	2
37	COTCRDSIMP	URSSAF CRDS	8	CSG;	0.5;	0.0;	t	f	f	55	0	39.00000000	2
38	cot 2	cot 2	2	 	 	 	f	f	f	73	0	40.00000000	2
39	REG5	Régularisation GMP 01/06 -> 11/06	2	11;	56;	27;	f	f	f	91	1	37.00000000	2
40	REG6	Régularisation GMP 08/06 -> 11/06	2	4;	56;	27;	f	f	f	92	1	38.00000000	2
41	REG7	Régularisation CSA 08/06 -> 11/06	8	4 * SAL_BRUT;	 	-0.3;	f	f	f	93	1	32.00000000	2
42	COTGMP2	Garantie Minimum de Points	2	100;	PART_SAL_GarantieMP;	PART_PAT_GarantieMP;	f	f	f	94	0	41.00000000	2
30	COTCET	AGIRC CET	2	TRANCHE_A + TRANCHE_B + TRANCHE_C;	0.13;	0.22;	f	f	f	46	0	29.00000000	2
22	COTFNGS	ASSEDIC FNGS	6	TRANCHE_A + TRANCHE_B;	0;	0.4;	f	f	f	38	0	21.00000000	2
\.


--
-- Data for Name: RUBRIQUE_NET; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "RUBRIQUE_NET" ("ID", "CODE", "NOM", "BASE", "TAUX", "MONTANT", "IMPOSABLE", "FRAIS_PERS", "BRUT", "ID_PERIODE_VALIDITE", "ID_TYPE_RUBRIQUE_NET", "ID_IMPRESSION_RUBRIQUE", "ORDRE", "ARCHIVE") FROM stdin;
1	Indéfini	Indéfini	 	 	 	f	f	f	1	1	1	1.00000000	0
2	SALAIRE_NET_IMP	Salaire net imposable	 	 	NET_IMP;	f	f	f	6	2	3	1.00000000	1
3	SALAIRE_NET_A_PAYER	Salaire net à payer	 	 	NET_A_PAYER;	f	f	f	7	2	3	1.00000000	1
4	Acompte	Acompte percu	 	 	ACOMPTE;	t	f	f	16	3	2	3.00000000	0
5	MaNouv_rub_net	test rubrique net	0.0;	0.0;	0.0;	f	f	f	36	2	2	4.00000000	1
\.


--
-- Data for Name: SERVICE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "SERVICE" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE") FROM stdin;
1			0	0.00000000
\.


--
-- Data for Name: SOCIETE_COMMON; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "SOCIETE_COMMON" ("ID", "DATABASE_NAME", "NOM", "NUM_SIRET", "NUM_NII", "NUM_APE", "ID_EXERCICE_COMMON", "NUM_TEL", "NUM_FAX", "MAIL", "ID_ADRESSE_COMMON", "TYPE", "ORDRE", "ARCHIVE", "NUMERO_URSSAF", "RCS", "CAPITAL") FROM stdin;
1	Default	 	 	 	 	1	 	 	 	1	 	1.00000000	0	 		0
48	OpenConcerto48	Votre Société	123	123	123	60				61		40.00000000	0			0
42	OpenConcerto42	ILM Informatique	16546546545	FRA6554324	12	58	03 22 19 44 72	03 22 19 44 08	contact@ilm-informatique.fr	55	SARL	34.00000000	0	153543		0
\.


--
-- Data for Name: STOCK; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "STOCK" ("ID", "QTE_REEL", "QTE_TH", "ARCHIVE", "ORDRE") FROM stdin;
1	0	0	0	0.00000000
\.


--
-- Data for Name: TACHE_COMMON; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "TACHE_COMMON" ("ID", "PRIORITE", "FAIT", "NOM", "DATE_ENTREE", "DATE_FAIT", "DATE_EXP", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_TO", "ORDRE", "ARCHIVE", "COMMENT", "ID_USER_COMMON_ASSIGN_BY", "ID_SOCIETE_COMMON", "TYPE", "COOKIE") FROM stdin;
517	0	t		2008-11-17 18:50:19.218	2008-11-17 19:05:45.39	2008-11-17 19:50:19.218	2	2	351.00000000	1	\N	1	1		
66	2	t	pour user 1	2006-05-27 18:57:18	2006-04-21 20:28:35	2006-04-21 20:28:35	1	1	63.00000000	1	\N	1	1		
67	2	t	pour user 4	2006-05-27 12:44:02	2006-04-27 16:52:30	2006-04-27 16:52:00	1	4	64.00000000	1	\N	1	1		
69	2	t	pour user 4	2006-05-27 12:44:02	2006-05-27 18:58:41	2006-05-27 18:58:41	1	4	66.00000000	1	\N	1	1		
70	1	t	Finir la map du formulaire 2033-E	2006-05-27 12:44:02	2006-05-26 19:27:51	2006-05-26 19:27:51	1	5	67.00000000	1	\N	1	1		
71	1	t	 	2006-05-27 18:57:21	2006-05-26 19:28:10	2006-05-26 19:28:10	1	1	68.00000000	1	\N	1	1		
72	1	f	 	2006-05-27 18:57:21	2006-05-26 19:28:16	2006-05-26 19:28:16	1	1	69.00000000	1	\N	1	1		
73	3	f	 	2006-05-27 18:57:21	2006-05-26 19:28:17	2006-05-26 19:28:17	1	1	70.00000000	1	\N	1	1		
74	1	f	ddddddddddddddddddd	2006-05-27 18:57:21	2006-05-26 19:28:20	2006-05-26 19:28:20	1	1	71.00000000	1	\N	1	1		
75	3	f	d	2006-05-27 18:57:21	2006-05-26 19:34:02	2006-05-26 19:34:02	1	1	72.00000000	1	\N	1	1		
76	3	f	dddddddddddddddd	2006-05-27 18:57:21	2006-05-26 19:34:11	2006-05-26 19:34:11	1	1	73.00000000	1	\N	1	1		
77	0	f	 	2006-05-27 18:57:21	2006-05-26 19:34:44	2006-05-26 19:34:44	1	1	74.00000000	1	\N	1	1		
78	1	f	 	2006-05-27 18:57:21	2006-05-26 19:35:53	2006-05-26 19:35:53	1	1	75.00000000	1	\N	1	1		
79	3	f	 	2006-05-27 18:57:21	2006-05-26 19:35:53	2006-05-26 19:35:53	1	1	76.00000000	1	\N	1	1		
80	1	f	 	2006-05-26 19:59:23	2006-05-26 19:35:53	2006-05-26 19:35:53	1	1	77.00000000	1	\N	1	1		
81	2	f	 	2006-05-26 19:59:23	2006-05-26 19:35:54	2006-05-26 19:35:54	1	1	78.00000000	1	\N	1	1		
82	1	f	 	2006-05-26 19:59:23	2006-05-26 19:35:54	2006-05-26 19:35:54	1	1	79.00000000	1	\N	1	1		
83	1	f	 	2006-05-26 19:59:23	2006-05-26 19:35:54	2006-05-26 19:35:54	1	1	80.00000000	1	\N	1	1		
84	1	f	 	2006-05-26 19:59:23	2006-05-26 19:37:49	2006-05-26 19:37:49	1	1	81.00000000	1	\N	1	1		
85	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:49	2006-05-26 19:37:49	1	1	82.00000000	1	\N	1	1		
86	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:49	2006-05-26 19:37:49	1	1	83.00000000	1	\N	1	1		
87	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:49	2006-05-26 19:37:49	1	1	84.00000000	1	\N	1	1		
88	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:50	2006-05-26 19:37:50	1	1	85.00000000	1	\N	1	1		
89	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:50	2006-05-26 19:37:50	1	1	86.00000000	1	\N	1	1		
90	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:50	2006-05-26 19:37:50	1	1	87.00000000	1	\N	1	1		
91	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:50	2006-05-26 19:37:50	1	1	88.00000000	1	\N	1	1		
92	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:50	2006-05-26 19:37:50	1	1	89.00000000	1	\N	1	1		
93	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:50	2006-05-26 19:37:50	1	1	90.00000000	1	\N	1	1		
94	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:50	2006-05-26 19:37:50	1	1	91.00000000	1	\N	1	1		
95	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:51	2006-05-26 19:37:51	1	1	92.00000000	1	\N	1	1		
96	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:51	2006-05-26 19:37:51	1	1	93.00000000	1	\N	1	1		
97	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:51	2006-05-26 19:37:51	1	1	94.00000000	1	\N	1	1		
98	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:51	2006-05-26 19:37:51	1	1	95.00000000	1	\N	1	1		
99	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:51	2006-05-26 19:37:51	1	1	96.00000000	1	\N	1	1		
100	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:51	2006-05-26 19:37:51	1	1	97.00000000	1	\N	1	1		
101	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:51	2006-05-26 19:37:51	1	1	98.00000000	1	\N	1	1		
102	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:52	2006-05-26 19:37:52	1	1	99.00000000	1	\N	1	1		
103	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:53	2006-05-26 19:37:53	1	1	100.00000000	1	\N	1	1		
104	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:54	2006-05-26 19:37:54	1	1	101.00000000	1	\N	1	1		
105	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:54	2006-05-26 19:37:54	1	1	102.00000000	1	\N	1	1		
106	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:54	2006-05-26 19:37:54	1	1	103.00000000	1	\N	1	1		
107	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:54	2006-05-26 19:37:54	1	1	104.00000000	1	\N	1	1		
108	0	f	 	2006-05-26 19:59:23	2006-05-26 19:37:55	2006-05-26 19:37:55	1	1	105.00000000	1	\N	1	1		
109	0	f	 	2006-05-27 18:57:21	2006-05-26 20:31:36	2006-05-26 20:31:36	1	1	106.00000000	1	\N	1	1		
110	0	f	ttttttttttttttttt	2006-05-27 18:57:21	2006-05-27 12:36:50	2006-05-27 12:36:50	1	1	107.00000000	1	\N	1	1		
111	0	f	rrrrrrrrrrrrrrr	2006-05-27 18:57:21	2006-05-27 14:54:28	2006-05-27 14:54:28	1	1	108.00000000	1	\N	1	1		
112	0	f	 	2006-05-27 18:57:21	2006-05-27 18:54:58	2006-05-27 18:54:58	1	1	109.00000000	1	\N	1	1		
113	0	f	 	2006-05-27 18:57:21	2006-05-27 18:54:59	2006-05-27 18:54:59	1	1	110.00000000	1	\N	1	1		
114	0	f	 	2006-05-27 18:57:21	2006-05-27 18:54:59	2006-05-27 18:54:59	1	1	111.00000000	1	\N	1	1		
115	0	f	 	2006-05-27 18:57:21	2006-05-27 18:54:59	2006-05-27 18:54:59	1	1	112.00000000	1	\N	1	1		
116	1	t	 	2006-06-15 19:56:29	2006-05-27 18:58:28	2006-06-09 17:56:00	2	2	113.00000000	1	\N	1	1		
117	0	f	Gestion du champ USER pour la table ECRITURE	2006-06-26 09:50:41	2006-05-27 19:45:41	2006-05-27 19:45:00	2	5	114.00000000	1	\N	1	1		
118	3	t	1	2007-01-30 18:02:15	2006-05-27 20:00:49	2006-05-27 20:00:49	2	4	115.00000000	1	\N	1	1		
119	3	t	test totot	2007-01-30 18:02:15	2006-05-27 20:00:00	2006-06-09 08:00:00	2	3	116.00000000	1	\N	1	1		
121	0	t	 	2007-01-30 18:02:15	2006-05-27 20:00:49	2006-05-27 20:00:49	2	5	118.00000000	1	\N	1	1		
122	1	f	3	2006-06-07 12:22:08	2006-05-27 20:00:49	2006-05-27 20:00:49	2	5	119.00000000	1	\N	1	1		
123	1	f	 	2006-06-15 19:56:44	2006-05-27 20:00:50	2006-05-27 20:00:50	2	4	120.00000000	1	\N	1	1		
124	1	f	 	2006-06-15 19:56:44	2006-05-27 20:00:50	2006-05-27 20:00:50	2	4	121.00000000	1	\N	1	1		
125	0	f	Compiler CTECH 4!!!!!!!! now d	2007-01-24 19:05:24	2006-05-29 14:16:00	2006-05-29 09:09:00	2	3	122.00000000	1	\N	1	1		
126	3	t	test mouvement	2007-01-26 18:53:54	2006-05-13 06:13:00	2006-05-29 13:13:00	2	2	123.00000000	1	\N	1	1		
127	2	t	Enregistrer la dernière commande	2006-05-31 19:21:07	2007-03-01 21:03:04	2006-05-31 19:21:00	2	3	124.00000000	1	\N	1	1		
128	0	t	Gérer les utilisateurs	2006-06-01 12:38:29	2006-06-01 12:38:00	2006-06-07 12:35:00	2	4	125.00000000	1	\N	1	1		
129	0	f	 	2006-06-15 19:56:26	2006-06-07 16:14:21	2006-06-07 16:14:21	2	2	126.00000000	1	\N	1	1		
130	3	t	Gestion des immos	2006-06-07 16:14:00	2006-06-07 16:14:22	2006-06-07 16:14:00	2	5	127.00000000	1	\N	1	1		
131	0	f	 	2006-06-15 19:56:26	2006-06-07 16:14:22	2006-06-07 16:14:22	2	2	128.00000000	1	\N	1	1		
132	0	f	 	2006-06-15 19:56:26	2006-06-07 16:14:22	2006-06-07 16:14:22	2	2	129.00000000	1	\N	1	1		
133	0	f	 	2006-06-15 19:56:26	2006-06-07 16:14:22	2006-06-07 16:14:22	2	2	130.00000000	1	\N	1	1		
134	0	f	 	2006-06-15 19:56:26	2006-06-13 17:33:56	2006-06-13 17:33:56	2	2	131.00000000	1	\N	1	1		
135	0	f	 	2006-06-15 19:56:26	2006-06-13 17:34:38	2006-06-13 17:34:38	2	2	132.00000000	1	\N	1	1		
136	0	f	 	2006-06-15 19:56:26	2006-06-13 17:34:40	2006-06-13 17:34:40	2	2	133.00000000	1	\N	1	1		
137	0	f	 	2006-06-15 19:56:26	2006-06-13 17:34:41	2006-06-13 17:34:41	2	2	134.00000000	1	\N	1	1		
138	0	f	 	2006-06-14 15:37:24	2006-06-14 15:36:17	2006-06-14 15:36:00	2	2	135.00000000	1	\N	1	1		
139	0	f	 	2006-06-14 15:39:08	2006-06-14 15:38:53	2006-06-14 15:38:00	2	2	136.00000000	1	\N	1	1		
140	0	f	 	2006-06-15 19:56:26	2006-06-15 19:55:36	2006-06-15 19:55:36	2	2	137.00000000	1	\N	1	1		
141	1	f	 	2006-06-19 11:14:47	2006-06-16 15:40:31	2006-06-19 15:40:00	5	5	138.00000000	1	\N	1	1		
142	0	f	 	2006-06-16 15:40:48	2006-06-16 15:40:33	2006-06-16 15:40:33	5	5	139.00000000	1	\N	1	1		
143	0	f	 	2006-06-16 15:40:48	2006-06-16 15:40:33	2006-06-16 15:40:33	5	5	140.00000000	1	\N	1	1		
144	0	f	 	2006-06-16 15:40:48	2006-06-16 15:40:33	2006-06-16 15:40:33	5	5	141.00000000	1	\N	1	1		
145	0	f	 	2006-06-16 15:40:50	2006-06-16 15:40:33	2006-06-16 15:40:33	5	5	142.00000000	1	\N	1	1		
146	0	f	 	2006-06-16 15:40:45	2006-06-16 15:40:34	2006-06-16 15:40:34	5	5	143.00000000	1	\N	1	1		
147	0	f	 	2006-06-16 15:40:45	2006-06-16 15:40:34	2006-06-16 15:40:34	5	5	144.00000000	1	\N	1	1		
148	0	f	 	2006-06-16 15:40:45	2006-06-16 15:40:34	2006-06-16 15:40:34	5	5	145.00000000	1	\N	1	1		
149	0	f	 	2006-06-16 15:40:45	2006-06-16 15:40:34	2006-06-16 15:40:34	5	5	146.00000000	1	\N	1	1		
150	0	f	 	2006-06-16 15:40:48	2006-06-16 15:40:34	2006-06-16 15:40:34	5	5	147.00000000	1	\N	1	1		
151	0	f	 	2006-06-19 11:14:05	2006-06-19 11:13:56	2006-06-19 11:13:56	2	2	148.00000000	1	\N	1	1		
152	1	f	Gestion de la paie	2006-10-03 18:08:36	2006-06-19 11:14:18	2006-06-19 11:14:18	5	5	149.00000000	1	\N	1	1		
153	0	t	Relancee	2007-01-24 18:25:08	2006-06-19 11:14:57	2006-06-19 11:14:00	5	3	150.00000000	1	\N	1	1		
154	0	t	Saisie au Km Modele predefini (facture eau, e	2006-06-19 11:25:32	2006-06-19 11:25:47	2006-06-19 11:25:47	5	5	151.00000000	1	\N	1	1		
155	0	f	Lettrage automatique lors des réglements ??	2006-06-19 16:34:49	2006-06-19 11:26:16	2006-06-19 11:26:16	5	5	152.00000000	1	\N	1	1		
156	0	t	génération documents analytiques	2006-06-19 11:32:00	2006-06-19 11:32:40	2006-06-19 11:32:00	5	5	153.00000000	1	\N	1	1		
157	0	t	Clic droit supprimer la ligne sur RowValuesTa	2007-02-23 09:19:38	2006-06-19 12:07:11	2006-06-19 12:07:11	5	5	154.00000000	1	\N	1	1		
158	0	f	Finir Map 2033-E	2006-06-19 16:19:12	2006-06-19 16:18:22	2006-06-19 16:18:22	5	5	155.00000000	1	\N	1	1		
159	1	f	Gérer les private Field pour les SQLElement	2006-06-20 17:28:05	2006-06-20 12:04:50	2006-06-20 12:04:50	5	5	156.00000000	1	\N	1	1		
160	0	t	Tester la clôture	2006-06-20 16:22:19	2006-06-20 16:22:43	2006-06-20 16:22:00	5	4	157.00000000	1	attn 	1	1		
161	0	t	Bug Montant HT sur saisie comptoir avec selec	2006-06-20 18:01:00	2006-06-20 18:01:02	2006-06-20 18:01:00	5	5	158.00000000	1	\N	1	1		
162	0	f	 	2006-06-26 09:51:06	2006-06-26 09:50:57	2006-06-26 09:50:57	2	2	159.00000000	1	\N	1	1		
163	0	t	Creation d'un exercice	2006-06-26 09:51:54	2006-06-26 09:52:00	2006-06-26 09:52:00	5	5	160.00000000	1	\N	1	1		
164	0	f	 	2006-06-29 11:15:48	2006-06-29 11:15:34	2006-06-29 11:15:34	2	2	161.00000000	1	\N	1	1		
165	0	f	Gestion des variables de cumuls pour la paye	2006-09-19 15:09:08	2006-07-11 15:41:48	2006-07-11 15:41:00	5	5	162.00000000	1	\N	1	1		
166	0	t	 	2006-07-19 10:45:59	2006-07-19 10:45:58	2006-07-19 10:45:00	2	4	163.00000000	1	\N	1	1		
167	0	f	 	2006-09-13 14:56:08	2006-09-13 14:56:02	2006-09-13 14:56:02	2	2	164.00000000	1	\N	1	1		
170	0	f	ddz	2007-01-24 16:47:48	2006-09-13 14:56:13	2006-09-15 14:56:00	2	2	167.00000000	1	\N	1	1		
171	1	f	zdd	2006-09-21 15:29:34	2006-09-13 14:56:13	2006-09-13 14:56:00	2	2	168.00000000	1	\N	1	1		
175	0	t	Ajouter dans les boutons droit pour devis etc	2006-09-27 12:38:54	2006-09-27 12:38:59	2006-09-27 12:38:59	2	5	172.00000000	1	\N	1	1		
178	0	t	dd	2006-10-03 18:10:03	2006-10-03 18:10:08	2006-10-03 18:10:00	2	3	175.00000000	1	\N	1	1		
179	1	t	TaskNX: voir purquoi ajouter une tache ne marche pas, Fixé!	2006-10-03 18:10:04	2007-03-01 12:49:53	2007-01-27 18:10:00	2	3	176.00000000	1	\N	1	1		
183	1	f	 	2006-10-03 18:50:05	2006-10-03 18:10:00	2006-10-03 18:10:10	2	2	180.00000000	1	\N	1	1		
184	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:12	2006-10-03 18:10:12	2	2	181.00000000	1	\N	1	1		
185	0	t	 	2006-10-03 18:50:05	2006-10-03 18:10:12	2006-10-03 18:10:00	2	2	182.00000000	1	\N	1	1		
186	0	t	 	2006-10-03 18:49:56	2006-10-03 18:10:13	2006-10-03 18:10:13	2	2	183.00000000	1	\N	1	1		
187	0	t	 	2006-10-03 18:49:53	2006-10-03 18:10:00	2006-10-03 18:10:00	2	2	184.00000000	1	\N	1	1		
188	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:20	2006-10-03 18:10:20	2	2	185.00000000	1	\N	1	1		
189	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:21	2006-10-03 18:10:00	2	2	186.00000000	1	\N	1	1		
190	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:22	2006-10-03 18:10:22	2	2	187.00000000	1	\N	1	1		
191	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:00	2006-10-03 18:10:24	2	2	188.00000000	1	\N	1	1		
192	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:24	2006-10-03 18:10:24	2	2	189.00000000	1	\N	1	1		
193	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:30	2006-10-03 18:10:30	2	2	190.00000000	1	\N	1	1		
194	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:32	2006-10-03 18:10:32	2	2	191.00000000	1	\N	1	1		
195	0	f	 	2006-10-03 18:50:05	2006-10-03 18:10:32	2006-10-03 18:10:32	2	2	192.00000000	1	\N	1	1		
197	0	f	 	2006-11-08 14:40:23	2006-11-08 14:37:06	2006-11-08 14:37:06	5	5	194.00000000	1	\N	1	1		
198	0	t	Fichier properties par société	2006-11-08 14:39:32	2006-11-08 14:40:03	2006-11-08 14:40:00	5	5	195.00000000	1	\N	1	1		
199	0	t	hhh	2007-01-30 18:17:48	2007-01-03 19:34:00	2006-11-27 10:53:06	2	5	196.00000000	1	\N	1	1		
200	0	t	 	2007-01-24 18:18:29	2006-12-12 18:27:06	2006-12-12 18:27:06	2	2	197.00000000	1	\N	1	1		
201	0	t	Demande de confirmation avant impression	2007-02-12 18:16:47	2006-12-20 12:31:57	2006-12-20 12:31:00	5	5	198.00000000	1	\N	1	1		
206	0	f	 	2007-02-12 18:20:23	2007-02-12 18:20:19	2007-02-12 18:20:19	5	5	203.00000000	1	\N	1	1		
207	0	t	 	2007-02-13 09:04:23	2007-02-12 19:36:44	2007-02-13 18:58:00	5	5	204.00000000	1	\N	1	1		
208	0	t	 	2007-02-13 09:04:21	2007-02-12 19:36:44	2007-02-06 19:13:00	5	5	205.00000000	1	\N	1	1		
209	0	t	 	2007-02-13 09:04:19	2007-02-12 19:47:11	2007-02-23 19:14:00	5	5	206.00000000	1	\N	1	1		
213	0	t	 	2007-02-13 09:04:00	2007-02-12 19:49:34	2007-02-06 20:23:00	5	5	207.00000000	1	\N	1	1		
214	0	t	gggggggggggg	2007-02-13 09:04:18	2000-01-01 00:00:00	2007-02-12 20:25:45	5	5	208.00000000	1	\N	1	1		
215	0	t	 	2007-02-13 09:04:01	2007-02-12 19:36:41	2007-02-08 19:28:00	5	5	209.00000000	1	\N	1	1		
216	1	t	TaskNX: ajouter un + pour pouvoir editer dans un textarea, fenetre externe	2007-03-01 16:29:39	2007-03-01 21:02:59	2007-02-27 20:28:00	5	3	210.00000000	1	Et popup qui va bien	1	1		
217	0	t	gggggggggggg	2007-02-13 09:04:16	2007-02-12 19:28:52	2007-02-12 20:28:36	5	5	211.00000000	1	\N	1	1		
218	0	t	gggggggggggg	2007-02-13 09:03:58	2007-02-12 19:49:35	2007-02-10 20:28:00	5	5	212.00000000	1	\N	1	1		
219	0	t	gggggggggggg	2007-02-13 09:04:14	2007-02-08 19:51:00	2007-02-12 20:51:01	5	5	213.00000000	1	\N	1	1		
220	0	f	 	2007-02-13 09:03:56	2000-01-01 00:00:48	2007-02-01 20:51:00	5	5	214.00000000	1	\N	1	1		
221	0	f	 	2007-02-13 09:03:53	2000-01-01 00:00:49	2007-02-12 20:51:49	5	5	215.00000000	1	\N	1	1		
222	0	f	 	2007-02-13 09:03:51	2000-01-01 00:00:49	2007-02-06 20:51:00	5	5	216.00000000	1	\N	1	1		
223	0	f	 	2007-02-13 09:03:49	2000-01-01 00:00:49	2007-02-08 20:51:00	5	5	217.00000000	1	\N	1	1		
224	0	f	 	2007-03-22 14:41:43	2000-01-01 00:00:49	2007-02-12 20:51:00	5	5	218.00000000	1	\N	1	1		
225	0	f	 	2007-03-22 14:41:42	2000-01-01 00:00:06	2007-02-13 21:21:06	5	5	219.00000000	1	\N	1	1		
226	0	f	 	2007-03-22 14:41:40	2000-01-01 00:00:19	2007-02-13 21:21:19	5	5	220.00000000	1	\N	1	1		
227	0	f	 	2007-03-22 14:41:38	2000-01-01 00:00:32	2007-02-13 21:25:32	5	5	221.00000000	1	\N	1	1		
228	1	t	TaskNX: notion de droit de reassignement	2007-02-28 15:25:27	2007-03-01 21:02:59	2007-02-27 15:25:00	4	3	222.00000000	1	Et tout ce qui va bien.\nEt même tout ce qui ne va pas bien !!!!!!!!!!!!!!!!!!	1	1		
230	3	t	TaskNX: coder 'avancer d'un jour' ou menuee	2007-03-01 21:03:23	2007-03-02 15:49:39	2007-03-07 22:03:00	3	3	224.00000000	1	 	1	1		
232	0	t	nouveau pc dans réseau Ets Pruvot	2007-03-02 17:01:59	2007-03-06 17:46:17	2007-03-05 15:00:00	4	5	226.00000000	1	58 rue Jean Jaurès\nFressenneville	1	1		
233	0	t	Au travail!	2007-03-02 17:15:25	2007-03-02 17:26:24	2007-03-02 18:15:25	3	4	227.00000000	1	\N	1	1		
234	1	f	Sources de Demerre	2007-03-02 17:22:29	2000-01-01 00:00:29	2007-03-02 18:22:29	3	4	228.00000000	1	\N	1	1		
235	2	f	Test	2007-03-05 11:52:02	2000-01-01 00:00:02	2007-03-05 12:52:02	6	3	229.00000000	1	 	1	1		
236	0	f	 	2007-03-05 12:08:54	2000-01-01 00:00:54	2007-03-05 13:08:00	3	5	230.00000000	1	\N	1	1		
237	1	t	Monter offre Bureautique	2007-03-05 16:45:16	2007-03-15 12:57:02	2007-03-06 11:45:00	3	6	231.00000000	1	\N	1	1		
238	0	f	 	2007-03-06 17:40:40	2000-01-01 00:00:06	2007-03-06 18:40:06	5	5	232.00000000	1	\N	1	1		
239	0	f	detève à appeler	2007-03-12 10:16:50	2000-01-01 00:00:50	2007-03-12 11:16:50	4	3	233.00000000	1	\N	1	1		
240	2	f	Convertir le 2eme fichier du mail de Mme Demerre	2007-03-14 10:06:56	2000-01-01 00:00:56	2007-03-14 11:06:56	4	3	234.00000000	1	\N	1	1		
241	1	f	s'occuper de Vitrolles	2007-03-22 10:43:17	2000-01-01 00:00:17	2007-03-22 11:43:17	4	3	235.00000000	1	pb de téléphone compatible\nwindows à installer\nelle va devoir s'occuper des maquettes	1	1		
242	2	f	rappeler passman pour fixer nouveau rendez vous	2007-03-22 11:05:40	2000-01-01 00:00:40	2007-03-22 12:05:40	4	3	236.00000000	1	\N	1	1		
243	0	t	Zissler Vendredi 23 mars 2007 matin Instalaltion camescope	2007-03-22 14:40:58	2007-03-23 11:42:40	2007-03-22 15:40:58	5	5	237.00000000	1	\N	1	1		
244	0	t	OT Vendredi 23 mars 2007 matin  Clef USB 1Go	2007-03-22 18:28:42	2007-03-23 09:01:00	2007-03-22 19:28:42	5	5	238.00000000	1	\N	1	1		
245	0	t	modem Sauriac	2007-03-22 18:29:57	2007-03-23 09:11:17	2007-03-22 19:29:57	5	5	239.00000000	1	\N	1	1		
246	0	f	 	2007-03-29 09:43:21	2000-01-01 00:00:45	2007-03-28 19:15:45	5	5	240.00000000	1	\N	1	1		
247	1	f	M. Matifa à rappeler 0689542680	2007-03-29 09:59:20	2000-01-01 00:00:20	2007-03-29 10:59:20	4	3	241.00000000	1	Devis pour matériel le 26	1	1		
248	0	f	Si on commence à éditer inline puis qu'on clic ... tout est perdu	2007-03-29 10:00:25	2000-01-01 00:00:25	2007-03-29 11:00:25	4	3	242.00000000	1	\N	1	1		
249	0	f	mettre ... dans le renderer s'il ya du txt dans le TextArea	2007-03-29 10:01:15	2000-01-01 00:00:15	2007-03-29 11:01:15	4	3	243.00000000	1	\N	1	1		
259	0	f		2007-03-30 07:33:26.156	2000-01-01 00:00:26	2007-03-30 08:33:26.156	10	10	253.00000000	1	\N	1	1		
250	0	f		2007-03-29 17:19:57.875	2000-01-01 00:00:57	2007-03-29 18:19:57.875	10	10	244.00000000	1	\N	1	1		
251	0	f		2007-03-29 17:20:00.078	2000-01-01 00:00:00	2007-03-29 18:20:00.078	10	10	245.00000000	1	\N	1	1		
252	0	f		2007-03-29 17:20:00.89	2000-01-01 00:00:00	2007-03-29 18:20:00.89	10	10	246.00000000	1	\N	1	1		
253	0	f		2007-03-29 17:20:01.25	2000-01-01 00:00:01	2007-03-29 18:20:01.25	10	10	247.00000000	1	\N	1	1		
254	0	f		2007-03-29 17:20:01.625	2000-01-01 00:00:01	2007-03-29 18:20:01.625	10	10	248.00000000	1	\N	1	1		
255	0	f		2007-03-29 17:20:01.796	2000-01-01 00:00:01	2007-03-29 18:20:01.796	10	10	249.00000000	1	\N	1	1		
256	0	f		2007-03-29 17:20:10.656	2000-01-01 00:00:10	2007-03-29 18:20:10.656	10	10	250.00000000	1	\N	1	1		
257	0	f		2007-03-29 17:20:11.359	2000-01-01 00:00:11	2007-03-29 18:20:11.359	10	10	251.00000000	1	\N	1	1		
258	0	f		2007-03-29 17:20:11.734	2000-01-01 00:00:11	2007-03-29 18:20:11.734	10	10	252.00000000	1	\N	1	1		
262	0	t		2007-04-10 17:41:19.015	2007-04-10 17:41:23.281	2007-04-10 18:41:19.015	10	10	256.00000000	1	\N	1	1		
260	1	t	Rappeler 0322194472	2007-04-10 16:56:22.62	2007-04-10 17:00:31.588	2007-04-19 17:56:00	10	10	254.00000000	1	\N	1	1		
261	0	t		2007-04-10 17:16:39.847	2007-04-10 17:41:23.703	2007-04-10 18:16:39.847	10	10	255.00000000	1	\N	1	1		
263	0	t		2007-04-20 15:43:01.578	2007-05-07 07:42:02.843	2007-04-20 16:43:01.578	10	10	257.00000000	1	\N	1	1		
264	0	f		2007-05-24 00:00:00	2007-05-30 00:00:00	2007-05-24 00:00:00	10	10	258.00000000	1	\N	1	1		
267	0	t		2007-08-02 00:00:00	2007-08-08 08:25:22.598	2007-08-02 00:00:00	10	10	261.00000000	1	\N	1	1		
266	0	t		2007-06-20 00:00:00	2007-11-02 17:36:30.171	2007-06-18 00:00:00	10	10	260.00000000	1	\N	1	1		
265	2	t		2007-06-18 00:00:00	2007-11-02 17:36:29.703	2007-06-18 00:00:00	10	10	259.00000000	1	\N	1	1		
268	0	t		2007-12-20 14:10:17.25	2007-12-20 17:06:31.906	2007-12-20 15:10:00	10	10	262.00000000	1	\N	1	1		
271	0	t		2007-12-27 08:55:35.187	2007-12-27 08:55:40.156	2007-12-27 09:55:35.187	10	10	265.00000000	1	\N	1	1		
269	0	t		2007-12-27 08:55:32.703	2007-12-27 08:55:40.843	2007-12-27 09:55:32.703	10	10	263.00000000	1	\N	1	1		
270	0	t		2007-12-27 08:55:34.437	2007-12-27 08:55:40.515	2007-12-27 09:55:34.437	10	10	264.00000000	1	\N	1	1		
272	0	t		2007-12-27 18:59:45.937	2007-12-27 19:00:05.546	2007-12-28 19:59:45.937	10	10	266.00000000	1	\N	1	1		
273	0	f	PAYER JORIS	2007-12-27 19:00:12.375	2007-12-27 19:01:06.671	2007-12-28 18:00:00	10	10	267.00000000	1	\N	1	1		
275	0	t	EZGFZERGFRG	2007-12-27 19:00:28.875	2007-12-27 19:00:35.015	2007-12-27 20:00:28.875	10	10	269.00000000	1	\N	1	1		
274	0	t	ZEFZGFZER	2007-12-27 19:00:28.64	2007-12-27 19:00:34.656	2007-12-27 20:00:28.64	10	10	268.00000000	1	\N	1	1		
305	0	t		2008-01-08 17:48:11.375	2008-01-09 11:35:54.14	2008-01-08 18:48:11.375	10	10	270.00000000	1	\N	1	1		
306	0	t		2008-01-21 11:32:47.046	2008-01-22 08:01:49.015	2008-01-21 12:32:47.046	10	10	271.00000000	1	\N	1	1		
307	0	t		2008-01-22 18:40:15.437	2008-01-22 20:09:12.937	2008-01-15 19:40:00	10	10	272.00000000	1	\N	1	1		
310	0	f		2008-01-24 13:53:35.734	2000-01-01 00:00:35	2008-01-24 14:53:35.734	10	10	273.00000000	1	\N	1	1		
315	0	f		2008-01-24 13:53:35.937	2000-01-01 00:00:35	2008-01-24 14:53:35.937	10	10	277.00000000	1	\N	1	1		
319	0	f		2008-01-24 13:53:36.125	2000-01-01 00:00:36	2008-01-24 14:53:36.125	10	10	281.00000000	1	\N	1	1		
308	0	f		2008-01-24 13:53:35.671	2008-01-24 14:09:57.125	2008-01-24 14:53:35.671	10	10	273.00000000	1	\N	1	1		
309	0	f		2008-01-24 13:53:35.703	2008-01-24 14:09:57.593	2008-01-24 14:53:35.703	10	10	273.00000000	1	\N	1	1		
318	0	f		2008-01-24 13:53:36.078	2000-01-01 00:00:36	2008-01-24 14:53:36.078	10	10	280.00000000	1	\N	1	1		
317	0	f		2008-01-24 13:53:36.031	2000-01-01 00:00:36	2008-01-24 14:53:36.031	10	10	279.00000000	1	\N	1	1		
316	0	f		2008-01-24 13:53:35.984	2000-01-01 00:00:35	2008-01-24 14:53:35.984	10	10	278.00000000	1	\N	1	1		
314	0	f		2008-01-24 13:53:35.906	2000-01-01 00:00:35	2008-01-24 14:53:35.906	10	10	276.00000000	1	\N	1	1		
313	0	f		2008-01-24 13:53:35.875	2000-01-01 00:00:35	2008-01-24 14:53:35.875	10	10	275.00000000	1	\N	1	1		
312	0	f		2008-01-24 13:53:35.812	2000-01-01 00:00:35	2008-01-24 14:53:35.812	10	10	274.00000000	1	\N	1	1		
311	0	f		2008-01-24 13:53:35.765	2000-01-01 00:00:35	2008-01-24 14:53:35.765	10	10	273.00000000	1	\N	1	1		
320	0	t		2008-02-05 11:34:17.125	2008-02-05 11:53:46.39	2008-02-05 12:34:17.125	10	10	282.00000000	1	\N	1	1		
321	0	t		2008-02-06 15:12:01.286	2008-02-07 08:11:12.328	2008-02-06 16:12:01.286	10	10	283.00000000	1	\N	1	1		
322	0	t		2008-02-08 14:21:06.468	2008-02-08 18:26:42.578	2008-02-08 15:21:06.468	10	10	284.00000000	1	\N	1	1		
323	0	t		2008-02-08 14:54:18.828	2008-02-08 18:26:46	2008-02-08 15:54:18.828	10	10	285.00000000	1	\N	1	1		
324	0	t		2008-02-09 10:44:37.046	2008-02-09 18:19:58.875	2008-02-09 11:44:37.046	10	10	286.00000000	1	\N	1	1		
325	0	t		2008-02-26 18:37:26.64	2008-02-26 19:35:59.093	2008-02-26 19:37:26.64	10	10	287.00000000	1	\N	1	1		
326	0	t		2008-02-27 14:53:01.834	2008-02-27 16:41:44.1	2008-02-27 15:53:01.834	10	10	288.00000000	1	\N	1	1		
327	0	t		2008-02-27 14:53:05.022	2008-02-27 17:26:55.256	2008-02-27 15:53:05.022	10	10	289.00000000	1	\N	1	1		
328	0	t		2008-02-27 17:55:08.116	2008-02-27 19:21:20.647	2008-02-27 18:55:08.116	10	10	290.00000000	1	\N	1	1		
329	0	t		2008-02-27 17:55:11.569	2008-02-27 19:21:25.975	2008-02-27 18:55:11.569	10	10	291.00000000	1	\N	1	1		
330	0	t		2008-02-29 16:51:20.546	2008-02-29 18:42:21.718	2008-02-29 17:51:20.546	10	10	292.00000000	1	\N	1	1		
331	0	t		2008-03-15 18:36:08.843	2008-03-16 09:35:27.859	2008-03-15 19:36:08.843	10	10	293.00000000	1	\N	1	1		
332	0	t		2008-03-18 16:18:12.921	2008-03-18 16:28:14.796	2008-03-18 17:18:12.921	10	10	294.00000000	1	\N	1	1		
333	0	t		2008-03-18 16:18:13.093	2008-03-18 16:28:13.812	2008-03-18 17:18:13.093	10	10	295.00000000	1	\N	1	1		
334	0	t		2008-03-25 14:54:13.281	2008-03-25 16:24:54.64	2008-03-25 15:54:13.281	10	10	296.00000000	1	\N	1	1		
335	0	t		2008-03-26 14:31:09.349	2008-03-26 16:03:19.864	2008-03-26 15:31:09.349	10	10	297.00000000	1	\N	1	1		
336	0	t		2008-03-26 14:31:09.505	2008-03-26 16:03:23.442	2008-03-26 15:31:09.505	10	10	298.00000000	1	\N	1	1		
337	0	t		2008-03-28 10:35:45.328	2008-03-28 19:10:53.718	2008-03-28 11:35:45.328	10	10	299.00000000	1	\N	1	1		
338	0	t		2008-04-03 12:27:54.875	2008-04-03 14:20:50.406	2008-04-03 13:27:54.875	10	10	300.00000000	1	\N	1	1		
339	0	t		2008-04-21 17:30:08.312	2008-04-21 18:16:52.5	2008-04-21 18:30:08.312	10	10	301.00000000	1	\N	1	1		
340	0	t		2008-04-28 20:55:58.218	2008-04-29 17:39:50.984	2008-04-28 21:55:58.218	10	10	302.00000000	1	\N	1	1		
341	0	t		2008-05-03 08:37:26.531	2008-05-05 07:58:24.265	2008-05-03 09:37:26.531	10	10	303.00000000	1	\N	1	1		
342	1	t		2008-05-14 09:58:18.312	2008-05-14 19:51:30.876	2008-05-14 10:58:18.312	10	10	304.00000000	1	\N	1	1		
343	0	t		2008-05-26 09:34:11.359	2008-05-27 17:25:28.234	2008-05-26 10:34:11.359	10	10	305.00000000	1	\N	1	1		
344	0	t		2008-05-29 18:49:08.515	2008-05-29 20:06:29.625	2008-05-29 19:49:00	10	10	306.00000000	1	\N	1	1		
346	0	t		2008-07-11 18:39:18.765	2008-07-11 18:39:24.343	2008-07-11 19:39:18.765	10	10	308.00000000	1	\N	1	1		
345	0	t		2008-07-11 18:39:18.593	2008-07-11 18:42:00.453	2008-07-11 19:39:18.593	10	10	307.00000000	1	\N	1	1		
349	0	t		2008-07-11 18:39:20.75	2008-07-11 18:40:23.984	2008-07-11 19:39:20.75	10	10	311.00000000	1	\N	1	1		
348	1	t		2008-07-11 18:39:20.609	2008-07-11 18:40:23.468	2008-07-11 19:39:20.609	10	10	310.00000000	1	\N	1	1		
347	0	t		2008-07-11 18:39:20.468	2008-07-11 18:39:24.687	2008-07-11 19:39:20.468	10	10	309.00000000	1	\N	1	1		
350	0	t		2008-07-12 14:19:52.687	2008-07-12 18:46:10.265	2008-07-12 15:19:52.687	10	10	312.00000000	1	\N	1	1		
351	0	f		2008-07-16 08:44:22.64	2000-01-01 00:00:22	2008-07-16 09:44:22.64	10	10	313.00000000	1	\N	1	1		
352	0	t		2008-07-16 14:01:09.781	2008-07-16 15:20:35.203	2008-07-16 15:01:09.781	10	10	314.00000000	1	\N	1	1		
353	0	t		2008-07-18 12:26:47.281	2008-07-18 12:27:07.906	2008-07-18 13:26:47.281	10	10	315.00000000	1	\N	1	1		
354	0	f		2008-07-19 08:58:40.671	2000-01-01 00:00:40	2008-07-19 09:58:40.671	10	10	316.00000000	1	\N	1	1		
355	0	t		2008-07-23 11:49:29	2008-07-23 18:03:23.546	2008-07-23 12:49:29	10	10	317.00000000	1	\N	1	1		
357	0	t		2008-07-26 17:10:40.546	2008-07-28 06:58:26.296	2008-07-26 18:10:40.546	10	10	319.00000000	1	\N	1	1		
356	0	f		2008-07-26 16:26:22.781	2000-01-01 00:00:22	2008-07-26 17:26:22.781	10	10	318.00000000	1	\N	1	1		
390	0	t		2008-08-02 16:30:52.343	2008-08-05 08:23:46.921	2008-08-02 17:30:52.343	10	10	320.00000000	1	\N	1	1		
423	0	t		2008-08-07 17:31:17.791	2008-08-07 19:04:26.666	2008-08-07 18:31:17.791	10	10	321.00000000	1	\N	1	1		
424	0	t		2008-08-27 17:25:37.468	2008-08-27 19:02:24.984	2008-08-27 18:25:37.468	10	10	322.00000000	1	\N	1	1		
425	0	t		2008-09-05 13:31:28.859	2008-09-05 17:11:43.937	2008-09-05 14:31:28.859	10	10	323.00000000	1	\N	1	1		
426	0	t		2008-09-10 13:56:35.703	2008-09-10 18:12:56.375	2008-09-10 14:56:35.703	10	10	324.00000000	1	\N	1	1		
429	0	t		2008-09-16 10:10:34.312	2008-09-16 10:54:01.218	2008-09-16 11:10:34.312	10	10	327.00000000	1	\N	1	1		
427	0	f		2008-09-16 10:08:40.375	2008-09-16 10:54:05.421	2008-09-16 11:08:40.375	10	10	325.00000000	1	\N	1	1		
428	0	f		2008-09-16 10:08:42.671	2008-09-16 10:54:08.265	2008-09-16 11:08:42.671	10	10	326.00000000	1	\N	1	1		
430	0	f		2008-09-19 12:34:09.265	2000-01-01 00:00:09	2008-09-19 13:34:09.265	10	10	328.00000000	1	\N	1	1		
431	0	t		2008-09-25 19:26:26.53	2008-09-26 12:16:15.281	2008-09-25 20:26:26.53	10	10	329.00000000	1	\N	1	1		
464	0	t		2008-09-29 19:36:18.265	2008-09-30 07:41:25.062	2008-09-29 20:36:18.265	10	10	330.00000000	1	\N	1	1		
465	0	f		2008-10-02 13:32:50.046	2000-01-01 00:00:50	2008-10-02 14:32:50.046	10	10	331.00000000	1	\N	1	1		
466	0	f		2008-10-02 18:01:13.979	2000-01-01 00:00:13	2008-10-02 19:01:13.979	10	10	332.00000000	1	\N	1	1		
467	0	f		2008-10-07 18:56:15.812	2000-01-01 00:00:15	2008-10-07 19:56:15.812	10	10	333.00000000	1	\N	1	1		
468	0	t		2008-10-09 11:53:50.937	2008-10-09 12:17:11.468	2008-10-09 12:53:50.937	10	10	334.00000000	1	\N	1	1		
469	0	f		2008-10-09 11:54:32.453	2000-01-01 00:00:32	2008-10-09 12:54:32.453	10	10	335.00000000	1	\N	1	1		
470	0	f		2008-10-09 12:17:01.609	2000-01-01 00:00:01	2008-10-09 13:17:01.609	10	10	336.00000000	1	\N	1	1		
471	0	t		2008-10-16 13:44:31.125	2008-10-16 17:27:42.67	2008-10-16 14:44:31.125	10	10	337.00000000	1	\N	1	1		
472	0	f		2008-10-20 08:12:36.046	2000-01-01 00:00:36	2008-10-20 09:12:36.046	10	10	338.00000000	1	\N	1	1		
473	0	t		2008-10-21 18:10:33	2008-10-21 19:16:51.25	2008-10-21 19:10:33	10	10	339.00000000	1	\N	1	1		
474	0	t		2008-10-23 17:23:24.093	2008-10-23 17:58:18.234	2008-10-23 18:23:24.093	10	10	340.00000000	1	\N	1	1		
475	0	t		2008-10-29 12:09:09.171	2008-10-29 12:12:27.812	2008-10-29 13:09:09.171	10	10	341.00000000	1	\N	1	1		
476	0	t		2008-11-03 18:49:40.968	2008-11-04 07:57:48.296	2008-11-03 19:49:40.968	10	10	342.00000000	1	\N	1	1		
509	0	f		2008-11-05 19:19:53.156	2000-01-01 00:00:53	2008-11-05 20:19:53.156	10	10	343.00000000	1	\N	1	1		
510	0	t		2008-11-07 12:03:01.359	2008-11-07 12:16:27.39	2008-11-07 13:03:01.359	10	10	344.00000000	1	\N	1	1		
511	0	f		2008-11-13 16:07:47.765	2000-01-01 00:00:47	2008-11-13 17:07:47.765	2	2	345.00000000	1	\N	1	1		
173	1	t	Clam AV sur serveurs	2006-09-25 18:54:27	2008-11-13 16:16:56.984	2006-09-25 18:54:28	2	2	170.00000000	1	\N	1	1		
174	0	t	 	2006-09-27 12:38:48	2008-11-13 16:16:58	2006-09-27 12:38:52	2	2	171.00000000	1	\N	1	1		
180	0	t	 	2006-10-03 18:10:04	2008-11-13 16:16:58.609	2006-10-03 18:10:08	2	2	177.00000000	1	\N	1	1		
172	0	t	 	2006-09-21 15:31:57	2008-11-13 16:17:09.89	2006-09-21 15:29:36	2	2	169.00000000	1	\N	1	1		
205	0	t	 	2007-02-03 11:26:29	2008-11-13 16:17:01.093	2007-02-03 11:26:36	2	2	202.00000000	1	\N	1	1		
196	0	t	 	2006-10-26 14:52:47	2008-11-13 16:17:00.578	2006-10-26 14:52:45	2	2	193.00000000	1	\N	1	1		
177	0	t	 	2006-10-03 18:10:03	2008-11-13 16:17:07.937	2006-10-03 18:10:07	2	2	174.00000000	1	\N	1	1		
176	0	t	 	2006-10-03 18:10:03	2008-11-13 16:17:08.593	2006-10-03 18:10:07	2	2	173.00000000	1	\N	1	1		
169	3	t	zzrr	2006-09-13 14:56:15	2008-11-13 16:17:11.203	2006-09-13 14:56:00	2	2	166.00000000	1	\N	1	1		
512	0	t		2008-11-13 17:26:54.203	2008-11-13 17:26:55.562	2008-11-13 18:26:54.203	2	2	346.00000000	1	\N	1	1		
120	3	t	 	2007-01-30 18:02:15	2008-11-17 13:41:23.406	2006-05-15 19:59:00	2	2	117.00000000	1	\N	1	1		
181	1	f	 	2006-10-03 18:10:04	2008-11-17 13:41:26.531	2006-10-03 18:10:08	2	2	178.00000000	1	\N	1	1		
514	0	t		2008-11-17 13:41:53.359	2008-11-17 13:41:58.984	2008-11-17 14:41:53.359	2	2	348.00000000	1	\N	1	1		
515	0	f		2008-11-17 13:41:53.734	2008-11-17 13:42:02.562	2008-11-17 14:41:53.734	2	2	349.00000000	1	\N	1	1		
513	0	f		2008-11-17 13:41:52.296	2008-11-17 13:42:04.906	2008-11-17 14:41:52.296	2	2	347.00000000	1	\N	1	1		
516	0	t		2008-11-17 13:41:53.968	2008-11-17 13:42:07.125	2008-11-17 14:41:53.968	2	2	350.00000000	1	\N	1	1		
202	0	t	 	2007-01-26 18:54:38	2008-11-17 14:10:19.171	2007-01-11 09:26:00	5	2	199.00000000	1	\N	1	1		
168	0	t	 	2006-09-13 14:56:15	2008-11-17 14:10:22.218	2006-09-13 14:56:00	2	2	165.00000000	1	\N	1	1		
231	2	t	 	2007-03-02 16:41:12	2008-11-17 14:10:25.218	2007-03-02 17:41:12	3	2	225.00000000	1	\N	1	1		
203	1	t	Preparer le devis pour Mr Deteve	2007-01-26 18:54:38	2008-11-17 14:10:26.078	2007-01-26 14:10:00	5	2	200.00000000	1	\N	1	1		
204	0	t	 	2007-01-26 18:54:38	2008-11-17 14:10:26.921	2007-01-16 14:26:01	5	2	201.00000000	1	\N	1	1		
229	0	t	 	2007-02-28 17:05:54	2008-11-17 14:10:29.015	2007-02-28 18:05:54	3	2	223.00000000	1	\N	1	1		
68	0	t	Génération des documents OO	2006-05-27 12:44:02	2008-11-17 14:10:29.937	2006-04-27 16:52:00	1	2	65.00000000	1	\N	1	1		
182	0	t	 	2006-10-03 18:10:00	2008-11-17 14:10:30.937	2006-10-03 18:10:00	2	2	179.00000000	1	\N	1	1		
518	0	t		2008-11-18 18:23:35.25	2008-11-18 18:39:50.984	2008-11-18 19:23:35.25	2	2	352.00000000	1	\N	1	1		
519	0	t		2008-11-18 18:40:00.421	2008-11-18 18:40:02.453	2008-11-18 19:40:00.421	2	2	353.00000000	1	\N	1	1		
520	0	t		2008-11-19 12:30:27.171	2008-11-19 17:32:27.203	2008-11-19 13:30:27.171	2	2	354.00000000	1	\N	1	1		
521	0	t		2008-11-21 17:26:21.718	2008-11-21 17:32:38.921	2008-11-21 18:26:21.718	2	2	355.00000000	1	\N	1	1		
522	0	t		2008-11-26 18:51:29.921	2008-11-26 19:27:01.39	2008-11-26 19:51:29.921	2	2	356.00000000	1	\N	1	1		
523	0	t		2008-11-27 17:50:38.953	2008-11-27 17:50:51.218	2008-11-27 18:50:38.953	2	2	357.00000000	1	\N	1	1		
524	0	t		2008-12-01 17:49:59.187	2008-12-01 17:51:31.218	2008-12-01 18:49:59.187	2	2	358.00000000	1	\N	1	1		
526	0	t		2008-12-02 08:13:31.093	2008-12-02 08:15:04.265	2008-12-02 09:13:31.093	2	2	360.00000000	1	\N	1	1		
525	0	t		2008-12-02 08:13:30.968	2008-12-02 08:15:07.234	2008-12-02 09:13:30.968	2	2	359.00000000	1	\N	1	1		
527	0	t		2008-12-02 17:54:09.234	2008-12-02 18:14:49.562	2008-12-02 18:54:09.234	2	2	361.00000000	1	\N	1	1		
528	0	t		2008-12-04 17:50:38.937	2008-12-04 18:00:16.203	2008-12-04 18:50:38.937	2	2	362.00000000	1	\N	1	1		
529	0	t		2008-12-05 18:48:50.871	2008-12-05 18:59:38.496	2008-12-05 19:48:50.871	2	2	363.00000000	1	\N	1	1		
530	0	t		2008-12-09 10:01:55.328	2008-12-09 18:40:09.093	2008-12-09 11:01:55.328	2	2	364.00000000	1	\N	1	1		
531	0	t		2008-12-11 12:20:50.046	2008-12-12 17:18:19.374	2008-12-11 13:20:50.046	2	2	365.00000000	1	\N	1	1		
532	0	t		2008-12-12 14:19:00.921	2008-12-12 17:18:24.937	2008-12-12 15:19:00.921	2	2	366.00000000	1	\N	1	1		
535	0	t		2008-12-16 12:50:14.25	2008-12-16 12:50:18.578	2008-12-16 13:50:14.25	2	2	369.00000000	1	\N	1	1		
534	0	t		2008-12-16 12:50:13.562	2008-12-16 12:50:20.187	2008-12-16 13:50:13.562	2	2	368.00000000	1	\N	1	1		
533	0	t		2008-12-15 18:23:59.39	2008-12-16 12:50:22.968	2008-12-15 19:23:59.39	2	2	367.00000000	1	\N	1	1		
536	0	f		2008-12-17 17:54:48.218	2000-01-01 00:00:48	2008-12-17 18:54:48.218	2	2	370.00000000	1	\N	1	1		
537	0	t		2008-12-20 15:50:22.468	2008-12-20 15:53:59.046	2008-12-20 16:50:22.468	2	2	371.00000000	1	\N	1	1		
538	0	t		2009-01-05 17:40:06.093	2009-01-05 17:47:26.828	2009-01-05 18:40:06.093	2	2	372.00000000	1	\N	1	1		
539	0	t		2009-01-07 11:38:11.281	2009-01-07 13:24:17.734	2009-01-07 12:38:11.281	2	2	373.00000000	1	\N	1	1		
541	0	t		2009-01-09 17:13:21.859	2009-01-09 17:15:53.75	2009-01-09 18:13:21.859	2	2	375.00000000	1	\N	1	1		
540	0	t		2009-01-09 17:06:15.812	2009-01-09 17:15:56.015	2009-01-09 18:06:15.812	2	2	374.00000000	1	\N	1	1		
542	0	t		2009-01-13 09:27:48.437	2009-01-13 12:11:00.89	2009-01-13 10:27:48.437	2	2	376.00000000	1	\N	1	1		
543	0	t		2009-01-14 17:32:01.828	2009-01-14 17:47:19.593	2009-01-14 18:32:01.828	2	2	377.00000000	1	\N	1	1		
545	0	t		2009-01-26 18:22:35.656	2009-01-26 18:33:04.734	2009-01-26 19:22:35.656	2	2	379.00000000	1	\N	1	1		
544	0	t		2009-01-26 18:19:34.812	2009-01-26 18:33:08.046	2009-01-26 19:19:34.812	2	2	378.00000000	1	\N	1	1		
546	0	t		2009-01-27 13:20:47.062	2009-01-27 18:08:12.375	2009-01-27 14:20:47.062	2	2	380.00000000	1	\N	1	1		
547	0	t		2009-01-28 17:40:40.265	2009-01-28 18:31:02.062	2009-01-28 18:40:40.265	2	2	381.00000000	1	\N	1	1		
548	0	t		2009-01-29 07:46:00.484	2009-01-29 07:47:25.468	2009-01-29 08:46:00.484	2	2	382.00000000	1	\N	1	1		
549	0	f		2009-02-02 20:01:09.316	2000-01-01 00:00:09	2009-02-02 21:01:09.316	2	2	383.00000000	1	\N	1	1		
550	0	t		2009-02-06 12:07:21.234	2009-02-06 13:42:54.109	2009-02-06 13:07:21.234	2	2	384.00000000	1	\N	1	1		
552	0	f		2009-02-06 19:25:42.406	2000-01-01 00:00:42	2009-02-06 20:25:42.406	2	2	386.00000000	1	\N	1	1		
551	0	f		2009-02-06 15:44:50.234	2000-01-01 00:00:50	2009-02-06 16:44:50.234	2	2	385.00000000	1	\N	1	1		
553	0	t		2009-02-09 13:05:54.912	2009-02-10 12:00:35.375	2009-02-09 14:05:54.912	2	2	387.00000000	1	\N	1	1		
554	0	t		2009-02-12 12:09:44.328	2009-02-12 12:10:26.406	2009-02-12 13:09:44.328	2	2	388.00000000	1	\N	1	1		
555	0	t		2009-02-13 17:40:15.75	2009-02-14 11:32:07.171	2009-02-13 18:40:15.75	2	2	389.00000000	1	\N	1	1		
559	0	t		2009-02-16 07:49:24.625	2009-02-16 07:49:27.14	2009-02-16 08:49:24.625	2	2	393.00000000	1	\N	1	1		
557	0	t		2009-02-16 07:49:24.265	2009-02-16 07:49:26.171	2009-02-16 08:49:24.265	2	2	391.00000000	1	\N	1	1		
558	0	t		2009-02-16 07:49:24.421	2009-02-16 07:49:29.078	2009-02-16 08:49:24.421	2	2	392.00000000	1	\N	1	1		
556	0	t		2009-02-16 07:49:23.921	2009-02-16 07:49:25.75	2009-02-16 08:49:23.921	2	2	390.00000000	1	\N	1	1		
560	0	t		2009-02-23 14:13:44.85	2009-02-23 14:15:05.381	2009-02-23 15:13:44.85	2	2	394.00000000	1	\N	1	1		
561	0	t		2009-02-24 16:09:09.796	2009-02-24 16:09:56.921	2009-02-24 17:09:09.796	2	2	395.00000000	1	\N	1	1		
562	0	f		2009-02-25 08:16:58.937	2000-01-01 00:00:58	2009-02-25 09:16:58.937	2	2	396.00000000	1	\N	1	1		
563	0	t		2009-03-02 17:54:31.787	2009-03-03 08:18:31.359	2009-03-02 18:54:31.787	2	2	397.00000000	1	\N	1	1		
565	0	t		2009-03-09 16:19:51.321	2009-03-09 18:07:27.931	2009-03-09 17:19:51.321	2	2	399.00000000	1	\N	1	1		
564	0	t		2009-03-09 12:33:01.806	2009-03-09 18:07:31.603	2009-03-09 13:33:01.806	2	2	398.00000000	1	\N	1	1		
566	0	t		2009-03-13 17:26:02.687	2009-03-16 07:07:15.125	2009-03-13 18:26:02.687	2	2	400.00000000	1	\N	1	1		
568	0	t		2009-03-19 16:19:57.875	2009-03-19 16:57:34.39	2009-03-19 17:19:57.875	2	2	401.00000000	1	\N	1	1		
567	0	t		2009-03-19 16:19:57.765	2009-03-19 16:57:36.468	2009-03-19 17:19:57.765	2	2	401.00000000	1	\N	1	1		
570	0	t		2009-03-27 18:09:23.859	2009-03-27 18:38:40.062	2009-03-27 19:09:23.859	2	2	403.00000000	1	\N	1	1		
569	0	t		2009-03-27 17:21:50.843	2009-03-27 18:38:39.625	2009-03-27 18:21:50.843	2	2	402.00000000	1	\N	1	1		
571	0	t		2009-03-30 15:13:01.853	2009-03-30 17:01:37.698	2009-03-30 16:13:01.853	2	2	404.00000000	1	\N	1	1		
572	0	t		2009-04-03 12:10:21.125	2009-04-03 14:42:59.203	2009-04-03 13:10:21.125	10	10	405.00000000	1	\N	10	1		
575	0	t		2009-04-07 13:54:06.203	2009-04-07 13:54:29.421	2009-04-07 14:54:06.203	10	10	407.00000000	1	\N	10	1		
574	0	t		2009-04-07 13:54:06.031	2009-04-07 13:54:31.125	2009-04-07 14:54:06.031	10	10	406.00000000	1	\N	10	1		
573	0	t		2009-04-07 13:54:05.875	2009-04-07 13:54:32.765	2009-04-07 14:54:05.875	10	10	406.00000000	1	\N	10	1		
576	0	t		2009-04-08 15:15:55.468	2009-04-08 15:39:19.625	2009-04-08 16:15:55.468	10	10	408.00000000	1	\N	10	1		
577	0	t		2009-04-10 17:41:06.375	2009-04-10 17:41:18.406	2009-04-10 18:41:06.375	10	10	409.00000000	1	\N	10	1		
578	0	t		2009-04-15 18:10:04.328	2009-04-16 06:59:51.218	2009-04-15 19:10:04.328	10	10	410.00000000	1	\N	10	1		
579	0	f		2009-04-17 08:04:42.906	2000-01-01 00:00:42	2009-04-17 09:04:42.906	10	10	411.00000000	1	\N	10	1		
580	0	t		2009-04-17 17:11:54.406	2009-04-17 18:08:25.625	2009-04-17 18:11:54.406	10	10	412.00000000	1	\N	10	1		
581	0	t		2009-04-20 13:55:02.765	2009-04-20 13:58:07.578	2009-04-20 14:55:02.765	10	10	413.00000000	1	\N	10	1		
582	0	t		2009-04-21 08:51:56.718	2009-04-21 08:54:44.921	2009-04-21 09:51:56.718	10	10	414.00000000	1	\N	10	1		
583	0	t		2009-04-23 11:46:49.062	2009-04-23 11:46:57.64	2009-04-23 12:46:49.062	10	10	415.00000000	1	\N	10	1		
584	0	t		2009-04-24 09:02:50.875	2009-04-24 09:02:54.781	2009-04-24 10:02:50.875	10	10	416.00000000	1	\N	10	1		
585	0	t		2009-04-28 12:38:21.359	2009-04-28 15:34:28.046	2009-04-28 13:38:21.359	10	10	417.00000000	1	\N	10	1		
586	0	t		2009-04-29 10:02:45.421	2009-04-29 10:24:38.187	2009-04-29 11:02:45.421	10	10	418.00000000	1	\N	10	1		
587	0	t		2009-04-29 10:23:52.64	2009-04-29 10:24:44.171	2009-04-29 11:23:52.64	10	10	419.00000000	1	\N	10	1		
588	0	t		2009-04-30 08:25:10.25	2009-04-30 08:27:29.031	2009-04-30 09:25:10.25	10	10	420.00000000	1	\N	10	1		
589	0	t		2009-05-04 16:23:25.89	2009-05-04 16:30:01.14	2009-05-04 17:23:25.89	10	10	421.00000000	1	\N	10	1		
590	0	t		2009-05-12 15:39:22.7	2009-05-12 16:44:05.325	2009-05-12 16:39:22.7	10	10	422.00000000	1	\N	10	1		
592	0	t		2009-05-18 19:05:06	2009-05-18 19:29:44.781	2009-05-18 20:05:06	10	10	424.00000000	1	\N	10	1		
591	0	t		2009-05-18 19:04:26.921	2009-05-18 19:29:46.968	2009-05-18 20:04:26.921	10	10	423.00000000	1	\N	10	1		
594	0	t		2009-05-20 11:46:23.359	2009-05-20 12:16:17.703	2009-05-20 12:46:23.359	10	10	426.00000000	1	\N	10	1		
593	0	t		2009-05-20 10:45:58.609	2009-05-20 12:16:20.171	2009-05-20 11:45:58.609	10	10	425.00000000	1	\N	10	1		
595	0	t		2009-05-25 13:38:13.984	2009-05-25 13:38:20.046	2009-05-25 14:38:13.984	10	10	427.00000000	1	\N	10	1		
596	0	t		2009-05-25 13:38:14.203	2009-05-25 13:38:19.703	2009-05-25 14:38:14.203	10	10	428.00000000	1	\N	10	1		
597	0	t		2009-05-25 13:38:14.359	2009-05-25 13:38:19.281	2009-05-25 14:38:14.359	10	10	429.00000000	1	\N	10	1		
598	0	t		2009-05-26 09:57:38.5	2009-05-26 10:00:40	2009-05-26 10:57:38.5	10	10	430.00000000	1	\N	10	1		
599	0	t		2009-05-28 14:16:46.281	2009-05-28 18:41:37.328	2009-05-28 15:16:46.281	10	10	431.00000000	1	\N	10	1		
600	0	t		2009-06-05 16:54:16.541	2009-06-05 17:16:26.869	2009-06-05 17:54:16.541	10	10	432.00000000	1	\N	10	1		
601	0	t		2009-06-08 07:43:10.89	2009-06-08 07:46:15.656	2009-06-08 08:43:10.89	10	10	433.00000000	1	\N	10	1		
602	0	t		2009-06-11 15:57:36.14	2009-06-11 16:00:05.406	2009-06-11 16:57:36.14	10	10	434.00000000	1	\N	10	1		
603	0	t		2009-06-18 09:00:53.046	2009-06-18 09:23:37.015	2009-06-18 10:00:53.046	10	10	435.00000000	1	\N	10	1		
605	0	t		2009-06-24 15:39:04.989	2009-06-24 17:37:51.005	2009-06-24 16:39:04.989	10	10	437.00000000	1	\N	10	1		
604	0	t		2009-06-24 13:45:51.676	2009-06-24 17:37:52.801	2009-06-24 14:45:51.676	10	10	436.00000000	1	\N	10	1		
610	0	t		2009-07-01 06:15:49.718	2009-07-01 06:15:53.531	2009-07-01 07:15:49.718	10	10	442.00000000	1	\N	10	1		
607	0	t		2009-07-01 06:15:49.296	2009-07-01 06:15:52.062	2009-07-01 07:15:49.296	10	10	439.00000000	1	\N	10	1		
608	0	t		2009-07-01 06:15:49.468	2009-07-01 06:15:52.531	2009-07-01 07:15:49.468	10	10	440.00000000	1	\N	10	1		
606	0	t		2009-07-01 06:15:48.703	2009-07-01 06:15:51.703	2009-07-01 07:15:48.703	10	10	438.00000000	1	\N	10	1		
609	0	t		2009-07-01 06:15:49.578	2009-07-01 06:15:53	2009-07-01 07:15:49.578	10	10	441.00000000	1	\N	10	1		
611	1	f	fghghghggg	2009-07-01 06:16:18.328	2000-01-01 00:00:18	2009-07-01 07:16:18.328	10	10	443.00000000	1	\N	10	1		
613	0	f		2009-07-06 17:28:50.25	2000-01-01 00:00:50	2009-07-06 18:28:50.25	10	10	445.00000000	1	\N	10	1		
612	0	f		2009-07-06 17:28:50.25	2009-07-06 18:33:27.312	2009-07-06 18:28:50.25	10	10	444.00000000	1	\N	10	1		
614	0	f		2009-07-07 17:14:06.296	2009-07-07 20:25:33.109	2009-07-07 18:14:06.296	10	10	446.00000000	1	\N	10	1		
615	0	t		2009-07-13 11:19:16.609	2009-07-13 16:42:48.968	2009-07-13 12:19:16.609	10	10	447.00000000	1	\N	10	1		
616	0	t		2009-07-30 18:49:14.828	2009-07-30 19:14:33.984	2009-07-30 19:49:14.828	10	10	448.00000000	1	\N	10	1		
617	0	t		2009-07-31 19:15:55.484	2009-08-02 14:57:12.609	2009-07-31 20:15:55.484	10	10	449.00000000	1	\N	10	1		
618	0	t		2009-08-05 19:41:25.812	2009-08-06 07:13:08.328	2009-08-05 20:41:25.812	10	10	450.00000000	1	\N	10	1		
620	0	t		2009-08-10 17:32:56.228	2009-08-10 17:33:37.665	2009-08-10 18:32:56.228	10	10	452.00000000	1	\N	10	1		
622	0	f		2009-08-10 17:32:56.228	2009-08-10 17:33:40.556	2009-08-10 18:32:00	10	10	454.00000000	1	\N	10	1		
621	0	f		2009-08-10 17:32:56.228	2009-08-10 17:33:40.556	2009-08-10 18:32:56.228	10	10	453.00000000	1	\N	10	1		
619	0	t		2009-08-10 17:32:53.931	2009-08-10 17:33:38.509	2009-08-10 18:32:53.931	10	10	451.00000000	1	\N	10	1		
623	0	t		2009-08-11 16:09:27.046	2009-08-11 16:19:21.906	2009-08-11 17:09:27.046	10	10	455.00000000	1	\N	10	1		
624	0	t		2009-08-12 16:35:00.328	2009-08-12 17:02:20.328	2009-08-12 17:35:00.328	10	10	456.00000000	1	\N	10	1		
625	0	f		2009-08-12 17:01:40.171	2000-01-01 00:00:40	2009-08-12 18:01:40.171	10	10	457.00000000	1	\N	10	1		
626	0	f		2009-08-14 09:18:46.203	2000-01-01 00:00:46	2009-08-14 10:18:46.203	10	10	458.00000000	1	\N	10	1		
627	0	t		2009-08-31 10:55:52.687	2009-08-31 11:04:58.984	2009-08-31 11:55:52.687	10	10	459.00000000	1	\N	10	1		
628	0	t		2009-09-14 17:30:17.359	2009-09-14 17:58:00.687	2009-09-14 18:30:00	10	10	460.00000000	1	\N	10	1		
629	0	f		2009-09-14 17:41:28.062	2000-01-01 00:00:28	2009-09-14 18:30:00	10	10	461.00000000	1	\N	10	1		
630	1	f		2009-09-22 14:48:05.312	2000-01-01 00:00:05	2009-09-22 15:48:05.312	10	10	462.00000000	1	\N	10	1		
633	0	t		2009-09-24 16:46:42.812	2009-09-24 16:46:47.812	2009-09-24 17:46:42.812	10	10	465.00000000	1	\N	10	1		
632	0	f		2009-09-24 16:46:41.953	2000-01-01 00:00:41	2009-09-24 17:46:41.953	10	10	464.00000000	1	\N	10	1		
631	0	f		2009-09-24 08:17:33.421	2000-01-01 00:00:33	2009-09-24 09:17:33.421	10	10	463.00000000	1	\N	10	1		
634	0	f		2009-09-28 07:57:36.723	2000-01-01 00:00:36	2009-09-28 08:57:36.723	10	10	466.00000000	1	\N	10	1		
638	0	f		2009-10-02 19:28:12.062	2000-01-01 00:00:12	2009-10-02 20:28:12.062	10	10	470.00000000	1	\N	10	1		
637	0	f		2009-10-02 18:54:59.406	2000-01-01 00:00:59	2009-10-02 19:54:59.406	10	10	469.00000000	1	\N	10	1		
636	0	f		2009-10-02 18:54:59.265	2000-01-01 00:00:59	2009-10-02 19:54:59.265	10	10	468.00000000	1	\N	10	1		
635	0	f		2009-10-02 17:51:15.921	2000-01-01 00:00:15	2009-10-02 18:51:15.921	10	10	467.00000000	1	\N	10	1		
639	0	f		2009-10-06 17:14:32.203	2000-01-01 00:00:32	2009-10-06 18:14:32.203	10	10	471.00000000	1	\N	10	1		
641	0	f		2009-10-07 17:26:49.265	2000-01-01 00:00:49	2009-10-07 18:26:49.265	10	10	473.00000000	1	\N	10	1		
640	0	f		2009-10-07 16:33:23.765	2000-01-01 00:00:23	2009-10-07 17:33:23.765	10	10	472.00000000	1	\N	10	1		
642	0	f		2009-10-09 17:17:56.703	2000-01-01 00:00:56	2009-10-09 18:17:56.703	10	10	474.00000000	1	\N	10	1		
643	0	f		2009-10-13 07:43:28.125	2000-01-01 00:00:28	2009-10-13 08:43:28.125	10	10	475.00000000	1	\N	10	1		
644	0	t		2009-10-15 17:08:56.812	2009-10-15 17:09:32.515	2009-10-15 18:08:56.812	10	10	476.00000000	1	\N	10	1		
645	1	f		2009-10-20 16:37:15.906	2000-01-01 00:00:15	2009-10-20 17:37:15.906	10	10	477.00000000	1	\N	10	1		
646	0	t		2009-10-22 17:53:39.015	2009-10-23 16:20:29.812	2009-10-22 18:53:39.015	10	10	478.00000000	1	\N	10	1		
647	0	t		2009-10-24 10:35:13.265	2009-10-24 11:37:15.39	2009-10-24 11:35:13.265	10	10	479.00000000	1	\N	10	1		
648	0	f		2009-10-26 17:46:33.171	2000-01-01 00:00:33	2009-10-26 18:46:33.171	10	10	480.00000000	1	\N	10	1		
649	0	f		2009-10-29 16:48:51.515	2000-01-01 00:00:51	2009-10-29 17:48:51.515	10	10	481.00000000	1	\N	10	1		
650	0	t		2009-10-30 14:43:49.656	2009-10-30 17:06:01.531	2009-10-30 15:43:49.656	10	10	482.00000000	1	\N	10	1		
651	0	f		2009-11-04 17:21:05.921	2000-01-01 00:00:00	2009-11-04 18:21:05.921	10	10	483.00000000	1	\N	10	1		
652	0	f		2009-11-09 16:25:51.705	2000-01-01 00:00:51	2009-11-09 17:25:51.705	10	10	484.00000000	1	\N	10	1		
653	0	t		2009-11-10 12:40:11.328	2009-11-10 17:11:51.812	2009-11-10 13:40:11.328	10	10	485.00000000	1	\N	10	1		
654	0	t		2009-11-20 17:09:05.656	2009-11-20 17:46:18.671	2009-11-20 18:09:05.656	10	10	486.00000000	1	\N	10	1		
655	0	f		2009-11-25 21:17:17.031	2000-01-01 00:00:17	2009-11-25 22:17:17.031	10	10	487.00000000	1	\N	10	1		
656	0	t		2009-11-30 13:20:54.21	2009-11-30 17:02:49.256	2009-11-30 14:20:54.21	10	10	488.00000000	1	\N	10	1		
657	0	t		2009-12-07 18:08:32.062	2009-12-08 10:39:49.296	2009-12-07 19:08:32.062	10	10	489.00000000	1	\N	10	1		
658	0	t		2009-12-10 16:10:53.031	2009-12-10 16:11:41.734	2009-12-10 17:10:53.031	10	10	490.00000000	1	\N	10	1		
659	0	f		2009-12-22 07:22:48.899	2000-01-01 00:00:48	2009-12-22 08:22:48.899	10	10	491.00000000	1	\N	10	1		
660	0	t		2009-12-22 09:04:04.008	2009-12-22 10:52:04.856	2009-12-22 10:04:04.008	10	10	492.00000000	1	\N	10	1		
662	0	t		2010-01-04 17:55:37.375	2010-01-04 18:16:15.046	2010-01-04 18:55:37.375	10	10	494.00000000	1	\N	10	1		
661	0	f		2010-01-04 17:31:11.031	2000-01-01 00:00:11	2010-01-04 18:31:11.031	10	10	493.00000000	1	\N	10	1		
664	1	f		2010-01-05 18:28:18.546	2000-01-01 00:00:18	2010-01-05 19:28:18.546	10	10	496.00000000	1	\N	10	1		
663	0	f		2010-01-05 17:18:24.281	2000-01-01 00:00:24	2010-01-05 18:18:24.281	10	10	495.00000000	1	\N	10	1		
667	0	t		2010-01-06 20:19:32.364	2010-01-06 20:19:44.27	2010-01-06 21:19:32.364	10	10	499.00000000	1	\N	10	1		
665	0	f		2010-01-06 16:32:40.317	2000-01-01 00:00:40	2010-01-06 17:32:40.317	10	10	497.00000000	1	\N	10	1		
666	0	f		2010-01-06 20:19:32.254	2000-01-01 00:00:32	2010-01-06 21:19:32.254	10	10	498.00000000	1	\N	10	1		
668	0	t		2010-01-07 16:14:28.25	2010-01-08 07:49:57.437	2010-01-07 17:14:28.25	10	10	500.00000000	1	\N	10	1		
669	0	f		2010-01-11 16:37:31.734	2010-01-11 17:02:00.453	2010-01-11 17:37:31.734	10	10	501.00000000	1	\N	10	1		
670	0	f		2010-01-12 17:09:23.328	2000-01-01 00:00:23	2010-01-12 18:09:23.328	10	10	502.00000000	1	\N	10	1		
671	0	f		2010-01-15 08:35:37.921	2000-01-01 00:00:37	2010-01-15 09:35:37.921	10	10	503.00000000	1	\N	10	1		
673	0	t		2010-01-21 16:11:43.015	2010-01-21 16:11:46.406	2010-01-21 17:11:43.015	10	10	505.00000000	1	\N	10	1		
672	0	f		2010-01-21 14:51:11.234	2000-01-01 00:00:11	2010-01-21 15:51:11.234	10	10	504.00000000	1	\N	10	1		
676	0	t		2010-01-27 17:55:59.076	2010-01-27 18:04:52.435	2010-01-27 18:55:59.076	10	10	508.00000000	1	\N	10	1		
674	0	t		2010-01-27 17:53:23.795	2010-01-27 18:04:52.857	2010-01-27 18:53:23.795	10	10	506.00000000	1	\N	10	1		
675	0	t		2010-01-27 17:55:59.076	2010-01-27 18:04:52.435	2010-01-27 18:55:59.076	10	10	507.00000000	1	\N	10	1		
678	0	f		2010-02-02 17:33:21.031	2000-01-01 00:00:21	2010-02-02 18:33:21.031	10	10	510.00000000	1	\N	10	1		
677	0	t		2010-02-02 17:33:21.031	2010-02-02 17:38:34.687	2010-02-02 18:33:21.031	10	10	509.00000000	1	\N	10	1		
679	0	f		2010-02-04 07:25:19.25	2000-01-01 00:00:19	2010-02-04 08:25:19.25	10	10	511.00000000	1	\N	10	1		
680	0	f		2010-03-19 09:30:42.703	2000-01-01 00:00:42	2010-03-19 10:30:42.703	10	10	512.00000000	1	\N	10	1		
681	0	f		2010-06-15 17:10:40.181	2000-01-01 00:00:40	2010-06-15 18:10:40.181	2	2	513.00000000	1	\N	2	1		
682	0	f		2010-06-16 16:47:03.561	2000-01-01 00:00:03	2010-06-16 17:47:03.561	2	2	514.00000000	1	\N	2	1		
684	0	t	hhhhh	2010-06-28 17:24:59.106	2010-06-28 17:25:14.397	2010-06-28 18:24:59.106	2	2	516.00000000	1	\N	2	1		
685	0	f	ddd	2010-06-28 17:25:23.77	2000-01-01 00:00:23	2010-06-28 18:25:23.77	2	2	517.00000000	1	\N	2	1		
688	0	f		2010-06-29 10:53:14.226	2000-01-01 00:00:14	2010-06-29 11:53:14.226	2	2	520.00000000	1	\N	2	1		
687	0	f		2010-06-29 10:52:21.577	2010-06-29 10:53:06.322	2010-06-30 11:52:00	2	2	519.00000000	1	\N	2	1		
692	0	f	test 30 juin 17:24	2010-06-30 17:24:41.612	2000-01-01 00:00:41	2010-06-29 18:24:00	2	2	523.00000000	1	\N	2	1		
689	0	f		2010-06-30 09:25:05.492	2000-01-01 00:00:05	2010-06-30 10:25:05.492	2	2	521.00000000	1	\N	2	1		
690	0	f		2010-06-30 09:25:05.498	2000-01-01 00:00:05	2010-06-30 10:25:00	2	2	521.00000000	1	\N	2	1		
686	0	f	ddd	2010-06-28 17:25:25.897	2000-01-01 00:00:25	2010-06-28 18:25:00	2	2	518.00000000	1	\N	2	1		
695	0	f		2010-07-02 11:42:30.51	2000-01-01 00:00:30	2010-07-02 12:42:30.51	2	2	526.00000000	1	\N	2	1		
694	0	f		2010-07-02 11:39:57.434	2000-01-01 00:00:57	2010-07-02 12:39:57.434	2	2	525.00000000	1	\N	2	1		
696	0	f		2010-07-06 09:38:01.791	2000-01-01 00:00:01	2010-07-06 10:38:01.791	2	2	527.00000000	1	\N	2	1		
702	0	t		2011-02-05 20:18:49.204	2011-02-08 00:14:08.414	2011-02-05 21:18:49.204	2	2	533.00000000	0	\N	2	1		
699	2	t	Découvrir OpenConcerto	2011-01-17 22:39:25.562	2011-01-26 16:37:28.654	2012-09-10 16:29:00	2	2	530.00000000	0	\N	2	1		
693	3	t	Visiter www.GestionNX.org/test	2010-06-30 19:36:49.799	2011-01-26 16:37:28.102	2010-10-16 20:36:00	2	2	524.00000000	1	\N	2	1		
697	0	t	Présentation Sage	2010-09-27 20:11:05.658	2011-01-26 16:37:27.622	2010-09-27 21:11:05.658	2	2	528.00000000	1	13h-14h30	2	1		
683	0	t	Base PostgreSQL sur serveur hébergé	2010-06-28 14:13:27.537	2011-01-26 16:37:26.302	2010-07-02 15:13:00	2	2	515.00000000	1	\N	2	1		
691	1	t	Mise sous pli de GestionNX	2010-06-30 09:26:53.583	2010-06-30 19:39:08.659	2010-06-30 10:26:00	2	2	522.00000000	1	\N	2	1		
698	2	t		2010-10-05 13:59:00.761	2010-10-05 13:59:39.088	2010-10-05 14:59:00.761	2	2	529.00000000	1	\N	2	1		
703	0	f	nouvelle tâche	2011-02-08 14:52:16.517	\N	2011-02-08 15:52:16.517	2	2	534.00000000	0	\N	2	1		
700	1	t		2011-02-01 13:19:44.741	2011-02-05 13:47:41.815	2011-02-01 14:19:44.741	2	2	531.00000000	1	\N	2	1		
704	0	f		2011-02-08 14:52:22.195	2000-01-01 00:00:00	2011-02-08 15:52:22.195	2	2	535.00000000	1	\N	2	1		
701	0	t		2011-02-05 13:47:39.125	2011-02-05 20:18:57.751	2011-02-05 14:47:39.125	2	2	532.00000000	0	\N	2	1		
1	0	f	Finir de coder	2006-04-13 21:05:00	2000-01-01 00:00:00	2000-01-01 00:00:00	1	1	1.00000000	0	\N	1	1		
2	1	f	Dormir	2007-01-30 18:02:15	2000-01-01 00:00:00	2000-01-01 00:00:00	1	1	2.00000000	1	\N	1	1		
5	2	f	test2 save	2007-01-30 18:02:15	2005-01-01 00:00:00	2005-01-01 00:00:00	1	1	0.00000000	1	\N	1	1		
6	2	f	salut toi jjjjjjjjj	2006-05-09 20:40:18	2005-01-01 00:00:00	2006-04-20 00:00:00	1	1	0.00000000	1	\N	1	1		
7	1	f	testnull	2006-11-06 17:22:41	2000-01-01 00:00:00	2006-04-19 00:00:00	1	1	0.00000000	1	\N	1	1		
8	0	f	comment	2006-05-09 19:44:50	2006-05-09 19:43:35	2006-05-09 19:43:35	1	1	5.00000000	1	\N	1	1		
9	2	f	 	2006-05-10 12:19:46	2006-04-20 18:19:32	2006-04-20 18:19:32	1	1	6.00000000	1	\N	1	1		
10	0	f	 	2006-05-09 19:48:14	2006-04-20 18:19:36	2006-04-20 18:19:36	1	1	7.00000000	1	\N	1	1		
11	0	t	 	2006-05-09 19:48:14	2006-04-20 18:19:49	2006-04-20 18:19:49	1	1	8.00000000	1	\N	1	1		
12	0	f	 	2006-05-09 19:48:14	2006-04-20 18:19:59	2006-04-20 18:19:59	1	1	9.00000000	1	\N	1	1		
13	0	t	 	2006-05-09 19:48:14	2006-04-20 18:28:36	2006-04-20 18:28:36	1	1	10.00000000	1	\N	1	1		
14	0	f	 	2006-05-09 19:48:14	2006-04-20 18:28:37	2006-04-20 18:28:37	1	1	11.00000000	1	\N	1	1		
15	0	t	 	2006-05-09 19:48:14	2006-04-20 18:28:37	2006-04-20 18:28:37	1	1	12.00000000	1	\N	1	1		
16	0	f	 	2006-05-09 19:48:14	2006-04-20 18:28:38	2006-04-20 18:28:38	1	1	13.00000000	1	\N	1	1		
17	0	t	 	2006-05-09 19:48:14	2006-04-20 18:28:38	2006-04-20 18:28:38	1	1	14.00000000	1	\N	1	1		
18	0	f	 	2006-05-09 19:48:14	2006-04-20 18:28:38	2006-04-20 18:28:38	1	1	15.00000000	1	\N	1	1		
19	0	f	 	2006-05-09 19:48:14	2006-04-20 18:28:38	2006-04-20 18:28:38	1	1	16.00000000	1	\N	1	1		
20	0	f	 	2006-05-09 19:48:14	2006-04-20 18:28:39	2006-04-20 18:28:39	1	1	17.00000000	1	\N	1	1		
21	0	f	 	2006-05-09 19:48:14	2006-04-20 18:28:39	2006-04-20 18:28:39	1	1	18.00000000	1	\N	1	1		
22	0	f	 	2006-05-09 19:48:14	2006-04-20 18:28:41	2006-04-20 18:28:41	1	1	19.00000000	1	\N	1	1		
23	0	f	 	2006-05-09 19:48:14	2006-04-20 18:29:20	2006-04-20 18:29:20	1	1	20.00000000	1	\N	1	1		
24	0	f	 	2006-05-09 19:48:14	2006-04-20 18:29:20	2006-04-20 18:29:20	1	1	21.00000000	1	\N	1	1		
25	0	f	 	2006-05-09 19:48:14	2006-04-20 18:29:21	2006-04-20 18:29:21	1	1	22.00000000	1	\N	1	1		
26	0	f	 	2006-05-09 19:48:14	2006-04-20 18:29:21	2006-04-20 18:29:21	1	1	23.00000000	1	\N	1	1		
27	0	f	 	2006-05-09 19:48:14	2006-04-20 18:29:44	2006-04-20 18:29:44	1	1	24.00000000	1	\N	1	1		
28	0	f	 	2006-05-09 19:48:14	2006-04-20 18:29:51	2006-04-20 18:29:51	1	1	25.00000000	1	\N	1	1		
29	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:15	2006-04-20 18:34:15	1	1	26.00000000	1	\N	1	1		
30	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:48	2006-04-20 18:34:48	1	1	27.00000000	1	\N	1	1		
31	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:49	2006-04-20 18:34:49	1	1	28.00000000	1	\N	1	1		
32	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:49	2006-04-20 18:34:49	1	1	29.00000000	1	\N	1	1		
33	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:49	2006-04-20 18:34:49	1	1	30.00000000	1	\N	1	1		
34	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:50	2006-04-20 18:34:50	1	1	31.00000000	1	\N	1	1		
35	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:50	2006-04-20 18:34:50	1	1	32.00000000	1	\N	1	1		
36	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:50	2006-04-20 18:34:50	1	1	33.00000000	1	\N	1	1		
37	0	f	 	2006-05-09 19:48:14	2006-04-20 18:34:50	2006-04-20 18:34:50	1	1	34.00000000	1	\N	1	1		
38	0	f	 	2006-05-09 19:48:14	2006-04-20 18:35:06	2006-04-20 18:35:06	1	1	35.00000000	1	\N	1	1		
39	0	f	 	2006-05-09 19:48:14	2006-04-20 18:41:21	2006-04-20 18:41:21	1	1	36.00000000	1	\N	1	1		
40	0	f	 	2006-05-09 19:48:14	2006-04-20 18:41:25	2006-04-20 18:41:25	1	1	37.00000000	1	\N	1	1		
41	0	f	 	2006-05-09 19:48:14	2006-04-20 18:41:26	2006-04-20 18:41:26	1	1	38.00000000	1	\N	1	1		
42	0	f	 	2006-05-09 19:48:14	2006-04-20 18:41:26	2006-04-20 18:41:26	1	1	39.00000000	1	\N	1	1		
43	0	f	 	2006-05-09 19:48:14	2006-04-20 18:41:27	2006-04-20 18:41:27	1	1	40.00000000	1	\N	1	1		
44	0	f	 	2006-05-09 19:48:14	2006-04-20 18:42:06	2006-04-20 18:42:06	1	1	41.00000000	1	\N	1	1		
45	0	f	 	2006-05-09 19:48:14	2006-04-20 18:42:07	2006-04-20 18:42:07	1	1	42.00000000	1	\N	1	1		
46	0	f	 	2006-05-09 19:48:14	2006-04-20 18:42:10	2006-04-20 18:42:10	1	1	43.00000000	1	\N	1	1		
47	0	f	 	2006-05-09 19:48:14	2006-04-20 18:42:11	2006-04-20 18:42:11	1	1	44.00000000	1	\N	1	1		
48	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:31	2006-04-20 18:58:31	1	1	45.00000000	1	\N	1	1		
49	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:32	2006-04-20 18:58:32	1	1	46.00000000	1	\N	1	1		
50	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:32	2006-04-20 18:58:32	1	1	47.00000000	1	\N	1	1		
51	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:33	2006-04-20 18:58:33	1	1	48.00000000	1	\N	1	1		
52	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:33	2006-04-20 18:58:33	1	1	49.00000000	1	\N	1	1		
53	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:33	2006-04-20 18:58:33	1	1	50.00000000	1	\N	1	1		
54	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:33	2006-04-20 18:58:33	1	1	51.00000000	1	\N	1	1		
55	0	f	 	2006-05-09 19:48:14	2006-04-20 18:58:33	2006-04-20 18:58:33	1	1	52.00000000	1	\N	1	1		
56	0	f	 	2006-05-09 19:48:14	2006-04-20 20:46:29	2006-04-20 20:46:29	1	1	53.00000000	1	\N	1	1		
57	0	f	 	2006-05-09 19:48:14	2006-04-20 20:46:31	2006-04-20 20:46:31	1	1	54.00000000	1	\N	1	1		
58	0	f	 	2006-05-09 19:48:14	2006-04-20 20:46:32	2006-04-20 20:46:32	1	1	55.00000000	1	\N	1	1		
59	0	f	 	2006-05-09 19:48:14	2006-04-21 12:40:36	2006-04-21 12:40:36	1	1	56.00000000	1	\N	1	1		
60	0	f	 	2006-05-09 19:48:14	2006-04-21 18:42:50	2006-04-21 18:42:50	1	1	57.00000000	1	\N	1	1		
61	0	f	 	2006-05-09 19:48:14	2006-04-21 20:26:36	2006-04-21 20:26:36	1	1	58.00000000	1	\N	1	1		
62	0	f	 	2006-05-09 19:48:14	2006-04-21 20:26:37	2006-04-21 20:26:37	1	1	59.00000000	1	\N	1	1		
63	0	f	 	2006-05-09 19:48:14	2006-04-21 20:26:37	2006-04-21 20:26:37	1	1	60.00000000	1	\N	1	1		
64	0	f	 	2006-05-09 19:48:14	2006-04-21 20:26:37	2006-04-21 20:26:37	1	1	61.00000000	1	\N	1	1		
65	2	t	pour user 0	2006-05-27 12:44:02	2006-04-21 20:26:38	2006-04-21 20:26:38	1	1	62.00000000	1	\N	1	1		
\.


--
-- Data for Name: TACHE_LISTENER_COMMON; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "TACHE_LISTENER_COMMON" ("ID", "ID_USER_COMMON", "ID_USER_COMMON_LISTENTO", "ARCHIVE", "ORDRE") FROM stdin;
1	1	1	0	1.00000000
2	2	2	0	1.00000000
3	2	1	0	1.00000000
\.


--
-- Data for Name: TACHE_RIGHTS; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "TACHE_RIGHTS" ("ID", "ID_USER_COMMON", "ID_USER_COMMON_TO", "READ", "MODIFY", "ADD", "VALIDATE", "ARCHIVE") FROM stdin;
2	2	1	t	t	t	f	0
3	2	1	t	t	t	f	0
4	2	1	t	f	t	f	0
5	1	1	t	t	t	t	0
6	1	1	t	t	t	f	0
7	1	2	t	t	t	f	0
8	1	2	t	f	t	f	0
9	1	1	t	f	t	f	0
19	1	1	t	t	t	t	0
18	1	1	t	t	t	f	0
21	1	1	t	t	t	f	0
20	1	1	t	t	t	f	0
23	1	1	t	t	t	f	0
22	1	1	t	t	t	f	0
24	1	1	t	t	t	f	0
11	1	1	t	t	t	t	0
10	1	1	t	f	t	t	0
13	1	1	t	f	f	f	0
12	1	1	t	t	t	t	0
15	1	1	t	t	t	f	0
14	1	2	t	f	t	f	0
17	1	2	t	f	f	f	0
16	1	1	t	t	t	f	0
25	10	10	t	t	t	t	1
1	2	2	t	t	t	t	0
29	2	2	f	f	f	f	0
34	13	14	f	f	f	f	1
33	13	13	t	f	f	f	1
28	12	2	t	t	t	t	1
27	12	11	t	t	f	t	1
31	2	12	t	t	t	t	1
26	12	12	t	t	f	f	1
32	11	12	t	t	t	t	1
30	2	11	f	f	f	f	0
\.


--
-- Data for Name: TYPE_MODELE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "TYPE_MODELE" ("ID", "NOM", "TABLE", "DEFAULT_MODELE", "ARCHIVE", "ORDRE") FROM stdin;
1				0	0.00000000
2	Avoir client	AVOIR_CLIENT	Avoir	0	1.00000000
3	Bon de livraison	BON_DE_LIVRAISON	BonLivraison	0	2.00000000
4	Commande Client	COMMANDE_CLIENT	CommandeClient	0	3.00000000
5	Devis	DEVIS	Devis	0	4.00000000
6	Facture	SAISIE_VENTE_FACTURE	VenteFacture	0	5.00000000
\.


--
-- Data for Name: TYPE_RUBRIQUE_BRUT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "TYPE_RUBRIQUE_BRUT" ("ID", "NOM", "ORDRE", "ARCHIVE") FROM stdin;
1	Indéfini	1.00000000	0
2	Gain	1.00000000	0
3	Retenue	1.00000000	0
4	Avantage en nature	1.00000000	1
5	Abattement sur le brut	1.00000000	1
\.


--
-- Data for Name: TYPE_RUBRIQUE_NET; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "TYPE_RUBRIQUE_NET" ("ID", "NOM", "ARCHIVE", "ORDRE") FROM stdin;
1	Indéfini	0	1.00000000
2	Gain	0	1.00000000
3	Retenue	0	1.00000000
4	Avantage nature	1	1.00000000
\.


--
-- Data for Name: USER_COMMON; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "USER_COMMON" ("ID", "LOGIN", "PASSWORD", "NOM", "PRENOM", "SURNOM", "ORDRE", "ARCHIVE", "SUPERUSER", "ADMIN", "MAIL") FROM stdin;
9	kd	c9mAZI3qUvhad8kxnJ7DyPPSPIQ=	kd	 	 	7.00000000	1	f	f	
8	Sylvain3	mbkiehDNwMXrbCeQaVh0Lx6kYRY=	Cuaz3	Sylvain	Syvain	3.00000000	1	f	f	
7	Ludo2	l9b6kGUOaOqYuRbCiGFniXIhWTU=	Dupent	Ludovic	Ludo	1.00000000	1	f	f	
1	Indéfini	 	 	 	 	0.00000000	0	f	f	
3	Guillaume	OTjyI/J9/yAUpUaZGzrGHuJ8JKA=	Maillard	Guillaume	Guillaume	0.00000000	1	f	f	
4	Sylvain	OTjyI/J9/yAUpUaZGzrGHuJ8JKA=	Cuaz	Sylvain	Syvain	0.00000000	1	f	f	
5	Ludo	OTjyI/J9/yAUpUaZGzrGHuJ8JKA=	Dupent	Ludovic	Ludo	0.00000000	1	f	f	
6	JP	OTjyI/J9/yAUpUaZGzrGHuJ8JKA=	Maillard	Jean-Pierre	JP	2.00000000	1	f	f	
2	Administrateur	2jmj7l5rSw0yVb/vlWAYkK/YBwk=	Administrateur	 	Admin	0.00000000	0	f	t	
10	ODT	OTjyI/J9/yAUpUaZGzrGHuJ8JKA=	ODT			2.50000000	1	f	f	
11	alice	UisnajVr3zkBPfq+os1D4UHsyeg=	Dubois	Alice		8.00000000	0	f	f	
14	toto	C5wmJdwh7wX2rU3fR8XyA4N6oyw=				9.25000000	1	f	f	
13	seblem2	nPldrNIm3PQ9o3bNtsu6cDUhiSE=	lemaitre5	sebastien3	seblemq	9.50000000	1	f	t	qsdqsdqd
12	sebastien	nPldrNIm3PQ9o3bNtsu6cDUhiSE=	lemaitre3	sebastien	seblem	9.00000000	1	f	t	dddd
15	SANDRA	ytFSQ2DliFHNCuHoK3X/UoNHRmc=	DUPONT	SANDRA		10.50000000	0	f	f	
\.


--
-- Data for Name: USER_RIGHT; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "USER_RIGHT" ("ORDRE", "ARCHIVE", "ID_USER_COMMON", "HAVE_RIGHT", "CODE", "ID", "NOM", "DESCRIPTION", "ID_RIGHT", "OBJECT") FROM stdin;
0.00000000	0	1	f		1			1	
5.00000000	0	2	t		6			6	\N
8.00000000	0	2	t		9			9	\N
8.50000000	0	2	t		10			8	\N
9.00000000	0	2	t		11			10	\N
9.50000000	0	2	t		12			11	\N
10.00000000	0	2	t		13			12	\N
10.50000000	0	2	t		14			7	\N
11.50000000	0	2	t		15			13	\N
12.50000000	0	2	t		16			14	\N
7.00000000	0	2	t		8			5	\N
1.00000000	1	10	t		2			2	
6.00000000	1	1	t		7			7	\N
4.00000000	1	1	t		5			5	\N
12.00000000	0	2	t		17			15	\N
13.50000000	1	12	t		18			6	mlmmm
2.00000000	0	1	t		3			3	\N
14.50000000	0	2	t		19			16	\N
3.00000000	1	10	t		4			10	\N
\.


--
-- Data for Name: VARIABLE_PAYE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "VARIABLE_PAYE" ("ID", "VALEUR", "FORMULE", "NOM", "ARCHIVE", "ORDRE", "CATEGORIE", "INFOS") FROM stdin;
1	0	 	Indéfini	0	1.00000000	 	 
2	12	 	Var12	1	1.00000000	 	 
3	24	 	Var24	1	1.00000000	 	 
4	0	Var12 + 2 + DUREE_HEBDO;	MA_VAR	1	1.00000000	 	 
6	0	int a = 2;	var2	1	1.00000000	 	 
7	98	 	var98	1	5.00000000	 	 
8	123	 	varInCat	1	6.00000000	cat	 
9	123	 	varInCat2	1	7.00000000	 	 
10	0	varInCat2 + DUREE_HEBDO;	myNewVarCat	1	8.00000000	CAT	 
11	0	Var12 + Var24;	varvar	1	9.00000000	 	 
12	0	varInCat2;	varbis	1	10.00000000	 	 
13	0	15645;	var15645	1	11.00000000	 	 
14	0	123;	qfqsdf	1	12.00000000	 	 
15	0	MA_VAR;	wxcwxcwx	1	13.00000000	 	 
16	0	var = 15.0;\nvar += 16 + DUREE_HEBDO + Var24;\n	varNewCalc	1	14.00000000	 	 
18	0	SALAIRE_MOIS/DUREE_MOIS;	TAUXHOR	0	16.00000000	 	Taux horaire de base du salarié
19	8.2700005	 	GMR2	1	17.00000000	 	 
20	2589	 	PLAFOND_TRANCHE_A	1	18.00000000	Plafond SS	 
21	0	PLAFOND_TRANCHE_A * 3;	PLAFOND_TRANCHE_B	0	19.00000000	Plafond SS	plafond sécurité sociale tranche B
22	0	PLAFOND_TRANCHE_A * 4;	PLAFOND_TRANCHE_C	0	20.00000000	Plafond SS	plafond sécurité sociale tranche C
23	0	PLAFOND_TRANCHE_A * 4;	PLAFOND_TRANCHE_C	1	21.00000000	Plafond SS	 
25	0	TRANCHE_B=0.0F;\nif(SAL_BRUT > PLAFOND_TRANCHE_B){\n\tTRANCHE_B = PLAFOND_TRANCHE_B-PLAFOND_TRANCHE_A;\n}else{\n\tif((SAL_BRUT - PLAFOND_TRANCHE_A)>0){\n\t    TRANCHE_B = SAL_BRUT - PLAFOND_TRANCHE_A;\n\t}\n}	TRANCHE_B	0	23.00000000	Tranche SS	tranche B du salaire brut
26	0	TRANCHE_C = 0.0F;\nif(SAL_BRUT > PLAFOND_TRANCHE_C){\n\tTRANCHE_C = PLAFOND_TRANCHE_C - PLAFOND_TRANCHE_B;\t\n}else{\n\tif((SAL_BRUT - PLAFOND_TRANCHE_C)>0){\n\tTRANCHE_C = SAL_BRUT - PLAFOND_TRANCHE_B;\n\t}\n}	TRANCHE_C	0	24.00000000	Tranche SS	Tranche C du salaire brut
27	123	 	qsd	1	25.00000000	 	 
28	0	12;	xcxvcxvx	1	26.00000000	 	 
29	0	12;	kj12	1	27.00000000	 	 
30	0	COEFF1=0.0F;\n\nif((SAL_BRUT/DUREE_MOIS)<(1.6*SMIC)){\n\tfloat smicMensuel = SMIC * DUREE_MOIS;\n\tfloat t = 1.6F * smicMensuel / SALAIRE_MOIS;\n\tCOEFF1 = Math.min(0.26F, (0.26F/0.6F)*(t-1.0F));\n}\n	COEFF1	0	28.00000000	 	Coefficient de réduction sur loi Fillon
31	0	Vqdsqsdqd = 123.0;	Vqdsqsdqd	1	29.00000000	 	 
32	0	mlk = 0.0;\n	mlk	1	30.00000000	 	 
33	2589	 	PLAFOND_TRANCHE_A	1	31.00000000	 	 
36	280	 	GMP	0	34.00000000	 	 
37	0	RCONG = TAUXHOR * HEURE_TRAV / JOUR_OUVR;\n	RCONG	1	35.00000000	Congés	 
38	6	 	JOUR_OUVR	0	36.00000000	Congés	 
39	50	 	TRANCHE_D	1	37.00000000	tranche SS	tranche d de la sécurité sociale
40	50	 	TRANCHE_D	1	38.00000000	tranche SS	 
41	50	 	TRANCHE_D	1	39.00000000	tranche SS	 
42	50	 	TRANCHE_D	0	40.00000000	tranche SS	 
43	0	32 + CONGES_PRIS;	VARPAYETESTCOMMON	0	41.00000000	 	 
44	21.559999	 	GMP_TAUX_SAL	1	42.00000000	 	 
45	35.27	 	GMP_TAUX_PAT	1	43.00000000	 	 
46	35.27	 	PART_PAT_GMP	1	44.00000000	 	 
47	21.559999	 	PART_SAL_GMP	1	45.00000000	 	 
50	21.559999	 	GMP_TAUX_SAL	0	48.00000000	 	 
34	2885		PLAFOND_TRANCHE_A	0	32.00000000	Plafond SS	plafond sécurité sociale tranche A
35	20.77		APEC	0	33.00000000	 	 
17	9		SMIC	0	15.00000000	 	Taux horaire du SMIC
24	2946	TRANCHE_A = 0.0F;\nTRANCHE_A = SAL_BRUT;\n\nif (SAL_BRUT > PLAFOND_TRANCHE_A){\n\tTRANCHE_A = PLAFOND_TRANCHE_A;\n}	TRANCHE_A	0	22.00000000	Tranche SS	tranche A du salaire brut
48	23.83	 	PART_SAL_GarantieMP	0	46.00000000	 	 
49	38.98	 	PART_PAT_GarantieMP	0	47.00000000	 	 
\.


--
-- Data for Name: VILLE; Type: TABLE DATA; Schema: Common; Owner: openconcerto
--

COPY "VILLE" ("ID", "NOM", "CODE_POSTAL", "X_LAMBERT", "Y_LAMBERT", "POPULATION", "ARCHIVE", "ORDRE") FROM stdin;
1	Indéfini	\N	0	0	0	0	0.00000000
116	VERDUN	55100	0	0	0	0	1.00000000
117	Verdun	55100	0	0	0	0	2.00000000
\.


SET search_path = "Default", pg_catalog;

--
-- Data for Name: ACOMPTE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ACOMPTE" ("ID", "ID_SALARIE", "MONTANT", "ID_MOUVEMENT", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	1	0	1	0	0.00000000	\N	1	1	\N
\.


--
-- Data for Name: ADRESSE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ADRESSE" ("ARCHIVE", "ORDRE", "ID_ADRESSE", "RUE", "CODE_POSTAL", "PAYS", "VILLE", "HAS_CEDEX", "CEDEX", "DEST", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "ID_CLIENT") FROM stdin;
0	0.00000000	1	indéfini	0	 	 	f	\N		1	\N	1	\N	1
0	1.00000000	6	indéfini	0	 	 	f	\N		1	\N	1	\N	1
0	2.00000000	7	indéfini	0	 	 	f	\N		1	\N	1	\N	1
0	3.00000000	5	indéfini	0	 	 	f	\N		1	\N	1	\N	1
0	4.00000000	8	indéfini	0	 	 	f	\N		1	\N	1	\N	1
0	5.00000000	3	indéfini	0	 	 	f	\N		1	\N	1	\N	1
0	6.00000000	2	indéfini	0	 	 	f	\N		1	\N	1	\N	1
0	7.00000000	4	indéfini	0	 	 	f	\N		1	\N	1	\N	1
\.


--
-- Data for Name: ARTICLE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ARTICLE" ("ID", "CODE", "NOM", "PA_HT", "PV_HT", "ID_TAXE", "POIDS", "ARCHIVE", "ORDRE", "CREATION_AUTO", "PV_TTC", "ID_STOCK", "PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_VT_1", "VALEUR_METRIQUE_1", "ID_METRIQUE_1", "VALEUR_METRIQUE_2", "ID_METRIQUE_2", "PRIX_METRIQUE_HA_2", "PRIX_METRIQUE_VT_2", "ID_METRIQUE_3", "VALEUR_METRIQUE_3", "PRIX_METRIQUE_HA_3", "PRIX_METRIQUE_VT_3", "ID_MODE_VENTE_ARTICLE", "SERVICE", "OBSOLETE", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "ID_FAMILLE_ARTICLE", "INFOS", "QTE_ACHAT", "DESCRIPTIF", "CODE_BARRE", "GESTION_STOCK", "CODE_DOUANIER", "QTE_MIN", "ID_DEVISE", "ID_FOURNISSEUR", "PV_U_DEVISE", "ID_DEVISE_HA", "PA_DEVISE", "ID_PAYS", "ID_UNITE_VENTE") FROM stdin;
1	 	Indéfini	0	0	2	0	0	0.00000000	f	0	1	0	0	0	1	0	1	0	0	1	0	0	0	5	f	f	\N	\N	\N	\N	1		1			t		1	1	1	0	1	0	1	2
\.


--
-- Data for Name: ARTICLE_DESIGNATION; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ARTICLE_DESIGNATION" ("ID", "ID_ARTICLE", "ID_LANGUE", "NOM", "ARCHIVE", "ORDRE") FROM stdin;
1	1	1		0	0.00000000
\.


--
-- Data for Name: ARTICLE_TARIF; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ARTICLE_TARIF" ("ID", "ID_DEVISE", "ID_TAXE", "ID_TARIF", "ID_ARTICLE", "PV_HT", "PV_TTC", "PRIX_METRIQUE_VT_1", "PRIX_METRIQUE_VT_2", "PRIX_METRIQUE_VT_3", "ARCHIVE", "ORDRE") FROM stdin;
1	1	1	1	1	0	0	0	0	0	0	0.00000000
\.


--
-- Data for Name: ASSOCIATION_COMPTE_ANALYTIQUE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ASSOCIATION_COMPTE_ANALYTIQUE" ("ID", "ID_COMPTE_PCE", "ID_AXE_ANALYTIQUE", "ORDRE", "ARCHIVE", "ID_REPARTITION_ANALYTIQUE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	1	1	0.00000000	0	1	\N	1	1	\N
\.


--
-- Data for Name: AVOIR_CLIENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "AVOIR_CLIENT" ("ID", "NOM", "DATE", "MONTANT_TTC", "ID_TAXE", "ARCHIVE", "ORDRE", "ID_CLIENT", "MONTANT_HT", "MONTANT_TVA", "NUMERO", "ID_SAISIE_VENTE_FACTURE", "ID_MODE_REGLEMENT", "PORT_HT", "REMISE_HT", "MONTANT_SERVICE", "ID_MOUVEMENT", "SOLDE", "A_DEDUIRE", "ENVOYE_EN_AFFACTURAGE", "DATE_ENVOI_AFFACTURAGE", "AFFACTURAGE", "MONTANT_SOLDE", "MONTANT_RESTANT", "COMPTE_SERVICE_AUTO", "ID_CONTACT", "ID_COMPTE_PCE_SERVICE", "MOTIF", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "ID_ADRESSE", "ID_COMMERCIAL", "AFFACTURE", "T_DEVISE", "T_POIDS", "ID_TARIF", "ID_MODELE") FROM stdin;
1	Indéfini	\N	0	1	0	0.00000000	1	0	0		1	1	0	0	0	1	f	f	f	\N	f	0	0	f	1	1		\N	\N	\N	\N	1	1	f	0	0	1	1
\.


--
-- Data for Name: AVOIR_CLIENT_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "AVOIR_CLIENT_ELEMENT" ("ID", "ID_STYLE", "CODE", "NOM", "PA_HT", "PV_HT", "ID_TAXE", "POIDS", "ARCHIVE", "ORDRE", "QTE", "ID_AVOIR_CLIENT", "SERVICE", "PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_VT_1", "VALEUR_METRIQUE_1", "ID_METRIQUE_1", "PRIX_METRIQUE_HA_2", "PRIX_METRIQUE_VT_2", "VALEUR_METRIQUE_2", "ID_METRIQUE_2", "PRIX_METRIQUE_HA_3", "PRIX_METRIQUE_VT_3", "ID_METRIQUE_3", "VALEUR_METRIQUE_3", "T_PV_HT", "T_PA_HT", "T_PV_TTC", "T_POIDS", "ID_MODE_VENTE_ARTICLE", "OBJET_INSPECTE", "TARIF_Q18_HT", "INFOS_OBJET_INSPECTE", "Q18", "ID_CONTACT", "INDICE_0", "REFERENTIEL_INSPECTION", "CODE_MISSION", "POURCENT_SERVICE", "INDICE_N", "LOCAL_OBJET_INSPECTE", "MONTANT_INITIAL", "SOUS_ACTIVITE", "DATE_FIN", "ACTIVITE", "NOM_MISSION", "DATE", "MONTANT_REVISABLE", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "ACOMPTE", "POURCENT_ACOMPTE", "POURCENT_REMISE", "SITUATION_ADMIN", "QTE_ACHAT", "CODE_DOUANIER", "ID_PAYS", "ID_DEVISE", "PV_U_DEVISE", "PV_T_DEVISE", "TAUX_DEVISE", "DESCRIPTIF", "MARGE_HT", "QTE_UNITAIRE", "ID_UNITE_VENTE", "ID_ARTICLE") FROM stdin;
1	3		Indéfini	0	0	2	0	0	0.00000000	1	1	f	0	0	0	1	0	0	0	1	0	0	1	0	0	0	0	0	5		0		f	1	0				0		0		\N			\N	f	\N	1	1	\N	f	100.00	0.00		1		1	1	0	0	1.00000000		0	1.000000	2	1
\.


--
-- Data for Name: AVOIR_FOURNISSEUR; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "AVOIR_FOURNISSEUR" ("ID", "ORDRE", "ARCHIVE", "ID_FOURNISSEUR", "DATE", "SOLDE", "A_DEDUIRE", "ID_MOUVEMENT", "ID_TAXE", "NUMERO", "ID_MODE_REGLEMENT", "MONTANT_HT", "MONTANT_TVA", "MONTANT_TTC", "NOM", "ID_COMPTE_PCE", "IMMO", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	0.00000000	0	1	\N	f	f	1	1		1	0	0	0		1	f	\N	\N	\N	\N
\.


--
-- Data for Name: AXE_ANALYTIQUE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "AXE_ANALYTIQUE" ("ARCHIVE", "ORDRE", "ID", "NOM", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
0	0.00000000	1	Indéfini	\N	1	1	\N
\.


--
-- Data for Name: BON_DE_LIVRAISON; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "BON_DE_LIVRAISON" ("ARCHIVE", "ORDRE", "ID", "DATE", "ID_SAISIE_VENTE_FACTURE", "NUMERO", "ID_CLIENT", "INFOS", "TOTAL_HT", "TOTAL_TVA", "TOTAL_TTC", "TOTAL_POIDS", "ID_COMMANDE_CLIENT", "NOM", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "SOURCE", "IDSOURCE", "T_DEVISE", "T_POIDS", "ID_TARIF", "ID_MODELE", "DATE_LIVRAISON") FROM stdin;
0	0.00000000	1	2006-01-01	1	 	1	 	0	0	0	0	1		\N	\N	\N	\N		1	0	0	1	1	\N
\.


--
-- Data for Name: BON_DE_LIVRAISON_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "BON_DE_LIVRAISON_ELEMENT" ("ID_SAISIE_VENTE_FACTURE_ELEMENT", "QTE_A_LIVRER", "QTE_LIVREE", "ID", "CODE", "NOM", "PV_HT", "QTE", "ID_TAXE", "POIDS", "ID_BON_DE_LIVRAISON", "ARCHIVE", "ORDRE", "VALEUR_METRIQUE_1", "PRIX_METRIQUE_VT_1", "PRIX_METRIQUE_HA_1", "ID_METRIQUE_1", "VALEUR_METRIQUE_2", "PRIX_METRIQUE_VT_2", "PRIX_METRIQUE_HA_2", "ID_METRIQUE_2", "VALEUR_METRIQUE_3", "PRIX_METRIQUE_HA_3", "PRIX_METRIQUE_VT_3", "ID_METRIQUE_3", "PA_HT", "T_POIDS", "T_PV_HT", "T_PA_HT", "T_PV_TTC", "SERVICE", "ID_STYLE", "T_POIDS_LIVREE", "ID_MODE_VENTE_ARTICLE", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "QTE_ACHAT", "CODE_DOUANIER", "ID_PAYS", "ID_DEVISE", "PV_U_DEVISE", "POURCENT_REMISE", "PV_T_DEVISE", "TAUX_DEVISE", "DESCRIPTIF", "MARGE_HT", "QTE_UNITAIRE", "ID_UNITE_VENTE", "ID_ARTICLE") FROM stdin;
1	0	0	1	 	 	0	0	2	0	1	0	0.00000000	0	0	0	1	0	0	0	1	0	0	0	1	0	0	0	0	0	f	2	0	5	\N	1	1	\N	1		1	1	0	0.00	0	1.00000000		0	1.000000	2	1
\.


--
-- Data for Name: BON_RECEPTION; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "BON_RECEPTION" ("ID", "DATE", "NUMERO", "ID_FOURNISSEUR", "INFOS", "TOTAL_HT", "TOTAL_TTC", "TOTAL_TVA", "TOTAL_POIDS", "NOM", "ARCHIVE", "ORDRE", "ID_COMMANDE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE", "ID_DEVISE", "T_DEVISE") FROM stdin;
1	\N	"	1		0	0	0	0		0	0.00000000	1	\N	\N	\N	\N	1	0
\.


--
-- Data for Name: BON_RECEPTION_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "BON_RECEPTION_ELEMENT" ("ID", "CODE", "NOM", "QTE", "ID_TAXE", "POIDS", "ID_BON_RECEPTION", "ARCHIVE", "ORDRE", "VALEUR_METRIQUE_1", "PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_VT_1", "ID_METRIQUE_1", "VALEUR_METRIQUE_2", "PRIX_METRIQUE_VT_2", "PRIX_METRIQUE_HA_2", "ID_METRIQUE_2", "VALEUR_METRIQUE_3", "PRIX_METRIQUE_VT_3", "PRIX_METRIQUE_HA_3", "ID_METRIQUE_3", "PA_HT", "T_POIDS", "T_PV_HT", "T_PV_TTC", "T_PA_HT", "SERVICE", "ID_STYLE", "PV_HT", "T_PA_TTC", "ID_MODE_VENTE_ARTICLE", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "QTE_ACHAT", "PA_DEVISE", "ID_DEVISE", "PA_DEVISE_T", "QTE_UNITAIRE", "ID_UNITE_VENTE", "ID_ARTICLE") FROM stdin;
1			0	2	0	1	0	0.00000000	0	0	0	1	0	0	0	1	0	0	0	1	0	0	0	0	0	f	2	0	0	5	\N	1	1	\N	1	0	1	0	1.000000	2	1
\.


--
-- Data for Name: CAISSE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CAISSE" ("NOM", "NUMERO", "ARCHIVE", "ORDRE", "ID") FROM stdin;
		0	0.00000000	1
\.


--
-- Data for Name: CHEQUE_AVOIR_CLIENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CHEQUE_AVOIR_CLIENT" ("ID", "ID_CLIENT", "MONTANT", "DECAISSE", "ID_MOUVEMENT", "DATE_AVOIR", "DATE_MIN_DECAISSE", "ARCHIVE", "ORDRE", "DATE_DECAISSE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "DATE", "NUMERO", "ETS", "REG_COMPTA") FROM stdin;
1	1	0	f	1	\N	\N	0	0.00000000	\N	\N	\N	\N	\N	\N			f
\.


--
-- Data for Name: CHEQUE_A_ENCAISSER; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CHEQUE_A_ENCAISSER" ("ID", "ID_CLIENT", "MONTANT", "ENCAISSE", "ID_MOUVEMENT", "ARCHIVE", "ORDRE", "DATE_MIN_DEPOT", "DATE_VENTE", "DATE_DEPOT", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "DATE", "NUMERO", "ETS", "REG_COMPTA") FROM stdin;
1	1	0	f	1	0	0.00000000	2006-01-01	2006-01-01	2006-01-01	\N	\N	\N	\N	\N			f
\.


--
-- Data for Name: CHEQUE_FOURNISSEUR; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CHEQUE_FOURNISSEUR" ("ARCHIVE", "ORDRE", "ID", "ID_FOURNISSEUR", "MONTANT", "DECAISSE", "ID_MOUVEMENT", "DATE_ACHAT", "DATE_MIN_DECAISSE", "DATE_DECAISSE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE", "DATE", "NUMERO", "ETS", "REG_COMPTA") FROM stdin;
0	0.00000000	1	1	0	f	1	\N	\N	\N	\N	\N	\N	\N	\N			f
\.


--
-- Data for Name: CLASSEMENT_CONVENTIONNEL; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CLASSEMENT_CONVENTIONNEL" ("ID", "NIVEAU", "COEFF", "INDICE", "POSITION", "ECHELON", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	Indéfini	Indéfini	Indéfini	Indéfini	Indéfini	0	1.00000000	\N	1	1	\N
\.


--
-- Data for Name: CLASSE_COMPTE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CLASSE_COMPTE" ("ID", "NOM", "TYPE_NUMERO_COMPTE", "ORDRE", "ARCHIVE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	Indéfini	 	\N	0	1	\N	1	\N
2	1 - Capitaux	^1.*$	\N	0	1	\N	1	\N
3	2 - Immobilisations	^2.*$	\N	0	1	\N	1	\N
4	3 - Stocks	^3.*$	\N	0	1	\N	1	\N
5	42-49 - Autres Tiers	^4$|^4[^0-1].*$	\N	0	1	\N	1	\N
6	5 - Financier	^5.*$	\N	0	1	\N	1	\N
7	6 - Charges	^6.*$	\N	0	1	\N	1	\N
8	7 - Produits	^7.*$	\N	0	1	\N	1	\N
9	41 - Clients	^4$|^41.*$	\N	0	1	\N	1	\N
10	40 - Fournisseurs	^4$|^40.*$	\N	0	1	\N	1	\N
11	8 - Comptes spéciaux	^8.*$	\N	0	1	\N	1	\N
\.


--
-- Data for Name: CLIENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CLIENT" ("ID", "FORME_JURIDIQUE", "NOM", "CODE", "TEL", "MAIL", "FAX", "NUMERO_TVA", "ID_ADRESSE", "ARCHIVE", "ORDRE", "RESPONSABLE", "ID_ADRESSE_L", "INFOS", "TEL_P", "RESPONSABLE_TECH", "TEL_P_TECH", "TEL_TECH", "MAIL_TECH", "RESPONSABLE_COM", "TEL_P_COM", "MAIL_COM", "TEL_COM", "ID_MODE_REGLEMENT", "ID_ADRESSE_F", "FAX_TECH", "FAX_COM", "ID_COMPTE_PCE", "SIRET", "RIB", "MARCHE_PUBLIC", "MARCHE_PRIVE", "AFFACTURAGE", "MAX_FACTURE", "COMPTANT", "COMPTE_CLIENT_AUTO", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "ID_TARIF", "ID_PAYS", "ID_LANGUE", "ID_DEVISE") FROM stdin;
1	 	 	 	 	 	 	 	1	0	0.00000000	 	1	 										1	1			1			f	f	f	0	f	f	\N	\N	\N	\N	1	1	1	1
\.


--
-- Data for Name: CODE_CARACT_ACTIVITE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_CARACT_ACTIVITE" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	 	Indéfini	0	0.00000000	\N	1	1	\N
3	02	temps partiel	0	1.00000000	\N	1	1	\N
4	04	intermittent	0	2.00000000	\N	1	1	\N
5	05	domicile	0	3.00000000	\N	1	1	\N
6	06	saisonnier	0	4.00000000	\N	1	1	\N
2	01	temps plein	0	5.00000000	\N	1	1	\N
8	08	occasionnel	0	6.00000000	\N	1	1	\N
9	09	temps non complet (réservé secteur public)	0	7.00000000	\N	1	1	\N
10	10	forfait jour	0	8.00000000	\N	1	1	\N
11	90	sans complément de contrat	0	9.00000000	\N	1	1	\N
7	07	vacataire	0	10.00000000	\N	1	1	\N
\.


--
-- Data for Name: CODE_CONTRAT_TRAVAIL; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_CONTRAT_TRAVAIL" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	 	Indéfini	0	0.00000000	1	\N	1	\N
3	02	contrat à durée déterminée	0	1.00000000	1	\N	1	\N
4	03	contrat de travail temporaire (mission)	0	2.00000000	1	\N	1	\N
7	06	contrat emploi jeunes	0	5.00000000	1	\N	1	\N
2	01	contrat à durée indéterminée	0	6.00000000	1	\N	1	\N
9	08	assistant d'éducation (IRCANTEC)	0	7.00000000	1	\N	1	\N
10	20	mandat électif (IRCANTEC)	0	8.00000000	1	\N	1	\N
11	21	arrêté de nomination (médecin) (IRCANTEC)	0	9.00000000	1	\N	1	\N
12	22	arrêté municipal (IRCANTEC)	0	10.00000000	1	\N	1	\N
13	90	sans contrat	0	11.00000000	1	\N	1	\N
8	07	contrat emploi solidarité	0	12.00000000	1	\N	1	\N
5	04	contrat d'apprentissage entreprises artisanales ou de 10 salariés au plus 	0	3.00000000	1	\N	1	\N
6	05	contrat d'apprentissage entreprises non artisanales de plus de 10 salariés	0	4.00000000	1	\N	1	\N
\.


--
-- Data for Name: CODE_DROIT_CONTRAT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_DROIT_CONTRAT" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	 	Indéfini	0	0.00000000	1	\N	1	\N
2	01	contrat de droit privé	0	1.00000000	1	\N	1	\N
3	02	pas de contrat de travail de droit privé	0	2.00000000	1	\N	1	\N
\.


--
-- Data for Name: CODE_EMPLOI; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_EMPLOI" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
840	521a	Employés de la Poste	0	217.00000000	\N	1	1	\N
886	553c	Autres vendeurs non spécialisés	0	263.00000000	\N	1	1	\N
627	231a	Chefs de grande entreprise de 500 salariés et plus	0	4.00000000	\N	1	1	\N
628	232a	Chefs de moyenne entreprise, de 50 à 499 salariés	0	5.00000000	\N	1	1	\N
629	233a	Chefs d'entreprise du bâtiment et des travaux publics, de 10 à 49 salariés	0	6.00000000	\N	1	1	\N
630	233b	Chefs d'entreprise de l'industrie ou des transports, de 10 à 49 salariés	0	7.00000000	\N	1	1	\N
631	233c	Chefs d'entreprise commerciale, de 10 à 49 salariés	0	8.00000000	\N	1	1	\N
632	233d	Chefs d'entreprise de services, de 10 à 49 salariés	0	9.00000000	\N	1	1	\N
633	311c	Chirurgiens dentistes	0	10.00000000	\N	1	1	\N
634	311d	Psychologues, psychanalystes, psychothérapeutes (non médecins)	0	11.00000000	\N	1	1	\N
635	311e	Vétérinaires	0	12.00000000	\N	1	1	\N
636	312a	Avocats	0	13.00000000	\N	1	1	\N
637	331a	Personnels de direction de la fonction publique (Etat, collectivités locales, hôpitaux)	0	14.00000000	\N	1	1	\N
638	332a	Ingénieurs de l'Etat et assimilés	0	15.00000000	\N	1	1	\N
639	332b	Ingénieurs des collectivités locales et des hôpitaux	0	16.00000000	\N	1	1	\N
640	333c	Cadres de la Poste	0	17.00000000	\N	1	1	\N
641	333d	Cadres administratifs de France Télécom (statut public)	0	18.00000000	\N	1	1	\N
642	333e	Autres personnels administratifs de catégorie A de l'Etat et assimilés (hors Enseignement, Patrimoine)	0	19.00000000	\N	1	1	\N
643	333f	Personnel administratif de catégorie A des collectivités locales et hôpitaux publics (hors Enseignement, Patrimoine)	0	20.00000000	\N	1	1	\N
644	341a	Professeurs agrégés et certifiés de l'enseignement secondaire	0	21.00000000	\N	1	1	\N
645	341b	Chefs d'établissement de l'enseignement secondaire et inspecteurs	0	22.00000000	\N	1	1	\N
646	342b	Professeurs et maîtres de conférences	0	23.00000000	\N	1	1	\N
647	342c	Professeurs agrégés et certifiés en fonction dans l'enseignement supérieur	0	24.00000000	\N	1	1	\N
648	342d	Personnel enseignant temporaire de l'enseignement supérieur	0	25.00000000	\N	1	1	\N
649	342f	Directeurs et chargés de recherche de la recherche publique	0	26.00000000	\N	1	1	\N
650	342g	Ingénieurs d'étude et de recherche de la recherche publique	0	27.00000000	\N	1	1	\N
651	342h	Allocataires de la recherche publique	0	28.00000000	\N	1	1	\N
652	343a	Psychologues spécialistes de l'orientation scolaire et professionnelle	0	29.00000000	\N	1	1	\N
653	344a	Médecins hospitaliers sans activité libérale	0	30.00000000	\N	1	1	\N
654	344b	Médecins salariés non hospitaliers	0	31.00000000	\N	1	1	\N
655	344c	Internes en médecine, odontologie et pharmacie	0	32.00000000	\N	1	1	\N
656	344d	Pharmaciens salariés	0	33.00000000	\N	1	1	\N
657	351a	Bibliothécaires, archivistes, conservateurs et autres cadres du patrimoine	0	34.00000000	\N	1	1	\N
658	352a	Journalistes (y c. rédacteurs en chef)	0	35.00000000	\N	1	1	\N
659	352b	Auteurs littéraires, scénaristes, dialoguistes	0	36.00000000	\N	1	1	\N
660	353a	Directeurs de journaux, administrateurs de presse, directeurs d'éditions (littéraire, musicale, audiovisuelle et multimédia)	0	37.00000000	\N	1	1	\N
661	353b	Directeurs, responsables de programmation et de production de l'audiovisuel et des spectacles	0	38.00000000	\N	1	1	\N
662	353c	Cadres artistiques et technico-artistiques de la réalisation de l'audiovisuel et des spectacles	0	39.00000000	\N	1	1	\N
663	354a	Artistes plasticiens	0	40.00000000	\N	1	1	\N
664	354b	Artistes de la musique et du chant	0	41.00000000	\N	1	1	\N
665	354c	Artistes dramatiques	0	42.00000000	\N	1	1	\N
666	354e	Artistes de la danse	0	43.00000000	\N	1	1	\N
667	354f	Artistes du cirque et des spectacles divers	0	44.00000000	\N	1	1	\N
668	354g	Professeurs d'art (hors établissements scolaires)	0	45.00000000	\N	1	1	\N
669	371a	Cadres d'état-major administratifs, financiers, commerciaux des grandes entreprises	0	46.00000000	\N	1	1	\N
670	372a	Cadres chargés d'études économiques, financières, commerciales	0	47.00000000	\N	1	1	\N
671	372b	Cadres de l'organisation ou du contrôle des services administratifs et financiers	0	48.00000000	\N	1	1	\N
672	372c	Cadres spécialistes des ressources humaines et du recrutement	0	49.00000000	\N	1	1	\N
673	372d	Cadres spécialistes de la formation	0	50.00000000	\N	1	1	\N
675	372f	Cadres de la documentation, de l'archivage (hors fonction publique)	0	52.00000000	\N	1	1	\N
676	373a	Cadres des services financiers ou comptables des grandes entreprises	0	53.00000000	\N	1	1	\N
677	373b	Cadres des autres services administratifs des grandes entreprises	0	54.00000000	\N	1	1	\N
678	373c	Cadres des services financiers ou comptables des petites et moyennes entreprises	0	55.00000000	\N	1	1	\N
679	373d	Cadres des autres services administratifs des petites et moyennes entreprises	0	56.00000000	\N	1	1	\N
680	374a	Cadres de l'exploitation des magasins de vente du commerce de détail	0	57.00000000	\N	1	1	\N
681	374b	Chefs de produits, acheteurs du commerce et autres cadres de la mercatique	0	58.00000000	\N	1	1	\N
682	374c	Cadres commerciaux des grandes entreprises (hors commerce de détail)	0	59.00000000	\N	1	1	\N
683	374d	Cadres commerciaux des petites et moyennes entreprises (hors commerce de détail)	0	60.00000000	\N	1	1	\N
684	375a	Cadres de la publicité	0	61.00000000	\N	1	1	\N
685	375b	Cadres des relations publiques et de la communication	0	62.00000000	\N	1	1	\N
686	376a	Cadres des marchés financiers	0	63.00000000	\N	1	1	\N
687	376b	Cadres des opérations bancaires	0	64.00000000	\N	1	1	\N
688	376c	Cadres commerciaux de la banque	0	65.00000000	\N	1	1	\N
689	376d	Chefs d'établissements et responsables de l'exploitation bancaire	0	66.00000000	\N	1	1	\N
690	376e	Cadres des services techniques des assurances	0	67.00000000	\N	1	1	\N
691	376f	Cadres des services techniques des organismes de sécurité sociale et assimilés	0	68.00000000	\N	1	1	\N
692	376g	Cadres de l'immobilier	0	69.00000000	\N	1	1	\N
693	377a	Cadres de l'hôtellerie et de la restauration	0	70.00000000	\N	1	1	\N
694	380a	Directeurs techniques des grandes entreprises	0	71.00000000	\N	1	1	\N
695	381b	Ingénieurs et cadres d'étude et développement de l'agriculture, la pêche, les eaux et forêts	0	72.00000000	\N	1	1	\N
696	381c	Ingénieurs et cadres de production et d'exploitation de l'agriculture, la pêche, les eaux et forêts	0	73.00000000	\N	1	1	\N
674	372e	Juristes	0	51.00000000	\N	1	1	\N
697	382a	Ingénieurs et cadres d'étude du bâtiment et des travaux publics	0	74.00000000	\N	1	1	\N
698	382b	Architectes salariés	0	75.00000000	\N	1	1	\N
699	382c	Ingénieurs, cadres de chantier et conducteurs de travaux (cadres) du bâtiment et des travaux publics	0	76.00000000	\N	1	1	\N
700	382d	Ingénieurs et cadres technico-commerciaux en bâtiment, travaux publics	0	77.00000000	\N	1	1	\N
701	383a	Ingénieurs et cadres d'étude, recherche et développement en électricité, électronique	0	78.00000000	\N	1	1	\N
702	383b	Ingénieurs et cadres de fabrication en matériel électrique, électronique	0	79.00000000	\N	1	1	\N
703	383c	Ingénieurs et cadres technico-commerciaux en matériel électrique ou électronique professionnel	0	80.00000000	\N	1	1	\N
704	384a	Ingénieurs et cadres d'étude, recherche et développement en mécanique et travail des métaux	0	81.00000000	\N	1	1	\N
705	384b	Ingénieurs et cadres de fabrication en mécanique et travail des métaux	0	82.00000000	\N	1	1	\N
706	384c	Ingénieurs et cadres technico-commerciaux en matériel mécanique professionnel	0	83.00000000	\N	1	1	\N
707	385a	Ingénieurs et cadres d'étude, recherche et développement des industries de transformation (agroalimentaire, chimie, métallurgie, matériaux lourds)	0	84.00000000	\N	1	1	\N
708	385b	Ingénieurs et cadres de fabrication des industries de transformation (agroalimentaire, chimie, métallurgie, matériaux lourds)	0	85.00000000	\N	1	1	\N
709	385c	Ingénieurs et cadres technico-commerciaux des industries de transformations (biens intermédiaires)	0	86.00000000	\N	1	1	\N
710	386b	Ingénieurs et cadres d'étude, recherche et développement de la distribution d'énergie, eau	0	87.00000000	\N	1	1	\N
711	386c	Ingénieurs et cadres d'étude, recherche et développement des autres industries  (imprimerie, matériaux souples, ameublement et bois)	0	88.00000000	\N	1	1	\N
712	386d	Ingénieurs et cadres de la production et de la distribution d'énergie, eau	0	89.00000000	\N	1	1	\N
713	386e	Ingénieurs et cadres de fabrication des autres industries (imprimerie, matériaux souples, ameublement et bois)	0	90.00000000	\N	1	1	\N
714	387a	Ingénieurs et cadres des achats et approvisionnements industriels	0	91.00000000	\N	1	1	\N
715	387b	Ingénieurs et cadres de la logistique, du planning et de l'ordonnancement	0	92.00000000	\N	1	1	\N
716	387c	Ingénieurs et cadres des méthodes de production	0	93.00000000	\N	1	1	\N
717	387d	Ingénieurs et cadres du contrôle-qualité	0	94.00000000	\N	1	1	\N
718	387e	Ingénieurs et cadres de la maintenance, de l'entretien et des travaux neufs	0	95.00000000	\N	1	1	\N
719	387f	Ingénieurs et cadres techniques de l'environnement	0	96.00000000	\N	1	1	\N
720	388a	Ingénieurs et cadres d'étude, recherche et développement en informatique	0	97.00000000	\N	1	1	\N
721	388b	Ingénieurs et cadres d'administration, maintenance, support et services aux utilisateurs en informatique	0	98.00000000	\N	1	1	\N
722	388c	Chefs de projets informatiques, responsables informatiques	0	99.00000000	\N	1	1	\N
723	388d	Ingénieurs et cadres technico-commerciaux en informatique et télécommunications	0	100.00000000	\N	1	1	\N
724	388e	Ingénieurs et cadres spécialistes des télécommunications	0	101.00000000	\N	1	1	\N
725	389a	Ingénieurs et cadres techniques de l'exploitation des transports	0	102.00000000	\N	1	1	\N
726	389b	Officiers et cadres navigants techniques et commerciaux de l'aviation civile	0	103.00000000	\N	1	1	\N
727	389c	Officiers et cadres navigants techniques de la marine marchande	0	104.00000000	\N	1	1	\N
728	421a	Instituteurs	0	105.00000000	\N	1	1	\N
730	422a	Professeurs d'enseignement général des collèges	0	107.00000000	\N	1	1	\N
731	422b	Professeurs de lycée professionnel	0	108.00000000	\N	1	1	\N
732	422c	Maîtres auxiliaires et professeurs contractuels de l'enseignement secondaire	0	109.00000000	\N	1	1	\N
733	422d	Conseillers principaux d'éducation	0	110.00000000	\N	1	1	\N
734	422e	Surveillants et aides-éducateurs des établissements d'enseignement	0	111.00000000	\N	1	1	\N
735	423a	Moniteurs d'école de conduite	0	112.00000000	\N	1	1	\N
736	423b	Formateurs et animateurs de formation continue	0	113.00000000	\N	1	1	\N
737	424a	Moniteurs et éducateurs sportifs, sportifs professionnels	0	114.00000000	\N	1	1	\N
738	425a	Sous-bibliothécaires, cadres intermédiaires du patrimoine	0	115.00000000	\N	1	1	\N
739	431a	Cadres infirmiers et assimilés	0	116.00000000	\N	1	1	\N
740	431b	Infirmiers psychiatriques	0	117.00000000	\N	1	1	\N
741	431c	Puéricultrices	0	118.00000000	\N	1	1	\N
742	431d	Infirmiers spécialisés (autres qu'infirmiers psychiatriques et puéricultrices)	0	119.00000000	\N	1	1	\N
743	431e	Sages-femmes	0	120.00000000	\N	1	1	\N
744	431f	Infirmiers en soins généraux	0	121.00000000	\N	1	1	\N
745	432b	Masseurs-kinésithérapeutes rééducateurs	0	122.00000000	\N	1	1	\N
746	432d	Autres spécialistes de la rééducation	0	123.00000000	\N	1	1	\N
747	433a	Techniciens médicaux	0	124.00000000	\N	1	1	\N
748	433b	Opticiens lunetiers et audioprothésistes	0	125.00000000	\N	1	1	\N
749	433c	Autres spécialistes de l'appareillage médical	0	126.00000000	\N	1	1	\N
750	433d	Préparateurs en pharmacie	0	127.00000000	\N	1	1	\N
751	434a	Cadres de l'intervention socio-éducative	0	128.00000000	\N	1	1	\N
752	434b	Assistants de service social	0	129.00000000	\N	1	1	\N
753	434c	Conseillers en économie sociale familiale	0	130.00000000	\N	1	1	\N
754	434d	Educateurs spécialisés	0	131.00000000	\N	1	1	\N
755	434e	Moniteurs éducateurs	0	132.00000000	\N	1	1	\N
756	434f	Educateurs techniques spécialisés, moniteurs d'atelier	0	133.00000000	\N	1	1	\N
757	434g	Educateurs de jeunes enfants	0	134.00000000	\N	1	1	\N
758	435a	Directeurs de centres socioculturels et de loisirs	0	135.00000000	\N	1	1	\N
759	435b	Animateurs socioculturels et de loisirs	0	136.00000000	\N	1	1	\N
760	441a	Clergé séculier	0	137.00000000	\N	1	1	\N
761	441b	Clergé régulier	0	138.00000000	\N	1	1	\N
729	421b	Professeurs des écoles	0	106.00000000	\N	1	1	\N
762	451a	Professions intermédiaires de la Poste	0	139.00000000	\N	1	1	\N
763	451b	Professions intermédiaires administratives de France Télécom (statut public)	0	140.00000000	\N	1	1	\N
764	451e	Autres personnels administratifs de catégorie B de l'Etat et assimilés (hors Enseignement, Patrimoine)	0	141.00000000	\N	1	1	\N
765	451g	Professions intermédiaires administratives des collectivités locales	0	142.00000000	\N	1	1	\N
766	451h	Professions intermédiaires administratives des hôpitaux	0	143.00000000	\N	1	1	\N
767	461b	Secrétaires de direction, assistants de direction (non cadres)	0	144.00000000	\N	1	1	\N
768	461c	Secrétaires de niveau supérieur (non cadres, hors secrétaires de direction)	0	145.00000000	\N	1	1	\N
769	461d	Maîtrise et techniciens des services financiers ou comptables	0	146.00000000	\N	1	1	\N
770	461e	Maîtrise et techniciens administratifs des services juridiques ou du personnel	0	147.00000000	\N	1	1	\N
771	461f	Maîtrise et techniciens administratifs des autres services administratifs	0	148.00000000	\N	1	1	\N
772	462a	Chefs de petites surfaces de vente	0	149.00000000	\N	1	1	\N
773	462b	Maîtrise de l'exploitation des magasins de vente	0	150.00000000	\N	1	1	\N
774	462c	Acheteurs non classés cadres, aides-acheteurs	0	151.00000000	\N	1	1	\N
775	462d	Animateurs commerciaux des magasins de vente, marchandiseurs (non cadres)	0	152.00000000	\N	1	1	\N
776	462e	Autres professions intermédiaires commerciales (sauf techniciens des forces de vente)	0	153.00000000	\N	1	1	\N
777	463a	Techniciens commerciaux et technico-commerciaux, représentants en informatique	0	154.00000000	\N	1	1	\N
778	463b	Techniciens commerciaux et technico-commerciaux, représentants en biens d'équipement, en biens intermédiaires, commerce interindustriel (hors informatique)	0	155.00000000	\N	1	1	\N
779	463c	Techniciens commerciaux et technico-commerciaux, représentants en biens de consommation auprès d'entreprises	0	156.00000000	\N	1	1	\N
780	463d	Techniciens commerciaux et technico-commerciaux, représentants en services auprès d'entreprises ou de professionnels (hors banque, assurance, informatique)	0	157.00000000	\N	1	1	\N
781	463e	Techniciens commerciaux et technico-commerciaux, représentants auprès de particuliers (hors banque, assurance, informatique)	0	158.00000000	\N	1	1	\N
782	464a	Assistants de la publicité, des relations publiques	0	159.00000000	\N	1	1	\N
783	464b	Interprètes, traducteurs	0	160.00000000	\N	1	1	\N
784	465a	Concepteurs et assistants techniques des arts graphiques, de la mode et de la décoration	0	161.00000000	\N	1	1	\N
785	465b	Assistants techniques de la réalisation des spectacles vivants et audiovisuels	0	162.00000000	\N	1	1	\N
786	465c	Photographes	0	163.00000000	\N	1	1	\N
787	466a	Responsables commerciaux et administratifs des transports de voyageurs et du tourisme (non cadres)	0	164.00000000	\N	1	1	\N
788	466b	Responsables commerciaux et administratifs des transports de marchandises (non cadres)	0	165.00000000	\N	1	1	\N
789	466c	Responsables d'exploitation des transports de voyageurs et de marchandises (non cadres)	0	166.00000000	\N	1	1	\N
790	467a	Chargés de clientèle bancaire	0	167.00000000	\N	1	1	\N
791	467b	Techniciens des opérations bancaires	0	168.00000000	\N	1	1	\N
792	467c	Professions intermédiaires techniques et commerciales des assurances	0	169.00000000	\N	1	1	\N
793	467d	Professions intermédiaires techniques des organismes de sécurité sociale	0	170.00000000	\N	1	1	\N
794	468a	Maîtrise de restauration : salle et service	0	171.00000000	\N	1	1	\N
795	468b	Maîtrise de l'hébergement : hall et étages	0	172.00000000	\N	1	1	\N
796	471a	Techniciens d'étude et de conseil en agriculture, eaux et forêts	0	173.00000000	\N	1	1	\N
797	471b	Techniciens d'exploitation et de contrôle de la production en agriculture, eaux et forêts	0	174.00000000	\N	1	1	\N
798	472a	Dessinateurs en bâtiment, travaux publics	0	175.00000000	\N	1	1	\N
799	472b	Géomètres, topographes	0	176.00000000	\N	1	1	\N
800	472c	Métreurs et techniciens divers du bâtiment et des travaux publics	0	177.00000000	\N	1	1	\N
801	472d	Techniciens des travaux publics de l'Etat et des collectivités locales	0	178.00000000	\N	1	1	\N
802	473a	Dessinateurs en électricité, électromécanique et électronique	0	179.00000000	\N	1	1	\N
803	473b	Techniciens de recherche-développement et des méthodes de fabrication en électricité, électromécanique et électronique	0	180.00000000	\N	1	1	\N
804	473c	Techniciens de fabrication et de contrôle-qualité en électricité, électromécanique et électronique	0	181.00000000	\N	1	1	\N
805	474a	Dessinateurs en construction mécanique et travail des métaux	0	182.00000000	\N	1	1	\N
806	474b	Techniciens de recherche-développement et des méthodes de fabrication en construction mécanique et travail des métaux	0	183.00000000	\N	1	1	\N
807	474c	Techniciens de fabrication et de contrôle-qualité en construction mécanique et travail des métaux	0	184.00000000	\N	1	1	\N
808	475a	Techniciens de recherche-développement et des méthodes de production des industries de transformation	0	185.00000000	\N	1	1	\N
809	475b	Techniciens de production et de contrôle-qualité des industries de transformation	0	186.00000000	\N	1	1	\N
810	476a	Assistants techniques, techniciens de l'imprimerie et de l'édition	0	187.00000000	\N	1	1	\N
811	476b	Techniciens de l'industrie des matériaux souples, de l'ameublement et du bois	0	188.00000000	\N	1	1	\N
812	477a	Techniciens de la logistique, du planning et de l'ordonnancement	0	189.00000000	\N	1	1	\N
813	477b	Techniciens d'installation et de maintenance des équipements industriels (électriques, électromécaniques, mécaniques, hors informatique)	0	190.00000000	\N	1	1	\N
814	477c	Techniciens d'installation et de maintenance des équipements non industriels (hors informatique et télécommunications)	0	191.00000000	\N	1	1	\N
815	477d	Techniciens de l'environnement et du traitement des pollutions	0	192.00000000	\N	1	1	\N
816	478a	Techniciens d'étude et de développement en informatique	0	193.00000000	\N	1	1	\N
817	478b	Techniciens de production, d'exploitation en informatique	0	194.00000000	\N	1	1	\N
818	478c	Techniciens d'installation, de maintenance, support et services aux utilisateurs en informatique	0	195.00000000	\N	1	1	\N
819	478d	Techniciens des télécommunications et de l'informatique des réseaux	0	196.00000000	\N	1	1	\N
820	479a	Techniciens des laboratoires de recherche publique ou de l'enseignement	0	197.00000000	\N	1	1	\N
821	479b	Experts de niveau technicien, techniciens divers	0	198.00000000	\N	1	1	\N
822	480a	Contremaîtres et agents d'encadrement (non cadres) en agriculture, sylviculture	0	199.00000000	\N	1	1	\N
823	480b	Maîtres d'équipage de la marine marchande et de la pêche	0	200.00000000	\N	1	1	\N
824	481a	Conducteurs de travaux (non cadres)	0	201.00000000	\N	1	1	\N
825	481b	Chefs de chantier (non cadres)	0	202.00000000	\N	1	1	\N
826	482a	Agents de maîtrise en fabrication de matériel électrique, électronique	0	203.00000000	\N	1	1	\N
827	483a	Agents de maîtrise en construction mécanique, travail des métaux	0	204.00000000	\N	1	1	\N
828	484a	Agents de maîtrise en fabrication : agroalimentaire, chimie, plasturgie, pharmacie.	0	205.00000000	\N	1	1	\N
829	484b	Agents de maîtrise en fabrication : métallurgie, matériaux lourds et autres industries de transformation	0	206.00000000	\N	1	1	\N
830	485a	Agents de maîtrise et techniciens en production et distribution d'énergie, eau, chauffage	0	207.00000000	\N	1	1	\N
831	485b	Agents de maîtrise en fabrication des autres industries (imprimerie, matériaux souples, ameublement et bois)	0	208.00000000	\N	1	1	\N
832	486b	Agents de maîtrise en maintenance, installation en électricité et électronique	0	209.00000000	\N	1	1	\N
833	486c	Agents de maîtrise en maintenance, installation en électromécanique	0	210.00000000	\N	1	1	\N
834	486d	Agents de maîtrise en maintenance, installation en mécanique	0	211.00000000	\N	1	1	\N
835	486e	Agents de maîtrise en entretien général, installation, travaux neufs (hors mécanique, électromécanique, électronique)	0	212.00000000	\N	1	1	\N
836	487a	Responsables d'entrepôt, de magasinage	0	213.00000000	\N	1	1	\N
837	487b	Responsables du tri, de l'emballage, de l'expédition et autres responsables de la manutention	0	214.00000000	\N	1	1	\N
838	488a	Maîtrise de restauration  : cuisine/production	0	215.00000000	\N	1	1	\N
839	488b	Maîtrise de restauration  : gestion d'établissement	0	216.00000000	\N	1	1	\N
841	521b	Employés de France Télécom (statut public)	0	218.00000000	\N	1	1	\N
842	523b	Adjoints administratifs de l'Etat et assimilés (sauf Poste, France Télécom)	0	219.00000000	\N	1	1	\N
843	523c	Adjoints administratifs des collectivités locales	0	220.00000000	\N	1	1	\N
845	524b	Agents administratifs de l'Etat et assimilés (sauf Poste, France Télécom)	0	222.00000000	\N	1	1	\N
846	524c	Agents administratifs des collectivités locales	0	223.00000000	\N	1	1	\N
847	524d	Agents administratifs des hôpitaux publics	0	224.00000000	\N	1	1	\N
848	525a	Agents de service des établissements primaires	0	225.00000000	\N	1	1	\N
849	525b	Agents de service des autres établissements d'enseignement	0	226.00000000	\N	1	1	\N
850	525c	Agents de service de la fonction publique (sauf écoles, hôpitaux)	0	227.00000000	\N	1	1	\N
851	525d	Agents de service hospitaliers	0	228.00000000	\N	1	1	\N
852	526a	Aides-soignants	0	229.00000000	\N	1	1	\N
853	526b	Assistants dentaires, médicaux et vétérinaires, aides de techniciens médicaux	0	230.00000000	\N	1	1	\N
854	526c	Auxiliaires de puériculture	0	231.00000000	\N	1	1	\N
855	526d	Aides médico-psychologiques	0	232.00000000	\N	1	1	\N
856	526e	Ambulanciers	0	233.00000000	\N	1	1	\N
857	533a	Pompiers	0	234.00000000	\N	1	1	\N
858	533b	Agents techniques forestiers, gardes des espaces naturels	0	235.00000000	\N	1	1	\N
859	533c	Agents de surveillance du patrimoine et des administrations	0	236.00000000	\N	1	1	\N
860	534a	Agents civils de sécurité et de surveillance	0	237.00000000	\N	1	1	\N
861	534b	Convoyeurs de fonds, gardes du corps, enquêteurs privés et métiers assimilés	0	238.00000000	\N	1	1	\N
862	541b	Agents d'accueil qualifiés, hôtesses d'accueil et d'information	0	239.00000000	\N	1	1	\N
863	541c	Agents d'accueil non qualifiés	0	240.00000000	\N	1	1	\N
864	541d	Standardistes, téléphonistes	0	241.00000000	\N	1	1	\N
865	542a	Secrétaires	0	242.00000000	\N	1	1	\N
866	542b	Dactylos, sténodactylos (sans secrétariat), opérateurs de traitement de texte	0	243.00000000	\N	1	1	\N
867	543b	Employés qualifiés des services comptables ou financiers	0	244.00000000	\N	1	1	\N
868	543c	Employés non qualifiés des services comptables ou financiers	0	245.00000000	\N	1	1	\N
869	543e	Employés qualifiés des services du personnel et des services juridiques	0	246.00000000	\N	1	1	\N
870	543f	Employés qualifiés des services commerciaux des entreprises (hors vente)	0	247.00000000	\N	1	1	\N
871	543g	Employés administratifs qualifiés des autres services des entreprises	0	248.00000000	\N	1	1	\N
872	543h	Employés administratifs non qualifiés	0	249.00000000	\N	1	1	\N
873	544a	Employés et opérateurs d'exploitation en informatique	0	250.00000000	\N	1	1	\N
874	545a	Employés administratifs des services techniques de la banque	0	251.00000000	\N	1	1	\N
875	545b	Employés des services commerciaux de la banque	0	252.00000000	\N	1	1	\N
876	545c	Employés des services techniques des assurances	0	253.00000000	\N	1	1	\N
877	545d	Employés des services techniques des organismes de sécurité sociale et assimilés	0	254.00000000	\N	1	1	\N
878	546a	Contrôleurs des transports (personnels roulants)	0	255.00000000	\N	1	1	\N
879	546b	Agents des services commerciaux des transports de voyageurs et du tourisme	0	256.00000000	\N	1	1	\N
880	546c	Employés administratifs d'exploitation des transports de marchandises	0	257.00000000	\N	1	1	\N
881	546d	Hôtesses de l'air et stewards	0	258.00000000	\N	1	1	\N
882	546e	Autres agents et hôtesses d'accompagnement (transports, tourisme)	0	259.00000000	\N	1	1	\N
883	551a	Employés de libre service du commerce et magasiniers	0	260.00000000	\N	1	1	\N
884	552a	Caissiers de magasin	0	261.00000000	\N	1	1	\N
844	523d	Adjoints administratifs des hôpitaux publics	0	221.00000000	\N	1	1	\N
885	553b	Vendeurs polyvalents des grands magasins	0	262.00000000	\N	1	1	\N
887	554a	Vendeurs en alimentation	0	264.00000000	\N	1	1	\N
888	554b	Vendeurs en ameublement, décor, équipement du foyer	0	265.00000000	\N	1	1	\N
889	554c	Vendeurs en droguerie, bazar, quincaillerie, bricolage	0	266.00000000	\N	1	1	\N
890	554d	Vendeurs du commerce de fleurs	0	267.00000000	\N	1	1	\N
891	554e	Vendeurs en habillement et articles de sport	0	268.00000000	\N	1	1	\N
892	554f	Vendeurs en produits de beauté, de luxe (hors biens culturels) et optique	0	269.00000000	\N	1	1	\N
893	554g	Vendeurs de biens culturels (livres, disques, multimédia, objets d'art)	0	270.00000000	\N	1	1	\N
894	554h	Vendeurs de tabac, presse et articles divers	0	271.00000000	\N	1	1	\N
895	554j	Pompistes et gérants de station-service (salariés ou mandataires)	0	272.00000000	\N	1	1	\N
896	555a	Vendeurs par correspondance, télévendeurs	0	273.00000000	\N	1	1	\N
897	556a	Vendeurs en gros de biens d'équipement, biens intermédiaires	0	274.00000000	\N	1	1	\N
898	561b	Serveurs, commis de restaurant, garçons qualifiés	0	275.00000000	\N	1	1	\N
899	561c	Serveurs, commis de restaurant, garçons non qualifiés	0	276.00000000	\N	1	1	\N
900	561d	Aides de cuisine, apprentis de cuisine et employés polyvalents de la restauration	0	277.00000000	\N	1	1	\N
901	561e	Employés de l'hôtellerie : réception et hall	0	278.00000000	\N	1	1	\N
902	561f	Employés d'étage et employés polyvalents de l'hôtellerie	0	279.00000000	\N	1	1	\N
903	562a	Manucures, esthéticiens	0	280.00000000	\N	1	1	\N
904	562b	Coiffeurs	0	281.00000000	\N	1	1	\N
905	563a	Assistantes maternelles, gardiennes d'enfants, familles d'accueil	0	282.00000000	\N	1	1	\N
906	563b	Aides à domicile, aides ménagères, travailleuses familiales	0	283.00000000	\N	1	1	\N
907	563c	Employés de maison et personnels de ménage chez des particuliers	0	284.00000000	\N	1	1	\N
908	564a	Concierges, gardiens d'immeubles	0	285.00000000	\N	1	1	\N
909	564b	Employés des services divers	0	286.00000000	\N	1	1	\N
910	621a	Chefs d'équipe du gros oeuvre et des travaux publics	0	287.00000000	\N	1	1	\N
911	621b	Ouvriers qualifiés du travail du béton	0	288.00000000	\N	1	1	\N
912	621c	Conducteurs qualifiés d'engins de chantiers du bâtiment et des travaux publics	0	289.00000000	\N	1	1	\N
913	621d	Ouvriers des travaux publics en installations électriques et de télécommunications	0	290.00000000	\N	1	1	\N
914	621e	Autres ouvriers qualifiés des travaux publics	0	291.00000000	\N	1	1	\N
915	621f	Ouvriers qualifiés des travaux publics (salariés de l'Etat et des collectivités locales)	0	292.00000000	\N	1	1	\N
916	621g	Mineurs de fond qualifiés et autres ouvriers qualifiés des industries d'extraction (carrières, pétrole, gaz...)	0	293.00000000	\N	1	1	\N
917	622a	Opérateurs qualifiés sur machines automatiques en production électrique ou électronique	0	294.00000000	\N	1	1	\N
919	622d	Câbleurs qualifiés en électronique (prototype, unité, petite série)	0	296.00000000	\N	1	1	\N
920	622e	Autres monteurs câbleurs en électronique	0	297.00000000	\N	1	1	\N
921	622f	Bobiniers qualifiés	0	298.00000000	\N	1	1	\N
922	622g	Plate-formistes, contrôleurs qualifiés de matériel électrique ou électronique	0	299.00000000	\N	1	1	\N
923	623a	Chaudronniers-tôliers industriels, opérateurs qualifiés du travail en forge, conducteurs qualifiés d'équipement de formage, traceurs qualifiés	0	300.00000000	\N	1	1	\N
924	623b	Tuyauteurs industriels qualifiés	0	301.00000000	\N	1	1	\N
925	623d	Opérateurs qualifiés sur machine de soudage	0	302.00000000	\N	1	1	\N
926	623e	Soudeurs manuels	0	303.00000000	\N	1	1	\N
927	623f	Opérateurs qualifiés d'usinage des métaux travaillant à l'unité ou en petite série, moulistes qualifiés	0	304.00000000	\N	1	1	\N
928	623g	Opérateurs qualifiés d'usinage des métaux sur autres machines (sauf moulistes)	0	305.00000000	\N	1	1	\N
929	624b	Monteurs, metteurs au point très qualifiés d'ensembles mécaniques travaillant à l'unité ou en petite série	0	306.00000000	\N	1	1	\N
930	624c	Monteurs qualifiés d'ensembles mécaniques travaillant en moyenne ou en grande série	0	307.00000000	\N	1	1	\N
931	624d	Monteurs qualifiés en structures métalliques	0	308.00000000	\N	1	1	\N
932	624e	Ouvriers qualifiés de contrôle et d'essais en mécanique	0	309.00000000	\N	1	1	\N
933	624f	Ouvriers qualifiés des traitements thermiques et de surface sur métaux	0	310.00000000	\N	1	1	\N
934	624g	Autres mécaniciens ou ajusteurs qualifiés (ou spécialité non reconnue)	0	311.00000000	\N	1	1	\N
935	625a	Pilotes d'installation lourde des industries de transformation : agroalimentaire, chimie, plasturgie, énergie	0	312.00000000	\N	1	1	\N
936	625b	Ouvriers qualifiés et agents qualifiés de laboratoire : agroalimentaire, chimie, biologie, pharmacie	0	313.00000000	\N	1	1	\N
937	625c	Autres opérateurs et ouvriers qualifiés de la chimie (y.c. pharmacie) et de la plasturgie	0	314.00000000	\N	1	1	\N
938	625d	Opérateurs de la transformation des viandes	0	315.00000000	\N	1	1	\N
939	625f	Autres opérateurs travaillant sur installations ou machines : industrie agroalimentaire (hors transformation des viandes)	0	316.00000000	\N	1	1	\N
940	625g	Autres ouvriers de production qualifiés ne travaillant pas sur machine : industrie agroalimentaire (hors transformation des viandes)	0	317.00000000	\N	1	1	\N
941	625h	Ouvriers qualifiés des autres industries (eau, gaz, énergie, chauffage)	0	318.00000000	\N	1	1	\N
942	626a	Pilotes d'installation lourde des industries de transformation : métallurgie, production verrière, matériaux de construction	0	319.00000000	\N	1	1	\N
943	626b	Autres opérateurs et ouvriers qualifiés : métallurgie, production verrière, matériaux de construction	0	320.00000000	\N	1	1	\N
944	626c	Opérateurs et ouvriers qualifiés des industries lourdes du bois et de la fabrication du papier-carton	0	321.00000000	\N	1	1	\N
918	622c	Monteurs câbleurs qualifiés en électricité	0	295.00000000	\N	1	1	\N
945	627a	Opérateurs qualifiés du textile et de la mégisserie	0	322.00000000	\N	1	1	\N
946	627b	Ouvriers qualifiés de la coupe des vêtements et de l'habillement, autres opérateurs de confection qualifiés	0	323.00000000	\N	1	1	\N
947	627c	Ouvriers qualifiés du travail industriel du cuir	0	324.00000000	\N	1	1	\N
948	627d	Ouvriers qualifiés de scierie, de la menuiserie industrielle et de l'ameublement	0	325.00000000	\N	1	1	\N
949	627e	Ouvriers de la photogravure et des laboratoires photographiques et cinématographiques	0	326.00000000	\N	1	1	\N
950	627f	Ouvriers de la composition et de l'impression, ouvriers qualifiés de la brochure, de la reliure et du façonnage du papier-carton	0	327.00000000	\N	1	1	\N
951	628a	Mécaniciens qualifiés de maintenance, entretien : équipements industriels	0	328.00000000	\N	1	1	\N
952	628b	Electromécaniciens, électriciens qualifiés d'entretien : équipements industriels	0	329.00000000	\N	1	1	\N
953	628c	Régleurs qualifiés d'équipement de fabrication (travail des métaux, mécanique)	0	330.00000000	\N	1	1	\N
954	628d	Régleurs qualifiés d'équipement de fabrication (hors travail des métaux et mécanique)	0	331.00000000	\N	1	1	\N
955	628e	Ouvriers qualifiés de l'assainissement et du traitement des déchets	0	332.00000000	\N	1	1	\N
956	628f	Agents qualifiés de laboratoire (sauf chimie, santé)	0	333.00000000	\N	1	1	\N
957	628g	Ouvriers qualifiés divers de type industriel	0	334.00000000	\N	1	1	\N
958	631a	Jardiniers	0	335.00000000	\N	1	1	\N
959	632a	Maçons qualifiés	0	336.00000000	\N	1	1	\N
960	632b	Ouvriers qualifiés du travail de la pierre	0	337.00000000	\N	1	1	\N
961	632c	Charpentiers en bois qualifiés	0	338.00000000	\N	1	1	\N
962	632d	Menuisiers qualifiés du bâtiment	0	339.00000000	\N	1	1	\N
963	632e	Couvreurs qualifiés	0	340.00000000	\N	1	1	\N
964	632f	Plombiers et chauffagistes qualifiés	0	341.00000000	\N	1	1	\N
965	632g	Peintres et ouvriers qualifiés de pose de revêtements sur supports verticaux	0	342.00000000	\N	1	1	\N
966	632h	Soliers moquetteurs et ouvriers qualifiés de pose de revêtements souples sur supports horizontaux	0	343.00000000	\N	1	1	\N
967	632j	Monteurs qualifiés en agencement, isolation	0	344.00000000	\N	1	1	\N
968	632k	Ouvriers qualifiés d'entretien général des bâtiments	0	345.00000000	\N	1	1	\N
969	633a	Electriciens qualifiés de type artisanal (y c. bâtiment)	0	346.00000000	\N	1	1	\N
970	633b	Dépanneurs qualifiés en radiotélévision, électroménager, matériel électronique	0	347.00000000	\N	1	1	\N
971	633c	Electriciens, électroniciens qualifiés en maintenance entretien, réparation : automobile	0	348.00000000	\N	1	1	\N
972	633d	Electriciens, électroniciens qualifiés en maintenance, entretien : équipements non industriels	0	349.00000000	\N	1	1	\N
973	634a	Carrossiers d'automobiles qualifiés	0	350.00000000	\N	1	1	\N
974	634b	Métalliers, serruriers qualifiés	0	351.00000000	\N	1	1	\N
975	634c	Mécaniciens qualifiés en maintenance, entretien, réparation : automobile	0	352.00000000	\N	1	1	\N
976	634d	Mécaniciens qualifiés de maintenance, entretien : équipements non industriels	0	353.00000000	\N	1	1	\N
977	635a	Tailleurs et couturières qualifiés, ouvriers qualifiés du travail des étoffes (sauf fabrication de vêtements), ouvriers qualifiés de type artisanal du travail du cuir	0	354.00000000	\N	1	1	\N
978	636a	Bouchers (sauf industrie de la viande)	0	355.00000000	\N	1	1	\N
979	636b	Charcutiers (sauf industrie de la viande)	0	356.00000000	\N	1	1	\N
980	636c	Boulangers, pâtissiers (sauf activité industrielle)	0	357.00000000	\N	1	1	\N
981	636d	Cuisiniers et commis de cuisine	0	358.00000000	\N	1	1	\N
982	637a	Modeleurs (sauf modeleurs de métal), mouleurs-noyauteurs à la main, ouvriers qualifiés du travail du verre ou de la céramique à la main	0	359.00000000	\N	1	1	\N
983	637b	Ouvriers d'art	0	360.00000000	\N	1	1	\N
984	637c	Ouvriers et techniciens des spectacles vivants et audiovisuels	0	361.00000000	\N	1	1	\N
985	637d	Ouvriers qualifiés divers de type artisanal	0	362.00000000	\N	1	1	\N
986	641a	Conducteurs routiers et grands routiers	0	363.00000000	\N	1	1	\N
987	641b	Conducteurs de véhicule routier de transport en commun	0	364.00000000	\N	1	1	\N
988	642a	Conducteurs de taxi	0	365.00000000	\N	1	1	\N
989	642b	Conducteurs de voiture particulière	0	366.00000000	\N	1	1	\N
990	643a	Conducteurs livreurs, coursiers	0	367.00000000	\N	1	1	\N
991	644a	Conducteurs de véhicule de ramassage des ordures ménagères	0	368.00000000	\N	1	1	\N
992	651a	Conducteurs d'engin lourd de levage	0	369.00000000	\N	1	1	\N
993	651b	Conducteurs d'engin lourd de manoeuvre	0	370.00000000	\N	1	1	\N
994	652a	Ouvriers qualifiés de la manutention, conducteurs de chariots élévateurs, caristes	0	371.00000000	\N	1	1	\N
995	652b	Dockers	0	372.00000000	\N	1	1	\N
996	653a	Magasiniers qualifiés	0	373.00000000	\N	1	1	\N
997	654b	Conducteurs qualifiés d'engins de transport guidés (sauf remontées mécaniques)	0	374.00000000	\N	1	1	\N
998	654c	Conducteurs qualifiés de systèmes de remontées mécaniques	0	375.00000000	\N	1	1	\N
999	655a	Autres agents et ouvriers qualifiés (sédentaires) des services d'exploitation des transports	0	376.00000000	\N	1	1	\N
1000	656b	Matelots de la marine marchande	0	377.00000000	\N	1	1	\N
1001	656c	Capitaines et matelots timoniers de la navigation fluviale	0	378.00000000	\N	1	1	\N
1002	671a	Ouvriers non qualifiés des travaux publics de l'Etat et des collectivités locales	0	379.00000000	\N	1	1	\N
1003	671c	Ouvriers non qualifiés des travaux publics et du travail du béton	0	380.00000000	\N	1	1	\N
1004	671d	Aides-mineurs, ouvriers non qualifiés de l'extraction	0	381.00000000	\N	1	1	\N
1005	672a	Ouvriers non qualifiés de l'électricité et de l'électronique	0	382.00000000	\N	1	1	\N
1006	673a	Ouvriers de production non qualifiés travaillant par enlèvement de métal	0	383.00000000	\N	1	1	\N
1	Indéfini	Indéfini	0	0.00000000	\N	1	1	\N
624	100x	Agriculteurs et éleveurs, salariés de leur exploitation	0	1.00000000	\N	1	1	\N
625	210x	Artisans salariés de leur entreprise	0	2.00000000	\N	1	1	\N
626	220x	Commerçants et assimilés, salariés de leur entreprise	0	3.00000000	\N	1	1	\N
1007	673b	Ouvriers de production non qualifiés travaillant par formage de métal	0	384.00000000	\N	1	1	\N
1008	673c	Ouvriers non qualifiés de montage, contrôle en mécanique et travail des métaux	0	385.00000000	\N	1	1	\N
1009	674a	Ouvriers de production non qualifiés : chimie, pharmacie, plasturgie	0	386.00000000	\N	1	1	\N
1010	674b	Ouvriers de production non qualifiés de la transformation des viandes	0	387.00000000	\N	1	1	\N
1025	683a	Apprentis boulangers, bouchers, charcutiers	0	402.00000000	\N	1	1	\N
1026	684a	Nettoyeurs	0	403.00000000	\N	1	1	\N
1027	684b	Ouvriers non qualifiés de l'assainissement et du traitement des déchets	0	404.00000000	\N	1	1	\N
1028	685a	Ouvriers non qualifiés divers de type artisanal	0	405.00000000	\N	1	1	\N
1029	691a	Conducteurs d'engin agricole ou forestier	0	406.00000000	\N	1	1	\N
1030	691b	Ouvriers de l'élevage	0	407.00000000	\N	1	1	\N
1031	691c	Ouvriers du maraîchage ou de l'horticulture	0	408.00000000	\N	1	1	\N
1032	691d	Ouvriers de la viticulture ou de l'arboriculture fruitière	0	409.00000000	\N	1	1	\N
1033	691e	Ouvriers agricoles sans spécialisation particulière	0	410.00000000	\N	1	1	\N
1034	691f	Ouvriers de l'exploitation forestière ou de la sylviculture	0	411.00000000	\N	1	1	\N
1035	692a	Marins-pêcheurs et ouvriers de l'aquaculture	0	412.00000000	\N	1	1	\N
1011	674c	Autres ouvriers de production non qualifiés : industrie agroalimentaire	0	388.00000000	\N	1	1	\N
1012	674d	Ouvriers de production non qualifiés : métallurgie, production verrière, céramique, matériaux de construction	0	389.00000000	\N	1	1	\N
1013	674e	Ouvriers de production non qualifiés : industrie lourde du bois, fabrication des papiers et cartons	0	390.00000000	\N	1	1	\N
1014	675a	Ouvriers de production non qualifiés du textile et de la confection, de la tannerie-mégisserie et du travail du cuir	0	391.00000000	\N	1	1	\N
1015	675b	Ouvriers de production non qualifiés du travail du bois et de l'ameublement	0	392.00000000	\N	1	1	\N
1016	675c	Ouvriers de production non qualifiés de l'imprimerie, presse, édition	0	393.00000000	\N	1	1	\N
1017	676a	Manutentionnaires non qualifiés	0	394.00000000	\N	1	1	\N
1018	676b	Déménageurs (hors chauffeurs-déménageurs), non qualifiés	0	395.00000000	\N	1	1	\N
1019	676c	Ouvriers du tri, de l'emballage, de l'expédition, non qualifiés	0	396.00000000	\N	1	1	\N
1020	676d	Agents non qualifiés des services d'exploitation des transports	0	397.00000000	\N	1	1	\N
1021	676e	Ouvriers non qualifiés divers de type industriel	0	398.00000000	\N	1	1	\N
1022	681a	Ouvriers non qualifiés du gros oeuvre du bâtiment	0	399.00000000	\N	1	1	\N
1023	681b	Ouvriers non qualifiés du second oeuvre du bâtiment	0	400.00000000	\N	1	1	\N
1024	682a	Métalliers, serruriers, réparateurs en mécanique non qualifiés	0	401.00000000	\N	1	1	\N
\.


--
-- Data for Name: CODE_REGIME; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_REGIME" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
7	134	SNCF	0	5.00000000	\N	1	1	\N
1	 	Indéfini	0	0.00000000	\N	1	1	\N
3	121	FSPOEIE	0	1.00000000	\N	1	1	\N
4	122	Fonctionnaires civils de l'Etat avec prélèvement de la pension et versement des cotisations	0	2.00000000	\N	1	1	\N
5	123	Fonctionnaires civils de l'Etat sans prélèvement de la pension mais avec versement des cotis	0	3.00000000	\N	1	1	\N
6	124	Fonctionnaires de l'Etat sans prélèvement de la pension ni versement des cotisations patrona	0	4.00000000	\N	1	1	\N
8	135	RATP	0	6.00000000	\N	1	1	\N
9	136	Etablissement des invalides de la marine(ENIM)	0	7.00000000	\N	1	1	\N
10	137	Mineurs et assimilés	0	8.00000000	\N	1	1	\N
11	138	Militaires de carrière	0	9.00000000	\N	1	1	\N
12	139	Banque de France	0	10.00000000	\N	1	1	\N
2	120	CNRACL	0	11.00000000	\N	1	1	\N
14	141	Chambre de commerce	0	12.00000000	\N	1	1	\N
15	144	Assemblée Nationale	0	13.00000000	\N	1	1	\N
16	145	Sénat	0	14.00000000	\N	1	1	\N
17	146	Port autonome de Bordeaux	0	15.00000000	\N	1	1	\N
18	200	Régime général	0	16.00000000	\N	1	1	\N
19	300	Régime agricole (CCMSA Salariés)	0	17.00000000	\N	1	1	\N
20	900	Autre	0	18.00000000	\N	1	1	\N
21	901	Sans régime obligatoire	0	19.00000000	\N	1	1	\N
22	902	Elus ne relevant pas du Régime général	0	20.00000000	\N	1	1	\N
13	140	Clercs et employés de notaires	0	21.00000000	\N	1	1	\N
\.


--
-- Data for Name: CODE_STATUT_CATEGORIEL; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_STATUT_CATEGORIEL" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	 	Indefini	0	0.00000000	1	\N	1	\N
2	01	cadre (article 4 et 4 bis)	0	1.00000000	1	\N	1	\N
3	02	extension cadre pour retraite complémentaire	0	2.00000000	1	\N	1	\N
4	03	non cadre	0	3.00000000	1	\N	1	\N
5	04	pas de statut catégoriel	0	4.00000000	1	\N	1	\N
\.


--
-- Data for Name: CODE_STATUT_CAT_CONV; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_STATUT_CAT_CONV" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE") FROM stdin;
1			0	0.00000000
2	01	agriculteur salarié de son exploitation	0	\N
3	02	artisan ou commerçant salarié de son entreprise	0	\N
4	03	cadre dirigeant (votant au collège employeur des élections prud''hommales)	0	\N
5	04	autres cadres au sens de la convention collective (ou du statut pour les régimes spéciaux)	0	\N
6	05	profession intermédiaire (technicien, contremaître, agent de maîtrise, clergé)	0	\N
7	06	employé administratif d''entreprise, de commerce, agent de service	0	\N
8	07	ouvriers qualifiés et non qualifiés y compris ouvriers agricoles	0	\N
\.


--
-- Data for Name: CODE_STATUT_PROF; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CODE_STATUT_PROF" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	 	Indéfini	0	0.00000000	\N	1	1	\N
3	2	employé	0	1.00000000	\N	1	1	\N
4	3	technicien	0	2.00000000	\N	1	1	\N
6	5	artiste	0	4.00000000	\N	1	1	\N
7	6	représentant exclusif	0	5.00000000	\N	1	1	\N
8	7	représentant multicarte	0	6.00000000	\N	1	1	\N
9	8	enseignant loi GUERMEUR	0	7.00000000	\N	1	1	\N
10	9	stagiaire rémunéré	0	8.00000000	\N	1	1	\N
11	10	stagiaire non rémunéré	0	9.00000000	\N	1	1	\N
12	11	stagiaire rémunéré Diplômé d'Etat	0	10.00000000	\N	1	1	\N
13	12	cadre supérieur	0	11.00000000	\N	1	1	\N
14	14	journaliste pigiste	0	12.00000000	\N	1	1	\N
15	15	journaliste stagiaire	0	13.00000000	\N	1	1	\N
16	16	journaliste titulaire	0	14.00000000	\N	1	1	\N
17	17	employé d'immeuble au service des entreprises	0	15.00000000	\N	1	1	\N
18	18	clergé	0	16.00000000	\N	1	1	\N
19	19	associé salarié	0	17.00000000	\N	1	1	\N
20	20	gérant minoritaire de SARL	0	18.00000000	\N	1	1	\N
21	21	gérant égalitaire de SARL	0	19.00000000	\N	1	1	\N
23	23	Directeur Général de Société Anonyme	0	21.00000000	\N	1	1	\N
26	34	parlementaire européen	0	24.00000000	\N	1	1	\N
27	40	élu communal	0	25.00000000	\N	1	1	\N
28	41	élu départemental	0	26.00000000	\N	1	1	\N
29	42	élu régional	0	27.00000000	\N	1	1	\N
31	52	praticien hospitalier	0	29.00000000	\N	1	1	\N
32	53	interne	0	30.00000000	\N	1	1	\N
33	54	étudiant hospitalier	0	31.00000000	\N	1	1	\N
34	56	praticien hospitalier sans activité libérale	0	32.00000000	\N	1	1	\N
35	57	praticien hospitalier universitaire	0	33.00000000	\N	1	1	\N
36	58	pharmacien	0	34.00000000	\N	1	1	\N
37	59	médecin sans statut hospitalier	0	35.00000000	\N	1	1	\N
2	1	ouvrier	0	43.00000000	\N	1	1	\N
47	69	agent titulaire de l'Etat	0	45.00000000	\N	1	1	\N
48	70	agent non titulaire de l'Etat	0	46.00000000	\N	1	1	\N
49	71	stagiaire de l'Etat	0	47.00000000	\N	1	1	\N
50	90	pas de statut	0	48.00000000	\N	1	1	\N
5	4	agent de maîtrise (y compris maîtrise administrative et commerciale)\n	0	3.00000000	\N	1	1	\N
22	22	Président Directeur Général de Société Anonyme \n	0	20.00000000	\N	1	1	\N
24	24	Président Directeur Général de Société Anonyme Simplifiée \n	0	22.00000000	\N	1	1	\N
25	25	Directeur Général de Société Anonyme Simplifiée \n	0	23.00000000	\N	1	1	\N
30	43	élu des établissements publics de coopération intercommunale\n	0	28.00000000	\N	1	1	\N
38	60	agent titulaire des étatblissements industriels de l'Etat\n	0	36.00000000	\N	1	1	\N
39	61	agent non titulaire des étatblissements industriels de l'Etat \n	0	37.00000000	\N	1	1	\N
40	62	stagiaire des étatblissements industriels de l'Etat\n	0	38.00000000	\N	1	1	\N
41	63	agent titulaire de la fonction publique territoriale \n	0	39.00000000	\N	1	1	\N
42	64	agent non titulaire des étatblissements industriels de l'Etat \nagent non titulaire de la fonction publique territoriale\n	0	40.00000000	\N	1	1	\N
43	65	stagiaire de la fonction publique territoriale \n	0	41.00000000	\N	1	1	\N
44	66	agent titulaire de la fonction publique hospitalière\n	0	42.00000000	\N	1	1	\N
45	67	agent non titulaire de la fonction publique hospitalière \n	0	49.00000000	\N	1	1	\N
46	68	stagiaire de la fonction publique hospitalière\n	0	44.00000000	\N	1	1	\N
\.


--
-- Data for Name: COMMANDE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMMANDE" ("ID", "NOM", "DATE", "DATE_ECHEANCE", "IDSOURCE", "SOURCE", "ID_FOURNISSEUR", "ARCHIVE", "ORDRE", "NUMERO", "T_HT", "T_TVA", "T_TTC", "T_POIDS", "T_SERVICE", "INFOS", "ID_COMMERCIAL", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE", "ID_DEVISE", "T_DEVISE", "EN_COURS", "ID_ADRESSE", "ID_CLIENT") FROM stdin;
1	Indéfini	\N	\N	1	 	1	0	1.00000000		0	0	0	0	0		1	\N	\N	\N	\N	1	0	t	1	1
\.


--
-- Data for Name: COMMANDE_CLIENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMMANDE_CLIENT" ("NOM", "SOURCE", "IDSOURCE", "ID", "DATE", "ID_CLIENT", "DATE_ECHEANCE", "NUMERO", "T_HT", "T_TVA", "T_TTC", "ARCHIVE", "ORDRE", "INFOS", "T_SERVICE", "ID_COMMERCIAL", "T_POIDS", "ID_DEVIS", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "T_DEVISE", "ID_TARIF", "ID_MODELE") FROM stdin;
 	 	0	1	2006-01-01	1	2006-01-01		0	0	0	0	0.00000000		0	1	0	1	\N	\N	\N	\N	0	1	1
\.


--
-- Data for Name: COMMANDE_CLIENT_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMMANDE_CLIENT_ELEMENT" ("ID", "ID_STYLE", "CODE", "NOM", "VALEUR_METRIQUE_1", "PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_VT_1", "ID_METRIQUE_1", "VALEUR_METRIQUE_2", "PRIX_METRIQUE_VT_2", "PRIX_METRIQUE_HA_2", "ID_METRIQUE_2", "VALEUR_METRIQUE_3", "PRIX_METRIQUE_VT_3", "PRIX_METRIQUE_HA_3", "ID_METRIQUE_3", "PA_HT", "PV_HT", "ID_TAXE", "SERVICE", "POIDS", "QTE", "T_PV_HT", "T_PA_HT", "T_PV_TTC", "T_POIDS", "ARCHIVE", "ORDRE", "ID_COMMANDE_CLIENT", "ID_MODE_VENTE_ARTICLE", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "QTE_ACHAT", "CODE_DOUANIER", "ID_PAYS", "ID_DEVISE", "PV_U_DEVISE", "POURCENT_REMISE", "PV_T_DEVISE", "TAUX_DEVISE", "DESCRIPTIF", "MARGE_HT", "QTE_UNITAIRE", "ID_UNITE_VENTE", "ID_ARTICLE") FROM stdin;
1	2			0	0	0	1	0	0	0	1	0	0	0	1	0	0	2	f	0	0	0	0	0	0	0	0.00000000	1	5	\N	1	1	\N	1		1	1	0	0.00	0	1.00000000		0	1.000000	2	1
\.


--
-- Data for Name: COMMANDE_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMMANDE_ELEMENT" ("ID", "ID_STYLE", "CODE", "NOM", "VALEUR_METRIQUE_1", "PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_VT_1", "ID_METRIQUE_1", "VALEUR_METRIQUE_2", "PRIX_METRIQUE_HA_2", "PRIX_METRIQUE_VT_2", "ID_METRIQUE_2", "VALEUR_METRIQUE_3", "PRIX_METRIQUE_VT_3", "PRIX_METRIQUE_HA_3", "ID_METRIQUE_3", "PA_HT", "PV_HT", "ID_TAXE", "SERVICE", "POIDS", "QTE", "T_PV_HT", "T_PA_HT", "T_PV_TTC", "T_POIDS", "ID_COMMANDE", "ARCHIVE", "ORDRE", "T_PA_TTC", "ID_MODE_VENTE_ARTICLE", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "QTE_ACHAT", "PA_DEVISE", "ID_DEVISE", "PA_DEVISE_T", "QTE_UNITAIRE", "ID_UNITE_VENTE", "ID_ARTICLE") FROM stdin;
1	2			0	0	0	1	0	0	0	1	0	0	0	1	0	0	2	f	0	0	0	0	0	0	1	0	0.00000000	0	5	\N	1	1	\N	1	0	1	0	1.000000	2	1
\.


--
-- Data for Name: COMMERCIAL; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMMERCIAL" ("ID_COMMERCIAL", "NOM", "PRENOM", "FONCTION", "TEL_STANDARD", "TEL_DIRECT", "TEL_MOBILE", "TEL_PERSONEL", "FAX", "EMAIL", "ARCHIVE", "ORDRE", "ID_TITRE_PERSONNEL", "ID_USER_COMMON", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	indéfini	 	 	 	 	 	 	 	 	0	0.00000000	1	1	\N	\N	\N	\N
2	A Définir									0	1.00000000	2	1	\N	\N	\N	\N
\.


--
-- Data for Name: COMPLETION; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMPLETION" ("CHAMP", "LABEL", "ARCHIVE", "ORDRE") FROM stdin;
\.


--
-- Data for Name: COMPTE_PCE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMPTE_PCE" ("ID", "NUMERO", "NOM", "INFOS", "TOTAL_DEBIT", "TOTAL_CREDIT", "RACINE", "ORDRE", "ARCHIVE", "ID_NATURE_COMPTE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	 	indefini	 	0	0	f	0.00000000	0	1	1	\N	1	\N
\.


--
-- Data for Name: COMPTE_PCG; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COMPTE_PCG" ("ID", "NUMERO", "NOM", "INFOS", "ID_TYPE_COMPTE_PCG_BASE", "ID_TYPE_COMPTE_PCG_AB", "ID_TYPE_COMPTE_PCG_DEV", "ID_NATURE_COMPTE", "ARCHIVE", "ORDRE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
12	41	Clients et comptes rattachés	Clients	1	1	1	1	1	7.00000000	1	\N	1	\N
25	1041	Primes d'émission	 	1	1	6	10	0	8.00000000	1	\N	1	\N
61	131	Subventions d'équipement	Le compte 131 « Subventions d'équipement » ou 138 « Autres subventions d'investissement » est\ncrédité de la subvention par le débit d'un compte de tiers ou d'un compte financier.\nLes subventions d'équipement dont bénéficie l'entité pour acquérir ou créer des immobilisations\nsont inscrites au compte 131.	2	1	7	10	0	65.00000000	1	\N	1	\N
62	1311	État	 	1	1	6	10	0	66.00000000	1	\N	1	\N
64	1313	Départements	 	1	1	6	10	0	68.00000000	1	\N	1	\N
65	1314	Communes	 	1	1	6	10	0	69.00000000	1	\N	1	\N
66	1315	Collectivités publiques	 	1	1	6	10	0	70.00000000	1	\N	1	\N
67	1316	Entreprises publiques	 	1	1	6	10	0	71.00000000	1	\N	1	\N
107	1572	Provisions pour gros entretien ou grandes révisions (Règlement n° 2003-07 du CRC)	 	1	1	6	10	0	111.00000000	1	\N	1	\N
221	2388	Autres immobilisations corporelles	 	1	1	6	1	0	225.00000000	1	\N	1	\N
223	26	PARTICIPATIONS ET CREANCES RATTACHEES A DES PARTICIPATIONS	 	3	1	7	1	0	227.00000000	1	\N	1	\N
269	2803	Frais de recherche et de développement	 	2	1	6	1	0	273.00000000	1	\N	1	\N
315	3221	Combustibles	 	1	1	6	1	0	319.00000000	1	\N	1	\N
371	3955	Produits finis (même ventilation que celle du compte 355)	 	1	1	6	1	0	375.00000000	1	\N	1	\N
372	397	Provisions pour dépréciation des stocks de marchandises	 	2	4	7	1	0	376.00000000	1	\N	1	\N
373	3971	Marchandise (ou groupe) A	 	1	1	6	1	0	377.00000000	1	\N	1	\N
374	3972	Marchandise (ou groupe) B	 	1	1	6	1	0	378.00000000	1	\N	1	\N
404	4181	Clients - Factures à établir	 	1	1	6	1	0	408.00000000	1	\N	1	\N
405	4188	Clients - Intérêts courus	 	1	1	6	1	0	409.00000000	1	\N	1	\N
406	419	Clients créditeurs	 	3	4	7	1	0	410.00000000	1	\N	1	\N
429	4382	Charges sociales sur congés à payer	 	1	1	6	1	0	433.00000000	1	\N	1	\N
488	4566	Actionnaires défaillants	 	1	1	1	1	1	492.00000000	1	\N	1	\N
489	4566	Actionnaires défaillants	 	1	1	1	1	1	493.00000000	1	\N	1	\N
499	467	Autres comptes débiteurs ou créditeurs	 	1	1	6	1	0	503.00000000	1	\N	1	\N
501	4686	Charges à payer	 	1	1	6	1	0	505.00000000	1	\N	1	\N
509	477	Différences de conversion - PASSIF	Le compte 477 est crédité des gains latents constatés par le débit de comptes de créances ou de\ncomptes de dettes, selon qu'elles correspondent à une augmentation des créances ou à une\ndiminution des dettes.\nLes différences de conversion, lorsqu'elles sont compensées par des contrats de couverture de\nchange, sont enregistrées dans des subdivisions distinctes des comptes 476 et 477.	2	1	7	1	0	513.00000000	1	\N	1	\N
510	4771	Augmentation des créances	 	1	1	6	1	0	514.00000000	1	\N	1	\N
772	6617	Intérêts des obligations cautionnées	 	1	1	6	1	0	776.00000000	1	\N	1	\N
894	7518	Autres droits et valeurs similaires	 	1	1	1	1	0	898.00000000	1	\N	1	\N
1	0	 	 	1	1	1	1	0	0.00000000	1	\N	1	\N
3	5113	Carte Bancaire	 	1	1	1	1	1	1.00000000	1	\N	1	\N
4	5111	Espèces	 	1	1	1	1	1	2.00000000	1	\N	1	\N
6	5114	Traites	 	1	1	1	1	1	3.00000000	1	\N	1	\N
9	3	Comptes de stocks et en-cours	Stocks	3	5	7	1	0	4.00000000	1	\N	1	\N
10	40	Fournisseurs et comptes rattachés	Fournisseurs\n\nLe compte 40 « Fournisseurs et comptes rattachés » enregistre les dettes et avances de fonds liées à\nl'acquisition de biens ou de services.	3	1	7	1	0	5.00000000	1	\N	1	\N
11	4	Comptes de tiers	Tiers	3	5	7	1	0	6.00000000	1	\N	1	\N
26	1042	Primes de fusion	 	1	1	6	10	0	9.00000000	1	\N	1	\N
27	1043	Primes d'apport	 	1	1	6	10	0	10.00000000	1	\N	1	\N
28	1044	Primes de conversion d'obligations en actions	 	1	1	6	10	0	11.00000000	1	\N	1	\N
29	1045	Bons de souscription d'actions	 	1	1	6	10	0	12.00000000	1	\N	1	\N
30	105	Écarts de réévaluation	Le compte 105 « Écarts de réévaluation » enregistre les écarts constatés à l'occasion d'opérations de réévaluation et qui peuvent être incorporés en tout ou partie au capital. Il est subdivisé autant que de besoin.	2	4	7	10	0	13.00000000	1	\N	1	\N
31	1051	Réserve spéciale de réévaluation	 	1	1	6	10	0	14.00000000	1	\N	1	\N
32	1052	Écart de réévaluation libre	 	1	1	6	10	0	15.00000000	1	\N	1	\N
54	11	REPORT A NOUVEAU (solde créditeur ou débiteur)	Le compte 11 « Report à nouveau » peut être subdivisé afin de distinguer le report à nouveau\nbénéficiaire au compte 110 « Report à nouveau (solde créditeur) » et le report à nouveau déficitaire\nau compte 119 « Report à nouveau (solde débiteur) ».\nEn l'absence de bénéfices, les intérêts intercalaires, alloués aux apports des associés en vertu d'une\nclause de garantie par l'État d'un dividende minimal, sont inscrits au compte 11 « Report à\nnouveau ».	2	1	7	8	0	16.00000000	1	\N	1	\N
33	1053	Réserve de réévaluation	 	1	1	6	10	0	17.00000000	1	\N	1	\N
34	106	Réserves	Les réserves à inscrire au compte 106 « Réserves » sont des bénéfices affectés durablement à l'entité jusqu'à décision contraire des organes compétents.\nCe compte est crédité, lors de l'affectation des bénéfices, des montants destinés : \t\n\t- à la réserve légale ; \t\n\t- aux réserves indisponibles, par exemple : réserves pour actions propres et parts propres ; \t\n\t- aux réserves statutaires ou contractuelles ; \t\n\t- aux réserves réglementées, telles que plus-values nettes à long terme, réserves consécutives à l'octroi de subventions d'investissement ; \t\n\t- aux autres réserves qui comprennent notamment les réserves de propre assureur. \n Le compte 106 est débité des prélèvements sur les réserves concernées pour les incorporer au capital, les distribuer aux associés et amortir les pertes.	3	1	7	10	0	18.00000000	1	\N	1	\N
35	1055	Écarts de réévaluation (autres opérations légales)	 	1	1	6	10	0	19.00000000	1	\N	1	\N
36	1057	Autres écarts de réévaluation en France	 	1	1	6	10	0	20.00000000	1	\N	1	\N
37	1058	Autres écarts de réévaluation à l'Étranger	 	1	1	6	10	0	21.00000000	1	\N	1	\N
39	10611	Réserve légale proprement dite	 	1	1	6	10	0	23.00000000	1	\N	1	\N
40	10612	Plus-values nettes à long terme	 	1	1	6	10	0	24.00000000	1	\N	1	\N
42	1062	Réserves indisponibles	 	2	1	6	10	0	25.00000000	1	\N	1	\N
43	1063	Réserves statutaires ou contractuelles	 	2	4	6	10	0	26.00000000	1	\N	1	\N
44	1064	Réserves réglementées	 	2	4	7	10	0	27.00000000	1	\N	1	\N
45	10641	Plus-values nettes à long terme	 	1	1	6	10	0	28.00000000	1	\N	1	\N
933	778	Autres produits exceptionnels	 	1	1	1	1	0	937.00000000	1	\N	1	\N
46	10643	Réserves consécutives à l'octroi de subventions d'investissement	 	1	1	6	10	0	29.00000000	1	\N	1	\N
47	10648	Autres réserves réglementées	 	1	1	6	10	0	30.00000000	1	\N	1	\N
48	1068	Autres réserves	 	2	4	7	10	0	31.00000000	1	\N	1	\N
49	10681	Réserve de propre assureur	 	1	1	6	10	0	32.00000000	1	\N	1	\N
50	10688	Réserves diverses	 	1	1	6	10	0	33.00000000	1	\N	1	\N
51	107	Écart d'équivalence	Le compte 107 « Écart d'équivalence » enregistre l'écart constaté lorsque la valeur globale des titres évalués par équivalence est supérieure à leur prix d'acquisition.	2	1	6	10	0	34.00000000	1	\N	1	\N
52	108	Compte de l'exploitant	 	2	4	6	10	0	35.00000000	1	\N	1	\N
53	109	Actionnaires : Capital souscrit - non appelé	Le compte 109 « Actionnaires : capital souscrit - non appelé » est débité en contrepartie de la\nsubdivision du compte 101 intitulée « Capital souscrit - non appelé ».	2	1	6	10	0	36.00000000	1	\N	1	\N
55	110	Report à nouveau (solde créditeur)	 	1	1	6	8	0	37.00000000	1	\N	1	\N
973	739	(Supprimés par le règlement n° 99-08 du CRC)	 	2	1	6	1	0	38.00000000	1	\N	1	\N
972	62	AUTRES CHARGES EXTERNES	 	1	1	1	1	1	39.00000000	1	\N	1	\N
971	475	Compte d'attente	 	2	1	6	1	0	40.00000000	1	\N	1	\N
970	474	Compte d'attente	 	2	1	6	1	0	41.00000000	1	\N	1	\N
969	473	Compte d'attente	 	2	1	6	1	0	42.00000000	1	\N	1	\N
968	472	Compte d'attente	 	2	1	6	1	0	43.00000000	1	\N	1	\N
2	5112	Cheques	 	1	1	1	1	1	44.00000000	1	\N	1	\N
58	120	Résultat de l'exercice (bénéfice)	 	1	1	6	8	0	46.00000000	1	\N	1	\N
57	12	RESULTAT DE L'EXERCICE (bénéfice ou perte)	Le solde créditeur du compte 12 représente un bénéfice, les produits étant supérieurs aux charges.\nLe solde débiteur du compte 12 représente une perte, les charges étant supérieures aux produits.\n\nLe compte 12 « Résultat de l'exercice » enregistre pour solde les comptes de charges et les comptes de produits de l'exercice. Le solde créditeur du compte 12 représente un bénéfice, les produits étant supérieurs aux charges. Le solde débiteur du compte 12 représente une perte, les charges étant supérieures aux produits. Le compte 12 est soldé après décision d'affectation du résultat. Dans les sociétés, les montants non distribués et non affectés à un compte de réserves sont virés au compte 11 « Report à nouveau » : au compte 110, en cas de report bénéficiaire, et au compte 119, en cas de report déficitaire, si ces comptes sont ouverts. A l'ouverture des comptes de l'exercice suivant, les entités ont la possibilité d'utiliser un compte spécial 88 « Résultat en instance d'affectation ». Dans les entreprises individuelles, le solde du compte 12 est viré au compte 101 « Capital individuel ».\n\nLes entités peuvent utiliser le compte 120 « Résultat de l'exercice (bénéfice) » pour enregistrer le bénéfice et le compte 129 « Résultat de l'exercice (perte) » pour enregistrer la perte. Elles ont la faculté d'utiliser les comptes 121 à 128, à leur convenance, pour dégager, par exemple, des soldes intermédiaires de gestion.	2	4	7	8	0	47.00000000	1	\N	1	\N
56	119	Report à nouveau (solde débiteur)	 	1	1	6	8	0	48.00000000	1	\N	1	\N
7	1	Comptes de capitaux	Capitaux propres, autres fonds propres, emprunts et dettes assimilées Les comptes de la classe 1 regroupent : - les capitaux propres qui correspondent à la somme algébrique : - des apports : capital, primes liées au capital, - des écarts de réévaluation, - des écarts d'équivalence, - des bénéfices autres que ceux pour lesquels une décision de distribution est intervenue : réserves, report à nouveau créditeur, bénéfice de l'exercice, - des pertes : report à nouveau débiteur, perte de l'exercice, - des subventions d'investissement, - des provisions réglementées. Au sein des capitaux propres, la situation nette est établie après affectation du résultat de l'exercice. Elle exclut les subventions d'investissement et les provisions réglementées ; - les autres fonds propres qui comprennent le montant des émissions de titres participatifs, les avances conditionnées et les droits du concédant ; - les provisions pour risques et charges ; - les emprunts et dettes assimilées ; - les dettes rattachées à des participations ; - les comptes de liaison des établissements et sociétés en participation.	3	5	7	1	0	49.00000000	1	\N	1	\N
8	2	Comptes d'immobilisations	Les comptes de la classe 2 regroupent les immobilisations incorporelles, les immobilisations\ncorporelles, les immobilisations financières, les amortissements et provisions relatifs aux\nimmobilisations.\n\n\nLes comptes d'immobilisations sont débités, à la date d'entrée des biens dans le patrimoine de\nl'entité :\n- de la valeur d'apport ;\n- du coût d'acquisition ;\n- du coût de production du bien ;\npar le crédit, suivant le cas :\n- du compte 101 « Capital », ou du compte 456 « Associés - Opérations sur le capital »\n(comptes d'apport en société) ;\n- du compte 404 « Fournisseurs d'immobilisations » ou autres comptes concernés ;\n- du compte 72 « Production immobilisée ».\nLes amortissements et les provisions pour dépréciation des immobilisations sont à porter aux\nsubdivisions des comptes 28 « Amortissements des immobilisations » et 29 « Provisions pour\ndépréciation des immobilisations ».\nLors des cessions, la valeur d'entrée des éléments cédés et les amortissements correspondants sont\nsortis des comptes où ils figurent. Le montant net en résultant est porté au débit du compte 675\n« Valeurs comptables des éléments d'actifs cédés ». Simultanément, le compte 775 « Produits des\ncessions d'éléments d'actif » est crédité par le débit du compte 462 « Créances sur cessions\nd'immobilisations ».	3	5	7	1	0	50.00000000	1	\N	1	\N
13	5	Comptes financier	Finances	3	5	7	1	0	51.00000000	1	\N	1	\N
14	6	Comptes de charges	Achats	3	5	7	1	0	52.00000000	1	\N	1	\N
15	7	Compte de produits	Ventes	3	5	7	1	0	53.00000000	1	\N	1	\N
16	8	Comptes spéciaux	Clôtures	3	5	7	1	0	54.00000000	1	\N	1	\N
90	145	Amortissements dérogatoires	 	2	4	6	10	0	94.00000000	1	\N	1	\N
17	101	Capital	1 - Comptes à l'usage de l'exploitant individuel. \n Le compte 101 « Capital individuel » enregistre à son crédit : \t\n\t- la valeur des apports de l'entrepreneur au début ou en cours d'activité ; \t\n\t- le bénéfice de l'exercice précédent par le débit du compte 12 « Résultat de l'exercice ».\n Il enregistre à son débit : \n\t- les prélèvements de toutes natures ; \n\t- la perte de l'exercice précédent par le crédit du compte 12. \nLes apports ou les retraits personnels de l'exploitant et, le cas échéant, de sa famille sont enregistrés en cours d'exercice dans un compte 108 dénommé « Compte de l'exploitant ». En fin d'exercice, le solde de ce compte est viré au compte 101 « Capital individuel ».   \n\n2 - Comptes à l'usage des sociétés.  \nDans les sociétés, le capital représente la valeur nominale des actions ou des parts sociales. Le compte 101 « Capital social » enregistre à son crédit le montant du capital figurant dans l'acte de société. Il retrace l'évolution de ce montant au cours de la vie de la société suivant les décisions des organes compétents. \nIl est crédité lors des augmentations de capital : \t\n\t- du montant des apports en espèces ou en nature effectués par les associés, sous déduction des primes liées au capital social ; \t\n\t- du montant des incorporations de réserves. Il est débité des réductions de capital, quelle qu'en soit la cause par exemple, absorption de pertes ou remboursement aux associés.	2	4	7	10	0	55.00000000	1	\N	1	\N
18	1011	Capital souscrit - non appelé	 	1	1	6	10	0	56.00000000	1	\N	1	\N
19	1012	Capital souscrit - appelé, non versé	 	1	1	6	10	0	57.00000000	1	\N	1	\N
20	1013	Capital souscrit - appelé, versé	 	1	1	7	1	0	58.00000000	1	\N	1	\N
21	10131	Capital non amorti	 	1	1	6	10	0	59.00000000	1	\N	1	\N
22	10132	Capital amorti	 	1	1	6	10	0	60.00000000	1	\N	1	\N
23	1018	Capital souscrit soumis à des réglementations particulières	Le compte 1018 « Capital souscrit soumis à des réglementations particulières » enregistre à son crédit le montant du capital provenant d'opérations particulières telles que l'incorporation de plusvalues nettes à long terme, qui sont isolées en application de dispositions législatives et réglementaires. Ce compte est subdivisé autant que de besoin.	1	1	6	10	0	61.00000000	1	\N	1	\N
24	104	Primes liées au capital social	Le compte 104 « Primes liées au capital social » enregistre les primes d'émission, de fusion, d'apport, de conversion d'obligations en actions. A la souscription, la société émettrice de bons de souscription d'actions (BSA) enregistre la contrepartie de la valeur des bons au compte 104. Cette affectation est maintenue en cas de péremption des bons. Le compte 104 enregistre également le montant du droit d'entrée dans les sociétés coopératives. Les réserves à inscrire au compte 106 « Réserves » sont des bénéfices affectés durablement à l'entité jusqu'à décision contraire des organes compétents. Ce compte est crédité, lors de l'affectation des bénéfices, des montants destinés : - à la réserve légale ; - aux réserves indisponibles, par exemple : réserves pour actions propres et parts propres ; - aux réserves statutaires ou contractuelles ; - aux réserves réglementées, telles que plus-values nettes à long terme, réserves consécutives à l'octroi de subventions d'investissement ; - aux autres réserves qui comprennent notamment les réserves de propre assureur.	2	1	7	10	0	62.00000000	1	\N	1	\N
41	10	Capital et réserves	 	3	1	7	1	0	63.00000000	1	\N	1	\N
60	13	SUBVENTIONS D'INVESTISSEMENT	13. SUBVENTIONS D'INVESTISSEMENT ET D'EQUIPEMENT\nLe compte 131 « Subventions d'équipement » ou 138 « Autres subventions d'investissement » est\ncrédité de la subvention par le débit d'un compte de tiers ou d'un compte financier.\nLes subventions d'équipement dont bénéficie l'entité pour acquérir ou créer des immobilisations\nsont inscrites au compte 131.\nLes autres subventions d'investissement dont bénéficie l'entité pour financer des activités à long\nterme sont inscrites au compte 138.\nLe compte 139 « Subventions d'investissement inscrites au compte de résultat » est débité par le\ncrédit du compte 777 « Quote-part des subventions d'investissement virée au résultat de\nl'exercice ».\nLes comptes 131 ou 138 et 139 sont soldés l'un par l'autre, lorsque le crédit du premier est égal au\ndébit du deuxième.	3	1	7	10	0	64.00000000	1	\N	1	\N
68	1317	Entreprises et organismes privés	 	1	1	6	10	0	72.00000000	1	\N	1	\N
69	1318	Autres	 	1	1	6	10	0	73.00000000	1	\N	1	\N
70	138	Autres subventions d'investissement (même ventilation que celle du compte 131)	Les autres subventions d'investissement dont bénéficie l'entité pour financer des activités à long\nterme sont inscrites au compte 138.	2	1	6	10	0	74.00000000	1	\N	1	\N
71	139	Subventions d'investissement inscrites au compte de résultat	Le compte 139 « Subventions d'investissement inscrites au compte de résultat » est débité par le\ncrédit du compte 777 « Quote-part des subventions d'investissement virée au résultat de\nl'exercice ».	3	1	7	10	0	75.00000000	1	\N	1	\N
72	1391	Subventions d'équipement	 	2	1	7	10	0	76.00000000	1	\N	1	\N
73	13911	État	 	1	1	6	10	0	77.00000000	1	\N	1	\N
74	13912	Régions	 	1	1	6	10	0	78.00000000	1	\N	1	\N
75	13913	Départements	 	1	1	6	10	0	79.00000000	1	\N	1	\N
76	13914	Communes	 	1	1	6	10	0	80.00000000	1	\N	1	\N
77	13915	Collectivités publiques	 	1	1	6	10	0	81.00000000	1	\N	1	\N
78	13916	Entreprises publiques	 	1	1	6	10	0	82.00000000	1	\N	1	\N
79	13917	Entreprises et organismes privés	 	1	1	6	10	0	83.00000000	1	\N	1	\N
80	13918	Autres	 	1	1	6	10	0	84.00000000	1	\N	1	\N
81	1398	Autres subventions d'investissement (même ventilation que celle du compte 1391)	 	2	1	6	10	0	85.00000000	1	\N	1	\N
82	14	PROVISIONS REGLEMENTEES	 	3	1	7	10	0	86.00000000	1	\N	1	\N
83	142	Provisions réglementées relatives aux immobilisations	 	2	1	7	10	0	87.00000000	1	\N	1	\N
84	1423	Provisions pour reconstitution des gisements miniers et pétroliers	 	1	1	6	10	0	88.00000000	1	\N	1	\N
85	1424	Provisions pour investissement (participation des salariés)	 	1	1	6	10	0	89.00000000	1	\N	1	\N
86	143	Provisions réglementées relatives aux stocks	 	2	1	1	10	0	90.00000000	1	\N	1	\N
87	1431	Hausse des prix	 	1	1	6	10	0	91.00000000	1	\N	1	\N
88	1432	Fluctuation des cours	 	1	1	6	10	0	92.00000000	1	\N	1	\N
89	144	Provisions réglementées relatives aux autres éléments de l'actif	 	2	1	6	10	0	93.00000000	1	\N	1	\N
38	1061	Réserve légale	 	2	4	7	10	0	22.00000000	1	\N	1	\N
91	146	Provision spéciale de réévaluation	 	2	4	6	10	0	95.00000000	1	\N	1	\N
92	147	Plus-values réinvesties	 	2	4	6	10	0	96.00000000	1	\N	1	\N
93	148	Autres provisions réglementées	 	2	4	6	10	0	97.00000000	1	\N	1	\N
94	15	PROVISIONS POUR RISQUES ET CHARGES	 	3	4	7	10	0	98.00000000	1	\N	1	\N
95	151	Provisions pour risques	Le compte 151 « Provisions pour risques » enregistre toutes les provisions destinées à couvrir les\nrisques identifiés inhérents à l'activité de l'entité tels que ceux résultant des garanties données aux\nclients ou des opérations traitées en monnaies étrangères.	2	1	7	10	0	99.00000000	1	\N	1	\N
96	1511	Provisions pour litiges	 	1	1	6	10	0	100.00000000	1	\N	1	\N
97	1512	Provisions pour garanties données aux clients	 	1	1	6	10	0	101.00000000	1	\N	1	\N
98	1513	Provisions pour pertes sur marchés à terme	 	1	1	6	10	0	102.00000000	1	\N	1	\N
99	1514	Provisions pour amendes et pénalités	 	1	1	6	10	0	103.00000000	1	\N	1	\N
100	1515	Provisions pour pertes de change	 	1	1	6	10	0	104.00000000	1	\N	1	\N
101	1516	Provisions pour pertes sur contrats (Règlement n° 2000-06 du CRC)	 	1	1	6	10	0	105.00000000	1	\N	1	\N
102	1518	Autres provisions pour risques	 	1	1	6	10	0	106.00000000	1	\N	1	\N
103	153	Provisions pour pensions et obligations similaires	Le compte 153 « Provisions pour pensions et obligations similaires » (Règlement n° 2000-06 du\nCRC) enregistre les provisions relatives aux charges que peuvent engendrer des obligations légales\nou contractuelles conférant au personnel des droits à la retraite ou d'autres avantages postérieurs à\nl'emploi (assurance vie, couverture médicale).	2	1	6	10	0	107.00000000	1	\N	1	\N
104	154	Provisions pour restructurations (Règlement n° 2000-06 du CRC)	Le compte 154 « Provisions pour restructurations » (Règlement n° 2000-06 du CRC) enregistre les\nprovisions relatives aux charges que peuvent engendrer des opérations de restructurations telles que\nl'arrêt d'une branche d'activité ou la fermeture d'un site.	2	1	6	10	0	108.00000000	1	\N	1	\N
105	155	Provisions pour impôts	Le compte 155 « Provisions pour impôts » enregistre les provisions pour impôts qui correspondent\nà la charge probable d'impôts rattachable à l'exercice mais différée dans le temps et dont la prise en\ncompte définitive dépend des résultats futurs.	2	1	6	10	0	109.00000000	1	\N	1	\N
106	157	Provisions pour charges à répartir sur plusieurs exercices	Le compte 157 « Provisions pour charges à répartir sur plusieurs exercices » enregistre les\nprovisions destinées à couvrir des charges prévisibles, importantes, ne présentant pas un caractère\nannuel, telles que les frais de grosses réparations, et qui en conséquence, ne sauraient être\nsupportées par le seul exercice au cours duquel elles sont engagées.\nLors de la constitution d'une provision pour risques et charges, le compte de provisions est crédité\npar le débit :\n- du compte 681 « Dotations aux amortissements et aux provisions - Charges\nd'exploitation », lorsqu'elle concerne l'exploitation ;\n- du compte 686 « Dotations aux amortissements et aux provisions - Charges financières »\nlorsqu'elle affecte l'activité financière de l'entité ;\n- du compte 687 « Dotations aux amortissements et aux provisions - Charges\nexceptionnelles » lorsqu'elle a un caractère exceptionnel.\nIl est réajusté à la fin de chaque exercice par :\n- le débit des comptes de dotations correspondants 681, 686 ou 687, lorsque le montant de\nla provision est augmenté ;\n- le crédit du compte 781 « Reprises sur amortissements et provisions (à inscrire dans les\nproduits d'exploitation) », du compte 786 « Reprises sur provisions (à inscrire dans les produits\nfinanciers) » ou du compte 787 « Reprises sur provisions (à inscrire dans les produits exceptionnels) »,\nlorsque le montant de la provision doit être diminué ou annulé, la provision étant devenue, en tout ou\npartie, sans objet.\nLors de la réalisation du risque ou de la survenance de la charge, la provision antérieurement\nconstituée est soldée par le crédit des compte 781, 786 ou 787. Corrélativement, la charge\nintervenue est inscrite au compte intéressé de la classe 6.	2	1	7	10	0	110.00000000	1	\N	1	\N
108	158	Autres provisions pour charges	 	2	1	7	10	0	112.00000000	1	\N	1	\N
109	1581	Provisions pour remises en état (Règlement n° 2000-06 du CRC)	 	1	1	6	10	0	113.00000000	1	\N	1	\N
110	16	EMPRUNTS ET DETTES ASSIMILEES	Le compte 16 « Emprunts et dettes assimilées » enregistre d'une part les emprunts, d'autre part les\ndettes financières assimilées à des emprunts, à l'exception de celles enregistrées au compte 17\n« Dettes rattachées à des participations ».	3	4	7	10	0	114.00000000	1	\N	1	\N
111	161	Emprunts obligataires convertibles	 	2	1	6	10	0	115.00000000	1	\N	1	\N
112	163	Autres emprunts obligataires	 	2	1	6	10	0	116.00000000	1	\N	1	\N
113	164	Emprunts auprès des établissements de crédit	 	2	1	6	10	0	117.00000000	1	\N	1	\N
114	165	Dépôts et cautionnements reçus	 	2	1	7	10	0	118.00000000	1	\N	1	\N
115	1651	Dépôts	 	1	1	6	10	0	119.00000000	1	\N	1	\N
116	1655	Cautionnements	 	1	1	6	10	0	120.00000000	1	\N	1	\N
117	166	Participation des salariés aux résultats	 	2	1	7	10	0	121.00000000	1	\N	1	\N
118	1661	Comptes bloqués	 	1	1	6	10	0	122.00000000	1	\N	1	\N
119	1662	Fonds de participation	 	1	1	6	10	0	123.00000000	1	\N	1	\N
120	167	Emprunts et dettes assortis de conditions particulières	 	3	1	7	10	0	124.00000000	1	\N	1	\N
121	1671	Émissions de titres participatifs	 	2	1	6	10	0	125.00000000	1	\N	1	\N
122	1674	Avances conditionnées de l'État	 	2	1	6	10	0	126.00000000	1	\N	1	\N
123	1675	Emprunts participatifs	 	2	1	6	10	0	127.00000000	1	\N	1	\N
124	168	Autres emprunts et dettes assimilées	 	2	1	7	10	0	128.00000000	1	\N	1	\N
125	1681	Autres emprunts	 	1	1	6	10	0	129.00000000	1	\N	1	\N
126	1685	Rentes viagères capitalisées	 	1	1	6	10	0	130.00000000	1	\N	1	\N
127	1687	Autres dettes	 	1	1	6	10	0	131.00000000	1	\N	1	\N
128	1688	Intérêts courus	 	1	1	7	10	0	132.00000000	1	\N	1	\N
59	129	Résultat de l'exercice (perte)	 	1	1	6	8	0	45.00000000	1	\N	1	\N
63	1312	Régions	 	1	1	6	10	0	67.00000000	1	\N	1	\N
129	16881	Sur emprunts obligataires convertibles	 	1	1	6	10	0	133.00000000	1	\N	1	\N
130	16883	Sur autres emprunts obligataires	 	1	1	6	10	0	134.00000000	1	\N	1	\N
131	16884	Sur emprunts auprès des établissements de crédit	 	1	1	6	10	0	135.00000000	1	\N	1	\N
132	16885	Sur dépôts et cautionnements reçus	 	1	1	6	10	0	136.00000000	1	\N	1	\N
133	16886	Sur participation des salariés aux résultats	 	1	1	6	10	0	137.00000000	1	\N	1	\N
134	16887	Sur emprunts et dettes assortis de conditions particulières	 	1	1	6	10	0	138.00000000	1	\N	1	\N
135	16888	Sur autres emprunts et dettes assimilées	 	1	1	6	10	0	139.00000000	1	\N	1	\N
136	169	Primes de remboursement des obligations	 	2	1	6	10	0	140.00000000	1	\N	1	\N
137	17	DETTES RATTACHEES A DES PARTICIPATIONS	 	3	1	7	10	0	141.00000000	1	\N	1	\N
138	171	Dettes rattachées à des participations (groupe)	 	2	1	6	10	0	142.00000000	1	\N	1	\N
139	174	Dettes rattachées à des participations (hors groupe)	 	2	1	6	10	0	143.00000000	1	\N	1	\N
140	178	Dettes rattachées à des sociétés en participation	 	2	1	7	10	0	144.00000000	1	\N	1	\N
141	1781	Principal	 	1	1	6	10	0	145.00000000	1	\N	1	\N
142	1788	Intérêts courus	 	1	1	6	10	0	146.00000000	1	\N	1	\N
143	18	COMPTES DE LIAISON DES ETABLISSEMENTS ET SOCIETES EN PARTICIPATION	 	2	1	7	10	0	147.00000000	1	\N	1	\N
144	181	Comptes de liaison des établissements	 	1	1	6	10	0	148.00000000	1	\N	1	\N
145	186	Biens et prestations de services échangés entre établissements (charges)	 	1	1	6	10	0	149.00000000	1	\N	1	\N
146	187	Biens et prestations de services échangés entre établissements (produits)	 	1	1	6	10	0	150.00000000	1	\N	1	\N
147	188	Comptes de liaison des sociétés en participation	 	1	1	6	10	0	151.00000000	1	\N	1	\N
148	156	Provisions pour renouvellement des immobilisations (entreprises concessionnaires)	Le compte 156 « Provisions pour renouvellement (entreprises concessionnaires) » (Règlement\nn° 2000-06 du CRC) enregistre les provisions pour renouvellement des immobilisations constituées\npar les concessionnaires de service public.	2	1	7	10	0	152.00000000	1	\N	1	\N
149	20	IMMOBILISATIONS INCORPORELLES	 	3	5	7	1	0	153.00000000	1	\N	1	\N
150	201	Frais d'établissement	Le compte 201 « Frais d'établissement » enregistre les frais d'établissement soit directement, soit par l'intermédiaire du compte 72 « Production immobilisée ».	2	4	7	9	0	154.00000000	1	\N	1	\N
151	2011	Frais de constitution	 	1	1	6	1	0	155.00000000	1	\N	1	\N
152	2012	Frais de premier établissement	 	1	1	7	9	0	156.00000000	1	\N	1	\N
153	20121	Frais de prospection	 	1	1	6	9	0	157.00000000	1	\N	1	\N
154	20122	Frais de publicité	 	1	1	6	9	0	158.00000000	1	\N	1	\N
155	2013	Frais d'augmentation de capital et d'opérations diverses (fusions, scissions, transformations)	 	1	1	6	1	0	159.00000000	1	\N	1	\N
156	203	Frais de recherche et de développement	Le compte 203 « Frais de recherche et de développement » enregistre les frais de recherche appliquée et de développement qui peuvent être inscrits dans les immobilisations incorporelles. Il est débité par le crédit du compte 72 « Production immobilisée ». En cas d'échec des projets, les frais correspondants sont immédiatement amortis par le débit de la subdivision du compte 687 intitulée « Dotations aux amortissements exceptionnels sur immobilisations ».	2	1	6	9	0	160.00000000	1	\N	1	\N
157	205	Concessions et droits similaires, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires	Lorsque la prise de brevet est consécutive à des recherches liées à la réalisation de projets, le compte 205 « Concessions et droits similaires, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires » est débité du montant retenu comme valeur d'entrée du brevet par le crédit du compte 203. Le compte 205 enregistre les dépenses faites pour l'obtention de l'avantage que constitue la protection accordée, sous certaines conditions, au titulaire d'une concession, à l'inventeur, à l'auteur ou au bénéficiaire du droit d'exploitation d'un brevet, d'une licence, d'une marque, d'un procédé, de droits de propriété littéraire ou artistique. « (Règlement n°2004-08 du CRC) - Le compte 205 enregistre également :  les dépenses d'acquisition ou de création de logiciels qui peuvent être inscrites en immobilisations incorporelles ;  les quotas d'émission ».	2	1	6	9	0	161.00000000	1	\N	1	\N
158	206	Droit au bail	Le compte 206 « Droit au bail » enregistre le montant versé ou dû au locataire précédent en considération du transfert à l'acheteur des droits résultant tant des conventions que de la législation sur la propriété commerciale.	2	4	6	9	0	162.00000000	1	\N	1	\N
159	207	Fonds commercial	Le compte 207 « Fonds commercial » enregistre l'acquisition des éléments incorporels du fonds de commerce, y compris le droit au bail, qui ne font pas l'objet d'une évaluation et d'une comptabilisation séparées au bilan et qui concourent au maintien ou au développement du potentiel d'activité de l'entité. Ces éléments ne bénéficient pas nécessairement d'une protection juridique leur donnant une valeur certaine. (Règlement n°2004-01 du CRC) Le compte 207 enregistre également le mali de fusion.	2	4	6	9	0	163.00000000	1	\N	1	\N
160	208	Autres immobilisations incorporelles	 	2	4	6	9	0	164.00000000	1	\N	1	\N
161	21	IMMOBILISATIONS CORPORELLES	 	3	4	7	9	0	165.00000000	1	\N	1	\N
162	211	Terrains	Le compte 211 enregistre la valeur des terrains. Sont distingués : - les terrains nus qui ne supportent pas de construction ; - les terrains aménagés qui sont viabilisés ; - les sous-sols et les sur-sols. Ce compte est utilisé lorsque l'entité n'est pas propriétaire des trois éléments rattachables à une même parcelle de terrain : sol, sous-sol, sur-sol. Ainsi, le compte sur-sol enregistre la valeur du droit de construction ou d'utilisation de l'espace situé au-dessus d'un sol dont l'entité n'est pas propriétaire ; - les terrains de gisement tels que les carrières ; - les terrains bâtis qui supportent une construction propre ; - les terrains bâtis qui supportent une construction d'autrui.	3	1	7	9	0	166.00000000	1	\N	1	\N
163	2111	Terrains nus	 	2	1	6	9	0	167.00000000	1	\N	1	\N
164	2112	Terrains aménagés	 	2	1	6	1	0	168.00000000	1	\N	1	\N
165	2113	Sous-sols et sur-sols	 	2	1	6	9	0	169.00000000	1	\N	1	\N
166	2114	Terrains de gisement	 	2	1	7	9	0	170.00000000	1	\N	1	\N
167	21141	Carrières	 	1	1	6	9	0	171.00000000	1	\N	1	\N
168	2115	Terrains bâtis	 	2	1	7	1	0	172.00000000	1	\N	1	\N
646	61637	sur ventes	 	1	1	6	1	0	650.00000000	1	\N	1	\N
169	21151	Ensembles immobiliers industriels (A, B...)	 	1	1	6	9	0	173.00000000	1	\N	1	\N
170	21155	Ensembles immobiliers administratifs et commerciaux (A, B...)	 	1	1	6	9	0	174.00000000	1	\N	1	\N
171	21158	Autres ensembles immobiliers	 	1	1	7	9	0	175.00000000	1	\N	1	\N
172	211581	affectés aux opérations professionnelles (A, B...)	 	1	1	6	9	0	176.00000000	1	\N	1	\N
173	211588	affectés aux opérations non professionnelles (A, B...)	 	1	1	6	9	0	177.00000000	1	\N	1	\N
174	2116	Compte d'ordre sur immobilisations (art. 6 du décret n° 78-737 du 11 juillet 1978)	 	2	1	6	9	0	178.00000000	1	\N	1	\N
175	212	Agencements et aménagements de terrains (même ventilation que celle du compte 211)	Les dépenses faites en vue de l'aménagement des terrains, par exemple : clôtures, mouvements de terres, sont inscrites sous le compte 212 « Agencements et aménagements de terrains ».	2	1	6	9	0	179.00000000	1	\N	1	\N
176	213	Constructions	Le compte 213 « Constructions » comprend : - les bâtiments ; - les installations, agencements, aménagements ; - les ouvrages d'infrastructure.	3	1	7	9	0	180.00000000	1	\N	1	\N
177	2131	Bâtiments	 	2	1	7	9	0	181.00000000	1	\N	1	\N
178	21311	Ensembles immobiliers industriels (A, B...)	 	1	1	6	9	0	182.00000000	1	\N	1	\N
179	21315	Ensembles immobiliers administratifs et commerciaux (A, B...)	 	1	1	6	9	0	183.00000000	1	\N	1	\N
180	21318	Autres ensembles immobiliers	 	1	1	7	1	0	184.00000000	1	\N	1	\N
181	213181	affectés aux opérations professionnelles (A, B...)	 	1	1	6	9	0	185.00000000	1	\N	1	\N
182	213188	affectés aux opérations non professionnelles (A, B...)	 	1	1	6	1	0	186.00000000	1	\N	1	\N
183	2135	Installations générales - agencements - aménagements des constructions (même ventilation que celle du compte 2131)	 	2	1	6	9	0	187.00000000	1	\N	1	\N
184	2138	Ouvrages d'infrastructure	 	2	1	7	9	0	188.00000000	1	\N	1	\N
185	21381	Voies de terre	 	1	1	6	9	0	189.00000000	1	\N	1	\N
186	21382	Voies de fer	 	1	1	6	9	0	190.00000000	1	\N	1	\N
187	21383	Voies d'eau	 	1	1	6	9	0	191.00000000	1	\N	1	\N
188	21384	Barrages	 	1	1	6	9	0	192.00000000	1	\N	1	\N
189	21385	Pistes d'aérodromes	 	1	1	6	9	0	193.00000000	1	\N	1	\N
190	214	Constructions sur sol d'autrui (même ventilation que celle du compte 213)	Le compte 214 enregistre la valeur des constructions édifiées sur le sol d'autrui. Il comprend les mêmes subdivisions que le compte 213.	2	1	6	9	0	194.00000000	1	\N	1	\N
191	215	Installations techniques, matériels et outillage industriels	 	3	1	7	9	0	195.00000000	1	\N	1	\N
192	2151	Installations complexes spécialisées	 	2	1	7	9	0	196.00000000	1	\N	1	\N
193	21511	sur sol propre	 	1	1	6	9	0	197.00000000	1	\N	1	\N
194	21514	sur sol d'autrui	 	1	1	6	9	0	198.00000000	1	\N	1	\N
195	2153	Installations à caractère spécifique	 	2	1	7	9	0	199.00000000	1	\N	1	\N
196	21531	sur sol propre	 	1	1	6	9	0	200.00000000	1	\N	1	\N
197	21534	sur sol d'autrui	 	1	1	6	9	0	201.00000000	1	\N	1	\N
198	2154	Matériel industriel	 	2	1	6	9	0	202.00000000	1	\N	1	\N
199	2155	Outillage industriel	 	2	1	6	9	0	203.00000000	1	\N	1	\N
200	2157	Agencements et aménagements du matériel et outillage industriels	 	2	1	6	9	0	204.00000000	1	\N	1	\N
201	218	Autres immobilisations corporelles	Le compte 218 « Autres immobilisations corporelles » enregistre le montant des installations générales, agencements et aménagements divers financés par l'entité lorsqu'elle n'est pas propriétaire de ces éléments, c'est-à-dire, lorsqu'ls sont incorporés dans des immobilisations dont elle n'est pas propriétaire ou sur lesquelles elle ne dispose d'aucun autre droit réel.	3	1	7	9	0	205.00000000	1	\N	1	\N
202	2181	Installations générales, agencements, aménagements divers	 	2	1	6	9	0	206.00000000	1	\N	1	\N
203	2182	Matériel de transport	 	2	1	6	9	0	207.00000000	1	\N	1	\N
204	2183	Matériel de bureau et matériel informatique	 	2	1	6	9	0	208.00000000	1	\N	1	\N
205	2184	Mobilier	 	2	1	6	9	0	209.00000000	1	\N	1	\N
206	2185	Cheptel	 	2	1	6	9	0	210.00000000	1	\N	1	\N
207	2186	Emballages récupérables	 	2	1	6	9	0	211.00000000	1	\N	1	\N
208	22	IMMOBILISATIONS MISES EN CONCESSION	Les immobilisations incorporelles ou corporelles mises en concession par le concédant ou par le concessionnaire sont inscrites au compte 22 ; les immobilisations corporelles sont ventilées dans les mêmes conditions que celles inscrites au compte 21.	2	1	6	1	0	212.00000000	1	\N	1	\N
209	23	IMMOBILISATIONS EN COURS	Le compte 23 « Immobilisations en cours » a pour objet de faire apparaître la valeur des immobilisations non terminées à la fin de chaque exercice.	3	4	7	1	0	213.00000000	1	\N	1	\N
210	231	Immobilisations corporelles en cours	Du point de vue de leur origine, les immobilisations inscrites aux comptes 231 et 232 se répartissent\nen deux groupes :\n- celles qui sont créées par les moyens propres de l'entité ;\n- celles qui résultent des travaux de plus ou moins longue durée confiés à des tiers.\nLe coût des immobilisations créées par l'entité est porté au débit du compte 231 « Immobilisations\ncorporelles en cours » ou à celui du compte 232 « Immobilisations incorporelles en cours » par le\ncrédit du compte 72 « Production immobilisée ».	2	1	7	1	0	214.00000000	1	\N	1	\N
211	2312	Terrains	 	1	1	6	1	0	215.00000000	1	\N	1	\N
212	2313	Constructions	 	1	1	6	1	0	216.00000000	1	\N	1	\N
213	2315	Installations techniques, matériel et outillage industriels	 	1	1	6	1	0	217.00000000	1	\N	1	\N
214	2318	Autres immobilisations corporelles	 	1	1	6	1	0	218.00000000	1	\N	1	\N
243	272	Titres immobilisés (droit de créance)	 	2	1	7	1	0	247.00000000	1	\N	1	\N
244	2721	Obligations	 	1	1	6	1	0	248.00000000	1	\N	1	\N
245	2722	Bons	 	1	1	6	1	0	249.00000000	1	\N	1	\N
246	273	Titres immobilisés de l'activité de portefeuille	 	2	1	6	1	0	250.00000000	1	\N	1	\N
293	2932	Immobilisations incorporelles en cours	 	2	1	6	1	0	297.00000000	1	\N	1	\N
215	232	Immobilisations incorporelles en cours	Du point de vue de leur origine, les immobilisations inscrites aux comptes 231 et 232 se répartissent\nen deux groupes :\n- celles qui sont créées par les moyens propres de l'entité ;\n- celles qui résultent des travaux de plus ou moins longue durée confiés à des tiers.\nLe coût des immobilisations créées par l'entité est porté au débit du compte 231 « Immobilisations\ncorporelles en cours » ou à celui du compte 232 « Immobilisations incorporelles en cours » par le\ncrédit du compte 72 « Production immobilisée ».	2	1	6	1	0	219.00000000	1	\N	1	\N
216	237	Avances et acomptes versés sur immobilisations incorporelles	Lorsque les travaux sont confiés à des tiers, le compte 237 ou le compte 238 sont débités des\navances à la commande et des acomptes représentant les règlements partiels effectués par l'entité au\nfur et à mesure de l'avancement des travaux.\nLe coût d'une immobilisation est viré du compte 23 au compte 20 ou au compte 21 lorsque\nl'immobilisation est terminée.\nLes avances et acomptes versés par l'entité à des tiers pour des opérations en cours sont portés :\n- au compte 237 lorsqu'ils ont pour objet l'acquisition d'une immobilisation incorporelle ;\n- au compte 238 lorsqu'ils ont pour objet l'acquisition d'une immobilisation corporelle.\nEn cours d'exercice, les entités ont la faculté de comptabiliser toutes les avances et acomptes visés\nci-dessus dans le compte 4091 « Fournisseurs - Avances et acomptes versés sur commandes », mais\nen fin d'exercice, elles virent au compte 237 ou 238 les avances et acomptes concernant les\ncommandes d'immobilisations.\nLes avances et les acomptes peuvent être enregistrés séparément dans des subdivisions appropriées\ndes comptes 237 et 238.	2	1	6	1	0	220.00000000	1	\N	1	\N
217	238	Avances et acomptes versés sur commandes d'immobilisations corporelles	Lorsque les travaux sont confiés à des tiers, le compte 237 ou le compte 238 sont débités des\navances à la commande et des acomptes représentant les règlements partiels effectués par l'entité au\nfur et à mesure de l'avancement des travaux.\nLe coût d'une immobilisation est viré du compte 23 au compte 20 ou au compte 21 lorsque\nl'immobilisation est terminée.\nLes avances et acomptes versés par l'entité à des tiers pour des opérations en cours sont portés :\n- au compte 237 lorsqu'ils ont pour objet l'acquisition d'une immobilisation incorporelle ;\n- au compte 238 lorsqu'ils ont pour objet l'acquisition d'une immobilisation corporelle.\nEn cours d'exercice, les entités ont la faculté de comptabiliser toutes les avances et acomptes visés\nci-dessus dans le compte 4091 « Fournisseurs - Avances et acomptes versés sur commandes », mais\nen fin d'exercice, elles virent au compte 237 ou 238 les avances et acomptes concernant les\ncommandes d'immobilisations.\nLes avances et les acomptes peuvent être enregistrés séparément dans des subdivisions appropriées\ndes comptes 237 et 238.	2	1	7	1	0	221.00000000	1	\N	1	\N
218	2382	Terrains	 	1	1	6	1	0	222.00000000	1	\N	1	\N
219	2383	Constructions	 	1	1	6	1	0	223.00000000	1	\N	1	\N
220	2385	Installations techniques, matériel et outillage industriels	 	1	1	6	1	0	224.00000000	1	\N	1	\N
222	25	PARTS DANS DES ENTREPRISES LIEES ET CREANCES SUR DES ENTREPRISES LIEES	 	2	1	6	1	0	226.00000000	1	\N	1	\N
224	261	Titres de participation	Le compte 261 « Titres de participation » est débité de la valeur d'apport ou du coût d'acquisition,\npar le crédit, suivant le cas :\n- du compte 101 « Capital » ou du compte 456 « Associés - Opérations sur le capital » ;\n- du compte 404 « Fournisseurs d'immobilisations » ou du compte 269 « Versements\nrestant à effectuer sur titres de participation non libérés » ou des comptes financiers.\nIl est crédité, en cas de cession des titres, par le débit du compte 675 « Valeurs comptables des\néléments d'actif cédés ».	2	1	7	1	0	228.00000000	1	\N	1	\N
227	266	Autres formes de participation	Le compte 266 « Autres formes de participation » est débité du montant de la souscription ou de\nl'acquisition des parts d'un G.I.E. Si le G.I.E. n'a pas de capital, le compte 266 est débité pour\nmémoire.	2	1	6	1	0	231.00000000	1	\N	1	\N
228	267	Créances rattachées à des participations	Le compte 267 « Créances rattachées à des participations » regroupe les créances nées à l'occasion\nde prêts octroyés à des entités dans lesquelles le prêteur détient une participation.\nLes avances à un G.I.E. qui ne sont pas réalisables sont enregistrées au débit d'une subdivision du\ncompte 267 « Avances consolidables ».\nDans le cas où la souscription à une partie du capital d'une société entraîne ultérieurement, pour le\nsouscripteur, des versements obligatoires de fonds supplémentaires qui ne sont pas inscrits au\ncapital de cette société, lesdits versements sont enregistrés dans une subdivision du compte 267\nintitulée « Versements représentatifs d'apports non capitalisés (appel de fonds) ». Il en est ainsi, par\nexemple, en matière immobilière.	2	1	7	1	0	232.00000000	1	\N	1	\N
230	2674	Créances rattachées à des participations (hors groupe)	 	1	1	6	1	0	234.00000000	1	\N	1	\N
231	2675	Versements représentatifs d'apports non capitalisés (appel de fonds)	 	1	1	6	1	0	235.00000000	1	\N	1	\N
232	2676	Avances consolidables	 	1	1	6	1	0	236.00000000	1	\N	1	\N
233	2677	Autres créances rattachées à des participations	 	1	1	6	1	0	237.00000000	1	\N	1	\N
234	2678	Intérêts courus	 	1	1	6	1	0	238.00000000	1	\N	1	\N
235	268	Créances rattachées à des sociétés en participation	Le compte 268 « Créances rattachées à des sociétés en participation » est débité par le crédit du\ncompte 458 « Associés ' Opérations faites en commun ou en GIE », des droits que l'entité\ncoparticipante non gérante, détient sur les biens acquis ou créés par le gérant de la société en\nparticipation.\nLe compte 268 est crédité par le débit du compte 458 lors de la consommation des biens\nimmobilisés.\nLes intérêts courus à la fin de l'exercice sont inscrits dans des subdivisions des comptes 267 et 268.	2	1	7	1	0	239.00000000	1	\N	1	\N
236	2681	Principal	 	1	1	6	1	0	240.00000000	1	\N	1	\N
237	2688	Intérêts courus	 	1	1	6	1	0	241.00000000	1	\N	1	\N
238	269	Versements restant à effectuer sur titres de participation non libérés	Le compte 269 « Versements restant à effectuer sur les titres de participation non libérés » est\ncrédité du montant des versements restant à effectuer sur les titres de participation non libérés par le\ndébit du compte 261 « Titres de participation ».	2	1	6	1	0	242.00000000	1	\N	1	\N
239	27	AUTRES IMMOBILISATIONS FINANCIERES	 	3	4	7	1	0	243.00000000	1	\N	1	\N
240	271	Titres immobilisés autres que les titres immobilisés de l'activité de portefeuille (droit de propriété)	 	2	1	7	1	0	244.00000000	1	\N	1	\N
241	2711	Actions	 	1	1	6	1	0	245.00000000	1	\N	1	\N
242	2718	Autres titres	 	1	1	6	1	0	246.00000000	1	\N	1	\N
247	274	Prêts	L'ouverture de subdivisions des comptes 274 « Prêts », 275 « Dépôts et cautionnements » et 276\n« Autres créances immobilisées » permet d'identifier la partie de ces prêts et créances qui sera\nrécupérée à long, moyen et court terme, ainsi que les intérêts courus.\nLes titres conférant un droit de propriété donnés en nantissement ou faisant l'objet d'un blocage\ntemporaire supérieur à un an sont inscrits sous le compte 271 « Titres immobilisés autres que les\ntitres immobilisés de l'activité de portefeuille (droit de propriété) ».	2	1	7	1	0	251.00000000	1	\N	1	\N
248	2741	Prêts participatifs	 	1	1	6	1	0	252.00000000	1	\N	1	\N
249	2742	Prêts aux associés	 	1	1	6	1	0	253.00000000	1	\N	1	\N
250	2743	Prêts au personnel	 	1	1	6	1	0	254.00000000	1	\N	1	\N
251	2748	Autres prêts	 	1	1	6	1	0	255.00000000	1	\N	1	\N
252	275	Dépôts et cautionnements versés	 	2	1	7	1	0	256.00000000	1	\N	1	\N
253	2751	Dépôts	 	1	1	6	1	0	257.00000000	1	\N	1	\N
254	2755	Cautionnements	 	1	1	6	1	0	258.00000000	1	\N	1	\N
255	276	Autres créances immobilisées	 	2	1	7	1	0	259.00000000	1	\N	1	\N
256	2761	Créances diverses	 	1	1	6	1	0	260.00000000	1	\N	1	\N
257	2768	Intérêts courus	 	1	1	7	1	0	261.00000000	1	\N	1	\N
258	27682	Sur titres immobilisés (droit de créance)	 	1	1	6	1	0	262.00000000	1	\N	1	\N
259	27684	Sur prêts	 	1	1	6	1	0	263.00000000	1	\N	1	\N
260	27685	Sur dépôts et cautionnements	 	1	1	6	1	0	264.00000000	1	\N	1	\N
261	27688	Sur créances diverses	 	1	1	6	1	0	265.00000000	1	\N	1	\N
262	277	Actions propres ou parts propres	 	2	1	7	1	0	266.00000000	1	\N	1	\N
263	2771	Actions propres ou parts propres	 	1	1	6	1	0	267.00000000	1	\N	1	\N
264	2772	Actions propres ou parts propres en voie d'annulation	 	1	1	6	1	0	268.00000000	1	\N	1	\N
265	279	Versements restant à effectuer sur titres immobilisés non libérés	Le compte 279 « Versements restant à effectuer sur titres immobilisés non libérés » est crédité du\nmontant des versements restant à effectuer sur les titres immobilisés non libérés, par le débit du\ncompte 271.	2	1	6	1	0	269.00000000	1	\N	1	\N
266	28	AMORTISSEMENTS DES IMMOBILISATIONS	Les comptes d'amortissements des immobilisations sont crédités par le débit du compte 681\n« Dotations aux amortissements et aux provisions - Charges d'exploitation », du compte 686\n« Dotations aux amortissements et aux provisions - Charges financières », ou du compte 687\n« Dotations aux amortissements et aux provisions » - Charges exceptionnelles », notamment pour\ndes immobilisations non encore complètement amorties et mises au rebut.	3	1	7	1	0	270.00000000	1	\N	1	\N
267	280	Amortissements des immobilisations incorporelles	 	3	4	7	1	0	271.00000000	1	\N	1	\N
268	2801	Frais d'établissement (même ventilation que celle du compte 201)	 	2	1	6	1	0	272.00000000	1	\N	1	\N
270	2805	Concessions et droits similaires, brevets, licences, logiciels, droits et valeurs similaires	 	2	1	6	1	0	274.00000000	1	\N	1	\N
271	2807	Fonds commercial	 	2	1	6	1	0	275.00000000	1	\N	1	\N
272	2808	Autres immobilisations incorporelles	 	2	1	6	1	0	276.00000000	1	\N	1	\N
273	281	Amortissements des immobilisations corporelles	 	3	4	7	1	0	277.00000000	1	\N	1	\N
274	2811	Terrains de gisement	 	2	1	6	1	0	278.00000000	1	\N	1	\N
275	2812	Agencements, aménagements de terrains (même ventilation que celle du compte 212)	 	2	1	6	1	0	279.00000000	1	\N	1	\N
276	2813	 	 	1	1	1	1	1	280.00000000	1	\N	1	\N
277	2813	Constructions (même ventilation que celle du compte 213)	 	2	1	6	1	0	281.00000000	1	\N	1	\N
278	2814	Constructions sur sol d'autrui (même ventilation que celle du compte 214)	 	2	1	6	1	0	282.00000000	1	\N	1	\N
279	2815	Installations techniques, matériel et outillage industriels (même ventilation que celle du compte 215)	 	2	1	6	1	0	283.00000000	1	\N	1	\N
280	2818	Autres immobilisations corporelles (même ventilation que celle du compte 218)	 	2	1	6	1	0	284.00000000	1	\N	1	\N
281	282	Amortissements des immobilisations mises en concession	 	2	1	6	1	0	285.00000000	1	\N	1	\N
225	2611	Actions	 	1	1	6	1	0	229.00000000	1	\N	1	\N
226	2618	Autres titres	 	1	1	6	1	0	230.00000000	1	\N	1	\N
229	2671	Créances rattachées à des participations (groupe)	 	1	1	6	1	0	233.00000000	1	\N	1	\N
282	29	DEPRECIATIONS DES IMMOBILISATIONS (REGLEMENT N° 2002-10 DU CRC)	Lors de la constitution de dépréciations ou de l'augmentation de dépréciations déjà constituées, le\ncompte de dépréciations concerné est crédité par le débit du compte 681 « Dotations aux\namortissements et aux provisions - Charges d'exploitation », du compte 686 « Dotations aux\namortissements et aux provisions - Charges financières », ou du compte 687 « Dotations aux\namortissements et aux provisions - Charges exceptionnelles ».\nLors de l'annulation d'une provision devenue sans objet ou de la diminution de cette provision, le\ncompte de provision est débité par le crédit des subdivisions appropriées du compte 78 « Reprises\nsur amortissements et provisions ».\nA la date de cession de l'immobilisation, la dépréciation antérieurement constituée est soldée par le\ncrédit d'une subdivision appropriée du compte 78.	3	1	7	1	0	286.00000000	1	\N	1	\N
283	290	Dépréciations des immobilisations incorporelles	 	3	4	7	1	0	287.00000000	1	\N	1	\N
284	2905	Marques, procédés, droits et valeurs similaires	 	2	1	6	1	0	288.00000000	1	\N	1	\N
285	2906	Droit au bail	 	2	1	6	1	0	289.00000000	1	\N	1	\N
286	2907	Fonds commercial	 	2	1	6	1	0	290.00000000	1	\N	1	\N
287	2908	Autres immobilisations incorporelles	 	2	1	6	1	0	291.00000000	1	\N	1	\N
288	291	dépréciations des immobilisations corporelles (même ventilation que celle du compte 21)	 	3	4	7	1	0	292.00000000	1	\N	1	\N
289	2911	Terrains (autres que terrains de gisement)	 	2	1	6	1	0	293.00000000	1	\N	1	\N
290	292	dépréciations des immobilisations mises en concession	 	2	4	6	1	0	294.00000000	1	\N	1	\N
291	293	dépréciations des immobilisations en cours	 	3	4	7	1	0	295.00000000	1	\N	1	\N
292	2931	Immobilisations corporelles en cours	 	2	1	6	1	0	296.00000000	1	\N	1	\N
294	296	Provisions pour dépréciation des participations et créances rattachées à des participations	 	3	4	7	1	0	298.00000000	1	\N	1	\N
295	2961	Titres de participation	 	2	1	6	1	0	299.00000000	1	\N	1	\N
296	2966	Autres formes de participation	 	2	1	6	1	0	300.00000000	1	\N	1	\N
297	2967	Créances rattachées à des participations (même ventilation que celle du compte 267)	 	2	1	6	1	0	301.00000000	1	\N	1	\N
298	2968	Créances rattachées à des sociétés en participation (même ventilation que celle du compte 268)	 	2	1	6	1	0	302.00000000	1	\N	1	\N
299	297	Provisions pour dépréciation des autres immobilisations financières	 	3	4	7	1	0	303.00000000	1	\N	1	\N
300	2971	Titres immobilisés autres que les titres immobilisés de l'activité de portefeuille - droit de propriété (même ventilation que celle du compte 271)	 	2	1	6	1	0	304.00000000	1	\N	1	\N
301	2972	Titres immobilisés - droit de créance (même ventilation que celle du compte 272)	 	2	1	6	1	0	305.00000000	1	\N	1	\N
302	2973	Titres immobilisés de l'activité de portefeuille	 	2	1	6	1	0	306.00000000	1	\N	1	\N
303	2974	Prêts (même ventilation que celle du compte 274)	 	2	1	6	1	0	307.00000000	1	\N	1	\N
304	2975	Dépôts et cautionnements versés (même ventilation que celle du compte 275)	 	2	1	6	1	0	308.00000000	1	\N	1	\N
305	2976	Autres créances immobilisées (même ventilation que celle du compte 276)	 	2	1	6	1	0	309.00000000	1	\N	1	\N
306	31	MATIERES PREMIERES (ET FOURNITURES)	Les comptes 31 « Matières premières (et fournitures)	2	4	7	1	0	310.00000000	1	\N	1	\N
307	311	Matières (ou groupe) A	 	1	1	6	1	0	311.00000000	1	\N	1	\N
308	312	Matières (ou groupe) B	 	1	1	6	1	0	312.00000000	1	\N	1	\N
309	317	Fournitures A, B, C, ...	 	1	1	6	1	0	313.00000000	1	\N	1	\N
310	32	AUTRES APPROVISIONNEMENTS	32 « Autres approvisionnements »	3	4	7	1	0	314.00000000	1	\N	1	\N
311	321	Matières consommables	 	2	1	7	1	0	315.00000000	1	\N	1	\N
312	3211	Matières (ou groupe) C	 	1	1	6	1	0	316.00000000	1	\N	1	\N
313	3212	Matières (ou groupe) D	 	1	1	6	1	0	317.00000000	1	\N	1	\N
314	322	Fournitures consommables	 	2	1	7	1	0	318.00000000	1	\N	1	\N
316	3222	Produits d'entretien	 	1	1	6	1	0	320.00000000	1	\N	1	\N
317	3223	Fournitures d'atelier et d'usine	 	1	1	6	1	0	321.00000000	1	\N	1	\N
318	3224	Fournitures de magasin	 	1	1	6	1	0	322.00000000	1	\N	1	\N
319	3225	Fournitures de bureau	 	1	1	6	1	0	323.00000000	1	\N	1	\N
320	326	Emballages	 	2	1	7	1	0	324.00000000	1	\N	1	\N
321	3261	Emballages perdus	 	1	1	6	1	0	325.00000000	1	\N	1	\N
322	3265	Emballages récupérables non identifiables	 	1	1	6	1	0	326.00000000	1	\N	1	\N
323	3267	Emballages à usage mixte	 	1	1	6	1	0	327.00000000	1	\N	1	\N
324	33	EN-COURS DE PRODUCTION DE BIENS	Les comptes 33 « En-cours de production de biens	3	4	7	1	0	328.00000000	1	\N	1	\N
325	331	Produits en cours	 	2	1	7	1	0	329.00000000	1	\N	1	\N
326	3311	Produits en cours P 1	 	1	1	6	1	0	330.00000000	1	\N	1	\N
327	3312	Produits en cours P 2	 	1	1	6	1	0	331.00000000	1	\N	1	\N
328	335	Travaux en cours	 	2	1	7	1	0	332.00000000	1	\N	1	\N
329	3351	Travaux en cours T 1	 	1	1	6	1	0	333.00000000	1	\N	1	\N
330	3352	Travaux en cours T 2	 	1	1	1	1	0	334.00000000	1	\N	1	\N
331	34	EN-COURS DE PRODUCTION DE SERVICES	34 « En-cours de production de services »	3	4	7	1	0	335.00000000	1	\N	1	\N
332	341	Études en cours	 	2	1	7	1	0	336.00000000	1	\N	1	\N
333	3411	Études en cours E 1	 	1	1	6	1	0	337.00000000	1	\N	1	\N
334	3412	Études en cours E 2	 	1	1	6	1	0	338.00000000	1	\N	1	\N
335	345	Prestations de services en cours	 	2	1	7	1	0	339.00000000	1	\N	1	\N
336	3451	Prestations de services S 1	 	1	1	6	1	0	340.00000000	1	\N	1	\N
337	3452	Prestations de services S 2	 	1	1	6	1	0	341.00000000	1	\N	1	\N
338	35	STOCKS DE PRODUITS	35 « Stocks de produits » sont crédités du montant du stock initial par le débit des comptes 7133\n« Variation des en-cours de production de biens », 7134 « Variation des en-cours de production de\nservices », 7135 « Variation des stocks de produits ».	3	4	7	1	0	342.00000000	1	\N	1	\N
339	351	Produits intermédiaires	 	2	1	7	1	0	343.00000000	1	\N	1	\N
340	3511	Produits intermédiaires (ou groupe) A	 	1	1	6	1	0	344.00000000	1	\N	1	\N
341	3512	Produits intermédiaires (ou groupe) B	 	1	1	6	1	0	345.00000000	1	\N	1	\N
342	355	Produits finis	 	2	1	7	1	0	346.00000000	1	\N	1	\N
343	3551	Produits finis (ou groupe) A	 	1	1	6	1	0	347.00000000	1	\N	1	\N
344	3552	Produits finis (ou groupe) B	 	1	1	7	1	0	348.00000000	1	\N	1	\N
345	358	Produits résiduels (ou matières de récupération)	 	2	1	7	1	0	349.00000000	1	\N	1	\N
346	3581	Déchets	 	1	1	6	1	0	350.00000000	1	\N	1	\N
347	3585	Rebuts	 	1	1	6	1	0	351.00000000	1	\N	1	\N
348	3586	Matières de récupération	 	1	1	6	1	0	352.00000000	1	\N	1	\N
349	36	(compte à ouvrir, le cas échéant, sous l'intitulé « stocks provenant d'immobilisations »)	Le compte 36 « Stocks provenant d'immobilisations » peut enregistrer en cours d'exercice les\nentrées en stocks d'éléments démontés ou récupérés sur des immobilisations corporelles. Il est\ndébité par le crédit du compte 21 « Immobilisations corporelles ». En fin d'exercice, le compte 36\nest soldé par le débit du compte 603 « Variation des stocks (approvisionnements et\nmarchandises) ». Si des éléments de stocks visés ci-dessus subsistent à cette date, ils sont inscrits au\ndébit des comptes appropriés de la classe 3 par le crédit du compte 603.	2	1	6	1	0	353.00000000	1	\N	1	\N
350	37	STOCKS DE MARCHANDISES	 	2	4	7	1	0	354.00000000	1	\N	1	\N
351	371	Marchandises (ou groupe) A	 	1	1	6	1	0	355.00000000	1	\N	1	\N
352	372	Marchandises (ou groupe) B	 	1	1	6	1	0	356.00000000	1	\N	1	\N
353	38	(lorsque l'entité tient un inventaire permanent en comptabilité générale, le compte 38 peut être utilisé pour comptabiliser les stocks en voie d'acheminement, mis en dépôt ou donnés en consignation)	 	2	1	6	1	0	357.00000000	1	\N	1	\N
354	39	PROVISIONS POUR DEPRECIATION DES STOCKS ET EN-COURS	Les subdivisions du compte 39 « Provisions pour dépréciation des stocks et en-cours » sont\ncréditées par les subdivisions concernées du compte 68 « Dotations aux amortissements et aux\nprovisions » du montant des dépréciations, ou de leur augmentation, affectant les stocks et en-cours.\nElles sont débitées par le crédit des subdivisions concernées du compte 78 « Reprises sur\namortissements et provisions » du montant des provisions ou de leur quote-part devenues sans\nobjet.	3	1	7	1	0	358.00000000	1	\N	1	\N
355	391	Provisions pour dépréciation des matières premières (et fournitures)	 	2	4	7	1	0	359.00000000	1	\N	1	\N
356	3911	Matières (ou groupe) A	 	1	1	6	1	0	360.00000000	1	\N	1	\N
357	3912	Matières (ou groupe) B	 	1	1	6	1	0	361.00000000	1	\N	1	\N
358	3917	Fournitures A, B, C, ...	 	1	1	6	1	0	362.00000000	1	\N	1	\N
359	392	Provisions pour dépréciation des autres approvisionnements	 	2	4	7	1	0	363.00000000	1	\N	1	\N
360	3921	Matières consommables (même ventilation que celle du compte 321)	 	1	1	6	1	0	364.00000000	1	\N	1	\N
361	3922	Fournitures consommables (même ventilation que celle du compte 322)	 	1	1	6	1	0	365.00000000	1	\N	1	\N
362	3926	Emballages (même ventilation que celle du compte 326)	 	1	1	6	1	0	366.00000000	1	\N	1	\N
363	393	Provisions pour dépréciation des en-cours de production de biens	 	2	4	7	1	0	367.00000000	1	\N	1	\N
364	3931	Produits en cours (même ventilation que celle du compte 331)	 	1	1	6	1	0	368.00000000	1	\N	1	\N
365	3935	Travaux en cours (même ventilation que celle du compte 335)	 	1	1	6	1	0	369.00000000	1	\N	1	\N
366	394	Provisions pour dépréciation des en-cours de production de services	 	2	4	7	1	0	370.00000000	1	\N	1	\N
367	3941	Études en cours (même ventilation que celle du compte 341)	 	1	1	6	1	0	371.00000000	1	\N	1	\N
368	3945	Prestations de services en cours (même ventilation que celle du compte 345)	 	1	1	6	1	0	372.00000000	1	\N	1	\N
369	395	Provisions pour dépréciation des stocks de produits	 	2	4	7	1	0	373.00000000	1	\N	1	\N
370	3951	Produits intermédiaires (même ventilation que celle du compte 351)	 	1	1	6	1	0	374.00000000	1	\N	1	\N
375	40	FOURNISSEURS ET COMPTES RATTACHES	 	1	1	1	1	1	379.00000000	1	\N	1	\N
376	400	Fournisseurs et Comptes rattachés	 	2	4	6	1	0	380.00000000	1	\N	1	\N
377	401	Fournisseurs	Le compte 401 « Fournisseurs » est crédité du montant des factures d'achats de biens ou de\nprestations de services par le débit :\n- des comptes concernés de la classe 6 pour le montant hors taxes récupérables par\nl'entité ;	2	1	7	1	0	381.00000000	1	\N	1	\N
379	4017	Fournisseurs - Retenues de garantie	 	1	1	6	1	0	383.00000000	1	\N	1	\N
380	403	Fournisseurs - Effets à payer	 	2	1	6	1	0	384.00000000	1	\N	1	\N
381	404	Fournisseurs d'immobilisations	 	2	1	7	1	0	385.00000000	1	\N	1	\N
382	4041	Fournisseurs - Achats d'immobilisations	 	1	1	6	1	0	386.00000000	1	\N	1	\N
383	4047	Fournisseurs d'immobilisations - Retenues de garantie	 	1	1	6	1	0	387.00000000	1	\N	1	\N
384	405	Fournisseurs d'immobilisations - Effets à payer	 	2	1	6	1	0	388.00000000	1	\N	1	\N
385	408	Fournisseurs - Factures non parvenues	 	2	1	7	1	0	389.00000000	1	\N	1	\N
387	4084	Fournisseurs d'immobilisations	 	1	1	6	1	0	391.00000000	1	\N	1	\N
388	4088	Fournisseurs - Intérêts courus	 	1	1	6	1	0	392.00000000	1	\N	1	\N
389	409	Fournisseurs débiteurs	 	3	4	7	1	0	393.00000000	1	\N	1	\N
390	4091	Fournisseurs - Avances et acomptes versés sur commandes	Le compte 4091 « Fournisseurs - Avances et acomptes versés sur commandes » est crédité par le\ndébit du compte 401 et éventuellement du compte 404 après réception de la facture par l'entité. Il\nest débité, lors du paiement par l'entité d'avances sur commandes passées auprès des fournisseurs,\npar le crédit d'un compte de trésorerie. Les avances et acomptes versés sur commandes\nd'immobilisations inscrites en cours d'exercice au compte 4091 sont virés en fin d'exercice aux\ncomptes 237 ou 238.\nLe compte 4096 « Fournisseurs - Créances pour emballages et matériel à rendre » est débité par le\ncrédit du compte 401 lors de la consignation par les fournisseurs à l'entité d'emballages ou de\nmatériel, pour le montant de la consignation.\nIl est crédité :\n- par le débit du compte 401 lorsque l'entité rend les emballages ou le matériel au prix de\nla consignation ;\n- par le débit du compte 602 « Achats stockés - Autres approvisionnements » lorsque\nl'entité décide de conserver les emballages ou le matériel consignés ;\n- par le débit du compte 401 et de la subdivision du compte 613 intitulée « Malis sur\nemballages » si la reprise se fait pour un montant inférieur à celui de la consignation.\nLes soldes débiteurs des comptes fournisseurs d'exploitation et d'immobilisations autres que 4091,\n4096 et 4098 sont virés au débit du compte 4097 « Fournisseurs - Autres avoirs ».	2	1	6	1	0	394.00000000	1	\N	1	\N
391	4096	Fournisseurs - Créances pour emballages et matériel à rendre	du compte 4096 « Fournisseurs - Créances pour emballages et matériel à rendre » ;	2	1	6	1	0	395.00000000	1	\N	1	\N
392	4097	Fournisseurs - Autres avoirs	 	2	1	7	1	0	396.00000000	1	\N	1	\N
393	40971	Fournisseurs d'exploitation	 	1	1	6	1	0	397.00000000	1	\N	1	\N
394	40974 	Fournisseurs d'immobilisations	 	1	1	6	1	0	398.00000000	1	\N	1	\N
395	4098	Rabais, remises, ristournes à obtenir et autres avoirs non encore reçus	 	2	1	6	1	0	399.00000000	1	\N	1	\N
417	425	Personnel - Avances et acomptes	Le compte 425 « Personnel ' Avances et acomptes » est débité du montant des avances et acomptes\nversés au personnel, par le crédit d'un compte de trésorerie. Il est crédité, pour solde, par le débit du\ncompte 421.	2	1	6	1	0	421.00000000	1	\N	1	\N
418	426	Personnel - Dépôts	Le compte 426 « Personnel ' Dépôts » est crédité du montant des sommes confiées en dépôt à\nl'entité par les membres de son personnel, par le débit d'un compte de trésorerie. Il est débité, lors\ndu remboursement au personnel des sommes ainsi déposées, par le crédit d'un compte de trésorerie.	2	1	6	1	0	422.00000000	1	\N	1	\N
396	41	CLIENTS ET COMPTES RATTACHES	Les créances liées à la vente de biens ou services rattachés au cycle d'exploitation de l'entité sont\nenregistrées au compte 41 « Clients et comptes rattachés ».\nLe compte 411 « Clients » est débité du montant des factures de ventes de biens ou de prestations\nde services par le crédit :\n- de l'une des subdivisions du compte 70 « Ventes de produits fabriqués, prestations de\nservices, marchandises » pour le montant hors taxes collectées ;\n- du compte 4196 « Clients - Dettes pour emballages et matériel consignés » ;\n- du compte 4457 « Taxes sur le chiffre d'affaires collectées par l'entreprise ».\nLe compte 411 est crédité par le débit :\n- d'un compte de trésorerie lors des règlements reçus des clients ;\n- de l'une des subdivisions du compte 70 pour le montant des factures d'avoir établies par\nl'entité lors du retour de marchandises par les clients ;\n- du compte 413 « Clients - Effets à recevoir » lors de l'acceptation par les clients d'une\nlettre de change ou de la réception d'un billet à ordre ;\n- du compte 709 « Rabais, remises et ristournes accordées par l'entreprise » pour le\nmontant des réductions sur ventes accordées aux clients hors factures ;\n- du compte 4191 « Clients - Avances et acomptes reçus sur commandes » pour solde de ce\ndernier.	3	1	7	1	0	400.00000000	1	\N	1	\N
397	410	Clients et Comptes rattachés	 	2	4	6	1	0	401.00000000	1	\N	1	\N
398	411	Clients	 	2	1	7	1	0	402.00000000	1	\N	1	\N
399	4111	Clients - Ventes de biens ou de prestations de services	 	1	1	6	1	0	403.00000000	1	\N	1	\N
400	4117	Clients - Retenues de garantie	Le compte 4117 « Clients - Retenues de garantie » est débité, le cas échéant, du montant des\nretenues effectuées par les clients sur le prix convenu, jusqu'à l'échéance du terme de garantie\nprévu ; en contrepartie, le compte du client est crédité.	1	1	6	1	0	404.00000000	1	\N	1	\N
401	413	Clients - Effets à recevoir	Le compte 413 est débité par le crédit du compte 411 au moment de l'entrée des effets en\nportefeuille. Ce compte est crédité, à l'échéance de l'effet ou à la date de l'escompte, par le débit :\n- d'un compte de trésorerie ;\n- de la subdivision du compte 661 intitulée « Intérêts bancaires et sur opérations de\nfinancement (escompte, ...) ».	2	1	6	1	0	405.00000000	1	\N	1	\N
402	416	Clients douteux ou litigieux	Le compte 416 « Clients douteux ou litigieux » est débité par le crédit du compte 411 pour le\nmontant total des créances que l'entité possède à l'encontre de clients dont la solvabilité apparaît\ndouteuse ou avec lesquels l'entité est en litige.	2	1	6	1	0	406.00000000	1	\N	1	\N
403	418	Clients - Produits non encore facturés	Le compte 418 « Clients - Produits non encore facturés » est débité, à la clôture de la période\ncomptable, du montant, taxes comprises, des créances imputables à la période close et pour\nlesquelles les pièces justificatives n'ont pas encore été établies, par le crédit des comptes concernés\ndes classes 4 et 7.\nA l'ouverture de la période suivante, ces écritures sont contre-passées.\nToutefois, les entités peuvent également créditer directement le compte 418 par le débit du compte\n411 lors de l'établissement de la pièce justificative, les ajustements nécessaires étant enregistrés aux\ncomptes intéressés	2	1	7	1	0	407.00000000	1	\N	1	\N
408	4196	Clients - Dettes sur emballages et matériels consignés	Le compte 4196 « Clients - Dettes pour emballages et matériel consignés » est crédité des sommes\nfacturées par l'entité à ses clients au titre des consignations d'emballages ou de matériel par le débit\ndu compte 411.	2	1	6	1	0	412.00000000	1	\N	1	\N
409	4197	Clients - Autres avoirs	 	2	1	6	1	0	413.00000000	1	\N	1	\N
410	4198	Rabais, remises, ristournes à accorder et autres avoirs à établir	 	2	1	6	1	0	414.00000000	1	\N	1	\N
411	42	PERSONNEL ET COMPTES RATTACHES	 	3	1	7	1	0	415.00000000	1	\N	1	\N
378	4011	Fournisseurs - Achats de biens et prestations de services	 	1	1	6	1	0	382.00000000	1	\N	1	\N
386	4081	Fournisseurs	 	1	1	6	1	0	390.00000000	1	\N	1	\N
412	421	Personnel - Rémunérations dues	Le compte 421 « Personnel - Rémunérations dues » est crédité des rémunérations brutes à payer au\npersonnel par le débit des comptes de charges intéressés.\nIl est débité :\n- du montant des avances et acomptes versés au personnel par le crédit du compte 425\n« Personnel ' Avances et acomptes » ;\n- du montant des oppositions notifiées à l'entité à l'encontre des membres de son personnel\npar le crédit du compte 427 « Personnel ' Oppositions » ;\n- de la quote-part des charges sociales incombant au personnel par le crédit du compte 43\n« Sécurité sociale et autres organismes sociaux » ;\n- du montant des règlements effectués au personnel par le crédit d'un compte de trésorerie.	2	4	6	1	0	416.00000000	1	\N	1	\N
413	422	Comités d'entreprises, d'établissement,...	Le compte 422 « Comités d'entreprise, d'établissement, ' » est crédité du montant des sommes\nmises à la disposition des comités d'entreprise, d'établissement ou autres, par le débit des\nsubdivisions du compte 647 intitulées « Versements aux comités d'entreprise et d'établissement »,\n« Versements aux comités d'hygiène et de sécurité ». Il est débité du montant des versements\neffectués à ces comités par le crédit d'un compte de trésorerie.	2	1	6	1	0	417.00000000	1	\N	1	\N
414	424	Participation des salariés aux résultats	Le compte 424 « Participation des salariés aux résultats » enregistre le montant des sommes\nattribuées aux salariés au titre de la participation aux résultats, après la date d'approbation des\ncomptes par l'assemblée générale ordinaire des actionnaires au cours de l'exercice suivant celui au\ntitre duquel la participation est attribuée, ou à la date de validité du contrat de participation si elle\nest postérieure à celle de l'assemblée générale.\nSelon la nature des emplois, une subdivision du compte 424 est débitée par le crédit des comptes\nsuivants :\n- en cas d'attribution d'actions ou de coupures d'actions de la société par incorporation de\nréserves au capital :\n- 101 « Capital social », et\n- 104 « Primes liées au capital social » ;\n\n- en cas d'attribution d'actions rachetées par la société :\n- 502 « Actions propres », compte au débit duquel les actions ont été enregistrées lors\ndu rachat ;\n- en cas de création d'un fonds dans l'entité :\n- subdivision du compte 166 intitulée « Fonds de participation » ;\n- en cas de versement à des organismes de placement étrangers à l'entité et d'achats\nd'actions de sociétés d'investissement à capital variable (SICAV) ou versement au dépositaire du\nfonds commun de placement, dans le cadre du plan d'épargne d'entreprise :\n- compte de trésorerie concerné.\nL'éventuel reliquat de fonds non attribué, par suite de l'existence d'un plafond pour chaque\nbénéficiaire, est maintenu à la subdivision concernée du compte 424.\nLa prise en charge par l'employeur des frais de gestion de l'organe de placement gérant les fonds\ndéposés dans le cadre de la participation des salariés ou du plan d'épargne d'entreprise est\nenregistrée au compte de charges externes 628 « Divers ».\nLa participation de l'employeur au plan d'épargne d'entreprise en un versement complémentaire\nappelé « abondement » constitue une charge de personnel inscrite au compte 647 « Autres charges\nsociales ».\nLorsque les fonds ne sont pas utilisés, par suite d'absence d'accord entre les employeurs et les\nsalariés, ils sont virés du compte 424 à la subdivision du compte 166 « Comptes bloqués ».\nLorsque les fonds deviennent disponibles, la dette inscrite au compte 166 au titre des comptes\nbloqués ou des fonds	2	1	7	1	0	418.00000000	1	\N	1	\N
415	4246	Réserve spéciale (art. L. 442-2 du Code du travail)	 	1	1	6	1	0	419.00000000	1	\N	1	\N
416	4248	Comptes courants	 	1	1	6	1	0	420.00000000	1	\N	1	\N
500	468	Divers - Charges à payer et produits à recevoir	 	1	1	7	1	0	504.00000000	1	\N	1	\N
502	4687	Produits à recevoir	 	1	1	6	1	0	506.00000000	1	\N	1	\N
419	427	Personnel - Oppositions	Le compte 427 « Personnel ' Oppositions » est crédité du montant des sommes faisant l'objet\nd'oppositions obtenues par des tiers à l'encontre de membres du personnel de l'entité, par le débit\ndu compte 421 « Personnel ' Rémunérations dues ». Il est débité du montant desdites sommes, lors\nde leur versement aux tiers bénéficiaires de l'opposition, par le crédit d'un compte de trésorerie.\nA la fin de l'exercice, au moment des écritures d'inventaire qui ont notamment pour objet\nl'enregistrement des charges et des produits afférents à la gestion de l'exercice clos, l'entité :\n- crédite les subdivisions du compte 428 « Personnel ' Charges à payer et produits à\nrecevoir » correspondant notamment au montant des dettes potentielles relatives aux\ncongés à payer et à la participation des salariés aux résultats par le débit de la subdivision\ndu compte 641 intitulée « Congés payés » et du compte 691 « Participation des salariés\naux résultats » ;\n- débite les subdivisions éventuelles du compte 428 par le crédit des comptes de produits\nintéressés.	2	1	6	1	0	423.00000000	1	\N	1	\N
420	428	Personnel - Charges à payer et produits à recevoir	 	2	4	7	1	0	424.00000000	1	\N	1	\N
421	4282	Dettes provisionnées pour congés à payer	 	1	1	6	1	0	425.00000000	1	\N	1	\N
422	4284	Dettes provisionnées pour participation des salariés aux résultats	 	1	1	6	1	0	426.00000000	1	\N	1	\N
423	4286	Autres charges à payer	 	1	1	1	1	1	427.00000000	1	\N	1	\N
424	4287	Produits à recevoir	 	1	1	6	1	0	428.00000000	1	\N	1	\N
425	43	SECURITE SOCIALE ET AUTRES ORGANISMES SOCIAUX	 	3	4	7	1	0	429.00000000	1	\N	1	\N
426	431	Sécurité sociale	Les comptes 431 »Sécurité sociale » et 437 « Autres organismes sociaux » sont crédités\nrespectivement du montant :\n- des sommes dues par l'entité à la Sécurité sociale ainsi qu'aux différents organismes\nsociaux au titre des cotisations patronales d'assurances sociales, d'allocations familiales,\nd'accidents du travail, de retraites du personnel par le débit des comptes de charges par\nnature intéressés ;\n- des sommes à régler aux organismes susvisés pour le compte du personnel par le débit du\ncompte 421 « Personnel - Rémunérations dues ».\nIls sont débités des règlements effectués à ces organismes par le crédit d'un compte de trésorerie.\nDans l'hypothèse où, conformément aux dispositions de certains accords de salaires, conventions\ncollectives ou contrats de travail individuels, l'entité a réglé à ses employés tout ou partie de leur\nrémunération en cas de maladie, d'accident ou de maternité, le compte\n4387 « Produits à recevoir » est débité du montant des diverses prestations qu'elle a ainsi avancées\nà ses salariés pour le compte de la Sécurité sociale et des autres organismes sociaux par le crédit du\ncompte 641 « Rémunérations du personnel ».	2	1	6	1	0	430.00000000	1	\N	1	\N
407	4191	Clients - Avances et acomptes reçus sur commandes	Le compte 4191 « Clients ' Avances et acomptes reçus sur commandes » enregistre les avances et\nacomptes reçus par l'entité sur les commandes à livrer, les travaux à exécuter ou les services à\nrendre. Il est crédité par le débit d'un compte de trésorerie du montant des avances et acomptes\nreçus des clients. Il est débité, après l'établissement de la facture, du montant de ces avances et\nacomptes par le crédit du compte 411.	2	1	6	1	0	411.00000000	1	\N	1	\N
427	437	Autres organismes sociaux	Les comptes 431 »Sécurité sociale » et 437 « Autres organismes sociaux » sont crédités\nrespectivement du montant :\n- des sommes dues par l'entité à la Sécurité sociale ainsi qu'aux différents organismes\nsociaux au titre des cotisations patronales d'assurances sociales, d'allocations familiales,\nd'accidents du travail, de retraites du personnel par le débit des comptes de charges par\nnature intéressés ;\n- des sommes à régler aux organismes susvisés pour le compte du personnel par le débit du\ncompte 421 « Personnel - Rémunérations dues ».\nIls sont débités des règlements effectués à ces organismes par le crédit d'un compte de trésorerie.\nDans l'hypothèse où, conformément aux dispositions de certains accords de salaires, conventions\ncollectives ou contrats de travail individuels, l'entité a réglé à ses employés tout ou partie de leur\nrémunération en cas de maladie, d'accident ou de maternité, le compte\n4387 « Produits à recevoir » est débité du montant des diverses prestations qu'elle a ainsi avancées\nà ses salariés pour le compte de la Sécurité sociale et des autres organismes sociaux par le crédit du\ncompte 641 « Rémunérations du personnel ».	2	1	6	1	0	431.00000000	1	\N	1	\N
428	438	Organismes sociaux - Charges à payer et produits à recevoir	 	2	1	7	1	0	432.00000000	1	\N	1	\N
430	4386	Autres charges à payer	 	1	1	6	1	0	434.00000000	1	\N	1	\N
431	4387	Produits à recevoir	 	1	1	6	1	0	435.00000000	1	\N	1	\N
432	44	ETAT ET AUTRES COLLECTIVITES PUBLIQUES	Les opérations à inscrire au compte 44 « Etat et autres collectivités publiques » sont celles qui sont\nfaites avec l'Etat, les collectivités publiques et les organismes internationaux à caractère officiel,\nconsidérés en tant que puissance publique, à l'exception par conséquent des ventes et des achats qui\ns'inscrivent au compte 40 « Fournisseurs et comptes rattachés » et 41 « Clients et comptes\nrattachés » au même titre que les opérations faites avec les autres fournisseurs et les autres clients.\nEn fin d'exercice, lorsque des subventions accordées à l'entité n'ont pas encore été perçues, le\ncompte 441 « Etat - Subventions à recevoir » est débité :\n- du montant des subventions d'investissement à recevoir par le crédit du compte 13\n« Subventions d'investissement » ;\n- du montant des subventions d'exploitation à recevoir par le crédit du compte 74\n« Subventions d'exploitation ».\n- du montant des subventions d'équilibre à recevoir par la subdivision du compte 771\nintitulée « Subventions d'équilibre ».	3	1	7	1	0	436.00000000	1	\N	1	\N
433	441	Etat - Subventions à recevoir	Le compte 441 est crédité par le débit d'un compte de trésorerie lors de la réception des subventions\nsusvisées.	2	1	7	1	0	437.00000000	1	\N	1	\N
434	4411	Subventions d'investissement	 	1	1	6	1	0	438.00000000	1	\N	1	\N
435	4417	Subventions d'exploitation	 	1	1	6	1	0	439.00000000	1	\N	1	\N
436	4418	Subventions d'équilibre	 	1	1	6	1	0	440.00000000	1	\N	1	\N
437	4419	Avances sur subventions	 	1	1	6	1	0	441.00000000	1	\N	1	\N
438	442	État - Impôts et taxes recouvrables sur des tiers	Le compte 442 « Etat - Impôts et taxes recouvrables sur des tiers » est crédité des retenues\neffectuées par l'entité pour le compte de l'Etat sur des sommes dues à des tiers par le débit de leurs\ncomptes.	2	1	7	1	0	442.00000000	1	\N	1	\N
439	4424	Obligataires	 	1	1	6	1	0	443.00000000	1	\N	1	\N
440	4425	Associés	 	1	1	6	1	0	444.00000000	1	\N	1	\N
527	4955	Comptes courants des associés	 	2	1	6	1	0	531.00000000	1	\N	1	\N
441	443	Opérations particulières avec l'État les collectivités publiques, les organismes internationaux	Le compte 443 « Opérations particulières avec l'Etat » enregistre notamment les produits ou\ncharges résultant d'avantages accordés ou de sujétions imposées à une entité par l'Etat, les\ncollectivités publiques, les organismes internationaux.\nLa créance sur l'Etat résultant de la suppression de la règle du décalage d'un mois en matière de\nTVA est enregistrée dans un compte spécifique : le compte 4431 « Créances sur l'Etat résultant de\nla suppression de la règle du décalage d'un mois en matière de TVA ». Les intérêts courus sur cette\ncréance sont enregistrés au compte 4438 « Intérêts courus sur créances figurant au 4431 ».	3	1	7	1	0	445.00000000	1	\N	1	\N
442	4431	Créances sur l'Etat résultant de la suppression de la règle du décalage d'un mois en matière de T.V.A.	 	2	1	6	1	0	446.00000000	1	\N	1	\N
443	4438	Intérêts courus sur créances figurant au compte 4431	 	2	1	6	1	0	447.00000000	1	\N	1	\N
444	444	État - Impôts sur les bénéfices	Le compte 444 « État - Impôts sur les bénéfices » est crédité du montant des impôts sur les\nbénéfices dus à l'État par le débit du compte 695 « Impôts sur les bénéfices ». Il est débité du\nmontant des acomptes et du solde des règlements effectués au Trésor par le crédit d'un compte de\ntrésorerie. Le règlement de l'impôt forfaitaire annuel dû par les sociétés est comptabilisé\ninitialement comme une avance sur impôt au débit du compte 444 par le crédit d'un compte de\ntrésorerie.\nLe compte 444 est également débité du montant de la créance résultant du report en arrière du\ndéficit par le crédit du compte 699 « Produits - Report en arrière des déficits ».	2	4	6	1	0	448.00000000	1	\N	1	\N
445	445	État - Taxes sur le chiffre d'affaires	Le compte 445 « Etat - Taxes sur le chiffre d'affaires » reçoit d'une part le montant des taxes\ncollectées pour le compte de l'Etat, et, d'autre part, le montant des taxes à récupérer.\n\n\n- des comptes 445 « Etat ' Taxes sur le chiffre d'affaires » et 447 « Autres impôts, taxes et\nversements assimilés »	3	4	7	1	0	449.00000000	1	\N	1	\N
446	4452	T.V.A. due intracommunautaire	Un compte spécifique 4452 « TVA due intracommunautaire » enregistre la TVA\nintracommunautaire.	2	1	6	1	0	450.00000000	1	\N	1	\N
447	4455	Taxes sur le chiffre d'affaires à décaisser	 	2	1	7	1	0	451.00000000	1	\N	1	\N
448	44551	T.V.A. à décaisser	 	1	1	6	1	0	452.00000000	1	\N	1	\N
449	44558	Taxes assimilées à la T.V.A.	 	1	1	6	1	0	453.00000000	1	\N	1	\N
450	4456	Taxes sur le chiffre d'affaires déductibles	du compte 4456 « Taxes sur le chiffre d'affaires déductibles » pour le montant des taxes\nrécupérables par l'entité.\n\n\nLa TVA déductible sur achats de biens et services constitue une créance sur le Trésor public\nenregistrée au débit du compte 4456 « Taxes sur le chiffre d'affaires déductibles ». Les souscomptes\nsuivants peuvent être ouverts pour tenir compte des modalités particulières de\nrécupération :\n- 44562 « TVA sur immobilisations »	2	1	7	1	0	454.00000000	1	\N	1	\N
451	44562	T.V.A. sur immobilisations	 	1	1	6	1	0	455.00000000	1	\N	1	\N
452	44563	T.V.A. transférée par d'autres entreprises	 	1	1	6	1	0	456.00000000	1	\N	1	\N
453	44566	T.V.A. sur autres biens et services	- 44566 « TVA sur autres biens et services »,	1	1	6	1	0	457.00000000	1	\N	1	\N
454	44567	Crédit de T.V.A. à reporter	 	1	1	6	1	0	458.00000000	1	\N	1	\N
455	44568	Taxes assimilées à la T.V.A.	- 44568 « Taxes assimilées à la TVA ».	1	1	6	1	0	459.00000000	1	\N	1	\N
456	4457	Taxes sur le chiffre d'affaires collectées par l'entreprise	La TVA collectée par l'entité constitue une dette envers le Trésor public. Elle est enregistrée au\ncrédit du compte 4457 « Taxes sur le chiffre d'affaires collectées par l'entreprise ».	2	1	7	1	0	460.00000000	1	\N	1	\N
457	44571	T.V.A. collectée	 	1	1	6	1	0	461.00000000	1	\N	1	\N
458	44578	Taxes assimilées à la T.V.A.	 	1	1	6	1	0	462.00000000	1	\N	1	\N
459	4458	Taxes sur le chiffre d'affaires à régulariser ou en attente	 	2	1	7	1	0	463.00000000	1	\N	1	\N
460	44581	Acomptes - Régime simplifié d'imposition	 	1	1	6	1	0	464.00000000	1	\N	1	\N
461	44582	Acomptes - Régime du forfait	 	1	1	6	1	0	465.00000000	1	\N	1	\N
462	44583	Remboursement de taxes sur le chiffre d'affaires demandé	 	1	1	6	1	0	466.00000000	1	\N	1	\N
463	44584	T.V.A. récupérée d'avance	 	1	1	6	1	0	467.00000000	1	\N	1	\N
464	44586	Taxes sur le chiffre d'affaires sur factures non parvenues	 	1	1	6	1	0	468.00000000	1	\N	1	\N
465	44587	Taxes sur le chiffres d'affaires sur factures à établir	 	1	1	6	1	0	469.00000000	1	\N	1	\N
466	446	Obligations cautionnées	Le compte 446 « Obligations cautionnées » est crédité du montant des obligations cautionnées\nsouscrites en règlement des taxes par le débit	2	1	6	1	0	470.00000000	1	\N	1	\N
467	447	Autres impôts, taxes et versements assimilés	Le compte 447 « Autres impôts, taxes et versements assimilés » est crédité du montant de tous les\nautres impôts et taxes dus par l'entité par le débit des comptes de charges intéressés.	2	4	6	1	0	471.00000000	1	\N	1	\N
468	448	État - Charges à payer et produits à recevoir	 	2	1	7	1	0	472.00000000	1	\N	1	\N
469	4482	Charges fiscales sur congés à payer	 	1	1	6	1	0	473.00000000	1	\N	1	\N
471	4487	Produits à recevoir	 	1	1	6	1	0	475.00000000	1	\N	1	\N
472	449	Quotas d'émission à restituer à l'Etat (Règlement n°2004-08 du CRC)	 	2	1	6	1	0	476.00000000	1	\N	1	\N
473	45	GROUPE ET ASSOCIES	 	3	5	7	1	0	477.00000000	1	\N	1	\N
474	451	Groupe	Le compte 451 « Groupe » enregistre à sont débit le montant des fonds avancés directement ou\nindirectement de façon temporaire par l'entité aux sociétés du groupe, et à son crédit le montant des\nfonds mis directement ou indirectement à disposition de l'entité par les sociétés du groupe.	2	1	6	1	0	478.00000000	1	\N	1	\N
475	455	Associés - Comptes courants	Le compte 455 « Associés ' Comptes courants » enregistre à son crédit le montant des fonds mis ou\nlaissés temporairement à la disposition de l'entité par les associés.	2	4	6	1	0	479.00000000	1	\N	1	\N
476	4551	Principal	 	1	1	6	1	0	480.00000000	1	\N	1	\N
477	4558	Intérêts courus	 	1	1	6	1	0	481.00000000	1	\N	1	\N
528	4958	Opérations faites en commun et en G.I.E.	 	2	1	6	1	0	532.00000000	1	\N	1	\N
478	456	Associés - Opérations sur le capital	Le compte 456 « Associés - Opérations sur le capital » est subdivisé afin d'enregistrer distinctement\nles opérations relatives à la création de l'entité ou à la modification de son capital :	2	1	7	1	0	482.00000000	1	\N	1	\N
479	4561	Associés - Comptes d'apport en société	- le compte 4561 « Associés - Comptes d'apport en société » est débité du montant de la\npromesse d'apport faite en espèce ou en nature, par les associés par le crédit des subdivisions\nconcernées du compte 101 « Capital » ; il est crédité par le débit des comptes retraçant les apports ;	1	1	7	1	0	483.00000000	1	\N	1	\N
480	45611	Apports en nature	 	1	1	6	1	0	484.00000000	1	\N	1	\N
481	45615	Apports en numéraire	 	1	1	6	1	0	485.00000000	1	\N	1	\N
482	4562	Apporteurs - Capital appelé, non versé	le compte 4562 « Apporteurs - Capital appelé, non versé » est débité par le crédit du\ncompte 109 « Actionnaires : Capital souscrit - non appelé » lors des appels successifs du capital ; il est\ncrédité lors de la réalisation de l'apport par le débit du ou des comptes d'actifs concernés ;	1	1	7	1	0	486.00000000	1	\N	1	\N
483	45621	Actionnaires - Capital souscrit et appelé, non versé	 	1	1	6	1	0	487.00000000	1	\N	1	\N
484	45625	Associés - Capital appelé, non versé	 	1	1	6	1	0	488.00000000	1	\N	1	\N
470	4486	Charges à payer	 	1	1	6	1	0	474.00000000	1	\N	1	\N
485	4563	Associés - Versements reçus sur augmentation de capital	- le compte 4563 « Associés - Versements reçus sur augmentation de capital » reçoit à son\ncrédit la contrepartie des versements effectués par les associés à la suite de la décision d'augmentation\ndu capital ; il est débité à la clôture de la période de réalisation de l'opération soit par le crédit des\nsubdivisions concernées des comptes 101 « Capital » et 104 « Primes liées au capital », lorsque\nl'augmentation devient effective, soit par le crédit d'un compte d'associé, lorsque la modification du\ncapital est annulée pour défaut de réalisation du quantum ;	1	1	6	1	0	489.00000000	1	\N	1	\N
486	4564	Associés - Versements anticipés	- le compte 4564 « Associés - Versements anticipés » reçoit à son crédit le montant des\napports que certains associés mettent à la disposition de l'entité préalablement aux appels de capital ; il\ns'apure au fur et à mesure de ces appels ;	1	1	6	1	0	490.00000000	1	\N	1	\N
487	4566	Actionnaires défaillants	- le compte 4566 « Actionnaires défaillants » est utilisé afin de régulariser la situation des\nactionnaires qui ne se sont pas acquittés de leurs obligations lors d'un appel de capital	1	1	6	1	0	491.00000000	1	\N	1	\N
490	4567	Associés - Capital à rembourser	- le compte 4567 « Associés - Capital à rembourser » est crédité des sommes dues aux\nassociés à la suite de la décision d'amortissement d'une fraction du capital.	1	1	6	1	0	494.00000000	1	\N	1	\N
491	457	Associés - Dividendes à payer	Le compte 457 « Associés - Dividendes à payer » est crédité du montant des dividendes\ndont la distribution a été décidée par les organes compétents, par le débit :\n- du compte 12 « Résultat de l'exercice » ;\n- du compte 11 « Report à nouveau » ;\n- du compte 106 « Réserves » pour les réserves dont la distribution ne fait pas l'objet d'une\ninterdiction.	2	1	6	1	0	495.00000000	1	\N	1	\N
492	458	Associés - Opérations faites en commun et en G.I.E.	Le compte 458 « Associés - Opérations faites en commun et en G.I.E. » enregistre les opérations\nfaites par l'intermédiaire d'une société en participation ou d'un G.I.E. selon les modalités\nsuivantes :\nLe compte 458 enregistre les mises de fonds entre coparticipants.\nLe gérant, propriétaire des biens acquis ou créés dans le cadre d'une société en participation,\nenregistre au débit du compte 458 la part des autres coparticipants par le crédit du compte 178\n« Dettes rattachées à des sociétés en participation ». Les coparticipants non gérants enregistrent leur\npart dans ces biens au débit du compte 268 « Créances rattachées à des sociétés en participation »\npar le crédit du compte 458. La constatation de la consommation des biens immobilisés par suite\ndes opérations d'exploitation faites en société en participation se traduit au niveau des comptes 178\net 268 par une réduction d'un même montant des obligations et des droits respectifs du gérant et des\nnon gérants :\n- le compte 178 est alors débité par le crédit du compte 458 dans la comptabilité du gérant,\n- le compte 268 est crédité par le débit du compte 458 dans la comptabilité des non gérants.\nLorsque la comptabilité de la société en participation est exclusivement tenue par un gérant, la\nquote-part des résultats revenant aux autres coparticipants est enregistrée dans la comptabilité du\ngérant au débit du compte 655 « Quote-parts du résultat sur opérations faites en commun » par le\ncrédit du compte 458, s'il s'agit d'un bénéfice ou au crédit du compte 755 « Quote-parts du résultat\nsur opérations faites en commun » par le débit du compte 458, s'il s'agit d'une perte.\nSymétriquement, la quote-part de résultat revenant à chaque coparticipant non gérant est enregistrée\ndans leur comptabilité aux comptes 755 ou 655 par le débit ou le crédit du\ncompte 458.\n\nLe compte 458 enregistre les opérations faites en G.I.E. autres que les acquisitions ou les\nsouscriptions de parts et les avances non réalisables qui sont respectivement enregistrées aux\ncomptes 266 « Autres formes de participations » et 267 « Créances rattachées à des participations ».\nLes cotisations versées à un G.I.E. en fonction des services rendus à l'entité constituent des charges\nd'exploitation à débiter aux comptes de sous-traitance intéressés par le crédit d'une subdivision du\ncompte 458. Si elles sont versées sous la forme d'abonnements ou de provisions, une régularisation\nest effectuée en fin d'exercice par l'intermédiaire du compte 468 « Charges à payer et produits à\nrecevoir » ou 486 « Charges constatées d'avance ».	2	1	7	1	0	496.00000000	1	\N	1	\N
495	46	DEBITEURS DIVERS ET CREDITEURS DIVERS	Lors de la cession d'immobilisations autres que les TIAP, le compte 462 « Créances sur cessions\nd'immobilisations » est débité du prix de cession des éléments d'actif cédés, par le crédit du compte\n775 « Produits des cessions d'éléments d'actif » ; simultanément, le compte d'immobilisations\nconcerné est crédité par le débit du compte 675 « Valeurs comptables des éléments d'actif cédés » ;\nles amortissements en sont déduits.\nLors de la cession de TIAP, le compte 462 est débité du prix de cession des TIAP, par le crédit :\n- du compte 775, lorsque la cession est génératrice d'un profit ; simultanément, le compte\n273 « Titres immobilisés de l'activité de portefeuille » est crédité par le débit du compte 775 ;\n- du compte 675, lorsque la cession est génératrice d'une perte ; simultanément, le compte\n273 est crédité par le débit du compte 675.	2	4	7	1	0	499.00000000	1	\N	1	\N
497	464	Dettes sur acquisitions de valeurs mobilières de placement	Le compte 464 « Dettes sur acquisitions de valeurs mobilières de placement » enregistre à son\ncrédit le montant des dettes relatives à l'acquisition de valeurs mobilières de placement ; le compte\n50 « Valeurs mobilières de placement » est débité en contrepartie.\nLes opérations dont le solde peut être indifféremment soit débiteur, soit créditeur sont\ncomptabilisées à des subdivisions ouvertes sous le compte 467 « Autres comptes débiteurs ou\ncréditeurs ».\nLa subdivision du compte 468 intitulée « Produits à recevoir » est débitée, notamment, des\nindemnités à recevoir consécutives à des sinistres ou litiges par le crédit des comptes de produits\nintéressés	1	1	6	1	0	501.00000000	1	\N	1	\N
498	465	Créances sur cessions de valeurs mobilières de placement	Lors de la cession de valeurs mobilières de placement, le compte 465 « Créances sur cessions de\nvaleurs mobilières de placement » est débité, par le crédit :\n- du compte 767 « Produits nets sur cessions de valeurs mobilières de placement », lorsque\nla cession est génératrice d'un profit ; simultanément, le compte 50 « Valeurs mobilières de\nplacement » est crédité par le débit du compte 767 ;\n- du compte 667 « Charges nettes sur cessions de valeurs mobilières de placement »,\nlorsque la cession est génératrice d'une perte ; simultanément, le compte 50 « Valeurs mobilières de\nplacement » est crédité par le débit du compte 667.	1	1	6	1	0	502.00000000	1	\N	1	\N
503	47	COMPTES TRANSITOIRES OU D'ATTENTE	Les opérations qui ne peuvent pas être imputées de façon certaine à un compte déterminé au\nmoment où elles sont enregistrées ou qui exigent une information complémentaire, sont inscrites\nprovisoirement dans les subdivisions 471 à 475 « Comptes d'attente » du compte 47 « Comptes\ntransitoires ou d'attente ».\nCe procédé de comptabilisation ne sera utilisé qu'à titre exceptionnel. Toute opération portée au\ncompte 47 sera imputée au compte définitif dans les moindres délais possibles.\nLes comptes divisionnaires à prévoir, le cas échéant, à l'intérieur du compte 47 seront ouverts sous\ndes intitulés précisant leur objet.\nLes opérations inscrites dans ces comptes sont reclassées en fin d'exercice parmi les comptes\nfigurant au modèle de bilan.	3	4	7	1	0	507.00000000	1	\N	1	\N
504	471	Comptes d'attente	 	2	1	6	1	0	508.00000000	1	\N	1	\N
493	4581	Opérations courantes	 	1	1	6	1	0	497.00000000	1	\N	1	\N
494	4588	Intérêts courus	 	1	1	6	1	0	498.00000000	1	\N	1	\N
496	462	Créances sur cessions d'immobilisations	 	1	1	6	1	0	500.00000000	1	\N	1	\N
505	476	Différence de conversion - ACTIF	Les comptes 476 « Différences de conversion ' ACTIF » et 477 « Différences de conversion '\nPASSIF » enregistrent les différences de conversion résultant de l'actualisation, au taux de change\nde fin d'exercice, des comptes de créances et de dettes libellées en monnaies étrangères.\nLe compte 476 est débité des pertes latentes constatées par le crédit de comptes de créances ou de\ncomptes de dettes, selon qu'elles correspondent à une diminution des créances ou à une\naugmentation des dettes.	2	1	7	1	0	509.00000000	1	\N	1	\N
506	4761	Diminution des créances	 	1	1	6	1	0	510.00000000	1	\N	1	\N
507	4762	Augmentation des dettes	 	1	1	6	1	0	511.00000000	1	\N	1	\N
508	4768	Différences compensées par couverture de change	 	1	1	6	1	0	512.00000000	1	\N	1	\N
511	4772	Diminution des dettes	 	1	1	6	1	0	515.00000000	1	\N	1	\N
512	4778	Différences compensées par couverture de change	 	1	1	6	1	0	516.00000000	1	\N	1	\N
513	478	Autres comptes transitoires	 	2	1	6	1	0	517.00000000	1	\N	1	\N
514	48	COMPTES DE REGULARISATION	(Règlement n°2004-06 du CRC) - En fin d'exercice, le compte 481 « Charges à répartir sur\nplusieurs exercices » enregistre à son débit les charges à répartir sur plusieurs exercices qui\ncomprennent les frais d'émission des emprunts par le crédit du compte 79 « Transferts de charges ».\nIl est crédité, à la clôture de chaque exercice, par le débit du compte 6812 « Dotations aux\namortissements des charges d'exploitation à répartir » du montant de la quote-part des charges\nincombant à cet exercice, également en ce qui concerne l'exercice de transfert.	3	1	7	1	0	518.00000000	1	\N	1	\N
517	486	Charges constatées d'avance	Le compte 486 « Charges constatées d'avance » enregistre les charges qui correspondent à des\nachats de biens et de services dont la fourniture ou la prestation interviendra ultérieurement. Il est\ndébité, en fin d'exercice, par le crédit des comptes de charges intéressés. Il est crédité, à l'ouverture\nde l'exercice suivant, par le débit de ces mêmes comptes. Un autre procédé de comptabilisation\nconsiste, lors de l'enregistrement initial de la facture, à affecter directement au compte de\nrégularisation 486 la quote-part des charges se rapportant à un exercice ultérieur.	2	4	6	1	0	521.00000000	1	\N	1	\N
518	487	Produits constatés d'avance	Le compte 487 « Produits constatés d'avance » enregistre les produits perçus ou comptabilisés\navant que les prestations ou les fournitures les justifiant aient été effectuées ou fournies. Il est\ncrédité, en fin d'exercice, par le débit des comptes de produits intéressés. Il est débité, à l'ouverture\nde l'exercice suivant, par le crédit de ces mêmes comptes. Un autre procédé de comptabilisation\nconsiste, lors de l'enregistrement initial de la facture, à affecter directement au compte de\nrégularisation 487 la quote-part des produits se rapportant à un exercice ultérieur.\nLes comptes 486 et 487 peuvent être subdivisés conformément à la nomenclature des classes 6 et 7.\nA la souscription, l'émetteur de bons de souscription d'obligations (BSO) enregistre au compte 487\nla contrepartie de la valeur des bons. Lors de l'exercice des bons, les produits constatés d'avance\nsont rapportés au résultat sur la durée de l'emprunt obligataire. Lors de la péremption, le montant\ndes bons non exercés est rapporté au résultat.\nA la souscription, l'émetteur d'obligations avec bons de souscription d'obligations (OBSO)\nenregistre au compte 487 la différence entre le prix d'émission des obligations avec bons de\nsouscription d'obligations et la valeur actuelle de l'emprunt obligataire. Lors de l'exercice des bons,\nles produits constatés d'avance sont rapportés au résultat sur la durée de l'emprunt. Lors de la\npéremption, le montant des bons non exercés est rapporté au résultat.	2	4	6	1	0	522.00000000	1	\N	1	\N
519	488	Comptes de répartition périodique des charges et des produits	Le compte 488 « Comptes de répartition périodique des charges et des produits » enregistre les\ncharges et les produits dont le montant peut être connu ou fixé d'avance avec une précision\nsuffisante et qu'on décide de répartir par fractions égales entre les périodes comptables de\nl'exercice. Il s'agit du système de l'abonnement. En cours d'exercice, l'abonnement est modifié,\ns'il y a lieu, en plus ou en moins, de manière que le total des sommes inscrites au débit ou au crédit\ndes comptes intéressés des classes 6 ou 7 soit égal, en fin d'exercice, au montant effectif de la\ncharge ou du produit. Le compte 488 est soldé à la fin de l'exercice.	2	1	7	1	0	523.00000000	1	\N	1	\N
521	4887	Produits	 	1	1	6	1	0	525.00000000	1	\N	1	\N
522	489	Quotas d'émission alloués par l'Etat (Règlement n°2004-08 du CRC)	 	2	1	6	1	0	526.00000000	1	\N	1	\N
523	49	PROVISIONS POUR DEPRECIATION DES COMPTES DE TIERS	Ces comptes sont crédités, en fin d'exercice :\n- par le débit du compte 6817 « Dotations aux provisions pour dépréciation des actifs\ncirculants » (autres que valeurs mobilières de placement) ;\n- ou par le débit du compte 6876 « Dotations aux provisions pour dépréciation\nexceptionnelles ».\n\nLorsque la provision est devenue, en tout ou partie sans objet, ou se révèle exagérée, ou lorsque se\nréalise le risque de non-recouvrement couvert par la provision, ces comptes sont débités :\n- par le crédit du compte 7817 « Reprises sur provisions pour dépréciation des actifs\ncirculants » (autres que valeurs mobilières de placement) ;\n- ou par le crédit du compte 7876 « Reprises sur provisions pour dépréciation\nexceptionnelles ».	3	1	7	1	0	527.00000000	1	\N	1	\N
524	491	Provisions pour dépréciation des comptes de clients	 	2	4	6	1	0	528.00000000	1	\N	1	\N
525	495	Provisions pour dépréciation des comptes du groupe et des associés	 	3	1	7	1	0	529.00000000	1	\N	1	\N
526	4951	Comptes du groupe	 	2	1	6	1	0	530.00000000	1	\N	1	\N
515	481	Charges à répartir sur plusieurs exercices (Règlement n°2004-06 du CRC)	 	2	4	7	1	0	519.00000000	1	\N	1	\N
516	4816	Frais d'émission des emprunts	 	1	1	6	1	0	520.00000000	1	\N	1	\N
520	4886	Charges	 	1	1	6	1	0	524.00000000	1	\N	1	\N
529	496	Provisions pour dépréciation des comptes de débiteurs divers	 	2	4	7	1	0	533.00000000	1	\N	1	\N
530	4962	Créances sur cessions d'immobilisations	 	1	1	6	1	0	534.00000000	1	\N	1	\N
531	4965	Créances sur cessions de valeurs mobilières de placement	 	1	1	6	1	0	535.00000000	1	\N	1	\N
532	4967	Autres comptes débiteurs	 	1	1	6	1	0	536.00000000	1	\N	1	\N
533	50	VALEURS MOBILIERES DE PLACEMENT	 	3	4	7	1	0	537.00000000	1	\N	1	\N
534	501	Parts dans des entreprises liées	 	2	1	6	1	0	538.00000000	1	\N	1	\N
535	502	Actions propres	Le compte 502 « Actions propres » est débité au moment du rachat par une société de ses propres\nactions, lorsque cette opération a explicitement pour objet soit la régularisation des cours de bourse,\nsoit l'attribution des titres à des salariés.\nPour la détermination du résultat dégagé à l'occasion de la vente des actions rachetées, les titres les\nplus anciens sont réputés vendus les premiers (PEPS).\nLa différence existant entre le prix de vente et le coût des actions cédées déterminé par application\nde la règle PEPS est inscrite soit à une subdivision du compte 778 intitulée « Bonis provenant du\nrachat par l'entreprise d'actions et d'obligations émises par elle-même », soit à une subdivision du\ncompte 678 intitulée « Malis provenant du rachat par l'entreprise d'actions et d'obligations émises\npar elle-même ».	2	1	6	1	0	539.00000000	1	\N	1	\N
536	503	Actions	Les comptes 503 « Actions » et 504 « Autres titres conférant un droit de propriété » sont débités de\nla valeur d'acquisition des actions et autres titres conférant un droit de propriété, par le crédit d'un\ncompte de tiers ou de disponibilités. Lors de la revente de ces actions, ou titres, ces comptes sont\ncrédités du montant de la valeur comptable de ces actions ou titres, par le débit :\n- du compte 767 « Produits nets sur cessions de valeurs mobilières de placement », lorsque\nla cession des titres est génératrice d'un profit ; simultanément lors de la cession, le prix de cession est\nporté au crédit du compte 767 ;\n- du compte 667 « Charges nettes sur cessions de valeurs mobilières de placement »,\nlorsque la cession des titres est génératrice d'une perte ; simultanément lors de la cession, le prix de\ncession est porté au crédit du compte 667.\n\nLa valeur d'acquisition des titres conférant un droit de créance est inscrite dans\nles comptes 505 « Obligations et bons émis par la société et rachetés par elle »,\n506 « Obligations », 507 « Bons du Trésor et bons de caisse à court terme » et 508 « Autres valeurs\nmobilières et créances assimilées ».\nLes écritures comptables relatives aux opérations d'acquisition, d'annulation ou de cession\nd'actions sont applicables aux opérations similaires effectuées sur des obligations.\nL'acquéreur ou le souscripteur de bons de souscription enregistre la valeur des bons dans le compte\n50 « Valeurs mobilières de placement ».	2	1	7	1	0	540.00000000	1	\N	1	\N
537	5031	Titres cotés	 	1	1	6	1	0	541.00000000	1	\N	1	\N
538	5035	Titres non cotés	 	1	1	6	1	0	542.00000000	1	\N	1	\N
542	5061	Titres cotés	 	1	1	6	1	0	546.00000000	1	\N	1	\N
543	5065	Titres non cotés	 	1	1	6	1	0	547.00000000	1	\N	1	\N
544	507	Bons du Trésor et bons de caisse à court terme	 	2	1	6	1	0	548.00000000	1	\N	1	\N
545	508	Autres valeurs mobilières de placement et autres créances assimilées	 	2	1	7	1	0	549.00000000	1	\N	1	\N
546	5081	Autres valeurs mobilières	 	1	1	6	1	0	550.00000000	1	\N	1	\N
547	5082	Bons de souscription	 	1	1	6	1	0	551.00000000	1	\N	1	\N
548	5088	Intérêts courus sur obligations, bons et valeurs assimilées	 	1	1	6	1	0	552.00000000	1	\N	1	\N
549	509	Versements restant à effectuer sur valeurs mobilières de placement non libérées	Le compte 509 « Versements restant à effectuer sur valeurs mobilières de placement non libérées »\nest crédité du montant des versements restant à effectuer sur les valeurs mobilières de placement\nnon libérées par le débit des subdivisions concernées du compte 50.	2	1	6	1	0	553.00000000	1	\N	1	\N
550	51	BANQUES, ETABLISSEMENTS FINANCIERS ET ASSIMILES	 	3	4	7	1	0	554.00000000	1	\N	1	\N
551	511	Valeurs à l'encaissement	Le compte 511 « Valeurs à l'encaissement » est débité du montant des coupons échus à encaisser,\ndes chèques et des effets remis à l'encaissement ainsi que des effets remis à l'escompte, par le\ncrédit des comptes intéressés.\n\nPour chaque compte bancaire dont elle est titulaire, l'entité utilise une subdivision distincte du\ncompte 512 « Banques ». Aucune compensation ne peut être opérée entre les comptes à solde\ncréditeur et les comptes à solde débiteur.\n\nLes effets financiers créés en représentation des crédits consentis à l'entité, dans le cadre\nd'opérations de mobilisation de créances commerciales (CMCC) ou de mobilisation de créances\nnées à l'étranger, sont comptabilisés à des subdivisions du compte 519 « Concours bancaires\ncourants ». Les intérêts courus liés à ces moyens de financement sont inscrits dans une subdivision\ndu compte 519.	2	1	7	1	0	555.00000000	1	\N	1	\N
552	5111	Coupons échus à l'encaissement	 	1	1	6	1	0	556.00000000	1	\N	1	\N
553	5112	Chèques à encaisser	 	1	1	6	1	0	557.00000000	1	\N	1	\N
554	5113	Effets à l'encaissement	 	1	1	6	1	0	558.00000000	1	\N	1	\N
555	5114	Effets à l'escompte	 	1	1	6	1	0	559.00000000	1	\N	1	\N
556	512	Banques	 	2	1	7	1	0	560.00000000	1	\N	1	\N
557	5121	Comptes en monnaie nationale	 	1	1	6	1	0	561.00000000	1	\N	1	\N
558	5124	Comptes en devises	 	1	1	6	1	0	562.00000000	1	\N	1	\N
559	514	Chèques postaux	 	2	1	6	1	0	563.00000000	1	\N	1	\N
539	504	Autres titres conférant un droit de propriété	 	2	1	6	1	0	543.00000000	1	\N	1	\N
540	505	Obligations et bons émis par la société et rachetés par elle	 	2	1	6	1	0	544.00000000	1	\N	1	\N
541	506	Obligations	 	2	1	7	1	0	545.00000000	1	\N	1	\N
560	515	« Caisses » du Trésor et des établissements publics	 	2	1	6	1	0	564.00000000	1	\N	1	\N
561	516	Sociétés de bourse	 	2	1	6	1	0	565.00000000	1	\N	1	\N
562	517	Autres organismes financiers	 	2	1	6	1	0	566.00000000	1	\N	1	\N
563	518	Intérêts courus	 	2	1	7	1	0	567.00000000	1	\N	1	\N
564	5181	Intérêts courus à payer	 	1	1	6	1	0	568.00000000	1	\N	1	\N
565	5188	Intérêts courus à recevoir	 	1	1	6	1	0	569.00000000	1	\N	1	\N
566	519	Concours bancaires courants	 	2	1	7	1	0	570.00000000	1	\N	1	\N
567	5191	Crédit de mobilisation de créances commerciales (CMCC)	 	1	1	6	1	0	571.00000000	1	\N	1	\N
568	5193	Mobilisation de créances nées à l'étranger	 	1	1	6	1	0	572.00000000	1	\N	1	\N
569	5198	Intérêts courus sur concours bancaires courants	 	1	1	6	1	0	573.00000000	1	\N	1	\N
570	52	INSTRUMENTS DE TRESORERIE	Le compte 52 « Instruments de trésorerie » est utilisé pour comptabiliser les opérations décrites à\nl'article 372-2.	2	1	6	1	0	574.00000000	1	\N	1	\N
571	53 	CAISSE	Le compte 53 « Caisse » est débité du montant des espèces encaissées par l'entité. Il est crédité du\nmontant des espèces décaissées. Son solde est soit débiteur soit nul.	2	4	7	1	0	575.00000000	1	\N	1	\N
572	531	Caisse siège social	 	1	1	7	1	0	576.00000000	1	\N	1	\N
573	5314	Caisse en devises	 	1	1	6	1	0	577.00000000	1	\N	1	\N
574	5311	Caisse en monnaie nationale	 	1	1	6	1	0	578.00000000	1	\N	1	\N
575	532	Caisse succursale (ou usine) A	 	1	1	6	1	0	579.00000000	1	\N	1	\N
576	533	Caisse succursale (ou usine) B	 	1	1	6	1	0	580.00000000	1	\N	1	\N
577	54	REGIES D'AVANCE ET ACCREDITIFS	Le compte 54 « Régies d'avances et accréditifs » enregistre, le cas échéant, les écritures relatives\naux fonds gérés par les régisseurs ou les comptables subordonnés et aux accréditifs ouverts dans les\nbanques au nom d'un tiers ou d'un agent de l'entité.\nCe compte est débité du montant des fonds remis aux régisseurs et aux titulaires d'accréditifs par le\ncrédit d'un compte de trésorerie. Il est crédité :\n- du montant des dépenses effectuées pour le compte de l'entité par le débit d'un compte\nde tiers ou de charges ;\n- du montant des reversements de fonds avancés, par le débit d'un compte de trésorerie.	2	4	6	1	0	581.00000000	1	\N	1	\N
578	58	VIREMENTS INTERNES	Les comptes 58 « Virements internes » sont des comptes de passage utilisés pour la\ncomptabilisation pratique d'opérations au terme desquelles ils sont soldés.\nCes comptes sont notamment destinés à permettre la centralisation, sans risque de double emploi :\n- des virements de fonds d'un compte de caisse ou de banque à un autre compte de banque\nou de caisse ;\n- et, plus généralement, de toute opération faisant l'objet d'un enregistrement dans\nplusieurs journaux auxiliaires.	2	4	6	1	0	582.00000000	1	\N	1	\N
579	59	PROVISIONS POUR DEPRECIATION DES COMPTES FINANCIERS	 	3	1	7	1	0	583.00000000	1	\N	1	\N
580	590	Provisions pour dépréciation des valeurs mobilières de placement	Le compte 590 « Provisions pour dépréciation des valeurs mobilières de placement » est crédité du\nmontant des dépréciations financières des valeurs mobilières de placement par le débit d'une\nsubdivision du compte 6866 intitulée « Dotations aux provisions pour dépréciation des valeurs\nmobilières de placement ».\nCe compte est débité par le crédit d'une subdivision du compte 7866 intitulée « Reprises sur\nprovision pour dépréciation des valeurs mobilières de placement », lorsque la provision s'avère, en\ntout ou partie, sans objet.\n\nA la date de cession des valeurs mobilières de placement, en principe, la provision pour\ndépréciation antérieurement constituée est soldée par le crédit du compte 7866	3	1	7	1	0	584.00000000	1	\N	1	\N
581	5903	Actions	 	2	1	6	1	0	585.00000000	1	\N	1	\N
582	5904	Autres titres conférant un droit de propriété	 	2	1	6	1	0	586.00000000	1	\N	1	\N
583	5906	Obligations	 	2	1	6	1	0	587.00000000	1	\N	1	\N
584	5908	Autres valeurs mobilières de placement et créances assimilées	 	2	1	6	1	0	588.00000000	1	\N	1	\N
585	60	ACHATS (sauf 603)	 	3	4	7	1	0	589.00000000	1	\N	1	\N
586	601	Achats stockés - Matières premières (et fournitures)	Les achats sont inscrits au débit des comptes 601 « Achats stockés ' Matières premières (et\nfournitures) », 602 « Achats stockés ' Autres approvisionnements », 604 « Achats d'études et\nprestations de services », 605 « Achats de matériel, équipements et travaux », 606 « Achats non\nstockés de matières et fournitures » et 607 « Achats de marchandises » au prix d'achat, droits de\ndouane inclus.\nDes subdivisions des comptes d'achat peuvent être ouvertes pour identifier :\n- les achats en France et à l'étranger ;\n- les achats faits par l'entité auprès d'entités liées ou avec lesquelles elle a un lien de\nparticipation.\nLes escomptes de règlement sont comptabilisés au crédit du compte 765 « Escomptes obtenus ».\nLes entités ont la faculté de comptabiliser directement les frais accessoires d'achat payés à des tiers,\npar exemple les transports, les commissions et les assurances à l'un des comptes d'achats 601 à 607\net non aux comptes de charges par nature, lorsque ces charges peuvent être affectées de façon\ncertaine à telle ou telle catégorie de marchandises ou d'approvisionnements.\nPour permettre aux entités de fournir plus facilement le détail des frais accessoires incorporés aux\nachats de l'exercice, le compte 608 peut être utilisé pour regrouper ces frais par catégorie tout en\nmaintenant dans des subdivisions de ce compte leur classement par nature.\nLorsque l'entité a reçu les marchandises ou les approvisionnements sans la facture correspondante,\nil convient de débiter les comptes d'achats susvisés par le crédit du compte 408 « Fournisseurs -\nFactures non parvenues ».\nLes biens et services sous-traités qui s'intègrent directement dans le cycle de production de l'entité\nsont inscrits dans ses achats au débit des comptes :\n- 604 « Achats d'études et de prestations de services » ;\n- 605 « Achats de matériel, équipements et travaux ».	2	1	7	1	0	590.00000000	1	\N	1	\N
587	6011	Matières (ou groupe) A	 	1	1	6	1	0	591.00000000	1	\N	1	\N
588	6012	Matières (ou groupe) B	 	1	1	6	1	0	592.00000000	1	\N	1	\N
589	6017	Fournitures A, B, C, ...	 	1	1	6	1	0	593.00000000	1	\N	1	\N
590	602	Achats stockés - Autres approvisionnements	 	3	1	7	1	0	594.00000000	1	\N	1	\N
591	6021	Matières consommables	 	2	1	7	1	0	595.00000000	1	\N	1	\N
592	60211	Matières (ou groupe) C	 	1	1	6	1	0	596.00000000	1	\N	1	\N
593	60212	Matières (ou groupe) D	 	1	1	6	1	0	597.00000000	1	\N	1	\N
594	6022	Fournitures consommables	 	2	1	7	1	0	598.00000000	1	\N	1	\N
595	60221	Combustibles	 	1	1	6	1	0	599.00000000	1	\N	1	\N
596	60222	Produits d'entretien	 	1	1	6	1	0	600.00000000	1	\N	1	\N
597	60223	Fournitures d'atelier et d'usine	 	1	1	6	1	0	601.00000000	1	\N	1	\N
598	60224	Fournitures de magasin	 	1	1	6	1	0	602.00000000	1	\N	1	\N
599	60225	Fournitures de bureau	 	1	1	6	1	0	603.00000000	1	\N	1	\N
600	6026	Emballages	 	2	1	7	1	0	604.00000000	1	\N	1	\N
601	60261	Emballages perdus	 	1	1	6	1	0	605.00000000	1	\N	1	\N
602	60267	Emballages à usage mixte	 	1	1	6	1	0	606.00000000	1	\N	1	\N
603	604	Achats d'études et prestations de services	 	2	1	6	1	0	607.00000000	1	\N	1	\N
604	605	Achats de matériel, équipements et travaux	 	2	1	6	1	0	608.00000000	1	\N	1	\N
605	606	Achats non stockés de matières et fournitures	Le compte 606 regroupe tous les achats non stockables, par exemple l'eau et l'énergie, ou non\nstockés par l'entité tels que ceux afférents à des fournitures qui ne passent pas par un compte de\nmagasin, et dont les existants neufs, en fin d'exercice, sont inscrits au débit du compte 486\n« Charges constatées d'avance ».	2	1	7	1	0	609.00000000	1	\N	1	\N
606	6061	Fournitures non stockables (eau, énergie, ...)	 	6	1	1	1	0	610.00000000	1	\N	1	\N
607	6063	Fournitures d'entretien et de petit équipement	 	1	1	6	1	0	611.00000000	1	\N	1	\N
608	6064	Fournitures administratives	 	1	1	6	1	0	612.00000000	1	\N	1	\N
609	6068	Autres matières et fournitures	 	1	1	6	1	0	613.00000000	1	\N	1	\N
610	607	Achats de marchandises	 	2	1	7	1	0	614.00000000	1	\N	1	\N
611	6071	Marchandise (ou groupe) A	 	1	1	6	1	0	615.00000000	1	\N	1	\N
612	6072	Marchandise (ou groupe) B	 	1	1	6	1	0	616.00000000	1	\N	1	\N
613	608	(Compte réservé, le cas échéant, à la récapitulation des frais accessoires incorporés aux achats)	 	2	1	6	1	0	617.00000000	1	\N	1	\N
614	609	Rabais, remises et ristournes obtenus sur achats	Le compte 609 « Rabais, remises et ristournes obtenus sur achats » enregistre à son crédit les rabais,\nremises et ristournes sur achats obtenus des fournisseurs et dont le montant, non déduit des factures\nd'achats, n'est connu que postérieurement à la comptabilisation de ces factures.	2	1	7	1	0	618.00000000	1	\N	1	\N
615	6091	de matières premières (et fournitures)	 	1	1	6	1	0	619.00000000	1	\N	1	\N
616	6092	d'autres approvisionnements stockés	 	1	1	6	1	0	620.00000000	1	\N	1	\N
617	6094	d'études et prestations de services	 	1	1	6	1	0	621.00000000	1	\N	1	\N
618	6095	de matériel, équipements et travaux	 	1	1	6	1	0	622.00000000	1	\N	1	\N
619	6096	d'approvisionnements non stockés	 	1	1	6	1	0	623.00000000	1	\N	1	\N
620	6097	de marchandises	 	1	1	6	1	0	624.00000000	1	\N	1	\N
621	6098	Rabais, remises et ristournes non affectés	 	1	1	6	1	0	625.00000000	1	\N	1	\N
622	603	VARIATIONS DES STOCKS (approvisionnements et marchandises)	Le compte 603 « Variation des stocks » est réservé à l'enregistrement des variations de stocks\nd'approvisionnements et de marchandises.	3	4	7	1	0	626.00000000	1	\N	1	\N
623	6031	Variation des stocks de matières premières (et fournitures)	Les soldes des subdivisions 6031 « Variation des stocks de matières premières (et fournitures) »,\n6032 « Variation des stocks des autres approvisionnements » et 6037 « Variation des stocks de\nmarchandises" du compte 603 représentent la différence existant entre la valeur des stocks\nd'approvisionnements et de marchandises à la clôture de l'exercice et la valeur desdits stocks à la\nclôture de l'exercice précédent, c'est-à-dire la différence de valeur entre le stock final, dit stock de\nsortie, et le stock initial, dit stock d'entrée, compte non tenu des provisions pour dépréciation\nCes comptes de variation des stocks sont débités, pour les éléments qui les concernent, de la valeur\ndu stock initial et crédités de la valeur du stock final. En conséquence, le solde du compte 603\nreprésente la variation globale de la valeur du stock entre le début et la fin de l'exercice.\nLes soldes des comptes 6037 d'une part, 6031 et 6032 d'autre part, peuvent être créditeurs ou\ndébiteurs. Ils figurent dans le modèle de compte de résultat comme comptes correcteurs en moins\nou en plus des achats de marchandises d'une part, des approvisionnements d'autre part.	2	1	6	1	0	627.00000000	1	\N	1	\N
624	6032	Variation des stocks des autres approvisionnements	 	2	1	6	1	0	628.00000000	1	\N	1	\N
625	6037	Variation des stocks de marchandises	 	2	1	6	1	0	629.00000000	1	\N	1	\N
626	61	AUTRES CHARGES EXTERNES	 	1	1	1	1	1	630.00000000	1	\N	1	\N
627	61	Services extérieurs	Sont comptabilisées dans les comptes 61/62 les charges externes, autres que les achats, en provenance des tiers. Néanmoins, les redevances dues pour concessions, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires sont inscrites au débit du compte 65 « Autres charges de gestion courante ». 61. Services extérieurs. 62. Autres services extérieurs. Sont enregistrés au débit du compte 611 « Sous-traitance générale » les factures de sous-traitance autres que celles inscrites au débit des comptes 604 « Achats d'études et prestations » et 605 « Achats de matériel, équipements et travaux ». Sont enregistrés au compte 612 « Redevances de crédit-bail » les factures de redevances ou de loyers concernant l'utilisation de biens en crédit-bail. Les rémunérations d'affacturage inscrites au compte 622 « Rémunérations d'intermédiaires et honoraires », à la subdivision 6225 « Rémunérations d'affacturage », comprennent : - la commission d'affacturage, qui constitue le paiement des services de gestion comptable, de recouvrement et de garantie de bonne fin ; - la commission de financement, qui représente le coût du financement anticipé, si exceptionnellement elle n'a pas été enregistrée au compte 66 « Charges financières ».	3	4	7	1	0	631.00000000	1	\N	1	\N
628	611	Sous-traitance générale	 	2	1	6	1	0	632.00000000	1	\N	1	\N
629	612	Redevances de crédit-bail	 	3	1	7	1	0	633.00000000	1	\N	1	\N
630	6122	Crédit-bail mobilier	 	2	1	6	1	0	634.00000000	1	\N	1	\N
631	6125	Crédit-bail immobilier	 	2	1	6	1	0	635.00000000	1	\N	1	\N
632	613	Locations	 	2	1	7	1	0	636.00000000	1	\N	1	\N
633	6132	Locations immobilières	 	1	1	6	1	0	637.00000000	1	\N	1	\N
634	6135	Locations mobilières	 	1	1	6	1	0	638.00000000	1	\N	1	\N
635	6136	Malis sur emballages	 	1	1	6	1	0	639.00000000	1	\N	1	\N
636	614	Charges locatives et de copropriété	 	2	1	6	1	0	640.00000000	1	\N	1	\N
637	615	Entretien et réparations	 	2	1	7	1	0	641.00000000	1	\N	1	\N
638	6152	sur biens immobiliers	 	1	1	6	1	0	642.00000000	1	\N	1	\N
639	6155	sur biens mobiliers	 	1	1	6	1	0	643.00000000	1	\N	1	\N
640	6156	Maintenance	 	1	1	6	1	0	644.00000000	1	\N	1	\N
641	616	Primes d'assurances	 	2	1	7	1	0	645.00000000	1	\N	1	\N
642	6161	Multirisques	 	1	1	6	1	0	646.00000000	1	\N	1	\N
643	6162	Assurance obligatoire dommage construction	 	1	1	6	1	0	647.00000000	1	\N	1	\N
644	6163	Assurance-transport	 	1	1	7	1	0	648.00000000	1	\N	1	\N
645	61636	sur achats	 	1	1	6	1	0	649.00000000	1	\N	1	\N
647	61638	sur autres biens	 	1	1	6	1	0	651.00000000	1	\N	1	\N
648	6164	Risques d'exploitation	 	1	1	6	1	0	652.00000000	1	\N	1	\N
649	6165	Insolvabilité clients	 	1	1	6	1	0	653.00000000	1	\N	1	\N
650	617	Études et recherches	 	2	1	6	1	0	654.00000000	1	\N	1	\N
651	618	Divers	 	2	1	7	1	0	655.00000000	1	\N	1	\N
652	6181	Documentation générale	 	1	1	6	1	0	656.00000000	1	\N	1	\N
653	6183	Documentation technique	 	1	1	6	1	0	657.00000000	1	\N	1	\N
654	6185	Frais de colloques, séminaires, conférences	 	1	1	6	1	0	658.00000000	1	\N	1	\N
655	619	Rabais, remises et ristournes obtenus sur services extérieurs	Les comptes 619 « Rabais, remises et ristournes obtenus sur services extérieurs » et 629 « Rabais,\nremises et ristournes obtenus sur autres services extérieurs » enregistrent les rabais, remises et\nristournes sur services extérieurs dans les conditions déjà définies pour le compte 609 « Rabais,\nremises et ristournes obtenus sur achats ».	2	1	6	1	0	659.00000000	1	\N	1	\N
656	62	Autres services extérieurs	 	3	4	7	1	0	660.00000000	1	\N	1	\N
657	621	Personnel extérieur à l'entreprise	 	2	1	7	1	0	661.00000000	1	\N	1	\N
658	6211	Personnel intérimaire	 	1	1	6	1	0	662.00000000	1	\N	1	\N
659	6214	Personnel détaché ou prêté à l'entreprise	 	1	1	6	1	0	663.00000000	1	\N	1	\N
660	622	Rémunérations d'intermédiaires et honoraires	 	2	1	7	1	0	664.00000000	1	\N	1	\N
661	6221	Commissions et courtages sur achats	 	1	1	6	1	0	665.00000000	1	\N	1	\N
662	6222	Commissions et courtages sur ventes	 	1	1	6	1	0	666.00000000	1	\N	1	\N
663	6224	Rémunérations des transitaires	 	1	1	6	1	0	667.00000000	1	\N	1	\N
664	6225	Rémunérations d'affacturage	 	1	1	6	1	0	668.00000000	1	\N	1	\N
665	6226	Honoraires	 	1	1	6	1	0	669.00000000	1	\N	1	\N
666	6227	Frais d'actes et de contentieux	 	1	1	6	1	0	670.00000000	1	\N	1	\N
667	6228	Divers	 	1	1	6	1	0	671.00000000	1	\N	1	\N
668	623	Publicité, publications, relations publiques	 	2	1	7	1	0	672.00000000	1	\N	1	\N
669	6231	Annonces et insertions	 	1	1	6	1	0	673.00000000	1	\N	1	\N
670	6232	Échantillons	 	1	1	6	1	0	674.00000000	1	\N	1	\N
671	6233	Foires et expositions	 	1	1	6	1	0	675.00000000	1	\N	1	\N
672	6234	Cadeaux à la clientèle	 	1	1	6	1	0	676.00000000	1	\N	1	\N
673	6235	Primes	 	1	1	6	1	0	677.00000000	1	\N	1	\N
674	6236	Catalogues et imprimés	 	1	1	6	1	0	678.00000000	1	\N	1	\N
675	6237	Publications	 	1	1	6	1	0	679.00000000	1	\N	1	\N
676	6238	Divers (pourboires, dons courants, ...)	 	1	1	6	1	0	680.00000000	1	\N	1	\N
677	624	Transports de biens et transports collectifs du personnel	 	2	1	7	1	0	681.00000000	1	\N	1	\N
678	6241	Transports sur achats	 	1	1	6	1	0	682.00000000	1	\N	1	\N
679	6242	Transports sur ventes	 	1	1	6	1	0	683.00000000	1	\N	1	\N
680	6243	Transports entre établissements ou chantiers	 	1	1	6	1	0	684.00000000	1	\N	1	\N
681	6244	Transports administratifs	 	1	1	6	1	0	685.00000000	1	\N	1	\N
682	6247	Transports collectifs du personnel	 	1	1	6	1	0	686.00000000	1	\N	1	\N
683	6248	Divers	 	1	1	6	1	0	687.00000000	1	\N	1	\N
684	625	Déplacements, missions et réceptions	 	2	1	7	1	0	688.00000000	1	\N	1	\N
685	6251	Voyages et déplacements	 	1	1	6	1	0	689.00000000	1	\N	1	\N
686	6255	Frais de déménagement	 	1	1	6	1	0	690.00000000	1	\N	1	\N
687	6256	Missions	 	1	1	6	1	0	691.00000000	1	\N	1	\N
688	6257	Réceptions	 	1	1	6	1	0	692.00000000	1	\N	1	\N
689	626	Frais postaux et de télécommunications	 	2	1	6	1	0	693.00000000	1	\N	1	\N
690	627	Services bancaires et assimilés	 	2	1	7	1	0	694.00000000	1	\N	1	\N
691	6271	Frais sur titres (achat, vente, garde)	 	1	1	6	1	0	695.00000000	1	\N	1	\N
692	6272	Commissions et frais sur émission d'emprunts	 	1	1	6	1	0	696.00000000	1	\N	1	\N
693	6275	Frais sur effets	 	1	1	6	1	0	697.00000000	1	\N	1	\N
694	6276	Location de coffres	 	1	1	6	1	0	698.00000000	1	\N	1	\N
695	6278	Autres frais et commissions sur prestations de services	 	1	1	6	1	0	699.00000000	1	\N	1	\N
696	628	Divers	 	2	1	7	1	0	700.00000000	1	\N	1	\N
697	6281	Concours divers (cotisations, ...)	 	1	1	6	1	0	701.00000000	1	\N	1	\N
698	6284	Frais de recrutement de personnel	 	1	1	6	1	0	702.00000000	1	\N	1	\N
699	629	Rabais, remises et ristournes obtenus sur autres services extérieurs	 	2	1	6	1	0	703.00000000	1	\N	1	\N
700	63	IMPOTS, TAXES ET VERSEMENTS ASSIMILES	Les impôts, taxes et versements assimilés sont des charges correspondant :\n- d'une part, à des versements obligatoires à l'Etat et aux collectivités locales pour\nsubvenir aux dépenses publiques ;\n- d'autre part, à des versements institués par l'autorité publique, notamment pour le\nfinancement d'actions d'intérêt économique ou social.\n\nLes impôts sur les bénéfices ne sont pas comptabilisés sous ce compte. Ils sont inscrits au compte\n695 « Impôts sur les bénéfices ».\nLes versements au Trésor à effectuer au titre des taxes et participations assises sur les salaires sont\nenregistrés au débit du compte 631 « Impôts, taxes et versements assimilés sur rémunérations\n(administration des impôts) » aux diverses subdivisions concernées, intitulées :\n- Taxe sur les salaires ;\n- Taxe d'apprentissage ;\n- Participation des employeurs à la formation professionnelle continue ;\n- Cotisation pour défaut d'investissement obligatoire dans la construction.\nLa contrepartie figure au crédit du compte 447 « Autres impôts, taxes et versements assimilés ».\nLorsque le montant des dépenses libératoires, acquittées ou dues à l'inventaire, est inférieur au\nmontant de la taxe ou de la participation obligatoire, l'entité inscrit le montant du versement restant\nà effectuer au Trésor au crédit du compte 447 ou de la subdivision du compte 448 intitulée « Etat -\nCharges à payer » par le débit du compte 631.\nLes versements à fonds perdus ou subventions au titre des taxes et participations assises sur les\nsalaires sont enregistrés au débit du compte 633 « Impôts, taxes et versements assimilés sur\nrémunérations (autres organismes) » aux diverses subdivisions concernées, intitulées :\n- Participation des employeurs à l'effort de construction lorsqu'il s'agit de versements à\nfonds perdus,\n- Participation des employeurs à la formation professionnelle continue lorsque les dépenses\nsont libératoires,\n- Versements libératoires ouvrant droit à l'exonération de la taxe d'apprentissage.\nLes autres dépenses ayant le caractère de charges figurent dans les comptes de charges concernés de\nla classe 6.\nLorsque la législation permet d'imputer à titre de dépenses libératoires les dépenses restant dues à\nla fin de l'exercice, ces dernières sont comptabilisées au débit des comptes d'actif ou des comptes\nde charges concernés par le crédit des comptes de tiers intéressés.	3	4	7	1	0	704.00000000	1	\N	1	\N
701	631	Impôts, taxes et versements assimilés sur rémunérations (administrations des impôts)	 	2	1	7	1	0	705.00000000	1	\N	1	\N
702	6311	Taxe sur les salaires	 	1	1	6	1	0	706.00000000	1	\N	1	\N
703	6312	Taxe d'apprentissage	 	1	1	6	1	0	707.00000000	1	\N	1	\N
704	6313	Participation des employeurs à la formation professionnelle continue	 	1	1	6	1	0	708.00000000	1	\N	1	\N
705	6314	Cotisation pour défaut d'investissement obligatoire dans la construction	 	1	1	6	1	0	709.00000000	1	\N	1	\N
706	6318	Autres	 	1	1	6	1	0	710.00000000	1	\N	1	\N
707	633	Impôts, taxes et versements assimilés sur rémunérations (autres organismes)	 	2	1	7	1	0	711.00000000	1	\N	1	\N
708	6331	Versement de transport	 	1	1	6	1	0	712.00000000	1	\N	1	\N
709	6332	Allocations logement	 	1	1	6	1	0	713.00000000	1	\N	1	\N
710	6333	Participation des employeurs à la formation professionnelle continue	 	1	1	6	1	0	714.00000000	1	\N	1	\N
711	6334	Participation des employeurs à l'effort de construction	 	1	1	6	1	0	715.00000000	1	\N	1	\N
712	6335	Versements libératoires ouvrant droit à l'exonération de la taxe d'apprentissage	 	1	1	6	1	0	716.00000000	1	\N	1	\N
713	6338	Autres	 	1	1	6	1	0	717.00000000	1	\N	1	\N
714	635	Autres impôts, taxes et versements assimilés (administrations des impôts)	 	2	1	7	1	0	718.00000000	1	\N	1	\N
715	6351	Impôts directs (sauf impôts sur les bénéfices)	 	1	1	7	1	0	719.00000000	1	\N	1	\N
716	63511	Taxe professionnelle	 	1	1	6	1	0	720.00000000	1	\N	1	\N
717	63512	Taxes foncières	 	1	1	6	1	0	721.00000000	1	\N	1	\N
718	63513	Autres impôts locaux	 	1	1	6	1	0	722.00000000	1	\N	1	\N
719	63514	Taxe sur les véhicules des sociétés	 	1	1	6	1	0	723.00000000	1	\N	1	\N
720	6352	Taxes sur le chiffre d'affaires non récupérables	 	1	1	6	1	0	724.00000000	1	\N	1	\N
721	6353	Impôts indirects	 	1	1	6	1	0	725.00000000	1	\N	1	\N
722	6354	Droits d'enregistrement et de timbre	 	1	1	7	1	0	726.00000000	1	\N	1	\N
723	63541	Droits de mutation	 	1	1	6	1	0	727.00000000	1	\N	1	\N
724	6358	Autres droits	 	1	1	6	1	0	728.00000000	1	\N	1	\N
725	637	Autres impôts, taxes et versements assimilés (autres organismes)	 	2	1	7	1	0	729.00000000	1	\N	1	\N
726	6371	Contribution sociale de solidarité à la charge des société	 	1	1	6	1	0	730.00000000	1	\N	1	\N
727	6372	Taxes perçues par les organismes publics internationaux	 	1	1	6	1	0	731.00000000	1	\N	1	\N
728	6374	Impôts et taxes exigibles à l'Étranger	 	1	1	6	1	0	732.00000000	1	\N	1	\N
729	6378	Taxes diverses	 	1	1	6	1	0	733.00000000	1	\N	1	\N
730	64	CHARGES DE PERSONNEL	 	3	1	7	1	0	734.00000000	1	\N	1	\N
731	641	Rémunérations du personnel	Sont inscrites au compte 641 « Rémunérations du personnel » toutes les rémunérations du\npersonnel, y compris les rémunérations allouées aux gérants majoritaires et aux administrateurs de\nsociété.	2	4	7	1	0	735.00000000	1	\N	1	\N
732	6411	Salaires, appointements	 	1	1	6	1	0	736.00000000	1	\N	1	\N
733	6412	Congés payés	 	1	1	6	1	0	737.00000000	1	\N	1	\N
734	6413	Primes et gratifications	 	1	1	6	1	0	738.00000000	1	\N	1	\N
735	6414	Indemnités et avantages divers	 	1	1	6	1	0	739.00000000	1	\N	1	\N
736	6415	Supplément familial	 	1	1	6	1	0	740.00000000	1	\N	1	\N
737	644	Rémunération du travail de l'exploitant	Les entreprises individuelles peuvent enregistrer au compte 644 « Rémunération du travail de\nl'exploitant » les rémunérations de l'exploitant et de sa famille lorsqu'aucune autre rémunération ne\nconstitue la contrepartie du travail fourni. Elles indiquent le mode de calcul retenu pour la fixation\nde cette rémunération et le montant du bénéfice comptable avant déduction de la rémunération de\nl'exploitant.	2	4	6	1	0	741.00000000	1	\N	1	\N
738	645	Charges de sécurité sociale et de prévoyance	 	2	4	7	1	0	742.00000000	1	\N	1	\N
739	6451	Cotisations à l'URSSAF	 	1	1	6	1	0	743.00000000	1	\N	1	\N
740	6452	Cotisations aux mutuelles	 	1	1	6	1	0	744.00000000	1	\N	1	\N
741	6453	Cotisations aux caisses de retraites	 	1	1	6	1	0	745.00000000	1	\N	1	\N
742	6454	Cotisations aux ASSEDIC	 	1	1	6	1	0	746.00000000	1	\N	1	\N
743	6458	Cotisations aux autres organismes sociaux	 	1	1	6	1	0	747.00000000	1	\N	1	\N
744	646 	Cotisations sociales personnelles de l'exploitant	 	2	4	6	1	0	748.00000000	1	\N	1	\N
745	647	Autres charges sociales	 	2	1	7	1	0	749.00000000	1	\N	1	\N
746	6471	Prestations directes	 	1	1	6	1	0	750.00000000	1	\N	1	\N
747	6472	Versements aux comités d'entreprise et d'établissement	 	1	1	6	1	0	751.00000000	1	\N	1	\N
748	6473	Versements aux comités d'hygiène et de sécurité	 	1	1	6	1	0	752.00000000	1	\N	1	\N
749	6474	Versements aux autres oeuvres sociales	 	1	1	6	1	0	753.00000000	1	\N	1	\N
750	6475	Médecine du travail, pharmacie	 	1	1	6	1	0	754.00000000	1	\N	1	\N
751	648	Autres charges de personnel	 	2	1	6	1	0	755.00000000	1	\N	1	\N
752	65	AUTRES CHARGES DE GESTION COURANTE	Les pertes sur créances irrécouvrables qui présentent un caractère habituel eu égard notamment à la\nnature de l'activité ou au volume des affaires traitées sont enregistrées au débit du compte 654\n« Pertes sur créances irrécouvrables »	3	4	7	1	0	756.00000000	1	\N	1	\N
753	651	Redevances pour concessions, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires	 	2	1	7	1	0	757.00000000	1	\N	1	\N
754	6511	Redevances pour concessions, brevets, licences, marques, procédés, logiciels	 	1	1	6	1	0	758.00000000	1	\N	1	\N
755	6516	Droits d'auteur et de reproduction	 	1	1	6	1	0	759.00000000	1	\N	1	\N
756	6518	Autres droits et valeurs similaires	 	1	1	6	1	0	760.00000000	1	\N	1	\N
757	653	Jetons de présence	 	2	1	6	1	0	761.00000000	1	\N	1	\N
758	654	Pertes sur créances irrécouvrables	 	2	1	7	1	0	762.00000000	1	\N	1	\N
759	6541	Créances de l'exercice	 	1	1	6	1	0	763.00000000	1	\N	1	\N
760	6544	Créances des exercices antérieurs	 	1	1	6	1	0	764.00000000	1	\N	1	\N
761	655	Quote-parts de résultat sur opérations faites en commun	Le compte 655 « Quote-parts de résultat sur opérations faites en commun » enregistre à son débit :\n- la quote-part de résultat sur opérations faites en commun qui représente pour l'entité\nnon gérante sa participation aux pertes. En contrepartie, le compte 458 « Associés - Opérations\nfaites en commun et en GIE » est crédité ;\n- la quote-part de résultat sur opérations faites en commun qui représente pour l'entité\ngérante le montant des bénéfices répartis aux associés non gérants. En contrepartie, le compte 458 est\ncrédité.	2	1	7	1	0	765.00000000	1	\N	1	\N
762	6551	Quote-part de bénéfice transférée (comptabilité du gérant)	 	1	1	6	1	0	766.00000000	1	\N	1	\N
763	6555	Quote-part de perte supportée (comptabilité des associés non gérants)	 	1	1	6	1	0	767.00000000	1	\N	1	\N
764	658	Charges diverses de gestion courante	 	2	1	6	1	0	768.00000000	1	\N	1	\N
765	66	CHARGES FINANCIERES	 	3	4	7	1	0	769.00000000	1	\N	1	\N
766	661	Charges d'intérêts	Des subdivisions du compte 661 « Charges d'intérêts » permettent d'identifier notamment les\nintérêts des emprunts et dettes assimilées concernant les entités liées	2	1	7	1	0	770.00000000	1	\N	1	\N
767	6611	Intérêts des emprunts et dettes	 	1	1	7	1	0	771.00000000	1	\N	1	\N
768	66116	des emprunts et dettes assimilées	 	1	1	6	1	0	772.00000000	1	\N	1	\N
769	66117	des dettes rattachées à des participations	 	1	1	6	1	0	773.00000000	1	\N	1	\N
770	6615	Intérêts des comptes courants et des dépôts créditeurs	 	1	1	6	1	0	774.00000000	1	\N	1	\N
771	6616	Intérêts bancaires et sur opérations de financement (escompte,...)	 	1	1	6	1	0	775.00000000	1	\N	1	\N
773	6618	Intérêts des autres dettes	 	1	1	7	1	0	777.00000000	1	\N	1	\N
775	66188	des dettes diverses	 	1	1	6	1	0	779.00000000	1	\N	1	\N
776	664	Pertes sur créances liées à des participations	 	2	1	6	1	0	780.00000000	1	\N	1	\N
777	665	Escomptes accordés	Le compte 665 « Escomptes accordés » est débité du montant des escomptes accordés par l'entité à\nses clients par le crédit du compte 411 « Clients » ou d'un compte de trésorerie.	2	1	6	1	0	781.00000000	1	\N	1	\N
778	666	Pertes de change	Le compte 666 « Pertes de change » enregistre à son débit les pertes de change supportées par\nl'entité au cours de l'exercice. En outre, les écarts de conversion négatifs constatés à la fin de\nl'exercice sur les disponibilités en devises sont considérés comme des pertes de change supportées.	2	1	6	1	0	782.00000000	1	\N	1	\N
779	667	Charges nettes sur cessions de valeurs mobilières de placement	Le compte 667 « Charges nettes sur cessions de valeurs mobilières de placement » est débité de la\nvaleur brute des valeurs mobilières de placement cédées. Il est crédité du prix de cession de ces\nvaleurs mobilières de placement.	2	1	6	1	0	783.00000000	1	\N	1	\N
780	668	Autres charges financières	 	2	1	6	1	0	784.00000000	1	\N	1	\N
781	67	CHARGES EXCEPTIONNELLES	Les charges exceptionnelles sont inscrites au débit :\n- du compte 671 « Charges exceptionnelles sur opérations de gestion » lorsqu'elles\nconcernent des opérations de gestion ;\n- des comptes 675 « Valeurs comptables des éléments d'actif cédés » et 678 « Autres\ncharges exceptionnelles » lorsqu'elles concernent des opérations en capital.	3	4	7	1	0	785.00000000	1	\N	1	\N
782	671	Charges exceptionnelles sur opérations de gestion	 	2	1	7	1	0	786.00000000	1	\N	1	\N
783	6711	Pénalités sur marchés (et dédits payés sur achats et ventes)	 	1	1	6	1	0	787.00000000	1	\N	1	\N
784	6712	Pénalités, amendes fiscales et pénales	 	1	1	6	1	0	788.00000000	1	\N	1	\N
785	6713	Dons, libéralités	 	1	1	6	1	0	789.00000000	1	\N	1	\N
786	6714	Créances devenues irrécouvrables dans l'exercice	 	1	1	6	1	0	790.00000000	1	\N	1	\N
787	6715	Subventions accordées	 	1	1	6	1	0	791.00000000	1	\N	1	\N
788	6717	Rappel d'impôts (autres qu'impôts sur les bénéfices)	 	1	1	6	1	0	792.00000000	1	\N	1	\N
789	6718	Autres charges exceptionnelles sur opérations de gestion	 	1	1	6	1	0	793.00000000	1	\N	1	\N
790	672	(Compte à la disposition des entités pour enregistrer, en cours d'exercice, les charges sur exercices antérieurs)	 	2	1	6	1	0	794.00000000	1	\N	1	\N
774	66181	des dettes commerciales	 	1	1	6	1	0	778.00000000	1	\N	1	\N
791	675	Valeurs comptables des éléments d'actif cédés	Le compte 675 est débité du montant de la valeur brute, le cas échéant diminuée des\namortissements, des éléments d'actif cédés par le crédit du compte d'actif intéressé sauf s'il s'agit\nde TIAP ou de valeurs mobilières de placement.\nLe compte 675 est débité de la valeur brute des TIAP cédés lorsque la cession est génératrice d'une\nperte. Il est alors crédité du prix de cession de ces titres.\nLa valeur brute des valeurs mobilières de placement cédées est virée au débit du compte 667\n« Charges nettes sur cessions de valeurs mobilières de placement » ou 767 « Produits nets sur\ncessions de valeurs mobilières de placement » selon que la cession est génératrice d'une perte (voir\n446-22) ou d'un profit (voir 447-13).\n\nEn cours de période, les entités peuvent utiliser le compte 672 pour enregistrer les charges sur\nexercices antérieurs à condition de les répartir au moins en fin d'exercice entre les charges\nd'exploitation et les charges exceptionnelles en fonction de leur nature.	2	1	7	1	0	795.00000000	1	\N	1	\N
792	6751	Immobilisations incorporelles	 	1	1	6	1	0	796.00000000	1	\N	1	\N
793	6752	Immobilisations corporelles	 	1	1	6	1	0	797.00000000	1	\N	1	\N
794	6756	Immobilisations financières	 	1	1	6	1	0	798.00000000	1	\N	1	\N
795	6758	Autres éléments d'actif	 	1	1	6	1	0	799.00000000	1	\N	1	\N
796	678	Autres charges exceptionnelles	 	2	1	7	1	0	800.00000000	1	\N	1	\N
797	6781	Malis provenant de clauses d'indexation	 	1	1	6	1	0	801.00000000	1	\N	1	\N
798	6782	Lots	 	1	1	6	1	0	802.00000000	1	\N	1	\N
799	6783	Malis provenant du rachat par l'entreprise d'actions et obligations émises par elle-même	 	1	1	6	1	0	803.00000000	1	\N	1	\N
800	6788	Charges exceptionnelles diverses	 	1	1	6	1	0	804.00000000	1	\N	1	\N
877	7134	Variation des en-cours de production de services	 	2	1	7	1	0	881.00000000	1	\N	1	\N
878	71341	Études en cours	 	1	1	6	1	0	882.00000000	1	\N	1	\N
801	68	DOTATIONS AUX AMORTISSEMENTS ET AUX PROVISIONS	Le compte 68 « Dotations aux amortissements et aux provisions » comporte des subdivisions\ndistinguant les charges calculées d'exploitation, financières ou exceptionnelles.	3	1	7	1	0	805.00000000	1	\N	1	\N
802	681	Dotations aux amortissements et aux provisions - Charges d'exploitation	Les comptes 681 « Dotations aux amortissements et aux provisions ' Charges d'exploitation », 686\n« Dotations aux amortissements et aux provisions ' Charges financières » et 687 « Dotations aux\namortissements et aux provisions ' Charges exceptionnelles » sont débités du montant respectif des\ndotations de l'exercice aux amortissements et aux provisions par le crédit des subdivisions, des\ncomptes d'amortissements et de provisions concernés.\nLes amortissements dérogatoires comptabilisés dans l'exercice sont inscrits au débit du compte\n6872 « Dotations aux provisions réglementées (immobilisations) ».	3	4	7	1	0	806.00000000	1	\N	1	\N
803	6811	Dotations aux amortissements sur immobilisations incorporelles et corporelles	 	2	1	7	1	0	807.00000000	1	\N	1	\N
804	68111	Immobilisations incorporelles	 	1	1	6	1	0	808.00000000	1	\N	1	\N
805	68112	Immobilisations corporelles	 	1	1	6	1	0	809.00000000	1	\N	1	\N
806	6812	Dotations aux amortissements des charges d'exploitation à répartir	 	2	1	6	1	0	810.00000000	1	\N	1	\N
807	6815	Dotations aux provisions pour risques et charges d'exploitation	 	2	1	6	1	0	811.00000000	1	\N	1	\N
808	6816	Dotations pour dépréciations des immobilisations incorporelles et corporelles (Règlement n° 2002-10 du CRC)	 	2	1	7	1	0	812.00000000	1	\N	1	\N
809	68161	Immobilisations incorporelles	 	1	1	6	1	0	813.00000000	1	\N	1	\N
810	68162	Immobilisations corporelles	 	1	1	6	1	0	814.00000000	1	\N	1	\N
811	6817	Dotations aux provisions pour dépréciation des actifs circulants	 	2	1	7	1	0	815.00000000	1	\N	1	\N
812	68173	Stocks et en-cours	 	1	1	6	1	0	816.00000000	1	\N	1	\N
813	68174	Créances	 	1	1	6	1	0	817.00000000	1	\N	1	\N
814	686	Dotations aux amortissements et aux provisions - Charges financières	 	3	4	7	1	0	818.00000000	1	\N	1	\N
815	6861	Dotations aux amortissements des primes de remboursement des obligations	 	2	1	6	1	0	819.00000000	1	\N	1	\N
816	6865	Dotations aux provisions pour risques et charges financières	 	2	1	6	1	0	820.00000000	1	\N	1	\N
817	6866	Dotations aux provisions pour dépréciation des éléments financiers	 	2	1	7	1	0	821.00000000	1	\N	1	\N
818	686662	Immobilisations financières	 	1	1	6	1	0	822.00000000	1	\N	1	\N
819	686665	Valeurs mobilières de placement	 	1	1	6	1	0	823.00000000	1	\N	1	\N
820	6868	Autres dotations	 	2	1	6	1	0	824.00000000	1	\N	1	\N
821	687	Dotations aux amortissements et aux provisions - Charges exceptionnelles	 	3	4	7	1	0	825.00000000	1	\N	1	\N
822	6871	Dotations aux amortissements exceptionnels des immobilisations	 	2	1	6	1	0	826.00000000	1	\N	1	\N
823	6872	Dotations aux provisions réglementées (immobilisations)	 	2	1	7	1	0	827.00000000	1	\N	1	\N
824	68725	Amortissements dérogatoires	 	1	1	6	1	0	828.00000000	1	\N	1	\N
825	6873	Dotations aux provisions réglementées (stocks)	 	2	1	6	1	0	829.00000000	1	\N	1	\N
826	6874	Dotations aux autres provisions réglementées	 	2	1	6	1	0	830.00000000	1	\N	1	\N
827	6875	Dotations aux provisions pour risques et charges exceptionnels	 	2	1	6	1	0	831.00000000	1	\N	1	\N
828	6876	Dotations pour dépréciations exceptionnelles (Règlement n° 2002-10 du CRC)	 	2	1	6	1	0	832.00000000	1	\N	1	\N
829	69	PARTICIPATION DES SALARIES - IMPOTS SUR LES BENEFICES ET ASSIMILES	Le compte 69 « Participation des salariés ' Impôts sur les bénéfices et assimilés » enregistre les\ncharges de la participation des salariés aux résultats et les impôts sur les bénéfices.\nLes charges de la classe 6 sont enregistrées hors taxes récupérables.	3	1	7	1	0	833.00000000	1	\N	1	\N
830	691	Participation des salariés aux résultats	Le compte 691 « Participation des salariés aux résultats » fonctionne de la façon suivante.\nA la clôture de l'exercice au titre duquel les droit des salariés sont nés, la participation est inscrite\nau crédit du compte 4284 « Dettes provisionnées pour participation des salariés aux résultats », par\nle débit du compte 691 « Participation des salariés aux résultats ».\nLorsque le montant de la participation a été approuvé par l'assemblée générale des actionnaires, ou\nà la date de validité du contrat si elle est postérieure à celle de l'assemblée générale, la dette envers\nles salariés est constatée en tant que réserve spéciale au crédit du compte 424 « Participation des\nsalariés aux résultats » :\n- soit par le débit du compte 428 « Personnel ' Charges à payer et produits à recevoir ».\nLes ajustements nécessaires sont effectués par le débit ou le crédit d'une subdivision particulière du\ncompte 691,\n- soit par le débit du compte 691 pour le montant total de la participation, lorsqu'on a\nprocédé à la contre-passation de la dette provisionnée au titre de l'exercice précédent.	2	4	6	1	0	834.00000000	1	\N	1	\N
831	695	Impôts sur les bénéfices	Le compte 695 « Impôts sur les bénéfices » enregistre à son débit le montant dû au titre des\nbénéfices imposables en France et à l'étranger. Des subdivisions permettent, le cas échéant,\nd'identifier les rappels et dégrèvements d'impôts concernant les bénéfices taxables des exercices\nantérieurs.	2	4	7	1	0	835.00000000	1	\N	1	\N
832	6951	Impôts dus en France	 	1	1	6	1	0	836.00000000	1	\N	1	\N
833	6952	Contribution additionnelle à l'impôt sur les bénéfices	 	1	1	6	1	0	837.00000000	1	\N	1	\N
834	6954	Impôts dus à l'étranger	 	1	1	6	1	0	838.00000000	1	\N	1	\N
835	696	Suppléments d'impôt sur les sociétés liés aux distributions	Le compte 696 « Suppléments d'impôt sur les sociétés à payer liés aux distributions » enregistre le\nsupplément d'impôt sur les sociétés dû en raison des distributions.	2	1	6	1	0	839.00000000	1	\N	1	\N
879	71345	Prestations de services en cours	 	1	1	6	1	0	883.00000000	1	\N	1	\N
880	7135	Variation des stocks de produits	 	2	1	7	1	0	884.00000000	1	\N	1	\N
881	71351	Produits intermédiaires	 	1	1	6	1	0	885.00000000	1	\N	1	\N
882	71355	Produits finis	 	1	1	6	1	0	886.00000000	1	\N	1	\N
883	71358	Produits résiduels	 	1	1	6	1	0	887.00000000	1	\N	1	\N
836	697	Imposition forfaitaire annuelle des sociétés	Le compte 697 « Imposition forfaitaire annuelle des sociétés » enregistre l'imposition forfaitaire\nannuelle des sociétés lorsqu'elle reste définitivement à la charge de la société. Lorsque l'imposition\nest susceptible d'être imputée sur l'impôt sur les sociétés dû au titre des deux exercices suivants,\nson montant reste en acompte au débit du compte 444 « État - Impôts sur les bénéfices »,\ncorrélativement une provision du même montant est constituée afin de faire face au risque de nonrécupération.	2	4	6	1	0	840.00000000	1	\N	1	\N
837	698	Intégration fiscale	Le compte 698 « Intégration fiscale » enregistre les charges ou produits afférents à l'application du\nrégime d'intégration fiscale. Les charges sont comptabilisées au compte 6981 « Intégration fiscale -\nCharges » et les produits au compte 6989 « Intégration fiscale - Produits ».	3	1	7	1	0	841.00000000	1	\N	1	\N
838	6981	Intégration fiscale - Charges	 	2	1	6	1	0	842.00000000	1	\N	1	\N
839	6989	Intégration fiscale - Produits	 	2	1	6	1	0	843.00000000	1	\N	1	\N
840	699	Produits - Report en arrière des déficits	Le crédit du compte 699 « Produits - Report en arrière des déficits » enregistre le produit résultant\ndu report en arrière des déficits.	2	4	6	1	0	844.00000000	1	\N	1	\N
841	70	VENTES DE PRODUITS FABRIQUES, PRESTATIONS DE SERVICES, MARCHANDISES	Les produits d'exploitation normale et courante sont enregistrés dans les comptes 70 « Ventes de\nproduits fabriqués, prestations de services, marchandises », 71 « Production stockée (ou\ndéstockage) », 72 « Production immobilisée », 74 « Subventions d'exploitation » et 75 « Autres\nproduits de gestion courante ».\nLes produits liés à la gestion financière sont enregistrés dans le compte 76 « Produits financiers ».\nLes produits relatifs à des opérations exceptionnelles sont enregistrés dans le compte 77 « Produits\nexceptionnels »\nLes reprises sur amortissements et provisions sont enregistrées dans le compte 78 « Reprises sur\namortissements et provisions » en distinguant les reprises sur charges calculées d'exploitation,\nfinancières ou exceptionnelles.\nLes transferts de charges sont enregistrés dans le compte 79 « Transfert de charges ».\nLes produits de la classe 7 sont enregistrés hors taxes collectées. Par exception, les entités, qui\nenregistrent leurs produits TVA comprise, rétablissent a posteriori leur montant hors taxe collectée\nen débitant globalement, pour chaque période d'imposition, les comptes de la classe 7 concernés\npar le crédit du compte 4457 « Taxes sur le chiffre d'affaires collectées par l'entreprise ».	3	1	7	1	0	845.00000000	1	\N	1	\N
842	701	Ventes de produits finis	 	2	4	7	1	0	846.00000000	1	\N	1	\N
843	7011	Produits finis (ou groupe) A	 	1	1	6	1	0	847.00000000	1	\N	1	\N
844	7012	Produits finis (ou groupe) B	 	1	1	6	1	0	848.00000000	1	\N	1	\N
845	702	Ventes de produits intermédiaires	 	2	1	6	1	0	849.00000000	1	\N	1	\N
846	703	Ventes de produits résiduels	 	2	1	6	1	0	850.00000000	1	\N	1	\N
847	704	Travaux	 	2	1	7	1	0	851.00000000	1	\N	1	\N
848	7041	Travaux de catégorie (ou activité) A	 	1	1	6	1	0	852.00000000	1	\N	1	\N
849	7042	Travaux de catégorie (ou activité) B	 	1	1	6	1	0	853.00000000	1	\N	1	\N
850	705	Études	 	2	1	6	1	0	854.00000000	1	\N	1	\N
851	706	Prestations de services	 	2	4	6	1	0	855.00000000	1	\N	1	\N
852	707	Ventes de marchandises	 	2	4	7	1	0	856.00000000	1	\N	1	\N
853	7071	Marchandises (ou groupe) A	 	1	1	6	1	0	857.00000000	1	\N	1	\N
854	7072	Marchandises (ou groupe) B	 	1	1	6	1	0	858.00000000	1	\N	1	\N
855	708	Produits des activités annexes	 	2	4	7	1	0	859.00000000	1	\N	1	\N
856	7081	Produits des services exploités dans l'intérêt du personnel	 	1	1	6	1	0	860.00000000	1	\N	1	\N
857	7082	Commissions et courtages	 	1	1	6	1	0	861.00000000	1	\N	1	\N
858	7083	Locations diverses	 	1	1	6	1	0	862.00000000	1	\N	1	\N
859	7084	Mise à disposition de personnel facturée	 	1	1	6	1	0	863.00000000	1	\N	1	\N
860	7085	Ports et frais accessoires facturés	 	1	1	6	1	0	864.00000000	1	\N	1	\N
861	7086	Bonis sur reprises d'emballages consignés	 	1	1	6	1	0	865.00000000	1	\N	1	\N
862	7087	Bonifications obtenues des clients et primes sur ventes	 	1	1	6	1	0	866.00000000	1	\N	1	\N
863	7088	Autres produits d'activités annexes (cessions d'approvisionnements,...)	 	1	1	6	1	0	867.00000000	1	\N	1	\N
864	709	Rabais, remises et ristournes accordés par l'entreprise	 	2	4	7	1	0	868.00000000	1	\N	1	\N
865	7091	sur ventes de produits finis	 	1	1	6	1	0	869.00000000	1	\N	1	\N
866	7092	sur ventes de produits intermédiaires	 	1	1	6	1	0	870.00000000	1	\N	1	\N
867	7094	sur travaux	 	1	1	6	1	0	871.00000000	1	\N	1	\N
868	7095	sur études	 	1	1	6	1	0	872.00000000	1	\N	1	\N
869	7096	sur prestations de services	 	1	1	6	1	0	873.00000000	1	\N	1	\N
870	7097	sur ventes de marchandises	 	1	1	6	1	0	874.00000000	1	\N	1	\N
871	7098	sur produits des activités annexes	 	1	1	6	1	0	875.00000000	1	\N	1	\N
872	71	PRODUCTION STOCKEE (OU DESTOCKAGE)	 	3	1	7	1	0	876.00000000	1	\N	1	\N
873	713	Variation des stocks (en-cours de production, produits)	 	3	4	7	1	0	877.00000000	1	\N	1	\N
874	7133	Variation des en-cours de production de biens	Les subdivisions 7133 « Variation des en-cours de production de biens », 7134 « Variation des encours\nde production de services » et 7135 « Variation des stocks de produits » du compte 713\n« Variation des stocks (en-cours de production, produits) » représentent la différence existant entre\nla valeur de la production stockée à la clôture de l'exercice et la valeur de la production stockée à la\nclôture de l'exercice précédent, compte non tenu des provisions pour dépréciation.\nCes comptes de variation de stocks sont débités, pour les éléments qui les concernent, de la valeur\nde la production stockée initiale et crédités de la valeur de la production stockée finale. En\nconséquence, le solde du compte 71 « Production stockée (ou déstockage) » représente la variation\nglobale de la valeur de la production stockée entre le début et la fin de l'exercice. Il peut être\ncréditeur ou débiteur.	2	1	6	1	0	878.00000000	1	\N	1	\N
875	71331	Produits en cours	 	1	1	6	1	0	879.00000000	1	\N	1	\N
876	71335	Travaux en cours	 	1	1	6	1	0	880.00000000	1	\N	1	\N
884	72	PRODUCTION IMMOBILISEE	Le compte 72 « Production immobilisée » enregistre le coût des travaux faits par l'entité pour ellemême.\nIl est crédité soit par le débit du compte 23 « Immobilisations en cours » du coût de\nproduction des immobilisations créées par les moyens propres de l'entité au fur et à mesure de la\nprogression des travaux, soit directement par le débit des comptes d'immobilisations intéressés si le\ntransit par le compte 23 ne s'avère pas nécessaire.	3	4	7	1	0	888.00000000	1	\N	1	\N
885	721	Immobilisations incorporelles	 	2	1	6	1	0	889.00000000	1	\N	1	\N
886	722	Immobilisations corporelles	 	2	1	6	1	0	890.00000000	1	\N	1	\N
887	73	(Supprimé par le règlement n° 99-08 du CRC)	 	3	4	7	1	0	891.00000000	1	\N	1	\N
888	731	(Supprimés par le règlement n° 99-08 du CRC)	 	2	1	6	1	0	892.00000000	1	\N	1	\N
889	74	SUBVENTIONS D'EXPLOITATION	Le compte 74 « Subventions d'exploitation » est crédité du montant des subventions d'exploitation\nacquises à l'entité par le débit du compte de tiers ou de trésorerie intéressé.	2	4	6	1	0	893.00000000	1	\N	1	\N
890	75	AUTRES PRODUITS DE GESTION COURANTE	 	1	1	1	1	0	894.00000000	1	\N	1	\N
891	751	Redevances pour concessions, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires	Les redevances acquises pour concessions, brevets, licences, marques, procédés, logiciels, droits et\nvaleurs similaires sont comptabilisées au compte 751 « Redevances pour concessions, brevets,\nlicences, marques, procédés, logiciels, droits et valeurs similaires ».	1	1	1	1	0	895.00000000	1	\N	1	\N
892	7511	Redevances pour concessions, brevets, licences, marques, procédés, logiciels	 	1	1	1	1	0	896.00000000	1	\N	1	\N
893	7516	Droits d'auteur et de reproduction	 	1	1	1	1	0	897.00000000	1	\N	1	\N
898	755	Quote-parts de résultat sur opérations faites en commun	Le compte 755 « Quote-parts de résultat sur opérations faites en commun » enregistre à son crédit :\n- la quote-part de résultat sur opérations faites en commun qui représente pour l'entité non\ngérante sa participation aux bénéfices. En contrepartie, le compte 458 « Associés - Opérations faites en\ncommun et en GIE » est débité ;\n- la quote-part de résultat sur opérations faites en commun qui représente pour l'entité\ngérante le montant des pertes mises à la charge des associés non gérants. En contrepartie, le compte\n458 est débité.	1	1	1	1	0	902.00000000	1	\N	1	\N
899	7551	Quote-part de perte transférée (comptabilité du gérant)	 	1	1	1	1	0	903.00000000	1	\N	1	\N
900	7555	Quote-part de bénéfice attribuée (comptabilité des associés non-gérants)	 	1	1	1	1	0	904.00000000	1	\N	1	\N
901	758	Produits divers de gestion courante	 	1	1	1	1	0	905.00000000	1	\N	1	\N
902	76	PRODUITS FINANCIERS	 	1	1	1	1	0	906.00000000	1	\N	1	\N
903	761	Produits de participations	Des subdivisions des comptes 761 « Produits de participations », 762 « Produits des autres\nimmobilisations financières » et éventuellement 763 « Revenus des autres créances » permettent\nd'identifier les produits concernant des entités liées et provenant de participations ou d'autres\nimmobilisations financières et éventuellement d'autres créances.\nDans la subdivision « Revenus sur autres formes de participation » du compte 761, est enregistrée\nla part de résultat bénéficiaire d'un GIE au cours de l'exercice de distribution.	1	1	1	1	0	907.00000000	1	\N	1	\N
904	7611	Revenus des titres de participation	 	1	1	1	1	0	908.00000000	1	\N	1	\N
905	7616	Revenus sur autres formes de participation	 	1	1	1	1	0	909.00000000	1	\N	1	\N
906	762	Produits des autres immobilisations financières	 	1	1	1	1	0	910.00000000	1	\N	1	\N
907	7621	Revenus des titres immobilisés	 	1	1	1	1	0	911.00000000	1	\N	1	\N
908	7626	Revenus des prêts	 	1	1	1	1	0	912.00000000	1	\N	1	\N
895	752	Revenus des immeubles non affectés à des activités professionnelles	 	1	1	1	1	0	899.00000000	1	\N	1	\N
896	753	Jetons de présence et rémunérations d'administrateurs, gérants	 	1	1	1	1	0	900.00000000	1	\N	1	\N
897	754	Ristournes perçues des coopératives (provenant des excédents)	Le compte 754 « Ristournes perçues des coopératives (provenant des excédents) » enregistre la\nquote-part des excédents répartis entre les associés coopérateurs au prorata des opérations traitées.\nElle est comptabilisée à la date de la décision de l'assemblée générale des associés ayant statué sur\nla répartition du résultat.	1	1	1	1	0	901.00000000	1	\N	1	\N
909	7627	Revenus des créances immobilisées	 	1	1	1	1	0	913.00000000	1	\N	1	\N
910	763	Revenus des autres créances	 	1	1	1	1	0	914.00000000	1	\N	1	\N
911	7631	Revenus des créances commerciales	 	1	1	1	1	0	915.00000000	1	\N	1	\N
912	7638	Revenus des créances diverses	Dans la subdivision 7638 « Revenus sur créances diverses », sont comptabilisés les produits\nprovenant des intérêts courus relatifs à la créance sur l'Etat résultant de la suppression du décalage\nd'un mois.	1	1	1	1	0	916.00000000	1	\N	1	\N
913	764	Revenus des valeurs mobilières de placement	 	1	1	1	1	0	917.00000000	1	\N	1	\N
914	765	Escomptes obtenus	Le compte 765 « Escomptes obtenus » est crédité du montant des escomptes obtenus par l'entité de\nses fournisseurs par le débit du compte de tiers intéressé ou d'un compte de trésorerie.\n\nLe compte 765 « Escomptes obtenus » est crédité du montant des escomptes obtenus par l'entité de\nses fournisseurs par le débit du compte de tiers intéressé ou d'un compte de trésorerie.	1	1	1	1	0	918.00000000	1	\N	1	\N
915	766	Gains de change	Le compte 766 « Gains de change » est crédité des gains de change réalisés par l'entité au cours de\nl'exercice. En outre, les écarts de conversion positifs constatés à la fin de l'exercice sur les\ndisponibilités en devises sont considérés comme des gains de change réalisés.	1	1	1	1	0	919.00000000	1	\N	1	\N
916	767	Produits nets sur cessions de valeurs mobilières de placement	Le compte 767 « Produits nets sur cessions de valeurs mobilières de placement » est débité de la\nvaleur brute des valeurs mobilières de placement cédées. Il est crédité du prix de cession de ces\nvaleurs mobilières de placement.	1	1	1	1	0	920.00000000	1	\N	1	\N
917	768	Autres produits financiers	Le compte 768 « Autres produits financiers » enregistre, le cas échéant, les revenus tirés des\ncomptes en banque.	1	1	1	1	0	921.00000000	1	\N	1	\N
960	7873	Reprises sur provisions réglementées (stocks)	 	1	1	1	1	0	964.00000000	1	\N	1	\N
918	77	PRODUITS EXCEPTIONNELS	Les produits exceptionnels sont inscrits au crédit :\n- du compte 771 « Produits exceptionnels sur opérations de gestion » lorsqu'ils concernent\ndes opérations de gestion ;\n- des comptes 775 « Produits des cessions d'éléments d'actifs », 777 « Quote-part des\nsubventions d'investissement virée au résultat de l'exercice » et 778 « Autres produits exceptionnels »\nlorsqu'ils concernent les opérations en capital.	1	1	1	1	0	922.00000000	1	\N	1	\N
919	771	Produits exceptionnels sur opérations de gestion	 	1	1	1	1	0	923.00000000	1	\N	1	\N
920	7711	Dédits et pénalités perçus sur achats et sur ventes	 	1	1	1	1	0	924.00000000	1	\N	1	\N
921	7713	Libéralités reçues	 	1	1	1	1	0	925.00000000	1	\N	1	\N
922	7714	Rentrées sur créances amorties	 	1	1	1	1	0	926.00000000	1	\N	1	\N
923	7715	Subventions d'équilibre	 	1	1	1	1	0	927.00000000	1	\N	1	\N
924	7717	Dégrèvements d'impôts autres qu'impôts sur les bénéfices	 	1	1	1	1	0	928.00000000	1	\N	1	\N
925	7718	Autres produits exceptionnels sur opérations de gestion	 	1	1	1	1	0	929.00000000	1	\N	1	\N
926	772	(Compte à la disposition des entités pour enregistrer, en cours d'exercice, les produits sur exercices antérieurs)	 	1	1	1	1	0	930.00000000	1	\N	1	\N
927	775	Produits des cessions d'éléments d'actif	Le compte 775 est crédité du prix des cessions d'éléments d'actifs cédés par le débit du compte de\ntiers ou de trésorerie intéressé sauf s'il s'agit de TIAP ou de valeurs mobilières de placement.\nLe compte 775 est crédité du prix de cession des TIAP lorsque la cession est génératrice d'un profit.\nIl est alors débité de la valeur brute de ces titres.\nLe prix de cession des valeurs mobilières de placement cédées est viré au crédit du compte 767\n« Produits nets sur cessions de valeurs mobilières de placement » ou 667 « Charges nettes sur\ncessions de valeurs mobilières de placement » selon que la cession est génératrice d'un profit (voir\n447-14) ou d'une perte (voir 446-22).	1	1	1	1	0	931.00000000	1	\N	1	\N
928	7751	Immobilisations incorporelles	 	1	1	1	1	0	932.00000000	1	\N	1	\N
929	7752	Immobilisations corporelles	 	1	1	1	1	0	933.00000000	1	\N	1	\N
930	7756	Immobilisations financières	 	1	1	1	1	0	934.00000000	1	\N	1	\N
931	7758	Autres éléments d'actif	 	1	1	1	1	0	935.00000000	1	\N	1	\N
932	777	Quote-part des subventions d'investissement virée au résultat de l'exercice	Le compte 777 « Quote-part des subventions d'investissement virée au résultat de l'exercice »\nenregistre, à son crédit, le montant des subventions d'investissement virées au résultat de l'exercice\npar le débit du compte 139 « Subventions d'investissement inscrites au compte de résultat ».\nEn cours de période, les entités peuvent utiliser le compte 772 pour enregistrer les produits sur\nexercices antérieurs à condition de les répartir au moins en fin d'exercice entre les produits\nd'exploitation et les produits exceptionnels en fonction de leur nature.	1	1	1	1	0	936.00000000	1	\N	1	\N
934	7781	Bonis provenant de clauses d'indexation	 	1	1	1	1	0	938.00000000	1	\N	1	\N
935	7782	lots	 	1	1	1	1	0	939.00000000	1	\N	1	\N
936	7783	Bonis provenant du rachat par l'entreprise d'actions et d'obligations émises par elle-même	 	1	1	1	1	0	940.00000000	1	\N	1	\N
937	7788	Produits exceptionnels divers	 	1	1	1	1	0	941.00000000	1	\N	1	\N
938	78	REPRISES SUR AMORTISSEMENTS ET PROVISIONS	 	1	1	1	1	0	942.00000000	1	\N	1	\N
939	781	Reprises sur amortissements et provisions (à inscrire dans les produits d'exploitation)	Les comptes 781 « Reprises sur amortissements et provisions (à inscrire dans les produits\nd'exploitation) », 786 « Reprises sur provisions (à inscrire en produits financiers) » et 787\n« Reprises sur provisions (à inscrire en produits exceptionnels) » sont crédités du montant respectif\ndes reprises sur amortissements et provisions par le débit des subdivisions des comptes\nd'amortissements et des provisions concernés.\nLes amortissements dérogatoires sont réintégrés dans le résultat, en fonction de la durée de vie des\nimmobilisations concernées, par le crédit du compte 7872 « Reprises sur provisions réglementées\n(immobilisations) »\nLorsque la charge effective est inférieure à la provision, ces comptes peuvent être subdivisés de\nfaçon à permettre de distinguer les reprises qui correspondent aux excédents de provisions.	1	1	1	1	0	943.00000000	1	\N	1	\N
940	7811	Reprises sur amortissements des immobilisations incorporelles et corporelles	 	1	1	1	1	0	944.00000000	1	\N	1	\N
941	78111	Immobilisations incorporelles	 	1	1	1	1	0	945.00000000	1	\N	1	\N
942	78112	Immobilisations corporelles	 	1	1	1	1	0	946.00000000	1	\N	1	\N
943	7815	Reprises sur provisions pour risques et charges d'exploitation	 	1	1	1	1	0	947.00000000	1	\N	1	\N
944	7816	Reprises sur dépréciations des immobilisations incorporelles et corporelles (Règlement n° 2002-10 du CRC)	 	1	1	1	1	0	948.00000000	1	\N	1	\N
945	78161	Immobilisations incorporelles	 	1	1	1	1	0	949.00000000	1	\N	1	\N
946	78162	Immobilisations corporelles	 	1	1	1	1	0	950.00000000	1	\N	1	\N
947	7817	Reprises sur provisions pour dépréciation des actifs circulants	 	1	1	1	1	0	951.00000000	1	\N	1	\N
948	78173	Stocks et en-cours	 	1	1	1	1	0	952.00000000	1	\N	1	\N
949	78174	Créances	 	1	1	1	1	0	953.00000000	1	\N	1	\N
950	786	Reprises sur provisions pour risques (à inscrire dans les produits financiers)	 	1	1	1	1	0	954.00000000	1	\N	1	\N
951	7865	Reprises sur provisions pour risques et charges financiers	 	1	1	1	1	0	955.00000000	1	\N	1	\N
952	7866	Reprises sur provisions pour dépréciation des éléments financiers	 	1	1	1	1	0	956.00000000	1	\N	1	\N
953	78662	Immobilisations financières	 	1	1	1	1	0	957.00000000	1	\N	1	\N
954	78665	Valeurs mobilières de placement	 	1	1	1	1	0	958.00000000	1	\N	1	\N
955	787	Reprises sur provisions (à inscrire dans les produits exceptionnels)	 	1	1	1	1	0	959.00000000	1	\N	1	\N
956	7872	Reprises sur provisions réglementées (immobilisations)	 	1	1	1	1	0	960.00000000	1	\N	1	\N
957	78725	Amortissements dérogatoires	 	1	1	1	1	0	961.00000000	1	\N	1	\N
958	78726	Provision spéciale de réévaluation	 	1	1	1	1	0	962.00000000	1	\N	1	\N
959	78727	Plus-values réinvesties	 	1	1	1	1	0	963.00000000	1	\N	1	\N
961	7874	Reprises sur autres provisions réglementées	 	1	1	1	1	0	965.00000000	1	\N	1	\N
962	7875	Reprises sur provisions pour risques et charges exceptionnels	 	1	1	1	1	0	966.00000000	1	\N	1	\N
963	7876	Reprises pour dépréciations exceptionnelles (Règlement n° 2002-10 du CRC)	 	1	1	1	1	0	967.00000000	1	\N	1	\N
964	79	TRANSFERTS DE CHARGES	Le compte 79 « Transferts de charges » enregistre les charges d'exploitation, financières et exceptionnelles à transférer soit à un compte de bilan, autre que les comptes d'immobilisations, soit à un autre compte de charges.	1	1	1	1	0	968.00000000	1	\N	1	\N
965	791	Transferts de charges d'exploitation	 	1	1	1	1	0	969.00000000	1	\N	1	\N
966	796	Transferts de charges financières	 	1	1	1	1	0	970.00000000	1	\N	1	\N
967	797	Transferts de charges exceptionnelles	 	1	1	1	1	0	971.00000000	1	\N	1	\N
974	4286	Autres charges à payer	 	1	1	6	1	0	972.00000000	1	\N	1	\N
975	60265	Emballages récupérables non identifiables	 	1	1	6	1	0	973.00000000	1	\N	1	\N
976	890	Bilan d'ouverture	 	2	4	6	1	0	974.00000000	1	\N	1	\N
977	891	Bilan de clôture	 	2	4	6	1	0	975.00000000	1	\N	1	\N
\.


--
-- Data for Name: CONTACT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CONTACT" ("ID", "NOM", "PRENOM", "TEL_DIRECT", "TEL_MOBILE", "EMAIL", "FAX", "ID_TITRE_PERSONNEL", "ARCHIVE", "ORDRE", "ID_CLIENT", "FONCTION", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "TEL_STANDARD", "TEL_PERSONEL") FROM stdin;
1	Indéfini						2	0	0.00000000	1		1	\N	1	\N		
\.


--
-- Data for Name: CONTACT_ADMINISTRATIF; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CONTACT_ADMINISTRATIF" ("ID", "NOM", "PRENOM", "TEL_DIRECT", "TEL_MOBILE", "EMAIL", "FAX", "FONCTION", "TEL_PERSONEL", "TEL_STANDARD", "ID_TITRE_PERSONNEL", "N4DS", "ARCHIVE", "ORDRE") FROM stdin;
1										1	f	0	0.00000000
\.


--
-- Data for Name: CONTACT_FOURNISSEUR; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CONTACT_FOURNISSEUR" ("ID", "NOM", "PRENOM", "TEL_DIRECT", "TEL_MOBILE", "EMAIL", "FAX", "FONCTION", "TEL_PERSONEL", "TEL_STANDARD", "ID_TITRE_PERSONNEL", "ID_FOURNISSEUR", "ARCHIVE", "ORDRE") FROM stdin;
1										1	1	0	0.00000000
\.


--
-- Data for Name: CONTRAT_SALARIE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CONTRAT_SALARIE" ("ID", "NATURE", "ID_CODE_EMPLOI", "ID_CODE_CONTRAT_TRAVAIL", "ID_CODE_DROIT_CONTRAT", "ID_CODE_CARACT_ACTIVITE", "ID_CODE_STATUT_PROF", "ID_CODE_STATUT_CATEGORIEL", "ARCHIVE", "ORDRE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "CODE_IRC_UGRR", "NUMERO_RATTACHEMENT_UGRR", "CODE_IRC_UGRC", "NUMERO_RATTACHEMENT_UGRC", "CODE_IRC_RETRAITE", "NUMERO_RATTACHEMENT_RETRAITE", "ID_CODE_STATUT_CAT_CONV") FROM stdin;
1	Indéfini	1	1	1	1	1	1	0	0.00000000	1	\N	1	\N							1
\.


--
-- Data for Name: COURRIER_CLIENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "COURRIER_CLIENT" ("ID", "NOM", "ID_MODELE_COURRIER_CLIENT", "INFOS", "ARCHIVE", "ORDRE", "DATE", "NUMERO", "ID_ADRESSE", "ID_CLIENT", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	Indéfini	1		0	0.00000000	\N		1	1	\N	\N	\N	\N
\.


--
-- Data for Name: CUMULS_CONGES; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CUMULS_CONGES" ("ID", "RESTANT", "ACQUIS", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	0	0	0	0.00000000	\N	1	1	\N
\.


--
-- Data for Name: CUMULS_PAYE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "CUMULS_PAYE" ("ID", "SAL_BRUT_C", "COT_PAT_C", "COT_SAL_C", "NET_IMP_C", "NET_A_PAYER_C", "CSG_C", "ARCHIVE", "ORDRE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	0	0	0	0	0	0	0	0.00000000	1	\N	1	\N
\.


--
-- Data for Name: DEPARTEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "DEPARTEMENT" ("ID", "NUMERO", "NOM", "CHEF_LIEU", "REGION_ADMIN", "ARCHIVE", "ORDRE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	0	Indéfini	Indéfini	Indéfini	0	0.00000000	1	\N	1	\N
2	1	Ain	Bourg	Rhône-Alpes	0	1.00000000	1	\N	1	\N
3	3	Allier	Moulins	Auvergne	0	2.00000000	1	\N	1	\N
4	4	Alpes de  \nHaute-Provence	Digne	Provence-Alpes-Côte d'Azur	0	3.00000000	1	\N	1	\N
6	6	Alpes-Maritimes	Nice	Provence-Alpes-Côte d'Azur	0	4.00000000	1	\N	1	\N
7	7	Ardêche	Privas	Rhône-Alpes	0	5.00000000	1	\N	1	\N
8	8	Ardennes	Charleville-Mézières	Champagne-Ardenne	0	6.00000000	1	\N	1	\N
9	9	Ariège	Foix	Midi-Pyrénées	0	7.00000000	1	\N	1	\N
10	10	Aube	Troyes	Champagne-Ardenne	0	8.00000000	1	\N	1	\N
11	11	Aude	Carcassonne	Languedoc-Roussillon	0	9.00000000	1	\N	1	\N
12	12	Aveyron	Rodez	Midi-Pyrénées	0	10.00000000	1	\N	1	\N
68	67	Bas-Rhin	Strasbourg	Alsace	0	11.00000000	1	\N	1	\N
13	13	Bouches-du-Rhône	Marseille	Provence-Alpes-Côte d'Azur	0	12.00000000	1	\N	1	\N
14	14	Calvados	Caen	Basse-Normandie	0	13.00000000	1	\N	1	\N
15	15	Cantal	Aurillac	Auvergne	0	14.00000000	1	\N	1	\N
16	16	Charente	Angoulême	Poitou-Charentes	0	15.00000000	1	\N	1	\N
17	17	Charente-Maritime	La Rochelle	Poitou-Charentes	0	16.00000000	1	\N	1	\N
18	18	Cher	Bourges	Centre	0	17.00000000	1	\N	1	\N
19	19	Corrèze	Tulle	Limousin	0	18.00000000	1	\N	1	\N
21	2B	Corse-du-Sud	Ajaccio	Corse	0	19.00000000	1	\N	1	\N
22	21	Côte-d'Or	Dijon	Bourgogne	0	20.00000000	1	\N	1	\N
23	22	Côtes d'Armor	St Brieuc	Bretagne	0	21.00000000	1	\N	1	\N
24	23	Creuse	Guéret	Limousin	0	22.00000000	1	\N	1	\N
80	79	Deux-Sèvres	Niort	Poitou-Charentes	0	23.00000000	1	\N	1	\N
25	24	Dordogne	Périgueux	Aquitaine	0	24.00000000	1	\N	1	\N
26	25	Doubs	Besançon	Franche-Comté	0	25.00000000	1	\N	1	\N
27	26	Drôme	Valence	Rhône-Alpes	0	26.00000000	1	\N	1	\N
92	91	Essonne	Evry	Ile-de-France	0	27.00000000	1	\N	1	\N
28	27	Eure	Evreux	Haute-Normandie	0	28.00000000	1	\N	1	\N
29	28	Eure-et-Loir	Chartres	Centre	0	29.00000000	1	\N	1	\N
30	29	Finistère	Quimper	Bretagne	0	30.00000000	1	\N	1	\N
31	30	Gard	Nîmes	Languedoc-Roussillon	0	31.00000000	1	\N	1	\N
33	32	Gers	Auch	Midi-Pyrénées	0	32.00000000	1	\N	1	\N
34	33	Gironde	Bordeaux	Aquitaine	0	33.00000000	1	\N	1	\N
97	971	Guadeloupe	Basse-Terre	Antilles/West  \nIndies	0	34.00000000	1	\N	1	\N
98	973	Guyane (française)	Cayenne	Amérique  \ndu Sud/Southern America	0	35.00000000	1	\N	1	\N
69	68	Haut-Rhin	Colmar	Alsace	0	36.00000000	1	\N	1	\N
20	2A	Haute-Corse	Bastia	Corse	0	37.00000000	1	\N	1	\N
32	31	Haute-Garonne	Toulouse	Midi-Pyrénées	0	38.00000000	1	\N	1	\N
44	43	Haute-Loire	Le Puy	Auvergne	0	39.00000000	1	\N	1	\N
53	52	Haute-Marne	Chaumont	Champagne-Ardenne	0	40.00000000	1	\N	1	\N
71	70	Haute-Saône	Vesoul	Franche-Comté	0	41.00000000	1	\N	1	\N
75	74	Haute-Savoie	Annecy	Rhône-Alpes	0	42.00000000	1	\N	1	\N
88	87	Haute-Vienne	Limoges	Limousin	0	43.00000000	1	\N	1	\N
5	5	Hautes-Alpes	Gap	Provence-Alpes-Côte  \nd'Azur	0	44.00000000	1	\N	1	\N
66	65	Hautes-Pyrénées	Tarbes	Midi-Pyrénées	0	45.00000000	1	\N	1	\N
93	92	Hauts-de-Seine	Nanterre	Ile-de-France	0	46.00000000	1	\N	1	\N
35	34	Hérault	Montpellier	Languedoc-Roussillon	0	47.00000000	1	\N	1	\N
36	35	Ile-et-Vilaine	Rennes	Bretagne	0	48.00000000	1	\N	1	\N
37	36	Indre	Chateauroux	Centre	0	49.00000000	1	\N	1	\N
38	37	Indre-et-Loire	Tours	Centre	0	50.00000000	1	\N	1	\N
39	38	Isère	Grenoble	Rhône-Alpes	0	51.00000000	1	\N	1	\N
40	39	Jura	Lons-le-Saunier	Franche-Comté	0	52.00000000	1	\N	1	\N
41	40	Landes	Mont-de-Marsan	Aquitaine	0	53.00000000	1	\N	1	\N
42	41	Loir-et-Cher	Blois	Centre	0	54.00000000	1	\N	1	\N
43	42	Loire	St Etienne	Rhône-Alpes	0	55.00000000	1	\N	1	\N
45	44	Loire-Atlantique	Nantes	Pays de la  \nLoire	0	56.00000000	1	\N	1	\N
46	45	Loiret	Orléans	Centre	0	57.00000000	1	\N	1	\N
47	46	Lot	Cahors	Midi-Pyrénées	0	58.00000000	1	\N	1	\N
48	47	Lot-et-Garonne	Agen	Aquitaine	0	59.00000000	1	\N	1	\N
49	48	Lozère	Mende	Languedoc-Roussillon	0	60.00000000	1	\N	1	\N
50	49	Maine-et-Loire	Angers	Pays de la  \nLoire	0	61.00000000	1	\N	1	\N
51	50	Manche	St Lô	Basse-Normandie	0	62.00000000	1	\N	1	\N
52	51	Marne	Châlons-sur-Marne	Champagne-Ardenne	0	63.00000000	1	\N	1	\N
99	972	Martinique	Fort-de-France	Antilles/West Indies	0	64.00000000	1	\N	1	\N
54	53	Mayenne	Laval	Pays de la Loire	0	65.00000000	1	\N	1	\N
55	54	Meurthe-et-Moselle	Nancy	Lorraine	0	66.00000000	1	\N	1	\N
56	55	Meuse	Bar-le-Duc	Lorraine	0	67.00000000	1	\N	1	\N
57	56	Morbihan	Vannes	Bretagne	0	68.00000000	1	\N	1	\N
58	57	Moselle	Metz	Lorraine	0	69.00000000	1	\N	1	\N
59	58	Nièvre	Nevers	Bourgogne	0	70.00000000	1	\N	1	\N
60	59	Nord	Lille	Nord-Pas-de-Calais	0	71.00000000	1	\N	1	\N
61	60	Oise	Beauvais	Picardie	0	72.00000000	1	\N	1	\N
62	61	Orne	Alençon	Basse-Normandie	0	73.00000000	1	\N	1	\N
76	75	Paris	Paris	Ile-de-France	0	74.00000000	1	\N	1	\N
63	62	Pas-de-Calais	Arras	Nord-Pas-de-Calais	0	75.00000000	1	\N	1	\N
101	99	Pays étranger	 	 	0	76.00000000	1	\N	1	\N
64	63	Puy-de-Dôme	Clermont-Ferrand	Auvergne	0	77.00000000	1	\N	1	\N
65	64	Pyrénées-Atlantiques	Pau	Aquitaine	0	78.00000000	1	\N	1	\N
67	66	Pyrénées-Orientales	Perpignan	Languedoc-Roussillon	0	79.00000000	1	\N	1	\N
100	974	Réunion	St Denis	Océan indien	0	80.00000000	1	\N	1	\N
70	69	Rhône	Lyon	Rhône-Alpes	0	81.00000000	1	\N	1	\N
72	71	Saône-et-Loire	Mâcon	Bourgogne	0	82.00000000	1	\N	1	\N
73	72	Sarthe	Le Mans	Pays de la Loire	0	83.00000000	1	\N	1	\N
74	73	Savoie	Chambéry	Rhône-Alpes	0	84.00000000	1	\N	1	\N
78	77	Seine-et-Marne	Melun	Ile-de-France	0	85.00000000	1	\N	1	\N
77	76	Seine-Maritime	Rouen	Haute-Normandie	0	86.00000000	1	\N	1	\N
94	93	Seine-Saint-Denis	Bobigny	Ile-de-France	0	87.00000000	1	\N	1	\N
81	80	Somme	Amiens	Picardie	0	88.00000000	1	\N	1	\N
82	81	Tarn	Albi	Midi-Pyrénées	0	89.00000000	1	\N	1	\N
83	82	Tarn-et-Garonne	Montauban	Midi-Pyrénées	0	90.00000000	1	\N	1	\N
91	90	Territoire-de-Belfort	Belfort	Franche-Comté	0	91.00000000	1	\N	1	\N
96	95	Val-d'Oise	Pontoise	Ile-de-France	0	92.00000000	1	\N	1	\N
95	94	Val-de-Marne	Créteil	Ile-de-France	0	93.00000000	1	\N	1	\N
84	83	Var	Toulon	Provence-Alpes-Côte  \nd'Azur	0	94.00000000	1	\N	1	\N
85	84	Vaucluse	Avignon	Provence-Alpes-Côte  \nd'Azur	0	95.00000000	1	\N	1	\N
86	85	Vendée	La Roche-sur-Yon	Pays de la  \nLoire	0	96.00000000	1	\N	1	\N
87	86	Vienne	Poitiers	Poitou-Charentes	0	97.00000000	1	\N	1	\N
89	88	Vosges	Epinal	Lorraine	0	98.00000000	1	\N	1	\N
90	89	Yonne	Auxerre	Bourgogne	0	99.00000000	1	\N	1	\N
79	78	Yvelines	Versailles	Ile-de-France	0	100.00000000	1	\N	1	\N
\.


--
-- Data for Name: DEVIS; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "DEVIS" ("ID_DEVIS", "NUMERO", "DATE", "OBJET", "ID_COMMERCIAL", "ID_CLIENT", "T_HT", "T_TVA", "T_TTC", "PORT_HT", "REMISE_HT", "T_SERVICE", "ARCHIVE", "ORDRE", "INFOS", "ID_ETAT_DEVIS", "DATE_ENVOI", "T_POIDS", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE", "ID_ADRESSE", "DATE_VALIDITE", "T_DEVISE", "ID_TARIF", "ID_MODELE") FROM stdin;
1	 	2006-01-01	 	1	1	0	0	0	0	0	0	0	0.00000000	 	1	\N	0	\N	\N	\N	\N	1	\N	0	1	1
\.


--
-- Data for Name: DEVIS_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "DEVIS_ELEMENT" ("ID_DEVIS_ELEMENT", "ID_STYLE", "CODE", "NOM", "PA_HT", "PV_HT", "ID_TAXE", "POIDS", "ARCHIVE", "ORDRE", "QTE", "ID_DEVIS", "SERVICE", "PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_VT_1", "VALEUR_METRIQUE_1", "ID_METRIQUE_1", "PRIX_METRIQUE_HA_2", "PRIX_METRIQUE_VT_2", "VALEUR_METRIQUE_2", "ID_METRIQUE_2", "PRIX_METRIQUE_HA_3", "PRIX_METRIQUE_VT_3", "VALEUR_METRIQUE_3", "ID_METRIQUE_3", "T_PV_HT", "T_PA_HT", "T_PV_TTC", "T_POIDS", "ID_MODE_VENTE_ARTICLE", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE", "QTE_ACHAT", "CODE_DOUANIER", "ID_PAYS", "ID_DEVISE", "PV_U_DEVISE", "POURCENT_REMISE", "PV_T_DEVISE", "TAUX_DEVISE", "DESCRIPTIF", "MARGE_HT", "QTE_UNITAIRE", "ID_UNITE_VENTE", "ID_ARTICLE") FROM stdin;
1	2	 	 	0	0	2	0	0	0.00000000	1	1	f	0	0	0	1	0	0	0	1	0	0	0	1	0	0	0	0	5	\N	1	1	\N	1		1	1	0	0.00	0	1.00000000		0	1.000000	2	1
\.


--
-- Data for Name: ECHANTILLON_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ECHANTILLON_ELEMENT" ("ID", "ORDRE", "ARCHIVE", "NOM", "QTE", "PV_HT", "T_PV_HT", "T_PV_TTC", "ID_TAXE", "ID_SAISIE_VENTE_FACTURE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	0.00000000	0		1	0	0	0	2	1	\N	1	1	\N
\.


--
-- Data for Name: ECHEANCE_CLIENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ECHEANCE_CLIENT" ("ID", "MONTANT", "DATE", "NOMBRE_RELANCE", "ID_MOUVEMENT", "ARCHIVE", "ORDRE", "ID_CLIENT", "REGLE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE", "INFOS", "RETOUR_NATEXIS", "REG_COMPTA", "DATE_LAST_RELANCE") FROM stdin;
1	0	2006-01-01	0	1	0	0.00000000	1	f	\N	\N	\N	\N		f	f	\N
\.


--
-- Data for Name: ECHEANCE_FOURNISSEUR; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ECHEANCE_FOURNISSEUR" ("ID", "MONTANT", "DATE", "ID_MOUVEMENT", "ARCHIVE", "ORDRE", "ID_FOURNISSEUR", "REGLE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	0	2006-01-01	1	0	0.00000000	1	f	\N	1	1	\N
\.


--
-- Data for Name: ECRITURE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ECRITURE" ("ID", "NOM", "ID_MOUVEMENT", "ID_COMPTE_PCE", "DATE", "DEBIT", "CREDIT", "ID_JOURNAL", "ARCHIVE", "VALIDE", "ORDRE", "POINTEE", "DATE_POINTEE", "DATE_VALIDE", "IDUSER_CREATE", "IDUSER_VALIDE", "IDUSER_DELETE", "LETTRAGE", "DATE_LETTRAGE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE", "JOURNAL_NOM", "JOURNAL_CODE", "COMPTE_NOM", "COMPTE_NUMERO") FROM stdin;
1	 	1	1	2006-01-01	0	0	1	0	f	0.00000000	 	\N	\N	1	1	1		\N	\N	\N	\N	\N				
\.


--
-- Data for Name: EMPLOYEUR_MULTIPLE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "EMPLOYEUR_MULTIPLE" ("ID", "NOM", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	Indéfini	0	0.00000000	\N	1	1	\N
2	Unique	0	1.00000000	\N	1	1	\N
3	Multiple	0	2.00000000	\N	1	1	\N
4	Non Connu	0	3.00000000	\N	1	1	\N
\.


--
-- Data for Name: ENCAISSER_MONTANT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ENCAISSER_MONTANT" ("ID", "DATE", "MONTANT", "ID_ECHEANCE_CLIENT", "ID_MODE_REGLEMENT", "ARCHIVE", "ORDRE", "NOM", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE", "ID_CLIENT", "ID_MOUVEMENT", "ID_TICKET_CAISSE") FROM stdin;
1	2006-01-01	0	1	1	0	0.00000000	\N	\N	1	1	\N	1	1	1
\.


--
-- Data for Name: ENCAISSER_MONTANT_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ENCAISSER_MONTANT_ELEMENT" ("ID", "ID_ECHEANCE_CLIENT", "ID_MOUVEMENT_ECHEANCE", "ID_ENCAISSER_MONTANT", "MONTANT_REGLE", "MONTANT_A_REGLER", "ARCHIVE", "ORDRE", "DATE") FROM stdin;
1	1	1	1	0	0	0	0.00000000	\N
\.


--
-- Data for Name: ETAT_CIVIL; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ETAT_CIVIL" ("ID", "ID_ADRESSE", "DATE_NAISSANCE", "NUMERO_SS", "NB_ENFANTS", "COMMUNE_NAISSANCE", "ID_DEPARTEMENT_NAISSANCE", "ID_PAYS_NAISSANCE", "TELEPHONE", "MAIL", "PORTABLE", "NB_PERS_A_CHARGE", "ID_SITUATION_FAMILIALE", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	1	\N	 	0	 	2	61	 	 	 	0	2	0	1.00000000	\N	1	1	\N
\.


--
-- Data for Name: ETAT_DEVIS; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ETAT_DEVIS" ("NOM", "ID", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
En attente	2	0	0.00000000	\N	1	1	\N
 	1	0	1.00000000	\N	1	1	\N
Refusé	3	0	2.00000000	\N	1	1	\N
Accepté	4	0	3.00000000	\N	1	1	\N
En cours de rédaction	5	0	4.00000000	2012-07-23 19:49:58.231	1	1	2012-07-23 19:49:58.231
\.


--
-- Data for Name: ETAT_RAPPORT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "ETAT_RAPPORT" ("ID", "NOM", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	Indéfini	0	0.00000000	\N	1	1	\N
2	En attente	0	0.00000000	\N	1	1	\N
\.


--
-- Data for Name: FAMILLE_ARTICLE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "FAMILLE_ARTICLE" ("ID", "NOM", "CODE", "ID_FAMILLE_ARTICLE_PERE", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	Tous les articles		1	0	0.00000000	\N	1	1	\N
\.


--
-- Data for Name: FICHE_PAYE; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "FICHE_PAYE" ("ID", "ANNEE", "ARCHIVE", "ORDRE", "ID_SALARIE", "ID_PROFIL_PAYE", "SAL_BRUT", "COT_PAT", "COT_SAL", "NET_IMP", "NET_A_PAYER", "ACOMPTE", "ID_MOIS", "VALIDE", "CSG", "DU", "AU", "CONGES_ACQUIS", "ID_CUMULS_PAYE", "ID_CUMULS_CONGES", "ID_VARIABLE_SALARIE", "ID_REGLEMENT_PAYE", "NATURE_EMPLOI", "ID_IDCC", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_MODIFY", "CREATION_DATE") FROM stdin;
1	2006	0	0.00000000	1	1	0	0	0	0	0	0	1	f	0	\N	\N	0	1	1	1	1	 	1	\N	\N	\N	\N
\.


--
-- Data for Name: FICHE_PAYE_ELEMENT; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "FICHE_PAYE_ELEMENT" ("ID", "ID_FICHE_PAYE", "SOURCE", "IDSOURCE", "NOM", "NB_BASE", "TAUX_SAL", "TAUX_PAT", "MONTANT_SAL_AJ", "MONTANT_PAT", "ARCHIVE", "ORDRE", "POSITION", "MONTANT_SAL_DED", "VALIDE", "IMPRESSION", "IN_PERIODE", "ID_USER_COMMON_MODIFY", "MODIFICATION_DATE", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
1	1	 	1	Indéfini	0	0	0	0	0	0	0.00000000	0	\N	f	t	t	1	\N	1	\N
\.


--
-- Data for Name: FOURNISSEUR; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "FOURNISSEUR" ("ID_FOURNISSEUR", "TYPE", "NOM", "CODE", "ID_ADRESSE", "ID_ADRESSE_E", "ARCHIVE", "ORDRE", "UE", "ID_COMPTE_PCE", "ID_MODE_REGLEMENT", "TEL", "FAX", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE", "ID_LANGUE", "ID_DEVISE", "RESPONSABLE", "TEL_P", "MAIL", "INFOS", "ID_COMPTE_PCE_CHARGE") FROM stdin;
1	g	a	a	1	1	0	0.00000000	f	1	1			\N	\N	\N	\N	1	1					1
\.


--
-- Data for Name: FWK_MODULE_METADATA; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "FWK_MODULE_METADATA" ("ID", "MODULE_NAME", "TABLE", "FIELD", "KEY", "MODULE_VERSION") FROM stdin;
\.


--
-- Data for Name: FWK_SCHEMA_METADATA; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "FWK_SCHEMA_METADATA" ("NAME", "VALUE") FROM stdin;
undefined ID policy	min
VERSION	20120723-195012.997+0200
\.


--
-- Data for Name: FWK_UNDEFINED_IDS; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "FWK_UNDEFINED_IDS" ("TABLENAME", "UNDEFINED_ID") FROM stdin;
ADRESSE	1
ARTICLE	1
ASSOCIATION_COMPTE_ANALYTIQUE	1
AVOIR_CLIENT	1
AXE_ANALYTIQUE	1
BON_DE_LIVRAISON	1
BON_DE_LIVRAISON_ELEMENT	1
CAISSE_COTISATION	1
CHEQUE_A_ENCAISSER	1
CHEQUE_FOURNISSEUR	1
CLASSEMENT_CONVENTIONNEL	1
CLASSE_COMPTE	1
CLIENT	1
CODEPOSTAL	1
CODE_CARACT_ACTIVITE	1
CODE_CONTRAT_TRAVAIL	1
CODE_DROIT_CONTRAT	1
CODE_EMPLOI	1
CODE_REGIME	1
CODE_STATUT_CATEGORIEL	1
CODE_STATUT_PROF	1
COMMANDE	1
COMMANDE_CLIENT	1
COMMERCIAL	1
COMPTE_PCE	1
COMPTE_PCG	1
CONTRAT_SALARIE	1
CUMULS_CONGES	1
CUMULS_PAYE	1
DEPARTEMENT	1
DEVIS	1
DEVIS_ELEMENT	1
ECHEANCE_CLIENT	1
ECHEANCE_FOURNISSEUR	1
ECRITURE	1
ELEMENT_STOCK	1
EMPLOYEUR_MULTIPLE	1
ENCAISSER_MONTANT	1
ETAT_CIVIL	1
ETAT_DEVIS	1
EXERCICE	1
FACTURE	1
FICHE_PAYE	1
FICHE_PAYE_ELEMENT	1
FOURNISSEUR	1
IDCC	1
IMPRESSION_RUBRIQUE	1
INFOS_SALARIE_PAYE	1
JOURNAL	1
METRIQUE	1
MODE_REGLEMENT	1
MODE_REGLEMENT_PAYE	1
MOIS	1
MOUVEMENT	1
MOUVEMENT_STOCK	1
NATURE_COMPTE	1
PAYS	1
PERIODE_VALIDITE	1
POSTE_ANALYTIQUE	1
PROFIL_PAYE	1
PROFIL_PAYE_ELEMENT	1
PROPOSITION	1
REGLEMENT_PAYE	1
REGLER_MONTANT	1
RELANCE	1
REPARTITION_ANALYTIQUE	1
REPARTITION_ANALYTIQUE_ELEMENT	1
RUBRIQUE_BRUT	1
RUBRIQUE_COMM	1
RUBRIQUE_COTISATION	1
RUBRIQUE_NET	1
SAISIE_ACHAT	1
SAISIE_KM	1
SAISIE_KM_ELEMENT	1
SAISIE_VENTE_COMPTOIR	1
SAISIE_VENTE_FACTURE	1
SAISIE_VENTE_FACTURE_ELEMENT	1
SALARIE	1
SITUATION_FAMILIALE	1
SOCIETE	1
STOCK	1
STYLE	1
TACHE	1
TACHE_LISTENER	1
TAXE	1
TITRE_PERSONNEL	1
TYPE_COMPTE_PCG	1
TYPE_LETTRE_RELANCE	1
TYPE_REGLEMENT	1
TYPE_RUBRIQUE_BRUT	1
TYPE_RUBRIQUE_NET	1
USER	1
VARIABLE_PAYE	1
COMMANDE_ELEMENT	1
COMMANDE_CLIENT_ELEMENT	1
BON_RECEPTION	1
BON_RECEPTION_ELEMENT	1
MODE_VENTE_ARTICLE	1
AFFAIRE	1
PROPOSITION_ELEMENT	1
AFFAIRE_ELEMENT	1
CODE_MISSION	1
FICHE_RENDEZ_VOUS_ELEMENT	1
FICHE_RENDEZ_VOUS	1
PERIODICITE	1
SECRETAIRE	1
POURCENT_CCIP	1
CONTACT	1
ORDRE_MISSION	1
AFFACTURAGE	1
ECHANTILLON_ELEMENT	1
AVIS_INTERVENTION	1
AVOIR_CLIENT_ELEMENT	1
ETAT_RAPPORT	1
RAPPORT	1
CHEQUE_AVOIR_CLIENT	1
MISSION_PROGRAMMEE	1
MISSION_FACTUREE	1
SECTEUR_ACTIVITE	1
SITE_INTERVENTION	1
NATURE_MISSION	1
AVOIR_FOURNISSEUR	1
POURCENT_SERVICE	1
POLE_PRODUIT	1
BANQUE_POLE_PRODUIT	1
REFERENCE_CLIENT	1
FAMILLE_ARTICLE	1
ENCAISSER_MONTANT_ELEMENT	1
CAISSE	1
TICKET_CAISSE	1
VARIABLE_SALARIE	1
NUMEROTATION_AUTO	1
ACOMPTE	1
PREFERENCES	2
REGIME_BASE	1
PREFS_COMPTE	1
PIECE	1
COURRIER_CLIENT	1
MODELE_COURRIER_CLIENT	1
FWK_MODULE_METADATA	\N
\.


--
-- Data for Name: IDCC; Type: TABLE DATA; Schema: Default; Owner: openconcerto
--

COPY "IDCC" ("ID", "CODE", "NOM", "ARCHIVE", "ORDRE", "MODIFICATION_DATE", "ID_USER_COMMON_MODIFY", "ID_USER_COMMON_CREATE", "CREATION_DATE") FROM stdin;
315	989	Convention collective départementale du crédit mutuel du Nord	0	319.00000000	\N	1	1	\N
412	1384	Convention collective régionale des vins de Champagne	0	415.00000000	\N	1	1	\N
463	1543	Convention collective nationale de la boyauderie	0	466.00000000	\N	1	1	\N
897	9371	Exploitations polyculture, élevage viticulture Indre et Loire	0	896.00000000	\N	1	1	\N
1	 	Indéfini	0	0.00000000	\N	1	1	\N
302	951	Convention collective nationale des théâtres privés	0	1.00000000	\N	1	1	\N
344	1078	Convention collective nationale de la coiffure	0	2.00000000	\N	1	1	\N
496	1618	Convention collective nationale du camping	0	3.00000000	\N	1	1	\N
577	1951	Convention collective nationale des cabinets ou entreprises d'expertises en automobile	0	4.00000000	\N	1	1	\N
625	2150	Convention collective nationale des personnels des sociétés anonymes et fondations d'HLM	0	5.00000000	\N	1	1	\N
747	7010	Aquaculture	0	6.00000000	\N	1	1	\N
2	1	Convention collective pour le commerce Stéphanois, autre que l'alimentation  (Saint-Etienne, Loire)	0	7.00000000	\N	1	1	\N
3	2	Convention collective départementale de l'industrie de la bonneterie et des industries annexes de l'Aube	0	8.00000000	\N	1	1	\N
4	3	Convention collective des ouvriers de la navigation intérieure de marchandises	0	9.00000000	\N	1	1	\N
5	4	Convention collective locale des employés de commerce de magasins du Havre (Seine-Maritime)	0	10.00000000	\N	1	1	\N
6	5	Convention collective du commerce de détail de l'Indre	0	11.00000000	\N	1	1	\N
7	7	Convention collective départementale de l'industrie du bâtiment et des travaux publics du Rhône	0	12.00000000	\N	1	1	\N
8	10	Convention collective des techniciens de post-synchronisation et doublage(cinéma, audiovisuel)	0	13.00000000	\N	1	1	\N
9	11	Convention collective des personnels des ports autonomes maritimes et des chambres de commerce et d'industrie concessionnaires dans les ports maritimes de commerce et de pêche	0	14.00000000	\N	1	1	\N
10	14	Convention collective nationale des techniciens de la production cinématographique	0	15.00000000	\N	1	1	\N
11	16	Convention collective nationale des transports routiers et activités auxiliaires du transport	0	16.00000000	\N	1	1	\N
12	18	Convention collective nationale de l'industrie textile	0	17.00000000	\N	1	1	\N
13	23	Convention collective nationale du personnel sédentaire des entreprises de navigation libre	0	18.00000000	\N	1	1	\N
14	24	Convention collective locale des commerces non alimentaires de Nevers (Nièvre)	0	19.00000000	\N	1	1	\N
15	25	Convention collective locale des industries du peigne de la Vallée de l'Hers et du Touyre (Ariège)	0	20.00000000	\N	1	1	\N
16	29	Convention collective nationale des établissements privés d'hospitalisation, de soins, de cure et de garde à but non lucratif(FEHAP, convention de 1951)	0	21.00000000	\N	1	1	\N
17	35	Convention collective régionale des employés, techniciens et agents de maîtrise des tissages de soierie du Sud-Est	0	22.00000000	\N	1	1	\N
18	39	Convention collective des courtiers en valeurs mobilières de Paris	0	23.00000000	\N	1	1	\N
19	43	Convention collective des entreprises de commission, de courtage et de commerce intracommunautaire et d'importation-exportation de France métropolitaine	0	24.00000000	\N	1	1	\N
20	44	Convention collective nationale des industries chimiques et connexes(UIC)	0	25.00000000	\N	1	1	\N
21	45	Convention collective nationale du caoutchouc	0	26.00000000	\N	1	1	\N
22	50	Convention collective locale des employés de commerce des cantons de Rodez (Aveyron)	0	27.00000000	\N	1	1	\N
23	52	Convention collective départementale de la boulangerie de la Haute-Garonne	0	28.00000000	\N	1	1	\N
24	54	Convention collective des ouvriers, employés, techniciens et agents de maîtrise des industries métallurgiques, mécaniques et connexes de la région parisienne	0	29.00000000	\N	1	1	\N
25	57	Convention collective des tisseurs à domicile rubanier de la région de Saint-Etienne (Loire, Haute-Loire)	0	30.00000000	\N	1	1	\N
26	71	Convention collective départementale du bâtiment du Finistère	0	31.00000000	\N	1	1	\N
27	73	Convention collective nationale de travail des professeurs de l'enseignement secondaire privé laïc	0	32.00000000	\N	1	1	\N
28	75	Convention collective départementale des ouvriers du bâtiment de Lot-et-Garonne	0	33.00000000	\N	1	1	\N
29	76	Convention collective du bâtiment de la Charente	0	34.00000000	\N	1	1	\N
30	80	Convention collective du bâtiment et des travaux publics de la Moselle	0	35.00000000	\N	1	1	\N
31	82	Convention collective départementale des industries métallurgiques métalliques et mécaniques du territoire de Belfort et des régions limitrophes (Montbéliard)	0	36.00000000	\N	1	1	\N
32	83	Convention collective nationale des menuiseries charpentes et constructions industrialisées et des portes planes	0	37.00000000	\N	1	1	\N
33	86	Convention collective nationale des entreprises de publicité et assimilées	0	38.00000000	\N	1	1	\N
34	87	Convention collective nationale des ouvriers des industries de carrières et de matériaux(UNICEM)	0	39.00000000	\N	1	1	\N
35	112	Convention collective nationale de l'industrie laitière	0	40.00000000	\N	1	1	\N
36	113	Convention collective locale des industries de produits réfractaires de Givors (Rhône)	0	41.00000000	\N	1	1	\N
37	114	Convention collective régionale du personnel des maisons grainières de la région parisienne	0	42.00000000	\N	1	1	\N
38	115	Convention collective départementale des ouvriers du bâtiment des Landes	0	43.00000000	\N	1	1	\N
957	9702	Exploitations forestières et sylvicoles Entreprises de travaux agricoles et forestiers (ETAF) Haute Saône (forêt, bois)	0	956.00000000	\N	1	1	\N
39	119	Convention collective des industries métallurgiques, métalliques et mécaniques  du département de la Haute-Saône et des industries qui s'y rattachent	0	44.00000000	\N	1	1	\N
40	120	Convention collective du commerce de détail non alimentaire de Bourges (Cher)	0	45.00000000	\N	1	1	\N
982	9853	Exploitations maraîchères Vendée	0	46.00000000	\N	1	1	\N
41	127	Convention collective des ouvriers du bâtiment des départements Drôme, Ardèche	0	47.00000000	\N	1	1	\N
42	131	Convention collective locale de la tapisserie d'art d'Aubusson-Felletin (Creuse)	0	48.00000000	\N	1	1	\N
43	132	Convention collective départementale des ouvriers du bâtiment de la Marne	0	49.00000000	\N	1	1	\N
44	134	Convention collective départementale des ouvriers du bâtiment des Hautes-Pyrénées	0	50.00000000	\N	1	1	\N
45	135	Convention collective nationale des employés techniciens et agents de maîtrise des industries de carrières et de matériaux(UNICEM)	0	51.00000000	\N	1	1	\N
46	137	Convention collective du bâtiment et des travaux publics de l'Indre-et-Loire	0	52.00000000	\N	1	1	\N
47	140	Convention collective départementale du bâtiment du Puy-de-Dôme	0	53.00000000	\N	1	1	\N
48	142	Convention collective départementale des ouvriers du bâtiment de la Haute-Saône	0	54.00000000	\N	1	1	\N
49	146	Convention collective départementale des ouvriers du bâtiment et des travaux publics de la Nièvre	0	55.00000000	\N	1	1	\N
50	149	Convention collective départementale des ouvriers du bâtiment de la Vienne	0	56.00000000	\N	1	1	\N
51	152	Convention collective départementale des ouvriers du bâtiment de l'Yonne	0	57.00000000	\N	1	1	\N
52	155	Convention collective pour les ouvriers de la fabrication des sacs en papiers de Saint-Junien de la Haute-Vienne	0	58.00000000	\N	1	1	\N
53	157	Convention collective des ouvriers du bâtiment et des travaux publics des Vosges	0	59.00000000	\N	1	1	\N
54	158	Convention collective nationale du travail mécanique du bois, des scieries, du négoce et de l'importation des bois	0	60.00000000	\N	1	1	\N
55	161	Convention collective nationale de la verrerie travaillée mécaniquement au chalumeau	0	61.00000000	\N	1	1	\N
56	162	Convention collective des commerces d'alimentation en gros et demi-gros du département de la Somme	0	62.00000000	\N	1	1	\N
57	164	Convention collective départementale du négoce charbonnier du Rhône	0	63.00000000	\N	1	1	\N
58	171	Convention collective départementale des ouvriers du bâtiment et des travaux publics de Seine-et-Marne	0	64.00000000	\N	1	1	\N
59	172	Convention collective interrégionale de l'industrie du bois de pin maritime en forêt de Gascogne (Charente, Aquitaine)	0	65.00000000	\N	1	1	\N
60	176	Convention collective nationale de l'industrie pharmaceutique (LEEM anciennement SNIP)	0	66.00000000	\N	1	1	\N
61	179	Convention collective nationale du personnel des coopératives de consommation	0	67.00000000	\N	1	1	\N
62	184	Convention collective nationale de l'imprimerie de labeur et des industries graphiques	0	68.00000000	\N	1	1	\N
63	186	Convention collective interrégionale de l'industrie de Roquefort (Languedoc-Rousillon, Pyrénées)	0	69.00000000	\N	1	1	\N
64	189	Convention collective départementale des hôtels cafés restaurants brasseries et tous les établissements s'y rattachant du Rhône	0	70.00000000	\N	1	1	\N
65	190	Convention collective départementale des ouvriers du bâtiment de l'Ille-et-Vilaine	0	71.00000000	\N	1	1	\N
66	192	Convention collective des ouvriers du bâtiment et des travaux publics du Doubs	0	72.00000000	\N	1	1	\N
67	193	Convention collective départementale de l'importation et du commerce en gros des vins et spiritueux de la Loire-Atlantique	0	73.00000000	\N	1	1	\N
68	194	Convention collective dans l'industrie du bâtiment pour le département du Cantal	0	74.00000000	\N	1	1	\N
69	195	Convention collective des entreprises de carénage piquage et travaux maritimes connexes de la région havraise (Seine-Maritime)	0	75.00000000	\N	1	1	\N
70	200	Convention collective nationale des exploitations frigorifiques(froid)	0	76.00000000	\N	1	1	\N
71	201	Convention collective nationale des cadres des agences de renseignements commerciaux	0	77.00000000	\N	1	1	\N
72	207	Convention collective nationale de l'industrie des cuirs et peaux	0	78.00000000	\N	1	1	\N
73	208	Convention collective départementale des ouvriers du bâtiment du territoire de Belfort	0	79.00000000	\N	1	1	\N
74	210	Convention collective des commerces de détail non alimentaires de l'arrondissement de Saint-Malo (Ille-et-Vilaine)	0	80.00000000	\N	1	1	\N
75	211	Convention collective nationale des cadres des industries de carrières et matériaux (UNICEM)	0	81.00000000	\N	1	1	\N
76	212	Convention collective locale des grands magasins de nouveautés et spécialités s'y rattachant de Rouen (Seine-Maritime)	0	82.00000000	\N	1	1	\N
77	214	Convention collective des ouvriers  des entreprises de presse de la région parisienne	0	83.00000000	\N	1	1	\N
78	218	Convention collective nationale des organismes de sécurité sociale(SS)	0	84.00000000	\N	1	1	\N
79	226	Convention collective départementale des ouvriers du bâtiment de Maine-et-Loire	0	85.00000000	\N	1	1	\N
80	231	Convention collective des employés des magasins populaires de Seine-et-Marne	0	86.00000000	\N	1	1	\N
81	232	Convention collective départementale des commerces d'alimentation générale de détail de la Somme	0	87.00000000	\N	1	1	\N
82	233	Convention collective départementale des maîtres et artisans tailleurs de la Loire-Atlantique	0	88.00000000	\N	1	1	\N
83	239	Convention collective départementale des commerces de la Sarthe	0	89.00000000	\N	1	1	\N
84	240	Convention collective nationale du personnel des greffes des tribunaux de commerce	0	90.00000000	\N	1	1	\N
85	246	Convention collective régionale du notariat de la Cour d'appel de Colmar (Alsace)	0	91.00000000	\N	1	1	\N
86	247	Convention collective nationale des industries de l'habillement[rattachement de l'industrie du bouton et de l'industries de la bretelle et de la ceinture](bouton, bretelle, ceinture)	0	92.00000000	\N	1	1	\N
87	249	Convention collective ouvrière de la distribution charbonnière de la région parisienne	0	93.00000000	\N	1	1	\N
88	252	Convention collective départementale des ouvriers du bâtiment et des travaux publics de l'Ain	0	94.00000000	\N	1	1	\N
89	255	Convention collective nationale des employés, techniciens et agents de maîtrise du bâtiment	0	95.00000000	\N	1	1	\N
90	265	Convention collective locale des dessinateurs des cabinets de dessin de la ville de Lyon et des localités de la communaute urbaine de Lyon (Rhône)	0	96.00000000	\N	1	1	\N
92	271	Convention collective des commerces non alimentaires de la Somme	0	97.00000000	\N	1	1	\N
94	276	Convention collective départementale des commerces de gros demi-gros et détail de la Haute-Vienne	0	99.00000000	\N	1	1	\N
95	277	Convention collective nationale de travail réglant les rapports entre les avoués près les Cours d'appel et leur personnel	0	100.00000000	\N	1	1	\N
96	278	Convention collective locale des grands magasins de Brest (Finistère)	0	101.00000000	\N	1	1	\N
97	279	Convention collective des ouvriers du bâtiment et des travaux publics pour le département de l'Allier	0	102.00000000	\N	1	1	\N
98	280	Convention collective des employés du commerce de la distribution charbonnière de la région parisienne	0	103.00000000	\N	1	1	\N
99	281	Convention collective des dessinateurs pour textiles, papiers peints, toiles cirées et linoleums de la région parisienne	0	104.00000000	\N	1	1	\N
100	285	Convention collective de travail des instituteurs et institutrices de l'enseignement privé laïc du premier degré	0	105.00000000	\N	1	1	\N
101	292	Convention collective nationale de la plasturgie (transformation des matières plastiques)	0	106.00000000	\N	1	1	\N
102	294	Convention collective nationale des ouvriers indépendants de studios de la production cinématographique	0	107.00000000	\N	1	1	\N
103	295	Convention collective régionale du notariat de la Cour d'appel de Rouen (Haute-Normandie)	0	108.00000000	\N	1	1	\N
104	296	Convention collective locale des commerces de la région Roubaix-Tourcoing (Nord)	0	109.00000000	\N	1	1	\N
105	303	Convention collective régionale de la couture parisienne	0	110.00000000	\N	1	1	\N
106	306	Convention collective des cadres techniques de la presse quotidienne parisienne	0	111.00000000	\N	1	1	\N
107	311	Convention collective départementale de la couture de la Loire-Atlantique	0	112.00000000	\N	1	1	\N
108	313	Convention collective locale pour le transit des primeurs d'Afrique du Nord à Marseille (Bouches-du-Rhône)	0	113.00000000	\N	1	1	\N
109	314	Convention collective régionale des entreprises de vidanges du Nord Pas-de-Calais et de la Somme	0	114.00000000	\N	1	1	\N
110	349	Convention collective des guides interprètes de la région parisienne	0	115.00000000	\N	1	1	\N
111	350	Convention collective nationale des industries de la mode et de la chapellerie	0	116.00000000	\N	1	1	\N
112	351	Convention collective départementale des ouvriers du bâtiment et des travaux publics de la Vendée	0	117.00000000	\N	1	1	\N
113	352	Convention collective régionale des commerces non alimentaires du territoire de Belfort et de la région de Montbéliard	0	118.00000000	\N	1	1	\N
114	354	Convention collective nationale de la ganterie de peau	0	119.00000000	\N	1	1	\N
115	356	Convention collective régionale du notariat du Nord-Pas-de-Calais	0	120.00000000	\N	1	1	\N
116	357	Convention collective départementale du bâtiment de l'équipement électrique et des travaux publics de la Haute-Garonne	0	121.00000000	\N	1	1	\N
117	361	Convention collective des ouvriers du bâtiment du département de l'Indre	0	122.00000000	\N	1	1	\N
118	362	Convention collective départementale des ouvriers du bâtiment et des travaux publics du Tarn-et-Garonne	0	123.00000000	\N	1	1	\N
119	363	Convention collective nationale du personnel ingénieurs et cadres de l'industrie de la fabrication des ciments	0	124.00000000	\N	1	1	\N
120	365	Convention collective des ouvriers du bâtiment du Gers	0	125.00000000	\N	1	1	\N
121	367	Convention collective locale des commerces de la région lilloise (Nord)	0	126.00000000	\N	1	1	\N
122	369	Convention collective départementale des ouvriers du bâtiment et des travaux publics de Dordogne	0	127.00000000	\N	1	1	\N
123	372	Convention collective départementale des ouvriers du bâtiment et des travaux publics de l'Ariège	0	128.00000000	\N	1	1	\N
124	376	Convention collective locale du personnel ouvrier dans les industries de la salaison et de la morue du canton de Fécamp (Seine-Maritime)	0	129.00000000	\N	1	1	\N
125	377	Convention collective du commerce des villes des Bouches-du-Rhône à l'exception de Marseille	0	130.00000000	\N	1	1	\N
126	379	Convention collective du travail des commerces de la Martinique	0	131.00000000	\N	1	1	\N
127	386	Convention collective des grands magasins de Meurthe-et-Moselle	0	132.00000000	\N	1	1	\N
128	388	Convention collective nationale des auditoriums cinématographiques	0	133.00000000	\N	1	1	\N
129	390	Convention collective de travail des professeurs de l'enseignement secondaire libre enseignant dans les établissements hors contrat et dans les établissements sous contrat mais sans être contractuels	0	134.00000000	\N	1	1	\N
130	392	Convention collective locale de l'industrie textile de Roubaix-Tourcoing, vallée de la Lys (Nord)	0	135.00000000	\N	1	1	\N
131	394	Convention collective des employés de la presse quotidienne parisienne	0	136.00000000	\N	1	1	\N
132	398	Convention collective nationale des ouvriers du négoce des matériaux de construction	0	137.00000000	\N	1	1	\N
133	400	Convention collective départementale du commerce de l'habillement de la Vienne	0	138.00000000	\N	1	1	\N
134	403	Convention collective nationale des employés, techniciens et agents de maîtrise des entreprises de travaux publics	0	139.00000000	\N	1	1	\N
135	405	Convention collective nationale des établissements médico-sociaux de l'union intersyndicale des secteurs sanitaires et sociaux     (UNISSS, FFESCPE, convention de 1965, enfants, adolescents )	0	140.00000000	\N	1	1	\N
136	406	Convention collective des commerces de détail non alimentaires du département du Calvados, élargie au département de la Mayenne	0	141.00000000	\N	1	1	\N
137	409	Convention collective du bâtiment et des travaux publics de la région du Limousin	0	142.00000000	\N	1	1	\N
138	412	Convention collective nationale de travail des guides accompagnateurs et accompagnateurs au service des agences de voyages et de tourisme	0	143.00000000	\N	1	1	\N
139	413	Convention collective nationale de travail des établissements et services pour personnes inadaptées et handicapées   (convention de 1966, SNAPEI )	0	144.00000000	\N	1	1	\N
93	275	Convention collective nationale du personnel au sol des entreprises de transport aérien	0	98.00000000	\N	1	1	\N
140	416	Convention collective départementale des ouvriers du bâtiment et des travaux publics du département des Côtes-du-Nord(Côtes d'Armor)	0	145.00000000	\N	1	1	\N
141	418	Convention collective nationale de la chemiserie sur mesure	0	146.00000000	\N	1	1	\N
142	426	Convention collective locale du personnel des cabinets d'avocats de Nantes (Loire-Atlantique)	0	147.00000000	\N	1	1	\N
143	427	Convention collective interrégionale de l'industrie textile d'Elbeuf Louviers et de la région (Seine-Maritime, Eure, Calvados, Eure-et-loir, Loire-Atlantique)	0	148.00000000	\N	1	1	\N
144	432	Convention collective des cadres des entreprises de manutention du port de Marseille	0	149.00000000	\N	1	1	\N
145	434	Convention collective des employés du commerce de la nouveauté et des spécialités qui s'y rattachent de la ville de Nantes (Loire-Atlantique)	0	150.00000000	\N	1	1	\N
146	435	Convention collective nationale des acteurs de la production cinématographique	0	151.00000000	\N	1	1	\N
147	436	Convention collective départementale des ouvriers du bâtiment et des travaux publics de la Charente-Maritime	0	152.00000000	\N	1	1	\N
148	437	Convention collective locale des cadres et agents de maîtrise du commerce de la nouveauté de Nantes (Loire-Atlantique)	0	153.00000000	\N	1	1	\N
149	438	Convention collective nationale de travail des échelons intermédiaires des services extérieurs de production des sociétés d'assurances	0	154.00000000	\N	1	1	\N
150	440	Convention collective départementale des sucreries et sucreries-distilleries de la Réunion	0	155.00000000	\N	1	1	\N
151	441	Convention collective locale des grands magasins à rayons multiples de Bastia (Corse)	0	156.00000000	\N	1	1	\N
152	447	Convention collective départementale des ouvriers du bâtiment des Pyrénées-Atlantiques	0	157.00000000	\N	1	1	\N
153	450	Convention collective nationale des entreprises de commerce de gros de jouets bimbeloterie bazars	0	158.00000000	\N	1	1	\N
154	454	Convention collective nationale des téléphériques et engins de remontées mécaniques	0	159.00000000	\N	1	1	\N
155	455	Convention collective de travail des commerces de détail non alimentaires de la Meuse	0	160.00000000	\N	1	1	\N
156	456	Convention collective départementale des ouvriers du bâtiment du Morbihan	0	161.00000000	\N	1	1	\N
157	468	Convention collective nationale des employés des entreprise à succursales du commerce de détail de la chaussure	0	162.00000000	\N	1	1	\N
158	477	Convention collective des industries de la blanchisserie, de la teinturerie et du nettoyage de Lorraine	0	163.00000000	\N	1	1	\N
159	478	Convention collective nationale des sociétés financières (établissements financiers)	0	164.00000000	\N	1	1	\N
160	483	Convention collective locale des commerces du vêtement et de la nouveauté de l'arrondissement de Valenciennes (Nord)	0	165.00000000	\N	1	1	\N
161	484	Convention collective interrégionale du crédit mutuel d'Alsace-Lorraine	0	166.00000000	\N	1	1	\N
162	486	Convention collective départementale des commerces de détail de l'habillement, des détaillants en chaussures, des magasins à rayons multiples de Saône-et-Loire	0	167.00000000	\N	1	1	\N
163	489	Convention collective du personnel des industries du cartonnage	0	168.00000000	\N	1	1	\N
164	490	Convention collective des commerces de détail alimentaires et non alimentaires des Vosges	0	169.00000000	\N	1	1	\N
165	493	Convention collective nationale des vins, cidres, jus de fruits, sirops, spiritueux et liqueurs de France	0	170.00000000	\N	1	1	\N
166	500	Convention collective nationale de travail des commerces de gros en bonneterie, lingerie, confection, mercerie, chaussures et négoces connexes	0	171.00000000	\N	1	1	\N
167	504	Convention collective nationale des industries alimentaires diverses(Agroalimentaire, Groupe des 5 branches)	0	172.00000000	\N	1	1	\N
168	506	Convention collective nationale des fabricants, importateurs et transformateurs de produits exotiques(Agroalimentaire, Groupe des 5 branches)	0	173.00000000	\N	1	1	\N
169	508	Convention collective régionale du personnel ouvrier d'exploitation de chauffage pour la région lyonnaise (Lyon)	0	174.00000000	\N	1	1	\N
170	509	Convention collective des cadres administratifs de la presse quotidienne parisienne	0	175.00000000	\N	1	1	\N
171	510	Convention collective locale des grands magasins de l'arrondissement d'Avesnes (Nord)	0	176.00000000	\N	1	1	\N
172	513	Convention collective locale des magasins populaires de l'arrondissement de Valenciennes (Nord)	0	177.00000000	\N	1	1	\N
173	524	Convention collective des commerces de gros de bière, des eaux minérales, des jus de fruits et boissons gazeuses de la région parisienne	0	178.00000000	\N	1	1	\N
174	525	Convention collective départementale des ouvriers du bâtiment de la Sarthe	0	179.00000000	\N	1	1	\N
175	528	Convention collective régionale des industries de la teinture nettoyage et de la blanchisserie du Nord et du Pas-de-Calais	0	180.00000000	\N	1	1	\N
176	530	Convention collective départementale des commerces non alimentaires des Bouches-du-Rhône	0	181.00000000	\N	1	1	\N
177	533	Convention collective nationale des employés, techniciens et agents de maîtrise du négoce des matériaux de construction	0	182.00000000	\N	1	1	\N
178	538	Convention collective nationale du personnel des entreprises de manutention ferroviaire et travaux connexes	0	183.00000000	\N	1	1	\N
179	539	Convention collective locale des commerces non alimentaires de Pau et d'Oloron (Pyrénées-Atlantiques)	0	184.00000000	\N	1	1	\N
180	541	Convention collective départementale du commerce de détail des chaussures de la Loire-Atlantique	0	185.00000000	\N	1	1	\N
181	547	Convention collective départementale de l'industrie hôtelière du Vaucluse	0	186.00000000	\N	1	1	\N
182	548	Conventio