/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.Transformer;
import org.openconcerto.utils.change.ListChange;
import org.openconcerto.utils.change.ListChangeIndex;

public class ListChangeRecipe<T>
implements ListChange<T> {
    private final List<ListChangeIndex<T>> changes;
    private final List<IClosure<? super ListChangeIndex<T>>> listeners;
    private final Map<List<?>, Pair<?>> boundLists;

    public ListChangeRecipe(boolean record) {
        this.changes = record ? new ArrayList() : null;
        this.listeners = new ArrayList<IClosure<? super ListChangeIndex<T>>>();
        this.boundLists = new IdentityHashMap();
    }

    public final boolean recordChanges() {
        return this.changes != null;
    }

    public final List<ListChangeIndex<T>> getChanges() {
        if (!this.recordChanges()) {
            throw new IllegalStateException("This instance wasn't created to record changes");
        }
        return this.changes;
    }

    public void addListener(IClosure<? super ListChangeIndex<T>> l) {
        this.listeners.add(l);
    }

    public void rmListener(IClosure<? super ListChangeIndex<T>> l) {
        this.listeners.remove(l);
    }

    public void bind(List<T> l) {
        this.bind(l, Transformer.nopTransformer());
    }

    public <U> void bind(List<U> l, ITransformer<T, U> transf) {
        this.boundLists.put(l, new Pair<U>(l, transf));
    }

    private final void add(ListChangeIndex<T> change) {
        if (this.recordChanges()) {
            this.changes.add(change);
        }
        for (Pair<?> pair : this.boundLists.values()) {
            pair.apply(change);
        }
        for (IClosure iClosure : this.listeners) {
            iClosure.executeChecked(change);
        }
    }

    public void add(int index0, Collection<? extends T> c) {
        this.add(new ListChangeIndex.Add<T>(index0, c));
    }

    public void remove(int index0, int index1, List<T> removed) {
        this.add(new ListChangeIndex.Rm<T>(index0, index1, removed));
    }

    public void set(int index0, T old, T newItem) {
        this.add(new ListChangeIndex.Set<T>(index0, old, newItem));
    }

    @Override
    public <U> void apply(List<U> l, ITransformer<T, U> transf) throws IllegalStateException {
        for (ListChange listChange : this.getChanges()) {
            listChange.apply(l, transf);
        }
    }

    private final class Pair<U> {
        private final List<U> l;
        private final ITransformer<T, U> transf;

        public Pair(List<U> l, ITransformer<T, U> transf) {
            this.l = l;
            this.transf = transf;
        }

        void apply(ListChange<T> change) {
            change.apply(this.l, this.transf);
        }
    }
}

