/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EnumOrderedSet<E extends Enum<E>>
extends AbstractSet<E> {
    private final List<E> levels;
    private final Map<E, Integer> indices;

    private EnumOrderedSet(Set<E> set) {
        this.levels = new ArrayList<E>(set);
        this.indices = new HashMap<E, Integer>();
    }

    public EnumOrderedSet(EnumSet<E> set) {
        this((Set<E>)set);
    }

    public final E get(int i) {
        return (E)((Enum)this.levels.get(i));
    }

    private final int indexOf(E l) {
        Integer res = this.indices.get(l);
        if (res == null) {
            res = this.levels.indexOf(l);
            this.indices.put(l, res);
        }
        return res;
    }

    @Override
    public final boolean contains(E l) {
        return this.indexOf(l) >= 0;
    }

    public final int getHops(E l1, E l2) {
        int i2 = this.indexOf(l2);
        int i1 = this.indexOf(l1);
        if (i1 < 0) {
            throw new IllegalArgumentException(l1 + " is not in " + this);
        }
        if (i2 < 0) {
            throw new IllegalArgumentException(l2 + " is not in " + this);
        }
        return i2 - i1;
    }

    public final E getPrevious(E l) {
        return this.getFrom(l, -1);
    }

    public final E getNext(E l) {
        return this.getFrom(l, 1);
    }

    public final E getFrom(E l, int offset) {
        return this.getFrom(l, offset, false);
    }

    public final E getFrom(E l, int offset, boolean cyclic) {
        int i = this.indexOf(l);
        if (i < 0) {
            throw new IllegalArgumentException(l + " is not in " + this);
        }
        int destIndex = cyclic ? (i + offset) % this.levels.size() : i + offset;
        try {
            return (E)((Enum)this.levels.get(destIndex));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.levels.iterator();
    }

    @Override
    public int size() {
        return this.levels.size();
    }
}

