/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class CollectionMap2<K, C extends Collection<V>, V>
extends HashMap<K, C> {
    private static final Mode DEFAULT_MODE = Mode.NULL_FORBIDDEN;
    private final boolean emptyCollSameAsNoColl;
    private final Mode mode;

    private static final String toStr(Object o) {
        return o == null ? "null" : "'" + o + "'";
    }

    public CollectionMap2() {
        this(DEFAULT_MODE);
    }

    public CollectionMap2(Mode mode) {
        this(mode, null);
    }

    public CollectionMap2(Mode mode, Boolean emptyCollSameAsNoColl) {
        this(16, mode, emptyCollSameAsNoColl);
    }

    public CollectionMap2(int initialCapacity) {
        this(initialCapacity, DEFAULT_MODE, null);
    }

    public CollectionMap2(int initialCapacity, Mode mode, Boolean emptyCollSameAsNoColl) {
        super(initialCapacity);
        this.mode = mode;
        this.emptyCollSameAsNoColl = emptyCollSameAsNoColl == null ? mode == Mode.NULL_MEANS_ALL : emptyCollSameAsNoColl;
    }

    public CollectionMap2(Map<? extends K, ? extends Collection<? extends V>> m) {
        super(m.size());
        if (m instanceof CollectionMap2) {
            CollectionMap2 collM = (CollectionMap2)m;
            this.mode = collM.getMode();
            this.emptyCollSameAsNoColl = collM.isEmptyCollSameAsNoColl();
        } else {
            this.mode = DEFAULT_MODE;
            this.emptyCollSameAsNoColl = this.mode == Mode.NULL_MEANS_ALL;
        }
        this.putAllCollections(m);
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final boolean isEmptyCollSameAsNoColl() {
        return this.emptyCollSameAsNoColl;
    }

    @Override
    public Set<Map.Entry<K, C>> entrySet() {
        if (this.getMode() == Mode.NULL_FORBIDDEN) {
            return new EntrySet(super.entrySet());
        }
        return super.entrySet();
    }

    @Override
    public final C put(K key, C value) {
        return this.putCollection(key, (Collection<? extends V>)value);
    }

    public final C putCollection(K key, Collection<? extends V> value) {
        if (value == null && this.getMode() == Mode.NULL_FORBIDDEN) {
            throw new NullPointerException("Putting null collection for " + CollectionMap2.toStr(key));
        }
        return (C)((Collection)super.put(key, value == null ? null : (Object)this.createCollection(value)));
    }

    public void putAllCollections(Map<? extends K, ? extends Collection<? extends V>> m) {
        for (Map.Entry<K, Collection<V>> e : m.entrySet()) {
            this.putCollection(e.getKey(), e.getValue());
        }
    }

    public final void add(K k, V v) {
        this.addAll(k, Collections.singleton(v));
    }

    public final void addAll(K k, Collection<? extends V> v) {
        boolean nullIsAll;
        boolean bl = nullIsAll = this.getMode() == Mode.NULL_MEANS_ALL;
        if (v == null && !nullIsAll) {
            throw new NullPointerException("Adding null collection for " + CollectionMap2.toStr(k));
        }
        if (v == null || !this.containsKey(k)) {
            this.putCollection(k, v);
        } else {
            Collection currentColl = (Collection)this.get(k);
            if (!nullIsAll || currentColl != null) {
                currentColl.addAll(v);
            }
        }
    }

    public final void addAll(Map<? extends K, ? extends Collection<? extends V>> mm) {
        for (Map.Entry<K, Collection<V>> e : mm.entrySet()) {
            this.addAll(e.getKey(), e.getValue());
        }
    }

    private final void removeAll(K k, Collection<? extends V> v, Iterator<Map.Entry<K, C>> iter) {
        boolean removeK = false;
        if (this.getMode() == Mode.NULL_MEANS_ALL) {
            if (v == null) {
                removeK = true;
            } else if (v.size() > 0) {
                Collection currentColl = (Collection)this.get(k);
                if (currentColl == null) {
                    throw new IllegalStateException("Cannot remove from all for " + CollectionMap2.toStr(k));
                }
                currentColl.removeAll(v);
                if (currentColl.isEmpty()) {
                    removeK = true;
                }
            }
        } else if (this.containsKey(k)) {
            Collection currentColl = (Collection)this.get(k);
            if (currentColl == null && v == null) {
                assert (this.getMode() == Mode.NULL_ALLOWED);
                removeK = true;
            } else {
                if (v == null) {
                    throw new NullPointerException("Removing null collection for " + CollectionMap2.toStr(k));
                }
                currentColl.removeAll(v);
                if (currentColl.isEmpty()) {
                    removeK = true;
                }
            }
        }
        if (removeK) {
            if (iter == null) {
                this.remove(k);
            } else {
                iter.remove();
            }
        }
    }

    public final void removeAll(Map<? extends K, ? extends Collection<? extends V>> mm) {
        Iterator<Map.Entry<K, C>> iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, C> e = iter.next();
            K key = e.getKey();
            if (!mm.containsKey(key)) continue;
            this.removeAll(key, mm.get(key), iter);
        }
    }

    public final void removeAllEmptyCollections() {
        this.removeAll(true);
    }

    private final void removeAll(boolean emptyOrNull) {
        Iterator<Map.Entry<K, C>> iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, C> e = iter.next();
            Collection val = (Collection)e.getValue();
            if ((!emptyOrNull || val == null || !val.isEmpty()) && (emptyOrNull || val != null)) continue;
            iter.remove();
        }
    }

    protected abstract C createCollection(Collection<? extends V> var1);

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.emptyCollSameAsNoColl ? 1231 : 1237);
        result = 31 * result + this.mode.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionMap2 other = (CollectionMap2)obj;
        return this.emptyCollSameAsNoColl == other.emptyCollSameAsNoColl && this.mode == other.mode;
    }

    private final class EntrySet
    extends AbstractCollection<Map.Entry<K, C>>
    implements Set<Map.Entry<K, C>> {
        private final Set<Map.Entry<K, C>> delegate;

        public EntrySet(Set<Map.Entry<K, C>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Iterator<Map.Entry<K, C>> iterator() {
            return new Iterator<Map.Entry<K, C>>(){
                private final Iterator<Map.Entry<K, C>> delegateIter;
                {
                    this.delegateIter = EntrySet.this.delegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIter.hasNext();
                }

                @Override
                public Map.Entry<K, C> next() {
                    final Map.Entry delegate = this.delegateIter.next();
                    return new Map.Entry<K, C>(){

                        @Override
                        public K getKey() {
                            return delegate.getKey();
                        }

                        @Override
                        public C getValue() {
                            return (Collection)delegate.getValue();
                        }

                        @Override
                        public C setValue(C value) {
                            if (value == null) {
                                throw new NullPointerException("Putting null collection for " + CollectionMap2.toStr(this.getKey()));
                            }
                            return (Collection)delegate.setValue(value);
                        }
                    };
                }

                @Override
                public void remove() {
                    this.delegateIter.remove();
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }
    }

    public static enum Mode {
        NULL_FORBIDDEN,
        NULL_ALLOWED,
        NULL_MEANS_ALL;

    }
}

