/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JToggleButton;
import org.openconcerto.ui.valuewrapper.BooleanValueWrapper;
import org.openconcerto.ui.valuewrapper.ConvertorValueWrapper;
import org.openconcerto.ui.valuewrapper.JFormattedTextFieldValueWrapper;
import org.openconcerto.ui.valuewrapper.TextValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapperFromVO;
import org.openconcerto.ui.valuewrapper.format.FormatValueWrapper;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.checks.MutableValueObject;
import org.openconcerto.utils.checks.ValueObject;
import org.openconcerto.utils.convertor.ValueConvertor;
import org.openconcerto.utils.convertor.ValueConvertorFactory;

public class ValueWrapperFactory {
    public static <Z> ValueWrapper<Z> create(JComponent comp, Class<Z> c) {
        if (ValueWrapperFactory.isValueWrapper(comp, c)) {
            return (ValueWrapper)((Object)comp);
        }
        if (ValueWrapperFactory.getConvertorVW(comp, c) != null) {
            return ValueWrapperFactory.getConvertorVW(comp, c);
        }
        if (ValueWrapperFactory.isValueObject(comp, c)) {
            return new ValueWrapperFromVO((MutableValueObject)((Object)comp));
        }
        if (comp instanceof JFormattedTextField && JFormattedTextFieldValueWrapper.isCompatible((JFormattedTextField)comp, c)) {
            return new JFormattedTextFieldValueWrapper<Z>((JFormattedTextField)comp, c);
        }
        if (Boolean.class.isAssignableFrom(c)) {
            return new BooleanValueWrapper((JToggleButton)comp);
        }
        if (String.class.isAssignableFrom(c)) {
            return TextValueWrapper.create(comp);
        }
        if (Number.class.isAssignableFrom(c)) {
            return FormatValueWrapper.create(comp, c);
        }
        throw new IllegalArgumentException("no suitable value wrapper for " + comp + " and " + c);
    }

    private static <Z> boolean isValueWrapper(JComponent comp, Class<Z> c) {
        if (!(comp instanceof ValueWrapper)) {
            return false;
        }
        return ReflectUtils.isCastable((ValueWrapper)((Object)comp), ValueWrapper.class, c);
    }

    private static <Z> ConvertorValueWrapper<Z, ?> getConvertorVW(JComponent comp, Class<Z> c) {
        if (!(comp instanceof ValueWrapper)) {
            return null;
        }
        ValueWrapper vw = (ValueWrapper)((Object)comp);
        List<Class<?>> typeArguments = ReflectUtils.getTypeArguments(vw, ValueWrapper.class);
        if (typeArguments.size() == 0) {
            throw new IllegalArgumentException("unable to find type arguments of " + vw + " \n(you should define a class that specify them, eg class C extends ValueWrapper<Integer>)");
        }
        Class<?> typeArgument = typeArguments.get(0);
        return ValueWrapperFactory.createCVW(vw, typeArgument, c);
    }

    private static <T, U> ConvertorValueWrapper<T, U> createCVW(ValueWrapper<U> comp, Class<U> typeArgument, Class<T> c) {
        ValueConvertor<T, U> vc = ValueConvertorFactory.find(c, typeArgument);
        if (vc == null) {
            return null;
        }
        return new ConvertorValueWrapper<T, U>(comp, vc);
    }

    private static <Z> boolean isValueObject(JComponent comp, Class<Z> c) {
        if (!(comp instanceof MutableValueObject)) {
            return false;
        }
        return ReflectUtils.isCastable((MutableValueObject)((Object)comp), ValueObject.class, c);
    }
}

