/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.convertor.ValueConvertor;

public class ConvertorValueWrapper<T, U>
implements ValueWrapper<T> {
    private final ValueWrapper<U> delegate;
    private final ValueConvertor<T, U> conv;

    public ConvertorValueWrapper(ValueWrapper<U> delegate, ValueConvertor<T, U> conv) {
        if (delegate == null || conv == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.conv = conv;
    }

    @Override
    public JComponent getComp() {
        return this.delegate.getComp();
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.delegate.addValidListener(l);
    }

    @Override
    public ValidState getValidState() {
        return this.delegate.getValidState();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.delegate.addValueListener(l);
    }

    @Override
    public void resetValue() {
        this.delegate.resetValue();
    }

    @Override
    public T getValue() {
        return this.conv.unconvert(this.delegate.getValue());
    }

    @Override
    public void setValue(T val) {
        this.delegate.setValue(this.conv.convert(val));
    }
}

