/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class XTableColumnModel
extends DefaultTableColumnModel {
    protected List<TableColumn> allTableColumns = new Vector<TableColumn>();

    public void setColumnVisible(TableColumn column, boolean visible) {
        if (!visible) {
            super.removeColumn(column);
        } else {
            int noVisibleColumns = this.tableColumns.size();
            int noInvisibleColumns = this.allTableColumns.size();
            int visibleIndex = 0;
            int invisibleIndex = 0;
            while (invisibleIndex < noInvisibleColumns) {
                TableColumn visibleColumn = visibleIndex < noVisibleColumns ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                TableColumn testColumn = this.allTableColumns.get(invisibleIndex);
                if (testColumn == column) {
                    if (visibleColumn != column) {
                        super.addColumn(column);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    return;
                }
                if (testColumn == visibleColumn) {
                    ++visibleIndex;
                }
                ++invisibleIndex;
            }
        }
    }

    public TableColumn getColumnByModelIndex(int modelColumnIndex) {
        int columnIndex = 0;
        while (columnIndex < this.allTableColumns.size()) {
            TableColumn column = this.allTableColumns.get(columnIndex);
            if (column.getModelIndex() == modelColumnIndex) {
                return column;
            }
            ++columnIndex;
        }
        return null;
    }

    public boolean isColumnVisible(TableColumn aColumn) {
        return this.tableColumns.indexOf(aColumn) >= 0;
    }

    @Override
    public void addColumn(TableColumn column) {
        this.allTableColumns.add(column);
        super.addColumn(column);
    }

    @Override
    public void removeColumn(TableColumn column) {
        int allColumnsIndex = this.allTableColumns.indexOf(column);
        if (allColumnsIndex != -1) {
            this.allTableColumns.remove(allColumnsIndex);
        }
        super.removeColumn(column);
    }

    @Override
    public void moveColumn(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        TableColumn fromColumn = (TableColumn)this.tableColumns.get(oldIndex);
        TableColumn toColumn = (TableColumn)this.tableColumns.get(newIndex);
        int allColumnsOldIndex = this.allTableColumns.indexOf(fromColumn);
        int allColumnsNewIndex = this.allTableColumns.indexOf(toColumn);
        if (oldIndex != newIndex) {
            this.allTableColumns.remove(allColumnsOldIndex);
            this.allTableColumns.add(allColumnsNewIndex, fromColumn);
        }
        super.moveColumn(oldIndex, newIndex);
    }

    public List<TableColumn> getColumns(boolean onlyVisible) {
        return Collections.unmodifiableList(this.getColumnsFast(onlyVisible));
    }

    private final List<TableColumn> getColumnsFast(boolean onlyVisible) {
        return onlyVisible ? this.tableColumns : this.allTableColumns;
    }

    public TableColumn getColumn(int columnIndex, boolean onlyVisible) {
        return this.getColumnsFast(onlyVisible).get(columnIndex);
    }
}

