/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.combo.ISearchableComboItem;

public class ISearchableComboPopup<T>
extends JPopupMenu {
    private final JList list;
    private int minWitdh = 150;
    private int maxVisibleRows;
    private final ISearchableCombo<T> text;

    ISearchableComboPopup(ListModel listModel, ISearchableCombo<T> text) {
        this.list = new JList(listModel);
        this.text = text;
        this.setMaxVisibleRows(30);
        this.uiInit();
        this.list.addMouseMotionListener(new ListMouseMotionHandler());
    }

    final void setMaxVisibleRows(int maxVisibleRows) {
        this.maxVisibleRows = maxVisibleRows;
    }

    private ISearchableCombo<T> getCombo() {
        return this.text;
    }

    private ListModel getListModel() {
        return this.list.getModel();
    }

    private void uiInit() {
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ISearchableComboPopup.this.validateSelection();
            }
        });
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                comp.setFont(ISearchableComboPopup.this.getCombo().getFont());
                if (value instanceof Action) {
                    comp.setFont(comp.getFont().deriveFont(2));
                    text = (String)((Action)value).getValue("Name");
                    comp.setIcon(null);
                } else {
                    ISearchableComboItem val = (ISearchableComboItem)value;
                    text = val.asString();
                    comp.setIcon(ISearchableComboPopup.this.getCombo().getIcon(val));
                    if (ISearchableComboPopup.this.getCombo().isEmptyItem(val)) {
                        comp.setFont(comp.getFont().deriveFont(2));
                    }
                }
                comp.setText(text.isEmpty() ? " " : text);
                return comp;
            }
        });
        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
        scroller.setFocusable(false);
        scroller.getVerticalScrollBar().setFocusable(false);
        scroller.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(true);
        this.add(scroller);
        this.setFocusable(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int width = d.width;
        if (width > 500) {
            width = 500;
        }
        width = Math.max(width, this.minWitdh) + 2;
        Dimension newD = new Dimension(width, d.height);
        return newD;
    }

    public void setMinWith(int i) {
        this.minWitdh = i;
    }

    protected void updateListBoxSelection(Point location) {
        this.updateListBoxSelection(location, true);
    }

    private void updateListBoxSelection(Point location, boolean shouldScroll) {
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.getListModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.getSelectionModel().setSelectionInterval(index, index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    public void selectNext() {
        int i = this.list.getSelectedIndex() + 1;
        if (i < this.getListModel().getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectNextPage() {
        int i = Math.min(10 + Math.max(this.list.getSelectedIndex(), 0), this.getListModel().getSize() - 1);
        if (i < this.getListModel().getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectPrevious() {
        int i = this.list.getSelectedIndex() - 1;
        if (i >= 0) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        } else {
            this.setVisible(false);
        }
    }

    public void selectPreviousPage() {
        int i = Math.max(0, this.list.getSelectedIndex() - 10);
        this.list.setSelectedIndex(i);
        this.list.ensureIndexIsVisible(i);
    }

    final void validateSelection() {
        Object sel = this.list.getSelectedValue();
        if (sel != null) {
            if (sel instanceof ISearchableComboItem) {
                this.getCombo().setValue((ISearchableComboItem)sel);
            } else if (sel instanceof Action) {
                ((Action)sel).actionPerformed(new ActionEvent(this.getCombo(), 1001, this.getCombo().getName()));
            } else {
                throw new IllegalStateException("unknown selection: " + sel);
            }
            this.setVisible(false);
        }
    }

    public void open() {
        int rowCount;
        int size = this.getListModel().getSize();
        int n = rowCount = size == 0 ? 3 : Math.min(size, this.maxVisibleRows);
        if (this.list.getVisibleRowCount() != rowCount) {
            this.list.setVisibleRowCount(rowCount);
            if (this.isShowing()) {
                this.setVisible(false);
            }
        }
        if (!this.isShowing()) {
            this.show(this.getCombo(), 0, this.getCombo().getBounds().height);
        }
        this.list.setSelectedValue(this.getCombo().getSelection(), true);
    }

    public void close() {
        this.setVisible(false);
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent anEvent) {
            ISearchableComboPopup.this.updateListBoxSelection(anEvent.getPoint());
        }
    }
}

