/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextComboCache;
import org.openconcerto.ui.component.MutableListCombo;
import org.openconcerto.ui.component.MutableListComboPopupListener;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.SwingWorker2;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.model.ListComboBoxModel;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.SimpleDocumentFilter;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ITextCombo
extends JComboBox
implements ValueWrapper<String>,
TextComponent {
    private final String defaultValue;
    private final ComboLockedMode locked;
    private final ValueChangeSupport<String> supp;
    protected final boolean autoComplete;
    protected boolean keyPressed;
    private boolean completing;
    private boolean cacheLoading;
    private String objToSelect;
    private boolean modeToSet;
    protected boolean modifyingDoc;
    private ITextComboCache cache;

    public ITextCombo() {
        this("");
    }

    public ITextCombo(String defaultValue) {
        this(defaultValue, ComboLockedMode.UNLOCKED);
    }

    public ITextCombo(boolean locked) {
        this(locked ? ComboLockedMode.LOCKED : ComboLockedMode.UNLOCKED);
    }

    public ITextCombo(ComboLockedMode mode) {
        this("", mode);
    }

    public ITextCombo(String defaultValue, ComboLockedMode mode) {
        super(new ListComboBoxModel());
        this.getListModel().setSelectOnAdd(false);
        this.supp = new ValueChangeSupport<String>(this);
        this.locked = mode;
        this.defaultValue = defaultValue;
        this.autoComplete = true;
        this.keyPressed = false;
        this.completing = false;
        this.cache = null;
        this.cacheLoading = false;
        this.modifyingDoc = false;
        this.setMinimumSize(new Dimension(80, 22));
        this.setPreferredSize(new Dimension(120, 22));
        this.objToSelect = defaultValue;
        this.setEditable(true);
        if (this.isLocked()) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ITextCombo.this.supp.fireValueChange();
                }
            });
        } else {
            this.getTextComp().getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    if (!ITextCombo.this.modifyingDoc) {
                        ITextCombo.this.setValue(ITextCombo.this.getTextComp().getText());
                    }
                    ITextCombo.this.supp.fireValueChange();
                }
            });
        }
        if (Boolean.getBoolean("org.openconcerto.ui.simpleTraversal")) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                if (child instanceof JButton || child instanceof Button) {
                    child.setFocusable(false);
                }
                ++n2;
            }
        }
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        if (!anEditor.getItem().equals(anItem)) {
            super.configureEditor(anEditor, anItem);
        }
    }

    protected final ComboLockedMode getMode() {
        return this.locked;
    }

    private boolean isLocked() {
        return this.locked == ComboLockedMode.LOCKED;
    }

    public final boolean hasCache() {
        return this.cache != null;
    }

    public final void initCache(ITextComboCache cache) {
        if (cache == null) {
            throw new NullPointerException("null cache");
        }
        if (this.hasCache()) {
            throw new IllegalStateException("cache already set " + this.cache);
        }
        this.cache = cache;
        new MutableListComboPopupListener(new MutableListCombo(){

            @Override
            public ComboLockedMode getMode() {
                return ITextCombo.this.getMode();
            }

            @Override
            public Component getPopupComp() {
                return ITextCombo.this.getEditor().getEditorComponent();
            }

            @Override
            public void addCurrentText() {
                ITextCombo.this.addCurrentText();
            }

            @Override
            public void removeCurrentText() {
                ITextCombo.this.removeCurrentText();
            }

            @Override
            public boolean canReload() {
                return true;
            }

            @Override
            public void reload() {
                ITextCombo.this.loadCache(true);
            }
        }).listen();
        this.loadCache(false);
        if (!this.isLocked()) {
            this.getTextComp().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    ITextCombo.this.keyPressed = true;
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    ITextCombo.this.keyPressed = false;
                }
            });
            DocumentFilterList.add((AbstractDocument)this.getTextComp().getDocument(), new SimpleDocumentFilter(){

                @Override
                protected boolean change(DocumentFilter.FilterBypass fb, String newText, SimpleDocumentFilter.Mode mode) throws BadLocationException {
                    if (mode != SimpleDocumentFilter.Mode.REMOVE && ITextCombo.this.autoComplete && ITextCombo.this.keyPressed) {
                        return ITextCombo.this.complete(fb, newText);
                    }
                    return true;
                }
            });
        }
    }

    protected final boolean complete(DocumentFilter.FilterBypass fb, String originalText) throws BadLocationException {
        boolean res = true;
        if (!this.completing) {
            String completion;
            this.completing = true;
            if (originalText.length() > 2 && !originalText.matches("^\\d*$") && (completion = this.getCompletion(originalText)) != null && !originalText.trim().equalsIgnoreCase(completion.trim())) {
                fb.replace(0, fb.getDocument().getLength(), completion, null);
                res = false;
                this.getTextComp().setSelectionStart(originalText.length());
                this.getTextComp().setSelectionEnd(completion.length());
            }
            this.completing = false;
        }
        return res;
    }

    private String getCompletion(String string) {
        if (string.length() < 1) {
            return null;
        }
        int count = 0;
        String result = null;
        for (Object obj : this.getListModel().getList()) {
            String item = (String)obj;
            if (!item.startsWith(string)) continue;
            ++count;
            result = item;
        }
        if (count == 1) {
            return result;
        }
        return null;
    }

    private ListComboBoxModel getListModel() {
        return (ListComboBoxModel)this.getModel();
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(!this.isLocked());
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.cacheLoading) {
            this.modeToSet = b;
        } else {
            super.setEnabled(b);
        }
    }

    private final synchronized void loadCache(final boolean force) {
        if (!this.cacheLoading) {
            this.modeToSet = this.isEnabled();
            this.setEnabled(false);
            this.objToSelect = this.getValue();
            this.cacheLoading = true;
            SwingWorker2<List<String>, Object> sw = new SwingWorker2<List<String>, Object>(){

                @Override
                protected List<String> doInBackground() throws Exception {
                    return force ? ITextCombo.this.cache.loadCache(false) : ITextCombo.this.cache.getCache();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    6 var1_1 = this;
                    synchronized (var1_1) {
                        ITextCombo.this.modifyingDoc = true;
                    }
                    ITextCombo.this.getListModel().removeAllElements();
                    try {
                        ITextCombo.this.getListModel().addAll((Collection)this.get());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ITextCombo.this.getListModel().addElement(e.getLocalizedMessage());
                    }
                    var1_1 = this;
                    synchronized (var1_1) {
                        ITextCombo.this.modifyingDoc = false;
                        ITextCombo.this.cacheLoading = false;
                    }
                    if (ITextCombo.this.isLocked() && ITextCombo.this.getModel().getSize() == 0) {
                        throw new IllegalStateException(ITextCombo.this + " locked but no items.");
                    }
                    ITextCombo.this.setEnabled(ITextCombo.this.modeToSet);
                    ITextCombo.this.setValue(ITextCombo.this.objToSelect);
                }
            };
            sw.execute();
        }
    }

    private final Object makeObj(String item) {
        return item;
    }

    private final boolean addToCache(String s) {
        if (s != null && s.length() > 0 && this.getListModel().getList().indexOf(s) < 0) {
            this.addItem(this.makeObj(s));
            return true;
        }
        return false;
    }

    private final void removeCurrentText() {
        String t = this.getTextComp().getText();
        this.cache.deleteFromCache(t);
        int i = 0;
        while (i < this.getItemCount()) {
            String o = (String)this.getItemAt(i);
            if (o.equals(t)) {
                this.removeItemAt(i);
                break;
            }
            ++i;
        }
    }

    private final void addCurrentText() {
        String t = this.getTextComp().getText();
        if (this.addToCache(t)) {
            this.cache.addToCache(t);
        }
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public final synchronized void setValue(String val) {
        if (this.cacheLoading) {
            this.objToSelect = val;
        } else if (!CompareUtils.equals(this.getSelectedItem(), val)) {
            this.completing = true;
            this.setSelectedItem(this.makeObj(val));
            this.completing = false;
        }
    }

    @Override
    public void resetValue() {
        this.setValue(this.defaultValue);
    }

    @Override
    public String getValue() {
        return (String)(this.isLocked() ? this.getSelectedItem() : this.getEditor().getItem());
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public JTextComponent getTextComp() {
        if (this.isLocked()) {
            return null;
        }
        return (JTextComponent)this.getEditor().getEditorComponent();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + (Object)((Object)this.locked) + " cache: " + this.cache;
    }
}

