/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;

public class SQLKey {
    private static boolean isKey(String fieldName) {
        return fieldName.toUpperCase().startsWith("ID_");
    }

    public static Set<String> foreignKeys(SQLTable table) {
        String pkeyName = CollectionUtils.getSole(table.getPKsNames());
        HashSet<String> result = new HashSet<String>();
        Iterator<SQLField> i = table.getFields().iterator();
        while (i.hasNext()) {
            String fieldName = i.next().getName();
            if (!SQLKey.isKey(fieldName) || fieldName.equals(pkeyName)) continue;
            result.add(fieldName);
        }
        return result;
    }

    public static SQLTable keyToTable(SQLField key) {
        SQLTable table = key.getTable();
        String keyName = key.getName();
        if (SQLKey.isKey(keyName)) {
            String rest = keyName.substring("ID_".length());
            SQLTable res = null;
            while (res == null && rest.length() > 0) {
                res = table.getDBRoot().findTable(rest);
                if (res != null) continue;
                int last_ = rest.lastIndexOf(95);
                rest = last_ > -1 ? rest.substring(0, last_) : "";
            }
            if (res == null) {
                throw new IllegalStateException("unable to find the table that " + key.getSQLName() + " points to.");
            }
            if (res.getPrimaryKeys().size() != 1) {
                throw new IllegalStateException(key + " points to " + res + " which doesn't have 1 primary key.");
            }
            return res;
        }
        throw new IllegalArgumentException("passed string is not a key");
    }
}

