/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.AliasedTables;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.FromClause;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public final class SQLSelect {
    public static final ArchiveMode UNARCHIVED = ArchiveMode.UNARCHIVED;
    public static final ArchiveMode ARCHIVED = ArchiveMode.ARCHIVED;
    public static final ArchiveMode BOTH = ArchiveMode.BOTH;
    private final List<String> select;
    private final List<SQLField> selectFields;
    private Where where;
    private boolean whereAddToFrom;
    private final List<FieldRef> groupBy;
    private Where having;
    private final List<String> order;
    private final FromClause from;
    private final AliasedTables declaredTables;
    private final Set<String> joinAliases;
    private final List<SQLSelectJoin> joins;
    private boolean generalExcludeUndefined;
    private Map<SQLTable, Boolean> excludeUndefined;
    private final Map<SQLTable, ArchiveMode> archivedPolicy;
    private boolean distinct;
    private boolean waitTrx;
    private final List<String> waitTrxTables;
    private Integer limit;

    public static final String quote(String pattern, Object ... params) {
        return SQLBase.quoteStd(pattern, params);
    }

    public SQLSelect(SQLBase base) {
        this(base, false);
    }

    public SQLSelect(SQLBase base, boolean plain) {
        this(base.getDBSystemRoot(), plain);
    }

    public SQLSelect() {
        this(false);
    }

    public SQLSelect(boolean plain) {
        this((DBSystemRoot)null, plain);
    }

    public SQLSelect(DBSystemRoot sysRoot, boolean plain) {
        this.select = new ArrayList<String>();
        this.selectFields = new ArrayList<SQLField>();
        this.where = null;
        this.whereAddToFrom = true;
        this.groupBy = new ArrayList<FieldRef>();
        this.having = null;
        this.order = new ArrayList<String>();
        this.from = new FromClause();
        this.declaredTables = new AliasedTables(sysRoot);
        this.joinAliases = new HashSet<String>();
        this.joins = new ArrayList<SQLSelectJoin>();
        this.distinct = false;
        this.excludeUndefined = new HashMap<SQLTable, Boolean>();
        this.archivedPolicy = new HashMap<SQLTable, ArchiveMode>();
        this.waitTrx = false;
        this.waitTrxTables = new ArrayList<String>();
        if (plain) {
            this.generalExcludeUndefined = false;
            this.setArchivedPolicy(BOTH);
        } else {
            this.generalExcludeUndefined = true;
            this.setArchivedPolicy(UNARCHIVED);
        }
        assert (this.archivedPolicy.containsKey(null));
    }

    public SQLSelect(SQLSelect orig) {
        this.select = new ArrayList<String>(orig.select);
        this.selectFields = new ArrayList<SQLField>(orig.selectFields);
        this.where = orig.where == null ? null : new Where(orig.where);
        this.whereAddToFrom = orig.whereAddToFrom;
        this.groupBy = new ArrayList<FieldRef>(orig.groupBy);
        this.having = orig.having == null ? null : new Where(orig.having);
        this.order = new ArrayList<String>(orig.order);
        this.from = new FromClause(orig.from);
        this.declaredTables = new AliasedTables(orig.declaredTables);
        this.joinAliases = new HashSet<String>(orig.joinAliases);
        this.joins = new ArrayList<SQLSelectJoin>(orig.joins);
        this.generalExcludeUndefined = orig.generalExcludeUndefined;
        this.excludeUndefined = new HashMap<SQLTable, Boolean>(orig.excludeUndefined);
        this.archivedPolicy = new HashMap<SQLTable, ArchiveMode>(orig.archivedPolicy);
        this.distinct = orig.distinct;
        this.waitTrx = orig.waitTrx;
        this.waitTrxTables = new ArrayList<String>(orig.waitTrxTables);
    }

    public final SQLSystem getSQLSystem() {
        return this.declaredTables.getSysRoot().getServer().getSQLSystem();
    }

    public String asString() {
        SQLSystem sys = this.getSQLSystem();
        StringBuffer result = new StringBuffer(512);
        result.append("SELECT ");
        if (this.distinct) {
            result.append("DISTINCT ");
        }
        if (this.getLimit() != null && sys == SQLSystem.MSSQL) {
            result.append("TOP ");
            result.append(this.getLimit());
            result.append(' ');
        }
        result.append(CollectionUtils.join(this.select, ", "));
        result.append("\n " + this.from.getSQL());
        Where archive = this.where;
        Collection<String> fromAliases = CollectionUtils.substract(this.declaredTables.getAliases(), this.joinAliases);
        for (String alias : fromAliases) {
            SQLTable fromTable = this.declaredTables.getTable(alias);
            archive = Where.and(this.getArchiveWhere(fromTable, alias), archive);
            archive = Where.and(this.getUndefWhere(fromTable, alias), archive);
        }
        if (archive != null && archive.getClause() != "") {
            result.append("\n WHERE ");
            result.append(archive.getClause());
        }
        if (!this.groupBy.isEmpty()) {
            result.append("\n GROUP BY ");
            result.append(CollectionUtils.join(this.groupBy, ", ", new ITransformer<FieldRef, String>(){

                @Override
                public String transformChecked(FieldRef input) {
                    return input.getFieldRef();
                }
            }));
        }
        if (this.having != null) {
            result.append("\n HAVING ");
            result.append(this.having.getClause());
        }
        if (!this.order.isEmpty()) {
            result.append("\n ORDER BY ");
            result.append(CollectionUtils.join(this.order, ", "));
        }
        if (this.getLimit() != null && sys != SQLSystem.MSSQL) {
            result.append("\nLIMIT ");
            result.append(this.getLimit());
        }
        if (this.waitTrx) {
            if (sys.equals((Object)SQLSystem.POSTGRESQL)) {
                result.append(" FOR SHARE");
                if (this.waitTrxTables.size() > 0) {
                    result.append(" OF " + CollectionUtils.join(this.waitTrxTables, ", "));
                }
            } else if (sys.equals((Object)SQLSystem.MYSQL)) {
                result.append(" LOCK IN SHARE MODE");
            }
        }
        return result.toString();
    }

    Where getArchiveWhere(SQLTable table, String alias) {
        Where res;
        ArchiveMode m;
        ArchiveMode archiveMode = m = this.archivedPolicy.containsKey(table) ? this.archivedPolicy.get(table) : this.archivedPolicy.get(null);
        assert (m != null) : "no default policy";
        if (table.isArchivable() && m != BOTH) {
            Comparable<Boolean> archiveValue = table.getArchiveField().getType().getJavaType().equals(Boolean.class) ? (Comparable<Boolean>)Boolean.valueOf(m == ARCHIVED) : (Comparable<Boolean>)Integer.valueOf(m == ARCHIVED ? 1 : 0);
            res = new Where(this.createRef(alias, table.getArchiveField()), "=", (Object)archiveValue);
        } else {
            res = null;
        }
        return res;
    }

    Where getUndefWhere(SQLTable table, String alias) {
        Boolean exclude = this.excludeUndefined.get(table);
        Where res = table.isRowable() && (exclude == Boolean.TRUE || exclude == null && this.generalExcludeUndefined) ? new Where(this.createRef(alias, table.getKey()), "!=", table.getUndefinedID()) : null;
        return res;
    }

    public String toString() {
        return this.asString();
    }

    public final List<SQLField> getSelectFields() {
        return this.selectFields;
    }

    public Where getWhere() {
        return this.where;
    }

    public final boolean contains(String alias) {
        return this.declaredTables.contains(alias);
    }

    public SQLSelect addOrder(TableRef t, boolean fieldMustExist) {
        SQLField orderField = t.getTable().getOrderField();
        if (orderField != null) {
            this.addFieldOrder(t.getField(orderField.getName()));
        } else if (fieldMustExist) {
            throw new IllegalArgumentException("table is not ordered : " + t);
        }
        return this;
    }

    public SQLSelect addFieldOrder(FieldRef fieldRef) {
        return this.addFieldOrder(fieldRef, Order.asc());
    }

    public SQLSelect addFieldOrder(FieldRef fieldRef, Order.Direction dir) {
        return this.addFieldOrder(fieldRef, dir, null);
    }

    public SQLSelect addFieldOrder(FieldRef fieldRef, Order.Direction dir, Order.Nulls nulls) {
        if (this.getSQLSystem().equals((Object)SQLSystem.DERBY)) {
            this.addSelect(fieldRef);
        }
        return this.addRawOrder(String.valueOf(fieldRef.getFieldRef()) + dir.getSQL() + (nulls == null ? "" : nulls.getSQL()));
    }

    public SQLSelect addRawOrder(String selectItem) {
        this.order.add(selectItem);
        return this;
    }

    public SQLSelect addOrderSilent(String t) {
        return this.addOrder(this.getTableRef(t), false);
    }

    public SQLSelect addSelect(FieldRef f) {
        return this.addSelect(f, null);
    }

    public SQLSelect addSelect(FieldRef f, String function) {
        return this.addSelect(f, function, null);
    }

    public SQLSelect addSelect(FieldRef f, String function, String alias) {
        String s = f.getFieldRef();
        if (function != null) {
            s = String.valueOf(function) + "(" + s + ")";
        }
        this.from.add(this.declaredTables.add(f));
        this.selectFields.add(f.getField());
        return this.addRawSelect(s, alias);
    }

    public SQLSelect addRawSelect(String expr, String alias) {
        if (alias != null) {
            expr = String.valueOf(expr) + " as " + SQLBase.quoteIdentifier(alias);
        }
        this.select.add(expr);
        return this;
    }

    public SQLSelect addSelectFunctionStar(String function) {
        return this.addRawSelect(String.valueOf(function) + "(*)", null);
    }

    public SQLSelect addSelectStar(SQLTable table) {
        this.select.add(String.valueOf(SQLBase.quoteIdentifier(table.getName())) + ".*");
        this.from.add(this.declaredTables.add(table));
        this.selectFields.addAll(table.getOrderedFields());
        return this;
    }

    public SQLSelect addFrom(SQLTable table, String alias) {
        return this.addFrom(new AliasedTable(table, alias));
    }

    public SQLSelect addFrom(TableRef t) {
        this.from.add(this.declaredTables.add(t));
        return this;
    }

    public SQLSelect setWhere(Where w) {
        this.where = w;
        if (this.whereAddToFrom && w != null) {
            for (FieldRef f : w.getFields()) {
                this.from.add(this.declaredTables.add(f));
            }
        }
        return this;
    }

    public SQLSelect setWhere(FieldRef field, String op, int i) {
        return this.setWhere(new Where(field, op, i));
    }

    public SQLSelect andWhere(Where w) {
        return this.setWhere(Where.and(this.getWhere(), w));
    }

    public SQLSelectJoin addJoin(String joinType, FieldRef f, String alias) {
        SQLTable foreignTable = f.getField().getForeignTable();
        this.getTable(f.getAlias());
        TableRef aliased = this.declaredTables.add(alias, foreignTable);
        return this.addJoin(new SQLSelectJoin(this, joinType, aliased, f, aliased));
    }

    public SQLSelectJoin addBackwardJoin(String joinType, String joinAlias, SQLField ff, String foreignTableAlias) {
        return this.addBackwardJoin(joinType, new AliasedField(ff, joinAlias), foreignTableAlias);
    }

    public SQLSelectJoin addBackwardJoin(String joinType, FieldRef ff, String foreignTableAlias) {
        SQLTable foreignTable = ff.getField().getForeignTable();
        TableRef aliasedFT = this.getTableRef(foreignTableAlias == null ? foreignTable.getName() : foreignTableAlias);
        if (aliasedFT.getTable() != foreignTable) {
            throw new IllegalArgumentException("wrong alias: " + aliasedFT + " is not an alias to the target of " + ff);
        }
        TableRef aliased = this.declaredTables.add(ff);
        return this.addJoin(new SQLSelectJoin(this, joinType, aliased, ff, aliasedFT));
    }

    private final SQLSelectJoin addJoin(SQLSelectJoin j) {
        this.from.add(j);
        this.joinAliases.add(j.getAlias());
        this.joins.add(j);
        return j;
    }

    public final List<SQLSelectJoin> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    public final SQLSelectJoin getJoin(FieldRef ff) {
        for (SQLSelectJoin j : this.joins) {
            if (!j.hasForeignField() || !j.getForeignField().getFieldRef().equals(ff.getFieldRef())) continue;
            return j;
        }
        return null;
    }

    private SQLSelectJoin getJoin(SQLField ff, String foreignTableAlias) {
        for (SQLSelectJoin j : this.joins) {
            if (!j.hasForeignField() || !j.getForeignField().getField().equals(ff) || !j.getForeignTable().getAlias().equals(foreignTableAlias)) continue;
            return j;
        }
        return null;
    }

    public TableRef assurePath(String tableAlias, Path p) {
        return this.followPath(tableAlias, p, true);
    }

    public TableRef followPath(String tableAlias, Path p) {
        return this.followPath(tableAlias, p, false);
    }

    public TableRef followPath(String tableAlias, Path p, boolean create) {
        TableRef firstTableRef = this.getTableRef(tableAlias);
        SQLTable firstTable = firstTableRef.getTable();
        if (!p.getFirst().equals(firstTable) && !p.getLast().equals(firstTable)) {
            throw new IllegalArgumentException("neither ends of " + p + " is " + firstTable);
        }
        if (!p.getFirst().equals(firstTable)) {
            return this.followPath(tableAlias, p.reverse(), create);
        }
        TableRef current = firstTableRef;
        int i = 0;
        while (i < p.length()) {
            Set<SQLField> step = p.getStepFields(i);
            if (step.size() != 1) {
                throw new IllegalArgumentException(p + " has more than 1 link at index " + i);
            }
            SQLField ff = step.iterator().next();
            boolean forward = current.getTable() == ff.getTable();
            SQLSelectJoin j = forward ? this.getJoin(current.getField(ff.getName())) : this.getJoin(ff, current.getAlias());
            if (j != null) {
                current = j.getJoinedTable();
            } else if (create) {
                String uniqAlias = this.getUniqueAlias("assurePath_" + i);
                SQLSelectJoin createdJoin = forward ? this.addJoin("LEFT", current.getField(ff.getName()), uniqAlias) : this.addBackwardJoin("LEFT", uniqAlias, ff, current.getAlias());
                current = createdJoin.getJoinedTable();
            } else {
                return null;
            }
            ++i;
        }
        return current;
    }

    public void setExcludeUndefined(boolean excludeUndefined) {
        this.generalExcludeUndefined = excludeUndefined;
    }

    public void setExcludeUndefined(boolean exclude, SQLTable table) {
        this.excludeUndefined.put(table, exclude);
    }

    public void setArchivedPolicy(ArchiveMode policy) {
        this.setArchivedPolicy(null, policy);
    }

    public void setArchivedPolicy(SQLTable t, ArchiveMode policy) {
        this.archivedPolicy.put(t, policy);
    }

    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setWaitPreviousWriteTX(boolean waitTrx) {
        this.waitTrx = waitTrx;
    }

    public void addWaitPreviousWriteTXTable(String table) {
        this.setWaitPreviousWriteTX(true);
        this.waitTrxTables.add(SQLBase.quoteIdentifier(table));
    }

    public SQLSelect setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public final Integer getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (o instanceof SQLSelect) {
            return this.asString().equals(((SQLSelect)o).asString());
        }
        return false;
    }

    public int hashCode() {
        return this.select.hashCode() + this.from.getSQL().hashCode() + (this.where == null ? 0 : this.where.hashCode());
    }

    public final SQLTable getTable(String name) {
        return this.getTableRef(name).getTable();
    }

    public final TableRef getTableRef(String alias) {
        TableRef res = this.declaredTables.getAliasedTable(alias);
        if (res == null) {
            throw new IllegalArgumentException("alias not in this select : " + alias);
        }
        return res;
    }

    public final TableRef getAlias(SQLTable t) {
        return this.declaredTables.getAlias(t);
    }

    public final List<TableRef> getAliases(SQLTable t) {
        return this.declaredTables.getAliases(t);
    }

    public final FieldRef getAlias(SQLField f) {
        return this.getAlias(f.getTable()).getField(f.getName());
    }

    public final String getUniqueAlias(String seed) {
        if (seed.length() > 63) {
            seed = seed.substring(0, 63);
        }
        if (!this.contains(seed)) {
            return seed;
        }
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 50) {
            String cat = String.valueOf(seed) + "_" + time;
            String res = cat.length() > 63 ? String.valueOf(seed.substring(0, seed.length() - (cat.length() - 63))) + "_" + time : cat;
            if (!this.contains(res)) {
                return res;
            }
            ++time;
            ++i;
        }
        return null;
    }

    private final FieldRef createRef(String alias, SQLField f) {
        return this.createRef(alias, f, true);
    }

    private final FieldRef createRef(String alias, SQLField f, boolean mustExist) {
        if (mustExist && !this.contains(alias)) {
            throw new IllegalArgumentException("unknown alias " + alias);
        }
        return new AliasedField(f, alias);
    }

    public final Set<SQLField> getFields() {
        HashSet<SQLField> res = new HashSet<SQLField>(this.getSelectFields());
        for (SQLSelectJoin j : this.getJoins()) {
            res.addAll(SQLSelect.getFields(j.getWhere()));
        }
        res.addAll(SQLSelect.getFields(this.getWhere()));
        for (FieldRef gb : this.groupBy) {
            res.add(gb.getField());
        }
        res.addAll(SQLSelect.getFields(this.having));
        return res;
    }

    private static final Set<SQLField> getFields(Where w) {
        if (w != null) {
            HashSet<SQLField> res = new HashSet<SQLField>();
            for (FieldRef v : w.getFields()) {
                res.add(v.getField());
            }
            return res;
        }
        return Collections.emptySet();
    }

    public static enum ArchiveMode {
        UNARCHIVED,
        ARCHIVED,
        BOTH;

    }
}

