/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.generationDoc.TemplateManager;

public class DocumentLocalStorageManager {
    private static DocumentLocalStorageManager instance = new DocumentLocalStorageManager();
    private Map<String, File> dirs = new HashMap<String, File>();
    private Map<String, File> dirsPDF = new HashMap<String, File>();
    private File documentDefaultDirectory;
    private File PDFDefaultDirectory;

    public static DocumentLocalStorageManager getInstance() {
        return instance;
    }

    public File getDocumentOutputDirectory(String templateId) {
        if (templateId == null) {
            throw new IllegalArgumentException("null template id");
        }
        File f = this.dirs.get(templateId);
        if (f != null) {
            return f;
        }
        return this.documentDefaultDirectory;
    }

    public File getPDFOutputDirectory(String templateId) {
        if (templateId == null) {
            throw new IllegalArgumentException("null template id");
        }
        File f = this.dirsPDF.get(templateId);
        if (f != null) {
            return f;
        }
        return this.PDFDefaultDirectory;
    }

    public void addDocumentDirectory(String templateId, File directory) {
        if (templateId == null) {
            throw new IllegalArgumentException("null template id");
        }
        this.dirs.put(templateId, directory);
        TemplateManager.getInstance().register(templateId);
    }

    public void addPDFDirectory(String templateId, File directory) {
        if (templateId == null) {
            throw new IllegalArgumentException("null template id");
        }
        this.dirsPDF.put(templateId, directory);
        TemplateManager.getInstance().register(templateId);
    }

    public void setDocumentDefaultDirectory(File directory) {
        this.documentDefaultDirectory = directory;
    }

    public void setPDFDefaultDirectory(File directory) {
        this.PDFDefaultDirectory = directory;
    }

    public void dump() {
        System.out.println(this.getClass().getCanonicalName());
        System.out.println("Default document directory: " + this.getAndTest(this.documentDefaultDirectory));
        System.out.println("Default PFD directory     : " + this.getAndTest(this.PDFDefaultDirectory));
        System.out.println("Document directories:");
        for (String key : this.dirs.keySet()) {
            System.out.println(String.valueOf(this.rightAlign("'" + key + "'")) + " : " + this.getAndTest(this.dirs.get(key)));
        }
        System.out.println("PDF directories:");
        for (String key : this.dirsPDF.keySet()) {
            System.out.println(String.valueOf(this.rightAlign("'" + key + "'")) + " : " + this.getAndTest(this.dirsPDF.get(key)));
        }
    }

    private String rightAlign(String s) {
        String r = s;
        int n = 20 - s.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(' ') + r;
            ++i;
        }
        return r;
    }

    private String getAndTest(File dir) {
        if (dir == null) {
            return "null !!!!!!";
        }
        String r = "'" + dir.getAbsolutePath() + "'";
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                r = String.valueOf(r) + " is not a directory!!";
            } else if (!dir.canWrite()) {
                r = String.valueOf(r) + " is write protected!!";
            }
        } else {
            r = String.valueOf(r) + " does not exist !!";
        }
        return r;
    }
}

