/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.employe.panel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.humanresources.employe.panel.ListAnneeModel;
import org.openconcerto.erp.core.humanresources.employe.panel.ObjectifTableModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;

public class ObjectifEditPanel
extends JPanel {
    int idCommercial;
    SQLTable tableObjectif = Configuration.getInstance().getRoot().findTable("OBJECTIF_COMMERCIAL");
    final ListAnneeModel<Integer> listModel = new ListAnneeModel();
    final ObjectifTableModel tableModel = new ObjectifTableModel();

    public ObjectifEditPanel(int idCommercial) {
        super(new GridBagLayout());
        this.idCommercial = idCommercial;
        this.uiInit();
        this.setOpaque(false);
    }

    public void setIdCommercial(int idCommercial) {
        this.idCommercial = idCommercial;
        this.listModel.loadData(idCommercial);
        this.tableModel.loadData(this.idCommercial, 0);
    }

    private void uiInit() {
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabelBold("Ann\u00e9e"), c);
        ++c.gridx;
        this.add((Component)new JLabelBold("Objectifs mensuels"), c);
        this.listModel.loadData(this.idCommercial);
        final JList<Integer> jList = new JList<Integer>(this.listModel);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 1;
        c.weightx = 0.2;
        this.add(jList, c);
        ++c.gridx;
        c.fill = 1;
        c.weightx = 0.8;
        JTable table = new JTable(this.tableModel);
        DeviseCellEditor cellEditor = new DeviseCellEditor();
        DeviseNiceTableCellRenderer rend = new DeviseNiceTableCellRenderer();
        table.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        table.getColumnModel().getColumn(1).setCellRenderer(rend);
        table.getColumnModel().getColumn(3).setCellEditor(cellEditor);
        table.getColumnModel().getColumn(3).setCellRenderer(rend);
        this.add((Component)new JScrollPane(table), c);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Integer annee = ObjectifEditPanel.this.listModel.getElementAt(jList.getSelectedIndex());
                ObjectifEditPanel.this.tableModel.loadData(ObjectifEditPanel.this.idCommercial, annee);
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)new JButton(new AbstractAction("Ajouter une ann\u00e9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectifEditPanel.this.addYear();
            }
        }), c);
    }

    private void addYear() {
        int annee;
        SQLSelect sel = new SQLSelect(this.tableObjectif.getBase());
        sel.addSelect(this.tableObjectif.getField("ANNEE"), "MAX");
        sel.setWhere(new Where((FieldRef)this.tableObjectif.getField("ID_COMMERCIAL"), "=", this.idCommercial));
        Object anneeObject = Configuration.getInstance().getBase().getDataSource().executeScalar(sel.asString());
        if (anneeObject == null) {
            annee = Calendar.getInstance().get(1);
        } else {
            annee = (Integer)anneeObject;
            ++annee;
        }
        List<String> s = Arrays.asList("Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre");
        for (String string : s) {
            SQLRowValues rowVals = new SQLRowValues(this.tableObjectif);
            rowVals.put("ANNEE", annee);
            rowVals.put("MOIS", string);
            rowVals.put("MARGE_HT", 0L);
            rowVals.put("POURCENT_MARGE", BigDecimal.ZERO);
            rowVals.put("CHIFFRE_AFFAIRE", 0L);
            rowVals.put("ID_COMMERCIAL", this.idCommercial);
            try {
                rowVals.insert();
            }
            catch (SQLException exn) {
                exn.printStackTrace();
            }
        }
        this.listModel.addElement(annee);
    }
}

