/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.convertor;

import java.sql.Clob;
import org.openconcerto.utils.convertor.NullIsNullConvertor;

public class StringClobConvertor
extends NullIsNullConvertor<String, Clob> {
    public static final StringClobConvertor INSTANCE = new StringClobConvertor(null);
    public static final StringClobConvertor INSTANCE_LENIENT = new StringClobConvertor(Integer.MAX_VALUE);
    private final Integer maxLength;

    public StringClobConvertor(int maxLength) {
        this((Integer)maxLength);
    }

    public StringClobConvertor(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    protected String unconvertNonNull(Clob o) {
        try {
            int l;
            long clobL = o.length();
            if (this.maxLength != null) {
                l = (int)Math.min(clobL, this.maxLength.longValue());
            } else {
                if (clobL > Integer.MAX_VALUE) {
                    throw new IllegalStateException("Clob too long: " + clobL);
                }
                l = (int)clobL;
            }
            return o.getSubString(1L, l);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

