/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.cc.IdentitySet;
import org.openconcerto.utils.cc.Transformer;

public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    private static final Pattern COMMA = Pattern.compile("\\p{Space}*,\\p{Space}*");

    public static final <E> String join(Collection<E> c, String sep, ITransformer<? super E, ?> tf) {
        int size = c.size();
        if (size == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer(size * 4);
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int i = 0;
            while (i < size) {
                res.append(tf.transformChecked(list.get(i)));
                if (i < size - 1) {
                    res.append(sep);
                }
                ++i;
            }
        } else {
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                E elem = iter.next();
                res.append(tf.transformChecked(elem));
                if (!iter.hasNext()) continue;
                res.append(sep);
            }
        }
        return res.toString();
    }

    public static <T> String join(Collection<T> c, String sep) {
        return CollectionUtils.join(c, sep, Transformer.nopTransformer());
    }

    public static int getValidIndex(List<?> l, int i) {
        return CollectionUtils.getValidIndex(l, i, false);
    }

    public static int getValidIndex(List<?> l, int i, boolean strict) {
        int size = l.size();
        if (i > size) {
            if (strict) {
                throw new IndexOutOfBoundsException("Too high : " + i + " > " + size);
            }
            return size;
        }
        if (i < -size) {
            if (strict) {
                throw new IndexOutOfBoundsException("Too low : " + i + " < " + -size);
            }
            return 0;
        }
        if (i >= 0) {
            return i;
        }
        return size + i;
    }

    public static <K, V> Tuple2<List<K>, List<V>> mapToLists(Map<K, V> map) {
        ArrayList<K> keys = new ArrayList<K>(map.size());
        ArrayList<V> vals = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keys.add(e.getKey());
            vals.add(e.getValue());
        }
        return Tuple2.create(keys, vals);
    }

    public static <K, V> Map<K, V> addIfNotPresent(Map<K, V> map, Map<? extends K, ? extends V> toAdd) {
        for (Map.Entry<K, V> e : toAdd.entrySet()) {
            if (map.containsKey(e.getKey())) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <T> Set<T> contains(Set<T> col1, Set<T> col2) {
        if (col1.containsAll(col2)) {
            return null;
        }
        HashSet<T> names = new HashSet<T>(col2);
        names.removeAll(col1);
        return names;
    }

    public static <T> Collection<T> intersection(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections.CollectionUtils.intersection(a, b);
    }

    public static <T> Set<T> inter(Set<T> a, Set<T> b) {
        return CollectionUtils.interSubtype(a, b);
    }

    public static <T> Set<? extends T> interSubtype(Set<? extends T> a, Set<? extends T> b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.size() > b.size()) {
            return CollectionUtils.interSubtype(b, a);
        }
        HashSet<T> res = new HashSet<T>();
        for (T item : a) {
            if (!b.contains(item)) continue;
            res.add(item);
        }
        return res;
    }

    public static <T> Set<T> union(Set<? extends T> a, Set<? extends T> b) {
        HashSet<T> res = new HashSet<T>(a);
        if (a != b) {
            res.addAll(b);
        }
        return res;
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> Collection<T> substract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> T getSole(List<T> l) {
        return l.size() == 1 ? (T)l.get(0) : null;
    }

    public static <T> T getSole(Collection<T> l) {
        return l.size() == 1 ? (T)l.iterator().next() : null;
    }

    public static <T> T getLast(List<T> l) {
        return CollectionUtils.getNoExn(l, l.size() - 1);
    }

    public static <T> T getNoExn(List<T> l, int index) {
        return index >= 0 && index < l.size() ? (T)l.get(index) : null;
    }

    public static <T> Set<T> createSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> createIdentitySet(Collection<T> items) {
        if (items instanceof IdentitySet) {
            return (Set)items;
        }
        return new IdentityHashSet<T>(items);
    }
}

