/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.SQLDataSource;

public class SQLUtils {
    private static final Pattern splitMySQLQueries = Pattern.compile(";\r?\n");
    public static final Pattern SPLIT_PATTERN = Pattern.compile("$jdbcDelimiter$", 16);

    public static <T> T executeAtomic(SQLDataSource ds, final SQLFactory<T> f) throws SQLException {
        return SQLUtils.executeAtomic(ds, new ConnectionHandlerNoSetup<T, SQLException>(){

            @Override
            public T handle(SQLDataSource ds) throws SQLException {
                return f.create();
            }
        });
    }

    public static <T, X extends Exception> T executeAtomic(SQLDataSource ds, final ConnectionHandlerNoSetup<T, X> h) throws SQLException, X {
        return ds.useConnection(new ConnectionHandler<T, X>(){
            private Boolean autoCommit = null;

            @Override
            public boolean canRestoreState() {
                return true;
            }

            @Override
            public void setup(Connection conn) throws SQLException {
                this.autoCommit = conn.getAutoCommit();
                if (this.autoCommit.booleanValue()) {
                    conn.setAutoCommit(false);
                }
            }

            @Override
            public T handle(SQLDataSource ds) throws Exception, SQLException {
                return h.handle(ds);
            }

            @Override
            public void restoreState(Connection conn) throws SQLException {
                if (this.autoCommit == Boolean.TRUE) {
                    try {
                        try {
                            this.get();
                            conn.commit();
                        }
                        catch (Exception e) {
                            conn.rollback();
                            conn.setAutoCommit(true);
                        }
                    }
                    finally {
                        conn.setAutoCommit(true);
                    }
                }
            }
        });
    }

    public static interface SQLFactory<T> {
        public T create() throws SQLException;
    }
}

