/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.SetMap;

class ToRefreshSpec {
    private TablesByRoot tablesFromXML = new TablesByRoot();
    private TablesByRoot tablesFromJDBC = new TablesByRoot();

    private static final TablesByRoot createMap(DBSystemRoot sysRoot) {
        TablesByRoot res = new TablesByRoot();
        for (DBRoot r : sysRoot.getChildrenMap().values()) {
            res.put(r.getName(), r.getChildrenNames());
        }
        return res;
    }

    private static TablesByRoot fillMap(TablesByRoot toRefresh, DBSystemRoot sysRoot) {
        if (toRefresh == null) {
            return ToRefreshSpec.createMap(sysRoot);
        }
        TablesByRoot res = new TablesByRoot(toRefresh);
        for (Map.Entry e : toRefresh.entrySet()) {
            String rootName = (String)e.getKey();
            if (!sysRoot.contains(rootName)) {
                res.remove(rootName);
                continue;
            }
            Set<String> newTableNames = sysRoot.getRoot(rootName).getChildrenNames();
            if (e.getValue() == null) {
                res.put(rootName, newTableNames);
                continue;
            }
            ((Set)res.get(rootName)).retainAll(newTableNames);
        }
        return res;
    }

    ToRefreshSpec() {
    }

    public final TablesByRoot getTablesFromXML() {
        return this.tablesFromXML;
    }

    public final TablesByRoot getTablesFromJDBC() {
        return this.tablesFromJDBC;
    }

    private final boolean isInScope(TablesByRoot m, SQLTable t) {
        String rootName = t.getDBRoot().getName();
        if (!m.containsKey(rootName)) {
            return false;
        }
        Collection values = (Collection)m.get(rootName);
        return values == null || values.contains(t.getName());
    }

    private final boolean isAnyInScope() {
        return this.tablesFromXML == null || this.tablesFromJDBC == null;
    }

    public final boolean isInScope(SQLTable t) {
        if (this.isAnyInScope()) {
            return true;
        }
        return this.isInScope(this.tablesFromXML, t) || this.isInScope(this.tablesFromJDBC, t);
    }

    public final ToRefreshSpec add(DBStructureItemJDBC parent, Set<String> childrenRefreshed, boolean readCache) {
        TablesByRoot tablesByRoot;
        TablesByRoot tablesByRoot2 = tablesByRoot = readCache ? this.tablesFromXML : this.tablesFromJDBC;
        if (tablesByRoot != null) {
            boolean parentIsSysRoot;
            boolean bl = parentIsSysRoot = parent != null && parent.getDB() instanceof DBSystemRoot;
            if (parent == null || parentIsSysRoot && childrenRefreshed == null) {
                if (readCache) {
                    this.tablesFromXML = null;
                } else {
                    this.tablesFromJDBC = null;
                }
            } else if (parentIsSysRoot) {
                for (String s : childrenRefreshed) {
                    tablesByRoot.put(s, null);
                }
            } else {
                String key = parent.getDBRoot().getName();
                if (!tablesByRoot.containsKey(key) || tablesByRoot.get(key) != null) {
                    if (!(parent.getDB() instanceof DBRoot)) {
                        tablesByRoot.add(key, parent.getAnc(SQLTable.class).getName());
                    } else if (childrenRefreshed == null || parent instanceof SQLBase) {
                        tablesByRoot.put(key, null);
                    } else {
                        tablesByRoot.addAll(key, childrenRefreshed);
                    }
                }
            }
        }
        return this;
    }

    private final Set<SQLTable> getTablesInScope(Set<SQLTable> tables) {
        if (this.isAnyInScope()) {
            return new HashSet<SQLTable>(tables);
        }
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (SQLTable t : tables) {
            if (!this.isInScope(t)) continue;
            res.add(t);
        }
        return res;
    }

    public final ToRefreshActual getActual(DBSystemRoot sysRoot, Set<SQLTable> currentGraphTables) {
        TablesByRoot fromJDBC;
        TablesByRoot fromXML;
        if (this.tablesFromJDBC == null) {
            fromXML = new TablesByRoot();
            fromJDBC = ToRefreshSpec.createMap(sysRoot);
        } else {
            fromXML = ToRefreshSpec.fillMap(this.tablesFromXML, sysRoot);
            fromJDBC = ToRefreshSpec.fillMap(this.tablesFromJDBC, sysRoot);
            fromXML.removeAll(fromJDBC);
            fromXML.removeAllEmptyCollections();
        }
        Set<SQLTable> toAdd = this.getTablesInScope(sysRoot.getDescs(SQLTable.class));
        Set<SQLTable> toRm = this.getTablesInScope(currentGraphTables);
        return new ToRefreshActual(fromXML, fromJDBC, toRm, toAdd);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " :\nfrom XML " + this.getTablesFromXML() + "\nfrom JDBC " + this.getTablesFromJDBC();
    }

    static final class TablesByRoot
    extends SetMap<String, String> {
        TablesByRoot() {
            super(3, CollectionMap2.Mode.NULL_MEANS_ALL, true);
        }

        TablesByRoot(Map<? extends String, ? extends Set<String>> m) {
            this();
            this.putAllCollections(m);
        }

        @Override
        protected Set<String> createCollection(Collection<? extends String> v) {
            HashSet<String> res = new HashSet<String>(Math.max(8, v.size()));
            res.addAll(v);
            return res;
        }
    }

    static final class ToRefreshActual {
        private final TablesByRoot fromXML;
        private final TablesByRoot fromJDBC;
        private final Set<SQLTable> oldTables;
        private final Set<SQLTable> newTables;

        private ToRefreshActual(TablesByRoot fromXML, TablesByRoot fromJDBC, Set<SQLTable> oldTables, Set<SQLTable> newTables) {
            this.fromXML = fromXML;
            this.fromJDBC = fromJDBC;
            this.oldTables = oldTables;
            this.newTables = newTables;
        }

        public final TablesByRoot getFromXML() {
            return this.fromXML;
        }

        public final TablesByRoot getFromJDBC() {
            return this.fromJDBC;
        }

        public final Set<SQLTable> getOldTablesInScope() {
            return this.oldTables;
        }

        public final Set<SQLTable> getNewTablesInScope() {
            return this.newTables;
        }
    }
}

