/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DirectedMultigraph;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.LoadingListener;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.BaseGraph;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.sql.model.graph.LabelPredicate;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.sql.model.graph.ToRefreshSpec;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.xml.JDOMUtils;

public class DatabaseGraph
extends BaseGraph {
    private final DBSystemRoot base;
    private Map<String, Set<String>> mappedFromFile;
    private final Map<SQLTable, Set<Link>> foreignLinks = new HashMap<SQLTable, Set<Link>>();
    private final Map<List<SQLField>, Link> foreignLink = new HashMap<List<SQLField>, Link>();
    private final ThreadLocal<Integer> atomicRefreshDepth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final ThreadLocal<ToRefreshSpec> atomicRefreshItems = new ThreadLocal<ToRefreshSpec>(){

        @Override
        protected ToRefreshSpec initialValue() {
            return new ToRefreshSpec();
        }
    };

    public DatabaseGraph(DBSystemRoot root) {
        super(new DirectedMultigraph<SQLTable, Link>(Link.class));
        this.base = root;
        this.mappedFromFile = null;
    }

    public final void refresh(DBStructureItemJDBC parent, Set<String> childrenRefreshed, boolean readCache) throws SQLException {
        if (this.inAtomicRefresh()) {
            this.atomicRefreshItems.get().add(parent, childrenRefreshed, readCache);
        } else {
            this.refresh(new ToRefreshSpec().add(parent, childrenRefreshed, readCache));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refresh(ToRefreshSpec toRefresh) throws SQLException {
        Object object = this.base.getTreeMutex();
        synchronized (object) {
            DatabaseGraph databaseGraph = this;
            synchronized (databaseGraph) {
                LoadingListener.GraphLoadingEvent evt = new LoadingListener.GraphLoadingEvent(this.base).fireEvent();
                try {
                    this.mappedFromFile = Collections.unmodifiableMap(this.mapTables(toRefresh));
                }
                finally {
                    evt.fireFinishingEvent();
                }
            }
        }
    }

    public final boolean inAtomicRefresh() {
        return this.atomicRefreshDepth.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V atomicRefresh(Callable<V> callable) throws SQLException {
        V res;
        this.atomicRefreshDepth.set(this.atomicRefreshDepth.get() + 1);
        Object object = this.base.getTreeMutex();
        synchronized (object) {
            int newVal;
            try {
                try {
                    res = callable.call();
                }
                catch (Exception e) {
                    throw new SQLException("Call failed", e);
                }
            }
            finally {
                newVal = this.atomicRefreshDepth.get() - 1;
                this.atomicRefreshDepth.set(newVal);
                assert (newVal >= 0);
            }
            if (newVal == 0) {
                ToRefreshSpec itemsToRefresh = this.atomicRefreshItems.get();
                this.atomicRefreshItems.remove();
                this.atomicRefreshDepth.remove();
                this.refresh(itemsToRefresh);
            }
        }
        return res;
    }

    private final SQLServer getServer() {
        return this.base.getAnc(SQLServer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, Set<String>> mapTables(ToRefreshSpec toRefreshSpec) throws SQLException {
        assert (Thread.holdsLock(this.base.getTreeMutex())) : "Cannot graph a changing object";
        ToRefreshSpec.TablesByRoot res = new ToRefreshSpec.TablesByRoot();
        Set<SQLTable> currentTables = this.getAllTables();
        ToRefreshSpec.ToRefreshActual toRefresh = toRefreshSpec.getActual(this.base, currentTables);
        Set<SQLTable> newTablesInScope = toRefresh.getNewTablesInScope();
        Set<SQLTable> oldTablesInScope = toRefresh.getOldTablesInScope();
        boolean clearGraph = oldTablesInScope.equals(currentTables);
        DatabaseGraph databaseGraph = this;
        synchronized (databaseGraph) {
            if (clearGraph) {
                this.foreignLink.clear();
                this.foreignLinks.clear();
            } else {
                SQLTable linkTable;
                Map.Entry<Object, Object> e;
                Iterator<Map.Entry<Object, Object>> iter = this.foreignLink.entrySet().iterator();
                while (iter.hasNext()) {
                    e = iter.next();
                    linkTable = e.getKey().get(0).getTable();
                    if (!oldTablesInScope.contains(linkTable)) continue;
                    iter.remove();
                }
                iter = this.foreignLinks.entrySet().iterator();
                while (iter.hasNext()) {
                    e = iter.next();
                    linkTable = ((SQLTable)e.getKey()).getTable();
                    if (!oldTablesInScope.contains(linkTable)) continue;
                    iter.remove();
                }
            }
        }
        if (clearGraph) {
            this.getGraphP().removeAllVertices(oldTablesInScope);
            assert (this.getGraphP().vertexSet().size() == 0 && this.getGraphP().edgeSet().size() == 0);
        } else {
            this.getGraphP().removeAllVertices(CollectionUtils.subtract(oldTablesInScope, newTablesInScope));
            HashSet linksToRemove = new HashSet();
            for (SQLTable t : CollectionUtils.intersection(oldTablesInScope, newTablesInScope)) {
                linksToRemove.addAll(this.getGraphP().outgoingEdgesOf(t));
            }
            this.getGraphP().removeAllEdges(linksToRemove);
        }
        Graphs.addAllVertices(this.getGraphP(), newTablesInScope);
        ToRefreshSpec.TablesByRoot fromXML = toRefresh.getFromXML();
        ToRefreshSpec.TablesByRoot fromJDBC = toRefresh.getFromJDBC();
        if (fromXML.size() > 0) {
            DBItemFileCache dir = this.getFileCache();
            try {
                if (dir != null) {
                    Log.get().config("for mapping " + this + " trying xmls in " + dir);
                    long t1 = System.currentTimeMillis();
                    res = this.mapFromXML(fromXML);
                    fromXML.removeAll(res);
                    long t2 = System.currentTimeMillis();
                    Log.get().config("XML took " + (t2 - t1) + "ms for mapping the graph of " + this.base.getName() + "." + res);
                }
            }
            catch (Exception e) {
                SQLBase.logCacheError(dir, e);
                this.deleteGraphFiles();
            }
            fromJDBC.addAll(fromXML);
        }
        if (!fromJDBC.isEmpty()) {
            long t1 = System.currentTimeMillis();
            for (Map.Entry e : fromJDBC.entrySet()) {
                String rootName = (String)e.getKey();
                Set tableNames = (Set)e.getValue();
                DBRoot r = this.base.getRoot(rootName);
                if (!this.map(r, tableNames)) {
                    for (String table : tableNames) {
                        this.map(r, table, null);
                    }
                }
                this.save(r);
            }
            long t2 = System.currentTimeMillis();
            Log.get().config("JDBC took " + (t2 - t1) + "ms for mapping the graph of " + this.base + "." + fromJDBC);
        }
        return res;
    }

    private final void addLink(List<SQLField> from, List<SQLField> to, String foreignKeyName, Link.Rule updateRule, Link.Rule deleteRule) {
        this.addLink(new Link(from, to, foreignKeyName, updateRule, deleteRule));
    }

    private final void addLink(Link l) {
        DirectedEdge.addEdge(this.getGraphP(), l);
    }

    private boolean map(DBRoot r, Set<String> tableNames) throws SQLException {
        if (r.getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            this.map(r, null, tableNames);
            return true;
        }
        return false;
    }

    private void map(final DBRoot r, final String tableName, Set<String> tableNames) throws SQLException {
        assert (tableName == null ^ tableNames == null);
        SQLServer server = r.getServer();
        CollectionMap metadataFKs = new CollectionMap(new HashSet());
        List importedKeys = this.base.getDataSource().useConnection(new ConnectionHandlerNoSetup<List, SQLException>(){

            @Override
            public List handle(SQLDataSource ds) throws SQLException {
                DatabaseMetaData metaData = ds.getConnection().getMetaData();
                return (List)SQLDataSource.ARRAY_LIST_HANDLER.handle(metaData.getImportedKeys(r.getBase().getMDName(), r.getSchema().getName(), tableName));
            }
        });
        ArrayList<SQLField> from = new ArrayList<SQLField>();
        ArrayList<SQLField> to = new ArrayList<SQLField>();
        Link.Rule updateRule = null;
        Link.Rule deleteRule = null;
        String name = null;
        for (Object[] m : importedKeys) {
            SQLSchema schema;
            assert (CompareUtils.equals(m[5], r.getSchema().getName()));
            String fkTableName = (String)m[6];
            assert (tableName == null || tableName.equals(fkTableName));
            if (tableNames != null && !tableNames.contains(fkTableName)) continue;
            String keyName = (String)m[7];
            short seq = ((Number)m[8]).shortValue();
            String foreignCat = this.base.getServer().getSQLSystem().isInterBaseSupported() && m[0] != null ? (String)m[0] : r.getBase().getName();
            String foreignSchema = (String)m[1];
            String foreignTableName = (String)m[2];
            String foreignTableColName = (String)m[3];
            String foreignKeyName = (String)m[11];
            SQLField key = r.getTable(fkTableName).getField(keyName);
            SQLBase base = server.getBase(foreignCat);
            SQLSchema sQLSchema = schema = base == null ? null : base.getSchema(foreignSchema);
            if (schema == null) {
                throw new IllegalStateException(key.getSQLName() + " references " + foreignCat + "." + foreignSchema + " which does not exist (probably filtered by DBSystemRoot.getRootsToMap())");
            }
            SQLTable foreignTable = this.base.getServer().getSQLSystem() == SQLSystem.MYSQL ? this.getTableIgnoringCase(schema, foreignTableName) : (SQLTable)schema.getCheckedChild(foreignTableName);
            metadataFKs.put(fkTableName, keyName);
            if (seq == 1) {
                if (from.size() > 0) {
                    this.addLink(from, to, name, updateRule, deleteRule);
                }
                from.clear();
                to.clear();
            }
            from.add(key);
            assert (seq == 1 || ((SQLField)from.get(from.size() - 2)).getTable() == ((SQLField)from.get(from.size() - 1)).getTable());
            to.add(foreignTable.getField(foreignTableColName));
            assert (seq == 1 || ((SQLField)to.get(to.size() - 2)).getTable() == ((SQLField)to.get(to.size() - 1)).getTable());
            Link.Rule prevUpdateRule = updateRule;
            Link.Rule prevDeleteRule = deleteRule;
            updateRule = Link.Rule.fromShort(((Number)m[9]).shortValue());
            deleteRule = Link.Rule.fromShort(((Number)m[10]).shortValue());
            if (seq > 1) {
                if (prevUpdateRule != updateRule) {
                    throw new IllegalStateException("Incoherent update rules " + (Object)((Object)prevUpdateRule) + " != " + (Object)((Object)updateRule));
                }
                if (prevDeleteRule != deleteRule) {
                    throw new IllegalStateException("Incoherent delete rules " + (Object)((Object)prevDeleteRule) + " != " + (Object)((Object)deleteRule));
                }
            }
            name = foreignKeyName;
        }
        if (from.size() > 0) {
            this.addLink(from, to, name, updateRule, deleteRule);
        }
        if (Boolean.getBoolean("org.openconcerto.sql.graph.inferFK")) {
            Set<String> tables = tableName != null ? Collections.singleton(tableName) : tableNames;
            for (String tableToInfer : tables) {
                SQLTable table = r.getTable(tableToInfer);
                Set<String> lexicalFKs = SQLKey.foreignKeys(table);
                lexicalFKs.removeAll(metadataFKs.getNonNull(table.getName()));
                for (String keyName : lexicalFKs) {
                    SQLField key = table.getField(keyName);
                    this.addLink(Collections.singletonList(key), Collections.singletonList(SQLKey.keyToTable(key).getKey()), null, null, null);
                }
            }
        }
    }

    private final SQLTable getTableIgnoringCase(SQLSchema s, String tablename) {
        for (String tname : s.getTableNames()) {
            if (!tname.equalsIgnoreCase(tablename)) continue;
            return s.getTable(tname);
        }
        return null;
    }

    private DBItemFileCache getFileCache() {
        boolean useXML = Boolean.getBoolean("org.openconcerto.sql.structure.useXML");
        DBFileCache d = this.getServer().getFileCache();
        if (!useXML || d == null) {
            return null;
        }
        return d.getChild(this.base);
    }

    private final File getRootFile(String root) {
        DBItemFileCache saveDir = this.getFileCache();
        if (saveDir == null) {
            return null;
        }
        return this.getGraphFile(saveDir.getChild(root));
    }

    private final List<DBItemFileCache> getSavedCaches(boolean withFile) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return Collections.emptyList();
        }
        return item.getSavedDesc(DBRoot.class, withFile ? "graph.xml" : null);
    }

    final void deleteGraphFiles() {
        for (DBItemFileCache i : this.getSavedCaches(true)) {
            this.getGraphFile(i).delete();
        }
    }

    private File getGraphFile(DBItemFileCache i) {
        return i.getFile("graph.xml");
    }

    boolean save(DBRoot r) {
        String rootName = r.getName();
        File rootFile = this.getRootFile(rootName);
        if (rootFile == null) {
            return false;
        }
        try {
            FileUtils.mkdir_p(rootFile.getParentFile());
            PrintWriter pWriter = new PrintWriter(new FileOutputStream(rootFile));
            pWriter.print("<root codecVersion=\"");
            pWriter.print("20120228-1810");
            pWriter.print("\"");
            SQLSchema.getVersionAttr(r.getSchema(), pWriter);
            pWriter.println(" >\n");
            for (SQLTable t : r.getDescs(SQLTable.class)) {
                Set<Link> flinks = this.getForeignLinks(t);
                if (flinks.isEmpty()) continue;
                pWriter.print("<table name=\"");
                pWriter.print(JDOMUtils.OUTPUTTER.escapeAttributeEntities(t.getName()));
                pWriter.println("\">");
                for (Link l : flinks) {
                    l.toXML(pWriter);
                }
                pWriter.println("</table>");
            }
            pWriter.println("\n</root>");
            pWriter.close();
            return true;
        }
        catch (Exception e) {
            Log.get().log(Level.WARNING, "unable to save files in " + rootFile, e);
            return false;
        }
    }

    private ToRefreshSpec.TablesByRoot mapFromXML(ToRefreshSpec.TablesByRoot fromXML) throws JDOMException, IOException {
        ToRefreshSpec.TablesByRoot res = new ToRefreshSpec.TablesByRoot();
        for (DBItemFileCache cache : this.getSavedCaches(true)) {
            String actualVersion;
            String rootName = cache.getName();
            if (!fromXML.containsKey(rootName)) continue;
            Document doc = new SAXBuilder().build(this.getGraphFile(cache));
            String fileVersion = doc.getRootElement().getAttributeValue("codecVersion");
            if (!"20120228-1810".equals(fileVersion)) {
                throw new IOException("wrong version expected 20120228-1810 got: " + fileVersion);
            }
            if (!this.base.contains(rootName)) continue;
            DBRoot r = (DBRoot)this.base.getCheckedChild(rootName);
            String xmlVersion = SQLSchema.getVersion(doc.getRootElement());
            if (!CompareUtils.equals(xmlVersion, actualVersion = r.getSchema().getVersion())) {
                throw new IOException("wrong version expected " + actualVersion + " got: " + xmlVersion);
            }
            Set fromXMLTableNames = (Set)fromXML.get(rootName);
            for (Object o : doc.getRootElement().getChildren()) {
                Element tableElem = (Element)o;
                SQLTable t = r.getTable(tableElem.getAttributeValue("name"));
                if (!fromXMLTableNames.contains(t.getName())) continue;
                for (Object lo : tableElem.getChildren()) {
                    Element linkElem = (Element)lo;
                    this.addLink(Link.fromXML(t, linkElem));
                }
                res.add(rootName, t.getName());
            }
            if (res.containsKey(rootName)) continue;
            res.put(rootName, Collections.emptySet());
        }
        return res;
    }

    public synchronized Set<Link> getForeignLinks(SQLTable table) {
        Set<Link> res = this.foreignLinks.get(table);
        if (res == null) {
            res = Collections.unmodifiableSet(this.getGraphP().outgoingEdgesOf(table));
            this.foreignLinks.put(table, res);
        }
        return res;
    }

    public Set<SQLField> getForeignKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getForeignLinks(table));
    }

    public Link getForeignLink(SQLField fk) {
        return this.getForeignLink(Collections.singletonList(fk));
    }

    public synchronized Link getForeignLink(List<SQLField> fk) {
        if (fk.size() == 0) {
            throw new IllegalArgumentException("empty list");
        }
        if (!this.foreignLink.containsKey(fk)) {
            this.foreignLink.put(fk, (Link)org.apache.commons.collections.CollectionUtils.find(this.getForeignLinks(fk.get(0).getTable()), new LabelPredicate(fk)));
        }
        return this.foreignLink.get(fk);
    }

    public SQLTable getForeignTable(SQLField fk) {
        Link l = this.getForeignLink(fk);
        if (l != null) {
            return (SQLTable)l.getTarget();
        }
        return null;
    }

    public synchronized Set<Link> getForeignLinks(SQLTable t1, SQLTable t2) {
        if (t1 == null || t2 == null) {
            throw new NullPointerException("t1: " + t1 + ", t2: " + t2);
        }
        return this.getGraphP().getAllEdges(t1, t2);
    }

    public Set<SQLField> getForeignFields(SQLTable t1, SQLTable t2) {
        return DatabaseGraph.getLabels(this.getForeignLinks(t1, t2));
    }

    public synchronized Set<Link> getReferentLinks(SQLTable table) {
        return this.getGraphP().incomingEdgesOf(table);
    }

    public Set<SQLField> getReferentKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getReferentLinks(table));
    }

    protected DirectedMultigraph<SQLTable, Link> getGraphP() {
        return (DirectedMultigraph)this.getGraph();
    }

    public static <C extends Collection<String>> C getNames(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add((String)l.getLabel().getName());
        }
        return fields;
    }

    public static Set<String> getNames(Collection<Link> links) {
        return DatabaseGraph.getNames(links, new HashSet());
    }

    public static <C extends Collection<SQLField>> C getLabels(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add((SQLField)l.getLabel());
        }
        return fields;
    }

    public static Set<SQLField> getLabels(Collection<Link> links) {
        return DatabaseGraph.getLabels(links, new HashSet());
    }
}

