/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Comparator;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;

public abstract class BaseGraph {
    private static final Comparator<SQLTable> TABLE_COMP = new Comparator<SQLTable>(){

        @Override
        public int compare(SQLTable o1, SQLTable o2) {
            return o1.getSQLName().quote().compareTo(o2.getSQLName().quote());
        }
    };
    private static final Comparator<Link> LINK_COMP = new Comparator<Link>(){

        @Override
        public int compare(Link o1, Link o2) {
            int srcRes = TABLE_COMP.compare((SQLTable)o1.getSource(), (SQLTable)o2.getSource());
            if (srcRes != 0) {
                return srcRes;
            }
            int destRes = TABLE_COMP.compare((SQLTable)o1.getTarget(), (SQLTable)o2.getTarget());
            if (destRes != 0) {
                return destRes;
            }
            return o1.getCols().toString().compareTo(o2.getCols().toString());
        }
    };
    private final Graph<SQLTable, Link> graph;

    protected BaseGraph(DirectedGraph<SQLTable, Link> g) {
        this.graph = g;
    }

    public final synchronized Set<SQLTable> getAllTables() {
        return this.graph.vertexSet();
    }

    protected final synchronized Graph<SQLTable, Link> getGraph() {
        return this.graph;
    }
}

