/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ServerFinder;
import org.openconcerto.erp.config.ServerFinderConfig;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.sql.Configuration;

public class ServerConfigListModel
extends AbstractListModel {
    private List<ServerFinderConfig> confs = new Vector<ServerFinderConfig>();

    @Override
    public Object getElementAt(int index) {
        return this.confs.get(index);
    }

    @Override
    public int getSize() {
        return this.confs.size();
    }

    public void startScan(PropertyChangeListener propertyChangeListener) {
        ServerFinderConfig c;
        this.confs.clear();
        this.fireContentsChanged(this, 0, 0);
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Impossible de charger le driver PostgreSQL");
            e.printStackTrace();
            return;
        }
        ServerFinder f = new ServerFinder();
        File fH2 = new File(Configuration.getDefaultConfDir(), "OpenConcerto-GESTION_DEFAULT/DBData");
        if (ServerFinderPanel.containsValidH2DB(fH2)) {
            c = new ServerFinderConfig();
            c.setType("H2");
            c.setFile(fH2);
            c.setProduct("H2 OpenConcerto found");
            this.confs.add(c);
        }
        if (ServerFinderPanel.containsValidH2DB(fH2 = new File(Configuration.getDefaultConfDir(), "OpenConcerto/DBData"))) {
            c = new ServerFinderConfig();
            c.setType("H2");
            c.setFile(fH2);
            c.setProduct("H2 OpenConcerto found");
            this.confs.add(c);
        }
        List<String> l = f.getIPsToScan();
        int stop = l.size();
        int i = 0;
        while (i < stop) {
            String ip;
            String s = ip = l.get(i);
            this.scan(s);
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "bar", null, new Integer(1 + i * 100 / stop)));
            ++i;
        }
    }

    public void scan(String ip) {
        boolean maybePostgreSQL;
        ServerFinder f = new ServerFinder();
        System.out.println("Test:'" + ip + "'");
        if (!ip.equals("127.0.0.1")) {
            try {
                InetAddress addr = InetAddress.getByName(ip);
                if (!ServerFinder.ping(addr)) {
                    return;
                }
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
            }
        }
        if (maybePostgreSQL = f.isPortOpen(ip, 5432)) {
            Connection db = null;
            ServerFinderConfig c = new ServerFinderConfig();
            c.setIp(ip);
            c.setPort("5432");
            c.setType("PostgreSQL");
            try {
                db = DriverManager.getConnection("jdbc:postgresql://" + ip + ":5432/OpenConcerto", "openconcerto", "openconcerto");
            }
            catch (SQLException e) {
                e.printStackTrace();
                String message = e.getMessage();
                c.setError(message);
            }
            if (db != null) {
                try {
                    DatabaseMetaData dbmd = db.getMetaData();
                    c.setProduct(String.valueOf(dbmd.getDatabaseProductName()) + " " + dbmd.getDatabaseProductVersion());
                }
                catch (SQLException e) {
                    c.setError(e.getMessage());
                    e.printStackTrace();
                }
                try {
                    db.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.confs.add(c);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerConfigListModel.this.fireContentsChanged(this, 0, ServerConfigListModel.this.confs.size());
                }
            });
        }
    }
}

