/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.sync;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.utils.sync.Range;

public class RangeList {
    private final List<Range> list = new ArrayList<Range>();
    private final int limit;

    public RangeList(int limit) {
        this.limit = limit;
    }

    public void add(Range range) {
        if (range.getStart() < 0 || range.getStart() >= this.limit) {
            throw new IllegalArgumentException(range + " start out of limit");
        }
        if (range.getStop() < 0 || range.getStop() > this.limit) {
            throw new IllegalArgumentException(range + " stop out of limit");
        }
        if (this.list.size() > 0) {
            Range last = this.list.get(this.list.size() - 1);
            if (last.getStop() == range.getStart()) {
                last.setStop(range.getStop());
            } else {
                if (range.getStart() < last.getStart()) {
                    throw new IllegalArgumentException("start (" + range.getStart() + ") < lastStart (" + last.getStart() + ")");
                }
                this.list.add(range);
            }
        } else {
            this.list.add(range);
        }
    }

    public List<Range> getUsedRanges() {
        return this.list;
    }

    public List<Range> getUnusedRanges() {
        ArrayList<Range> result = new ArrayList<Range>();
        if (this.list.size() == 0) {
            result.add(new Range(0, this.limit));
            return result;
        }
        Range r = new Range(0, this.list.get(0).getStart());
        if (!r.isEmpty()) {
            result.add(r);
        }
        int i = 0;
        while (i < this.list.size() - 1) {
            Range r1 = this.list.get(i);
            Range r2 = this.list.get(i + 1);
            result.add(new Range(r1.getStop(), r2.getStart()));
            ++i;
        }
        Range lastRange = new Range(this.list.get(this.list.size() - 1).getStop(), this.limit);
        if (!lastRange.isEmpty()) {
            result.add(lastRange);
        }
        return result;
    }

    public void dump() {
        System.out.println("RangeList 0 - " + this.limit);
        System.out.println("Used");
        for (Range r : this.getUsedRanges()) {
            System.out.println(r);
        }
        System.out.println("Unused");
        List<Range> unusedRanges = this.getUnusedRanges();
        for (Range r : unusedRanges) {
            System.out.println(r);
        }
        System.out.println("===============");
    }
}

