/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.sync;

import org.openconcerto.utils.Base64;

public class FileProperty
implements Comparable<FileProperty> {
    private String name;
    private int size;
    private long date;
    private byte[] sha256;

    public FileProperty(String fileName, int fileSize, long date, byte[] sha256) {
        this.name = fileName;
        this.size = fileSize;
        this.date = date;
        this.sha256 = sha256;
    }

    public boolean isDirectory() {
        return this.size < 0;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getSha256() {
        return this.sha256;
    }

    public String toString() {
        return "[" + this.name + " " + this.size + "bytes " + Base64.encodeBytes(this.sha256) + "] date:" + this.date;
    }

    @Override
    public int compareTo(FileProperty o) {
        return this.name.compareToIgnoreCase(o.name);
    }
}

