/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.EventListenerList;
import org.openconcerto.ui.preferences.PreferencePanel;
import org.openconcerto.ui.preferences.PreferencePanelListener;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public abstract class DefaultPreferencePanel
extends JPanel
implements ActionListener,
PreferencePanel {
    private long showTime = Calendar.getInstance().getTimeInMillis();
    private boolean hasBeenModified = false;
    EventListenerList listeners = new EventListenerList();
    public ContainerListener containerListener = new ContainerAdapter(){

        @Override
        public void componentAdded(ContainerEvent e) {
            DefaultPreferencePanel.this.addListener(e.getChild());
        }
    };

    public DefaultPreferencePanel() {
        this.setOpaque(false);
        this.addContainerListener(this.containerListener);
        this.fireModifyChange(false);
    }

    public abstract String getTitleName();

    public boolean equals(Object obj) {
        if (obj instanceof DefaultPreferencePanel) {
            DefaultPreferencePanel p = (DefaultPreferencePanel)obj;
            return p.getTitleName().equals(this.getTitleName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getTitleName().hashCode();
    }

    public void fireModifyChange(boolean b) {
        long time = Calendar.getInstance().getTimeInMillis();
        if (this.showTime + 2000L < time) {
            this.hasBeenModified = b;
            PreferencePanelListener[] preferencePanelListenerArray = (PreferencePanelListener[])this.listeners.getListeners(PreferencePanelListener.class);
            int n = preferencePanelListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PreferencePanelListener l = preferencePanelListenerArray[n2];
                l.valueModifyChanged(b);
                ++n2;
            }
        }
    }

    private void addListener(Component c) {
        if (JTextField.class.isAssignableFrom(c.getClass())) {
            JTextField text = (JTextField)c;
            text.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    DefaultPreferencePanel.this.fireModifyChange(true);
                }
            });
        } else if (JCheckBox.class.isAssignableFrom(c.getClass())) {
            JCheckBox box = (JCheckBox)c;
            box.addActionListener(this);
        } else if (JPanel.class.isAssignableFrom(c.getClass())) {
            JPanel panel = (JPanel)c;
            Component[] cs = panel.getComponents();
            int i = 0;
            while (i < cs.length) {
                this.addListener(cs[i]);
                ++i;
            }
        } else if (JScrollPane.class.isAssignableFrom(c.getClass())) {
            JScrollPane panel = (JScrollPane)c;
            Component[] cs = panel.getViewport().getComponents();
            int i = 0;
            while (i < cs.length) {
                this.addListener(cs[i]);
                ++i;
            }
        } else if (JRadioButton.class.isAssignableFrom(c.getClass())) {
            JRadioButton radio = (JRadioButton)c;
            radio.addActionListener(this);
        } else if (JLabel.class.isAssignableFrom(c.getClass())) {
            JLabel label = (JLabel)c;
            label.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equalsIgnoreCase("text")) {
                        DefaultPreferencePanel.this.fireModifyChange(true);
                    }
                }
            });
        } else if (JComboBox.class.isAssignableFrom(c.getClass())) {
            JComboBox combo = (JComboBox)c;
            combo.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireModifyChange(true);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }
}

