/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.text;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.text.JTextComponent;

public class TextBehaviour {
    private final JTextComponent comp;
    protected boolean gained;
    protected boolean mousePressed;
    protected String initialText;

    public static final TextBehaviour manage(JTextComponent comp) {
        return new TextBehaviour(comp);
    }

    private TextBehaviour(JTextComponent comp) {
        this.comp = comp;
        this.comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextBehaviour.this.gained = true;
                TextBehaviour.this.initialText = TextBehaviour.this.comp.getText();
                if (!TextBehaviour.this.mousePressed) {
                    TextBehaviour.this.comp.selectAll();
                }
            }
        });
        this.comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TextBehaviour.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TextBehaviour.this.gained && TextBehaviour.this.comp.getSelectedText() == null) {
                    TextBehaviour.this.comp.selectAll();
                }
                TextBehaviour.this.gained = false;
                TextBehaviour.this.mousePressed = false;
            }
        });
        this.comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    TextBehaviour.this.comp.setText(TextBehaviour.this.initialText);
                    TextBehaviour.this.comp.selectAll();
                }
            }
        });
    }
}

