/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class SQLRowValuesListFetcher {
    private final SQLRowValues graph;
    private final Path descendantPath;
    private ITransformer<SQLSelect, SQLSelect> selTransf;
    private Integer selID;
    private boolean ordered;
    private SQLRowValues minGraph;
    private boolean includeForeignUndef;
    private SQLSelect frozen;
    private final Map<Path, Map<Path, SQLRowValuesListFetcher>> grafts;
    private static final ExecutorService exec = new ThreadPoolExecutor(0, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public static SQLRowValuesListFetcher create(final SQLRowValues graph, final boolean ordered) {
        SQLRowValuesListFetcher f;
        Map<Path, SQLRowValuesListFetcher> graftedFetchers;
        SQLRowValuesListFetcher res;
        final HashMap<Path, Path> handledPaths = new HashMap<Path, Path>();
        Path emptyPath = new Path(graph.getTable());
        handledPaths.put(emptyPath, emptyPath);
        graph.getGraph().walk(graph, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

            @Override
            public Path transformChecked(SQLRowValuesCluster.State<Object> input) {
                Path p = input.getPath();
                int i = p.length();
                while (i > 0) {
                    Path subPath = p.subPath(0, i);
                    if (handledPaths.containsKey(subPath)) break;
                    handledPaths.put(subPath, p);
                    --i;
                }
                return null;
            }
        }, RecursionType.DEPTH_FIRST, false);
        final CollectionMap grafts = new CollectionMap();
        graph.getGraph().walk(graph, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

            @Override
            public Path transformChecked(SQLRowValuesCluster.State<Object> input) {
                Path p = input.getPath();
                if (!handledPaths.containsKey(p)) {
                    Path pMinusLast = p.minusLast();
                    if (!input.isBackwards()) {
                        Path existingRefPath = (Path)handledPaths.get(pMinusLast);
                        if (!$assertionsDisabled && existingRefPath == null) {
                            throw new AssertionError();
                        }
                        handledPaths.put(p, existingRefPath);
                    } else {
                        if (!grafts.containsKey(pMinusLast)) {
                            SQLRowValues copy = graph.deepCopy();
                            SQLRowValues graftNode = copy.followPath(pMinusLast);
                            graftNode.clear();
                            SQLRowValues previous = copy.followPath(pMinusLast.minusLast());
                            if (!$assertionsDisabled && !p.getStep(-2).isForeign().booleanValue()) {
                                throw new AssertionError();
                            }
                            previous.remove(p.getStep(-2).getSingleField().getName());
                            if (previous.getGraph() == graftNode.getGraph()) {
                                throw new IllegalArgumentException("Graph is not a tree");
                            }
                            SQLRowValuesListFetcher rec = SQLRowValuesListFetcher.create(graftNode, ordered);
                            Collection<SQLRowValuesListFetcher> ungrafted = rec.ungraft();
                            if (ungrafted == null || ungrafted.size() == 0) {
                                if (!$assertionsDisabled && rec.descendantPath.length() <= 0) {
                                    throw new AssertionError();
                                }
                                grafts.put(pMinusLast, rec);
                            } else {
                                grafts.putAll(pMinusLast, ungrafted);
                            }
                        }
                        throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                    }
                }
                return null;
            }
        }, RecursionType.BREADTH_FIRST, null, false);
        HashSet refPaths = new HashSet(handledPaths.values());
        refPaths.remove(emptyPath);
        if (refPaths.size() == 1) {
            res = new SQLRowValuesListFetcher(graph, (Path)refPaths.iterator().next());
            graftedFetchers = Collections.emptyMap();
        } else {
            res = new SQLRowValuesListFetcher(graph, false);
            graftedFetchers = new HashMap();
            if (refPaths.size() > 0) {
                Path graftPath = new Path(graph.getTable());
                SQLRowValues copy = graph.deepCopy();
                copy.clear();
                for (Path refPath : refPaths) {
                    f = new SQLRowValuesListFetcher(copy, refPath, true).setOrdered(ordered);
                    res.graft(f, graftPath);
                    graftedFetchers.put(refPath, f);
                }
            }
        }
        res.setOrdered(ordered);
        for (Map.Entry e : grafts.entrySet()) {
            Path graftPath = (Path)e.getKey();
            Path refPath = (Path)handledPaths.get(graftPath);
            f = graftedFetchers.containsKey(refPath) ? (SQLRowValuesListFetcher)graftedFetchers.get(refPath) : res;
            for (SQLRowValuesListFetcher recFetcher : e.getValue()) {
                f.graft(recFetcher, graftPath);
            }
        }
        return res;
    }

    private static Path computePath(SQLRowValues graph) {
        Path res = new Path(graph.getTable());
        graph.getGraph().walk(graph, res, new ITransformer<SQLRowValuesCluster.State<Path>, Path>(){

            @Override
            public Path transformChecked(SQLRowValuesCluster.State<Path> input) {
                Collection<SQLRowValues> referentRows = input.getCurrent().getReferentRows();
                if (referentRows.size() > 1) {
                    List<SQLRowValues> toPrint = SQLRowValues.trim(referentRows);
                    throw new IllegalArgumentException(input.getCurrent() + " is referenced by " + toPrint + "\nat " + input.getPath());
                }
                if (referentRows.size() == 0) {
                    input.getAcc().append(input.getPath());
                }
                return input.getAcc();
            }
        }, RecursionType.BREADTH_FIRST, false);
        return res;
    }

    private static final CollectionMap<Tuple2<Path, Number>, SQLRowValues> createCollectionMap() {
        return new CollectionMap<Tuple2<Path, Number>, SQLRowValues>(new ArrayList(8));
    }

    public SQLRowValuesListFetcher(SQLRowValues graph) {
        this(graph, false);
    }

    public SQLRowValuesListFetcher(SQLRowValues graph, boolean referents) {
        this(graph, referents ? SQLRowValuesListFetcher.computePath(graph) : null);
    }

    public SQLRowValuesListFetcher(SQLRowValues graph, Path referentPath) {
        this(graph, referentPath, true);
    }

    SQLRowValuesListFetcher(SQLRowValues graph, Path referentPath, boolean prune) {
        this.graph = graph.deepCopy();
        this.descendantPath = referentPath == null ? new Path(graph.getTable()) : referentPath;
        SQLRowValues descRow = this.graph.followPath(this.descendantPath);
        if (descRow == null) {
            throw new IllegalArgumentException("path is not contained in the passed rowValues : " + referentPath + "\n" + this.graph.printTree());
        }
        assert (this.descendantPath.getFirst() == this.graph.getTable() && this.descendantPath.isSingleLink());
        if (prune) {
            this.graph.getGraph().walk(descRow, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

                @Override
                public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                    if (input.getFrom() == null) {
                        input.getCurrent().clearReferents();
                    } else {
                        input.getCurrent().retainReferent(input.getPrevious());
                    }
                    return null;
                }
            }, RecursionType.BREADTH_FIRST, true);
        }
        for (SQLRowValues curr : this.getGraph().getGraph().getItems()) {
            if (curr.hasID()) continue;
            curr.setID(null);
        }
        this.selTransf = null;
        this.selID = null;
        this.ordered = false;
        this.minGraph = null;
        this.includeForeignUndef = false;
        this.frozen = null;
        this.grafts = new HashMap<Path, Map<Path, SQLRowValuesListFetcher>>(4);
    }

    public final SQLRowValuesListFetcher freeze() {
        if (!this.isFrozen()) {
            this.frozen = new SQLSelect(this.getReq());
            for (Map<Path, SQLRowValuesListFetcher> m : this.grafts.values()) {
                for (SQLRowValuesListFetcher f : m.values()) {
                    f.freeze();
                }
            }
        }
        return this;
    }

    public final boolean isFrozen() {
        return this.frozen != null;
    }

    private final void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("this has been frozen: " + this);
        }
    }

    public SQLRowValues getGraph() {
        return this.graph;
    }

    public final void setIncludeForeignUndef(boolean includeForeignUndef) {
        this.checkFrozen();
        this.includeForeignUndef = includeForeignUndef;
    }

    public final void setFullOnly(boolean b) {
        this.checkFrozen();
        this.minGraph = b ? this.getGraph().deepCopy() : null;
    }

    private final boolean isPathRequired(Path p) {
        return this.minGraph != null && this.minGraph.followPath(p) != null;
    }

    private boolean fetchReferents() {
        return this.descendantPath.length() > 0;
    }

    public void setSelTransf(ITransformer<SQLSelect, SQLSelect> selTransf) {
        this.checkFrozen();
        this.selTransf = selTransf;
    }

    public final ITransformer<SQLSelect, SQLSelect> getSelTransf() {
        return this.selTransf;
    }

    public void setSelID(Integer selID) {
        this.checkFrozen();
        this.selID = selID;
    }

    public final Integer getSelID() {
        return this.selID;
    }

    public final SQLRowValuesListFetcher setOrdered(boolean b) {
        this.checkFrozen();
        this.ordered = b;
        return this;
    }

    public final boolean isOrdered() {
        return this.ordered;
    }

    public final SQLRowValuesListFetcher graft(SQLRowValuesListFetcher other, Path graftPath) {
        this.checkFrozen();
        if (this == other) {
            throw new IllegalArgumentException("trying to graft onto itself");
        }
        if (other.getGraph().getTable() != graftPath.getLast()) {
            throw new IllegalArgumentException("trying to graft " + other.getGraph().getTable() + " at " + graftPath);
        }
        SQLRowValues graftPlace = this.getGraph().followPath(graftPath);
        if (graftPlace == null) {
            throw new IllegalArgumentException("path doesn't exist: " + graftPath);
        }
        assert (graftPath.getLast() == graftPlace.getTable());
        if (other.getGraph().getForeigns().size() > 0) {
            throw new IllegalArgumentException("shouldn't have foreign rows");
        }
        Path descendantPath = SQLRowValuesListFetcher.computePath(other.getGraph());
        int descendantPathLength = descendantPath.length();
        if (descendantPathLength == 0) {
            throw new IllegalArgumentException("empty path");
        }
        assert (descendantPath.isSingleLink());
        if (!this.grafts.containsKey(graftPath)) {
            this.grafts.put(graftPath, new HashMap(4));
        } else {
            Map<Path, SQLRowValuesListFetcher> map = this.grafts.get(graftPath);
            block0: for (Map.Entry<Path, SQLRowValuesListFetcher> e : map.entrySet()) {
                Path fetcherPath = e.getKey();
                SQLRowValuesListFetcher fetcher = e.getValue();
                int i = 1;
                while (i <= descendantPathLength) {
                    Path subPath = descendantPath.subPath(0, i);
                    if (!fetcherPath.startsWith(subPath)) continue block0;
                    if (!fetcher.getGraph().followPath(subPath).getFields().equals(other.getGraph().followPath(subPath).getFields())) {
                        throw new IllegalArgumentException("The same node have different fields in different fetcher\n" + graftPath + "\n" + subPath);
                    }
                    ++i;
                }
            }
        }
        return this.grafts.get(graftPath).put(descendantPath, other);
    }

    public final Collection<SQLRowValuesListFetcher> ungraft() {
        return this.ungraft(new Path(this.getGraph().getTable()));
    }

    public final Collection<SQLRowValuesListFetcher> ungraft(Path graftPath) {
        this.checkFrozen();
        Map<Path, SQLRowValuesListFetcher> res = this.grafts.remove(graftPath);
        return res == null ? null : res.values();
    }

    private final void addFields(SQLSelect sel, SQLRowValues vals, String alias) {
        for (String fieldName : vals.getFields()) {
            sel.addSelect(new AliasedField(vals.getTable().getField(fieldName), alias));
        }
    }

    public final SQLSelect getReq() {
        if (this.isFrozen()) {
            return this.frozen;
        }
        final SQLTable t = this.getGraph().getTable();
        SQLSelect sel = new SQLSelect(t.getBase());
        if (this.includeForeignUndef) {
            sel.setExcludeUndefined(false);
            sel.setExcludeUndefined(true, t);
        }
        if (this.isOrdered() && t.isOrdered()) {
            sel.addFieldOrder(t.getOrderField());
        }
        this.walk(sel, new ITransformer<SQLRowValuesCluster.State<SQLSelect>, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLRowValuesCluster.State<SQLSelect> input) {
                String alias;
                if (input.getFrom() != null) {
                    String joinType;
                    alias = SQLRowValuesListFetcher.getAlias(input.getAcc(), input.getPath());
                    String aliasPrev = input.getPath().length() == 1 ? null : input.getAcc().followPath(t.getName(), input.getPath().subPath(0, -1)).getAlias();
                    String string = joinType = SQLRowValuesListFetcher.this.isPathRequired(input.getPath()) ? "INNER" : "LEFT";
                    if (input.isBackwards()) {
                        input.getAcc().addBackwardJoin(joinType, alias, input.getFrom(), aliasPrev);
                        if (SQLRowValuesListFetcher.this.isOrdered()) {
                            input.getAcc().addOrderSilent(alias);
                        }
                    } else {
                        input.getAcc().addJoin(joinType, new AliasedField(input.getFrom(), aliasPrev), alias);
                    }
                } else {
                    alias = null;
                }
                SQLRowValuesListFetcher.this.addFields(input.getAcc(), input.getCurrent(), alias);
                return input.getAcc();
            }
        });
        if (this.selID != null) {
            sel.andWhere(new Where((FieldRef)t.getKey(), "=", (Object)this.selID));
        }
        return this.getSelTransf() == null ? sel : this.getSelTransf().transformChecked(sel);
    }

    static String getAlias(SQLSelect sel, Path path) {
        String res = "tAlias";
        int stop = path.length();
        int i = 0;
        while (i < stop) {
            res = String.valueOf(res) + "__" + path.getSingleStep(i).getName();
            ++i;
        }
        res = String.valueOf(res) + "__" + path.getTable(stop).getName();
        return sel.getUniqueAlias(res);
    }

    private <S> void walk(S sel, final ITransformer<SQLRowValuesCluster.State<S>, S> transf) {
        this.getGraph().getGraph().walk(this.getGraph(), sel, transf, RecursionType.BREADTH_FIRST, true);
        this.getGraph().getGraph().walk(this.getGraph(), sel, new ITransformer<SQLRowValuesCluster.State<S>, S>(){

            @Override
            public S transformChecked(SQLRowValuesCluster.State<S> input) {
                Path p = input.getPath();
                if (p.getStep(0).isForeign().booleanValue()) {
                    throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                }
                Step lastStep = p.getStep(p.length() - 1);
                if (!lastStep.isForeign().booleanValue() && !p.isSingleDirection(false).booleanValue()) {
                    throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                }
                return transf.transformChecked(input);
            }
        }, RecursionType.BREADTH_FIRST, null, false);
    }

    public final List<SQLRowValues> fetch() {
        return this.fetch(true);
    }

    private final List<SQLRowValues> fetch(boolean merge) {
        List<SQLRowValues> merged;
        SQLSelect req = this.getReq();
        ArrayList<String> selectFields = new ArrayList<String>(req.getSelectFields().size());
        for (SQLField f : req.getSelectFields()) {
            selectFields.add(f.getName());
        }
        SQLTable table = this.getGraph().getTable();
        int graphSize = this.getGraph().getGraph().size();
        final ArrayList l = new ArrayList(graphSize);
        this.walk(0, new ITransformer<SQLRowValuesCluster.State<Integer>, Integer>(){

            @Override
            public Integer transformChecked(SQLRowValuesCluster.State<Integer> input) {
                int index = l.size();
                l.add(new GraphNode(input));
                return index;
            }
        });
        assert (l.size() == graphSize) : "All nodes weren't explored once : " + l.size() + " != " + graphSize + "\n" + this.getGraph().printGraph();
        IResultSetHandler rsh = new IResultSetHandler(new RSH(selectFields, l), false);
        List<SQLRowValues> res = (List<SQLRowValues>)table.getBase().getDataSource().execute(req.asString(), (ResultSetHandler)rsh, false);
        List<SQLRowValues> list = merged = merge && this.fetchReferents() ? this.merge(res) : res;
        if (this.grafts.size() > 0) {
            for (Map.Entry<Path, Map<Path, SQLRowValuesListFetcher>> graftPlaceEntry : this.grafts.entrySet()) {
                Path graftPlace = graftPlaceEntry.getKey();
                Path mapPath = new Path(graftPlace.getLast());
                HashSet<Number> ids = new HashSet<Number>();
                CollectionMap<Tuple2<Path, Number>, SQLRowValues> byRows = SQLRowValuesListFetcher.createCollectionMap();
                for (SQLRowValues sQLRowValues : merged) {
                    SQLRowValues graftPlaceVals = sQLRowValues.followPath(graftPlace);
                    if (graftPlaceVals == null) continue;
                    ids.add(graftPlaceVals.getIDNumber());
                    byRows.put(Tuple2.create(mapPath, graftPlaceVals.getIDNumber()), (Object)graftPlaceVals);
                }
                assert (ids.size() == byRows.size());
                for (Map.Entry entry : graftPlaceEntry.getValue().entrySet()) {
                    Path descendantPath = (Path)entry.getKey();
                    assert (descendantPath.getFirst() == graftPlace.getLast()) : descendantPath + " != " + graftPlace;
                    SQLRowValuesListFetcher graft = (SQLRowValuesListFetcher)entry.getValue();
                    SQLSelect toRestore = graft.frozen;
                    graft.frozen = new SQLSelect(graft.getReq()).andWhere(new Where(graft.getGraph().getTable().getKey(), ids));
                    List<SQLRowValues> referentVals = graft.fetch(false);
                    graft.frozen = toRestore;
                    this.merge(merged, referentVals, byRows, descendantPath);
                }
            }
        }
        return merged;
    }

    private static void link(List<GraphNode> l, List<List<SQLRowValues>> rows, int start, int stop) {
        int graphSize = l.size();
        int nodeIndex = 1;
        while (nodeIndex < graphSize) {
            GraphNode node = l.get(nodeIndex);
            String fromName = node.getFromName();
            int linkIndex = node.getLinkIndex();
            boolean backwards = node.isBackwards();
            int i = start;
            while (i < stop) {
                List<SQLRowValues> row = rows.get(i);
                SQLRowValues creatingVals = row.get(nodeIndex);
                if (creatingVals.hasID()) {
                    SQLRowValues valsToPut;
                    SQLRowValues valsToFill;
                    if (backwards) {
                        valsToFill = creatingVals;
                        valsToPut = row.get(linkIndex);
                    } else {
                        valsToFill = row.get(linkIndex);
                        valsToPut = creatingVals;
                    }
                    valsToFill.put(fromName, valsToPut, false);
                }
                ++i;
            }
            ++nodeIndex;
        }
    }

    private final List<SQLRowValues> merge(List<SQLRowValues> l) {
        return this.merge(l, l, null, this.descendantPath);
    }

    private final List<SQLRowValues> merge(List<SQLRowValues> tree, List<SQLRowValues> graft, CollectionMap<Tuple2<Path, Number>, SQLRowValues> graftPlaceRows, Path descendantPath) {
        boolean isGraft;
        boolean bl = isGraft = graftPlaceRows != null;
        assert (tree != graft == isGraft) : "Trying to graft onto itself";
        ArrayList<SQLRowValues> res = isGraft ? tree : new ArrayList<SQLRowValues>();
        CollectionMap<Tuple2<Path, Number>, SQLRowValues> map = isGraft ? graftPlaceRows : SQLRowValuesListFetcher.createCollectionMap();
        int stop = descendantPath.length();
        for (SQLRowValues v : graft) {
            boolean doAdd = true;
            SQLRowValues previous = null;
            int i = stop;
            while (i >= 0 && doAdd) {
                Path subPath = descendantPath.subPath(0, i);
                SQLRowValues desc = v.followPath(subPath);
                if (desc != null) {
                    Tuple2<Path, Number> row = Tuple2.create(subPath, desc.getIDNumber());
                    if (map.containsKey(row)) {
                        doAdd = false;
                        assert (((SQLRowValues)((List)map.getNonNull(row)).get(0)).getFields().containsAll(desc.getFields())) : "Discarding an SQLRowValues with more fields : " + desc;
                        if (previous != null) {
                            List destinationRows = (List)map.getNonNull(row);
                            int destinationSize = destinationRows.size();
                            assert (destinationSize > 0) : "Map contains row but have no corresponding value: " + row;
                            String ffName = descendantPath.getSingleStep(i).getName();
                            int j = 1;
                            while (j < destinationSize) {
                                previous.deepCopy().put(ffName, destinationRows.get(j));
                                ++j;
                            }
                            previous.put(ffName, destinationRows.get(0));
                        }
                    } else {
                        map.put(row, (Object)desc);
                    }
                    previous = desc;
                }
                --i;
            }
            if (!doAdd) continue;
            assert (!isGraft) : "Adding graft values as tree values";
            res.add(v);
        }
        return res;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getGraph() + " with " + this.getSelID() + " and " + this.getSelTransf();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLRowValuesListFetcher) {
            SQLRowValuesListFetcher o = (SQLRowValuesListFetcher)obj;
            return this.getReq().equals(o.getReq()) && CompareUtils.equals(this.descendantPath, o.descendantPath) && this.grafts.equals(o.grafts);
        }
        return false;
    }

    public int hashCode() {
        return this.getReq().hashCode();
    }

    private static final class GraphNode {
        private final SQLTable t;
        private final int fieldCount;
        private final int linkIndex;
        private final Step from;

        private GraphNode(SQLRowValuesCluster.State<Integer> input) {
            this.t = input.getCurrent().getTable();
            this.fieldCount = input.getCurrent().size();
            this.linkIndex = input.getAcc();
            int length = input.getPath().length();
            this.from = length == 0 ? null : input.getPath().getStep(length - 1);
        }

        public final SQLTable getTable() {
            return this.t;
        }

        public final int getFieldCount() {
            return this.fieldCount;
        }

        public final int getLinkIndex() {
            return this.linkIndex;
        }

        public final String getFromName() {
            return this.from.getSingleField().getName();
        }

        public final boolean isBackwards() {
            return !this.from.isForeign(this.from.getSingleField());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fieldCount;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + this.linkIndex;
            result = 31 * result + this.t.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GraphNode other = (GraphNode)obj;
            return this.fieldCount == other.fieldCount && this.linkIndex == other.linkIndex && this.t.equals(other.t) && CompareUtils.equals(this.from, other.from);
        }

        public String toString() {
            String link = this.from == null ? "" : " linked to " + this.getLinkIndex() + " by " + this.getFromName() + (this.isBackwards() ? " backwards" : " forewards");
            return String.valueOf(this.getFieldCount()) + " fields of " + this.getTable() + link;
        }
    }

    private static final class Linker
    implements Callable<Object> {
        private final List<GraphNode> l;
        private final List<List<SQLRowValues>> rows;
        private final int fromIndex;
        private final int toIndex;

        public Linker(List<GraphNode> l, List<List<SQLRowValues>> rows, int first, int last) {
            this.l = l;
            this.rows = rows;
            this.fromIndex = first;
            this.toIndex = last;
        }

        @Override
        public Object call() throws Exception {
            SQLRowValuesListFetcher.link(this.l, this.rows, this.fromIndex, this.toIndex);
            return null;
        }
    }

    private static final class RSH
    implements ResultSetHandler {
        private final List<String> selectFields;
        private final List<GraphNode> graphNodes;

        private RSH(List<String> selectFields, List<GraphNode> l) {
            this.selectFields = selectFields;
            this.graphNodes = l;
        }

        @Override
        public Object handle(ResultSet rs) throws SQLException {
            int i;
            List<GraphNode> l = this.graphNodes;
            int graphSize = l.size();
            int nextToLink = 0;
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(64);
            List<List<SQLRowValues>> rows = Collections.synchronizedList(new ArrayList(64));
            while (rs.next()) {
                int rsIndex = 1;
                if (Thread.currentThread().isInterrupted()) {
                    throw new RTInterruptedException("interrupted while fetching");
                }
                ArrayList<SQLRowValues> arrayList = new ArrayList<SQLRowValues>(graphSize);
                i = 0;
                while (i < graphSize) {
                    GraphNode node = l.get(i);
                    SQLRowValues creatingVals = new SQLRowValues(node.getTable());
                    if (i == 0) {
                        res.add(creatingVals);
                    }
                    int stop = rsIndex + node.getFieldCount();
                    while (rsIndex < stop) {
                        try {
                            creatingVals.put(this.selectFields.get(rsIndex - 1), rs.getObject(rsIndex), false);
                        }
                        catch (SQLException e) {
                            throw new IllegalStateException("unable to fill " + creatingVals, e);
                        }
                        ++rsIndex;
                    }
                    arrayList.add(creatingVals);
                    ++i;
                }
                rows.add(arrayList);
                int currentCount = rows.size();
                if (currentCount % 1000 != 0) continue;
                futures.add(exec.submit(new Linker(l, rows, nextToLink, currentCount)));
                nextToLink = currentCount;
            }
            int rowSize = rows.size();
            assert (nextToLink > 0 == futures.size() > 0);
            if (nextToLink > 0) {
                futures.add(exec.submit(new Linker(l, rows, nextToLink, rowSize)));
            }
            if (rowSize > 0) {
                List list = (List)rows.get(0);
                i = 0;
                while (i < graphSize) {
                    SQLRowValues vals = (SQLRowValues)list.get(i);
                    if (!vals.getTable().getFieldsName().containsAll(vals.getFields())) {
                        throw new IllegalStateException("field name error : " + vals.getFields() + " not in " + vals.getTable().getFieldsName());
                    }
                    ++i;
                }
            }
            if (nextToLink == 0) {
                SQLRowValuesListFetcher.link(l, rows, 0, rowSize);
            } else {
                try {
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (Exception exception) {
                    throw new IllegalStateException("couldn't link", exception);
                }
            }
            return res;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.graphNodes.hashCode();
            result = 31 * result + this.selectFields.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RSH other = (RSH)obj;
            return this.graphNodes.equals(other.graphNodes) && this.selectFields.equals(other.selectFields);
        }
    }
}

