/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;

public class FieldPath
implements IFieldPath {
    private final Path p;
    private final String fieldName;

    public static Set<FieldPath> create(Path p, Collection<String> fields) {
        HashSet<FieldPath> res = new HashSet<FieldPath>();
        for (String f : fields) {
            res.add(new FieldPath(p, f));
        }
        return res;
    }

    public FieldPath(IFieldPath f) {
        this(f.getPath(), f.getField().getName());
    }

    public FieldPath(Path p, String fieldName) {
        this.p = p;
        if (!this.p.isSingleLink()) {
            throw new IllegalArgumentException(p + " is not single link");
        }
        this.fieldName = fieldName;
        if (!p.getLast().contains(fieldName)) {
            throw new IllegalArgumentException(String.valueOf(fieldName) + " is not part of " + p);
        }
    }

    @Override
    public final Path getPath() {
        return this.p;
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public Object getObject(SQLRowValues r) {
        SQLRowValues vals = r.followPath(this.getPath());
        return vals == null ? null : vals.getObject(this.getFieldName());
    }

    public String getString(SQLRowValues r) {
        SQLRowValues vals = r.followPath(this.getPath());
        return vals == null ? null : vals.getString(this.getFieldName());
    }

    @Override
    public SQLField getField() {
        return this.p.getLast().getField(this.fieldName);
    }

    @Override
    public SQLTable getTable() {
        return this.p.getLast();
    }

    @Override
    public FieldPath getFieldPath() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldPath) {
            FieldPath o = (FieldPath)obj;
            return this.p.equals(o.p) && this.fieldName.equals(o.fieldName);
        }
        return false;
    }

    public int hashCode() {
        return this.p.hashCode() + this.fieldName.hashCode();
    }

    public String toString() {
        String path = "";
        int i = 0;
        while (i < this.p.length()) {
            SQLField step = this.p.getSingleStep(i);
            path = String.valueOf(path) + step.getFullName() + ",";
            ++i;
        }
        return String.valueOf(this.getClass().getSimpleName()) + " " + path + this.fieldName;
    }
}

