/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtSaisieKm
extends GenerationEcritures {
    private int idSaisieKm;

    public GenerationMvtSaisieKm(int idSaisieKm) {
        this.idSaisieKm = idSaisieKm;
    }

    public int genereMouvement() {
        SQLRow saisieRow = base.getTable("SAISIE_KM").getRow(this.idSaisieKm);
        this.date = (Date)saisieRow.getObject("DATE");
        this.nom = saisieRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", saisieRow.getObject("ID_JOURNAL"));
        this.mEcritures.put("ID_MOUVEMENT", new Integer(1));
        this.getNewMouvement("SAISIE_KM", this.idSaisieKm, 1, "Saisie au km " + saisieRow.getObject("NOM").toString());
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_KM_ELEMENT");
        Collection set = saisieRow.getReferentRows(tableElt);
        try {
            for (SQLRow rowElement : set) {
                int idCpt = ComptePCESQLElement.getId(rowElement.getString("NUMERO"), rowElement.getString("NOM"));
                this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCpt));
                this.mEcritures.put("NOM", rowElement.getString("NOM_ECRITURE"));
                this.mEcritures.put("DEBIT", rowElement.getObject("DEBIT"));
                this.mEcritures.put("CREDIT", rowElement.getObject("CREDIT"));
                int idEcr = this.ajoutEcriture();
                if (idEcr <= 1) continue;
                SQLRowValues vals = rowElement.createEmptyUpdateRow();
                vals.put("ID_ECRITURE", new Integer(idEcr));
                try {
                    vals.update();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
        return this.idMvt;
    }
}

