/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.MathContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class PrixUnitaireRemiseProvider
extends UserInitialsValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        Long pv = row.getLong("PV_HT");
        BigDecimal remise = (BigDecimal)row.getObject("POURCENT_REMISE");
        BigDecimal result = BigDecimal.ONE.subtract(remise.movePointLeft(2)).multiply(new BigDecimal(pv), MathContext.DECIMAL128);
        result = result.movePointLeft(2);
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("PrixUnitaireRemise", new PrixUnitaireRemiseProvider());
    }
}

