/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.sales.quote.ui.DevisItemTable;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.ui.RadioButtons;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class DevisSQLComponent
extends BaseSQLComponent {
    private DevisItemTable table;
    private JUniqueTextField numeroUniqueDevis;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final ITextArea infos = new ITextArea();
    private final RadioButtons radioEtat = new RadioButtons("NOM");
    private JTextField textPourcentRemise;
    private JTextField textPoidsTotal;
    private DeviseField textRemiseHT;
    private DeviseField fieldHT;
    private PanelOOSQLComponent panelOO;

    public DevisSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelNumero = new JLabel(this.getLabelFor("NUMERO"));
        labelNumero.setHorizontalAlignment(4);
        this.add((Component)labelNumero, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.numeroUniqueDevis = new JUniqueTextField(15);
        DefaultGridBagConstraints.lockMinimumSize(this.numeroUniqueDevis);
        DefaultGridBagConstraints.lockMaximumSize(this.numeroUniqueDevis);
        this.add((Component)this.numeroUniqueDevis, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        this.add((Component)labelDate, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        JDate dateDevis = new JDate(true);
        this.add((Component)((Object)dateDevis), c);
        this.radioEtat.setLayout(new VFlowLayout());
        this.radioEtat.setBorder(BorderFactory.createTitledBorder(this.getLabelFor("ID_ETAT_DEVIS")));
        c.gridwidth = 0;
        c.gridheight = 5;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.gridx += 2;
        this.add((Component)this.radioEtat, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 0.0;
        JLabel labelObjet = new JLabel(this.getLabelFor("OBJET"));
        labelObjet.setHorizontalAlignment(4);
        this.add((Component)labelObjet, c);
        SQLTextCombo textObjet = new SQLTextCombo();
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 1;
        this.add((Component)textObjet, c);
        String field = "ID_COMMERCIAL";
        JLabel labelCommercial = new JLabel(this.getLabelFor(field));
        labelCommercial.setHorizontalAlignment(4);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)labelCommercial, c);
        ElementComboBox comboCommercial = new ElementComboBox(false, 25);
        comboCommercial.setListIconVisible(false);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)comboCommercial, c);
        this.addRequiredSQLObject(comboCommercial, field);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelClient = new JLabel(this.getLabelFor("ID_CLIENT"));
        labelClient.setHorizontalAlignment(4);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)labelClient, c);
        final ElementComboBox comboClient = new ElementComboBox();
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)comboClient, c);
        final ElementComboBox boxTarif = new ElementComboBox();
        comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Integer id;
                if (comboClient.getValue() != null && (id = comboClient.getValue()) > 1) {
                    SQLRow row = comboClient.getElement().getTable().getRow(id);
                    if (comboClient.getElement().getTable().getFieldsName().contains("ID_TARIF")) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") != 0)) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        }
                    }
                }
            }
        });
        if (this.getTable().getFieldsName().contains("DATE_VALIDITE")) {
            ++c.gridx;
            this.add((Component)new JLabel(this.getLabelFor("DATE_VALIDITE")), c);
            ++c.gridx;
            JDate dateValidite = new JDate();
            this.add((Component)((Object)dateValidite), c);
            this.addView((JComponent)((Object)dateValidite), "DATE_VALIDITE");
        }
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            JLabel comp = new JLabel("Tarif \u00e0 appliquer", 4);
            this.add((Component)comp, c);
            ++c.gridx;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            DefaultGridBagConstraints.lockMinimumSize(boxTarif);
            boxTarif.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DevisSQLComponent.this.table.setTarif(boxTarif.getSelectedRow(), false);
                }
            });
        }
        this.table = new DevisItemTable();
        c.fill = 1;
        c.gridx = 0;
        c.gridy += 2;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.table, c);
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cBottom = new DefaultGridBagConstraints();
        cBottom.weightx = 1.0;
        bottomPanel.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), cBottom);
        ++cBottom.gridy;
        cBottom.fill = 1;
        cBottom.weighty = 0.0;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        bottomPanel.add((Component)scrollPane, cBottom);
        JPanel panel = new JPanel(new GridBagLayout());
        this.textPoidsTotal = new JTextField(8);
        this.textPoidsTotal.setText("0.0");
        DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
        panel.add((Component)new JLabel(this.getLabelFor("T_POIDS")), cPanel);
        cPanel.weightx = 0.0;
        ++cPanel.gridx;
        panel.add((Component)this.textPoidsTotal, cPanel);
        this.textPoidsTotal.setEnabled(false);
        this.textPoidsTotal.setEditable(false);
        this.textPoidsTotal.setHorizontalAlignment(4);
        this.textPoidsTotal.setDisabledTextColor(Color.BLACK);
        ++cPanel.gridy;
        cPanel.gridx = 0;
        panel.add((Component)new JLabel(this.getLabelFor("PORT_HT"), 4), cPanel);
        ++cPanel.gridx;
        DeviseField textPortHT = new DeviseField();
        panel.add((Component)textPortHT, cPanel);
        final JRadioButton radioEuros = new JRadioButton("en \u20ac");
        JRadioButton radioPourCent = new JRadioButton("en %");
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(radioEuros);
        radioGroup.add(radioPourCent);
        radioEuros.setSelected(true);
        JPanel panelRemise = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cRemise = new DefaultGridBagConstraints();
        cRemise.insets = new Insets(0, 0, 1, 0);
        JLabel labelRemise = new JLabel(this.getLabelFor("REMISE_HT"));
        panelRemise.add((Component)labelRemise, cRemise);
        ++cRemise.gridx;
        panelRemise.add((Component)radioEuros, cRemise);
        ++cRemise.gridx;
        cRemise.weightx = 0.0;
        this.textRemiseHT = new DeviseField();
        panelRemise.add((Component)this.textRemiseHT, cRemise);
        this.textRemiseHT.setMinimumSize(new Dimension(150, 20));
        this.textRemiseHT.setPreferredSize(new Dimension(150, 20));
        cRemise.gridx = 1;
        ++cRemise.gridy;
        cRemise.weightx = 0.0;
        panelRemise.add((Component)radioPourCent, cRemise);
        this.textPourcentRemise = new JTextField(5);
        DefaultGridBagConstraints.lockMinimumSize(this.textPourcentRemise);
        ++cRemise.gridx;
        panelRemise.add((Component)this.textPourcentRemise, cRemise);
        cPanel.gridx = 0;
        ++cPanel.gridy;
        cPanel.gridwidth = 2;
        panel.add((Component)panelRemise, cPanel);
        cBottom.gridy = 0;
        ++cBottom.gridx;
        cBottom.weighty = 0.0;
        cBottom.weightx = 1.0;
        cBottom.gridheight = 2;
        cBottom.fill = 2;
        cBottom.anchor = 12;
        DefaultGridBagConstraints.lockMinimumSize(panel);
        this.addSQLObject(this.textRemiseHT, "REMISE_HT");
        this.addSQLObject(textPortHT, "PORT_HT");
        this.fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        this.fieldHT.setEditable(false);
        fieldTVA.setEditable(false);
        fieldTTC.setEditable(false);
        fieldService.setEditable(false);
        this.addRequiredSQLObject(this.fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        JTextField poids = new JTextField();
        DeviseField fieldHA = new DeviseField();
        if (this.getTable().contains("PREBILAN")) {
            this.addSQLObject(fieldHA, "PREBILAN");
        } else if (this.getTable().contains("T_HA")) {
            this.addSQLObject(fieldHA, "T_HA");
        }
        final TotalPanel totalTTC = new TotalPanel(this.table, this.fieldHT, fieldTVA, fieldTTC, textPortHT, this.textRemiseHT, fieldService, fieldHA, fieldDevise, poids, null);
        cBottom.gridy = 0;
        cBottom.gridx += 2;
        cBottom.gridheight = 2;
        cBottom.gridwidth = 1;
        cBottom.fill = 0;
        cBottom.weightx = 0.0;
        cBottom.anchor = 12;
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        bottomPanel.add((Component)totalTTC, cBottom);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridwidth = 0;
        this.add((Component)bottomPanel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 14;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        textPortHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        this.textRemiseHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        this.textPourcentRemise.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                DevisSQLComponent.this.calculPourcentage();
            }
        });
        radioEuros.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DevisSQLComponent.this.textRemiseHT.setEnabled(radioEuros.isSelected());
                DevisSQLComponent.this.textPourcentRemise.setEnabled(!radioEuros.isSelected());
            }
        });
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DevisSQLComponent.this.textPoidsTotal.setText(String.valueOf(DevisSQLComponent.this.table.getPoidsTotal()));
            }
        });
        this.addRequiredSQLObject(comboClient, "ID_CLIENT");
        this.addSQLObject(textObjet, "OBJET");
        this.addSQLObject(this.textPoidsTotal, "T_POIDS");
        this.addRequiredSQLObject((JComponent)((Object)dateDevis), "DATE");
        this.addRequiredSQLObject(this.radioEtat, "ID_ETAT_DEVIS");
        this.addRequiredSQLObject(this.numeroUniqueDevis, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        DefaultGridBagConstraints.lockMinimumSize(comboCommercial);
        DefaultGridBagConstraints.lockMinimumSize(comboClient);
    }

    @Override
    protected SQLRowValues createDefaults() {
        System.err.println("Create defaults");
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(DevisSQLElement.class));
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        if (this.getTable().getUndefinedID() == -1) {
            rowVals.put("ID_ETAT_DEVIS", 2);
        } else {
            SQLRowValues foreign = UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.getTable());
            if (foreign != null && !foreign.isUndefined()) {
                rowVals.put("ID_ETAT_DEVIS", foreign.getID());
            } else {
                rowVals.put("ID_ETAT_DEVIS", 2);
            }
        }
        rowVals.put("T_HT", 0L);
        rowVals.put("T_TVA", 0L);
        rowVals.put("T_SERVICE", 0L);
        rowVals.put("T_TTC", 0L);
        if (this.getTable().getFieldsName().contains("DATE_VALIDITE")) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, 1);
            rowVals.put("DATE_VALIDITE", cal.getTime());
        }
        return rowVals;
    }

    private void calculPourcentage() {
        String remiseP = this.textPourcentRemise.getText().replace(',', '.');
        Long totalHT = (Long)this.fieldHT.getUncheckedValue();
        Long remiseHT = (Long)this.textRemiseHT.getUncheckedValue();
        totalHT = totalHT == null ? Long.valueOf(0L) : totalHT;
        remiseHT = remiseHT == null ? Long.valueOf(0L) : remiseHT;
        try {
            int valueRemise = Integer.valueOf(remiseP);
            long remise = (long)valueRemise * (totalHT + remiseHT) / 100L;
            if (remiseHT != remise) {
                this.textRemiseHT.setValue(GestionDevise.currencyToString(remise));
            }
        }
        catch (NumberFormatException e) {
            ExceptionHandler.handle("Erreur durant le calcul de la remise", e);
        }
    }

    @Override
    public int insert(SQLRow order) {
        int idDevis;
        if (this.numeroUniqueDevis.checkValidation()) {
            idDevis = super.insert(order);
            this.table.updateField("ID_DEVIS", idDevis);
            this.table.createArticle(idDevis, this.getElement());
            try {
                DevisXmlSheet sheet = new DevisXmlSheet(this.getTable().getRow(idDevis));
                sheet.createDocumentAsynchronous();
                sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de cr\u00e9er le devis", e);
            }
            if (NumerotationAutoSQLElement.getNextNumero(DevisSQLElement.class).equalsIgnoreCase(this.numeroUniqueDevis.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt(NumerotationAutoSQLElement.getLabelNumberFor(DevisSQLElement.class));
                rowVals.put(NumerotationAutoSQLElement.getLabelNumberFor(DevisSQLElement.class), new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            idDevis = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de devis existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idDevis;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            this.numeroUniqueDevis.setIdSelected(r.getID());
        }
        if (r == null || r.getIDNumber() == null) {
            super.select(r);
        } else {
            System.err.println(r);
            SQLRowValues rVals = r.asRowValues();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            System.err.println("Select CLIENT");
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        }
        if (r != null) {
            this.table.insertFrom("ID_DEVIS", r.getID());
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueDevis.checkValidation()) {
            ExceptionHandler.handle("Impossible de modifier, num\u00e9ro de devis existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.table.updateField("ID_DEVIS", this.getSelectedID());
        this.table.createArticle(this.getSelectedID(), this.getElement());
        try {
            DevisXmlSheet sheet = new DevisXmlSheet(this.getTable().getRow(this.getSelectedID()));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le devis", e);
        }
    }

    public void loadDevisExistant(int idDevis) {
        Collection myListItem;
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLRow row = devis.getTable().getRow(idDevis);
            SQLRowValues rowVals = new SQLRowValues(devis.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(DevisSQLElement.class));
            this.select(rowVals);
        }
        if ((myListItem = devis.getTable().getRow(idDevis).getReferentRows(devisElt.getTable())).size() != 0) {
            this.table.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                this.table.getModel().addRow(rowVals);
                int rowIndex = this.table.getModel().getRowCount() - 1;
                this.table.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.table.getModel().clearRows();
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }
}

