/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.component;

import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.FonctionTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.ui.JMultiLineToolTip;

public class VariableTree
extends JTree {
    private static DefaultMutableTreeNode rootVar = new DefaultMutableTreeNode("Variables");
    private static DefaultMutableTreeNode nodeVariablesPaye = null;
    private static Map<String, DefaultMutableTreeNode> mapCategorie;
    private static final DefaultTreeModel model;

    static {
        model = new DefaultTreeModel(rootVar, false);
        VariableTree.loadNode();
        VariableTree.setSQLTableListener();
    }

    public VariableTree() {
        this.setModel(model);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (leaf) {
                    Object obj = value;
                    if (obj != null && obj instanceof FormuleTreeNode) {
                        FormuleTreeNode n = (FormuleTreeNode)obj;
                        String strTmp = n.getTextInfosValue();
                        if (strTmp != null && strTmp.length() != 0) {
                            this.setToolTipText(strTmp);
                        } else {
                            this.setToolTipText(null);
                        }
                    }
                } else {
                    this.setToolTipText(null);
                }
                return this;
            }
        };
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
        this.expandRow(0);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private static void loadNode() {
        Map<String, List<?>> m = VariablePayeSQLElement.getMapTree();
        rootVar.removeAllChildren();
        mapCategorie = new HashMap<String, DefaultMutableTreeNode>();
        Object[] key = m.keySet().toArray();
        int i = 0;
        while (i < key.length) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(key[i]);
            int place = 0;
            while (place < rootVar.getChildCount()) {
                if (node.toString().compareToIgnoreCase(rootVar.getChildAt(place).toString()) < 0) break;
                ++place;
            }
            rootVar.insert(node, place);
            List<?> l = m.get(key[i]);
            int j = 0;
            while (j < l.size()) {
                if (l.get(j) instanceof SQLField) {
                    VariableTreeNode nodeVar = new VariableTreeNode((SQLField)l.get(j));
                    int n = 0;
                    while (n < node.getChildCount()) {
                        if (nodeVar.toString().compareToIgnoreCase(node.getChildAt(n).toString()) < 0) break;
                        ++n;
                    }
                    node.insert(nodeVar, n);
                } else if (l.get(j) instanceof SQLRow) {
                    if (nodeVariablesPaye == null) {
                        nodeVariablesPaye = node;
                    }
                    String cat = ((SQLRow)l.get(j)).getString("CATEGORIE").trim();
                    VariableRowTreeNode nodeVar = new VariableRowTreeNode((SQLRow)l.get(j));
                    if (cat.length() == 0) {
                        int n = 0;
                        while (n < node.getChildCount()) {
                            if (nodeVar.toString().compareToIgnoreCase(node.getChildAt(n).toString()) < 0) break;
                            ++n;
                        }
                        node.insert(nodeVar, n);
                    } else if (mapCategorie.get(cat.toLowerCase()) != null) {
                        DefaultMutableTreeNode nodeCat = mapCategorie.get(cat.toLowerCase());
                        int n = 0;
                        while (n < nodeCat.getChildCount()) {
                            if (nodeVar.toString().compareToIgnoreCase(nodeCat.getChildAt(n).toString()) <= 0) break;
                            ++n;
                        }
                        nodeCat.insert(nodeVar, n);
                    } else {
                        DefaultMutableTreeNode nodeCat = new DefaultMutableTreeNode(cat.toLowerCase());
                        int n = 0;
                        while (n < node.getChildCount()) {
                            if (nodeCat.toString().compareToIgnoreCase(node.getChildAt(n).toString()) <= 0) break;
                            ++n;
                        }
                        node.insert(nodeCat, n);
                        mapCategorie.put(cat.toLowerCase(), nodeCat);
                        nodeCat.add(nodeVar);
                    }
                } else if (l.get(j) instanceof HashMap) {
                    HashMap mapFonction = (HashMap)l.get(j);
                    Object[] keys = mapFonction.keySet().toArray();
                    int k = 0;
                    while (k < keys.length) {
                        FonctionTreeNode nodeFunction = new FonctionTreeNode(keys[k].toString(), mapFonction.get(keys[k]).toString());
                        int n = 0;
                        while (n < node.getChildCount()) {
                            if (nodeFunction.toString().compareToIgnoreCase(node.getChildAt(n).toString()) <= 0) break;
                            ++n;
                        }
                        node.insert(nodeFunction, n);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        model.reload();
        System.err.println("TREE CHANGED");
    }

    @Override
    public JToolTip createToolTip() {
        JMultiLineToolTip t = new JMultiLineToolTip();
        t.setFixedWidth(300);
        return t;
    }

    private static void modifyNode(SQLRow row, MutableTreeNode nodeParent) {
        int i = 0;
        while (i < nodeParent.getChildCount()) {
            VariableRowTreeNode nodeTmp;
            TreeNode o = nodeParent.getChildAt(i);
            if (o instanceof VariableRowTreeNode && (nodeTmp = (VariableRowTreeNode)o).getID() == row.getID()) {
                nodeTmp.setRow(row);
                model.nodeChanged(nodeTmp);
                System.err.println("Find & refresh");
                return;
            }
            ++i;
        }
    }

    private static void addNode(SQLRow row, MutableTreeNode nodeParent) {
        VariableRowTreeNode nodeVar = new VariableRowTreeNode(row);
        int n = 0;
        while (n < nodeParent.getChildCount()) {
            if (nodeVar.toString().compareToIgnoreCase(nodeParent.getChildAt(n).toString()) <= 0) break;
            ++n;
        }
        model.insertNodeInto(nodeVar, nodeParent, n);
    }

    private static void removeNode(SQLRow row, MutableTreeNode nodeParent) {
        int i = 0;
        while (i < nodeParent.getChildCount()) {
            VariableRowTreeNode nodeTmp;
            TreeNode o = nodeParent.getChildAt(i);
            if (o instanceof VariableRowTreeNode && (nodeTmp = (VariableRowTreeNode)o).getID() == row.getID()) {
                model.removeNodeFromParent(nodeTmp);
                System.err.println("Find & removed");
                return;
            }
            ++i;
        }
    }

    private static void setSQLTableListener() {
        Configuration.getInstance().getBase().getTable("VARIABLE_PAYE").addTableListener(new SQLTableListener(){

            @Override
            public void rowModified(SQLTable table, int id) {
                System.err.println("refresh line");
                VariableTree.modifyNode(table.getRow(id), nodeVariablesPaye);
                Iterator i = mapCategorie.keySet().iterator();
                while (i.hasNext()) {
                    Object o = mapCategorie.get(i.next());
                    if (!(o instanceof DefaultMutableTreeNode)) continue;
                    VariableTree.modifyNode(table.getRow(id), (DefaultMutableTreeNode)o);
                }
            }

            @Override
            public void rowAdded(SQLTable table, int id) {
                System.err.println("Variable tree node row added ");
                if (nodeVariablesPaye != null) {
                    SQLRow rowTmp = table.getRow(id);
                    String cat = rowTmp.getString("CATEGORIE").trim();
                    if (cat.length() == 0) {
                        VariableTree.addNode(table.getRow(id), nodeVariablesPaye);
                    } else if (mapCategorie.get(cat.toLowerCase()) != null) {
                        DefaultMutableTreeNode nodeCat = (DefaultMutableTreeNode)mapCategorie.get(cat.toLowerCase());
                        VariableTree.addNode(table.getRow(id), nodeCat);
                    } else {
                        DefaultMutableTreeNode nodeCat = new DefaultMutableTreeNode(cat.toLowerCase());
                        VariableTree.addNode(table.getRow(id), nodeCat);
                        mapCategorie.put(cat.toLowerCase(), nodeCat);
                    }
                }
            }

            @Override
            public void rowDeleted(SQLTable table, int id) {
                System.err.println("remove line");
                VariableTree.removeNode(table.getRow(id), nodeVariablesPaye);
                Iterator i = mapCategorie.keySet().iterator();
                while (i.hasNext()) {
                    Object o = mapCategorie.get(i.next());
                    if (!(o instanceof DefaultMutableTreeNode)) continue;
                    VariableTree.removeNode(table.getRow(id), (DefaultMutableTreeNode)o);
                }
            }
        });
    }
}

