/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.finance.accounting.ui.ListPanelEcritures;
import org.openconcerto.erp.core.finance.accounting.ui.ListeDesEcrituresPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.State;
import org.openconcerto.ui.state.WindowStateManager;

public class ConsultationCompteFrame
extends JFrame {
    private final ListPanelEcritures panelEcritures;
    private final ListeDesEcrituresPanel panel;
    private String titre;

    public ConsultationCompteFrame(ListeDesEcrituresPanel panel, String titre) {
        this.panel = panel;
        this.panelEcritures = panel.getListPanelEcritures();
        this.titre = titre;
        this.panelEcritures.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ConsultationCompteFrame.this.setTitle();
            }
        });
        this.uiInit();
        State.INSTANCE.frameCreated();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                State.INSTANCE.frameHidden();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                State.INSTANCE.frameShown();
            }
        });
    }

    private String getPlural(String s, int nb) {
        return String.valueOf(nb) + " " + s + (nb > 1 ? "s" : "");
    }

    private void setTitle(boolean displayRowCount, boolean displayItemCount) {
        int count;
        String title = this.titre;
        if (displayRowCount) {
            int rowCount = this.panelEcritures.getListe().getRowCount();
            title = String.valueOf(title) + ", " + this.getPlural("ligne", rowCount);
            int total = this.panelEcritures.getListe().getTotalRowCount();
            if (total != rowCount) {
                title = String.valueOf(title) + " / " + total;
            }
        }
        if (displayItemCount && (count = this.panelEcritures.getListe().getItemCount()) >= 0) {
            title = String.valueOf(title) + ", " + this.getPlural("\u00e9l\u00e9ment", count);
        }
        this.setTitle(title);
    }

    public void setTitle() {
        this.setTitle(true, true);
    }

    private final void uiInit() {
        this.setTitle();
        this.getContentPane().setLayout(new GridLayout());
        this.getContentPane().add(this.panel);
        this.setBounds();
        File configFile = new File(Configuration.getInstance().getConfDir(), String.valueOf(this.panelEcritures.getElement().getPluralName()) + "-window.xml");
        new WindowStateManager(this, configFile).loadState();
    }

    protected final void setBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode dm = ge.getDefaultScreenDevice().getDisplayMode();
        int topOffset = 50;
        if (dm.getWidth() <= 800 || dm.getHeight() <= 600) {
            this.setLocation(0, 50);
            this.setSize(dm.getWidth(), dm.getHeight() - 50);
        } else {
            this.setLocation(10, 50);
            this.setSize(dm.getWidth() - 50, dm.getHeight() - 20 - 50);
        }
    }

    public final ListPanelEcritures getPanel() {
        return this.panelEcritures;
    }
}

