/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht;

import java.util.Collection;
import org.jgrapht.Graph;

public abstract class Graphs {
    public static <V, E> boolean addGraph(Graph<? super V, ? super E> destination, Graph<V, E> source) {
        boolean modified = Graphs.addAllVertices(destination, (Collection)source.vertexSet());
        return modified |= Graphs.addAllEdges(destination, source, (Collection)source.edgeSet());
    }

    public static <V, E> boolean addAllEdges(Graph<? super V, ? super E> destination, Graph<V, E> source, Collection<? extends E> edges) {
        boolean modified = false;
        for (E e : edges) {
            V s = source.getEdgeSource(e);
            V t = source.getEdgeTarget(e);
            destination.addVertex(s);
            destination.addVertex(t);
            modified |= destination.addEdge(s, t, e);
        }
        return modified;
    }

    public static <V, E> boolean addAllVertices(Graph<? super V, ? super E> destination, Collection<? extends V> vertices) {
        boolean modified = false;
        for (V v : vertices) {
            modified |= destination.addVertex(v);
        }
        return modified;
    }

    public static <V, E> V getOppositeVertex(Graph<V, E> g, E e, V v) {
        V source = g.getEdgeSource(e);
        V target = g.getEdgeTarget(e);
        if (v.equals(source)) {
            return target;
        }
        if (v.equals(target)) {
            return source;
        }
        throw new IllegalArgumentException("no such vertex");
    }
}

