/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jpos.config.JposRegPopulator;
import jpos.loader.JposServiceLoader;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public abstract class AbstractRegPopulator
implements JposRegPopulator {
    private Hashtable jposEntries = new Hashtable();
    private InputStream populatorIS = null;
    private OutputStream populatorOS = null;
    private String populatorFileName = "";
    private String populatorFileURL = "";
    private String uniqueId = "";
    protected Exception lastLoadException = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("AbstractRegPopulator");

    public AbstractRegPopulator(String string) {
        this.setUniqueId(string);
    }

    public abstract String getName();

    public String getUniqueId() {
        return this.uniqueId.equals("") ? this.getClassName() : this.uniqueId;
    }

    public Enumeration getEntries() {
        Vector vector = new Vector();
        Enumeration enumeration = this.jposEntries.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public String toString() {
        return this.getName();
    }

    public Exception getLastLoadException() {
        return this.lastLoadException;
    }

    protected Hashtable getJposEntries() {
        return this.jposEntries;
    }

    protected boolean isPopulatorFileDefined() {
        boolean bl = false;
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            bl = true;
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            bl = true;
        }
        return bl;
    }

    protected InputStream getPopulatorFileIS() throws Exception {
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.populatorFile")) {
            this.populatorFileName = jposProperties.getPropertyString("jpos.config.populatorFile");
            this.tracer.println("getPopulatorFileIS(): populatorFileName=" + this.populatorFileName);
            this.populatorIS = new FileInputStream(this.populatorFileName);
        } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
            this.populatorFileURL = jposProperties.getPropertyString("jpos.config.populatorFileURL");
            URL uRL = new URL(this.populatorFileURL);
            this.populatorIS = uRL.openStream();
            this.tracer.println("getPopulatorFileIS(): populatorFileURL=" + this.populatorFileURL);
        } else {
            String string = "jpos.config.populatorFile OR  jpos.config.populatorFileURL properties not defined";
            this.tracer.println(string);
            throw new Exception(string);
        }
        return this.populatorIS;
    }

    protected void setUniqueId(String string) {
        this.uniqueId = string;
    }

    public abstract String getClassName();
}

