/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.Vector;

public class PGtokenizer {
    protected Vector tokens;

    public PGtokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public int tokenize(String string, char delim) {
        this.tokens = new Vector();
        int nest = 0;
        int s = 0;
        for (int p = 0; p < string.length(); ++p) {
            char c = string.charAt(p);
            if (c == '(' || c == '[' || c == '<') {
                ++nest;
            }
            if (c == ')' || c == ']' || c == '>') {
                --nest;
            }
            if (nest != 0 || c != delim) continue;
            this.tokens.addElement(string.substring(s, p));
            s = p + 1;
        }
        if (s < string.length()) {
            this.tokens.addElement(string.substring(s));
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n) {
        return (String)this.tokens.elementAt(n);
    }

    public static String remove(String s, String l, String t) {
        if (s.startsWith(l)) {
            s = s.substring(l.length());
        }
        if (s.endsWith(t)) {
            s = s.substring(0, s.length() - t.length());
        }
        return s;
    }

    public static String removePara(String s) {
        return PGtokenizer.remove(s, "(", ")");
    }

    public static String removeBox(String s) {
        return PGtokenizer.remove(s, "[", "]");
    }

    public static String removeAngle(String s) {
        return PGtokenizer.remove(s, "<", ">");
    }
}

