/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openconcerto.utils.cc.ITransformer;

public final class Matrix<T> {
    private final List<List<T>> rows;
    private final T defaultItem;

    public Matrix() {
        this(8);
    }

    public Matrix(int initialHeight) {
        this(initialHeight, null);
    }

    public Matrix(int initialCapacity, T defaultItem) {
        this.rows = new ArrayList<List<T>>(initialCapacity);
        this.defaultItem = defaultItem;
    }

    private final List<List<T>> createEmptyRows(int count) {
        ArrayList<List<T>> res = new ArrayList<List<T>>(count);
        int i = 0;
        while (i < count) {
            res.add(new ArrayList());
            ++i;
        }
        return res;
    }

    public final void put(int x, int y, T item) {
        List<T> row;
        if (this.rows.size() <= y) {
            this.rows.addAll(this.createEmptyRows(y - this.rows.size() + 1));
        }
        if ((row = this.rows.get(y)).size() <= x) {
            row.addAll(Collections.nCopies(x - row.size() + 1, this.defaultItem));
        }
        row.set(x, item);
    }

    public final String print(int cellLength, ITransformer<T, ?> transf) {
        String spaces;
        if (cellLength < 0) {
            spaces = null;
        } else {
            char[] array = new char[cellLength];
            Arrays.fill(array, ' ');
            spaces = new String(array);
        }
        StringBuilder sb = new StringBuilder();
        for (List<T> row : this.rows) {
            for (T item : row) {
                String s;
                String string = item == null ? "" : (s = (transf == null ? item : transf.transformChecked(item)).toString());
                if (spaces == null) {
                    sb.append(s);
                    sb.append('\t');
                    continue;
                }
                if (s.length() < cellLength) {
                    sb.append(s);
                    sb.append(spaces.substring(s.length()));
                } else if (s.length() == cellLength) {
                    sb.append(s.substring(0, cellLength));
                } else {
                    int middle = cellLength / 2;
                    sb.append(s.substring(0, middle));
                    sb.append('\u2026');
                    sb.append(s.substring(s.length() - (cellLength - middle - 1), s.length()));
                }
                sb.append(' ');
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Matrix) {
            return this.rows.equals(((Matrix)obj).rows);
        }
        return false;
    }

    public int hashCode() {
        return this.rows.hashCode();
    }

    public String toString() {
        return this.print(20, null);
    }
}

