/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.utils.cache.CacheWatcher;

public class SQLCacheWatcher<K>
extends CacheWatcher<K, SQLData> {
    private final SQLTableModifiedListener listener;

    SQLCacheWatcher(SQLCache<K, ?> c, SQLData t) {
        super(c, t);
        this.listener = t.createTableListener(new SQLDataListener(){

            @Override
            public void dataChanged() {
                SQLCacheWatcher.this.clearCache();
            }
        });
        this.getTable().addPremierTableModifiedListener(this.listener);
    }

    private final SQLTable getTable() {
        return ((SQLData)this.getData()).getTable();
    }

    @Override
    protected void dying() {
        this.getTable().removeTableModifiedListener(this.listener);
    }
}

