/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;

public class Path {
    private final DBRoot base;
    private final List<SQLTable> tables;
    private final List<Step> fields;
    private final List<SQLField> singleFields;

    public Path(SQLTable start) {
        this.tables = new ArrayList<SQLTable>();
        this.fields = new ArrayList<Step>();
        this.singleFields = new ArrayList<SQLField>();
        this.base = start.getDBRoot();
        this.tables.add(start);
    }

    public Path(Path p) {
        this.tables = new ArrayList<SQLTable>(p.tables);
        this.fields = new ArrayList<Step>(p.fields);
        this.singleFields = new ArrayList<SQLField>(p.singleFields);
        this.base = p.base;
    }

    public final Path reverse() {
        Path res = new Path(this.getLast());
        int i = this.fields.size() - 1;
        while (i >= 0) {
            res.add(this.fields.get(i).reverse());
            --i;
        }
        return res;
    }

    public int length() {
        return this.fields.size();
    }

    public SQLTable getFirst() {
        return this.getTable(0);
    }

    public SQLTable getLast() {
        return this.getTable(this.tables.size() - 1);
    }

    public SQLTable getTable(int i) {
        return this.tables.get(i);
    }

    public Path minusFirst() {
        return this.subPath(1, this.length());
    }

    public Path subPath(int fromIndex, int toIndex) {
        fromIndex = CollectionUtils.getValidIndex(this.fields, fromIndex);
        toIndex = CollectionUtils.getValidIndex(this.fields, toIndex);
        Path p = new Path(this.getTable(fromIndex));
        p.tables.addAll(this.tables.subList(fromIndex + 1, toIndex + 1));
        p.fields.addAll(this.fields.subList(fromIndex, toIndex));
        p.singleFields.addAll(this.singleFields.subList(fromIndex, toIndex));
        return p;
    }

    public final Path append(Path p) {
        if (this.getLast() != p.getFirst()) {
            throw new IllegalArgumentException("this ends at " + this.getLast() + " while the other begins at " + p.getFirst());
        }
        this.fields.addAll(p.fields);
        this.singleFields.addAll(p.singleFields);
        this.tables.addAll(p.tables.subList(1, p.tables.size()));
        return this;
    }

    private Path add(Step step) {
        assert (step.getFrom() == this.getLast()) : "broken path";
        this.fields.add(step);
        this.singleFields.add(step.getSingleField());
        this.tables.add(step.getTo());
        return this;
    }

    public final Path add(SQLField fField, Boolean direction) {
        return this.add(Step.create(this.getLast(), fField, direction));
    }

    public final Step getStep(int i) {
        return this.fields.get(CollectionUtils.getValidIndex(this.fields, i, true));
    }

    public final Set<SQLField> getStepFields(int i) {
        return this.getStep(i).getFields();
    }

    public SQLField getSingleStep(int i) {
        return this.singleFields.get(i);
    }

    public boolean isSingleLink() {
        for (SQLField step : this.singleFields) {
            if (step != null) continue;
            return false;
        }
        return true;
    }

    public final Boolean isBackwards(int i) {
        Boolean foreign = this.getStep(i).isForeign();
        return foreign == null ? null : Boolean.valueOf(foreign == false);
    }

    public final Boolean isSingleDirection(boolean foreign) {
        return this.isSingleDirection((Boolean)foreign);
    }

    private final Boolean isSingleDirection(Boolean foreign) {
        Boolean dir = foreign;
        for (Step s : this.fields) {
            Boolean stepIsForeign = s.isForeign();
            if (stepIsForeign == null) {
                return null;
            }
            if (dir == null) {
                dir = stepIsForeign;
                continue;
            }
            if (dir.equals(stepIsForeign)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Path\n\tTables: " + this.tables + "\n\tLinks:" + this.fields;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path o = (Path)obj;
            return this.base.equals(o.base) && this.getFirst().equals(o.getFirst()) && this.fields.equals(o.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }
}

