/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.State;
import org.openconcerto.sql.model.ColumnListHandler;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.HandlersStack;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLResultSet;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.cache.CacheResult;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;

public final class SQLDataSource
extends BasicDataSource
implements Cloneable {
    public static final Map<SQLSystem, String> DRIVERS = new HashMap<SQLSystem, String>();
    public static final IgnoringRowProcessor ROW_PROC;
    public static final ColumnListHandler COLUMN_LIST_HANDLER;
    public static final ArrayListHandler ARRAY_LIST_HANDLER;
    public static final ArrayHandler ARRAY_HANDLER;
    public static final ScalarHandler SCALAR_HANDLER;
    public static final MapListHandler MAP_LIST_HANDLER;
    public static final MapHandler MAP_HANDLER;
    private SQLCache<List<?>, Object> cache;
    private boolean cacheEnabled;
    private Set<SQLTable> tables;
    private static int count;
    private final SQLServer server;
    private final Map<Thread, HandlersStack> handlers;
    private ExecutorService exec = null;
    private final Object setInitialShemaLock = new String("initialShemaWriteLock");
    private boolean initialShemaSet;
    private String initialShema;
    private final Map<Connection, Object> uptodate;
    private volatile int retryWait;
    private boolean blockWhenExhausted;
    private final ReentrantLock testLock = new ReentrantLock();
    private static int executorSerial;
    private static final String pgInterrupted;

    static {
        DRIVERS.put(SQLSystem.MYSQL, "com.mysql.jdbc.Driver");
        DRIVERS.put(SQLSystem.POSTGRESQL, "org.postgresql.Driver");
        DRIVERS.put(SQLSystem.DERBY, "org.apache.derby.jdbc.ClientDriver");
        DRIVERS.put(SQLSystem.H2, "org.h2.Driver");
        DRIVERS.put(SQLSystem.MSSQL, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        System.setProperty("h2.databaseToUpper", "false");
        ROW_PROC = new IgnoringCSRowProcessor();
        COLUMN_LIST_HANDLER = new ColumnListHandler();
        ARRAY_LIST_HANDLER = new ArrayListHandler();
        ARRAY_HANDLER = new ArrayHandler();
        SCALAR_HANDLER = new ScalarHandler();
        MAP_LIST_HANDLER = new MapListHandler(ROW_PROC);
        MAP_HANDLER = new MapHandler(ROW_PROC);
        count = 0;
        executorSerial = 0;
        pgInterrupted = GT.tr("Interrupted while attempting to connect.");
    }

    public SQLDataSource(SQLServer server, String base, String login, String pass) {
        this(server, server.getURL(base), login, pass, Collections.emptySet());
    }

    private SQLDataSource(SQLServer server, String url, String login, String pass, Set<SQLTable> tables) {
        this(server);
        SQLSystem system = server.getSQLSystem();
        if (!DRIVERS.containsKey((Object)system)) {
            throw new IllegalArgumentException("unknown database system: " + (Object)((Object)system));
        }
        this.setDriverClassName(DRIVERS.get((Object)system));
        this.setUrl("jdbc:" + system.getJDBCName() + ":" + url);
        this.setUsername(login);
        this.setPassword(pass);
        this.setTables(tables);
        if (this.server.getSQLSystem() == SQLSystem.MYSQL) {
            this.addConnectionProperty("transformedBitIsBoolean", "true");
        } else if (this.server.getSQLSystem() == SQLSystem.H2) {
            this.addConnectionProperty("CACHE_SIZE", "32000");
        }
        this.setLoginTimeout(15);
        this.setSocketTimeout(480);
        this.setRetryWait(3);
    }

    @Override
    public final void setLoginTimeout(int timeout) {
        if (this.server.getSQLSystem() == SQLSystem.MYSQL) {
            this.addConnectionProperty("connectTimeout", String.valueOf(timeout) + "000");
        } else if (this.server.getSQLSystem() == SQLSystem.POSTGRESQL) {
            this.addConnectionProperty("loginTimeout", String.valueOf(timeout));
        }
    }

    public final void setSocketTimeout(int timeout) {
        if (this.server.getSQLSystem() == SQLSystem.MYSQL) {
            this.addConnectionProperty("socketTimeout", String.valueOf(timeout) + "000");
        } else if (this.server.getSQLSystem() == SQLSystem.H2) {
            this.addConnectionProperty("QUERY_TIMEOUT", String.valueOf(timeout) + "000");
        } else if (this.server.getSQLSystem() == SQLSystem.POSTGRESQL) {
            this.addConnectionProperty("socketTimeout", String.valueOf(timeout));
        }
    }

    public final void setRetryWait(int retryWait) {
        this.retryWait = retryWait;
    }

    synchronized void setTables(Set<SQLTable> tables) {
        boolean update = this.cache == null || !tables.containsAll(this.tables);
        this.tables = Collections.unmodifiableSet(new HashSet<SQLTable>(tables));
        if (update) {
            this.updateCache();
        }
    }

    private synchronized void updateCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.cache = this.cacheEnabled && this.tables.size() > 0 ? new SQLCache(30, 30, "results of " + this.getClass().getSimpleName()) : null;
    }

    public final synchronized void setCacheEnabled(boolean b) {
        if (this.cacheEnabled != b) {
            this.cacheEnabled = b;
            this.updateCache();
        }
    }

    private SQLDataSource(SQLServer server) {
        this.server = server;
        this.handlers = new Hashtable<Thread, HandlersStack>();
        this.uptodate = new WeakHashMap<Connection, Object>();
        this.initialShemaSet = false;
        this.initialShema = null;
        this.setValidationQuery("SELECT 1");
        this.setTestOnBorrow(false);
        this.setInitialSize(3);
        this.setMaxActive(48);
        this.setMinIdle(2);
        this.setMaxIdle(16);
        this.setBlockWhenExhausted(false);
        this.tables = Collections.emptySet();
        this.cache = null;
        this.cacheEnabled = false;
    }

    public List execute(String query) {
        return (List)this.execute(query, MAP_LIST_HANDLER);
    }

    public List executeCol(String query) {
        return (List)this.execute(query, COLUMN_LIST_HANDLER);
    }

    public Map execute1(String query) {
        return (Map)this.execute(query, MAP_HANDLER);
    }

    public Object executeScalar(String query) {
        return this.execute(query, SCALAR_HANDLER);
    }

    public Object execute(String query, ResultSetHandler rsh) {
        return this.execute(query, rsh, null);
    }

    public final Object execute(String query, ResultSetHandler rsh, boolean changeState) throws RTInterruptedException {
        return this.execute(query, rsh, changeState, null);
    }

    private Object execute(String query, ResultSetHandler rsh, Connection c) throws RTInterruptedException {
        return this.execute(query, rsh, false, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(String query, ResultSetHandler rsh, boolean changeState, Connection passedConn) throws RTInterruptedException {
        long afterHandle;
        long afterExecute;
        long afterQueryInfo;
        List<Object> key;
        SQLCache<List<?>, Object> cache;
        long timeMs = System.currentTimeMillis();
        long time = System.nanoTime();
        if (query.length() == 0) {
            SQLRequestLog.log(query, "Pas de requ\u00eate.", timeMs, time);
            return null;
        }
        IResultSetHandler irsh = rsh instanceof IResultSetHandler ? (IResultSetHandler)rsh : null;
        SQLDataSource sQLDataSource = this;
        synchronized (sQLDataSource) {
            cache = this.cache;
        }
        List<Object> list = key = cache != null && query.startsWith("SELECT") ? Arrays.asList(query, rsh) : null;
        if (key != null && (irsh == null || irsh.readCache())) {
            CacheResult l = cache.check(key);
            if (l.getState() == CacheResult.State.INTERRUPTED) {
                throw new RTInterruptedException("interrupted while waiting for the cache");
            }
            if (l.getState() == CacheResult.State.VALID) {
                State.INSTANCE.addCacheHit();
                SQLRequestLog.log(query, "En cache.", timeMs, time);
                return l.getRes();
            }
        }
        Object result = null;
        QueryInfo info = null;
        long afterCache = System.nanoTime();
        try {
            info = new QueryInfo(query, changeState, passedConn);
            try {
                afterQueryInfo = System.nanoTime();
                Object[] res = this.executeTwice(info);
                Statement stmt = (Statement)res[0];
                ResultSet rs = (ResultSet)res[1];
                afterExecute = System.nanoTime();
                if (rsh != null && rs != null) {
                    if (this.getSystem() == SQLSystem.DERBY || this.getSystem() == SQLSystem.POSTGRESQL) {
                        rs = new SQLResultSet(rs);
                    }
                    result = rsh.handle(rs);
                }
                afterHandle = System.nanoTime();
                stmt.close();
                if (key != null) {
                    SQLDataSource sQLDataSource2 = this;
                    synchronized (sQLDataSource2) {
                        this.putInCache(cache, irsh, key, result, true);
                        if (this.cache != cache) {
                            this.putInCache(this.cache, irsh, key, result, false);
                        }
                    }
                }
                info.releaseConnection();
            }
            catch (SQLException exn) {
                throw new IllegalStateException("Impossible d'acc\u00e9der au r\u00e9sultat de " + query + "\n in " + this, exn);
            }
        }
        catch (RuntimeException e) {
            if (cache != null && key != null) {
                cache.removeRunning(key);
            }
            if (info != null) {
                info.releaseConnection(e);
            }
            throw e;
        }
        SQLRequestLog.log(query, "", info, timeMs, time, afterCache, afterQueryInfo, afterExecute, afterHandle, System.nanoTime());
        return result;
    }

    private synchronized void putInCache(SQLCache<List<?>, Object> cache, IResultSetHandler irsh, List<Object> key, Object result, boolean removeRunning) {
        if (irsh != null && irsh.writeCache()) {
            cache.put(key, result, irsh.getCacheModifiers() == null ? this.tables : irsh.getCacheModifiers());
        } else if (irsh == null && IResultSetHandler.shouldCache(result)) {
            cache.put(key, result, this.tables);
        } else if (removeRunning) {
            cache.removeRunning(key);
        }
    }

    private final synchronized ExecutorService getExec() {
        if (this.exec == null) {
            ThreadFactory factory = new ThreadFactory(String.valueOf(SQLDataSource.class.getSimpleName()) + " " + this.toString() + " exec n\u00b0 ", false);
            this.exec = new ThreadPoolExecutor(0, 32, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        }
        return this.exec;
    }

    private final boolean handlingConnection() {
        return this.handlers.containsKey(Thread.currentThread());
    }

    private final HandlersStack getHandlersStack() {
        return this.handlers.get(Thread.currentThread());
    }

    public final <T, X extends Exception> T useConnection(ConnectionHandler<T, X> handler) throws SQLException, X {
        boolean pristineState;
        HandlersStack h;
        if (!this.handlingConnection()) {
            h = new HandlersStack(this.getNewConnection(), handler);
            this.handlers.put(Thread.currentThread(), h);
        } else if (handler.canRestoreState()) {
            h = this.getHandlersStack().push(handler);
        } else {
            throw new IllegalStateException("this thread has already called useConnection() and thus expect its state, but the passed handler cannot restore state: " + handler);
        }
        Connection conn = null;
        Exception exn = null;
        try {
            conn = h.getConnection();
            h.setChangeAllowed(true);
            handler.setup(conn);
            h.setChangeAllowed(false);
            handler.compute(this);
        }
        catch (Exception e) {
            h.setChangeAllowed(false);
            exn = e;
        }
        boolean bl = pristineState = conn == null;
        if (!pristineState && handler.canRestoreState()) {
            h.setChangeAllowed(true);
            try {
                handler.restoreState(conn);
                pristineState = true;
            }
            catch (Exception e) {
                exn = exn == null ? e : new SQLException("could not restore state: " + ExceptionUtils.getStackTrace(e), exn);
            }
            h.setChangeAllowed(false);
        }
        if (h.pop()) {
            this.handlers.remove(Thread.currentThread());
            if (pristineState) {
                this.returnConnection(conn);
            } else {
                this.closeConnection(conn);
            }
        } else if (!pristineState) {
            h.invalidConnection();
            this.closeConnection(conn);
        }
        if (exn != null) {
            if (exn instanceof RuntimeException) {
                throw (RuntimeException)exn;
            }
            throw (SQLException)exn;
        }
        return handler.get();
    }

    private Object[] executeTwice(QueryInfo queryInfo) throws SQLException {
        Object[] res;
        String query = queryInfo.getQuery();
        try {
            res = this.executeOnce(query, queryInfo.getConnection());
        }
        catch (SQLException exn) {
            Log.get().log(Level.INFO, "executeOnce() failed for " + queryInfo, exn);
            State.INSTANCE.addFailedRequest(query);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(String.valueOf(e.getMessage()) + " : " + query, exn);
            }
            try {
                Connection otherConn = queryInfo.obtainNewConnection();
                if (otherConn == null) {
                    throw exn;
                }
                res = this.executeOnce(query, otherConn);
            }
            catch (Exception e) {
                if (e == exn) {
                    throw exn;
                }
                throw new SQLException("second exec failed: " + e.getLocalizedMessage(), exn);
            }
        }
        return res;
    }

    private Object[] executeOnce(String query, Connection c) throws SQLException {
        Statement stmt = c.createStatement();
        ResultSet rs = this.execute(query, stmt);
        return new Object[]{stmt, rs};
    }

    private ResultSet execute(String query, Statement stmt) throws SQLException, RTInterruptedException {
        ResultSet rs;
        long t1;
        block8: {
            State.INSTANCE.beginRequest(query);
            if (Thread.currentThread().isInterrupted()) {
                throw new RTInterruptedException("request interrupted : " + query);
            }
            t1 = System.currentTimeMillis();
            rs = null;
            try {
                if (query.startsWith("INSERT") || query.startsWith("UPDATE") || query.startsWith("DELETE") || query.startsWith("ALTER") || query.startsWith("DROP") || query.startsWith("SET")) {
                    boolean returnGenK = (query.startsWith("INSERT") || query.startsWith("UPDATE")) && stmt.getConnection().getMetaData().supportsGetGeneratedKeys();
                    stmt.executeUpdate(query, returnGenK ? 1 : 2);
                    rs = returnGenK ? stmt.getGeneratedKeys() : null;
                    break block8;
                }
                ExecutorThread thr = new ExecutorThread(stmt, query);
                thr.start();
                try {
                    rs = thr.getRs();
                }
                catch (InterruptedException e) {
                    thr.stopQuery();
                    throw new InterruptedQuery("request interrupted : " + query, e, thr);
                }
            }
            finally {
                State.INSTANCE.endRequest(query);
            }
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 1000L && query.length() < 1000) {
            System.err.println("Warning:" + (t2 - t1) + "ms pour :" + query);
        }
        ++count;
        return rs;
    }

    @Override
    public synchronized void close() throws SQLException {
        GenericObjectPool pool = this.connectionPool;
        super.close();
        this.connectionPool = pool;
        if (this.exec != null) {
            this.exec.shutdownNow();
            this.exec = null;
        }
        if (this.getBorrowedConnectionCount() == 0) {
            this.noConnectionIsOpen();
        }
    }

    private synchronized void noConnectionIsOpen() {
        assert (this.connectionPool.getNumIdle() + this.connectionPool.getNumActive() == 0);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public final synchronized boolean isClosed() {
        return this.dataSource == null;
    }

    @Override
    public final Connection getConnection() {
        HandlersStack res = this.handlers.get(Thread.currentThread());
        if (res == null) {
            throw new IllegalStateException("useConnection() wasn't called");
        }
        return res.getConnection();
    }

    public final Connection getNewConnection() {
        try {
            return this.borrowConnection(false);
        }
        catch (RTInterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            return this.borrowConnection(true);
        }
    }

    private final Connection borrowConnection(boolean test) {
        if (test) {
            this.testLock.lock();
            this.setTestOnBorrow(true);
        }
        try {
            Connection res = this.getRawConnection();
            try {
                this.initConnection(res);
                Connection connection = res;
                return connection;
            }
            catch (RuntimeException e) {
                this.closeConnection(res);
                throw e;
            }
        }
        finally {
            if (test) {
                this.setTestOnBorrow(false);
                this.testLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initConnection(Connection res) {
        boolean setSchema = false;
        String schemaToSet = null;
        SQLDataSource sQLDataSource = this;
        synchronized (sQLDataSource) {
            if (!this.uptodate.containsKey(res)) {
                if (this.initialShemaSet) {
                    setSchema = true;
                    schemaToSet = this.initialShema;
                }
                this.uptodate.put(res, null);
            }
        }
        if (setSchema) {
            this.setSchema(schemaToSet, res);
        }
    }

    private Connection getRawConnection() {
        assert (!Thread.holdsLock(this)) : "super.getConnection() might block (see setWhenExhaustedAction()), and since return/closeConnection() need this lock, this method cannot wait while holding the lock";
        Connection result = null;
        try {
            result = super.getConnection();
        }
        catch (SQLException e1) {
            if (e1.getCause() instanceof InterruptedException || e1 instanceof PSQLException && e1.getMessage().equals(pgInterrupted)) {
                throw new RTInterruptedException(e1);
            }
            int retryWait = this.retryWait;
            if (retryWait == 0) {
                throw new IllegalStateException("Impossible d'obtenir une connexion sur " + this, e1);
            }
            try {
                Thread.sleep(retryWait * 1000);
                result = super.getConnection();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException("interrupted while waiting for a second try", e);
            }
            catch (Exception e) {
                throw new IllegalStateException("Impossible d'obtenir une connexion sur " + this + ": " + e.getLocalizedMessage(), e1);
            }
        }
        State.INSTANCE.connectionCreated();
        return result;
    }

    public final int getBorrowedConnectionCount() {
        return this.connectionPool.getNumActive();
    }

    public synchronized void setBlockWhenExhausted(boolean block) {
        this.blockWhenExhausted = block;
        if (this.connectionPool != null) {
            this.connectionPool.setWhenExhaustedAction(block ? (byte)1 : 2);
        }
    }

    @Override
    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.isClosed()) {
            super.createDataSource();
            this.connectionPool.setLifo(true);
            this.setBlockWhenExhausted(this.blockWhenExhausted);
            this.connectionPool.setTimeBetweenEvictionRunsMillis(4000L);
            this.connectionPool.setNumTestsPerEvictionRun(5);
            this.connectionPool.setSoftMinEvictableIdleTimeMillis(40000L);
            this.dataSource = new PoolingDataSource(this.connectionPool){

                @Override
                public Connection getConnection() throws SQLException {
                    try {
                        return (Connection)this._pool.borrowObject();
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLNestedException("Cannot get a connection, pool exhausted", e);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new SQLNestedException("Cannot get a connection, general error", e);
                    }
                }

                @Override
                public Connection getConnection(String username, String password) throws SQLException {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(Connection con) {
        if (con != null) {
            boolean unrecoverableOutOfDate;
            SQLDataSource sQLDataSource = this;
            synchronized (sQLDataSource) {
                unrecoverableOutOfDate = !this.initialShemaSet && !this.uptodate.containsKey(con);
            }
            if (this.isClosed() || unrecoverableOutOfDate) {
                this.closeConnection(con);
            } else {
                try {
                    con.close();
                }
                catch (Exception e) {
                    Log.get().log(Level.FINE, "Could not return " + con, e);
                }
                State.INSTANCE.connectionRemoved();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection con) {
        if (con != null) {
            SQLDataSource sQLDataSource = this;
            synchronized (sQLDataSource) {
                this.uptodate.remove(con);
            }
            try {
                this.connectionPool.invalidateObject(con);
            }
            catch (Exception e) {
                Log.get().log(Level.FINE, "Could not close " + con, e);
            }
            if (this.isClosed() && this.getBorrowedConnectionCount() == 0) {
                this.noConnectionIsOpen();
            }
        }
    }

    public void setInitialSchema(String schemaName) {
        if (schemaName != null || this.server.getSQLSystem().isClearingPathSupported()) {
            this.setInitialSchema(true, schemaName);
        } else if (this.server.getSQLSystem().isDBPathEmpty()) {
            this.unsetInitialSchema();
        } else {
            throw new IllegalArgumentException(this + " cannot have no default schema");
        }
    }

    public void unsetInitialSchema() {
        this.setInitialSchema(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setInitialSchema(boolean set, String schemaName) {
        Object object = this.setInitialShemaLock;
        synchronized (object) {
            Connection newConn;
            SQLDataSource sQLDataSource = this;
            synchronized (sQLDataSource) {
                if (this.initialShemaSet == set && CompareUtils.equals(this.initialShema, schemaName)) {
                    return;
                }
            }
            if (set) {
                newConn = this.getNewConnection();
                try {
                    this.setSchema(schemaName, newConn);
                }
                catch (RuntimeException e) {
                    this.closeConnection(newConn);
                    throw e;
                }
            } else {
                newConn = null;
            }
            SQLDataSource sQLDataSource2 = this;
            synchronized (sQLDataSource2) {
                this.initialShemaSet = set;
                this.initialShema = schemaName;
                this.uptodate.clear();
                if (!set) {
                    this.connectionPool.clear();
                } else {
                    this.uptodate.put(newConn, null);
                }
            }
            this.returnConnection(newConn);
        }
    }

    private void setSchema(String schemaName, Connection c) {
        String q;
        if (this.getSystem() == SQLSystem.MYSQL) {
            if (schemaName == null) {
                if (this.getSchema(c) != null) {
                    throw new IllegalArgumentException("cannot unset DATABASE in MySQL");
                }
                q = null;
            } else {
                q = "USE " + schemaName;
            }
        } else if (this.getSystem() == SQLSystem.DERBY) {
            q = "SET SCHEMA \"" + schemaName + '\"';
        } else if (this.getSystem() == SQLSystem.H2) {
            q = "SET SCHEMA " + SQLBase.quoteIdentifier(schemaName);
        } else if (this.getSystem() == SQLSystem.POSTGRESQL) {
            String schemasString = schemaName == null ? "''" : SQLSelect.quote(" '\"' || array_to_string( cast (%s as name) || current_schemas(false) , '\", \"')||  '\"'", schemaName);
            q = "select set_config('search_path', " + schemasString + " , false)";
        } else if (this.getSystem() == SQLSystem.MSSQL) {
            if (schemaName == null) {
                throw new IllegalArgumentException("cannot unset default schema in " + (Object)((Object)this.getSystem()));
            }
            q = "alter user " + this.getUsername() + " with default_schema = " + SQLBase.quoteIdentifier(schemaName);
        } else {
            throw new UnsupportedOperationException();
        }
        if (q != null) {
            this.execute(q, null, true, c);
        }
    }

    public final String getSchema() {
        return this.getSchema(null);
    }

    private String getSchema(Connection c) {
        String q;
        if (this.getSystem() == SQLSystem.MYSQL) {
            q = "select DATABASE(); ";
        } else if (this.getSystem() == SQLSystem.DERBY) {
            q = "select CURRENT SCHEMA;";
        } else if (this.getSystem() == SQLSystem.POSTGRESQL) {
            q = "select (current_schemas(false))[1];";
        } else if (this.getSystem() == SQLSystem.H2) {
            q = "select SCHEMA();";
        } else if (this.getSystem() == SQLSystem.MSSQL) {
            q = "select SCHEMA_NAME();";
        } else {
            throw new UnsupportedOperationException();
        }
        return (String)this.execute(q, (ResultSetHandler)SCALAR_HANDLER, c);
    }

    public String toString() {
        return this.getUrl();
    }

    private final SQLSystem getSystem() {
        return this.server.getSQLSystem();
    }

    public Object clone() {
        SQLDataSource ds = new SQLDataSource(this.server);
        ds.setUrl(this.getUrl());
        ds.setUsername(this.getUsername());
        ds.setPassword(this.getPassword());
        ds.setDriverClassName(this.getDriverClassName());
        return ds;
    }

    private final class ExecutorThread
    extends Thread {
        private final Statement stmt;
        private final String query;
        private ResultSet rs;
        private Exception exn;
        private boolean canceled;

        public ExecutorThread(Statement stmt, String query) {
            int n = executorSerial;
            executorSerial = n + 1;
            super(String.valueOf(n) + " ExecutorThread on " + query);
            this.stmt = stmt;
            this.query = query;
            this.canceled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutorThread executorThread = this;
            synchronized (executorThread) {
                if (this.canceled) {
                    return;
                }
            }
            ResultSet rs = null;
            try {
                this.stmt.execute(this.query);
                ExecutorThread executorThread2 = this;
                synchronized (executorThread2) {
                    if (this.canceled) {
                        return;
                    }
                }
                rs = this.stmt.getResultSet();
            }
            catch (Exception e) {
                this.exn = e;
            }
            this.rs = rs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopQuery() throws SQLException {
            this.stmt.cancel();
            ExecutorThread executorThread = this;
            synchronized (executorThread) {
                this.canceled = true;
            }
        }

        public ResultSet getRs() throws SQLException, InterruptedException {
            this.join();
            if (this.exn != null) {
                if (this.exn instanceof SQLException) {
                    throw (SQLException)this.exn;
                }
                throw (RuntimeException)this.exn;
            }
            return this.rs;
        }
    }

    private static class IgnoringCSRowProcessor
    extends BasicRowProcessor
    implements IgnoringRowProcessor {
        private IgnoringCSRowProcessor() {
        }

        @Override
        public Map<String, Object> toMap(ResultSet rs) throws SQLException {
            return this.toMap(rs, Collections.<String>emptySet());
        }

        @Override
        public Map<String, Object> toMap(ResultSet rs, Set<String> toIgnore) throws SQLException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            int i = 1;
            while (i <= cols) {
                String label = rsmd.getColumnLabel(i);
                if (!toIgnore.contains(label)) {
                    result.put(label, rs.getObject(i));
                }
                ++i;
            }
            return result;
        }
    }

    public static interface IgnoringRowProcessor
    extends RowProcessor {
        @Override
        public Map<String, Object> toMap(ResultSet var1) throws SQLException;

        public Map<String, Object> toMap(ResultSet var1, Set<String> var2) throws SQLException;
    }

    private final class InterruptedQuery
    extends RTInterruptedException {
        private final ExecutorThread thread;

        InterruptedQuery(String message, Throwable cause, ExecutorThread thr) {
            super(message, cause);
            this.thread = thr;
        }

        public final ExecutorThread getThread() {
            return this.thread;
        }
    }

    public final class QueryInfo {
        private final String query;
        private final boolean changeState;
        private Connection c;
        private final boolean privateConnection;

        QueryInfo(String query, boolean changeState, Connection passedConn) {
            Connection foundConn;
            this.query = query;
            this.changeState = changeState;
            boolean acquiredConnection = false;
            if (passedConn != null) {
                foundConn = passedConn;
            } else if (!SQLDataSource.this.handlingConnection()) {
                foundConn = SQLDataSource.this.getNewConnection();
                acquiredConnection = true;
            } else {
                HandlersStack threadHandlers = SQLDataSource.this.getHandlersStack();
                if (!changeState || threadHandlers.isChangeAllowed()) {
                    foundConn = threadHandlers.getConnection();
                } else {
                    throw new IllegalStateException("the passed query change the connection's state and the current thread has a connection which will thus be changed. A possible solution is to execute it in the setup() of a ConnectionHandler\n" + query);
                }
            }
            this.privateConnection = acquiredConnection;
            this.c = foundConn;
        }

        public final Connection getConnection() {
            return this.c;
        }

        public final String getQuery() {
            return this.query;
        }

        void releaseConnection(RuntimeException e) {
            if (e instanceof InterruptedQuery && SQLDataSource.this.getSystem() == SQLSystem.MYSQL) {
                final ExecutorThread thread = ((InterruptedQuery)e).getThread();
                if (this.privateConnection) {
                    if (this.changeState) {
                        this.releaseConnection();
                    } else {
                        SQLDataSource.this.getExec().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    thread.join(1500L);
                                    if (thread.isAlive()) {
                                        Log.get().warning(QueryInfo.this.getFailedCancelMsg());
                                        SQLDataSource.this.closeConnection(QueryInfo.this.getConnection());
                                    } else {
                                        SQLDataSource.this.returnConnection(QueryInfo.this.getConnection());
                                    }
                                }
                                catch (InterruptedException e) {
                                    Log.get().fine("Interrupted while joining " + QueryInfo.this.getQuery());
                                    SQLDataSource.this.closeConnection(QueryInfo.this.getConnection());
                                }
                            }
                        });
                    }
                } else {
                    try {
                        Thread.interrupted();
                        thread.join(500L);
                    }
                    catch (InterruptedException e2) {
                        System.err.println("ignore, we are already interrupted");
                        e2.printStackTrace();
                    }
                    Thread.currentThread().interrupt();
                    if (thread.isAlive()) {
                        throw new IllegalStateException(this.getFailedCancelMsg(), e);
                    }
                    this.releaseConnection();
                }
            } else {
                this.releaseConnection();
            }
        }

        void releaseConnection() {
            if (this.privateConnection) {
                if (this.changeState) {
                    SQLDataSource.this.closeConnection(this.getConnection());
                } else {
                    SQLDataSource.this.returnConnection(this.getConnection());
                }
            }
        }

        private final String getFailedCancelMsg() {
            return "cancel of " + System.identityHashCode(this.getConnection()) + " failed for " + this.getQuery();
        }

        public final Connection obtainNewConnection() {
            if (!this.privateConnection) {
                return null;
            }
            SQLDataSource.this.closeConnection(this.getConnection());
            this.c = SQLDataSource.this.borrowConnection(true);
            return this.getConnection();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " private connection: " + this.privateConnection + " query: " + this.getQuery();
        }
    }
}

