/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import org.openconcerto.utils.CompareUtils;

public class ModuleVersion
implements Comparable<ModuleVersion> {
    private final int major;
    private final int minor;
    private final long merged;

    public ModuleVersion(long merged) {
        if (merged >= 100000000L) {
            throw new IllegalArgumentException("Merged too big " + merged);
        }
        this.major = (int)(merged / 10000L);
        this.minor = (int)(merged % 10000L);
        this.merged = merged;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(ModuleVersion o) {
        return CompareUtils.compareLong(this.merged, o.merged);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.merged ^ this.merged >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.merged == ((ModuleVersion)obj).merged;
    }

    public String toString() {
        return "v" + this.getMajor() + "." + this.getMinor();
    }
}

