/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.combo.ISearchableComboItem;
import org.openconcerto.ui.component.combo.SearchMode;

public class ISearchableComboCompletionThread<T>
extends Thread {
    private final ISearchableCombo<T> combo;
    private final boolean showAll;
    private final String t;
    private boolean stopNow;

    public ISearchableComboCompletionThread(ISearchableCombo<T> combo, boolean showAll, String t) {
        this.combo = combo;
        this.showAll = showAll;
        this.t = t;
        this.stopNow = false;
    }

    private ISearchableCombo<T> getCombo() {
        return this.combo;
    }

    @Override
    public void run() {
        this.computeAutoCompletion();
    }

    public synchronized void stopNow() {
        this.stopNow = true;
    }

    private synchronized boolean isStopped() {
        return this.stopNow;
    }

    private void computeAutoCompletion() {
        final List<ISearchableComboItem<T>> l = !this.showAll ? this.getMatchingValues() : this.getMaxValues();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ISearchableComboCompletionThread.this.isStopped()) {
                    return;
                }
                ISearchableComboCompletionThread.this.getCombo().setMatchingCompletions(l, ISearchableComboCompletionThread.this.showAll);
            }
        });
    }

    private List<ISearchableComboItem<T>> getMaxValues() {
        List<ISearchableComboItem<T>> allVals = this.getCombo().getModelValues();
        return allVals.subList(0, Math.min(this.getCombo().getMaximumResult(), allVals.size()));
    }

    private List<ISearchableComboItem<T>> getMatchingValues() {
        ArrayList<ISearchableComboItem<T>> result = new ArrayList<ISearchableComboItem<T>>();
        String aText = this.t.trim().toLowerCase();
        int minimumSearch = this.getCombo().getMinimumSearch();
        if (aText.length() >= minimumSearch) {
            List<ISearchableComboItem<T>> cache = this.getCombo().getModelValues();
            SearchMode.ComboMatcher search = this.getCombo().getCompletionMode().matcher(aText);
            int maximumResult = this.getCombo().getMaximumResult();
            int index = 0;
            while (index < cache.size()) {
                ISearchableComboItem<T> itemO = cache.get(index);
                String item = itemO.asString();
                if (index % 50 == 0 && this.isStopped()) {
                    return result;
                }
                boolean ok = search.match(item.toLowerCase());
                boolean removeDuplicate = true;
                if (ok && removeDuplicate) {
                    int i = 0;
                    while (i < result.size()) {
                        if (this.isStopped()) {
                            return result;
                        }
                        ISearchableComboItem element = (ISearchableComboItem)result.get(i);
                        if (element.asString().equalsIgnoreCase(item)) {
                            ok = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (ok) {
                    result.add(itemO);
                }
                if (result.size() > maximumResult) break;
                ++index;
            }
        }
        return result;
    }

    static final List<String> cut(String value) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value);
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            v.add(element);
        }
        return v;
    }
}

