/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.Map;
import java.util.concurrent.Callable;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtTicketCaisse
extends GenerationEcritures {
    public static final Integer journal = 3;
    private final SQLRow rowTicket;
    private static final SQLTable ticketTable = base.getTable("TICKET_CAISSE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtTicketCaisse(SQLRow ticket) {
        System.err.println("********* init GeneRation");
        this.idMvt = 1;
        this.rowTicket = ticket;
    }

    public Callable<Integer> genereMouvement() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int idCompteClient;
                SQLRow clientRow = GenerationMvtTicketCaisse.this.rowTicket.getForeignRow("ID_CLIENT");
                PrixTTC prixTTC = new PrixTTC((Long)GenerationMvtTicketCaisse.this.rowTicket.getObject("TOTAL_TTC"));
                PrixHT prixTVA = new PrixHT((Long)GenerationMvtTicketCaisse.this.rowTicket.getObject("TOTAL_TVA"));
                PrixHT prixHT = new PrixHT((Long)GenerationMvtTicketCaisse.this.rowTicket.getObject("TOTAL_HT"));
                GenerationMvtTicketCaisse.this.date = GenerationMvtTicketCaisse.this.rowTicket.getDate("DATE").getTime();
                GenerationMvtTicketCaisse.this.nom = "Ticket " + GenerationMvtTicketCaisse.this.rowTicket.getString("NUMERO");
                GenerationMvtTicketCaisse.this.mEcritures.put("DATE", GenerationMvtTicketCaisse.this.date);
                GenerationMvtTicketCaisse.this.mEcritures.put("NOM", GenerationMvtTicketCaisse.this.nom);
                GenerationMvtTicketCaisse.this.mEcritures.put("ID_JOURNAL", GenerationMvtSaisieVenteFacture.journal);
                GenerationMvtTicketCaisse.this.mEcritures.put("ID_MOUVEMENT", 1);
                if (GenerationMvtTicketCaisse.this.idMvt == 1) {
                    GenerationMvtTicketCaisse.this.getNewMouvement("TICKET_CAISSE", GenerationMvtTicketCaisse.this.rowTicket.getID(), 1, GenerationMvtTicketCaisse.this.nom);
                } else {
                    GenerationMvtTicketCaisse.this.mEcritures.put("ID_MOUVEMENT", GenerationMvtTicketCaisse.this.idMvt);
                }
                long produitHT = prixHT.getLongValue();
                if (produitHT >= 0L && produitHT > 0L) {
                    int idCompteVenteProduit = 1;
                    if (idCompteVenteProduit <= 1 && (idCompteVenteProduit = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_PRODUIT")) <= 1) {
                        try {
                            idCompteVenteProduit = ComptePCESQLElement.getIdComptePceDefault("VentesProduits");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    GenerationMvtTicketCaisse.this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteProduit);
                    GenerationMvtTicketCaisse.this.mEcritures.put("DEBIT", 0L);
                    GenerationMvtTicketCaisse.this.mEcritures.put("CREDIT", produitHT);
                    GenerationMvtTicketCaisse.this.ajoutEcriture();
                }
                if (prixTVA.getLongValue() > 0L) {
                    int idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_VENTE");
                    if (idCompteTVA <= 1) {
                        try {
                            idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVACollectee");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Map<Integer, Long> m = GenerationMvtTicketCaisse.this.getMultiTVAFromRow(GenerationMvtTicketCaisse.this.rowTicket, GenerationMvtTicketCaisse.this.rowTicket.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT"), true, prixHT, 0L);
                    long allTaxe = 0L;
                    for (Integer i : m.keySet()) {
                        Long l = m.get(i);
                        if (l == null || l <= 0L) continue;
                        int idCpt = i;
                        if (idCpt <= 1) {
                            idCpt = idCompteTVA;
                        }
                        GenerationMvtTicketCaisse.this.mEcritures.put("ID_COMPTE_PCE", idCpt);
                        GenerationMvtTicketCaisse.this.mEcritures.put("DEBIT", 0L);
                        GenerationMvtTicketCaisse.this.mEcritures.put("CREDIT", Long.valueOf(l));
                        GenerationMvtTicketCaisse.this.ajoutEcriture();
                        allTaxe += l.longValue();
                    }
                    if (allTaxe < prixTVA.getLongValue()) {
                        GenerationMvtTicketCaisse.this.mEcritures.put("ID_COMPTE_PCE", idCompteTVA);
                        GenerationMvtTicketCaisse.this.mEcritures.put("DEBIT", 0L);
                        GenerationMvtTicketCaisse.this.mEcritures.put("CREDIT", prixTVA.getLongValue() - allTaxe);
                        GenerationMvtTicketCaisse.this.ajoutEcriture();
                    }
                }
                if ((idCompteClient = clientRow.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                    try {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                GenerationMvtTicketCaisse.this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
                GenerationMvtTicketCaisse.this.mEcritures.put("DEBIT", prixTTC.getLongValue());
                GenerationMvtTicketCaisse.this.mEcritures.put("CREDIT", 0L);
                GenerationMvtTicketCaisse.this.ajoutEcriture();
                return GenerationMvtTicketCaisse.this.idMvt;
            }
        };
        return c;
    }
}

