/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.component.ReferenceArticleSQLComponent;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTablePanel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.utils.ExceptionHandler;

public class ArticleTarifTable
extends RowValuesTablePanel {
    private SQLTableElement tarif;
    private SQLTable article = Configuration.getInstance().getBase().getTable("ARTICLE");
    private SQLRowValues rowValuesArticleCompile = new SQLRowValues(this.article);
    SQLTableElement tableElement_PrixMetrique1_VenteHT;
    ReferenceArticleSQLComponent comp;

    public ArticleTarifTable(ReferenceArticleSQLComponent comp) {
        this.init();
        this.uiInit();
        this.comp = comp;
    }

    public void setArticleValues(SQLRowAccessor articleAccessor) {
        this.rowValuesArticleCompile.put("VALEUR_METRIQUE_1", articleAccessor.getObject("VALEUR_METRIQUE_1"));
        this.rowValuesArticleCompile.put("VALEUR_METRIQUE_2", articleAccessor.getObject("VALEUR_METRIQUE_2"));
        this.rowValuesArticleCompile.put("VALEUR_METRIQUE_3", articleAccessor.getObject("VALEUR_METRIQUE_2"));
        this.rowValuesArticleCompile.put("PRIX_METRIQUE_VT_1", articleAccessor.getObject("PRIX_METRIQUE_VT_1"));
        this.rowValuesArticleCompile.put("PRIX_METRIQUE_VT_2", articleAccessor.getObject("PRIX_METRIQUE_VT_2"));
        this.rowValuesArticleCompile.put("PRIX_METRIQUE_VT_3", articleAccessor.getObject("PRIX_METRIQUE_VT_3"));
        this.rowValuesArticleCompile.put("ID_MODE_VENTE_ARTICLE", articleAccessor.getObject("ID_MODE_VENTE_ARTICLE"));
        this.rowValuesArticleCompile.put("ID_TAXE", articleAccessor.getObject("ID_TAXE"));
    }

    public void fireModification() {
        this.rowValuesArticleCompile.putAll(this.comp.getDetailsRowValues().getAbsolutelyAll());
        this.rowValuesArticleCompile.put("ID_TAXE", this.comp.getSelectedTaxe());
        int rows = this.getRowValuesTable().getRowCount();
        int i = 0;
        while (i < rows) {
            SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
            this.rowValuesArticleCompile.put("PRIX_METRIQUE_VT_1", rowVals.getObject("PRIX_METRIQUE_VT_1"));
            this.tableElement_PrixMetrique1_VenteHT.fireModification(rowVals);
            ++i;
        }
    }

    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        this.tarif = new SQLTableElement(e.getTable().getField("ID_TARIF"));
        this.tarif.setEditable(false);
        list.add(this.tarif);
        final DeviseCellEditor editorPVHT = new DeviseCellEditor();
        editorPVHT.setConvertToTTCEnable(true);
        this.tableElement_PrixMetrique1_VenteHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_VT_1"), Long.class, editorPVHT){

            @Override
            public TableCellRenderer getTableCellRenderer() {
                ArrayList<Integer> l = new ArrayList<Integer>();
                l.add(3);
                l.add(6);
                l.add(2);
                l.add(4);
                l.add(5);
                return new ArticleRowValuesRenderer(l);
            }
        };
        list.add(this.tableElement_PrixMetrique1_VenteHT);
        SQLTableElement tableElement_Devise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
        tableElement_Devise.setEditable(false);
        list.add(tableElement_Devise);
        SQLTableElement tableElement_TVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        list.add(tableElement_TVA);
        SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(e.getTable().getField("PV_HT"), Long.class, new DeviseCellEditor());
        tableElement_PrixVente_HT.setRenderer(new DeviseNiceTableCellRenderer());
        tableElement_PrixVente_HT.setEditable(false);
        list.add(tableElement_PrixVente_HT);
        SQLTableElement tableElement_PrixVente_TTC = new SQLTableElement(e.getTable().getField("PV_TTC"), Long.class, new DeviseCellEditor());
        tableElement_PrixVente_TTC.setRenderer(new DeviseNiceTableCellRenderer());
        tableElement_PrixVente_TTC.setEditable(false);
        list.add(tableElement_PrixVente_TTC);
        this.defaultRowVals = new SQLRowValues(this.getSQLElement().getTable());
        this.defaultRowVals.put("PRIX_METRIQUE_VT_1", 0);
        this.defaultRowVals.put("PV_HT", 0);
        this.defaultRowVals.put("PV_TTC", 0);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("ID_TARIF"), false, this.defaultRowVals);
        this.table = new RowValuesTable(this.model, null);
        this.tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                ArticleTarifTable.this.rowValuesArticleCompile.putAll(ArticleTarifTable.this.comp.getDetailsRowValues().getAbsolutelyAll());
                ArticleTarifTable.this.rowValuesArticleCompile.put("PRIX_METRIQUE_VT_1", row.getObject("PRIX_METRIQUE_VT_1"));
                Number n = (Number)ArticleTarifTable.this.rowValuesArticleCompile.getObject("ID_MODE_VENTE_ARTICLE");
                if (n.intValue() == 5 || n.intValue() <= 1) {
                    return ((Number)row.getObject("PRIX_METRIQUE_VT_1")).longValue();
                }
                long prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(ArticleTarifTable.this.rowValuesArticleCompile);
                return prixVTFromDetails;
            }
        });
        tableElement_PrixVente_HT.addModificationListener(tableElement_PrixVente_TTC);
        tableElement_PrixVente_TTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                Float resultTaux;
                ArticleTarifTable.this.rowValuesArticleCompile.putAll(ArticleTarifTable.this.comp.getDetailsRowValues().getAbsolutelyAll());
                ArticleTarifTable.this.rowValuesArticleCompile.put("PRIX_METRIQUE_VT_1", row.getObject("PRIX_METRIQUE_VT_1"));
                Number f = (Number)row.getObject("PV_HT");
                Object object = row.getObject("ID_TAXE");
                int idTaux = 1;
                if (object != null) {
                    idTaux = Integer.parseInt(object.toString());
                }
                if ((resultTaux = TaxeCache.getCache().getTauxFromId(idTaux)) == null) {
                    Integer i = TaxeCache.getCache().getFirstTaxe();
                    if (i == null) {
                        ExceptionHandler.handle("Aucune taxe d\u00e9finie!");
                        System.err.println("Aucune Taxe");
                    } else {
                        ArticleTarifTable.this.rowValuesArticleCompile.put("ID_TAXE", i);
                        resultTaux = TaxeCache.getCache().getTauxFromId(i);
                    }
                }
                PrixHT pHT = new PrixHT(f.longValue());
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                editorPVHT.setTaxe(resultTaux.floatValue());
                Long r = pHT.calculLongTTC(taux / 100.0f);
                return r;
            }
        });
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("ARTICLE_TARIF");
    }
}

