/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.tax.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public final class TaxeCache {
    private final transient Map<Integer, Float> mapTaux = new HashMap<Integer, Float>();
    private static TaxeCache instance;
    private transient Integer firstIdTaxe = null;

    private static final SQLSelect getSel() {
        DBRoot root = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete();
        SQLTable table = root.getTable("TAXE");
        SQLSelect sel = new SQLSelect(table.getBase());
        sel.addSelect(table.getField("ID_TAXE"));
        sel.addSelect(table.getField("TAUX"));
        return sel;
    }

    private TaxeCache() {
        SQLSelect sel = TaxeCache.getSel();
        String req = sel.asString();
        sel.getSelectFields().get(0).getDBSystemRoot().getDataSource().execute(req, new ResultSetHandler(){

            @Override
            public Object handle(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    int idTaxe = resultSet.getInt(1);
                    Float resultTaux = Float.valueOf(resultSet.getFloat(2));
                    TaxeCache.this.mapTaux.put(idTaxe, resultTaux);
                }
                return null;
            }
        });
    }

    public static synchronized TaxeCache getCache() {
        if (instance == null) {
            instance = new TaxeCache();
        }
        return instance;
    }

    public Float getTauxFromId(int idTaux) {
        return this.mapTaux.get(idTaux);
    }

    public Integer getFirstTaxe() {
        if (this.firstIdTaxe == null) {
            SQLBase table = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
            SQLSelect sel = TaxeCache.getSel();
            String req = sel.asString();
            List list = (List)table.getDataSource().execute(req, new ArrayListHandler());
            if (list != null && !list.isEmpty()) {
                Object[] tmp = (Object[])list.get(0);
                this.firstIdTaxe = Integer.parseInt(tmp[0].toString());
            }
        }
        return this.firstIdTaxe;
    }

    public Integer getIdFromTaux(Float tax) {
        Set<Integer> s = this.mapTaux.keySet();
        for (Integer integer : s) {
            if (!this.mapTaux.get(integer).equals(tax)) continue;
            return integer;
        }
        return null;
    }
}

