/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.model.PlanComptableGModel;
import org.openconcerto.erp.core.finance.accounting.ui.PlanComptableCellRenderer;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JMultiLineToolTip;
import org.openconcerto.ui.TitledSeparator;

public class PlanComptableGPanel
extends JPanel {
    private Vector classeComptes = new Vector();
    private JTabbedPane tabbedClasse = new JTabbedPane();
    private Vector tables = new Vector();
    private JRadioButton radioCompteBase = new JRadioButton("Base");
    private JRadioButton radioCompteAbrege = new JRadioButton("Abr\u00e9g\u00e9");
    private JRadioButton radioCompteDeveloppe = new JRadioButton("D\u00e9velopp\u00e9");
    private JTextArea textInfos = new JTextArea();
    private JPanel panelCompte = new JPanel();
    private JPanel panelInfosCompte = new JPanel();
    private JPanel panelDetails = new JPanel();
    private Vector actionClickDroit;

    public PlanComptableGPanel() {
        this.actionClickDroit = null;
        this.uiInit();
    }

    public PlanComptableGPanel(Vector actionClickDroit) {
        this.actionClickDroit = actionClickDroit;
        this.uiInit();
    }

    private void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.setOpaque(false);
        this.panelCompte.setOpaque(false);
        this.panelInfosCompte.setOpaque(false);
        this.panelDetails.setOpaque(false);
        this.panelCompte.setLayout(new GridBagLayout());
        this.panelInfosCompte.setLayout(new GridBagLayout());
        this.panelDetails.setLayout(new GridBagLayout());
        this.panelDetails.add((Component)this.radioCompteBase, c);
        this.radioCompteBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanComptableGPanel.this.updateCompteTable();
            }
        });
        ++c.gridy;
        this.panelDetails.add((Component)this.radioCompteAbrege, c);
        this.radioCompteAbrege.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanComptableGPanel.this.updateCompteTable();
            }
        });
        ++c.gridy;
        this.panelDetails.add((Component)this.radioCompteDeveloppe, c);
        this.radioCompteDeveloppe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanComptableGPanel.this.updateCompteTable();
            }
        });
        ButtonGroup grp1 = new ButtonGroup();
        grp1.add(this.radioCompteBase);
        grp1.add(this.radioCompteAbrege);
        grp1.add(this.radioCompteDeveloppe);
        this.radioCompteBase.setSelected(true);
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 2;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelDetails.setBorder(BorderFactory.createTitledBorder("D\u00e9tails"));
        this.panelCompte.add((Component)this.panelDetails, c);
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable classeCompteTable = base.getTable("CLASSE_COMPTE");
        SQLSelect selClasse = new SQLSelect(base);
        selClasse.addSelect(classeCompteTable.getField("ID"));
        selClasse.addSelect(classeCompteTable.getField("NOM"));
        selClasse.addSelect(classeCompteTable.getField("TYPE_NUMERO_COMPTE"));
        selClasse.addRawOrder("\"CLASSE_COMPTE\".\"TYPE_NUMERO_COMPTE\"");
        String reqClasse = selClasse.asString();
        Object obClasse = base.getDataSource().execute(reqClasse, new ArrayListHandler());
        List myListClasse = (List)obClasse;
        if (myListClasse.size() != 0) {
            int k = 0;
            while (k < myListClasse.size()) {
                Object[] objTmp = (Object[])myListClasse.get(k);
                ClasseCompte ccTmp = new ClasseCompte(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString(), objTmp[2].toString());
                this.classeComptes.add(ccTmp);
                JTable tab = this.creerJTable(ccTmp);
                this.tables.add(tab);
                this.tabbedClasse.add(ccTmp.getNom(), new JScrollPane(tab));
                ++k;
            }
        }
        c.gridwidth = 4;
        c.gridheight = 6;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridx;
        c.gridy = 0;
        this.panelCompte.add((Component)this.tabbedClasse, c);
        c.gridwidth = 0;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        TitledSeparator sep = new TitledSeparator("Informations sur le compte");
        this.panelInfosCompte.add((Component)sep, c);
        GridBagConstraints cInfos = new GridBagConstraints();
        cInfos.insets = new Insets(0, 0, 0, 0);
        cInfos.fill = 1;
        cInfos.anchor = 18;
        cInfos.gridx = 0;
        cInfos.gridy = 0;
        cInfos.gridwidth = 1;
        cInfos.gridheight = 1;
        cInfos.weightx = 1.0;
        cInfos.weighty = 1.0;
        this.textInfos.setFont(this.getFont());
        this.textInfos.setEditable(false);
        JPanel infos = new JPanel(new GridBagLayout());
        infos.add((Component)this.textInfos, cInfos);
        JScrollPane scrollInfos = new JScrollPane(infos);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 0;
        this.panelInfosCompte.add((Component)scrollInfos, c);
        this.panelInfosCompte.setMinimumSize(new Dimension(100, 80));
        JSplitPane split = new JSplitPane(0, this.panelCompte, this.panelInfosCompte);
        split.setBorder(null);
        this.add((Component)split, c);
    }

    public JTable creerJTable(ClasseCompte ccTmp) {
        final PlanComptableGModel model = this.radioCompteDeveloppe.isSelected() ? new PlanComptableGModel(ccTmp, 3) : (this.radioCompteAbrege.isSelected() ? new PlanComptableGModel(ccTmp, 2) : new PlanComptableGModel(ccTmp, 1));
        final JTable table = new JTable(model){

            @Override
            public JToolTip createToolTip() {
                JMultiLineToolTip t = new JMultiLineToolTip();
                t.setFixedWidth(500);
                return t;
            }
        };
        table.getColumnModel().getColumn(0).setCellRenderer(new PlanComptableCellRenderer(0));
        table.getColumnModel().getColumn(1).setCellRenderer(new PlanComptableCellRenderer(0));
        table.getColumnModel().getColumn(0).setMaxWidth(90);
        table.getTableHeader().setReorderingAllowed(false);
        table.addMouseMotionListener(new MouseMotionAdapter(){
            int lastRow = -1;

            @Override
            public void mouseMoved(MouseEvent e) {
                final Point p = new Point(e.getX(), e.getY());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int row = table.rowAtPoint(p);
                        if (lastRow != row) {
                            lastRow = row;
                            String strTmp = model.getComptes().get(lastRow).getInfos();
                            if (strTmp.length() != 0) {
                                table.setToolTipText(strTmp);
                            } else {
                                table.setToolTipText(null);
                            }
                        }
                    }
                });
            }
        });
        if (this.actionClickDroit != null) {
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        PlanComptableGPanel.this.actionDroitTable(e, table);
                    }
                }
            });
        }
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = table.getSelectedRow();
                if (selectedRow < 0) {
                    PlanComptableGPanel.this.textInfos.setText("Pas de compte s\u00e9l\u00e9ctionn\u00e9");
                } else {
                    PlanComptableGPanel.this.textInfos.setText(model.getComptes().get(selectedRow).getInfos());
                }
            }
        });
        return table;
    }

    private void actionDroitTable(MouseEvent e, final JTable table) {
        JPopupMenu menuDroit = new JPopupMenu();
        int i = 0;
        while (i < this.actionClickDroit.size()) {
            menuDroit.add((AbstractAction)this.actionClickDroit.get(i));
            ++i;
        }
        menuDroit.add(new AbstractAction("Tout s\u00e9lectionner"){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.selectAll();
            }
        });
        menuDroit.show(e.getComponent(), e.getX(), e.getY());
        System.out.println("Click droit sur JTable");
    }

    public int getSelectedIndex() {
        return this.tabbedClasse.getSelectedIndex();
    }

    public Vector getTables() {
        return this.tables;
    }

    private void updateCompteTable() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < PlanComptableGPanel.this.tabbedClasse.getTabCount()) {
                    final JTable tab = PlanComptableGPanel.this.creerJTable((ClasseCompte)PlanComptableGPanel.this.classeComptes.get(i));
                    final int indexTab = i++;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlanComptableGPanel.this.tables.set(indexTab, tab);
                            PlanComptableGPanel.this.tabbedClasse.setComponentAt(indexTab, new JScrollPane(tab));
                        }
                    });
                }
            }
        }).start();
    }
}

