/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;

public class ListPanelEcritures
extends ListeAddPanel {
    public ListPanelEcritures() {
        this(Configuration.getInstance().getDirectory().getElement("ECRITURE"), (Where)null);
    }

    public ListPanelEcritures(SQLElement element, Where w) {
        this(element, new IListe(element.createTableSource(w)));
    }

    public ListPanelEcritures(SQLElement element, IListe l) {
        super(element, l);
        this.buttonAjouter.setVisible(false);
        this.getListe().setSQLEditable(false);
        this.getListe().addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                System.out.println("Selection Changed");
                SQLRow row = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("ECRITURE").getRow(id);
                if (row != null) {
                    ListPanelEcritures.this.setButtonEnabled(row.getBoolean("VALIDE") == false);
                }
            }
        });
        if (!UserManager.getInstance().getCurrentUser().getRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            this.getListe().getRequest().setWhere(new Where((FieldRef)this.getElement().getTable().getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        }
        this.getListe().getSelectedId();
    }

    @Override
    protected void handleAction(JButton source, ActionEvent e) {
        if (source == this.buttonModifier) {
            SQLRow ecritureRow = new EcritureSQLElement().getTable().getRow(this.getListe().getSelectedId());
            MouvementSQLElement.showSource(ecritureRow.getInt("ID_MOUVEMENT"));
        } else {
            super.handleAction(source, e);
        }
    }

    private void setButtonEnabled(boolean b) {
        this.buttonAjouter.setEnabled(b);
        this.buttonModifier.setEnabled(b);
        this.buttonEffacer.setEnabled(b);
    }
}

