/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.TcpServer;
import org.h2.util.Tool;

public class Server
extends Tool
implements Runnable {
    private Service service;

    public Server() {
    }

    public Server(Service service, String ... stringArray) throws SQLException {
        this.service = service;
        try {
            service.init(stringArray);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public static Server createTcpServer(String ... stringArray) throws SQLException {
        return new Server(new TcpServer(), stringArray);
    }

    public Server start() throws SQLException {
        try {
            this.service.start();
            Thread thread = new Thread(this);
            thread.setDaemon(this.service.isDaemon());
            String string = this.service.getName() + " (" + this.service.getURL() + ")";
            thread.setName(string);
            thread.start();
            for (int i = 1; i < 64; i += i) {
                Server.wait(i);
                if (!this.isRunning(false)) continue;
                return this;
            }
            if (this.isRunning(true)) {
                return this;
            }
            throw DbException.get(90061, string, "timeout");
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private static void wait(int n) {
        try {
            long l = (long)n * (long)n;
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isRunning(boolean bl) {
        return this.service.isRunning(bl);
    }

    public void stop() {
        this.service.stop();
    }

    public int getPort() {
        return this.service.getPort();
    }

    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
        }
    }
}

