/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.change;

import java.util.Collection;
import org.openconcerto.utils.change.CollectionChangeEvent;

public abstract class CollectionChangeEventCreator {
    private final Object src;
    private final String propName;
    private final Collection oldVal;

    protected CollectionChangeEventCreator(Object src, String propName, Collection oldVal) {
        if (oldVal == null) {
            throw new NullPointerException();
        }
        this.src = src;
        this.propName = propName;
        this.oldVal = this.clone(oldVal);
        if (this.oldVal == oldVal) {
            throw new IllegalStateException("oldVal has not been cloned : " + oldVal + " == " + this.oldVal);
        }
        if (!this.oldVal.equals(oldVal)) {
            throw new IllegalStateException("clones are not equal : " + oldVal + " != " + this.oldVal);
        }
    }

    protected abstract Collection clone(Collection var1);

    public CollectionChangeEvent create(Collection newVal) {
        return new CollectionChangeEvent(this.src, this.propName, this.oldVal, this.clone(newVal));
    }

    public final String getName() {
        return this.propName;
    }
}

