/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openconcerto.ui.EnhancedTableColumn;
import org.openconcerto.ui.EnhancedTableUI;

public class EnhancedTable
extends JTable {
    private boolean blockRepaint = false;
    protected HashMap<Integer, Integer> rowHeights = new HashMap();
    private HashMap<Long, Integer> prefferedRowHeights = new HashMap();

    public EnhancedTable() {
        this(null, null, null);
    }

    public EnhancedTable(TableModel dm) {
        this(dm, null, null);
    }

    public EnhancedTable(TableModel dm, TableColumnModel cm) {
        this(dm, cm, null);
    }

    public EnhancedTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initUI();
    }

    public EnhancedTable(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public EnhancedTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initUI();
    }

    public EnhancedTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initUI();
    }

    @Override
    protected void initializeLocalVars() {
        this.setBlockRepaint(true);
        super.initializeLocalVars();
        this.setBlockRepaint(false);
    }

    @Override
    public void setUI(TableUI ui) {
        this.setBlockRepaint(true);
        super.setUI(ui);
        this.setBlockRepaint(false);
    }

    private void initUI() {
        this.setUI(new EnhancedTableUI());
        this.setIntercellSpacing(new Dimension(1, 1));
    }

    @Override
    public int rowAtPoint(Point point) {
        int y = point.y;
        if (y < 0) {
            return -1;
        }
        int rowSpacing = 0;
        int rowCount = this.getRowCount();
        int aRowHeight = 0;
        int i = 0;
        while (i < rowCount) {
            if (y < (aRowHeight += this.getRowHeight(i) + rowSpacing)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        int i;
        Rectangle r = new Rectangle();
        boolean valid = true;
        if (row < 0) {
            valid = false;
        } else {
            r.height = this.getRowHeight(row);
            int y = 0;
            i = 0;
            while (i < row) {
                y += this.getRowHeight(i);
                ++i;
            }
            r.y = y;
        }
        if (column < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else if (column >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else {
            TableColumnModel cm = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                i = 0;
                while (i < column) {
                    r.x += cm.getColumn(i).getWidth();
                    ++i;
                }
            } else {
                i = cm.getColumnCount() - 1;
                while (i > column) {
                    r.x += cm.getColumn(i).getWidth();
                    --i;
                }
            }
            r.width = cm.getColumn(column).getWidth();
        }
        if (valid && !includeSpacing) {
            int rm = this.getRowMargin();
            int cm = this.getColumnModel().getColumnMargin();
            r.setBounds(r.x + cm / 2, r.y + rm / 2, r.width - cm, r.height - rm);
        }
        return r;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e == null || e.getFirstRow() == -1) {
            this.clearSelection();
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
            }
        } else if (e.getType() == 1) {
            this.tableRowsInserted(e);
        } else if (e.getType() == -1) {
            this.tableRowsDeleted(e);
        }
        this.resizeAndRepaint();
    }

    private void tableRowsInserted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int rowCount = this.getRowCount();
        int rowsInserted = end - start + 1;
        int r = start;
        while (r < rowCount) {
            Integer height = this.rowHeights.get(r);
            if (height != null) {
                this.rowHeights.put(r + rowsInserted, height);
            }
            ++r;
        }
        Rectangle drawRect = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        drawRect.height = this.getCellRect((int)rowCount, (int)0, (boolean)false).y - drawRect.y;
        if (this.selectionModel != null) {
            if (end < 0) {
                end = this.getRowCount() - 1;
            }
            int length = end - start + 1;
            this.selectionModel.insertIndexInterval(start, length, true);
        }
        this.revalidate();
        this.repaint(drawRect);
    }

    private void tableRowsDeleted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int deletedCount = end - start + 1;
        int previousRowCount = this.getRowCount() + deletedCount;
        int i = start;
        while (i <= end) {
            this.resetRowHeight(i);
            ++i;
        }
        int r = end + 1;
        while (r < previousRowCount) {
            Integer height = this.rowHeights.get(r);
            if (height != null) {
                this.rowHeights.put(r - deletedCount, height);
            }
            ++r;
        }
        Rectangle drawRect = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        drawRect.height = this.getCellRect((int)previousRowCount, (int)0, (boolean)false).y - drawRect.y;
        if (this.selectionModel != null) {
            if (end < 0) {
                end = this.getRowCount() - 1;
            }
            if (end < 0) {
                end = 0;
            }
            if (start < 0) {
                start = 0;
            }
            this.selectionModel.removeIndexInterval(start, end);
        }
        this.revalidate();
    }

    @Override
    public int getRowHeight(int row) {
        Integer o;
        int result = 0;
        result = this.rowHeights == null ? super.getRowHeight() + 3 : ((o = this.rowHeights.get(row)) == null ? this.getRowHeight() + 3 : o);
        return result;
    }

    @Override
    public void setRowHeight(int row, int height) {
        if (this.getRowHeight(row) != height) {
            this.rowHeights.put(row, height + 3);
        }
    }

    void resetRowHeight(int row) {
        this.rowHeights.remove(row);
    }

    public void setBlockRepaint(boolean blockRepaint) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void paintComponents(Graphics g) {
        super.paintComponents(g);
        this.resizeAndRepaint();
    }

    @Override
    public void repaint() {
        if (!this.blockRepaint) {
            super.repaint();
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        super.columnMarginChanged(e);
        this.resizeAndRepaint();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            int i = 0;
            while (i < m.getColumnCount()) {
                EnhancedTableColumn newColumn = new EnhancedTableColumn(i);
                this.addColumn(newColumn);
                ++i;
            }
        }
    }

    @Override
    protected void resizeAndRepaint() {
        if (this.tableHeader != null) {
            this.tableHeader.resizeAndRepaint();
        }
        super.resizeAndRepaint();
    }

    @Override
    public boolean getShowHorizontalLines() {
        return true;
    }

    @Override
    public boolean getShowVerticalLines() {
        return true;
    }
}

