/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;

public final class DropTable
extends ChangeTable<DropTable> {
    private final SQLTable t;

    public DropTable(SQLTable t) {
        super(t.getServer().getSQLSystem().getSyntax(), t.getName());
        this.t = t;
    }

    private final AlterTable getAlterTable() {
        AlterTable alterTable = new AlterTable(this.t);
        for (Link foreignLink : this.t.getDBSystemRoot().getGraph().getForeignLinks(this.t)) {
            if (foreignLink.getName() == null) {
                throw new IllegalStateException(foreignLink + " is not a real constraint, use AddFK");
            }
            alterTable.dropForeignConstraint(foreignLink.getName());
        }
        return alterTable;
    }

    @Override
    public String asString(String rootName) {
        return this.t.getBase().quote("DROP TABLE %f ;", this.t);
    }

    @Override
    protected String asString(String rootName, ChangeTable.ConcatStep step) {
        switch (step) {
            case DROP_FOREIGN: {
                return this.getAlterTable().asString(rootName, step);
            }
            case ALTER_TABLE: {
                return this.asString(rootName);
            }
        }
        return null;
    }

    @Override
    public DropTable addColumn(String name, String definition) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getConstraintPrefix() {
        throw new UnsupportedOperationException();
    }
}

