/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.StructureSource;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;

public class XMLStructureSource
extends StructureSource<IOException> {
    public static final DateFormat XMLDATE_FMT = new SimpleDateFormat("yyyyMMdd-HHmmss.SSSZ");
    private final Map<String, Element> xmlSchemas = new HashMap<String, Element>();
    private final Set<String> schemas = new HashSet<String>();
    private final Set<SQLName> tableNames;
    private final Set<String> allSchemas = new HashSet<String>();

    public XMLStructureSource(SQLBase b, Set<String> scope) {
        super(b, scope);
        this.tableNames = new HashSet<SQLName>();
        this.setPreVerify(true);
    }

    @Override
    protected void getNames(Connection conn) throws IOException {
        this.schemas.clear();
        this.tableNames.clear();
        try {
            this.allSchemas.addAll(this.getJDBCSchemas(conn.getMetaData()));
        }
        catch (SQLException exn) {
            throw new IOException("could not get schemas", exn);
        }
        String versionPb = "";
        SAXBuilder sxb = new SAXBuilder();
        List<String> savedSchemas = this.getBase().getSavedSchemas();
        this.filterOutOfScope(savedSchemas);
        savedSchemas.retainAll(this.allSchemas);
        for (String schemaName : savedSchemas) {
            Document document;
            File schemaFile = this.getBase().getSchemaFile(schemaName);
            try {
                document = sxb.build(schemaFile);
            }
            catch (JDOMException e1) {
                throw new IOException("couldn't parse " + schemaFile, e1);
            }
            Element rootElem = document.getRootElement();
            Element schemaElem = rootElem.getChild("schema");
            String schemaNameAttr = schemaElem.getAttributeValue("name");
            if (!CompareUtils.equals(schemaName, schemaNameAttr)) {
                throw new IOException("name attr: " + schemaNameAttr + " != " + schemaName + " :file name");
            }
            String thisVersionBad = "";
            try {
                String codecVersion = rootElem.getAttributeValue("codecVersion");
                thisVersionBad = String.valueOf(thisVersionBad) + this.isVersionBad(codecVersion, "20100917-1546");
                thisVersionBad = String.valueOf(thisVersionBad) + this.isVersionBad(SQLSchema.getVersion(schemaElem), SQLSchema.getVersion(this.getBase(), schemaName));
            }
            catch (Exception e) {
                thisVersionBad = String.valueOf(thisVersionBad) + ExceptionUtils.getStackTrace(e);
            }
            thisVersionBad = thisVersionBad.trim();
            if (thisVersionBad.length() > 0) {
                schemaFile.delete();
                versionPb = String.valueOf(versionPb) + thisVersionBad;
            }
            if (!versionPb.isEmpty()) continue;
            this.xmlSchemas.put(schemaName, schemaElem);
            this.schemas.add(schemaName);
            List l = schemaElem.getChildren("table");
            int i = 0;
            while (i < l.size()) {
                Element elementTable = (Element)l.get(i);
                this.tableNames.add(new SQLName(schemaName, elementTable.getAttributeValue("name")));
                ++i;
            }
        }
        if (versionPb.length() > 0) {
            throw new IllegalStateException("files with wrong versions: " + versionPb);
        }
    }

    private String isVersionBad(String xmlVersion, String actualVersion) {
        if (xmlVersion == null || !xmlVersion.equals(actualVersion)) {
            return "version mismatch " + xmlVersion + " != " + actualVersion + '\n';
        }
        return "";
    }

    @Override
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    public Set<SQLName> getTablesNames() {
        return this.tableNames;
    }

    @Override
    protected void fillTables(Set<String> newSchemas) {
        for (String schemaName : newSchemas) {
            Element schemaElem = this.xmlSchemas.get(schemaName);
            this.getNewSchema(schemaName).load(schemaElem);
        }
    }

    @Override
    public void save() {
    }
}

